// chrome/browser/ui/webui/omnibox_popup/mojom/omnibox_popup_aim.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  SearchContextSpec as searchbox_mojom_SearchContextSpec,
  SearchContext as searchbox_mojom_SearchContext
} from '//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';







export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'omnibox_popup_aim.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "omnibox_popup_aim.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'omnibox_popup_aim.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  requestClose(): void;
  navigateCurrentTab(url: url_mojom_Url): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  requestClose(): void {
    this.proxy.sendMessage(
        0,
        PageHandler_RequestClose_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  navigateCurrentTab(
      url: url_mojom_Url): void {
    this.proxy.sendMessage(
        1,
        PageHandler_NavigateCurrentTab_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_RequestClose_ParamsSpec.$,
        null,
        impl.requestClose.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_NavigateCurrentTab_ParamsSpec.$,
        null,
        impl.navigateCurrentTab.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "omnibox_popup_aim.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  requestClose: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  navigateCurrentTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.requestClose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_RequestClose_ParamsSpec.$,
        null,
        this.requestClose.createReceiverHandler(false /* expectsResponse */),
        false);
    this.navigateCurrentTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_NavigateCurrentTab_ParamsSpec.$,
        null,
        this.navigateCurrentTab.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'omnibox_popup_aim.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  onPopupShown(context: searchbox_mojom_SearchContext): void;
  addContext(context: searchbox_mojom_SearchContext): void;
  onPopupHidden(): Promise<{
        input: string, }>;
  setPreserveContextOnClose(preserveContextOnClose: boolean): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onPopupShown(
      context: searchbox_mojom_SearchContext): void {
    this.proxy.sendMessage(
        0,
        Page_OnPopupShown_ParamsSpec.$,
        null,
        [
          context
        ],
        false);
  }

  addContext(
      context: searchbox_mojom_SearchContext): void {
    this.proxy.sendMessage(
        1,
        Page_AddContext_ParamsSpec.$,
        null,
        [
          context
        ],
        false);
  }

  onPopupHidden(): Promise<{
        input: string, }> {
    return this.proxy.sendMessage(
        2,
        Page_OnPopupHidden_ParamsSpec.$,
        Page_OnPopupHidden_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  setPreserveContextOnClose(
      preserveContextOnClose: boolean): void {
    this.proxy.sendMessage(
        3,
        Page_SetPreserveContextOnClose_ParamsSpec.$,
        null,
        [
          preserveContextOnClose
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_OnPopupShown_ParamsSpec.$,
        null,
        impl.onPopupShown.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_AddContext_ParamsSpec.$,
        null,
        impl.addContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_OnPopupHidden_ParamsSpec.$,
        Page_OnPopupHidden_ResponseParamsSpec.$,
        impl.onPopupHidden.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Page_SetPreserveContextOnClose_ParamsSpec.$,
        null,
        impl.setPreserveContextOnClose.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "omnibox_popup_aim.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onPopupShown: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  addContext: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onPopupHidden: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setPreserveContextOnClose: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onPopupShown =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_OnPopupShown_ParamsSpec.$,
        null,
        this.onPopupShown.createReceiverHandler(false /* expectsResponse */),
        false);
    this.addContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_AddContext_ParamsSpec.$,
        null,
        this.addContext.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onPopupHidden =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_OnPopupHidden_ParamsSpec.$,
        Page_OnPopupHidden_ResponseParamsSpec.$,
        this.onPopupHidden.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setPreserveContextOnClose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Page_SetPreserveContextOnClose_ParamsSpec.$,
        null,
        this.setPreserveContextOnClose.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RequestClose_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_NavigateCurrentTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnPopupShown_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_AddContext_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnPopupHidden_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnPopupHidden_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SetPreserveContextOnClose_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RequestClose_ParamsMojoType {
}


export type PageHandler_RequestClose_Params = PageHandler_RequestClose_ParamsMojoType;
mojo.internal.Struct<PageHandler_RequestClose_ParamsMojoType>(
    PageHandler_RequestClose_ParamsSpec.$,
    'PageHandler_RequestClose_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_NavigateCurrentTab_ParamsMojoType {
  url: url_mojom_Url;
}


export type PageHandler_NavigateCurrentTab_Params = PageHandler_NavigateCurrentTab_ParamsMojoType;
mojo.internal.Struct<PageHandler_NavigateCurrentTab_ParamsMojoType>(
    PageHandler_NavigateCurrentTab_ParamsSpec.$,
    'PageHandler_NavigateCurrentTab_Params',
    [
      mojo.internal.StructField<PageHandler_NavigateCurrentTab_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnPopupShown_ParamsMojoType {
  context: searchbox_mojom_SearchContext;
}


export type Page_OnPopupShown_Params = Page_OnPopupShown_ParamsMojoType;
mojo.internal.Struct<Page_OnPopupShown_ParamsMojoType>(
    Page_OnPopupShown_ParamsSpec.$,
    'Page_OnPopupShown_Params',
    [
      mojo.internal.StructField<Page_OnPopupShown_ParamsMojoType, searchbox_mojom_SearchContext>(
        'context', 0,
        0,
        searchbox_mojom_SearchContextSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_AddContext_ParamsMojoType {
  context: searchbox_mojom_SearchContext;
}


export type Page_AddContext_Params = Page_AddContext_ParamsMojoType;
mojo.internal.Struct<Page_AddContext_ParamsMojoType>(
    Page_AddContext_ParamsSpec.$,
    'Page_AddContext_Params',
    [
      mojo.internal.StructField<Page_AddContext_ParamsMojoType, searchbox_mojom_SearchContext>(
        'context', 0,
        0,
        searchbox_mojom_SearchContextSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnPopupHidden_ParamsMojoType {
}


export type Page_OnPopupHidden_Params = Page_OnPopupHidden_ParamsMojoType;
mojo.internal.Struct<Page_OnPopupHidden_ParamsMojoType>(
    Page_OnPopupHidden_ParamsSpec.$,
    'Page_OnPopupHidden_Params',
    [
    ],
    [[0, 8],]);





export interface Page_OnPopupHidden_ResponseParamsMojoType {
  input: string;
}


export type Page_OnPopupHidden_ResponseParams = Page_OnPopupHidden_ResponseParamsMojoType;
mojo.internal.Struct<Page_OnPopupHidden_ResponseParamsMojoType>(
    Page_OnPopupHidden_ResponseParamsSpec.$,
    'Page_OnPopupHidden_ResponseParams',
    [
      mojo.internal.StructField<Page_OnPopupHidden_ResponseParamsMojoType, string>(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_SetPreserveContextOnClose_ParamsMojoType {
  preserveContextOnClose: boolean;
}


export type Page_SetPreserveContextOnClose_Params = Page_SetPreserveContextOnClose_ParamsMojoType;
mojo.internal.Struct<Page_SetPreserveContextOnClose_ParamsMojoType>(
    Page_SetPreserveContextOnClose_ParamsSpec.$,
    'Page_SetPreserveContextOnClose_Params',
    [
      mojo.internal.StructField<Page_SetPreserveContextOnClose_ParamsMojoType, boolean>(
        'preserveContextOnClose', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



