// Copyright 2011 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{css,CrLitElement,html,nothing}from"chrome://resources/lit/v3_0/lit.rollup.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{mojo}from"chrome://resources/mojo/mojo/public/js/bindings.js";import{String16Spec}from"chrome://resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js";import{TimeTicksSpec,JSTimeSpec,TimeDeltaSpec}from"chrome://resources/mojo/mojo/public/mojom/base/time.mojom-webui.js";import{UrlSpec}from"chrome://resources/mojo/url/mojom/url.mojom-webui.js";import{html as html$1}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import"chrome://omnibox-popup.top-chrome/strings.m.js";import{PageCallbackRouter as PageCallbackRouter$3,PageHandler as PageHandler$1}from"chrome://resources/cr_components/color_change_listener/color_change_listener.mojom-webui.js";import{addWebUiListener,removeWebUiListener}from"chrome://resources/js/cr.js";const CLASS_NAME="focus-outline-visible";const docsToManager=new Map;class FocusOutlineManager{focusByKeyboard_=true;classList_;constructor(doc){this.classList_=doc.documentElement.classList;doc.addEventListener("keydown",(e=>this.onEvent_(true,e)),true);doc.addEventListener("mousedown",(e=>this.onEvent_(false,e)),true);this.updateVisibility()}onEvent_(focusByKeyboard,e){if(this.focusByKeyboard_===focusByKeyboard){return}if(e instanceof KeyboardEvent&&e.repeat){return}this.focusByKeyboard_=focusByKeyboard;this.updateVisibility()}updateVisibility(){this.visible=this.focusByKeyboard_}set visible(visible){this.classList_.toggle(CLASS_NAME,visible)}get visible(){return this.classList_.contains(CLASS_NAME)}static forDocument(doc){let manager=docsToManager.get(doc);if(!manager){manager=new FocusOutlineManager(doc);docsToManager.set(doc,manager)}return manager}}function assert(value,message){if(value){return}throw new Error("Assertion failed"+(message?`: ${message}`:""))}function assertInstanceof(value,type,message){if(value instanceof type){return}throw new Error(`Value ${value} is not of type ${type.name||typeof type}`)}function assertNotReached(message="Unreachable code hit"){assert(false,message)}class EventTracker{listeners_=[];add(target,eventType,listener,capture=false){const h={target:target,eventType:eventType,listener:listener,capture:capture};this.listeners_.push(h);target.addEventListener(eventType,listener,capture)}remove(target,eventType){this.listeners_=this.listeners_.filter((listener=>{if(listener.target===target&&(!eventType||listener.eventType===eventType)){EventTracker.removeEventListener(listener);return false}return true}))}removeAll(){this.listeners_.forEach((listener=>EventTracker.removeEventListener(listener)));this.listeners_=[]}static removeEventListener(entry){entry.target.removeEventListener(entry.eventType,entry.listener,entry.capture)}}let instance$H=null;function getCss$A(){return instance$H||(instance$H=[...[],css`:host{bottom:0;display:block;left:0;overflow:hidden;pointer-events:none;position:absolute;right:0;top:0;transform:translate3d(0,0,0)}.ripple{background-color:currentcolor;left:0;opacity:var(--paper-ripple-opacity,0.25);pointer-events:none;position:absolute;will-change:height,transform,width}.ripple,:host(.circle){border-radius:50%}`])}class CrRippleElement extends CrLitElement{static get is(){return"cr-ripple"}static get styles(){return getCss$A()}static get properties(){return{holdDown:{type:Boolean},recenters:{type:Boolean},noink:{type:Boolean}}}#holdDown_accessor_storage=false;get holdDown(){return this.#holdDown_accessor_storage}set holdDown(value){this.#holdDown_accessor_storage=value}#recenters_accessor_storage=false;get recenters(){return this.#recenters_accessor_storage}set recenters(value){this.#recenters_accessor_storage=value}#noink_accessor_storage=false;get noink(){return this.#noink_accessor_storage}set noink(value){this.#noink_accessor_storage=value}ripples_=[];eventTracker_=new EventTracker;connectedCallback(){super.connectedCallback();assert(this.parentNode);const keyEventTarget=this.parentNode.nodeType===Node.DOCUMENT_FRAGMENT_NODE?this.parentNode.host:this.parentElement;this.eventTracker_.add(keyEventTarget,"pointerdown",(e=>this.uiDownAction(e)));this.eventTracker_.add(keyEventTarget,"pointerup",(()=>this.uiUpAction()));this.eventTracker_.add(keyEventTarget,"pointerout",(()=>this.uiUpAction()));this.eventTracker_.add(keyEventTarget,"keydown",(e=>{if(e.defaultPrevented){return}if(e.key==="Enter"){this.onEnterKeydown_();return}if(e.key===" "){this.onSpaceKeydown_()}}));this.eventTracker_.add(keyEventTarget,"keyup",(e=>{if(e.defaultPrevented){return}if(e.key===" "){this.onSpaceKeyup_()}}))}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("holdDown")){this.holdDownChanged_(this.holdDown,changedProperties.get("holdDown"))}}uiDownAction(e){if(e!==undefined&&e.button!==0){return}if(!this.noink){this.downAction_(e)}}downAction_(e){if(this.ripples_.length&&this.holdDown){return}this.showRipple_(e)}clear(){this.hideRipple_();this.holdDown=false}showAndHoldDown(){this.ripples_.forEach((ripple=>{ripple.remove()}));this.ripples_=[];this.holdDown=true}showRipple_(e){return}uiUpAction(){if(!this.noink){this.upAction_()}}upAction_(){if(!this.holdDown){this.hideRipple_()}}hideRipple_(){if(this.ripples_.length===0){return}this.ripples_.forEach((function(ripple){const opacity=ripple.computedStyleMap().get("opacity");if(opacity===null){ripple.remove();return}const animation=ripple.animate({opacity:[opacity.value,0]},{duration:150,fill:"forwards"});animation.finished.then((()=>{ripple.remove()}))}));this.ripples_=[]}onEnterKeydown_(){this.uiDownAction();window.setTimeout((()=>{this.uiUpAction()}),1)}onSpaceKeydown_(){this.uiDownAction()}onSpaceKeyup_(){this.uiUpAction()}holdDownChanged_(newHoldDown,oldHoldDown){if(oldHoldDown===undefined){return}if(newHoldDown){this.downAction_()}else{this.upAction_()}}}customElements.define(CrRippleElement.is,CrRippleElement);const CrRippleMixin=superClass=>{class CrRippleMixin extends superClass{static get properties(){return{noink:{type:Boolean}}}#noink_accessor_storage=false;get noink(){return this.#noink_accessor_storage}set noink(value){this.#noink_accessor_storage=value}rippleContainer=null;ripple_=null;updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("noink")&&this.hasRipple()){assert(this.ripple_);this.ripple_.noink=this.noink}}ensureRippleOnPointerdown(){this.addEventListener("pointerdown",(()=>this.ensureRipple()),{capture:true})}ensureRipple(){if(this.hasRipple()){return}this.ripple_=this.createRipple();this.ripple_.noink=this.noink;const rippleContainer=this.rippleContainer||this.shadowRoot;assert(rippleContainer);rippleContainer.appendChild(this.ripple_)}getRipple(){this.ensureRipple();assert(this.ripple_);return this.ripple_}hasRipple(){return Boolean(this.ripple_)}createRipple(){const ripple=document.createElement("cr-ripple");ripple.id="ink";return ripple}}return CrRippleMixin};let instance$G=null;function getCss$z(){return instance$G||(instance$G=[...[],css`[hidden],:host([hidden]){display:none !important}`])}const sheet=new CSSStyleSheet;sheet.replaceSync(`html{--google-blue-50-rgb:232,240,254;--google-blue-50:rgb(var(--google-blue-50-rgb));--google-blue-100-rgb:210,227,252;--google-blue-100:rgb(var(--google-blue-100-rgb));--google-blue-200-rgb:174,203,250;--google-blue-200:rgb(var(--google-blue-200-rgb));--google-blue-300-rgb:138,180,248;--google-blue-300:rgb(var(--google-blue-300-rgb));--google-blue-400-rgb:102,157,246;--google-blue-400:rgb(var(--google-blue-400-rgb));--google-blue-500-rgb:66,133,244;--google-blue-500:rgb(var(--google-blue-500-rgb));--google-blue-600-rgb:26,115,232;--google-blue-600:rgb(var(--google-blue-600-rgb));--google-blue-700-rgb:25,103,210;--google-blue-700:rgb(var(--google-blue-700-rgb));--google-blue-800-rgb:24,90,188;--google-blue-800:rgb(var(--google-blue-800-rgb));--google-blue-900-rgb:23,78,166;--google-blue-900:rgb(var(--google-blue-900-rgb));--google-green-50-rgb:230,244,234;--google-green-50:rgb(var(--google-green-50-rgb));--google-green-200-rgb:168,218,181;--google-green-200:rgb(var(--google-green-200-rgb));--google-green-300-rgb:129,201,149;--google-green-300:rgb(var(--google-green-300-rgb));--google-green-400-rgb:91,185,116;--google-green-400:rgb(var(--google-green-400-rgb));--google-green-500-rgb:52,168,83;--google-green-500:rgb(var(--google-green-500-rgb));--google-green-600-rgb:30,142,62;--google-green-600:rgb(var(--google-green-600-rgb));--google-green-700-rgb:24,128,56;--google-green-700:rgb(var(--google-green-700-rgb));--google-green-800-rgb:19,115,51;--google-green-800:rgb(var(--google-green-800-rgb));--google-green-900-rgb:13,101,45;--google-green-900:rgb(var(--google-green-900-rgb));--google-grey-50-rgb:248,249,250;--google-grey-50:rgb(var(--google-grey-50-rgb));--google-grey-100-rgb:241,243,244;--google-grey-100:rgb(var(--google-grey-100-rgb));--google-grey-200-rgb:232,234,237;--google-grey-200:rgb(var(--google-grey-200-rgb));--google-grey-300-rgb:218,220,224;--google-grey-300:rgb(var(--google-grey-300-rgb));--google-grey-400-rgb:189,193,198;--google-grey-400:rgb(var(--google-grey-400-rgb));--google-grey-500-rgb:154,160,166;--google-grey-500:rgb(var(--google-grey-500-rgb));--google-grey-600-rgb:128,134,139;--google-grey-600:rgb(var(--google-grey-600-rgb));--google-grey-700-rgb:95,99,104;--google-grey-700:rgb(var(--google-grey-700-rgb));--google-grey-800-rgb:60,64,67;--google-grey-800:rgb(var(--google-grey-800-rgb));--google-grey-900-rgb:32,33,36;--google-grey-900:rgb(var(--google-grey-900-rgb));--google-grey-900-white-4-percent:#292a2d;--google-purple-200-rgb:215,174,251;--google-purple-200:rgb(var(--google-purple-200-rgb));--google-purple-900-rgb:104,29,168;--google-purple-900:rgb(var(--google-purple-900-rgb));--google-red-100-rgb:244,199,195;--google-red-100:rgb(var(--google-red-100-rgb));--google-red-300-rgb:242,139,130;--google-red-300:rgb(var(--google-red-300-rgb));--google-red-500-rgb:234,67,53;--google-red-500:rgb(var(--google-red-500-rgb));--google-red-600-rgb:217,48,37;--google-red-600:rgb(var(--google-red-600-rgb));--google-red-700-rgb:197,57,41;--google-red-700:rgb(var(--google-red-700-rgb));--google-yellow-50-rgb:254,247,224;--google-yellow-50:rgb(var(--google-yellow-50-rgb));--google-yellow-100-rgb:254,239,195;--google-yellow-100:rgb(var(--google-yellow-100-rgb));--google-yellow-200-rgb:253,226,147;--google-yellow-200:rgb(var(--google-yellow-200-rgb));--google-yellow-300-rgb:253,214,51;--google-yellow-300:rgb(var(--google-yellow-300-rgb));--google-yellow-400-rgb:252,201,52;--google-yellow-400:rgb(var(--google-yellow-400-rgb));--google-yellow-500-rgb:251,188,4;--google-yellow-500:rgb(var(--google-yellow-500-rgb));--google-yellow-700-rgb:240,147,0;--google-yellow-700:rgb(var(--google-yellow-700-rgb));--cr-card-background-color:white;--cr-shadow-key-color_:color-mix(in srgb,var(--cr-shadow-color) 30%,transparent);--cr-shadow-ambient-color_:color-mix(in srgb,var(--cr-shadow-color) 15%,transparent);--cr-elevation-1:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 1px 3px 1px;--cr-elevation-2:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 2px 6px 2px;--cr-elevation-3:var(--cr-shadow-key-color_) 0 1px 3px 0,var(--cr-shadow-ambient-color_) 0 4px 8px 3px;--cr-elevation-4:var(--cr-shadow-key-color_) 0 2px 3px 0,var(--cr-shadow-ambient-color_) 0 6px 10px 4px;--cr-elevation-5:var(--cr-shadow-key-color_) 0 4px 4px 0,var(--cr-shadow-ambient-color_) 0 8px 12px 6px;--cr-card-shadow:var(--cr-elevation-2);--cr-focused-item-color:var(--google-grey-300);--cr-form-field-label-color:var(--google-grey-700);--cr-hairline-rgb:0,0,0;--cr-iph-anchor-highlight-color:rgba(var(--google-blue-600-rgb),0.1);--cr-menu-background-color:white;--cr-menu-background-focus-color:var(--google-grey-400);--cr-menu-shadow:var(--cr-elevation-2);--cr-separator-color:rgba(0,0,0,.06);--cr-title-text-color:rgb(90,90,90);--cr-scrollable-border-color:var(--google-grey-300)}@media (prefers-color-scheme:dark){html{--cr-card-background-color:var(--google-grey-900-white-4-percent);--cr-focused-item-color:var(--google-grey-800);--cr-form-field-label-color:var(--dark-secondary-color);--cr-hairline-rgb:255,255,255;--cr-iph-anchor-highlight-color:rgba(var(--google-grey-100-rgb),0.1);--cr-menu-background-color:var(--google-grey-900);--cr-menu-background-focus-color:var(--google-grey-700);--cr-menu-background-sheen:rgba(255,255,255,.06);--cr-menu-shadow:rgba(0,0,0,.3) 0 1px 2px 0,rgba(0,0,0,.15) 0 3px 6px 2px;--cr-separator-color:rgba(255,255,255,.1);--cr-title-text-color:var(--cr-primary-text-color);--cr-scrollable-border-color:var(--google-grey-700)}}@media (forced-colors:active){html{--cr-focus-outline-hcm:2px solid transparent;--cr-border-hcm:2px solid transparent}}html{--cr-button-edge-spacing:12px;--cr-controlled-by-spacing:24px;--cr-default-input-max-width:264px;--cr-icon-ripple-size:36px;--cr-icon-ripple-padding:8px;--cr-icon-size:20px;--cr-icon-button-margin-start:16px;--cr-icon-ripple-margin:calc(var(--cr-icon-ripple-padding) * -1);--cr-section-min-height:48px;--cr-section-two-line-min-height:64px;--cr-section-padding:20px;--cr-section-vertical-padding:12px;--cr-section-indent-width:40px;--cr-section-indent-padding:calc(var(--cr-section-padding) + var(--cr-section-indent-width));--cr-section-vertical-margin:21px;--cr-centered-card-max-width:680px;--cr-centered-card-width-percentage:0.96;--cr-hairline:1px solid rgba(var(--cr-hairline-rgb),.14);--cr-separator-height:1px;--cr-separator-line:var(--cr-separator-height) solid var(--cr-separator-color);--cr-toolbar-overlay-animation-duration:150ms;--cr-toolbar-height:56px;--cr-container-shadow-height:6px;--cr-container-shadow-margin:calc(-1 * var(--cr-container-shadow-height));--cr-container-shadow-max-opacity:1;--cr-card-border-radius:8px;--cr-disabled-opacity:.38;--cr-form-field-bottom-spacing:16px;--cr-form-field-label-font-size:.625rem;--cr-form-field-label-height:1em;--cr-form-field-label-line-height:1}html{--cr-fallback-color-outline:rgb(116,119,117);--cr-fallback-color-primary:rgb(11,87,208);--cr-fallback-color-on-primary:rgb(255,255,255);--cr-fallback-color-primary-container:rgb(211,227,253);--cr-fallback-color-on-primary-container:rgb(4,30,73);--cr-fallback-color-secondary-container:rgb(194,231,255);--cr-fallback-color-on-secondary-container:rgb(0,29,53);--cr-fallback-color-neutral-container:rgb(242,242,242);--cr-fallback-color-neutral-outline:rgb(199,199,199);--cr-fallback-color-surface:rgb(255,255,255);--cr-fallback-color-surface1:rgb(248,250,253);--cr-fallback-color-surface2:rgb(243,246,252);--cr-fallback-color-surface3:rgb(239,243,250);--cr-fallback-color-on-surface-rgb:31,31,31;--cr-fallback-color-on-surface:rgb(var(--cr-fallback-color-on-surface-rgb));--cr-fallback-color-surface-variant:rgb(225,227,225);--cr-fallback-color-on-surface-variant:rgb(138,141,140);--cr-fallback-color-on-surface-subtle:rgb(71,71,71);--cr-fallback-color-inverse-primary:rgb(168,199,250);--cr-fallback-color-inverse-surface:rgb(48,48,48);--cr-fallback-color-inverse-on-surface:rgb(242,242,242);--cr-fallback-color-tonal-container:rgb(211,227,253);--cr-fallback-color-on-tonal-container:rgb(4,30,73);--cr-fallback-color-tonal-outline:rgb(168,199,250);--cr-fallback-color-error:rgb(179,38,30);--cr-fallback-color-divider:rgb(211,227,253);--cr-fallback-color-state-hover-on-prominent_:rgba(253,252,251,.1);--cr-fallback-color-state-on-subtle-rgb_:31,31,31;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.06);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.08);--cr-fallback-color-state-ripple-primary-rgb_:124,172,248;--cr-fallback-color-state-ripple-primary_:rgba(var(--cr-fallback-color-state-ripple-primary-rgb_),0.32);--cr-fallback-color-base-container:rgb(236,239,247);--cr-fallback-color-disabled-background:rgba(var(--cr-fallback-color-on-surface-rgb),.12);--cr-fallback-color-disabled-foreground:rgba(var(--cr-fallback-color-on-surface-rgb),var(--cr-disabled-opacity));--cr-hover-background-color:var(--color-sys-state-hover,rgba(var(--cr-fallback-color-on-surface-rgb),.08));--cr-hover-on-prominent-background-color:var(--color-sys-state-hover-on-prominent,var(--cr-fallback-color-state-hover-on-prominent_));--cr-hover-on-subtle-background-color:var(--color-sys-state-hover-on-subtle,var(--cr-fallback-color-state-hover-on-subtle_));--cr-active-background-color:var(--color-sys-state-pressed,rgba(var(--cr-fallback-color-on-surface-rgb),.12));--cr-active-on-primary-background-color:var(--color-sys-state-ripple-primary,var(--cr-fallback-color-state-ripple-primary_));--cr-active-neutral-on-subtle-background-color:var(--color-sys-state-ripple-neutral-on-subtle,var(--cr-fallback-color-state-ripple-neutral-on-subtle_));--cr-focus-outline-color:var(--color-sys-state-focus-ring,var(--owl-control-accent-color,var(--cr-fallback-color-primary)));--cr-focus-outline-inverse-color:var(--color-sys-state-focus-ring-inverse,var(--cr-fallback-color-inverse-primary));--cr-primary-text-color:var(--color-primary-foreground,var(--cr-fallback-color-on-surface));--cr-secondary-text-color:var(--color-secondary-foreground,var(--cr-fallback-color-on-surface-variant));--cr-link-color:var(--color-link-foreground-default,var(--cr-fallback-color-primary));--cr-button-height:36px;--cr-shadow-color:var(--color-sys-shadow,rgb(0,0,0));--cr-checked-color:var(--color-checkbox-foreground-checked,var(--owl-control-accent-color,var(--cr-fallback-color-primary)))}@media (prefers-color-scheme:dark){html{--cr-fallback-color-outline:rgb(142,145,143);--cr-fallback-color-primary:rgb(168,199,250);--cr-fallback-color-on-primary:rgb(6,46,111);--cr-fallback-color-primary-container:rgb(8,66,160);--cr-fallback-color-on-primary-container:rgb(211,227,253);--cr-fallback-color-secondary-container:rgb(0,74,119);--cr-fallback-color-on-secondary-container:rgb(194,231,255);--cr-fallback-color-neutral-container:rgb(40,40,40);--cr-fallback-color-neutral-outline:rgb(117,117,117);--cr-fallback-color-surface:rgb(31,31,31);--cr-fallback-color-surface1:rgb(39,40,42);--cr-fallback-color-surface2:rgb(45,47,49);--cr-fallback-color-surface3:rgb(51,52,56);--cr-fallback-color-on-surface-rgb:227,227,227;--cr-fallback-color-surface-variant:rgb(68,71,70);--cr-fallback-color-on-surface-variant:rgb(158,161,160);--cr-fallback-color-on-surface-subtle:rgb(199,199,199);--cr-fallback-color-inverse-primary:rgb(11,87,208);--cr-fallback-color-inverse-surface:rgb(227,227,227);--cr-fallback-color-inverse-on-surface:rgb(31,31,31);--cr-fallback-color-tonal-container:rgb(0,74,119);--cr-fallback-color-on-tonal-container:rgb(194,231,255);--cr-fallback-color-tonal-outline:rgb(4,125,183);--cr-fallback-color-error:rgb(242,184,181);--cr-fallback-color-divider:rgb(94,94,94);--cr-fallback-color-state-hover-on-prominent_:rgba(31,31,31,.06);--cr-fallback-color-state-on-subtle-rgb_:253,252,251;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.10);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.16);--cr-fallback-color-state-ripple-primary-rgb_:76,141,246;--cr-fallback-color-base-container:rgba(40,40,40,1)}}@media (forced-colors:active){html{--cr-fallback-color-disabled-background:Canvas;--cr-fallback-color-disabled-foreground:GrayText}}`);document.adoptedStyleSheets=[...document.adoptedStyleSheets,sheet];let instance$F=null;function getCss$y(){return instance$F||(instance$F=[...[getCss$z()],css`:host{--cr-button-background-color:transparent;--cr-button-border-color:var(--color-button-border,var(--cr-fallback-color-tonal-outline));--cr-button-text-color:var(--color-button-foreground,var(--cr-fallback-color-primary));--cr-button-ripple-opacity:1;--cr-button-ripple-color:var(--cr-active-background-color);--cr-button-disabled-background-color:transparent;--cr-button-disabled-border-color:var(--color-button-border-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground))}:host(.action-button){--cr-button-background-color:var(--color-button-background-prominent,var(--cr-fallback-color-primary));--cr-button-text-color:var(--color-button-foreground-prominent,var(--cr-fallback-color-on-primary));--cr-button-ripple-color:var(--cr-active-on-primary-background-color);--cr-button-border:none;--cr-button-disabled-background-color:var(--color-button-background-prominent-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-button-disabled-border:none}:host(.tonal-button),:host(.floating-button){--cr-button-background-color:var(--color-button-background-tonal,var(--cr-fallback-color-secondary-container));--cr-button-text-color:var(--color-button-foreground-tonal,var(--cr-fallback-color-on-tonal-container));--cr-button-border:none;--cr-button-disabled-background-color:var(--color-button-background-tonal-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-button-disabled-border:none}:host{flex-shrink:0;display:inline-flex;align-items:center;justify-content:center;box-sizing:border-box;min-width:5.14em;height:var(--cr-button-height);padding:8px 16px;outline-width:0;overflow:hidden;position:relative;cursor:pointer;user-select:none;-webkit-tap-highlight-color:transparent;border:var(--cr-button-border,1px solid var(--cr-button-border-color));border-radius:8px;background:var(--cr-button-background-color);color:var(--cr-button-text-color);font-weight:500;line-height:20px;isolation:isolate}@media (forced-colors:active){:host{forced-color-adjust:none}}:host(.floating-button){border-radius:8px;height:40px;transition:box-shadow 80ms linear}:host(.floating-button:hover){box-shadow:var(--cr-elevation-3)}:host([has-prefix-icon_]),:host([has-suffix-icon_]){--iron-icon-height:20px;--iron-icon-width:20px;--icon-block-padding-large:16px;--icon-block-padding-small:12px;gap:8px;padding-block-end:8px;padding-block-start:8px}:host([has-prefix-icon_]){padding-inline-end:var(--icon-block-padding-large);padding-inline-start:var(--icon-block-padding-small)}:host([has-suffix-icon_]){padding-inline-end:var(--icon-block-padding-small);padding-inline-start:var(--icon-block-padding-large)}#background{border-radius:inherit;inset:0;pointer-events:none;position:absolute}#content{display:inline}#hoverBackground{content:'';display:none;inset:0;pointer-events:none;position:absolute;z-index:1}:host(:hover) #hoverBackground{background:var(--cr-hover-background-color);display:block}:host(.action-button:hover) #hoverBackground{background:var(--cr-hover-on-prominent-background-color)}:host([disabled]){background:var(--cr-button-disabled-background-color);border:var(--cr-button-disabled-border,1px solid var(--cr-button-disabled-border-color));color:var(--cr-button-disabled-text-color);cursor:auto;pointer-events:none}:host(.cancel-button){margin-inline-end:8px}:host(.action-button),:host(.cancel-button){line-height:154%}#ink{color:var(--cr-button-ripple-color);--paper-ripple-opacity:var(--cr-button-ripple-opacity)}#background{z-index:0}#hoverBackground,cr-ripple{z-index:1}#content,::slotted(*){z-index:2}`])}function getHtml$s(){return html`
<div id="background"></div>
<slot id="prefixIcon" name="prefix-icon"
    @slotchange="${this.onPrefixIconSlotChanged_}">
</slot>
<span id="content"><slot></slot></span>
<slot id="suffixIcon" name="suffix-icon"
    @slotchange="${this.onSuffixIconSlotChanged_}">
</slot>
<div id="hoverBackground" part="hoverBackground"></div>`}const CrButtonElementBase=CrRippleMixin(CrLitElement);class CrButtonElement extends CrButtonElementBase{static get is(){return"cr-button"}static get styles(){return getCss$y()}render(){return getHtml$s.bind(this)()}static get properties(){return{disabled:{type:Boolean,reflect:true},hasPrefixIcon_:{type:Boolean,reflect:true},hasSuffixIcon_:{type:Boolean,reflect:true}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#hasPrefixIcon__accessor_storage=false;get hasPrefixIcon_(){return this.#hasPrefixIcon__accessor_storage}set hasPrefixIcon_(value){this.#hasPrefixIcon__accessor_storage=value}#hasSuffixIcon__accessor_storage=false;get hasSuffixIcon_(){return this.#hasSuffixIcon__accessor_storage}set hasSuffixIcon_(value){this.#hasSuffixIcon__accessor_storage=value}spaceKeyDown_=false;timeoutIds_=new Set;constructor(){super();this.addEventListener("blur",this.onBlur_.bind(this));this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("keyup",this.onKeyUp_.bind(this));this.ensureRippleOnPointerdown()}firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","button")}if(!this.hasAttribute("tabindex")){this.setAttribute("tabindex","0")}FocusOutlineManager.forDocument(document)}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled")){this.setAttribute("aria-disabled",this.disabled?"true":"false");this.disabledChanged_(this.disabled,changedProperties.get("disabled"))}}disconnectedCallback(){super.disconnectedCallback();this.timeoutIds_.forEach(clearTimeout);this.timeoutIds_.clear()}setTimeout_(fn,delay){if(!this.isConnected){return}const id=setTimeout((()=>{this.timeoutIds_.delete(id);fn()}),delay);this.timeoutIds_.add(id)}disabledChanged_(newValue,oldValue){if(!newValue&&oldValue===undefined){return}if(this.disabled){this.blur()}this.setAttribute("tabindex",String(this.disabled?-1:0))}onBlur_(){this.spaceKeyDown_=false;this.setTimeout_((()=>this.getRipple().uiUpAction()),100)}onClick_(e){if(this.disabled){e.stopImmediatePropagation()}}onPrefixIconSlotChanged_(){this.hasPrefixIcon_=this.$.prefixIcon.assignedElements().length>0}onSuffixIconSlotChanged_(){this.hasSuffixIcon_=this.$.suffixIcon.assignedElements().length>0}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}this.getRipple().uiDownAction();if(e.key==="Enter"){this.click();this.setTimeout_((()=>this.getRipple().uiUpAction()),100)}else if(e.key===" "){this.spaceKeyDown_=true}}onKeyUp_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(this.spaceKeyDown_&&e.key===" "){this.spaceKeyDown_=false;this.click();this.getRipple().uiUpAction()}}}customElements.define(CrButtonElement.is,CrButtonElement);let instance$E=null;function getCss$x(){return instance$E||(instance$E=[...[getCss$z()],css`:host{align-items:center;display:inline-flex;justify-content:center;position:relative;vertical-align:middle;fill:var(--iron-icon-fill-color,currentcolor);stroke:var(--iron-icon-stroke-color,none);width:var(--iron-icon-width,24px);height:var(--iron-icon-height,24px)}`])}let iconsetMap=null;class IconsetMap extends EventTarget{iconsets_=new Map;static getInstance(){return iconsetMap||(iconsetMap=new IconsetMap)}static resetInstanceForTesting(instance){iconsetMap=instance}get(id){return this.iconsets_.get(id)||null}set(id,iconset){assert(!this.iconsets_.has(id),`Tried to add a second iconset with id '${id}'`);this.iconsets_.set(id,iconset);this.dispatchEvent(new CustomEvent("cr-iconset-added",{detail:id}))}}class CrIconElement extends CrLitElement{static get is(){return"cr-icon"}static get styles(){return getCss$x()}static get properties(){return{icon:{type:String}}}#icon_accessor_storage="";get icon(){return this.#icon_accessor_storage}set icon(value){this.#icon_accessor_storage=value}iconsetName_="";iconName_="";iconset_=null;updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("icon")){const[iconsetName,iconName]=this.icon.split(":");this.iconName_=iconName||"";this.iconsetName_=iconsetName||"";this.updateIcon_()}}updateIcon_(){if(this.iconName_===""&&this.iconset_){this.iconset_.removeIcon(this)}else if(this.iconsetName_){const iconsetMap=IconsetMap.getInstance();this.iconset_=iconsetMap.get(this.iconsetName_);assert(this.iconset_,`Could not find iconset for: '${this.iconsetName_}:${this.iconName_}'`);this.iconset_.applyIcon(this,this.iconName_)}}}customElements.define(CrIconElement.is,CrIconElement);let instance$D=null;function getCss$w(){return instance$D||(instance$D=[...[],css`#toolEnabledButton{align-items:center;background-color:var(--color-composebox-context-entrypoint-hover-background);border:none;color:var(--color-searchbox-results-foreground);display:flex;font-size:13px;gap:2px;height:36px;justify-content:center;padding-bottom:6px;padding-inline:8px 12px;padding-top:6px}#toolEnabledButton .icon-container{align-items:center;display:flex;height:24px;justify-content:center;position:relative;width:24px}#toolEnabledButton .tool-icon,#toolEnabledButton .close-icon{height:16px;position:absolute;transition:opacity 150ms;width:16px}#toolEnabledButton .tool-icon{padding-top:3px}#toolEnabledButton .close-icon{opacity:0}#toolEnabledButton:hover .close-icon,#toolEnabledButton:focus .close-icon{opacity:1}#toolEnabledButton:hover .tool-icon,#toolEnabledButton:focus .tool-icon{opacity:0}`])}function getHtml$r(){return html`
<cr-button id="toolEnabledButton" class="upload-icon no-overlap"
  aria-label="${this.removeChipAriaLabel}">
  <div class="icon-container" slot="prefix-icon">
    <cr-icon class="tool-icon" .icon="${this.icon}"></cr-icon>
    <cr-icon class="close-icon" icon="cr:close"></cr-icon>
  </div>
  <div>${this.label}</div>
</cr-button>`}class ComposeboxToolChipElement extends CrLitElement{static get is(){return"cr-composebox-tool-chip"}static get styles(){return getCss$w()}static get properties(){return{icon:{type:String},label:{type:String},visible:{type:Boolean},removeChipAriaLabel:{type:String}}}#icon_accessor_storage="";get icon(){return this.#icon_accessor_storage}set icon(value){this.#icon_accessor_storage=value}#label_accessor_storage="";get label(){return this.#label_accessor_storage}set label(value){this.#label_accessor_storage=value}#visible_accessor_storage=false;get visible(){return this.#visible_accessor_storage}set visible(value){this.#visible_accessor_storage=value}#removeChipAriaLabel_accessor_storage="";get removeChipAriaLabel(){return this.#removeChipAriaLabel_accessor_storage}set removeChipAriaLabel(value){this.#removeChipAriaLabel_accessor_storage=value}render(){if(!this.visible){return}return getHtml$r.call(this)}}customElements.define(ComposeboxToolChipElement.is,ComposeboxToolChipElement);let instance$C=null;function getCss$v(){return instance$C||(instance$C=[...[],css`:host{display:none}`])}function getHtml$q(){return html`
<svg id="baseSvg" xmlns="http://www.w3.org/2000/svg"
     viewBox="0 0 ${this.size} ${this.size}"
     preserveAspectRatio="xMidYMid meet" focusable="false"
     style="pointer-events: none; display: block; width: 100%; height: 100%;">
 </svg>
<slot></slot>
`}const APPLIED_ICON_CLASS="cr-iconset-svg-icon_";class CrIconsetElement extends CrLitElement{static get is(){return"cr-iconset"}static get styles(){return getCss$v()}render(){return getHtml$q.bind(this)()}static get properties(){return{name:{type:String},size:{type:Number}}}#name_accessor_storage="";get name(){return this.#name_accessor_storage}set name(value){this.#name_accessor_storage=value}#size_accessor_storage=24;get size(){return this.#size_accessor_storage}set size(value){this.#size_accessor_storage=value}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("name")){assert(changedProperties.get("name")===undefined);IconsetMap.getInstance().set(this.name,this)}}applyIcon(element,iconName){this.removeIcon(element);const svg=this.cloneIcon_(iconName);if(svg){svg.classList.add(APPLIED_ICON_CLASS);element.shadowRoot.insertBefore(svg,element.shadowRoot.childNodes[0]);return svg}return null}createIcon(iconName){return this.cloneIcon_(iconName)}removeIcon(element){const oldSvg=element.shadowRoot.querySelector(`.${APPLIED_ICON_CLASS}`);if(oldSvg){oldSvg.remove()}}cloneIcon_(id){const sourceSvg=this.querySelector(`g[id="${id}"]`);if(!sourceSvg){return null}const svgClone=this.$.baseSvg.cloneNode(true);const content=sourceSvg.cloneNode(true);content.removeAttribute("id");const contentViewBox=content.getAttribute("viewBox");if(contentViewBox){svgClone.setAttribute("viewBox",contentViewBox)}svgClone.appendChild(content);return svgClone}}customElements.define(CrIconsetElement.is,CrIconsetElement);function isValidArray(arr){if(arr instanceof Array&&Object.isFrozen(arr)){return true}return false}function getStaticString(literal){const isStaticString=isValidArray(literal)&&!!literal.raw&&isValidArray(literal.raw)&&literal.length===literal.raw.length&&literal.length===1;assert(isStaticString,"static_types.js only allows static strings");return literal.join("")}function createTypes(_ignore,literal){return getStaticString(literal)}const rules={createHTML:createTypes,createScript:createTypes,createScriptURL:createTypes};let staticPolicy;if(window.trustedTypes){staticPolicy=window.trustedTypes.createPolicy("static-types",rules)}else{staticPolicy=rules}function getTrustedHTML(literal){return staticPolicy.createHTML("",literal)}const div$1=document.createElement("div");div$1.innerHTML=getTrustedHTML`
<cr-iconset name="composebox">
  <svg>
    <defs>
      <g id="google-lens-2" height="20px" viewBox="0 -960 960 960" width="20px" fill="currentColor">
        <path d="M480.24-324Q432-324 398-357.76q-34-33.77-34-82Q364-488 397.76-522q33.77-34 82-34Q528-556 562-522.24q34 33.77 34 82Q596-392 562.24-358q-33.77 34-82 34ZM720-164q-32 0-54-22t-22-54q0-32 22-54t54-22q32 0 54 22t22 54q0 32-22 54t-54 22Zm-432 20q-60 0-102-42t-42-102v-96h72v96q0 29.7 21.15 50.85Q258.3-216 288-216h192v72H288Zm456-296v-160q0-29.7-21.15-50.85Q701.7-672 672-672H288q-29.7 0-50.85 21.15Q216-629.7 216-600v144h-72v-144q0-60 42-102t102-42h80l36-72h152l36 72h80q60 0 102 42t42 102v160h-72Z"/>
      </g>
      <g id="imageUpload">
        <path d="M5 21C4.45 21 3.975 20.8083 3.575 20.425C3.19167 20.025 3 19.55 3 19V5C3 4.45 3.19167 3.98333 3.575 3.6C3.975 3.2 4.45 3 5 3H13C13 3.28333 13 3.59167 13 3.925C13 4.25833 13 4.61667 13 5H5V19H19V11C19.3833 11 19.7417 11 20.075 11C20.4083 11 20.7167 11 21 11V19C21 19.55 20.8 20.025 20.4 20.425C20.0167 20.8083 19.55 21 19 21H5ZM6 17H18L14.25 12L11.25 16L9 13L6 17ZM17 9V7H15V5H17V3H19V5H21V7H19V9H17Z" fill="currentColor"/>
      </g>
      <g id="fileUpload">
        <path d="M18 15.75C18 17.4833 17.3917 18.9583 16.175 20.175C14.9583 21.3917 13.4833 22 11.75 22C10.0167 22 8.54167 21.3917 7.325 20.175C6.10833 18.9583 5.5 17.4833 5.5 15.75V6.5C5.5 5.25 5.93333 4.19167 6.8 3.325C7.68333 2.44167 8.75 2 10 2C11.25 2 12.3083 2.44167 13.175 3.325C14.0583 4.19167 14.5 5.25 14.5 6.5V15.25C14.5 16.0167 14.2333 16.6667 13.7 17.2C13.1667 17.7333 12.5167 18 11.75 18C10.9833 18 10.3333 17.7333 9.8 17.2C9.26667 16.6667 9 16.0167 9 15.25V6H11V15.25C11 15.4667 11.0667 15.65 11.2 15.8C11.35 15.9333 11.5333 16 11.75 16C11.9667 16 12.1417 15.9333 12.275 15.8C12.425 15.65 12.5 15.4667 12.5 15.25V6.5C12.4833 5.8 12.2333 5.20833 11.75 4.725C11.2833 4.24167 10.7 4 10 4C9.3 4 8.70833 4.24167 8.225 4.725C7.74167 5.20833 7.5 5.8 7.5 6.5V15.75C7.48333 16.9333 7.89167 17.9417 8.725 18.775C9.55833 19.5917 10.5667 20 11.75 20C12.9167 20 13.9083 19.5917 14.725 18.775C15.5417 17.9417 15.9667 16.9333 16 15.75V6H18V15.75Z" fill="currentColor"/>
      </g>
      <g id="deepSearch" viewBox="0 0 16 16">
        <path d="M0.447222 6.99401C0.447222 6.08019 0.614385 5.22766 0.948711 4.43642C1.29418 3.64519 1.76781 2.95425 2.36959 2.36361C2.97138 1.76182 3.66789 1.29376 4.45913 0.959439C5.25036 0.613969 6.09732 0.441235 7 0.441235C8.40417 0.441235 9.64674 0.825709 10.7277 1.59466C11.8087 2.36361 12.5944 3.35544 13.0847 4.57015C13.1627 4.77075 13.1627 4.97134 13.0847 5.17194C13.0067 5.36139 12.8674 5.48955 12.6668 5.55641C12.4997 5.62328 12.3269 5.60656 12.1486 5.50626C11.9814 5.40597 11.8644 5.26666 11.7976 5.08836C11.5413 4.45314 11.1679 3.89036 10.6776 3.40001C10.1984 2.89853 9.6356 2.51405 8.98924 2.24659V2.61435C8.98924 2.94867 8.87222 3.23285 8.6382 3.46688C8.40417 3.68976 8.12556 3.8012 7.80238 3.8012H6.19762V4.60359C6.19762 4.82647 6.11961 5.01592 5.96359 5.17194C5.81872 5.31681 5.63484 5.38925 5.41195 5.38925H4.60957V6.99401H4.69316C4.89375 6.99401 5.06091 7.06088 5.19464 7.19461C5.32837 7.32834 5.39524 7.48993 5.39524 7.67938V8.56534H4.60957L1.95169 5.90745C1.91825 6.08576 1.89039 6.26407 1.86811 6.44238C1.84582 6.62068 1.83467 6.80456 1.83467 6.99401C1.83467 8.29788 2.25815 9.43459 3.10511 10.4041C3.96321 11.3737 5.01634 11.9365 6.26448 12.0925C6.44279 12.1371 6.58209 12.2318 6.68239 12.3767C6.78269 12.5104 6.82727 12.6664 6.81612 12.8447C6.79383 13.0342 6.70468 13.1957 6.54866 13.3295C6.39264 13.4521 6.21434 13.4911 6.01374 13.4465C4.44241 13.2236 3.12183 12.5048 2.05198 11.2901C0.982143 10.0754 0.447222 8.64335 0.447222 6.99401ZM12.1152 12.6775L10.5271 11.1062C10.3043 11.2399 10.0702 11.3458 9.82505 11.4238C9.59102 11.4907 9.34028 11.5241 9.07282 11.5241C8.27044 11.5241 7.59064 11.2455 7.03343 10.6883C6.47622 10.1311 6.19762 9.45688 6.19762 8.66564C6.19762 7.86326 6.47622 7.18346 7.03343 6.62625C7.59064 6.06905 8.27044 5.79044 9.07282 5.79044C9.86406 5.79044 10.5383 6.06905 11.0955 6.62625C11.6527 7.18346 11.9313 7.85769 11.9313 8.64892C11.9313 8.92753 11.8923 9.18942 11.8143 9.43459C11.7474 9.67976 11.6471 9.90822 11.5134 10.12L13.1014 11.708C13.2352 11.8529 13.302 12.0145 13.302 12.1928C13.302 12.3711 13.2352 12.5327 13.1014 12.6775C12.9566 12.8113 12.7894 12.8781 12.6 12.8781C12.4216 12.8781 12.2601 12.8113 12.1152 12.6775ZM9.0561 10.1367C9.46844 10.1367 9.81948 9.99737 10.1092 9.71876C10.399 9.42902 10.5438 9.07797 10.5438 8.66564C10.5438 8.2533 10.399 7.90226 10.1092 7.61251C9.83062 7.32277 9.48515 7.17789 9.07282 7.17789C8.66048 7.17789 8.30944 7.32277 8.01969 7.61251C7.72994 7.89112 7.58507 8.23659 7.58507 8.64892C7.58507 9.06126 7.72437 9.4123 8.00298 9.70205C8.29272 9.9918 8.64377 10.1367 9.0561 10.1367Z" fill="currentColor"/>
      </g>
      <g id="createImage" viewBox="0 0 16 16">
        <path d="M8.72178 8.114C9.02267 8.114 9.30127 8.05828 9.55759 7.94684C9.82505 7.8354 10.0702 7.67938 10.2931 7.47878C10.438 7.33391 10.5661 7.16675 10.6776 6.9773C10.789 6.7767 10.8782 6.56496 10.945 6.34208C10.9785 6.23064 10.9506 6.13034 10.8615 6.04118C10.7834 5.95203 10.6887 5.92417 10.5773 5.9576C10.3544 5.99104 10.1427 6.06347 9.94206 6.17491C9.75261 6.27521 9.57988 6.40337 9.42386 6.55939C9.21212 6.75998 9.04496 6.99401 8.92237 7.26147C8.81093 7.51779 8.74406 7.80197 8.72178 8.114ZM8.68834 8.114C8.66606 7.80197 8.58805 7.51222 8.45432 7.24476C8.33173 6.9773 8.16457 6.74327 7.95283 6.54267C7.78567 6.38665 7.60179 6.26407 7.40119 6.17491C7.21174 6.07462 7.00557 6.00218 6.78269 5.9576C6.67125 5.92417 6.57095 5.95203 6.4818 6.04118C6.40379 6.13034 6.37593 6.23064 6.39821 6.34208C6.45394 6.56496 6.53752 6.7767 6.64896 6.9773C6.77154 7.16675 6.91642 7.33391 7.08358 7.47878C7.29532 7.67938 7.53492 7.8354 7.80238 7.94684C8.06984 8.05828 8.36516 8.114 8.68834 8.114ZM8.70506 6.02447C8.86108 6.02447 8.99481 5.96875 9.10625 5.85731C9.22884 5.74586 9.29013 5.60656 9.29013 5.4394V5.28895L9.40714 5.37253C9.54087 5.46169 9.68575 5.48955 9.84177 5.45612C10.0089 5.41154 10.1371 5.31124 10.2262 5.15522C10.3042 5.03264 10.321 4.89333 10.2764 4.73732C10.2318 4.5813 10.1427 4.45314 10.0089 4.35284L9.89192 4.26926L10.0256 4.18568C10.1594 4.09653 10.243 3.97951 10.2764 3.83464C10.321 3.67862 10.2987 3.52817 10.2095 3.3833C10.1315 3.23842 10.0145 3.1437 9.85848 3.09912C9.70246 3.05454 9.55759 3.07683 9.42386 3.16599L9.29013 3.24957V3.08241C9.29013 2.92639 9.22884 2.79266 9.10625 2.68122C8.99481 2.55863 8.85551 2.49734 8.68834 2.49734C8.53233 2.49734 8.3986 2.55863 8.28715 2.68122C8.17571 2.79266 8.11999 2.92639 8.11999 3.08241V3.24957L7.96954 3.16599C7.82467 3.07683 7.67422 3.05454 7.51821 3.09912C7.37333 3.1437 7.25632 3.23285 7.16716 3.36658C7.08915 3.51146 7.06687 3.6619 7.1003 3.81792C7.14487 3.97394 7.2396 4.09653 7.38448 4.18568L7.51821 4.26926L7.36776 4.33613C7.22288 4.41413 7.12816 4.53115 7.08358 4.68717C7.05015 4.84319 7.07801 4.99363 7.16716 5.13851C7.25632 5.29453 7.3789 5.39482 7.53492 5.4394C7.69094 5.47283 7.83581 5.44497 7.96954 5.35582L8.10327 5.27224V5.4394C8.10327 5.60656 8.159 5.74586 8.27044 5.85731C8.38188 5.96875 8.52675 6.02447 8.70506 6.02447ZM8.68834 4.85433C8.53233 4.85433 8.3986 4.79861 8.28715 4.68717C8.17571 4.57573 8.11999 4.43642 8.11999 4.26926C8.11999 4.11324 8.17571 3.97951 8.28715 3.86807C8.3986 3.74548 8.5379 3.68419 8.70506 3.68419C8.86108 3.68419 8.99481 3.74548 9.10625 3.86807C9.22884 3.97951 9.29013 4.11324 9.29013 4.26926C9.29013 4.43642 9.22884 4.57573 9.10625 4.68717C8.99481 4.79861 8.85551 4.85433 8.68834 4.85433ZM5.14449 10.2537C4.72102 10.2537 4.38112 10.1311 4.1248 9.88593C3.87963 9.62961 3.75704 9.28971 3.75704 8.86623V1.7451C3.75704 1.32162 3.87963 0.987299 4.1248 0.742127C4.38112 0.485811 4.72102 0.357653 5.14449 0.357653H12.2656C12.6891 0.357653 13.0234 0.485811 13.2686 0.742127C13.5249 0.987299 13.6531 1.32162 13.6531 1.7451V8.86623C13.6531 9.28971 13.5249 9.62961 13.2686 9.88593C13.0234 10.1311 12.6891 10.2537 12.2656 10.2537H5.14449ZM5.14449 8.86623H12.2656V1.7451H5.14449V8.86623ZM2.8878 13.6304C2.52004 13.6861 2.18014 13.5969 1.86811 13.3629C1.56721 13.1177 1.38891 12.8113 1.33318 12.4435L0.380357 5.37253C0.324636 4.98249 0.41379 4.63702 0.647818 4.33613C0.89299 4.02409 1.20503 3.84578 1.58393 3.8012L1.90154 3.76777C2.11328 3.75663 2.28601 3.81792 2.41974 3.95165C2.56462 4.08538 2.63705 4.25812 2.63705 4.46986C2.63705 4.64816 2.58133 4.80418 2.46989 4.93791C2.35845 5.07164 2.21357 5.14408 2.03527 5.15522L1.76781 5.18866L2.70392 12.2596L10.2931 11.2232C10.4937 11.2009 10.6664 11.2511 10.8113 11.3737C10.9673 11.4851 11.0565 11.6356 11.0788 11.825C11.1122 12.0145 11.0676 12.1872 10.945 12.3432C10.8336 12.4992 10.6832 12.5884 10.4937 12.6107L2.8878 13.6304Z" fill="currentColor"/>
      </g>
      <g id="nanoBanana" viewBox="0 0 24 24">
        <path d="M2 22.4004H22V2.40039H2V22.4004Z" fill="url(#pattern0_1500_179774)"/>
          <defs>
          <pattern id="pattern0_1500_179774" patternContentUnits="objectBoundingBox" width="1" height="1">
            <use xlink:href="#image0_1500_179774" transform="scale(0.00625)"/>
          </pattern>
          <image id="image0_1500_179774" width="160" height="160" preserveAspectRatio="none" xlink:href="data:image/png;base64,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"/>
        </defs>
      </g>
  </defs>
  </svg>
</cr-iconset>
<cr-iconset name="thumbnail" size=18>
  <svg>
    <defs>
      <g id="pdf">
        <path d="M12.5 12H14V10H15.5V8.5H14V7.5H15.5V6H12.5V12ZM2.5 12H4V10H5.5C5.78333 10 6.01667 9.90833 6.2 9.725C6.4 9.525 6.5 9.28333 6.5 9V7C6.5 6.71667 6.4 6.48333 6.2 6.3C6.01667 6.1 5.78333 6 5.5 6H2.5V12ZM4 8.5V7.5H5V8.5H4ZM7.4 12H10.4C10.6833 12 10.9167 11.9083 11.1 11.725C11.3 11.525 11.4 11.2833 11.4 11V7C11.4 6.71667 11.3 6.48333 11.1 6.3C10.9167 6.1 10.6833 6 10.4 6H7.4V12ZM8.9 10.5V7.5H9.9V10.5H8.9ZM2 18C1.45 18 0.975 17.8083 0.575 17.425C0.191667 17.025 0 16.55 0 16V2C0 1.45 0.191667 0.983333 0.575 0.599999C0.975 0.199999 1.45 -1.43051e-06 2 -1.43051e-06H16C16.55 -1.43051e-06 17.0167 0.199999 17.4 0.599999C17.8 0.983333 18 1.45 18 2V16C18 16.55 17.8 17.025 17.4 17.425C17.0167 17.8083 16.55 18 16 18H2ZM2 16H16V2H2V16ZM2 2V16V2Z" fill="currentColor"/>
      </g>
    </defs>
  </svg>
</cr-iconset>`;const iconsets$1=div$1.querySelectorAll("cr-iconset");for(const iconset of iconsets$1){document.head.appendChild(iconset)}const AUTO_SRC="auto-src";const CLEAR_SRC="clear-src";const IS_GOOGLE_PHOTOS="is-google-photos";const STATIC_ENCODE="static-encode";const ENCODE_TYPE="encode-type";class CrAutoImgElement extends HTMLImageElement{static get observedAttributes(){return[AUTO_SRC,IS_GOOGLE_PHOTOS,STATIC_ENCODE,ENCODE_TYPE]}attributeChangedCallback(name,oldValue,newValue){if(name!==AUTO_SRC&&name!==IS_GOOGLE_PHOTOS&&name!==STATIC_ENCODE&&name!==ENCODE_TYPE){return}if(name===IS_GOOGLE_PHOTOS&&oldValue===null===(newValue===null)){return}if(this.hasAttribute(CLEAR_SRC)){this.removeAttribute("src")}let url=null;try{url=new URL(this.getAttribute(AUTO_SRC)||"")}catch(_){}if(!url||url.protocol==="chrome-untrusted:"){this.removeAttribute("src");return}if(url.protocol==="data:"||url.protocol==="chrome:"){this.src=url.href;return}if(!this.hasAttribute(IS_GOOGLE_PHOTOS)&&!this.hasAttribute(STATIC_ENCODE)&&!this.hasAttribute(ENCODE_TYPE)){this.src="chrome://image?"+url.href;return}this.src=`chrome://image?url=${encodeURIComponent(url.href)}`;if(this.hasAttribute(IS_GOOGLE_PHOTOS)){this.src+=`&isGooglePhotos=true`}if(this.hasAttribute(STATIC_ENCODE)){this.src+=`&staticEncode=true`}if(this.hasAttribute(ENCODE_TYPE)){this.src+=`&encodeType=${this.getAttribute(ENCODE_TYPE)}`}}set autoSrc(src){this.setAttribute(AUTO_SRC,src)}get autoSrc(){return this.getAttribute(AUTO_SRC)||""}set clearSrc(_){this.setAttribute(CLEAR_SRC,"")}get clearSrc(){return this.getAttribute(CLEAR_SRC)||""}set isGooglePhotos(enabled){if(enabled){this.setAttribute(IS_GOOGLE_PHOTOS,"")}else{this.removeAttribute(IS_GOOGLE_PHOTOS)}}get isGooglePhotos(){return this.hasAttribute(IS_GOOGLE_PHOTOS)}set staticEncode(enabled){if(enabled){this.setAttribute(STATIC_ENCODE,"")}else{this.removeAttribute(STATIC_ENCODE)}}get staticEncode(){return this.hasAttribute(STATIC_ENCODE)}set encodeType(type){if(type){this.setAttribute(ENCODE_TYPE,type)}else{this.removeAttribute(ENCODE_TYPE)}}get encodeType(){return this.getAttribute(ENCODE_TYPE)||""}}customElements.define("cr-auto-img",CrAutoImgElement,{extends:"img"});const isMac=/Mac/.test(navigator.platform);const isWindows=/Win/.test(navigator.platform);const isAndroid=/Android/.test(navigator.userAgent);const isIOS=/CriOS/.test(navigator.userAgent);function getSupportedScaleFactors(){const supportedScaleFactors=[];if(!isIOS){supportedScaleFactors.push(1)}if(!isIOS&&!isAndroid){supportedScaleFactors.push(2)}else{supportedScaleFactors.push(window.devicePixelRatio)}return supportedScaleFactors}function getUrlForCss(s){const s2=s.replace(/(\(|\)|\,|\s|\'|\"|\\)/g,"\\$1");return`url("${s2}")`}function getImageSet(path){const supportedScaleFactors=getSupportedScaleFactors();const replaceStartIndex=path.indexOf("SCALEFACTOR");if(replaceStartIndex<0){return getUrlForCss(path)}let s="";for(let i=0;i<supportedScaleFactors.length;++i){const scaleFactor=supportedScaleFactors[i];const pathWithScaleFactor=path.substr(0,replaceStartIndex)+scaleFactor+path.substr(replaceStartIndex+"scalefactor".length);s+=getUrlForCss(pathWithScaleFactor)+" "+scaleFactor+"x";if(i!==supportedScaleFactors.length-1){s+=", "}}return"image-set("+s+")"}function getBaseFaviconUrl(){const faviconUrl=new URL("chrome://favicon2/");faviconUrl.searchParams.set("size","16");faviconUrl.searchParams.set("scaleFactor","SCALEFACTORx");return faviconUrl}function getDefaultFaviconUrlParams(){return{isSyncedUrlForHistoryUi:false,remoteIconUrlForUma:"",size:16,forceLightMode:false,fallbackToHost:true,forceEmptyDefaultFavicon:false,scaleFactor:""}}function getFaviconUrl(url,optionalParams){const params=Object.assign(getDefaultFaviconUrlParams(),optionalParams);const faviconUrl=getBaseFaviconUrl();faviconUrl.searchParams.set("pageUrl",url);faviconUrl.searchParams.set("size",params.size.toString());const fallback=params.isSyncedUrlForHistoryUi?"1":"0";faviconUrl.searchParams.set("allowGoogleServerFallback",fallback);if(params.isSyncedUrlForHistoryUi){faviconUrl.searchParams.set("iconUrl",params.remoteIconUrlForUma)}if(params.forceLightMode){faviconUrl.searchParams.set("forceLightMode","true")}if(!params.fallbackToHost){faviconUrl.searchParams.set("fallbackToHost","0")}if(params.forceEmptyDefaultFavicon){faviconUrl.searchParams.set("forceEmptyDefaultFavicon","1")}if(params.scaleFactor){faviconUrl.searchParams.set("scaleFactor",params.scaleFactor)}return faviconUrl.toString()}function getFaviconForPageURL(url,isSyncedUrlForHistoryUi,remoteIconUrlForUma="",size=16,forceLightMode=false,fallbackToHost=true,forceEmptyDefaultFavicon=false,scaleFactor=""){return getImageSet(getFaviconUrl(url,{isSyncedUrlForHistoryUi:isSyncedUrlForHistoryUi,remoteIconUrlForUma:remoteIconUrlForUma,size:size,forceLightMode:forceLightMode,fallbackToHost:fallbackToHost,forceEmptyDefaultFavicon:forceEmptyDefaultFavicon,scaleFactor:scaleFactor}))}let instance$B=null;function getCss$u(){return instance$B||(instance$B=[...[],css`:host{background-position:center;background-repeat:no-repeat;background-size:100%;display:flex;flex-shrink:0;height:16px;width:16px}`])}class TabFaviconElement extends CrLitElement{static get is(){return"cr-composebox-tab-favicon"}static get styles(){return getCss$u()}static get properties(){return{url:{type:Object},size:{type:Number}}}#url_accessor_storage="";get url(){return this.#url_accessor_storage}set url(value){this.#url_accessor_storage=value}#size_accessor_storage=16;get size(){return this.#size_accessor_storage}set size(value){this.#size_accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("url")||changedProperties.has("size")){if(!this.url){this.style.setProperty("background-image","")}else{this.style.setProperty("background-image",getFaviconForPageURL(this.url,false,"",this.size,false,true))}}}}customElements.define(TabFaviconElement.is,TabFaviconElement);const div=document.createElement("div");div.innerHTML=getTrustedHTML`
<cr-iconset name="cr20" size="20">
  <svg>
    <defs>
      <!--
      Keep these in sorted order by id="".
      -->
      <g id="block">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M10 0C4.48 0 0 4.48 0 10C0 15.52 4.48 20 10 20C15.52 20 20 15.52 20 10C20 4.48 15.52 0 10 0ZM2 10C2 5.58 5.58 2 10 2C11.85 2 13.55 2.63 14.9 3.69L3.69 14.9C2.63 13.55 2 11.85 2 10ZM5.1 16.31C6.45 17.37 8.15 18 10 18C14.42 18 18 14.42 18 10C18 8.15 17.37 6.45 16.31 5.1L5.1 16.31Z">
        </path>
      </g>
      <g id="cloud-off">
        <path
          d="M16 18.125L13.875 16H5C3.88889 16 2.94444 15.6111 2.16667 14.8333C1.38889 14.0556 1 13.1111 1 12C1 10.9444 1.36111 10.0347 2.08333 9.27083C2.80556 8.50694 3.6875 8.09028 4.72917 8.02083C4.77083 7.86805 4.8125 7.72222 4.85417 7.58333C4.90972 7.44444 4.97222 7.30555 5.04167 7.16667L1.875 4L2.9375 2.9375L17.0625 17.0625L16 18.125ZM5 14.5H12.375L6.20833 8.33333C6.15278 8.51389 6.09722 8.70139 6.04167 8.89583C6 9.07639 5.95139 9.25694 5.89583 9.4375L4.83333 9.52083C4.16667 9.57639 3.61111 9.84028 3.16667 10.3125C2.72222 10.7708 2.5 11.3333 2.5 12C2.5 12.6944 2.74306 13.2847 3.22917 13.7708C3.71528 14.2569 4.30556 14.5 5 14.5ZM17.5 15.375L16.3958 14.2917C16.7153 14.125 16.9792 13.8819 17.1875 13.5625C17.3958 13.2431 17.5 12.8889 17.5 12.5C17.5 11.9444 17.3056 11.4722 16.9167 11.0833C16.5278 10.6944 16.0556 10.5 15.5 10.5H14.125L14 9.14583C13.9028 8.11806 13.4722 7.25694 12.7083 6.5625C11.9444 5.85417 11.0417 5.5 10 5.5C9.65278 5.5 9.31944 5.54167 9 5.625C8.69444 5.70833 8.39583 5.82639 8.10417 5.97917L7.02083 4.89583C7.46528 4.61806 7.93056 4.40278 8.41667 4.25C8.91667 4.08333 9.44444 4 10 4C11.4306 4 12.6736 4.48611 13.7292 5.45833C14.7847 6.41667 15.375 7.59722 15.5 9C16.4722 9 17.2986 9.34028 17.9792 10.0208C18.6597 10.7014 19 11.5278 19 12.5C19 13.0972 18.8611 13.6458 18.5833 14.1458C18.3194 14.6458 17.9583 15.0556 17.5 15.375Z">
        </path>
      </g>
      <g id="delete">
        <path
          d="M 5.832031 17.5 C 5.375 17.5 4.984375 17.335938 4.65625 17.011719 C 4.328125 16.683594 4.167969 16.292969 4.167969 15.832031 L 4.167969 5 L 3.332031 5 L 3.332031 3.332031 L 7.5 3.332031 L 7.5 2.5 L 12.5 2.5 L 12.5 3.332031 L 16.667969 3.332031 L 16.667969 5 L 15.832031 5 L 15.832031 15.832031 C 15.832031 16.292969 15.671875 16.683594 15.34375 17.011719 C 15.015625 17.335938 14.625 17.5 14.167969 17.5 Z M 14.167969 5 L 5.832031 5 L 5.832031 15.832031 L 14.167969 15.832031 Z M 7.5 14.167969 L 9.167969 14.167969 L 9.167969 6.667969 L 7.5 6.667969 Z M 10.832031 14.167969 L 12.5 14.167969 L 12.5 6.667969 L 10.832031 6.667969 Z M 5.832031 5 L 5.832031 15.832031 Z M 5.832031 5 ">
        </path>
      </g>
      <g id="domain" viewBox="0 -960 960 960">
        <path d="M96-144v-672h384v144h384v528H96Zm72-72h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm168 456h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm144 456h312v-384H480v80h72v72h-72v80h72v72h-72v80Zm168-232v-72h72v72h-72Zm0 152v-72h72v72h-72Z"></path>
      </g>
      <g id="kite">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M4.6327 8.00094L10.3199 2L16 8.00094L10.1848 16.8673C10.0995 16.9873 10.0071 17.1074 9.90047 17.2199C9.42417 17.7225 8.79147 18 8.11611 18C7.44076 18 6.80806 17.7225 6.33175 17.2199C5.85545 16.7173 5.59242 16.0497 5.59242 15.3371C5.59242 14.977 5.46445 14.647 5.22275 14.3919C4.98104 14.1369 4.66825 14.0019 4.32701 14.0019H4V12.6667H4.32701C5.00237 12.6667 5.63507 12.9442 6.11137 13.4468C6.58768 13.9494 6.85071 14.617 6.85071 15.3296C6.85071 15.6896 6.97867 16.0197 7.22038 16.2747C7.46209 16.5298 7.77488 16.6648 8.11611 16.6648C8.45735 16.6648 8.77014 16.5223 9.01185 16.2747C9.02396 16.2601 9.03607 16.246 9.04808 16.2319C9.08541 16.1883 9.12176 16.1458 9.15403 16.0947L9.55213 15.4946L4.6327 8.00094ZM10.3199 13.9371L6.53802 8.17116L10.3199 4.1814L14.0963 8.17103L10.3199 13.9371Z">
        </path>
      </g>
      <g id="menu">
        <path d="M2 4h16v2H2zM2 9h16v2H2zM2 14h16v2H2z"></path>
      </g>
      <g id="password">
        <path d="M5.833 11.667c.458 0 .847-.16 1.167-.479.333-.333.5-.729.5-1.188s-.167-.847-.5-1.167a1.555 1.555 0 0 0-1.167-.5c-.458 0-.854.167-1.188.5A1.588 1.588 0 0 0 4.166 10c0 .458.16.854.479 1.188.333.319.729.479 1.188.479Zm0 3.333c-1.389 0-2.569-.486-3.542-1.458C1.319 12.569.833 11.389.833 10c0-1.389.486-2.569 1.458-3.542C3.264 5.486 4.444 5 5.833 5c.944 0 1.813.243 2.604.729a4.752 4.752 0 0 1 1.833 1.979h7.23c.458 0 .847.167 1.167.5.333.319.5.708.5 1.167v3.958c0 .458-.167.854-.5 1.188A1.588 1.588 0 0 1 17.5 15h-3.75a1.658 1.658 0 0 1-1.188-.479 1.658 1.658 0 0 1-.479-1.188v-1.042H10.27a4.59 4.59 0 0 1-1.813 2A5.1 5.1 0 0 1 5.833 15Zm3.292-4.375h4.625v2.708H15v-1.042a.592.592 0 0 1 .167-.438.623.623 0 0 1 .458-.188c.181 0 .327.063.438.188a.558.558 0 0 1 .188.438v1.042H17.5V9.375H9.125a3.312 3.312 0 0 0-1.167-1.938 3.203 3.203 0 0 0-2.125-.77 3.21 3.21 0 0 0-2.354.979C2.827 8.298 2.5 9.083 2.5 10s.327 1.702.979 2.354a3.21 3.21 0 0 0 2.354.979c.806 0 1.514-.25 2.125-.75.611-.514 1-1.167 1.167-1.958Z"></path>
      </g>
      
  </svg>
</cr-iconset>

<!-- NOTE: In the common case that the final icon will be 20x20, export the SVG
     at 20px and place it in the section above. -->
<cr-iconset name="cr" size="24">
  <svg>
    <defs>
      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      -->
      <g id="add">
        <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z" />
      </g>
      <g id="arrow-back">
        <path
          d="m7.824 13 5.602 5.602L12 20l-8-8 8-8 1.426 1.398L7.824 11H20v2Zm0 0">
        </path>
      </g>
      <g id="arrow-drop-up">
        <path d="M7 14l5-5 5 5z"></path>
      </g>
      <g id="arrow-drop-down">
        <path d="M7 10l5 5 5-5z"></path>
      </g>
      <g id="arrow-forward">
        <path
          d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z">
        </path>
      </g>
      <g id="arrow-right">
        <path d="M10 7l5 5-5 5z"></path>
      </g>
      <g id="cancel">
        <path
          d="M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z">
        </path>
      </g>
      <g id="check">
        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path>
      </g>
      <g id="check-circle" viewBox="0 -960 960 960">
        <path d="m424-296 282-282-56-56-226 226-114-114-56 56 170 170Zm56 216q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-80q134 0 227-93t93-227q0-134-93-227t-227-93q-134 0-227 93t-93 227q0 134 93 227t227 93Zm0-320Z"></path>
      </g>
      <g id="chevron-left">
        <path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path>
      </g>
      <g id="chevron-right">
        <path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"></path>
      </g>
      <g id="clear">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="chrome-product" viewBox="0 -960 960 960">
        <path d="M336-479q0 60 42 102t102 42q60 0 102-42t42-102q0-60-42-102t-102-42q-60 0-102 42t-42 102Zm144 216q11 0 22.5-.5T525-267L427-99q-144-16-237.5-125T96-479q0-43 9.5-84.5T134-645l160 274q28 51 78 79.5T480-263Zm0-432q-71 0-126.5 42T276-545l-98-170q53-71 132.5-109.5T480-863q95 0 179 45t138 123H480Zm356 72q15 35 21.5 71t6.5 73q0 155-100 260.5T509-96l157-275q14-25 22-52t8-56q0-40-15-77t-41-67h196Z">
        </path>
      </g>
      <g id="close">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="computer">
        <path
          d="M20 18c1.1 0 1.99-.9 1.99-2L22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H0v2h24v-2h-4zM4 6h16v10H4V6z">
        </path>
      </g>
      <g id="create">
        <path
          d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z">
        </path>
      </g>
      <g id="delete" viewBox="0 -960 960 960">
        <path
          d="M309.37-135.87q-34.48 0-58.74-24.26-24.26-24.26-24.26-58.74v-474.5h-53.5v-83H378.5v-53.5h202.52v53.5h206.11v83h-53.5v474.07q0 35.21-24.26 59.32t-58.74 24.11H309.37Zm341.26-557.5H309.37v474.5h341.26v-474.5ZM379.7-288.24h77.5v-336h-77.5v336Zm123.1 0h77.5v-336h-77.5v336ZM309.37-693.37v474.5-474.5Z">
        </path>
      </g>
      <g id="domain">
        <path
          d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z">
        </path>
      </g>
      <!-- source: https://fonts.google.com/icons?selected=Material+Symbols+Outlined:family_link:FILL@0;wght@0;GRAD@0;opsz@24&icon.size=24&icon.color=%23e8eaed -->
      <g id="kite" viewBox="0 -960 960 960">
        <path
          d="M390-40q-51 0-90.5-30.5T246-149q-6-23-25-37t-43-14q-16 0-30 6.5T124-175l-61-51q21-26 51.5-40t63.5-14q51 0 91 30t54 79q6 23 25 37t42 14q19 0 34-10t26-25l1-2-276-381q-8-11-11.5-23t-3.5-24q0-16 6-30.5t18-26.5l260-255q11-11 26-17t30-6q15 0 30 6t26 17l260 255q12 12 18 26.5t6 30.5q0 12-3.5 24T825-538L500-88q-18 25-48 36.5T390-40Zm110-185 260-360-260-255-259 256 259 359Zm1-308Z"/>
        </path>
      </g>
      <g id="error">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z">
        </path>
      </g>
      <g id="error-outline">
        <path
          d="M11 15h2v2h-2zm0-8h2v6h-2zm.99-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z">
        </path>
      </g>
      <g id="expand-less">
        <path d="M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14z"></path>
      </g>
      <g id="expand-more">
        <path d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"></path>
      </g>
      <g id="extension">
        <path
          d="M20.5 11H19V7c0-1.1-.9-2-2-2h-4V3.5C13 2.12 11.88 1 10.5 1S8 2.12 8 3.5V5H4c-1.1 0-1.99.9-1.99 2v3.8H3.5c1.49 0 2.7 1.21 2.7 2.7s-1.21 2.7-2.7 2.7H2V20c0 1.1.9 2 2 2h3.8v-1.5c0-1.49 1.21-2.7 2.7-2.7 1.49 0 2.7 1.21 2.7 2.7V22H17c1.1 0 2-.9 2-2v-4h1.5c1.38 0 2.5-1.12 2.5-2.5S21.88 11 20.5 11z">
        </path>
      </g>
      <g id="file-download" viewBox="0 -960 960 960">
        <path d="M480-336 288-528l51-51 105 105v-342h72v342l105-105 51 51-192 192ZM263.72-192Q234-192 213-213.15T192-264v-72h72v72h432v-72h72v72q0 29.7-21.16 50.85Q725.68-192 695.96-192H263.72Z"></path>
      </g>
      <g id="fullscreen">
        <path
          d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z">
        </path>
      </g>
      <g id="group">
        <path
          d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z">
        </path>
      </g>
      <g id="help-outline">
        <path
          d="M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z">
        </path>
      </g>
      <g id="history">
        <path
          d="M12.945312 22.75 C 10.320312 22.75 8.074219 21.839844 6.207031 20.019531 C 4.335938 18.199219 3.359375 15.972656 3.269531 13.34375 L 5.089844 13.34375 C 5.175781 15.472656 5.972656 17.273438 7.480469 18.742188 C 8.988281 20.210938 10.808594 20.945312 12.945312 20.945312 C 15.179688 20.945312 17.070312 20.164062 18.621094 18.601562 C 20.167969 17.039062 20.945312 15.144531 20.945312 12.910156 C 20.945312 10.714844 20.164062 8.855469 18.601562 7.335938 C 17.039062 5.816406 15.15625 5.054688 12.945312 5.054688 C 11.710938 5.054688 10.554688 5.339844 9.480469 5.902344 C 8.402344 6.46875 7.476562 7.226562 6.699219 8.179688 L 9.585938 8.179688 L 9.585938 9.984375 L 3.648438 9.984375 L 3.648438 4.0625 L 5.453125 4.0625 L 5.453125 6.824219 C 6.386719 5.707031 7.503906 4.828125 8.804688 4.199219 C 10.109375 3.566406 11.488281 3.25 12.945312 3.25 C 14.300781 3.25 15.570312 3.503906 16.761719 4.011719 C 17.949219 4.519531 18.988281 5.214844 19.875 6.089844 C 20.761719 6.964844 21.464844 7.992188 21.976562 9.167969 C 22.492188 10.34375 22.75 11.609375 22.75 12.964844 C 22.75 14.316406 22.492188 15.589844 21.976562 16.777344 C 21.464844 17.964844 20.761719 19.003906 19.875 19.882812 C 18.988281 20.765625 17.949219 21.464844 16.761719 21.976562 C 15.570312 22.492188 14.300781 22.75 12.945312 22.75 Z M 16.269531 17.460938 L 12.117188 13.34375 L 12.117188 7.527344 L 13.921875 7.527344 L 13.921875 12.601562 L 17.550781 16.179688 Z M 16.269531 17.460938">
        </path>
      </g>
      <g id="info">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z">
        </path>
      </g>
      <g id="info-outline">
        <path
          d="M11 17h2v-6h-2v6zm1-15C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zM11 9h2V7h-2v2z">
        </path>
      </g>
      <g id="insert-drive-file">
        <path
          d="M6 2c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6H6zm7 7V3.5L18.5 9H13z">
        </path>
      </g>
      <g id="location-on">
        <path
          d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z">
        </path>
      </g>
      <g id="mic">
        <path
          d="M12 14c1.66 0 2.99-1.34 2.99-3L15 5c0-1.66-1.34-3-3-3S9 3.34 9 5v6c0 1.66 1.34 3 3 3zm5.3-3c0 3-2.54 5.1-5.3 5.1S6.7 14 6.7 11H5c0 3.41 2.72 6.23 6 6.72V21h2v-3.28c3.28-.48 6-3.3 6-6.72h-1.7z">
        </path>
      </g>
      <g id="more-vert">
        <path
          d="M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z">
        </path>
      </g>
      <g id="open-in-new" viewBox="0 -960 960 960">
        <path
          d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h264v72H216v528h528v-264h72v264q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm171-192-51-51 357-357H576v-72h240v240h-72v-117L387-336Z">
        </path>
      </g>
      <g id="person">
        <path
          d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z">
        </path>
      </g>
      <g id="phonelink">
        <path
          d="M4 6h18V4H4c-1.1 0-2 .9-2 2v11H0v3h14v-3H4V6zm19 2h-6c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h6c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zm-1 9h-4v-7h4v7z">
        </path>
      </g>
      <g id="print">
        <path
          d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z">
        </path>
      </g>
      <g id="schedule">
        <path
          d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z">
        </path>
      </g>
      <g id="search">
        <path
          d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z">
        </path>
      </g>
      <g id="security">
        <path
          d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z">
        </path>
      </g>
      <!-- The <g> IDs are exposed as global variables in Vulcanized mode, which
        conflicts with the "settings" namespace of MD Settings. Using an "_icon"
        suffix prevents the naming conflict. -->
      <g id="settings_icon">
        <path
          d="M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65C14.46 2.18 14.25 2 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64l-2.11-1.65zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z">
        </path>
      </g>
      <g id="star">
        <path
          d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z">
        </path>
      </g>
      <g id="sync" viewBox="0 -960 960 960">
        <path
          d="M216-192v-72h74q-45-40-71.5-95.5T192-480q0-101 61-177.5T408-758v75q-63 23-103.5 77.5T264-480q0 48 19.5 89t52.5 70v-63h72v192H216Zm336-10v-75q63-23 103.5-77.5T696-480q0-48-19.5-89T624-639v63h-72v-192h192v72h-74q45 40 71.5 95.5T768-480q0 101-61 177.5T552-202Z">
        </path>
      </g>
      <g id="thumbs-down">
        <path
            d="M6 3h11v13l-7 7-1.25-1.25a1.454 1.454 0 0 1-.3-.475c-.067-.2-.1-.392-.1-.575v-.35L9.45 16H3c-.533 0-1-.2-1.4-.6-.4-.4-.6-.867-.6-1.4v-2c0-.117.017-.242.05-.375s.067-.258.1-.375l3-7.05c.15-.333.4-.617.75-.85C5.25 3.117 5.617 3 6 3Zm9 2H6l-3 7v2h9l-1.35 5.5L15 15.15V5Zm0 10.15V5v10.15Zm2 .85v-2h3V5h-3V3h5v13h-5Z">
        </path>
      </g>
      <g id="thumbs-down-filled">
        <path
            d="M6 3h10v13l-7 7-1.25-1.25a1.336 1.336 0 0 1-.29-.477 1.66 1.66 0 0 1-.108-.574v-.347L8.449 16H3c-.535 0-1-.2-1.398-.602C1.199 15 1 14.535 1 14v-2c0-.117.012-.242.04-.375.022-.133.062-.258.108-.375l3-7.05c.153-.333.403-.618.75-.848A1.957 1.957 0 0 1 6 3Zm12 13V3h4v13Zm0 0">
        </path>
      </g>
      <g id="thumbs-up">
        <path
            d="M18 21H7V8l7-7 1.25 1.25c.117.117.208.275.275.475.083.2.125.392.125.575v.35L14.55 8H21c.533 0 1 .2 1.4.6.4.4.6.867.6 1.4v2c0 .117-.017.242-.05.375s-.067.258-.1.375l-3 7.05c-.15.333-.4.617-.75.85-.35.233-.717.35-1.1.35Zm-9-2h9l3-7v-2h-9l1.35-5.5L9 8.85V19ZM9 8.85V19 8.85ZM7 8v2H4v9h3v2H2V8h5Z">
        </path>
      </g>
      <g id="thumbs-up-filled">
        <path
            d="M18 21H8V8l7-7 1.25 1.25c.117.117.21.273.29.477.073.199.108.39.108.574v.347L15.551 8H21c.535 0 1 .2 1.398.602C22.801 9 23 9.465 23 10v2c0 .117-.012.242-.04.375a1.897 1.897 0 0 1-.108.375l-3 7.05a2.037 2.037 0 0 1-.75.848A1.957 1.957 0 0 1 18 21ZM6 8v13H2V8Zm0 0">
      </g>
      <g id="videocam" viewBox="0 -960 960 960">
        <path
          d="M216-192q-29 0-50.5-21.5T144-264v-432q0-29.7 21.5-50.85Q187-768 216-768h432q29.7 0 50.85 21.15Q720-725.7 720-696v168l144-144v384L720-432v168q0 29-21.15 50.5T648-192H216Zm0-72h432v-432H216v432Zm0 0v-432 432Z">
        </path>
      </g>
      <g id="warning">
        <path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"></path>
      </g>
    </defs>
  </svg>
</cr-iconset>`;const iconsets=div.querySelectorAll("cr-iconset");for(const iconset of iconsets){document.head.appendChild(iconset)}function getDeepActiveElement(){let a=document.activeElement;while(a&&a.shadowRoot&&a.shadowRoot.activeElement){a=a.shadowRoot.activeElement}return a}function isRTL(){return document.documentElement.dir==="rtl"}function hasKeyModifiers(e){return!!(e.altKey||e.ctrlKey||e.metaKey||e.shiftKey)}const ACTIVE_CLASS="focus-row-active";class FocusRow{root;delegate;eventTracker=new EventTracker;boundary_;constructor(root,boundary,delegate){this.root=root;this.boundary_=boundary||document.documentElement;this.delegate=delegate}static isFocusable(element){if(!element||element.disabled){return false}let current=element;while(true){assertInstanceof(current,Element);const style=window.getComputedStyle(current);if(style.visibility==="hidden"||style.display==="none"){return false}const parent=current.parentNode;if(!parent){return false}if(parent===current.ownerDocument||parent instanceof DocumentFragment){return true}current=parent}}static getFocusableElement(element){const withFocusable=element;if(withFocusable.getFocusableElement){return withFocusable.getFocusableElement()}return element}addItem(type,selectorOrElement){assert(type);let element;if(typeof selectorOrElement==="string"){element=this.root.querySelector(selectorOrElement)}else{element=selectorOrElement}if(!element){return false}element.setAttribute("focus-type",type);element.tabIndex=this.isActive()?0:-1;this.eventTracker.add(element,"blur",this.onBlur_.bind(this));this.eventTracker.add(element,"focus",this.onFocus_.bind(this));this.eventTracker.add(element,"keydown",this.onKeydown_.bind(this));this.eventTracker.add(element,"mousedown",this.onMousedown_.bind(this));return true}destroy(){this.eventTracker.removeAll()}getCustomEquivalent(_sampleElement){const focusable=this.getFirstFocusable();assert(focusable);return focusable}getElements(){return Array.from(this.root.querySelectorAll("[focus-type]")).map(FocusRow.getFocusableElement)}getEquivalentElement(sampleElement){if(this.getFocusableElements().indexOf(sampleElement)>=0){return sampleElement}const sampleFocusType=this.getTypeForElement(sampleElement);if(sampleFocusType){const sameType=this.getFirstFocusable(sampleFocusType);if(sameType){return sameType}}return this.getCustomEquivalent(sampleElement)}getFirstFocusable(type){const element=this.getFocusableElements().find((el=>!type||el.getAttribute("focus-type")===type));return element||null}getFocusableElements(){return this.getElements().filter(FocusRow.isFocusable)}getTypeForElement(element){return element.getAttribute("focus-type")||""}isActive(){return this.root.classList.contains(ACTIVE_CLASS)}makeActive(active){if(active===this.isActive()){return}this.getElements().forEach((function(element){element.tabIndex=active?0:-1}));this.root.classList.toggle(ACTIVE_CLASS,active)}onBlur_(e){if(!this.boundary_.contains(e.relatedTarget)){return}const currentTarget=e.currentTarget;if(this.getFocusableElements().indexOf(currentTarget)>=0){this.makeActive(false)}}onFocus_(e){if(this.delegate){this.delegate.onFocus(this,e)}}onMousedown_(e){if(e.button){return}const target=e.currentTarget;if(!target.disabled){target.tabIndex=0}}onKeydown_(e){const elements=this.getFocusableElements();const currentElement=FocusRow.getFocusableElement(e.currentTarget);const elementIndex=elements.indexOf(currentElement);assert(elementIndex>=0);if(this.delegate&&this.delegate.onKeydown(this,e)){return}const isShiftTab=!e.altKey&&!e.ctrlKey&&!e.metaKey&&e.shiftKey&&e.key==="Tab";if(hasKeyModifiers(e)&&!isShiftTab){return}let index=-1;let shouldStopPropagation=true;if(isShiftTab){index=elementIndex-1;if(index<0){return}}else if(e.key==="ArrowLeft"){index=elementIndex+(isRTL()?1:-1)}else if(e.key==="ArrowRight"){index=elementIndex+(isRTL()?-1:1)}else if(e.key==="Home"){index=0}else if(e.key==="End"){index=elements.length-1}else{shouldStopPropagation=false}const elementToFocus=elements[index];if(elementToFocus){this.getEquivalentElement(elementToFocus).focus();e.preventDefault()}if(shouldStopPropagation){e.stopPropagation()}}}let hideInk=false;document.addEventListener("pointerdown",(function(){hideInk=true}),true);document.addEventListener("keydown",(function(){hideInk=false}),true);function focusWithoutInk(toFocus){if(!("noink"in toFocus)||!hideInk){toFocus.focus();return}const toFocusWithNoInk=toFocus;assert(document===toFocusWithNoInk.ownerDocument);const{noink:noink}=toFocusWithNoInk;toFocusWithNoInk.noink=true;toFocusWithNoInk.focus();toFocusWithNoInk.noink=noink}let instance$A=null;function getCss$t(){return instance$A||(instance$A=[...[],css`:host{--cr-hairline:1px solid var(--color-menu-separator,var(--cr-fallback-color-divider));--cr-action-menu-disabled-item-color:var(--color-menu-item-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-action-menu-disabled-item-opacity:1;--cr-menu-background-color:var(--color-menu-background,var(--cr-fallback-color-surface));--cr-menu-background-focus-color:var(--cr-hover-background-color);--cr-menu-shadow:var(--cr-elevation-2);--cr-primary-text-color:var(--color-menu-item-foreground,var(--cr-fallback-color-on-surface))}:host dialog{background-color:var(--cr-menu-background-color);border:none;border-radius:var(--cr-menu-border-radius,4px);box-shadow:var(--cr-menu-shadow);margin:0;min-width:128px;outline:none;overflow:var(--cr-action-menu-overflow,auto);padding:0;position:absolute}@media (forced-colors:active){:host dialog{border:var(--cr-border-hcm)}}:host dialog::backdrop{background-color:transparent}:host ::slotted(.dropdown-item){-webkit-tap-highlight-color:transparent;background:none;border:none;border-radius:0;box-sizing:border-box;color:var(--cr-primary-text-color);font:inherit;min-height:32px;padding:8px 24px;text-align:start;user-select:none;width:100%}:host ::slotted(.dropdown-item:not([hidden])){align-items:center;display:flex}:host ::slotted(.dropdown-item[disabled]){color:var(--cr-action-menu-disabled-item-color,var(--cr-primary-text-color));opacity:var(--cr-action-menu-disabled-item-opacity,0.65)}:host ::slotted(.dropdown-item:not([disabled])){cursor:pointer}:host ::slotted(.dropdown-item:focus){background-color:var(--cr-menu-background-focus-color);outline:none}:host ::slotted(.dropdown-item:focus-visible){outline:solid 2px var(--cr-focus-outline-color);outline-offset:-2px}@media (forced-colors:active){:host ::slotted(.dropdown-item:focus){outline:var(--cr-focus-outline-hcm)}}.item-wrapper{outline:none;padding:var(--cr-action-menu-padding,8px 0)}`])}function getHtml$p(){return html`
<dialog id="dialog" part="dialog" @close="${this.onNativeDialogClose_}"
    role="application"
    aria-roledescription="${this.roleDescription||nothing}">
  <div id="wrapper" class="item-wrapper" role="menu" tabindex="-1"
      aria-label="${this.accessibilityLabel||nothing}">
    <slot id="contentNode" @slotchange="${this.onSlotchange_}"></slot>
  </div>
</dialog>`}var AnchorAlignment;(function(AnchorAlignment){AnchorAlignment[AnchorAlignment["BEFORE_START"]=-2]="BEFORE_START";AnchorAlignment[AnchorAlignment["AFTER_START"]=-1]="AFTER_START";AnchorAlignment[AnchorAlignment["CENTER"]=0]="CENTER";AnchorAlignment[AnchorAlignment["BEFORE_END"]=1]="BEFORE_END";AnchorAlignment[AnchorAlignment["AFTER_END"]=2]="AFTER_END"})(AnchorAlignment||(AnchorAlignment={}));const DROPDOWN_ITEM_CLASS="dropdown-item";const SELECTABLE_DROPDOWN_ITEM_QUERY=`.${DROPDOWN_ITEM_CLASS}:not([hidden]):not([disabled])`;const AFTER_END_OFFSET=10;function getStartPointWithAnchor(start,end,menuLength,anchorAlignment,min,max){let startPoint=0;switch(anchorAlignment){case AnchorAlignment.BEFORE_START:startPoint=start-menuLength;break;case AnchorAlignment.AFTER_START:startPoint=start;break;case AnchorAlignment.CENTER:startPoint=(start+end-menuLength)/2;break;case AnchorAlignment.BEFORE_END:startPoint=end-menuLength;break;case AnchorAlignment.AFTER_END:startPoint=end;break}if(startPoint+menuLength>max){startPoint=end-menuLength}if(startPoint<min){startPoint=start}startPoint=Math.max(min,Math.min(startPoint,max-menuLength));return startPoint}function getDefaultShowConfig(){return{top:0,left:0,height:0,width:0,anchorAlignmentX:AnchorAlignment.AFTER_START,anchorAlignmentY:AnchorAlignment.AFTER_START,minX:0,minY:0,maxX:0,maxY:0}}class CrActionMenuElement extends CrLitElement{static get is(){return"cr-action-menu"}static get styles(){return getCss$t()}render(){return getHtml$p.bind(this)()}static get properties(){return{accessibilityLabel:{type:String},autoReposition:{type:Boolean},open:{type:Boolean,notify:true},roleDescription:{type:String}}}#accessibilityLabel_accessor_storage;get accessibilityLabel(){return this.#accessibilityLabel_accessor_storage}set accessibilityLabel(value){this.#accessibilityLabel_accessor_storage=value}#autoReposition_accessor_storage=false;get autoReposition(){return this.#autoReposition_accessor_storage}set autoReposition(value){this.#autoReposition_accessor_storage=value}#open_accessor_storage=false;get open(){return this.#open_accessor_storage}set open(value){this.#open_accessor_storage=value}#roleDescription_accessor_storage;get roleDescription(){return this.#roleDescription_accessor_storage}set roleDescription(value){this.#roleDescription_accessor_storage=value}boundClose_=null;resizeObserver_=null;hasMousemoveListener_=false;anchorElement_=null;lastConfig_=null;firstUpdated(){this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("mouseover",this.onMouseover_);this.addEventListener("click",this.onClick_)}disconnectedCallback(){super.disconnectedCallback();this.removeListeners_()}getDialog(){return this.$.dialog}removeListeners_(){window.removeEventListener("resize",this.boundClose_);window.removeEventListener("popstate",this.boundClose_);if(this.resizeObserver_){this.resizeObserver_.disconnect();this.resizeObserver_=null}}onNativeDialogClose_(e){if(e.target!==this.$.dialog){return}this.fire("close")}onClick_(e){if(e.target===this){this.close();e.stopPropagation()}}onKeyDown_(e){e.stopPropagation();if(e.key==="Tab"||e.key==="Escape"){this.close();if(e.key==="Tab"){this.fire("tabkeyclose",{shiftKey:e.shiftKey})}e.preventDefault();return}if(e.key!=="Enter"&&e.key!=="ArrowUp"&&e.key!=="ArrowDown"){return}const options=Array.from(this.querySelectorAll(SELECTABLE_DROPDOWN_ITEM_QUERY));if(options.length===0){return}const focused=getDeepActiveElement();const index=options.findIndex((option=>FocusRow.getFocusableElement(option)===focused));if(e.key==="Enter"){if(index!==-1){return}if(isWindows||isMac){this.close();e.preventDefault();return}}e.preventDefault();this.updateFocus_(options,index,e.key!=="ArrowUp");if(!this.hasMousemoveListener_){this.hasMousemoveListener_=true;this.addEventListener("mousemove",(e=>{this.onMouseover_(e);this.hasMousemoveListener_=false}),{once:true})}}onMouseover_(e){const item=e.composedPath().find((el=>el.matches&&el.matches(SELECTABLE_DROPDOWN_ITEM_QUERY)));(item||this.$.wrapper).focus()}updateFocus_(options,focusedIndex,next){const numOptions=options.length;assert(numOptions>0);let index;if(focusedIndex===-1){index=next?0:numOptions-1}else{const delta=next?1:-1;index=(numOptions+focusedIndex+delta)%numOptions}options[index].focus()}close(){if(!this.open){return}this.removeListeners_();this.$.dialog.close();this.open=false;if(this.anchorElement_){assert(this.anchorElement_);focusWithoutInk(this.anchorElement_);this.anchorElement_=null}if(this.lastConfig_){this.lastConfig_=null}}showAt(anchorElement,config){this.anchorElement_=anchorElement;this.anchorElement_.scrollIntoViewIfNeeded();const rect=this.anchorElement_.getBoundingClientRect();let height=rect.height;if(config&&!config.noOffset&&config.anchorAlignmentY===AnchorAlignment.AFTER_END){height-=AFTER_END_OFFSET}this.showAtPosition(Object.assign({top:rect.top,left:rect.left,height:height,width:rect.width,anchorAlignmentX:AnchorAlignment.BEFORE_END},config));this.$.wrapper.focus()}showAtPosition(config){const doc=document.scrollingElement;const scrollLeft=doc.scrollLeft;const scrollTop=doc.scrollTop;this.resetStyle_();this.$.dialog.showModal();this.open=true;config.top+=scrollTop;config.left+=scrollLeft;this.positionDialog_(Object.assign({minX:scrollLeft,minY:scrollTop,maxX:scrollLeft+doc.clientWidth,maxY:scrollTop+doc.clientHeight},config));doc.scrollTop=scrollTop;doc.scrollLeft=scrollLeft;this.addListeners_();const openedByKey=FocusOutlineManager.forDocument(document).visible;if(openedByKey){const firstSelectableItem=this.querySelector(SELECTABLE_DROPDOWN_ITEM_QUERY);if(firstSelectableItem){requestAnimationFrame((()=>{firstSelectableItem.focus()}))}}}resetStyle_(){this.$.dialog.style.left="";this.$.dialog.style.right="";this.$.dialog.style.top="0"}positionDialog_(config){this.lastConfig_=config;const c=Object.assign(getDefaultShowConfig(),config);const top=c.top;const left=c.left;const bottom=top+c.height;const right=left+c.width;const rtl=getComputedStyle(this).direction==="rtl";if(rtl){c.anchorAlignmentX*=-1}const offsetWidth=this.$.dialog.offsetWidth;const menuLeft=getStartPointWithAnchor(left,right,offsetWidth,c.anchorAlignmentX,c.minX,c.maxX);if(rtl){const menuRight=document.scrollingElement.clientWidth-menuLeft-offsetWidth;this.$.dialog.style.right=menuRight+"px"}else{this.$.dialog.style.left=menuLeft+"px"}const menuTop=getStartPointWithAnchor(top,bottom,this.$.dialog.offsetHeight,c.anchorAlignmentY,c.minY,c.maxY);this.$.dialog.style.top=menuTop+"px"}onSlotchange_(){for(const node of this.$.contentNode.assignedElements({flatten:true})){if(node.classList.contains(DROPDOWN_ITEM_CLASS)&&!node.getAttribute("role")){node.setAttribute("role","menuitem")}}}addListeners_(){this.boundClose_=this.boundClose_||(()=>{if(this.$.dialog.open){this.close()}});window.addEventListener("resize",this.boundClose_);window.addEventListener("popstate",this.boundClose_);if(this.autoReposition){this.resizeObserver_=new ResizeObserver((()=>{if(this.lastConfig_){this.positionDialog_(this.lastConfig_);this.fire("cr-action-menu-repositioned")}}));this.resizeObserver_.observe(this.$.dialog)}}}customElements.define(CrActionMenuElement.is,CrActionMenuElement);let instance$z=null;function getCss$s(){return instance$z||(instance$z=[...[],css`:host{--cr-icon-button-fill-color:currentColor;--cr-icon-button-icon-start-offset:0;--cr-icon-button-icon-size:20px;--cr-icon-button-size:32px;--cr-icon-button-height:var(--cr-icon-button-size);--cr-icon-button-transition:150ms ease-in-out;--cr-icon-button-width:var(--cr-icon-button-size);-webkit-tap-highlight-color:transparent;border-radius:50%;color:var(--cr-icon-button-stroke-color,var(--cr-icon-button-fill-color));cursor:pointer;display:inline-flex;flex-shrink:0;height:var(--cr-icon-button-height);margin-inline-end:var(--cr-icon-button-margin-end,var(--cr-icon-ripple-margin));margin-inline-start:var(--cr-icon-button-margin-start);outline:none;overflow:hidden;position:relative;user-select:none;vertical-align:middle;width:var(--cr-icon-button-width)}:host(:hover){background-color:var(--cr-icon-button-hover-background-color,var(--cr-hover-background-color))}:host(:focus-visible:focus){box-shadow:inset 0 0 0 2px var(--cr-icon-button-focus-outline-color,var(--cr-focus-outline-color))}@media (forced-colors:active){:host(:focus-visible:focus){outline:var(--cr-focus-outline-hcm)}}#ink{--paper-ripple-opacity:1;color:var(--cr-icon-button-active-background-color,var(--cr-active-background-color))}:host([disabled]){cursor:initial;opacity:var(--cr-disabled-opacity);pointer-events:none}:host(.no-overlap){--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0}:host-context([dir=rtl]):host(:not([suppress-rtl-flip]):not([multiple-icons_])){transform:scaleX(-1)}:host-context([dir=rtl]):host(:not([suppress-rtl-flip])[multiple-icons_]) cr-icon{transform:scaleX(-1)}:host(:not([iron-icon])) #maskedImage{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-button-icon-size);-webkit-transform:var(--cr-icon-image-transform,none);background-color:var(--cr-icon-button-fill-color);height:100%;transition:background-color var(--cr-icon-button-transition);width:100%}@media (forced-colors:active){:host(:not([iron-icon])) #maskedImage{background-color:ButtonText}}#icon{align-items:center;border-radius:4px;display:flex;height:100%;justify-content:center;padding-inline-start:var(--cr-icon-button-icon-start-offset);position:relative;width:100%}cr-icon{--iron-icon-fill-color:var(--cr-icon-button-fill-color);--iron-icon-stroke-color:var(--cr-icon-button-stroke-color,none);--iron-icon-height:var(--cr-icon-button-icon-size);--iron-icon-width:var(--cr-icon-button-icon-size);transition:fill var(--cr-icon-button-transition),stroke var(--cr-icon-button-transition)}@media (prefers-color-scheme:dark){:host{--cr-icon-button-fill-color:var(--google-grey-500)}}`])}function getHtml$o(){return html`
<div id="icon">
  <div id="maskedImage"></div>
</div>`}const CrIconbuttonElementBase=CrRippleMixin(CrLitElement);class CrIconButtonElement extends CrIconbuttonElementBase{static get is(){return"cr-icon-button"}static get styles(){return getCss$s()}render(){return getHtml$o.bind(this)()}static get properties(){return{disabled:{type:Boolean,reflect:true},ironIcon:{type:String,reflect:true},suppressRtlFlip:{type:Boolean,value:false,reflect:true},multipleIcons_:{type:Boolean,reflect:true}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#ironIcon_accessor_storage;get ironIcon(){return this.#ironIcon_accessor_storage}set ironIcon(value){this.#ironIcon_accessor_storage=value}#multipleIcons__accessor_storage=false;get multipleIcons_(){return this.#multipleIcons__accessor_storage}set multipleIcons_(value){this.#multipleIcons__accessor_storage=value}spaceKeyDown_=false;constructor(){super();this.addEventListener("blur",this.onBlur_.bind(this));this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("keyup",this.onKeyUp_.bind(this));this.ensureRippleOnPointerdown()}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("ironIcon")){const icons=(this.ironIcon||"").split(",");this.multipleIcons_=icons.length>1}}firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","button")}if(!this.hasAttribute("tabindex")){this.setAttribute("tabindex","0")}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled")){this.setAttribute("aria-disabled",this.disabled?"true":"false");this.disabledChanged_(this.disabled,changedProperties.get("disabled"))}if(changedProperties.has("ironIcon")){this.onIronIconChanged_()}}disabledChanged_(newValue,oldValue){if(!newValue&&oldValue===undefined){return}if(this.disabled){this.blur()}this.setAttribute("tabindex",String(this.disabled?-1:0))}onBlur_(){this.spaceKeyDown_=false}onClick_(e){if(this.disabled){e.stopImmediatePropagation()}}onIronIconChanged_(){this.shadowRoot.querySelectorAll("cr-icon").forEach((el=>el.remove()));if(!this.ironIcon){return}const icons=(this.ironIcon||"").split(",");icons.forEach((async icon=>{const crIcon=document.createElement("cr-icon");crIcon.icon=icon;this.$.icon.appendChild(crIcon);await crIcon.updateComplete;crIcon.shadowRoot.querySelectorAll("svg, img").forEach((child=>child.setAttribute("role","none")))}))}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}if(e.key==="Enter"){this.click()}else if(e.key===" "){this.spaceKeyDown_=true}}onKeyUp_(e){if(e.key===" "||e.key==="Enter"){e.preventDefault();e.stopPropagation()}if(this.spaceKeyDown_&&e.key===" "){this.spaceKeyDown_=false;this.click()}}}customElements.define(CrIconButtonElement.is,CrIconButtonElement);function sanitizeInnerHtmlInternal(rawString,opts){opts=opts||{};const html=parseHtmlSubset(`<b>${rawString}</b>`,opts.tags,opts.attrs).firstElementChild;return html.innerHTML}let sanitizedPolicy=null;function sanitizeInnerHtml(rawString,opts){assert(window.trustedTypes);if(sanitizedPolicy===null){sanitizedPolicy=window.trustedTypes.createPolicy("sanitize-inner-html",{createHTML:sanitizeInnerHtmlInternal,createScript:()=>assertNotReached(),createScriptURL:()=>assertNotReached()})}return sanitizedPolicy.createHTML(rawString,opts)}const allowAttribute=(_node,_value)=>true;const allowedAttributes=new Map([["href",(node,value)=>node.tagName==="A"&&(value.startsWith("chrome://")||value.startsWith("https://")||value==="#")],["target",(node,value)=>node.tagName==="A"&&value==="_blank"]]);const allowedOptionalAttributes=new Map([["class",allowAttribute],["id",allowAttribute],["is",(_node,value)=>value==="action-link"||value===""],["role",(_node,value)=>value==="link"],["src",(node,value)=>node.tagName==="IMG"&&value.startsWith("chrome://")],["tabindex",allowAttribute],["aria-description",allowAttribute],["aria-hidden",allowAttribute],["aria-label",allowAttribute],["aria-labelledby",allowAttribute]]);const allowedTags=new Set(["A","B","I","BR","DIV","EM","KBD","P","PRE","SPAN","STRONG"]);const allowedOptionalTags=new Set(["IMG","LI","UL"]);let unsanitizedPolicy;function mergeTags(optTags){const clone=new Set(allowedTags);optTags.forEach((str=>{const tag=str.toUpperCase();if(allowedOptionalTags.has(tag)){clone.add(tag)}}));return clone}function mergeAttrs(optAttrs){const clone=new Map(allowedAttributes);optAttrs.forEach((key=>{if(allowedOptionalAttributes.has(key)){clone.set(key,allowedOptionalAttributes.get(key))}}));return clone}function walk(n,f){f(n);for(let i=0;i<n.childNodes.length;i++){walk(n.childNodes[i],f)}}function assertElement(tags,node){if(!tags.has(node.tagName)){throw Error(node.tagName+" is not supported")}}function assertAttribute(attrs,attrNode,node){const n=attrNode.nodeName;const v=attrNode.nodeValue||"";if(!attrs.has(n)||!attrs.get(n)(node,v)){throw Error(node.tagName+"["+n+'="'+v+'"] is not supported')}}function parseHtmlSubset(s,extraTags,extraAttrs){const tags=extraTags?mergeTags(extraTags):allowedTags;const attrs=extraAttrs?mergeAttrs(extraAttrs):allowedAttributes;const doc=document.implementation.createHTMLDocument("");const r=doc.createRange();r.selectNode(doc.body);if(window.trustedTypes){if(!unsanitizedPolicy){unsanitizedPolicy=window.trustedTypes.createPolicy("parse-html-subset",{createHTML:untrustedHTML=>untrustedHTML,createScript:()=>assertNotReached(),createScriptURL:()=>assertNotReached()})}s=unsanitizedPolicy.createHTML(s)}const df=r.createContextualFragment(s);walk(df,(function(node){switch(node.nodeType){case Node.ELEMENT_NODE:assertElement(tags,node);const nodeAttrs=node.attributes;for(let i=0;i<nodeAttrs.length;++i){assertAttribute(attrs,nodeAttrs[i],node)}break;case Node.COMMENT_NODE:case Node.DOCUMENT_FRAGMENT_NODE:case Node.TEXT_NODE:break;default:throw Error("Node type "+node.nodeType+" is not supported")}}));return df}const I18nMixinLit=superClass=>{class I18nMixinLit extends superClass{i18nRaw_(id,...varArgs){return varArgs.length===0?loadTimeData.getString(id):loadTimeData.getStringF(id,...varArgs)}i18n(id,...varArgs){const rawString=this.i18nRaw_(id,...varArgs);return parseHtmlSubset(`<b>${rawString}</b>`).firstChild.textContent}i18nAdvanced(id,opts){opts=opts||{};const rawString=this.i18nRaw_(id,...opts.substitutions||[]);return sanitizeInnerHtml(rawString,opts)}i18nDynamic(_locale,id,...varArgs){return this.i18n(id,...varArgs)}i18nRecursive(locale,id,...varArgs){let args=varArgs;if(args.length>0){args=args.map((str=>this.i18nExists(str)?loadTimeData.getString(str):str))}return this.i18nDynamic(locale,id,...args)}i18nExists(id){return loadTimeData.valueExists(id)}}return I18nMixinLit};var TabUploadOrigin;(function(TabUploadOrigin){TabUploadOrigin[TabUploadOrigin["CONTEXT_MENU"]=0]="CONTEXT_MENU";TabUploadOrigin[TabUploadOrigin["RECENT_TAB_CHIP"]=1]="RECENT_TAB_CHIP";TabUploadOrigin[TabUploadOrigin["ACTION_CHIP"]=2]="ACTION_CHIP";TabUploadOrigin[TabUploadOrigin["OTHER"]=3]="OTHER"})(TabUploadOrigin||(TabUploadOrigin={}));function recordContextAdditionMethod(additionMethod,composeboxSource){if(!chrome.metricsPrivate){return}chrome.metricsPrivate.recordEnumerationValue("ContextualSearch.ContextAdded.ContextAddedMethod."+composeboxSource,additionMethod,3+1)}let instance$y=null;function getCss$r(){return instance$y||(instance$y=[...[],css`.icon-arrow-back{--cr-icon-image:url(//resources/images/icon_arrow_back.svg)}.icon-arrow-dropdown{--cr-icon-image:url(//resources/images/icon_arrow_dropdown.svg)}.icon-arrow-drop-down-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_down_cr23.svg)}.icon-arrow-drop-up-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_up_cr23.svg)}.icon-arrow-upward{--cr-icon-image:url(//resources/images/icon_arrow_upward.svg)}.icon-cancel{--cr-icon-image:url(//resources/images/icon_cancel.svg)}.icon-clear{--cr-icon-image:url(//resources/images/icon_clear.svg)}.icon-copy-content{--cr-icon-image:url(//resources/images/icon_copy_content.svg)}.icon-delete-gray{--cr-icon-image:url(//resources/images/icon_delete_gray.svg)}.icon-edit{--cr-icon-image:url(//resources/images/icon_edit.svg)}.icon-file{--cr-icon-image:url(//resources/images/icon_filetype_generic.svg)}.icon-folder-open{--cr-icon-image:url(//resources/images/icon_folder_open.svg)}.icon-picture-delete{--cr-icon-image:url(//resources/images/icon_picture_delete.svg)}.icon-expand-less{--cr-icon-image:url(//resources/images/icon_expand_less.svg)}.icon-expand-more{--cr-icon-image:url(//resources/images/icon_expand_more.svg)}.icon-external{--cr-icon-image:url(//resources/images/open_in_new.svg)}.icon-more-vert{--cr-icon-image:url(//resources/images/icon_more_vert.svg)}.icon-refresh{--cr-icon-image:url(//resources/images/icon_refresh.svg)}.icon-search{--cr-icon-image:url(//resources/images/icon_search.svg)}.icon-settings{--cr-icon-image:url(//resources/images/icon_settings.svg)}.icon-visibility{--cr-icon-image:url(//resources/images/icon_visibility.svg)}.icon-visibility-off{--cr-icon-image:url(//resources/images/icon_visibility_off.svg)}.subpage-arrow{--cr-icon-image:url(//resources/images/arrow_right.svg)}.cr-icon{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-size);background-color:var(--cr-icon-color,var(--owl-control-accent-color,var(--google-grey-700)));flex-shrink:0;height:var(--cr-icon-ripple-size);margin-inline-end:var(--cr-icon-ripple-margin);margin-inline-start:var(--cr-icon-button-margin-start);user-select:none;width:var(--cr-icon-ripple-size)}:host-context([dir=rtl]) .cr-icon{transform:scaleX(-1)}.cr-icon.no-overlap{margin-inline-end:0;margin-inline-start:0}@media (prefers-color-scheme:dark){.cr-icon{background-color:var(--cr-icon-color,var(--owl-control-accent-color,var(--google-grey-500)))}}`])}let instance$x=null;function getCss$q(){return instance$x||(instance$x=[...[getCss$r()],css`:host{--button-height:36px;--cr-focus-outline-color:var(--color-searchbox-results-icon-focused-outline);--duration:1800ms;--fulfillment-background:#fff;--glif-gradient:conic-gradient(#3186ff00 0deg,#34a853ff 43deg,#ffd314ff 65deg,#ff4641ff 105deg,#3186ffff 144deg,#3186ffff 150deg,#3186ff00 250deg);--gradient-width:2px;--input-background:#fff;--input-foreground:#0a0a0a;--standard-curve:cubic-bezier(0.4,0,0.2,1);--text-animation-curve:cubic-bezier(0.38,0.72,0,1)}.glow-container{display:inline-block;height:var(--button-height);margin-left:2px;position:relative;width:var(--button-height)}cr-button#entrypoint.ai-mode-button{width:max-content}@keyframes slide-in{to{transform:translateX(0px)}}@keyframes fade-in{to{opacity:1}}:host([glif-animation-state="spinner-only"]) #description{opacity:0}:host([glif-animation-state="started"]) #description{animation:slide-in 1000ms 820ms var(--text-animation-curve) forwards,fade-in 850ms 970ms var(--text-animation-curve) forwards;opacity:0;transform:translateX(-12px)}#entrypoint.ai-mode-button{position:relative;z-index:5}.aim-c{border-radius:100%;inset:0;pointer-events:none;position:absolute}.aim-gradient-outer-blur,.aim-gradient-solid{inset:0;overflow:hidden;pointer-events:none;position:absolute}.aim-gradient-outer-blur:before,.aim-gradient-solid:before{background:var(--glif-gradient);bottom:0;content:"";height:200%;left:0;opacity:0;position:absolute;right:0;scale:2 2;top:-50%}.aim-gradient-outer-blur{filter:blur(2px);opacity:0.35;transform:translate3d(0px,0px,0px)}.dark .aim-gradient-outer-blur{filter:blur(3px);opacity:0.7}@keyframes rotate-gradient{from{transform:rotate(0deg)}to{transform:rotate(360deg)}}.aim-gradient-outer-blur,.aim-gradient-solid{animation:rotate-gradient calc(var(--duration) / 1.5) var(--standard-curve) infinite}:host([glif-animation-state="finished"]) .aim-gradient-outer-blur,:host([glif-animation-state="ineligible"]) .aim-gradient-outer-blur,:host([glif-animation-state="finished"]) .aim-gradient-solid,:host([glif-animation-state="ineligible"]) .aim-gradient-solid{animation-play-state:paused;opacity:0}@keyframes fade-out-only{0%{opacity:1}50%{opacity:1}100%{opacity:0}}:host([glif-animation-state="started"]) .aim-gradient-outer-blur:before,:host([glif-animation-state="started"]) .aim-gradient-solid:before{opacity:1;animation:fade-out-only var(--duration) linear forwards}@keyframes opacity-fade-in-and-stay{from{opacity:0}to{opacity:1}}:host([glif-animation-state="spinner-only"]) .aim-gradient-outer-blur:before,:host([glif-animation-state="spinner-only"]) .aim-gradient-solid:before{animation:opacity-fade-in-and-stay 300ms linear forwards}:host([glif-animation-state="finished"]) .aim-gradient-outer-blur:before,:host([glif-animation-state="finished"]) .aim-gradient-solid:before{opacity:0}:host([glif-animation-state="spinner-only"]) .aim-background{animation:opacity-fade-in-and-stay 300ms linear forwards;background-color:var(--fulfillment-background)}.aim-background{background-color:var(--input-background);clip-path:inset(0 0 0 0 round calc(var(--button-height) * 2));filter:blur(4px);inset:var(--gradient-width);position:absolute}:host([glif-animation-state="started"]) .aim-background{animation:background-fade var(--duration) linear forwards}:host([glif-animation-state="finished"]) .aim-background{opacity:0}@keyframes background-fade{0%{background:var(--fulfillment-background)}50%{background:var(--fulfillment-background)}100%{background:var(--input-background)}}@keyframes hover-background-delay{to{--cr-hover-background-color:var(--color-composebox-context-entrypoint-hover-background)}}#entrypoint{--cr-button-disabled-text-color:var(--color-composebox-context-entrypoint-text-disabled);--cr-button-text-color:var(--color-composebox-file-chip-text);--cr-hover-background-color:var(--cr-icon-button-hover-background-color);--cr-icon-button-margin-start:6px;--icon-block-padding-small:10px;border:initial;gap:4px}:host(:not([glif-animation-state="ineligible"])) #entrypoint{--cr-hover-background-color:transparent;animation:hover-background-delay 0ms 1850ms linear forwards;--icon-block-padding-small:8px}#entrypoint:not([disabled]){--cr-icon-button-fill-color:var(--composebox-context-menu-entrypoint-button-color,var(--cr-button-text-color))}#entrypoint.menu-open{--cr-hover-background-color:var(--cr-icon-button-hover-background-color);background-color:var(--cr-icon-button-hover-background-color)}#description{display:block;font-size:13px}#menu{--color-sys-divider:var(--color-composebox-file-carousel-divider);--cr-action-menu-overflow:visible;--cr-menu-background-color:var(--color-composebox-background);--cr-menu-border-radius:16px;--cr-primary-text-color:var(--color-composebox-file-chip-text);--cr-hover-background-color:var(--color-composebox-context-entrypoint-hover-background)}.suggestion-container{position:relative}.tab-preview{background-color:var(--color-sys-surface-container-high);border-radius:12px;border:1px solid var(--color-sys-outline);box-shadow:0 4px 12px 0 rgba(0,0,0,0.15);display:none;height:125px;inset-inline-start:100%;margin-inline-start:8px;object-fit:cover;object-position:top;position:absolute;top:50%;transform:translateY(-50%);width:200px}.dropdown-item:hover+.tab-preview{display:block}#tabHeader{color:var(--cr-primary-text-color);font-size:11px;font-weight:500;line-height:16px;margin:0;padding:8px 14px 4px 14px}.dropdown-item{--iron-icon-height:16px;--iron-icon-width:16px;align-items:center;background:transparent;border:none;color:var(--cr-primary-text-color);cursor:pointer;display:flex;font-size:13px;font-weight:400;gap:8px;height:32px;justify-content:flex-start;max-width:320px;padding:6px 14px;text-align:left;width:100%}:host([enable-multi-tab-selection_]) .dropdown-item{width:320px}.dropdown-item:hover{background-color:var(--cr-hover-background-color)}.dropdown-item[disabled]{color:var(--color-composebox-context-entrypoint-text-disabled);cursor:default}.dropdown-item[disabled]:hover{background-color:transparent}#menu hr{background:var(--color-sys-divider);border:none;height:1px;margin:8px 0}.tab-title{display:block;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}#createImage{--iron-icon-height:16px;--iron-icon-width:16px}.multi-tab-icon{--iron-icon-height:10px;--iron-icon-width:10px;border-radius:10px;flex-shrink:0;margin-left:auto;padding:2px}#multi-tab-add{border:1px solid}#multi-tab-check{--iron-icon-fill-color:white;background-color:var(--color-composebox-tab-selector-button-selected)}@media (forced-colors:active){#entrypoint:not([disabled]){--cr-button-text-color:ButtonText;--cr-icon-button-fill-color:ButtonText}#entrypoint{background-color:ButtonFace;border:1px solid ButtonText;box-sizing:border-box}}`])}function getHtml$n(){const entrypointButton=!this.hideEntrypointButton?html`
    ${this.showContextMenuDescription?html`
    <cr-button id="entrypoint"
        class="ai-mode-button"
        @click="${this.onEntrypointClick_}"
        ?disabled="${this.inputsDisabled}"
        title="${this.i18n("addContextTitle")}"
        noink>
      <cr-icon id="entrypointIcon" icon="cr:add" slot="prefix-icon"></cr-icon>
      <span id="description"
        @animationend="${e=>{this.onAnimationEnd_(e,"slide-in")}}">
          ${this.i18n("addContext")}
      </span>
    </cr-button>`:html`
    <cr-icon-button id="entrypoint"
        class="ai-mode-button"
        part="context-menu-entrypoint-icon"
        iron-icon="cr:add"
        @click="${this.onEntrypointClick_}"
        ?disabled="${this.inputsDisabled}"
        title="${this.i18n("addContextTitle")}"
        noink>
    </cr-icon-button>`}`:"";return html`<!--_html_template_start_-->
    ${this.glifAnimationState!==GlifAnimationState.INELIGIBLE?html`
    <div id="glowWrapper" class="glow-container">
      ${entrypointButton}
      <div class="aim-gradient-outer-blur aim-c"></div>
      <div class="aim-gradient-solid aim-c"></div>
      <div class="aim-background aim-c"
        @animationend="${this.showContextMenuDescription?nothing:e=>{this.onAnimationEnd_(e,"background-fade")}}"></div>
    </div>
    `:entrypointButton}

  <cr-action-menu id="menu" role-description="${this.i18n("menu")}"
      @close="${this.onMenuClose_}">
    ${this.tabSuggestions?.length>0?html`
      <h4 id="tabHeader">${this.i18n("addTab")}</h4>
      ${this.tabSuggestions.map(((tab,index)=>html`
        <div class="suggestion-container">
          <button class="dropdown-item"
              title="${tab.title}" data-index="${index}"
              aria-label="${this.i18n("addTab")}, ${tab.title}"
              ?disabled="${this.isTabDisabled_(tab)}"
              @pointerenter="${this.onTabPointerenter_}"
              @click="${this.onTabClick_}">
            <cr-composebox-tab-favicon .url="${tab.url.url}">
            </cr-composebox-tab-favicon>
            <span class="tab-title">${tab.title}</span>
            ${this.enableMultiTabSelection_?html`
              ${this.disabledTabIds.has(tab.tabId)?html`
                <cr-icon class="multi-tab-icon"
                    icon="cr:check" id="multi-tab-check"></cr-icon>
              `:html`
                <cr-icon class="multi-tab-icon"
                    icon="cr:add" id="multi-tab-add"></cr-icon>
              `}
            `:""}
          </button>
          ${this.shouldShowTabPreview_()?html`
            <img class="tab-preview" .src="${this.tabPreviewUrl_}">
          `:""}
        </div>
      `))}
      <hr/>
    `:""}
    <button id="imageUpload" class="dropdown-item"
        @click="${this.openImageUpload_}"
         ?disabled="${this.imageUploadDisabled_}">
      <cr-icon icon="composebox:imageUpload"></cr-icon>
      ${this.i18n("addImage")}
    </button>
    ${this.pdfUploadEnabled_?html`<button id="fileUpload" class="dropdown-item"
        @click="${this.openFileUpload_}"
        ?disabled="${this.fileUploadDisabled_}">
      <cr-icon icon="composebox:fileUpload"></cr-icon>
      ${this.i18n("uploadFile")}
    </button>`:""}
    ${this.showDeepSearch_||this.showCreateImage_?html`<hr/>`:""}
    ${this.showDeepSearch_?html`<button id="deepSearch" class="dropdown-item"
        @click="${this.onDeepSearchClick_}"
        ?disabled="${this.deepSearchDisabled_}">
      <cr-icon icon="composebox:deepSearch"></cr-icon>
      ${this.i18n("deepSearch")}
    </button>`:""}
    ${this.showCreateImage_?html`<button id="createImage" class="dropdown-item"
        @click="${this.onCreateImageClick_}"
        ?disabled="${this.createImageDisabled_}">
      <cr-icon icon="composebox:nanoBanana"></cr-icon>
      ${this.i18n("createImages")}
    </button>`:""}
  </cr-action-menu>
<!--_html_template_end_-->`}const MENU_WIDTH_PX=190;const TALL_BOTTOM_CONTEXT_LAYOUT_MODE="TallBottomContext";var GlifAnimationState;(function(GlifAnimationState){GlifAnimationState["INELIGIBLE"]="ineligible";GlifAnimationState["SPINNER_ONLY"]="spinner-only";GlifAnimationState["STARTED"]="started";GlifAnimationState["FINISHED"]="finished"})(GlifAnimationState||(GlifAnimationState={}));const ContextMenuEntrypointElementBase=I18nMixinLit(CrLitElement);class ContextMenuEntrypointElement extends ContextMenuEntrypointElementBase{static get is(){return"cr-composebox-context-menu-entrypoint"}static get styles(){return getCss$q()}render(){return getHtml$n.bind(this)()}static get properties(){return{inputsDisabled:{type:Boolean},fileNum:{type:Number},showContextMenuDescription:{type:Boolean},inCreateImageMode:{reflect:true,type:Boolean},hasImageFiles:{reflect:true,type:Boolean},hideEntrypointButton:{type:Boolean},disabledTabIds:{type:Object},tabSuggestions:{type:Array},entrypointName:{type:String},searchboxLayoutMode:{type:String},glifAnimationState:{type:String,reflect:true},enableMultiTabSelection_:{reflect:true,type:Boolean},tabPreviewUrl_:{type:String},tabPreviewsEnabled_:{type:Boolean},showDeepSearch_:{reflect:true,type:Boolean},showCreateImage_:{reflect:true,type:Boolean},pdfUploadEnabled_:{type:Boolean}}}#inputsDisabled_accessor_storage=false;get inputsDisabled(){return this.#inputsDisabled_accessor_storage}set inputsDisabled(value){this.#inputsDisabled_accessor_storage=value}#fileNum_accessor_storage=0;get fileNum(){return this.#fileNum_accessor_storage}set fileNum(value){this.#fileNum_accessor_storage=value}#showContextMenuDescription_accessor_storage=false;get showContextMenuDescription(){return this.#showContextMenuDescription_accessor_storage}set showContextMenuDescription(value){this.#showContextMenuDescription_accessor_storage=value}#inCreateImageMode_accessor_storage=false;get inCreateImageMode(){return this.#inCreateImageMode_accessor_storage}set inCreateImageMode(value){this.#inCreateImageMode_accessor_storage=value}#hasImageFiles_accessor_storage=false;get hasImageFiles(){return this.#hasImageFiles_accessor_storage}set hasImageFiles(value){this.#hasImageFiles_accessor_storage=value}#hideEntrypointButton_accessor_storage=false;get hideEntrypointButton(){return this.#hideEntrypointButton_accessor_storage}set hideEntrypointButton(value){this.#hideEntrypointButton_accessor_storage=value}#disabledTabIds_accessor_storage=new Map;get disabledTabIds(){return this.#disabledTabIds_accessor_storage}set disabledTabIds(value){this.#disabledTabIds_accessor_storage=value}#tabSuggestions_accessor_storage=[];get tabSuggestions(){return this.#tabSuggestions_accessor_storage}set tabSuggestions(value){this.#tabSuggestions_accessor_storage=value}#entrypointName_accessor_storage="";get entrypointName(){return this.#entrypointName_accessor_storage}set entrypointName(value){this.#entrypointName_accessor_storage=value}#searchboxLayoutMode_accessor_storage="";get searchboxLayoutMode(){return this.#searchboxLayoutMode_accessor_storage}set searchboxLayoutMode(value){this.#searchboxLayoutMode_accessor_storage=value}#glifAnimationState_accessor_storage=GlifAnimationState.INELIGIBLE;get glifAnimationState(){return this.#glifAnimationState_accessor_storage}set glifAnimationState(value){this.#glifAnimationState_accessor_storage=value}#enableMultiTabSelection__accessor_storage=loadTimeData.getBoolean("composeboxContextMenuEnableMultiTabSelection");get enableMultiTabSelection_(){return this.#enableMultiTabSelection__accessor_storage}set enableMultiTabSelection_(value){this.#enableMultiTabSelection__accessor_storage=value}#tabPreviewUrl__accessor_storage="";get tabPreviewUrl_(){return this.#tabPreviewUrl__accessor_storage}set tabPreviewUrl_(value){this.#tabPreviewUrl__accessor_storage=value}#tabPreviewsEnabled__accessor_storage=loadTimeData.getBoolean("composeboxShowContextMenuTabPreviews");get tabPreviewsEnabled_(){return this.#tabPreviewsEnabled__accessor_storage}set tabPreviewsEnabled_(value){this.#tabPreviewsEnabled__accessor_storage=value}#showDeepSearch__accessor_storage=loadTimeData.getBoolean("composeboxShowDeepSearchButton");get showDeepSearch_(){return this.#showDeepSearch__accessor_storage}set showDeepSearch_(value){this.#showDeepSearch__accessor_storage=value}#showCreateImage__accessor_storage=loadTimeData.getBoolean("composeboxShowCreateImageButton");get showCreateImage_(){return this.#showCreateImage__accessor_storage}set showCreateImage_(value){this.#showCreateImage__accessor_storage=value}#pdfUploadEnabled__accessor_storage=loadTimeData.getBoolean("composeboxShowPdfUpload");get pdfUploadEnabled_(){return this.#pdfUploadEnabled__accessor_storage}set pdfUploadEnabled_(value){this.#pdfUploadEnabled__accessor_storage=value}maxFileCount_=loadTimeData.getInteger("composeboxFileMaxCount");metricsSource_=loadTimeData.getString("composeboxSource");constructor(){super()}openMenuForMultiSelection(){if(this.enableMultiTabSelection_&&this.searchboxLayoutMode!==TALL_BOTTOM_CONTEXT_LAYOUT_MODE){this.updateComplete.then(this.showMenuAtEntrypoint_.bind(this))}}closeMenu(){this.$.menu.close()}get imageUploadDisabled_(){return this.fileNum>=this.maxFileCount_||this.inCreateImageMode&&this.hasImageFiles}get fileUploadDisabled_(){return this.inCreateImageMode||this.fileNum>=this.maxFileCount_}get deepSearchDisabled_(){return this.inCreateImageMode||this.fileNum===1||this.fileNum>1}get createImageDisabled_(){return this.inCreateImageMode||this.fileNum>1||this.fileNum===1&&!this.hasImageFiles}isTabDisabled_(tab){const noNewContextAllowed=this.inCreateImageMode||this.fileNum>=this.maxFileCount_;const isTabInContext=this.disabledTabIds.has(tab.tabId);if(this.enableMultiTabSelection_){return noNewContextAllowed&&!isTabInContext}return noNewContextAllowed||isTabInContext}onEntrypointClick_(e){e.stopPropagation();const metricName="ContextualSearch.ContextMenuEntry.Clicked."+this.metricsSource_;chrome.metricsPrivate.recordBoolean(metricName,true);const entrypoint=this.shadowRoot.querySelector("#entrypoint");assert(entrypoint);this.fire("context-menu-entrypoint-click",{x:entrypoint.getBoundingClientRect().left,y:entrypoint.getBoundingClientRect().bottom});if(this.entrypointName!=="Omnibox"){this.showMenuAtEntrypoint_()}}onTabClick_(e){e.stopPropagation();const tabElement=e.currentTarget;const tabInfo=this.tabSuggestions[Number(tabElement.dataset["index"])];assert(tabInfo);if(this.enableMultiTabSelection_&&this.disabledTabIds.has(tabInfo.tabId)){this.deleteTabContext_(this.disabledTabIds.get(tabInfo.tabId));return}this.addTabContext_(tabInfo);recordContextAdditionMethod(0,this.metricsSource_)}deleteTabContext_(uuid){this.fire("delete-tab-context",{uuid:uuid});if(this.searchboxLayoutMode===TALL_BOTTOM_CONTEXT_LAYOUT_MODE){this.$.menu.close()}}addTabContext_(tabInfo){this.fire("add-tab-context",{id:tabInfo.tabId,title:tabInfo.title,url:tabInfo.url,delayUpload:false,origin:TabUploadOrigin.CONTEXT_MENU});if(!this.enableMultiTabSelection_||this.entrypointName==="Realbox"||this.searchboxLayoutMode===TALL_BOTTOM_CONTEXT_LAYOUT_MODE){this.$.menu.close()}}onTabPointerenter_(e){if(!this.tabPreviewsEnabled_){return}const tabElement=e.currentTarget;const tabInfo=this.tabSuggestions[Number(tabElement.dataset["index"])];assert(tabInfo);this.tabPreviewUrl_="";this.fire("get-tab-preview",{tabId:tabInfo.tabId,onPreviewFetched:previewDataUrl=>{this.tabPreviewUrl_=previewDataUrl}})}shouldShowTabPreview_(){return this.tabPreviewsEnabled_&&this.tabPreviewUrl_!==""}openImageUpload_(){this.fire("open-image-upload");this.$.menu.close()}openFileUpload_(){this.fire("open-file-upload");this.$.menu.close()}onDeepSearchClick_(){this.fire("deep-search-click");this.$.menu.close()}onCreateImageClick_(){this.fire("create-image-click");this.$.menu.close()}onAnimationEnd_(e,animationName){if(e.animationName===animationName){this.glifAnimationState=GlifAnimationState.FINISHED}}onMenuClose_(){const entrypoint=this.shadowRoot.querySelector("#entrypoint");assert(entrypoint);entrypoint.classList.remove("menu-open")}showMenuAtEntrypoint_(){const entrypoint=this.shadowRoot.querySelector("#entrypoint");assert(entrypoint);entrypoint?.classList.add("menu-open");this.$.menu.showAt(entrypoint,{top:entrypoint.getBoundingClientRect().bottom,width:MENU_WIDTH_PX,anchorAlignmentX:AnchorAlignment["AFTER_START"]})}}customElements.define(ContextMenuEntrypointElement.is,ContextMenuEntrypointElement);let instance$w=null;function getCss$p(){return instance$w||(instance$w=[...[],css`#lensSearch{--cr-button-border-color:var(--color-composebox-lens-search-button-border-color);--cr-button-text-color:var(--composebox-lens-search-button-text-color);--cr-button-disabled-text-color:var(--color-composebox-context-entrypoint-text-disabled);--cr-hover-background-color:var(--color-composebox-context-entrypoint-hover-background);--cr-button-height:28px;align-items:center;border-radius:8px;display:inline-flex;font-size:12px;justify-content:center;padding:6px 8px}#content{align-items:center;display:flex;gap:4px;justify-content:center}#icon{color:var(--composebox-lens-search-icon-color);height:16px;width:16px}`])}function getHtml$m(){return html`
  <cr-button id="lensSearch"
      aria-label="${this.i18n("lensSearchLabel")}" title="${this.i18n("lensSearchLabel")}"
      @click="${this.onLensSearchClick_}">
    <div id="content">
      <cr-icon id="icon" icon="composebox:google-lens-2"></cr-icon>
      <div>${this.i18n("lensSearchLabel")}</div>
    </div>
  </cr-button>`}class ComposeboxLensSearchElement extends(I18nMixinLit(CrLitElement)){static get is(){return"cr-composebox-lens-search"}static get styles(){return getCss$p()}render(){return getHtml$m.bind(this)()}onLensSearchClick_(e){e.stopPropagation();this.fire("lens-search-click")}}customElements.define(ComposeboxLensSearchElement.is,ComposeboxLensSearchElement);({$:mojo.internal.Enum()});var FileUploadStatus$1;(function(FileUploadStatus){FileUploadStatus[FileUploadStatus["MIN_VALUE"]=0]="MIN_VALUE";FileUploadStatus[FileUploadStatus["MAX_VALUE"]=7]="MAX_VALUE";FileUploadStatus[FileUploadStatus["kNotUploaded"]=0]="kNotUploaded";FileUploadStatus[FileUploadStatus["kProcessing"]=1]="kProcessing";FileUploadStatus[FileUploadStatus["kValidationFailed"]=2]="kValidationFailed";FileUploadStatus[FileUploadStatus["kUploadStarted"]=3]="kUploadStarted";FileUploadStatus[FileUploadStatus["kUploadSuccessful"]=4]="kUploadSuccessful";FileUploadStatus[FileUploadStatus["kUploadFailed"]=5]="kUploadFailed";FileUploadStatus[FileUploadStatus["kUploadExpired"]=6]="kUploadExpired";FileUploadStatus[FileUploadStatus["kProcessingSuggestSignalsReady"]=7]="kProcessingSuggestSignalsReady"})(FileUploadStatus$1||(FileUploadStatus$1={}));({$:mojo.internal.Enum()});var FileUploadErrorType$1;(function(FileUploadErrorType){FileUploadErrorType[FileUploadErrorType["MIN_VALUE"]=0]="MIN_VALUE";FileUploadErrorType[FileUploadErrorType["MAX_VALUE"]=6]="MAX_VALUE";FileUploadErrorType[FileUploadErrorType["kUnknown"]=0]="kUnknown";FileUploadErrorType[FileUploadErrorType["kBrowserProcessingError"]=1]="kBrowserProcessingError";FileUploadErrorType[FileUploadErrorType["kNetworkError"]=2]="kNetworkError";FileUploadErrorType[FileUploadErrorType["kServerError"]=3]="kServerError";FileUploadErrorType[FileUploadErrorType["kServerSizeLimitExceeded"]=4]="kServerSizeLimitExceeded";FileUploadErrorType[FileUploadErrorType["kAborted"]=5]="kAborted";FileUploadErrorType[FileUploadErrorType["kImageProcessingError"]=6]="kImageProcessingError"})(FileUploadErrorType$1||(FileUploadErrorType$1={}));let instance$v=null;function getCss$o(){return instance$v||(instance$v=[...[],css`@keyframes spin{0%{transform:rotate(0deg)}100%{transform:rotate(360deg)}}.spinner{height:20px;width:20px}.spinner-circle{animation:spin 1.5s linear infinite;fill:none;stroke:var(--color-composebox-file-chip-spinner);stroke-dasharray:240;stroke-dashoffset:60;stroke-linecap:round;stroke-width:10;transform-origin:50% 50%}.img-thumbnail{height:100%;object-fit:cover;object-position:center;width:100%}#imgChip{align-items:center;border-radius:8px;display:flex;height:var(--composebox-thumbnail-img-chip-size,44px);justify-content:center;overflow:hidden;position:relative;width:var(--composebox-thumbnail-img-chip-size,44px)}.img-overlay{background-color:var(--color-composebox-file-image-overlay);height:100%;left:0;opacity:0;position:absolute;top:0;width:100%}#removeImgButton{--cr-icon-button-height:100%;--cr-icon-button-width:100%;--cr-icon-button-fill-color:white;--cr-icon-button-icon-size:20px;--cr-icon-button-margin-start:0px;border-radius:10px;display:flex}.chip{align-items:center;background-color:var(--color-composebox-file-chip-background);border-radius:8px;display:flex;gap:6px;height:44px;overflow:hidden;padding:0px 12px 0px 8px;position:relative;width:var(--thumbnail-chip-width,154px)}.thumbnail{align-items:center;background-color:var(--color-composebox-file-chip-favicon-background);border-radius:4px;display:flex;flex-shrink:0;height:16px;justify-content:center;padding:var(--thumbnail-chip-padding,6px);position:relative;width:var(--thumbnail-chip-icon-size,16px)}.pdf-icon{background-color:var(--color-composebox-pdf-chip-icon-background,--color-composebox-background);border-radius:var(--pdf-icon-border-radius,4px);box-sizing:border-box;border-radius:var(--pdf-icon-border-radius,4px);color:var(--color-composebox-pdf-chip-icon-border);height:var(--pdf-icon-size,100%);width:var(--pdf-icon-size,100%)}.chip-overlay{border-radius:inherit;inset:0;display:none;pointer-events:none;position:absolute}.chip:hover .chip-overlay{display:block}.overlay{align-items:center;display:flex;height:100%;justify-content:center;opacity:0;position:absolute;inset-inline-end:0;top:0;width:var(--thumbnail-chip-overlay-width,44px)}.gradient-protection{background:linear-gradient(270deg,var(--color-composebox-file-carousel-remove-gradient-start) 85.29%,var(--color-composebox-file-carousel-remove-gradient-end) 123.53%);border-radius:0 8px 8px 0;inline-size:var(--gradient-protection-width,56px);inset-block:0;inset-inline-end:0;pointer-events:none;position:absolute}.remove-button{--cr-icon-button-fill-color:var(--cr-composebox-file-thumbnail-remove-button-fill-color,black);--cr-icon-button-hover-background-color:var(--color-composebox-file-carousel-remove-button);--cr-icon-button-height:var(--remove-button-height,24px);--cr-icon-button-width:var(--remove-button-width,24px);--cr-icon-button-icon-size:16px;--cr-icon-button-margin-start:0;background-color:var(--color-composebox-file-carousel-remove-button);border-radius:var(--remove-button-border-radius,50%);inset-inline-end:var(--remove-button-inset-inline-end,0);color:var(--color-composebox-pdf-chip-icon);position:relative}:host-context([dir='rtl']) .gradient-protection{transform:scaleX(-1)}.title{color:var(--color-composebox-file-chip-text);font-family:inherit;font-size:var(--cr-composebox-file-chip-title-text-size,12px);font-style:normal;font-weight:500;line-height:16px;overflow:hidden;position:relative;text-overflow:ellipsis;white-space:nowrap}#imgChip:hover .img-overlay,#imgChip:focus-within .img-overlay,.chip:hover .overlay,.chip:focus-within .overlay{opacity:1}#tabThumbnail cr-composebox-tab-favicon{border-radius:50%;height:16px;width:16px}.tabInfo{display:flex;flex-direction:column;min-width:0}.url{color:var(--color-composebox-file-carousel-url);font-size:var(--cr-composebox-file-chip-url-text-size,12px);font-weight:500;line-height:16px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}@media (forced-colors:active){.remove-button{--cr-icon-button-fill-color:ButtonText;--cr-icon-button-hover-background-color:ButtonFace;border:1px solid ButtonText;box-sizing:border-box}}`])}function getHtml$l(){return html`<!--_html_template_start_-->
<div id="container">
  ${this.file.url?html`
    <div id="tabChip" class="chip">
      <div id="tabThumbnail" class="thumbnail">
        <cr-composebox-tab-favicon .url="${this.file.url.url}" .size="${24}">
        </cr-composebox-tab-favicon>
      </div>
      <div class="tabInfo">
        <div class="title">${this.file.name}</div>
        <div class="url">${this.formattedUrl_}</div>
      </div>
      <div class="overlay">
        <div class="gradient-protection"></div>
        ${this.file.isDeletable?html`<cr-icon-button
          id="removeTabButton"
          class="remove-button"
          iron-icon="cr:clear"
          title="${this.file.name}"
          aria-label="${this.deleteFileButtonTitle_}"
          @click="${this.deleteFile_}">
          </cr-icon-button>`:""}
      </div>
      <div class="chip-overlay"></div>
    </div>
  `:this.file.objectUrl||this.file.dataUrl?html`
    <div id="imgChip">
      ${this.file.status!==FileUploadStatus$1.kUploadSuccessful?html`
        <svg role="image" class="spinner" viewBox="0 0 100 100">
          <circle class="spinner-circle" cx="50" cy="50" r="40" />
        </svg>
      `:html`
        <img class="img-thumbnail"
          src="${this.file.objectUrl||this.file.dataUrl}"
          aria-label="${this.file.name}">
      `}
      ${this.file.isDeletable?html`<cr-icon-button
          class="img-overlay"
          id="removeImgButton"
          iron-icon="cr:clear"
          title="${this.file.name}"
          aria-label="${this.deleteFileButtonTitle_}"
          @click="${this.deleteFile_}">
      </cr-icon-button>`:""}
    </div>`:html`
    <div id="pdfChip" class="chip">
      <div id="pdfThumbnail" class="thumbnail" part="thumbnail">
        ${this.file.status===FileUploadStatus$1.kUploadSuccessful?html`
          <cr-icon icon="thumbnail:pdf" class="pdf-icon">
          </cr-icon>
        `:html`
          <svg class="spinner" viewBox="0 0 100 100">
            <circle class="spinner-circle" cx="50" cy="50" r="40" />
          </svg>
        `}
      </div>
      <p class="title" id="pdfTitle">${this.file.name}</p>
      <div class="overlay">
        <div class="gradient-protection"></div>
        ${this.file.isDeletable?html`<cr-icon-button
            id="removePdfButton"
            class="remove-button"
            iron-icon="cr:clear"
            title="${this.file.name}"
            aria-label="${this.deleteFileButtonTitle_}"
            @click="${this.deleteFile_}">
        </cr-icon-button>`:""}
      </div>
      <div class="chip-overlay"></div>
    </div>
  `}
</div>
<!--_html_template_end_-->`}class ComposeboxFileThumbnailElement extends CrLitElement{static get is(){return"cr-composebox-file-thumbnail"}static get styles(){return getCss$o()}render(){return getHtml$l.bind(this)()}static get properties(){return{file:{type:Object}}}#file_accessor_storage={name:"",type:"",objectUrl:null,dataUrl:null,uuid:"",status:FileUploadStatus$1.kNotUploaded,url:null,tabId:null,isDeletable:true};get file(){return this.#file_accessor_storage}set file(value){this.#file_accessor_storage=value}deleteFile_(){this.fire("delete-file",{uuid:this.file.uuid,fromUserAction:true})}get deleteFileButtonTitle_(){return loadTimeData.getStringF("composeboxDeleteFileTitle",this.file.name)}get formattedUrl_(){if(!this.file?.url){return null}const link=new URL(this.file.url.url);return(link.host+link.pathname).replace(/\/$/,"")}}customElements.define(ComposeboxFileThumbnailElement.is,ComposeboxFileThumbnailElement);let instance$u=null;function getCss$n(){return instance$u||(instance$u=[...[],css`:host{display:flex;flex-wrap:wrap;gap:6px;width:100%}`])}function getHtml$k(){return html`<!--_html_template_start_-->
${this.files.map((item=>html`
    <cr-composebox-file-thumbnail .file="${item}"
        exportparts="thumbnail">
    </cr-composebox-file-thumbnail>`))}
<!--_html_template_end_-->`}const DEBOUNCE_TIMEOUT_MS$1=20;const CAROUSEL_HEIGHT_PADDING=18;function debounce$1(context,func,delay){let timeout;return function(...args){clearTimeout(timeout);timeout=setTimeout((()=>func.apply(context,args)),delay)}}class ComposeboxFileCarouselElement extends CrLitElement{static get is(){return"cr-composebox-file-carousel"}static get styles(){return getCss$n()}render(){return getHtml$k.bind(this)()}static get properties(){return{files:{type:Array}}}#files_accessor_storage=[];get files(){return this.#files_accessor_storage}set files(value){this.#files_accessor_storage=value}resizeObserver_=null;getThumbnailElementByUuid(uuid){const thumbnails=this.shadowRoot.querySelectorAll("cr-composebox-file-thumbnail");for(const thumbnail of thumbnails){if(thumbnail.file.uuid===uuid){return thumbnail}}return null}connectedCallback(){super.connectedCallback();this.resizeObserver_=new ResizeObserver(debounce$1(this,(()=>{const height=this.clientHeight?this.clientHeight+CAROUSEL_HEIGHT_PADDING:0;this.dispatchEvent(new CustomEvent("carousel-resize",{bubbles:true,composed:true,detail:{height:height}}))}),DEBOUNCE_TIMEOUT_MS$1));this.resizeObserver_.observe(this)}disconnectedCallback(){super.disconnectedCallback();if(this.resizeObserver_){this.resizeObserver_.disconnect();this.resizeObserver_=null}}}customElements.define(ComposeboxFileCarouselElement.is,ComposeboxFileCarouselElement);let instance$t=null;function getCss$m(){return instance$t||(instance$t=[...[getCss$r()],css`:host .button-content{display:flex;align-items:center;gap:4px}#recentTabButton{border-radius:8px;font-size:12px;font-weight:500;height:28px;line-height:18px;padding:6px 8px;--cr-button-border-color:var(--color-composebox-recent-tab-chip-outline);--cr-button-text-color:var(--color-composebox-context-entrypoint-text);--cr-button-disabled-text-color:var(--color-composebox-context-entrypoint-text-disabled);--cr-hover-background-color:var(--color-composebox-context-entrypoint-hover-background)}@media (forced-colors:active){#recentTabButton{--cr-button-text-color:Highlight}}.favicon{border-radius:2px;height:16px;width:16px}`])}function getHtml$j(){return this.recentTab?html`<!--_html_template_start_-->
  <cr-button id="recentTabButton"
      @click="${this.addTabContext_}"
      title="${this.recentTabChipTitle_}"
      aria-label="${this.recentTab.showInCurrentTabChip?this.i18n("askAboutThisPageAriaLabel",this.recentTabChipTitle_):this.i18n("askAboutPreviousTabAriaLabel",this.recentTabChipTitle_)}">
    <div class="button-content">
      <cr-composebox-tab-favicon
          class="favicon"
          .url="${this.recentTab.url?.url}">
      </cr-composebox-tab-favicon>
      <span class="recent-tab-button-text">
        ${this.recentTab.showInCurrentTabChip?this.i18n("askAboutThisPage"):this.i18n("askAboutPreviousTab")}
      </span>
    </div>
  </cr-button>
<!--_html_template_end_-->`:""}const RecentTabChipBase=I18nMixinLit(CrLitElement);class RecentTabChipElement extends RecentTabChipBase{static get is(){return"composebox-recent-tab-chip"}static get styles(){return getCss$m()}render(){return getHtml$j.bind(this)()}static get properties(){return{recentTab:{type:Object}}}#recentTab_accessor_storage=undefined;get recentTab(){return this.#recentTab_accessor_storage}set recentTab(value){this.#recentTab_accessor_storage=value}delayTabUploads_=loadTimeData.getBoolean("addTabUploadDelayOnRecentTabChipClick");composeboxSource_=loadTimeData.getString("composeboxSource");get recentTabChipTitle_(){if(!this.recentTab){return""}const url=new URL(this.recentTab.url.url);const domain=url.hostname.replace(/^www\./,"");return`${this.recentTab.title} - ${domain}`}addTabContext_(e){e.stopPropagation();assert(this.recentTab);this.fire("add-tab-context",{id:this.recentTab.tabId,title:this.recentTab.title,url:this.recentTab.url,delayUpload:this.delayTabUploads_,origin:TabUploadOrigin.RECENT_TAB_CHIP});recordContextAdditionMethod(3,this.composeboxSource_)}}customElements.define(RecentTabChipElement.is,RecentTabChipElement);const BigBufferSharedMemoryRegionSpec={$:{}};const BigBufferSpec={$:{}};mojo.internal.Struct(BigBufferSharedMemoryRegionSpec.$,"BigBufferSharedMemoryRegion",[mojo.internal.StructField("bufferHandle",0,0,mojo.internal.Handle,null,false,0,undefined,undefined),mojo.internal.StructField("size",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Union(BigBufferSpec.$,"BigBuffer",{bytes:{ordinal:0,type:mojo.internal.Array(mojo.internal.Uint8,false)},sharedMemory:{ordinal:1,type:BigBufferSharedMemoryRegionSpec.$},invalidBuffer:{ordinal:2,type:mojo.internal.Bool}});var BigBufferFieldTags;(function(BigBufferFieldTags){BigBufferFieldTags[BigBufferFieldTags["BYTES"]=0]="BYTES";BigBufferFieldTags[BigBufferFieldTags["SHARED_MEMORY"]=1]="SHARED_MEMORY";BigBufferFieldTags[BigBufferFieldTags["INVALID_BUFFER"]=2]="INVALID_BUFFER"})(BigBufferFieldTags||(BigBufferFieldTags={}));class UnguessableTokenDataView{decoder_;version_;fieldSpecs_;constructor(decoder,version,fieldSpecs){this.decoder_=decoder;this.version_=version;this.fieldSpecs_=fieldSpecs}get high(){const field=this.fieldSpecs_[0];return mojo.internal.decodeStructField(this.decoder_,field,this.version_)}get low(){const field=this.fieldSpecs_[1];return mojo.internal.decodeStructField(this.decoder_,field,this.version_)}}const HEX_BASE=16;const TOKEN_COMPONENT_STR_LENGTH=64/4;class UnguessableTokenConverter{validate(token){if(token.length!==2*TOKEN_COMPONENT_STR_LENGTH){throw new Error("token is malformed: "+token)}if(token!==token.toUpperCase()){throw new Error("token is not uppercase: "+token)}}high(token){this.validate(token);return BigInt(`0x${token.slice(0,TOKEN_COMPONENT_STR_LENGTH)}`)}low(token){this.validate(token);return BigInt(`0x${token.slice(TOKEN_COMPONENT_STR_LENGTH)}`)}convert(view){return(view.high.toString(HEX_BASE).padStart(TOKEN_COMPONENT_STR_LENGTH,"0")+view.low.toString(HEX_BASE).padStart(TOKEN_COMPONENT_STR_LENGTH,"0")).toUpperCase()}}const UnguessableTokenSpec={$:{}};const converterForUnguessableToken=new UnguessableTokenConverter;mojo.internal.TypemappedStruct(UnguessableTokenSpec.$,"UnguessableToken",UnguessableTokenDataView,converterForUnguessableToken,[mojo.internal.StructField("high",0,0,mojo.internal.Uint64,BigInt(0),false,0,undefined,(value=>converterForUnguessableToken.high(value))),mojo.internal.StructField("low",8,0,mojo.internal.Uint64,BigInt(0),false,0,undefined,(value=>converterForUnguessableToken.low(value)))],[[0,24]]);const PointSpec={$:{}};const PointFSpec={$:{}};const Point3FSpec={$:{}};const SizeSpec={$:{}};const SizeFSpec={$:{}};const RectSpec={$:{}};const RectFSpec={$:{}};const InsetsSpec={$:{}};const InsetsFSpec={$:{}};const Vector2dSpec={$:{}};const Vector2dFSpec={$:{}};const Vector3dFSpec={$:{}};const QuaternionSpec={$:{}};const QuadFSpec={$:{}};const AxisTransform2dSpec={$:{}};mojo.internal.Struct(PointSpec.$,"Point",[mojo.internal.StructField("x",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PointFSpec.$,"PointF",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Point3FSpec.$,"Point3F",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("z",8,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(SizeSpec.$,"Size",[mojo.internal.StructField("width",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("height",4,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(SizeFSpec.$,"SizeF",[mojo.internal.StructField("width",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("height",4,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(RectSpec.$,"Rect",[mojo.internal.StructField("x",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("width",8,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("height",12,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(RectFSpec.$,"RectF",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("width",8,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("height",12,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(InsetsSpec.$,"Insets",[mojo.internal.StructField("top",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("left",4,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("bottom",8,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("right",12,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(InsetsFSpec.$,"InsetsF",[mojo.internal.StructField("top",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("left",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("bottom",8,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("right",12,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Vector2dSpec.$,"Vector2d",[mojo.internal.StructField("x",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Vector2dFSpec.$,"Vector2dF",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Vector3dFSpec.$,"Vector3dF",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("z",8,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(QuaternionSpec.$,"Quaternion",[mojo.internal.StructField("x",0,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("y",8,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("z",16,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("w",24,0,mojo.internal.Double,0,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(QuadFSpec.$,"QuadF",[mojo.internal.StructField("p1",0,0,PointFSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("p2",8,0,PointFSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("p3",16,0,PointFSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("p4",24,0,PointFSpec.$,null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(AxisTransform2dSpec.$,"AxisTransform2d",[mojo.internal.StructField("scale",0,0,Vector2dFSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("translation",8,0,Vector2dFSpec.$,null,false,0,undefined,undefined)],[[0,24]]);const FileUploadStatusSpec={$:mojo.internal.Enum()};var FileUploadStatus;(function(FileUploadStatus){FileUploadStatus[FileUploadStatus["MIN_VALUE"]=0]="MIN_VALUE";FileUploadStatus[FileUploadStatus["MAX_VALUE"]=7]="MAX_VALUE";FileUploadStatus[FileUploadStatus["kNotUploaded"]=0]="kNotUploaded";FileUploadStatus[FileUploadStatus["kProcessing"]=1]="kProcessing";FileUploadStatus[FileUploadStatus["kValidationFailed"]=2]="kValidationFailed";FileUploadStatus[FileUploadStatus["kUploadStarted"]=3]="kUploadStarted";FileUploadStatus[FileUploadStatus["kUploadSuccessful"]=4]="kUploadSuccessful";FileUploadStatus[FileUploadStatus["kUploadFailed"]=5]="kUploadFailed";FileUploadStatus[FileUploadStatus["kUploadExpired"]=6]="kUploadExpired";FileUploadStatus[FileUploadStatus["kProcessingSuggestSignalsReady"]=7]="kProcessingSuggestSignalsReady"})(FileUploadStatus||(FileUploadStatus={}));const FileUploadErrorTypeSpec={$:mojo.internal.Enum()};var FileUploadErrorType;(function(FileUploadErrorType){FileUploadErrorType[FileUploadErrorType["MIN_VALUE"]=0]="MIN_VALUE";FileUploadErrorType[FileUploadErrorType["MAX_VALUE"]=6]="MAX_VALUE";FileUploadErrorType[FileUploadErrorType["kUnknown"]=0]="kUnknown";FileUploadErrorType[FileUploadErrorType["kBrowserProcessingError"]=1]="kBrowserProcessingError";FileUploadErrorType[FileUploadErrorType["kNetworkError"]=2]="kNetworkError";FileUploadErrorType[FileUploadErrorType["kServerError"]=3]="kServerError";FileUploadErrorType[FileUploadErrorType["kServerSizeLimitExceeded"]=4]="kServerSizeLimitExceeded";FileUploadErrorType[FileUploadErrorType["kAborted"]=5]="kAborted";FileUploadErrorType[FileUploadErrorType["kImageProcessingError"]=6]="kImageProcessingError"})(FileUploadErrorType||(FileUploadErrorType={}));const NavigationPredictorSpec={$:mojo.internal.Enum()};var NavigationPredictor;(function(NavigationPredictor){NavigationPredictor[NavigationPredictor["MIN_VALUE"]=1]="MIN_VALUE";NavigationPredictor[NavigationPredictor["MAX_VALUE"]=3]="MAX_VALUE";NavigationPredictor[NavigationPredictor["kMouseDown"]=1]="kMouseDown";NavigationPredictor[NavigationPredictor["kUpOrDownArrowButton"]=2]="kUpOrDownArrowButton";NavigationPredictor[NavigationPredictor["kTouchDown"]=3]="kTouchDown"})(NavigationPredictor||(NavigationPredictor={}));({$:mojo.internal.Enum()});var PageClassification;(function(PageClassification){PageClassification[PageClassification["MIN_VALUE"]=0]="MIN_VALUE";PageClassification[PageClassification["MAX_VALUE"]=28]="MAX_VALUE";PageClassification[PageClassification["INVALID_SPEC"]=0]="INVALID_SPEC";PageClassification[PageClassification["NTP"]=1]="NTP";PageClassification[PageClassification["BLANK"]=2]="BLANK";PageClassification[PageClassification["HOME_PAGE"]=3]="HOME_PAGE";PageClassification[PageClassification["OTHER"]=4]="OTHER";PageClassification[PageClassification["SEARCH_RESULT_PAGE_DOING_SEARCH_TERM_REPLACEMENT"]=6]="SEARCH_RESULT_PAGE_DOING_SEARCH_TERM_REPLACEMENT";PageClassification[PageClassification["INSTANT_NTP_WITH_OMNIBOX_AS_STARTING_FOCUS"]=7]="INSTANT_NTP_WITH_OMNIBOX_AS_STARTING_FOCUS";PageClassification[PageClassification["SEARCH_RESULT_PAGE_NO_SEARCH_TERM_REPLACEMENT"]=9]="SEARCH_RESULT_PAGE_NO_SEARCH_TERM_REPLACEMENT";PageClassification[PageClassification["APP_HOME"]=10]="APP_HOME";PageClassification[PageClassification["APP_SEARCH"]=11]="APP_SEARCH";PageClassification[PageClassification["APP_MAPS"]=12]="APP_MAPS";PageClassification[PageClassification["SEARCH_BUTTON_AS_STARTING_FOCUS"]=13]="SEARCH_BUTTON_AS_STARTING_FOCUS";PageClassification[PageClassification["CHROMEOS_APP_LIST"]=14]="CHROMEOS_APP_LIST";PageClassification[PageClassification["NTP_REALBOX"]=15]="NTP_REALBOX";PageClassification[PageClassification["ANDROID_SEARCH_WIDGET"]=16]="ANDROID_SEARCH_WIDGET";PageClassification[PageClassification["ANDROID_SHORTCUTS_WIDGET"]=19]="ANDROID_SHORTCUTS_WIDGET";PageClassification[PageClassification["NTP_ZPS_PREFETCH"]=20]="NTP_ZPS_PREFETCH";PageClassification[PageClassification["JOURNEYS"]=21]="JOURNEYS";PageClassification[PageClassification["SRP_ZPS_PREFETCH"]=22]="SRP_ZPS_PREFETCH";PageClassification[PageClassification["OTHER_ZPS_PREFETCH"]=23]="OTHER_ZPS_PREFETCH";PageClassification[PageClassification["CONTEXTUAL_SEARCHBOX"]=24]="CONTEXTUAL_SEARCHBOX";PageClassification[PageClassification["SEARCH_SIDE_PANEL_SEARCHBOX"]=25]="SEARCH_SIDE_PANEL_SEARCHBOX";PageClassification[PageClassification["LENS_SIDE_PANEL_SEARCHBOX"]=26]="LENS_SIDE_PANEL_SEARCHBOX";PageClassification[PageClassification["SEARCH_RESULT_PAGE_ON_CCT"]=27]="SEARCH_RESULT_PAGE_ON_CCT";PageClassification[PageClassification["OTHER_ON_CCT"]=28]="OTHER_ON_CCT"})(PageClassification||(PageClassification={}));const ToolModeSpec={$:mojo.internal.Enum()};var ToolMode;(function(ToolMode){ToolMode[ToolMode["MIN_VALUE"]=0]="MIN_VALUE";ToolMode[ToolMode["MAX_VALUE"]=4]="MAX_VALUE";ToolMode[ToolMode["kDefault"]=0]="kDefault";ToolMode[ToolMode["kDeepSearch"]=1]="kDeepSearch";ToolMode[ToolMode["kCreateImage"]=4]="kCreateImage"})(ToolMode||(ToolMode={}));const SideTypeSpec={$:mojo.internal.Enum()};var SideType;(function(SideType){SideType[SideType["MIN_VALUE"]=0]="MIN_VALUE";SideType[SideType["MAX_VALUE"]=1]="MAX_VALUE";SideType[SideType["kDefaultPrimary"]=0]="kDefaultPrimary";SideType[SideType["kSecondary"]=1]="kSecondary"})(SideType||(SideType={}));const RenderTypeSpec={$:mojo.internal.Enum()};var RenderType;(function(RenderType){RenderType[RenderType["MIN_VALUE"]=0]="MIN_VALUE";RenderType[RenderType["MAX_VALUE"]=2]="MAX_VALUE";RenderType[RenderType["kDefaultVertical"]=0]="kDefaultVertical";RenderType[RenderType["kHorizontal"]=1]="kHorizontal";RenderType[RenderType["kGrid"]=2]="kGrid"})(RenderType||(RenderType={}));const SelectionLineStateSpec={$:mojo.internal.Enum()};var SelectionLineState;(function(SelectionLineState){SelectionLineState[SelectionLineState["MIN_VALUE"]=1]="MIN_VALUE";SelectionLineState[SelectionLineState["MAX_VALUE"]=4]="MAX_VALUE";SelectionLineState[SelectionLineState["kNormal"]=1]="kNormal";SelectionLineState[SelectionLineState["kKeywordMode"]=2]="kKeywordMode";SelectionLineState[SelectionLineState["kFocusedButtonAction"]=3]="kFocusedButtonAction";SelectionLineState[SelectionLineState["kFocusedButtonRemoveSuggestion"]=4]="kFocusedButtonRemoveSuggestion"})(SelectionLineState||(SelectionLineState={}));let PageHandlerPendingReceiver$2=class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"searchbox.mojom.PageHandler",scope)}};let PageHandlerRemote$2=class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver$2,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}setPage(page){this.proxy.sendMessage(0,PageHandler_SetPage_ParamsSpec.$,null,[page],false)}onFocusChanged(focused){this.proxy.sendMessage(1,PageHandler_OnFocusChanged_ParamsSpec.$,null,[focused],false)}queryAutocomplete(input,preventInlineAutocomplete){this.proxy.sendMessage(2,PageHandler_QueryAutocomplete_ParamsSpec.$,null,[input,preventInlineAutocomplete],false)}stopAutocomplete(clearResult){this.proxy.sendMessage(3,PageHandler_StopAutocomplete_ParamsSpec.$,null,[clearResult],false)}openAutocompleteMatch(line,url,areMatchesShowing,mouseButton,altKey,ctrlKey,metaKey,shiftKey){this.proxy.sendMessage(4,PageHandler_OpenAutocompleteMatch_ParamsSpec.$,null,[line,url,areMatchesShowing,mouseButton,altKey,ctrlKey,metaKey,shiftKey],false)}onNavigationLikely(line,url,navigationPredictor){this.proxy.sendMessage(5,PageHandler_OnNavigationLikely_ParamsSpec.$,null,[line,url,navigationPredictor],false)}deleteAutocompleteMatch(line,url){this.proxy.sendMessage(6,PageHandler_DeleteAutocompleteMatch_ParamsSpec.$,null,[line,url],false)}activateKeyword(line,url,matchSelectionTimestamp,isMouseEvent){this.proxy.sendMessage(7,PageHandler_ActivateKeyword_ParamsSpec.$,null,[line,url,matchSelectionTimestamp,isMouseEvent],false)}showContextMenu(point){this.proxy.sendMessage(8,PageHandler_ShowContextMenu_ParamsSpec.$,null,[point],false)}executeAction(line,actionIndex,url,matchSelectionTimestamp,mouseButton,altKey,ctrlKey,metaKey,shiftKey){this.proxy.sendMessage(9,PageHandler_ExecuteAction_ParamsSpec.$,null,[line,actionIndex,url,matchSelectionTimestamp,mouseButton,altKey,ctrlKey,metaKey,shiftKey],false)}onThumbnailRemoved(){this.proxy.sendMessage(10,PageHandler_OnThumbnailRemoved_ParamsSpec.$,null,[],false)}getPlaceholderConfig(){return this.proxy.sendMessage(11,PageHandler_GetPlaceholderConfig_ParamsSpec.$,PageHandler_GetPlaceholderConfig_ResponseParamsSpec.$,[],false)}getRecentTabs(){return this.proxy.sendMessage(12,PageHandler_GetRecentTabs_ParamsSpec.$,PageHandler_GetRecentTabs_ResponseParamsSpec.$,[],false)}getTabPreview(tabId){return this.proxy.sendMessage(13,PageHandler_GetTabPreview_ParamsSpec.$,PageHandler_GetTabPreview_ResponseParamsSpec.$,[tabId],false)}notifySessionStarted(){this.proxy.sendMessage(14,PageHandler_NotifySessionStarted_ParamsSpec.$,null,[],false)}notifySessionAbandoned(){this.proxy.sendMessage(15,PageHandler_NotifySessionAbandoned_ParamsSpec.$,null,[],false)}addFileContext(fileInfo,fileBytes){return this.proxy.sendMessage(16,PageHandler_AddFileContext_ParamsSpec.$,PageHandler_AddFileContext_ResponseParamsSpec.$,[fileInfo,fileBytes],false)}addTabContext(tabId,delayUpload){return this.proxy.sendMessage(17,PageHandler_AddTabContext_ParamsSpec.$,PageHandler_AddTabContext_ResponseParamsSpec.$,[tabId,delayUpload],false)}deleteContext(token,fromAutomaticChip){this.proxy.sendMessage(18,PageHandler_DeleteContext_ParamsSpec.$,null,[token,fromAutomaticChip],false)}clearFiles(){this.proxy.sendMessage(19,PageHandler_ClearFiles_ParamsSpec.$,null,[],false)}submitQuery(queryText,mouseButton,altKey,ctrlKey,metaKey,shiftKey){this.proxy.sendMessage(20,PageHandler_SubmitQuery_ParamsSpec.$,null,[queryText,mouseButton,altKey,ctrlKey,metaKey,shiftKey],false)}openLensSearch(){this.proxy.sendMessage(21,PageHandler_OpenLensSearch_ParamsSpec.$,null,[],false)}};class PageHandler{static get $interfaceName(){return"searchbox.mojom.PageHandler"}static getRemote(){let remote=new PageHandlerRemote$2;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}let PagePendingReceiver$2=class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"searchbox.mojom.Page",scope)}};let PageRemote$2=class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver$2,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}autocompleteResultChanged(result){this.proxy.sendMessage(0,Page_AutocompleteResultChanged_ParamsSpec.$,null,[result],false)}updateSelection(oldSelection,selection){this.proxy.sendMessage(1,Page_UpdateSelection_ParamsSpec.$,null,[oldSelection,selection],false)}setKeywordSelected(isKeywordSelected){this.proxy.sendMessage(2,Page_SetKeywordSelected_ParamsSpec.$,null,[isKeywordSelected],false)}onShow(){this.proxy.sendMessage(3,Page_OnShow_ParamsSpec.$,null,[],false)}setInputText(input){this.proxy.sendMessage(4,Page_SetInputText_ParamsSpec.$,null,[input],false)}setThumbnail(thumbnailUrl,isDeletable){this.proxy.sendMessage(5,Page_SetThumbnail_ParamsSpec.$,null,[thumbnailUrl,isDeletable],false)}onContextualInputStatusChanged(token,status,errorType){this.proxy.sendMessage(6,Page_OnContextualInputStatusChanged_ParamsSpec.$,null,[token,status,errorType],false)}onTabStripChanged(){this.proxy.sendMessage(7,Page_OnTabStripChanged_ParamsSpec.$,null,[],false)}addFileContext(token,fileInfo){this.proxy.sendMessage(8,Page_AddFileContext_ParamsSpec.$,null,[token,fileInfo],false)}updateAutoSuggestedTabContext(tab){this.proxy.sendMessage(9,Page_UpdateAutoSuggestedTabContext_ParamsSpec.$,null,[tab],false)}updateLensSearchEligibility(eligible){this.proxy.sendMessage(10,Page_UpdateLensSearchEligibility_ParamsSpec.$,null,[eligible],false)}updateContentSharingPolicy(enabled){this.proxy.sendMessage(11,Page_UpdateContentSharingPolicy_ParamsSpec.$,null,[enabled],false)}updateAimEligibility(eligible){this.proxy.sendMessage(12,Page_UpdateAimEligibility_ParamsSpec.$,null,[eligible],false)}onShowAiModePrefChanged(canShow){this.proxy.sendMessage(13,Page_OnShowAiModePrefChanged_ParamsSpec.$,null,[canShow],false)}};let PageCallbackRouter$2=class PageCallbackRouter{helper_internal_;$;router_;autocompleteResultChanged;updateSelection;setKeywordSelected;onShow;setInputText;setThumbnail;onContextualInputStatusChanged;onTabStripChanged;addFileContext;updateAutoSuggestedTabContext;updateLensSearchEligibility;updateContentSharingPolicy;updateAimEligibility;onShowAiModePrefChanged;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote$2);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.autocompleteResultChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Page_AutocompleteResultChanged_ParamsSpec.$,null,this.autocompleteResultChanged.createReceiverHandler(false),false);this.updateSelection=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,Page_UpdateSelection_ParamsSpec.$,null,this.updateSelection.createReceiverHandler(false),false);this.setKeywordSelected=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,Page_SetKeywordSelected_ParamsSpec.$,null,this.setKeywordSelected.createReceiverHandler(false),false);this.onShow=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,Page_OnShow_ParamsSpec.$,null,this.onShow.createReceiverHandler(false),false);this.setInputText=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,Page_SetInputText_ParamsSpec.$,null,this.setInputText.createReceiverHandler(false),false);this.setThumbnail=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,Page_SetThumbnail_ParamsSpec.$,null,this.setThumbnail.createReceiverHandler(false),false);this.onContextualInputStatusChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,Page_OnContextualInputStatusChanged_ParamsSpec.$,null,this.onContextualInputStatusChanged.createReceiverHandler(false),false);this.onTabStripChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,Page_OnTabStripChanged_ParamsSpec.$,null,this.onTabStripChanged.createReceiverHandler(false),false);this.addFileContext=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,Page_AddFileContext_ParamsSpec.$,null,this.addFileContext.createReceiverHandler(false),false);this.updateAutoSuggestedTabContext=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,Page_UpdateAutoSuggestedTabContext_ParamsSpec.$,null,this.updateAutoSuggestedTabContext.createReceiverHandler(false),false);this.updateLensSearchEligibility=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,Page_UpdateLensSearchEligibility_ParamsSpec.$,null,this.updateLensSearchEligibility.createReceiverHandler(false),false);this.updateContentSharingPolicy=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,Page_UpdateContentSharingPolicy_ParamsSpec.$,null,this.updateContentSharingPolicy.createReceiverHandler(false),false);this.updateAimEligibility=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,Page_UpdateAimEligibility_ParamsSpec.$,null,this.updateAimEligibility.createReceiverHandler(false),false);this.onShowAiModePrefChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(13,Page_OnShowAiModePrefChanged_ParamsSpec.$,null,this.onShowAiModePrefChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}};const ACMatchClassificationSpec={$:{}};const ActionSpec={$:{}};const SuggestionAnswerSpec={$:{}};const AutocompleteMatchSpec={$:{}};const TabInfoSpec={$:{}};const FileAttachmentSpec={$:{}};const TabAttachmentSpec={$:{}};const SearchContextSpec={$:{}};const SelectedFileInfoSpec={$:{}};const SuggestionGroupSpec={$:{}};const AutocompleteResultSpec={$:{}};const OmniboxPopupSelectionSpec={$:{}};const PlaceholderConfigSpec={$:{}};const PageHandler_SetPage_ParamsSpec={$:{}};const PageHandler_OnFocusChanged_ParamsSpec={$:{}};const PageHandler_QueryAutocomplete_ParamsSpec={$:{}};const PageHandler_StopAutocomplete_ParamsSpec={$:{}};const PageHandler_OpenAutocompleteMatch_ParamsSpec={$:{}};const PageHandler_OnNavigationLikely_ParamsSpec={$:{}};const PageHandler_DeleteAutocompleteMatch_ParamsSpec={$:{}};const PageHandler_ActivateKeyword_ParamsSpec={$:{}};const PageHandler_ShowContextMenu_ParamsSpec={$:{}};const PageHandler_ExecuteAction_ParamsSpec={$:{}};const PageHandler_OnThumbnailRemoved_ParamsSpec={$:{}};const PageHandler_GetPlaceholderConfig_ParamsSpec={$:{}};const PageHandler_GetPlaceholderConfig_ResponseParamsSpec={$:{}};const PageHandler_GetRecentTabs_ParamsSpec={$:{}};const PageHandler_GetRecentTabs_ResponseParamsSpec={$:{}};const PageHandler_GetTabPreview_ParamsSpec={$:{}};const PageHandler_GetTabPreview_ResponseParamsSpec={$:{}};const PageHandler_NotifySessionStarted_ParamsSpec={$:{}};const PageHandler_NotifySessionAbandoned_ParamsSpec={$:{}};const PageHandler_AddFileContext_ParamsSpec={$:{}};const PageHandler_AddFileContext_ResponseParamsSpec={$:{}};const PageHandler_AddTabContext_ParamsSpec={$:{}};const PageHandler_AddTabContext_ResponseParamsSpec={$:{}};const PageHandler_DeleteContext_ParamsSpec={$:{}};const PageHandler_ClearFiles_ParamsSpec={$:{}};const PageHandler_SubmitQuery_ParamsSpec={$:{}};const PageHandler_OpenLensSearch_ParamsSpec={$:{}};const Page_AutocompleteResultChanged_ParamsSpec={$:{}};const Page_UpdateSelection_ParamsSpec={$:{}};const Page_SetKeywordSelected_ParamsSpec={$:{}};const Page_OnShow_ParamsSpec={$:{}};const Page_SetInputText_ParamsSpec={$:{}};const Page_SetThumbnail_ParamsSpec={$:{}};const Page_OnContextualInputStatusChanged_ParamsSpec={$:{}};const Page_OnTabStripChanged_ParamsSpec={$:{}};const Page_AddFileContext_ParamsSpec={$:{}};const Page_UpdateAutoSuggestedTabContext_ParamsSpec={$:{}};const Page_UpdateLensSearchEligibility_ParamsSpec={$:{}};const Page_UpdateContentSharingPolicy_ParamsSpec={$:{}};const Page_UpdateAimEligibility_ParamsSpec={$:{}};const Page_OnShowAiModePrefChanged_ParamsSpec={$:{}};const SearchContextAttachmentSpec={$:{}};mojo.internal.Struct(ACMatchClassificationSpec.$,"ACMatchClassification",[mojo.internal.StructField("offset",0,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("style",4,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ActionSpec.$,"Action",[mojo.internal.StructField("hint",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("suggestionContents",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("iconPath",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("a11yLabel",24,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(SuggestionAnswerSpec.$,"SuggestionAnswer",[mojo.internal.StructField("firstLine",0,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("secondLine",8,0,String16Spec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AutocompleteMatchSpec.$,"AutocompleteMatch",[mojo.internal.StructField("isHidden",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("a11yLabel",8,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("allowedToBeDefaultMatch",0,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("actions",16,0,mojo.internal.Array(ActionSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("answer",24,0,SuggestionAnswerSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("contents",32,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("contentsClass",40,0,mojo.internal.Array(ACMatchClassificationSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("description",48,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("descriptionClass",56,0,mojo.internal.Array(ACMatchClassificationSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("destinationUrl",64,0,UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("inlineAutocompletion",72,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("fillIntoEdit",80,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("is_weather_answer_suggestion_$flag",0,2,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"is_weather_answer_suggestion_$value",originalFieldName:"isWeatherAnswerSuggestion"},undefined),mojo.internal.StructField("is_weather_answer_suggestion_$value",0,3,mojo.internal.Bool,false,false,0,{isPrimary:false,originalFieldName:"isWeatherAnswerSuggestion"},undefined),mojo.internal.StructField("iconPath",88,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("iconUrl",96,0,UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("imageDominantColor",104,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("imageUrl",112,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("isNoncannedAimSuggestion",0,4,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isRichSuggestion",0,5,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isSearchType",0,6,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isEnterpriseSearchAggregatorPeopleType",0,7,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("type",120,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("removeButtonA11yLabel",128,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("swapContentsAndDescription",1,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("suggestionGroupId",4,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("supportsDeletion",1,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("tailSuggestCommonPrefix",136,0,String16Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("hasInstantKeyword",1,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("keywordChipHint",144,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("keywordChipA11y",152,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,168]]);mojo.internal.Struct(TabInfoSpec.$,"TabInfo",[mojo.internal.StructField("tabId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("title",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("url",16,0,UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("showInCurrentTabChip",4,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("showInPreviousTabChip",4,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("lastActive",24,0,TimeTicksSpec.$,null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(FileAttachmentSpec.$,"FileAttachment",[mojo.internal.StructField("uuid",0,0,UnguessableTokenSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("name",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("mimeType",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("imageDataUrl",24,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(TabAttachmentSpec.$,"TabAttachment",[mojo.internal.StructField("tabId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("title",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("url",16,0,UrlSpec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(SearchContextSpec.$,"SearchContext",[mojo.internal.StructField("input",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("attachments",8,0,mojo.internal.Array(SearchContextAttachmentSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("toolMode",16,0,ToolModeSpec.$,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(SelectedFileInfoSpec.$,"SelectedFileInfo",[mojo.internal.StructField("fileName",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("mimeType",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("imageDataUrl",16,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("isDeletable",24,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("selectionTime",32,0,JSTimeSpec.$,null,false,0,undefined,undefined)],[[0,48]]);mojo.internal.Struct(SuggestionGroupSpec.$,"SuggestionGroup",[mojo.internal.StructField("header",0,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("renderType",8,0,RenderTypeSpec.$,RenderType.kDefaultVertical,false,0,undefined,undefined),mojo.internal.StructField("sideType",12,0,SideTypeSpec.$,SideType.kDefaultPrimary,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AutocompleteResultSpec.$,"AutocompleteResult",[mojo.internal.StructField("input",0,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("suggestionGroupsMap",8,0,mojo.internal.Map(mojo.internal.Int32,SuggestionGroupSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("matches",16,0,mojo.internal.Array(AutocompleteMatchSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("smartComposeInlineHint",24,0,String16Spec.$,null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(OmniboxPopupSelectionSpec.$,"OmniboxPopupSelection",[mojo.internal.StructField("line",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("state",4,0,SelectionLineStateSpec.$,1,false,0,undefined,undefined),mojo.internal.StructField("actionIndex",1,0,mojo.internal.Uint8,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PlaceholderConfigSpec.$,"PlaceholderConfig",[mojo.internal.StructField("texts",0,0,mojo.internal.Array(String16Spec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("changeTextAnimationInterval",8,0,TimeDeltaSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("fadeTextAnimationDuration",16,0,TimeDeltaSpec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_SetPage_ParamsSpec.$,"PageHandler_SetPage_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageRemote$2),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_OnFocusChanged_ParamsSpec.$,"PageHandler_OnFocusChanged_Params",[mojo.internal.StructField("focused",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_QueryAutocomplete_ParamsSpec.$,"PageHandler_QueryAutocomplete_Params",[mojo.internal.StructField("input",0,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("preventInlineAutocomplete",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_StopAutocomplete_ParamsSpec.$,"PageHandler_StopAutocomplete_Params",[mojo.internal.StructField("clearResult",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_OpenAutocompleteMatch_ParamsSpec.$,"PageHandler_OpenAutocompleteMatch_Params",[mojo.internal.StructField("line",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("url",8,0,UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("areMatchesShowing",1,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("mouseButton",2,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("altKey",1,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("ctrlKey",1,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("metaKey",1,3,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("shiftKey",1,4,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_OnNavigationLikely_ParamsSpec.$,"PageHandler_OnNavigationLikely_Params",[mojo.internal.StructField("line",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("url",8,0,UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("navigationPredictor",4,0,NavigationPredictorSpec.$,1,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_DeleteAutocompleteMatch_ParamsSpec.$,"PageHandler_DeleteAutocompleteMatch_Params",[mojo.internal.StructField("line",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("url",8,0,UrlSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_ActivateKeyword_ParamsSpec.$,"PageHandler_ActivateKeyword_Params",[mojo.internal.StructField("line",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("url",8,0,UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("matchSelectionTimestamp",16,0,TimeTicksSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("isMouseEvent",1,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_ShowContextMenu_ParamsSpec.$,"PageHandler_ShowContextMenu_Params",[mojo.internal.StructField("point",0,0,PointSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ExecuteAction_ParamsSpec.$,"PageHandler_ExecuteAction_Params",[mojo.internal.StructField("line",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("actionIndex",1,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("url",8,0,UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("matchSelectionTimestamp",16,0,TimeTicksSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("mouseButton",2,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("altKey",3,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("ctrlKey",3,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("metaKey",3,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("shiftKey",3,3,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_OnThumbnailRemoved_ParamsSpec.$,"PageHandler_OnThumbnailRemoved_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetPlaceholderConfig_ParamsSpec.$,"PageHandler_GetPlaceholderConfig_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetPlaceholderConfig_ResponseParamsSpec.$,"PageHandler_GetPlaceholderConfig_ResponseParams",[mojo.internal.StructField("config",0,0,PlaceholderConfigSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetRecentTabs_ParamsSpec.$,"PageHandler_GetRecentTabs_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetRecentTabs_ResponseParamsSpec.$,"PageHandler_GetRecentTabs_ResponseParams",[mojo.internal.StructField("tabs",0,0,mojo.internal.Array(TabInfoSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetTabPreview_ParamsSpec.$,"PageHandler_GetTabPreview_Params",[mojo.internal.StructField("tabId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetTabPreview_ResponseParamsSpec.$,"PageHandler_GetTabPreview_ResponseParams",[mojo.internal.StructField("previewDataUrl",0,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_NotifySessionStarted_ParamsSpec.$,"PageHandler_NotifySessionStarted_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_NotifySessionAbandoned_ParamsSpec.$,"PageHandler_NotifySessionAbandoned_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_AddFileContext_ParamsSpec.$,"PageHandler_AddFileContext_Params",[mojo.internal.StructField("fileInfo",0,0,SelectedFileInfoSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("fileBytes",8,0,BigBufferSpec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_AddFileContext_ResponseParamsSpec.$,"PageHandler_AddFileContext_ResponseParams",[mojo.internal.StructField("token",0,0,UnguessableTokenSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_AddTabContext_ParamsSpec.$,"PageHandler_AddTabContext_Params",[mojo.internal.StructField("tabId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("delayUpload",4,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_AddTabContext_ResponseParamsSpec.$,"PageHandler_AddTabContext_ResponseParams",[mojo.internal.StructField("token",0,0,UnguessableTokenSpec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_DeleteContext_ParamsSpec.$,"PageHandler_DeleteContext_Params",[mojo.internal.StructField("token",0,0,UnguessableTokenSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("fromAutomaticChip",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_ClearFiles_ParamsSpec.$,"PageHandler_ClearFiles_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_SubmitQuery_ParamsSpec.$,"PageHandler_SubmitQuery_Params",[mojo.internal.StructField("queryText",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("mouseButton",8,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("altKey",9,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("ctrlKey",9,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("metaKey",9,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("shiftKey",9,3,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_OpenLensSearch_ParamsSpec.$,"PageHandler_OpenLensSearch_Params",[],[[0,8]]);mojo.internal.Struct(Page_AutocompleteResultChanged_ParamsSpec.$,"Page_AutocompleteResultChanged_Params",[mojo.internal.StructField("result",0,0,AutocompleteResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_UpdateSelection_ParamsSpec.$,"Page_UpdateSelection_Params",[mojo.internal.StructField("oldSelection",0,0,OmniboxPopupSelectionSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("selection",8,0,OmniboxPopupSelectionSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Page_SetKeywordSelected_ParamsSpec.$,"Page_SetKeywordSelected_Params",[mojo.internal.StructField("isKeywordSelected",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnShow_ParamsSpec.$,"Page_OnShow_Params",[],[[0,8]]);mojo.internal.Struct(Page_SetInputText_ParamsSpec.$,"Page_SetInputText_Params",[mojo.internal.StructField("input",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_SetThumbnail_ParamsSpec.$,"Page_SetThumbnail_Params",[mojo.internal.StructField("thumbnailUrl",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("isDeletable",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Page_OnContextualInputStatusChanged_ParamsSpec.$,"Page_OnContextualInputStatusChanged_Params",[mojo.internal.StructField("token",0,0,UnguessableTokenSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("status",8,0,FileUploadStatusSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("error_type_$flag",12,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"error_type_$value",originalFieldName:"errorType"},undefined),mojo.internal.StructField("error_type_$value",16,0,FileUploadErrorTypeSpec.$,0,false,0,{isPrimary:false,originalFieldName:"errorType"},undefined)],[[0,32]]);mojo.internal.Struct(Page_OnTabStripChanged_ParamsSpec.$,"Page_OnTabStripChanged_Params",[],[[0,8]]);mojo.internal.Struct(Page_AddFileContext_ParamsSpec.$,"Page_AddFileContext_Params",[mojo.internal.StructField("token",0,0,UnguessableTokenSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("fileInfo",8,0,SelectedFileInfoSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Page_UpdateAutoSuggestedTabContext_ParamsSpec.$,"Page_UpdateAutoSuggestedTabContext_Params",[mojo.internal.StructField("tab",0,0,TabInfoSpec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_UpdateLensSearchEligibility_ParamsSpec.$,"Page_UpdateLensSearchEligibility_Params",[mojo.internal.StructField("eligible",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_UpdateContentSharingPolicy_ParamsSpec.$,"Page_UpdateContentSharingPolicy_Params",[mojo.internal.StructField("enabled",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_UpdateAimEligibility_ParamsSpec.$,"Page_UpdateAimEligibility_Params",[mojo.internal.StructField("eligible",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnShowAiModePrefChanged_ParamsSpec.$,"Page_OnShowAiModePrefChanged_Params",[mojo.internal.StructField("canShow",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Union(SearchContextAttachmentSpec.$,"SearchContextAttachment",{fileAttachment:{ordinal:0,type:FileAttachmentSpec.$},tabAttachment:{ordinal:1,type:TabAttachmentSpec.$}});var SearchContextAttachmentFieldTags;(function(SearchContextAttachmentFieldTags){SearchContextAttachmentFieldTags[SearchContextAttachmentFieldTags["FILE_ATTACHMENT"]=0]="FILE_ATTACHMENT";SearchContextAttachmentFieldTags[SearchContextAttachmentFieldTags["TAB_ATTACHMENT"]=1]="TAB_ATTACHMENT"})(SearchContextAttachmentFieldTags||(SearchContextAttachmentFieldTags={}));let instance$s=null;function getCss$l(){return instance$s||(instance$s=[...[getCss$r()],css`#carousel{box-sizing:border-box;margin-bottom:12px;margin-top:4px;padding-inline-end:var(--context-carousel-inline-end-spacing,50px);padding-inline-start:var(--context-carousel-inline-start-spacing,50px)}#carousel.top{margin:0;position:absolute;top:14px;width:auto}.context-menu-container{align-items:center;cursor:text;display:flex;gap:4px;margin-bottom:var(--contextual-entrypoint-and-carousel-context-menu-container-margin-bottom);min-height:var(--cr-icon-button-size);padding-inline-start:var(--contextual-entrypoint-and-carousel-context-menu-container-padding-inline-start,4px);flex-wrap:nowrap}:host([is-omnibox-in-compact-mode_]) .context-menu-container{min-height:0}.context-menu-container>*{flex-shrink:0}#contextEntrypoint{color:var(--color-searchbox-results-foreground);padding-inline:var(--contextual-entrypoint-and-carousel-context-entrypoint-padding-inline,8px)}#toolChipsContainer{padding-top:10px;padding-inline-start:16px}#uploadContainer{display:flex;padding-inline-start:var(--text-input-inline-start-spacing)}.upload-button{--cr-icon-button-focus-outline-color:var(--color-searchbox-results-icon-focused-outline);--cr-icon-button-icon-size:24px;--cr-icon-button-hover-background-color:var(--color-searchbox-results-background-hovered);--cr-icon-button-size:48px;color:var(--color-composebox-upload-button);display:flex;flex-wrap:nowrap}.context-menu-container:has(.contextual-chip){padding-bottom:var(--contextual-entrypoint-and-carousel-contextual-chip-padding-bottom)}:host([inputs-disabled_]) .upload-button{color:var(--color-composebox-upload-button-disabled)}#imageUploadButton{--cr-icon-button-margin-start:-12px}.carousel-divider{border-radius:100px;border-top:1px solid var(--color-composebox-file-carousel-divider);margin-inline-end:16px;margin-inline-start:var(--text-input-inline-start-spacing);margin-top:var(--contextual-entrypoint-and-carousel-carousel-divider-margin-top,20px);margin-bottom:var(--contextual-entrypoint-and-carousel-carousel-divider-margin-bottom,10px)}#deepSearchButton{align-items:center;background-color:var(--color-composebox-context-entrypoint-hover-background);border:none;color:var(--color-composebox-upload-button);display:flex;font-size:13px;gap:2px;height:36px;justify-content:center;padding-bottom:6px;padding-inline:8px 12px;padding-top:6px;width:126px}#deepSearchButton .icon-container{align-items:center;display:flex;height:24px;justify-content:center;position:relative;width:24px}#deepSearchButton .deep-search-icon,#deepSearchButton .close-icon{height:16px;position:absolute;transition:opacity 150ms;width:16px}#deepSearchButton .deep-search-icon{padding-top:3px}#deepSearchButton .close-icon{opacity:0}#deepSearchButton:hover .close-icon{opacity:1}#deepSearchButton:hover .deep-search-icon{opacity:0}`])}const styleMod=document.createElement("dom-module");styleMod.appendChild(html$1`
  <template>
    <style>
.icon-arrow-back{--cr-icon-image:url(//resources/images/icon_arrow_back.svg)}.icon-arrow-dropdown{--cr-icon-image:url(//resources/images/icon_arrow_dropdown.svg)}.icon-arrow-drop-down-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_down_cr23.svg)}.icon-arrow-drop-up-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_up_cr23.svg)}.icon-arrow-upward{--cr-icon-image:url(//resources/images/icon_arrow_upward.svg)}.icon-cancel{--cr-icon-image:url(//resources/images/icon_cancel.svg)}.icon-clear{--cr-icon-image:url(//resources/images/icon_clear.svg)}.icon-copy-content{--cr-icon-image:url(//resources/images/icon_copy_content.svg)}.icon-delete-gray{--cr-icon-image:url(//resources/images/icon_delete_gray.svg)}.icon-edit{--cr-icon-image:url(//resources/images/icon_edit.svg)}.icon-file{--cr-icon-image:url(//resources/images/icon_filetype_generic.svg)}.icon-folder-open{--cr-icon-image:url(//resources/images/icon_folder_open.svg)}.icon-picture-delete{--cr-icon-image:url(//resources/images/icon_picture_delete.svg)}.icon-expand-less{--cr-icon-image:url(//resources/images/icon_expand_less.svg)}.icon-expand-more{--cr-icon-image:url(//resources/images/icon_expand_more.svg)}.icon-external{--cr-icon-image:url(//resources/images/open_in_new.svg)}.icon-more-vert{--cr-icon-image:url(//resources/images/icon_more_vert.svg)}.icon-refresh{--cr-icon-image:url(//resources/images/icon_refresh.svg)}.icon-search{--cr-icon-image:url(//resources/images/icon_search.svg)}.icon-settings{--cr-icon-image:url(//resources/images/icon_settings.svg)}.icon-visibility{--cr-icon-image:url(//resources/images/icon_visibility.svg)}.icon-visibility-off{--cr-icon-image:url(//resources/images/icon_visibility_off.svg)}.subpage-arrow{--cr-icon-image:url(//resources/images/arrow_right.svg)}.cr-icon{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-size);background-color:var(--cr-icon-color,var(--owl-control-accent-color,var(--google-grey-700)));flex-shrink:0;height:var(--cr-icon-ripple-size);margin-inline-end:var(--cr-icon-ripple-margin);margin-inline-start:var(--cr-icon-button-margin-start);user-select:none;width:var(--cr-icon-ripple-size)}:host-context([dir=rtl]) .cr-icon{transform:scaleX(-1)}.cr-icon.no-overlap{margin-inline-end:0;margin-inline-start:0}@media (prefers-color-scheme:dark){.cr-icon{background-color:var(--cr-icon-color,var(--owl-control-accent-color,var(--google-grey-500)))}}
    </style>
  </template>
`.content);styleMod.register("cr-icons");function getHtml$i(){const showDescription=this.showContextMenuDescription_&&!this.shouldShowRecentTabChip_;const toolChips=html`
        ${this.shouldShowRecentTabChip_?html`
        <composebox-recent-tab-chip id="recentTabChip"
            class="upload-button contextual-chip"
            .recentTab="${this.recentTabForChip_}"
            @add-tab-context="${this.addTabContext_}">
        </composebox-recent-tab-chip>
        `:""}
      ${this.shouldShowLensSearchChip_?html`
        <cr-composebox-lens-search id="lensSearchChip" class="upload-button contextual-chip">
        </cr-composebox-lens-search>
      `:""}
        <cr-composebox-tool-chip
            icon="composebox:deepSearch"
            label="${this.i18n("deepSearch")}"
            remove-chip-aria-label="${this.i18n("removeToolChipAriaLabel",this.i18n("deepSearch"))}"
            ?visible="${this.inDeepSearchMode_}"
            @click="${this.onDeepSearchClick_}">
        </cr-composebox-tool-chip>
        <cr-composebox-tool-chip
            icon="composebox:nanoBanana"
            label="${this.i18n("createImages")}"
            remove-chip-aria-label="${this.i18n("removeToolChipAriaLabel",this.i18n("createImages"))}"
            ?visible="${this.inCreateImageMode_}"
            @click="${this.onCreateImageClick_}">
        </cr-composebox-tool-chip>
  `;const voiceSearchButton=html`
          <cr-icon-button id="voiceSearchButton" class="voice-icon"
              part="voice-icon" iron-icon="cr:mic"
              @click="${this.onVoiceSearchClick_}"
              title="${this.i18n("voiceSearchButtonLabel")}">
          </cr-icon-button>
        `;const contextMenu=html`
      <div class="context-menu-container" part="context-menu-and-tools"
          @mousedown="${this.preventFocus_}"
          @click="${this.onContextMenuContainerClick_}">
        <cr-composebox-context-menu-entrypoint id="contextEntrypoint"
            part="composebox-entrypoint"
            exportparts="context-menu-entrypoint-icon"
            class="upload-button no-overlap"
            .tabSuggestions="${this.tabSuggestions}"
            .entrypointName="${this.entrypointName}"
            @open-image-upload="${this.openImageUpload_}"
            @open-file-upload="${this.openFileUpload_}"
            @add-tab-context="${this.addTabContext_}"
            @deep-search-click="${this.onDeepSearchClick_}"
            @create-image-click="${this.onCreateImageClick_}"
            @delete-tab-context="${this.onDeleteFile_}"
            .inCreateImageMode="${this.inCreateImageMode_}"
            .hasImageFiles="${this.hasImageFiles()}"
            .hideEntrypointButton="${this.shouldHideEntrypointButton_}"
            .disabledTabIds="${this.addedTabsIds_}"
            .fileNum="${this.files_.size}"
            .searchboxLayoutMode="${this.searchboxLayoutMode}"
            ?inputs-disabled="${this.inputsDisabled_}"
            ?show-context-menu-description="${showDescription}"
            glif-animation-state="${this.contextMenuGlifAnimationState}">
        </cr-composebox-context-menu-entrypoint>
        ${this.searchboxLayoutMode==="Compact"&&this.showVoiceSearch?voiceSearchButton:""}
        ${this.shouldShowToolChipsForTallMode_?toolChips:""}
        ${this.searchboxLayoutMode==="TallTopContext"&&this.showVoiceSearch?voiceSearchButton:""}
        ${this.searchboxLayoutMode==="TallTopContext"&&this.submitButtonShown?html`<slot name="submit-button"></slot>`:""}
      </div>
  `;return html`<!--_html_template_start_-->
  ${this.searchboxLayoutMode==="Compact"&&!this.isOmniboxInCompactMode_?contextMenu:""}
    <div part="carousel-container">
    ${this.showFileCarousel_?html`
      <cr-composebox-file-carousel
        part="cr-composebox-file-carousel"
        exportparts="thumbnail"
        id="carousel"
        class="${this.carouselOnTop_?"top":""}"
        .files="${Array.from(this.files_.values())}"
        @delete-file="${this.onDeleteFile_}">
      </cr-composebox-file-carousel> `:""}
    ${this.submitButtonShown&&this.searchboxLayoutMode==="Compact"?html`<slot name="submit-button"></slot>`:""}
  </div>
  ${this.searchboxLayoutMode==="TallTopContext"?contextMenu:""}
  ${this.shouldShowDivider_?html`
    <div class="carousel-divider" part="carousel-divider"></div>
  `:""}
  <!-- Suggestions are slotted in from the parent component. -->
  <slot id="dropdownMatches"></slot>
  ${this.shouldShowToolChipsForCompactMode_?html`
    <div class="context-menu-container" id="toolChipsContainer"
        part="tool-chips-container">${toolChips}</div>
  `:""}
  ${this.searchboxLayoutMode==="TallBottomContext"||this.searchboxLayoutMode===""||this.isOmniboxInCompactMode_?html`
    ${this.contextMenuEnabled_?contextMenu:html`
      <div part="upload-container" id="uploadContainer" class="icon-fade">
          <cr-icon-button
              class="upload-button no-overlap"
              id="imageUploadButton"
              iron-icon="composebox:imageUpload"
              title="${this.i18n("composeboxImageUploadButtonTitle")}"
              .disabled="${this.inputsDisabled_}"
              @click="${this.openImageUpload_}">
          </cr-icon-button>
          ${this.composeboxShowPdfUpload_?html`
          <cr-icon-button
              class="upload-button no-overlap"
              id="fileUploadButton"
              iron-icon="composebox:fileUpload"
              title="${this.i18n("composeboxPdfUploadButtonTitle")}"
              .disabled="${this.inputsDisabled_}"
              @click="${this.openFileUpload_}">
          </cr-icon-button>
          `:""}
      </div>
    `}
  `:""}
  <input type="file"
      accept="${this.imageFileTypes_}"
      id="imageInput"
      @change="${this.onFileChange_}"
      hidden>
  </input>
  <input type="file"
      accept="${this.attachmentFileTypes_}"
      id="fileInput"
      @change="${this.onFileChange_}"
      hidden>
  </input>
  ${(this.searchboxLayoutMode==="TallBottomContext"||!this.searchboxLayoutMode)&&this.showVoiceSearch?voiceSearchButton:""}
  ${this.submitButtonShown&&this.searchboxLayoutMode==="TallBottomContext"?html`<slot name="submit-button"></slot>`:""}
<!--_html_template_end_-->`}var ComposeboxMode;(function(ComposeboxMode){ComposeboxMode["DEFAULT"]="";ComposeboxMode["DEEP_SEARCH"]="deep-search";ComposeboxMode["CREATE_IMAGE"]="create-image"})(ComposeboxMode||(ComposeboxMode={}));const FILE_VALIDATION_ERRORS_MAP=new Map([[FileUploadErrorType$1.kImageProcessingError,"composeFileTypesAllowedError"],[FileUploadErrorType$1.kUnknown,"composeboxFileUploadValidationFailed"]]);var ProcessFilesError;(function(ProcessFilesError){ProcessFilesError[ProcessFilesError["NONE"]=0]="NONE";ProcessFilesError[ProcessFilesError["INVALID_TYPE"]=1]="INVALID_TYPE";ProcessFilesError[ProcessFilesError["FILE_TOO_LARGE"]=2]="FILE_TOO_LARGE";ProcessFilesError[ProcessFilesError["FILE_EMPTY"]=3]="FILE_EMPTY";ProcessFilesError[ProcessFilesError["MAX_FILES_EXCEEDED"]=4]="MAX_FILES_EXCEEDED"})(ProcessFilesError||(ProcessFilesError={}));class ContextualEntrypointAndCarouselElement extends(I18nMixinLit(CrLitElement)){static get is(){return"contextual-entrypoint-and-carousel"}static get styles(){return getCss$l()}render(){return getHtml$i.bind(this)()}static get properties(){return{showDropdown:{type:Boolean},showLensSearchChip:{reflect:true,type:Boolean},searchboxLayoutMode:{type:String},tabSuggestions:{type:Array},entrypointName:{type:String},showVoiceSearch:{reflect:true,type:Boolean},contextMenuGlifAnimationState:{type:String,reflect:true},hideEntrypointButton:{type:Boolean},inComposebox:{type:Boolean},attachmentFileTypes_:{type:String},contextMenuEnabled_:{type:Boolean},files_:{type:Object},pendingFiles_:{type:Object},addedTabsIds_:{type:Object},imageFileTypes_:{type:String},inputsDisabled_:{reflect:true,type:Boolean},composeboxShowPdfUpload_:{reflect:true,type:Boolean},showContextMenuDescription_:{type:Boolean},showFileCarousel_:{reflect:true,type:Boolean},showRecentTabChip:{type:Boolean},inDeepSearchMode_:{reflect:true,type:Boolean},inCreateImageMode_:{reflect:true,type:Boolean},recentTabForChip_:{type:Object},carouselOnTop_:{type:Boolean},submitButtonShown:{type:Boolean},isOmniboxInCompactMode_:{type:Boolean,reflect:true}}}#showDropdown_accessor_storage=false;get showDropdown(){return this.#showDropdown_accessor_storage}set showDropdown(value){this.#showDropdown_accessor_storage=value}#showLensSearchChip_accessor_storage=false;get showLensSearchChip(){return this.#showLensSearchChip_accessor_storage}set showLensSearchChip(value){this.#showLensSearchChip_accessor_storage=value}#searchboxLayoutMode_accessor_storage="";get searchboxLayoutMode(){return this.#searchboxLayoutMode_accessor_storage}set searchboxLayoutMode(value){this.#searchboxLayoutMode_accessor_storage=value}#entrypointName_accessor_storage="";get entrypointName(){return this.#entrypointName_accessor_storage}set entrypointName(value){this.#entrypointName_accessor_storage=value}#tabSuggestions_accessor_storage=[];get tabSuggestions(){return this.#tabSuggestions_accessor_storage}set tabSuggestions(value){this.#tabSuggestions_accessor_storage=value}#carouselOnTop__accessor_storage=false;get carouselOnTop_(){return this.#carouselOnTop__accessor_storage}set carouselOnTop_(value){this.#carouselOnTop__accessor_storage=value}#showVoiceSearch_accessor_storage=false;get showVoiceSearch(){return this.#showVoiceSearch_accessor_storage}set showVoiceSearch(value){this.#showVoiceSearch_accessor_storage=value}#showRecentTabChip_accessor_storage=false;get showRecentTabChip(){return this.#showRecentTabChip_accessor_storage}set showRecentTabChip(value){this.#showRecentTabChip_accessor_storage=value}#contextMenuGlifAnimationState_accessor_storage=GlifAnimationState.INELIGIBLE;get contextMenuGlifAnimationState(){return this.#contextMenuGlifAnimationState_accessor_storage}set contextMenuGlifAnimationState(value){this.#contextMenuGlifAnimationState_accessor_storage=value}#inComposebox_accessor_storage=false;get inComposebox(){return this.#inComposebox_accessor_storage}set inComposebox(value){this.#inComposebox_accessor_storage=value}#isOmniboxInCompactMode__accessor_storage=false;get isOmniboxInCompactMode_(){return this.#isOmniboxInCompactMode__accessor_storage}set isOmniboxInCompactMode_(value){this.#isOmniboxInCompactMode__accessor_storage=value}#attachmentFileTypes__accessor_storage=loadTimeData.getString("composeboxAttachmentFileTypes");get attachmentFileTypes_(){return this.#attachmentFileTypes__accessor_storage}set attachmentFileTypes_(value){this.#attachmentFileTypes__accessor_storage=value}#contextMenuEnabled__accessor_storage=loadTimeData.getBoolean("composeboxShowContextMenu");get contextMenuEnabled_(){return this.#contextMenuEnabled__accessor_storage}set contextMenuEnabled_(value){this.#contextMenuEnabled__accessor_storage=value}#files__accessor_storage=new Map;get files_(){return this.#files__accessor_storage}set files_(value){this.#files__accessor_storage=value}#addedTabsIds__accessor_storage=new Map;get addedTabsIds_(){return this.#addedTabsIds__accessor_storage}set addedTabsIds_(value){this.#addedTabsIds__accessor_storage=value}#pendingFiles__accessor_storage=new Map;get pendingFiles_(){return this.#pendingFiles__accessor_storage}set pendingFiles_(value){this.#pendingFiles__accessor_storage=value}#imageFileTypes__accessor_storage=loadTimeData.getString("composeboxImageFileTypes");get imageFileTypes_(){return this.#imageFileTypes__accessor_storage}set imageFileTypes_(value){this.#imageFileTypes__accessor_storage=value}#inputsDisabled__accessor_storage=false;get inputsDisabled_(){return this.#inputsDisabled__accessor_storage}set inputsDisabled_(value){this.#inputsDisabled__accessor_storage=value}#composeboxShowPdfUpload__accessor_storage=loadTimeData.getBoolean("composeboxShowPdfUpload");get composeboxShowPdfUpload_(){return this.#composeboxShowPdfUpload__accessor_storage}set composeboxShowPdfUpload_(value){this.#composeboxShowPdfUpload__accessor_storage=value}contextMenuDescriptionEnabled_=loadTimeData.getBoolean("composeboxShowContextMenuDescription");#showContextMenuDescription__accessor_storage=this.contextMenuDescriptionEnabled_;get showContextMenuDescription_(){return this.#showContextMenuDescription__accessor_storage}set showContextMenuDescription_(value){this.#showContextMenuDescription__accessor_storage=value}#showFileCarousel__accessor_storage=false;get showFileCarousel_(){return this.#showFileCarousel__accessor_storage}set showFileCarousel_(value){this.#showFileCarousel__accessor_storage=value}#inDeepSearchMode__accessor_storage=false;get inDeepSearchMode_(){return this.#inDeepSearchMode__accessor_storage}set inDeepSearchMode_(value){this.#inDeepSearchMode__accessor_storage=value}#inCreateImageMode__accessor_storage=false;get inCreateImageMode_(){return this.#inCreateImageMode__accessor_storage}set inCreateImageMode_(value){this.#inCreateImageMode__accessor_storage=value}#recentTabForChip__accessor_storage=null;get recentTabForChip_(){return this.#recentTabForChip__accessor_storage}set recentTabForChip_(value){this.#recentTabForChip__accessor_storage=value}#submitButtonShown_accessor_storage=false;get submitButtonShown(){return this.#submitButtonShown_accessor_storage}set submitButtonShown(value){this.#submitButtonShown_accessor_storage=value}#hideEntrypointButton_accessor_storage=false;get hideEntrypointButton(){return this.#hideEntrypointButton_accessor_storage}set hideEntrypointButton(value){this.#hideEntrypointButton_accessor_storage=value}hasAutomaticActiveTabChipToken(){return this.automaticActiveTabChipToken_!==null}getAutomaticActiveTabChipElement(){if(!this.automaticActiveTabChipToken_){return null}const carousel=this.shadowRoot?.querySelector("#carousel");if(!carousel){return null}return carousel.getThumbnailElementByUuid(this.automaticActiveTabChipToken_)}get inToolMode_(){return this.inDeepSearchMode_||this.inCreateImageMode_}shouldShowContextualSearchChips_(){return this.files_.size===0&&!this.inToolMode_&&!(this.searchboxLayoutMode==="Compact"&&this.entrypointName==="Realbox")}get shouldShowRecentTabChip_(){return this.shouldShowContextualSearchChips_()&&!!this.recentTabForChip_&&this.showRecentTabChip}get shouldShowLensSearchChip_(){return this.shouldShowContextualSearchChips_()&&this.showLensSearchChip}get shouldShowContextualChipsForCompactMode_(){return this.searchboxLayoutMode==="Compact"&&(this.shouldShowRecentTabChip_||this.shouldShowLensSearchChip_)}get shouldShowToolChipsForTallMode_(){if(this.entrypointName==="Omnibox"){return!this.shouldShowToolChipsForCompactMode_}return this.searchboxLayoutMode!=="Compact"||this.shouldShowContextualChipsForCompactMode_}get toolChipsVisible_(){return this.shouldShowRecentTabChip_||this.shouldShowLensSearchChip_||this.inDeepSearchMode_||this.inCreateImageMode_}get shouldShowToolChipsForCompactMode_(){if(this.searchboxLayoutMode!=="Compact"||!this.toolChipsVisible_){return false}return this.entrypointName!=="Omnibox"||this.inComposebox}get shouldShowDivider_(){if(this.entrypointName==="Omnibox"&&this.searchboxLayoutMode==="TallBottomContext"){return false}return this.showDropdown&&(this.entrypointName!=="Omnibox"&&this.shouldShowContextualChipsForCompactMode_||this.showFileCarousel_||this.searchboxLayoutMode==="TallTopContext"||this.submitButtonShown)}get shouldHideEntrypointButton_(){return this.shouldShowContextualChipsForCompactMode_||this.hideEntrypointButton}maxFileCount_=loadTimeData.getInteger("composeboxFileMaxCount");maxFileSize_=loadTimeData.getInteger("composeboxFileMaxSize");createImageModeEnabled_=loadTimeData.getBoolean("composeboxShowCreateImageButton");composeboxSource_=loadTimeData.getString("composeboxSource");automaticActiveTabChipToken_=null;willUpdate(changedProperties){super.willUpdate(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("files_")||changedPrivateProperties.has(`inCreateImageMode_`)){const isCreateImageToolAvailableWithImages=this.createImageModeEnabled_&&this.hasImageFiles()&&this.files_.size===1;this.inputsDisabled_=this.files_.size>=this.maxFileCount_&&!isCreateImageToolAvailableWithImages||this.hasImageFiles()&&this.inCreateImageMode_;this.showFileCarousel_=this.files_.size>0;this.fire("on-context-files-changed",{files:this.files_.size})}if(changedProperties.has("tabSuggestions")){this.recentTabForChip_=this.tabSuggestions.find((tab=>tab.showInCurrentTabChip))||null;if(!this.recentTabForChip_){this.recentTabForChip_=this.tabSuggestions.find((tab=>tab.showInPreviousTabChip))||null}}if(changedProperties.has("entrypointName")||changedProperties.has("searchboxLayoutMode")){this.isOmniboxInCompactMode_=this.entrypointName==="Omnibox"&&this.searchboxLayoutMode==="Compact"}}addDroppedFiles(files){this.processFiles_(files);recordContextAdditionMethod(2,this.composeboxSource_)}addPastedFiles(files){this.processFiles_(files);recordContextAdditionMethod(1,this.composeboxSource_)}blurEntrypoint(){this.$.contextEntrypoint.blur()}setContextFiles(files){for(const file of files){if("tabId"in file){if(this.contextMenuEnabled_&&file.origin===TabUploadOrigin.CONTEXT_MENU){this.$.contextEntrypoint.openMenuForMultiSelection()}this.addTabContext_(new CustomEvent("addTabContext",{detail:{id:file.tabId,title:file.title,url:file.url,delayUpload:file.delayUpload,replaceAutoActiveTabToken:false,origin:file.origin}}))}else{this.addFileContext_([file.file])}}}setInitialMode(mode){switch(mode){case ComposeboxMode.DEEP_SEARCH:this.onDeepSearchClick_();break;case ComposeboxMode.CREATE_IMAGE:this.onCreateImageClick_();break}}updateFileStatus(token,status,errorType){let errorMessage=null;let file=this.files_.get(token);if(file){if([FileUploadStatus$1.kValidationFailed,FileUploadStatus$1.kUploadFailed,FileUploadStatus$1.kUploadExpired].includes(status)){this.files_.delete(token);if(file.tabId){this.addedTabsIds_=new Map([...this.addedTabsIds_.entries()].filter((([id,_])=>id!==file.tabId)))}switch(status){case FileUploadStatus$1.kValidationFailed:errorMessage=this.i18n(FILE_VALIDATION_ERRORS_MAP.get(errorType)??"composeboxFileUploadValidationFailed");break;case FileUploadStatus$1.kUploadFailed:errorMessage=this.i18n("composeboxFileUploadFailed");break;case FileUploadStatus$1.kUploadExpired:errorMessage=this.i18n("composeboxFileUploadExpired");break}if(this.contextMenuEnabled_){this.$.contextEntrypoint.closeMenu()}}else{file={...file,status:status};this.files_.set(token,file)}this.files_=new Map([...this.files_])}else{this.pendingFiles_.set(token,status)}return{file:file,errorMessage:errorMessage}}resetContextFiles(){const undeletableFiles=Array.from(this.files_.values()).filter((file=>!file.isDeletable));if(undeletableFiles.length===this.files_.size){return[...this.files_.keys()]}this.files_=new Map(undeletableFiles.map((file=>[file.uuid,file])));this.addedTabsIds_=new Map(undeletableFiles.filter((file=>file.tabId)).map((file=>[file.tabId,file.uuid])));return[...this.files_.keys()]}resetModes(){if(this.inDeepSearchMode_){this.inDeepSearchMode_=false;this.inputsDisabled_=false;this.fire("set-deep-search-mode",{inDeepSearchMode:this.inDeepSearchMode_});this.showContextMenuDescription_=this.contextMenuDescriptionEnabled_}else if(this.inCreateImageMode_){this.inCreateImageMode_=false;this.fire("set-create-image-mode",{inCreateImageMode:this.inCreateImageMode_,imagePresent:this.hasImageFiles()});this.showContextMenuDescription_=this.contextMenuDescriptionEnabled_}}hasImageFiles(){if(this.files_){for(const file of this.files_.values()){if(file.type.includes("image")){return true}}}return false}hasTabFile(){if(this.files_){for(const file of this.files_.values()){if(file.type==="tab"){return true}}}return false}hasDeletableFiles(){return Array.from(this.files_.values()).some((file=>file.isDeletable))}onFileContextAdded(file){const newFiles=new Map(this.files_);newFiles.set(file.uuid,file);this.files_=newFiles}updateAutoActiveTabContext(tab){if(this.automaticActiveTabChipToken_){this.onDeleteFile_(new CustomEvent("deleteTabContext",{detail:{uuid:this.automaticActiveTabChipToken_}}));this.automaticActiveTabChipToken_=null}if(!tab){return}this.addTabContext_(new CustomEvent("addTabContext",{detail:{id:tab.tabId,title:tab.title,url:tab.url,delayUpload:true,replaceAutoActiveTabToken:true,origin:TabUploadOrigin.OTHER}}))}addFileFromAttachment_(fileAttachment){const pendingStatus=this.pendingFiles_.get(fileAttachment.uuid);const composeboxFile={uuid:fileAttachment.uuid,name:fileAttachment.name,objectUrl:null,dataUrl:fileAttachment.imageDataUrl??null,type:fileAttachment.mimeType,status:pendingStatus??FileUploadStatus$1.kNotUploaded,url:null,tabId:null,isDeletable:true};if(pendingStatus){this.pendingFiles_.delete(fileAttachment.uuid)}this.onFileContextAdded(composeboxFile)}addTabFromAttachment_(tabAttachment){this.addTabContext_(new CustomEvent("addTabContext",{detail:{id:tabAttachment.tabId,title:tabAttachment.title,url:tabAttachment.url,delayUpload:false,replaceAutoActiveTabToken:false,origin:TabUploadOrigin.OTHER}}))}addSearchContext(context){for(const attachment of context.attachments){if(attachment.fileAttachment){this.addFileFromAttachment_(attachment.fileAttachment)}else if(attachment.tabAttachment){this.addTabFromAttachment_(attachment.tabAttachment)}}if(context.attachments){recordContextAdditionMethod(0,this.composeboxSource_)}switch(context.toolMode){case ToolMode.kDeepSearch:this.setInitialMode(ComposeboxMode.DEEP_SEARCH);break;case ToolMode.kCreateImage:this.setInitialMode(ComposeboxMode.CREATE_IMAGE);break}}preventFocus_(e){e.preventDefault();e.stopPropagation()}onContextMenuContainerClick_(e){e.preventDefault();e.stopPropagation();if(e.button!==0){return}if(this.shadowRoot.activeElement===null){this.fire("context-menu-container-click")}}onDeleteFile_(e){if(!e.detail.uuid||!this.files_.has(e.detail.uuid)){return}const file=this.files_.get(e.detail.uuid);if(file?.tabId){this.addedTabsIds_=new Map([...this.addedTabsIds_.entries()].filter((([id,_])=>id!==file.tabId)))}const fromAutoSuggestedChip=e.detail.uuid===this.automaticActiveTabChipToken_&&e.detail.fromUserAction===true;if(fromAutoSuggestedChip){if(chrome.metricsPrivate){const metricName="ContextualSearch.UserAction.DeleteAutoSuggestedTab."+this.composeboxSource_;chrome.metricsPrivate.recordUserAction(metricName);chrome.metricsPrivate.recordBoolean(metricName,true)}this.automaticActiveTabChipToken_=null}this.files_=new Map([...this.files_.entries()].filter((([uuid,_])=>uuid!==e.detail.uuid)));this.fire("delete-context",{uuid:e.detail.uuid,fromAutoSuggestedChip:fromAutoSuggestedChip})}handleProcessFilesError_(error){if(error===ProcessFilesError.NONE){return}let metric=0;let errorMessage="";switch(error){case ProcessFilesError.MAX_FILES_EXCEEDED:metric=1;errorMessage="maxFilesReachedError";break;case ProcessFilesError.FILE_EMPTY:metric=2;errorMessage="composeboxFileUploadInvalidEmptySize";break;case ProcessFilesError.FILE_TOO_LARGE:metric=3;errorMessage="composeboxFileUploadInvalidTooLarge";break;case ProcessFilesError.INVALID_TYPE:errorMessage="composeFileTypesAllowedError";break}this.recordFileValidationMetric_(metric);if(this.contextMenuEnabled_){this.$.contextEntrypoint.closeMenu()}this.fire("on-file-validation-error",{errorMessage:this.i18n(errorMessage)})}isFileAllowed_(file,acceptedFileTypes){const fileType=file.type.toLowerCase();const allowedTypes=acceptedFileTypes.split(",");return allowedTypes.some((type=>{if(type.endsWith("/*")){const prefix=type.slice(0,-1);return fileType.startsWith(prefix)}return fileType===type}))}processFiles_(files){if(!files||files.length===0){return}const filesToUpload=[];let errorToDisplay=ProcessFilesError.NONE;if(this.files_.size+files.length>this.maxFileCount_){errorToDisplay=ProcessFilesError.MAX_FILES_EXCEEDED}for(const file of files){if(file.size===0||file.size>this.maxFileSize_){const sizeError=file.size===0?ProcessFilesError.FILE_EMPTY:ProcessFilesError.FILE_TOO_LARGE;errorToDisplay=Math.max(errorToDisplay,sizeError);continue}if(!this.isFileAllowed_(file,this.imageFileTypes_)&&!this.isFileAllowed_(file,this.attachmentFileTypes_)){errorToDisplay=Math.max(errorToDisplay,ProcessFilesError.INVALID_TYPE);continue}if(this.files_.size+filesToUpload.length<this.maxFileCount_){filesToUpload.push(file)}}if(filesToUpload.length>0){this.addFileContext_(filesToUpload)}this.handleProcessFilesError_(errorToDisplay)}onFileChange_(e){const input=e.target;const files=input.files;this.processFiles_(files);input.value="";recordContextAdditionMethod(0,this.composeboxSource_)}addFileContext_(filesToUpload){this.fire("add-file-context",{files:filesToUpload,onContextAdded:files=>{this.files_=new Map([...this.files_.entries(),...files.entries()]);this.recordFileValidationMetric_(0)}})}addTabContext_(e){e.stopPropagation();this.fire("add-tab-context",{id:e.detail.id,title:e.detail.title,url:e.detail.url,delayUpload:e.detail.delayUpload,origin:e.detail.origin,onContextAdded:file=>{this.files_=new Map([...this.files_.entries(),[file.uuid,file]]);this.addedTabsIds_=new Map([...this.addedTabsIds_.entries(),[e.detail.id,file.uuid]]);if(e.detail.replaceAutoActiveTabToken){if(this.automaticActiveTabChipToken_){this.onDeleteFile_(new CustomEvent("deleteTabContext",{detail:{uuid:this.automaticActiveTabChipToken_}}))}this.automaticActiveTabChipToken_=file.uuid}}})}openImageUpload_(){if(this.entrypointName==="ContextualTasks"){this.fire("open-file-dialog",{isImage:true})}else{assert(this.$.imageInput);this.$.imageInput.click()}}openFileUpload_(){if(this.entrypointName==="ContextualTasks"){this.fire("open-file-dialog",{isImage:false})}else if(this.$.fileInput){this.$.fileInput.click()}}onDeepSearchClick_(){if(this.entrypointName!=="Realbox"){if(this.contextMenuDescriptionEnabled_){this.showContextMenuDescription_=!this.showContextMenuDescription_}this.inputsDisabled_=!this.inputsDisabled_;this.inDeepSearchMode_=!this.inDeepSearchMode_}this.fire("set-deep-search-mode",{inDeepSearchMode:this.inDeepSearchMode_})}onCreateImageClick_(){if(this.entrypointName!=="Realbox"){if(this.contextMenuDescriptionEnabled_){this.showContextMenuDescription_=!this.showContextMenuDescription_}this.inCreateImageMode_=!this.inCreateImageMode_;if(this.hasImageFiles()){this.inputsDisabled_=!this.inputsDisabled_}}this.fire("set-create-image-mode",{inCreateImageMode:this.inCreateImageMode_,imagePresent:this.hasImageFiles()})}onVoiceSearchClick_(){this.fire("open-voice-search")}recordFileValidationMetric_(enumValue){if(!chrome.metricsPrivate){return}chrome.metricsPrivate.recordEnumerationValue("ContextualSearch.File.WebUI.UploadAttemptFailure."+this.composeboxSource_,enumValue,3+1)}}customElements.define(ContextualEntrypointAndCarouselElement.is,ContextualEntrypointAndCarouselElement);let instance$r=null;function getCss$k(){return instance$r||(instance$r=[...[getCss$r()],css`:host{--input-inline-spacing:12px;outline:none;height:var(--cr-composebox-match-height,44px);display:block}:host(:not([is-last])){padding-bottom:var(--cr-composebox-match-match-padding-bottom,2px)}.container{border-start-end-radius:24px;border-end-end-radius:24px;color:var(--color-composebox-font);cursor:default;display:flex;font-size:16px;height:var(--cr-composebox-match-height,44px);line-height:24px;position:relative}.container:hover{background-color:var(--color-searchbox-results-background-hovered)}:host(:is(:focus-visible,[selected])) .container{background-color:var(--color-searchbox-results-background-selected,var(--color-searchbox-results-background-hovered))}#focusIndicator{background-color:var(--color-searchbox-results-focus-indicator);border-radius:4px;display:none;margin-inline-start:-4px;height:100%;position:absolute;width:8px}:host(:is(:focus-visible,[selected])) #focusIndicator{display:block}#iconContainer{align-items:center;display:flex;padding-inline-start:var(--cr-composebox-match-icon-container-padding-inline-start,18px);justify-content:center}#icon{-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:cover;background-color:var(--color-composebox-input-icon);height:var(--cr-composebox-match-icon-size,20px);width:var(--cr-composebox-match-icon-size,20px)}#textContainer{align-content:center;color:var(--color-composebox-font-light);font-size:var(--cr-composebox-match-text-container-font-size,16px);overflow:hidden;padding-inline:var(--input-inline-spacing) 64px;text-overflow:ellipsis;white-space:nowrap}:host(:is(:focus-visible,[selected])) #textContainer{color:var(--color-searchbox-results-foreground-selected,var(--color-composebox-font-light))}#remove{--cr-icon-button-fill-color:var(--color-searchbox-results-icon-selected);--cr-icon-button-icon-size:16px;--cr-icon-button-hover-background-color:var(--color-searchbox-results-button-hover);display:none;position:absolute;top:var(--cr-composebox-match-remove-button-top,6px);right:12px}:host-context([dir='rtl']) #remove{left:12px;right:unset}.container:hover #remove:not([hidden]),:host-context(cr-composebox-match:-webkit-any(:focus-within,[selected])) #remove:not([hidden]){display:inline-flex}:host-context([in-deep-search-mode_]) #textContainer{overflow:hidden;white-space:normal;line-height:24px}:host-context([in-deep-search-mode_]) #focusIndicator{top:0;bottom:0;height:auto}:host-context([in-deep-search-mode_]){height:auto;min-height:var(--cr-composebox-match-height,44px)}:host-context([in-deep-search-mode_]) .container{height:auto;min-height:24px;padding-block:10px}:host-context([in-deep-search-mode_]) .container{border-start-end-radius:24px;border-end-end-radius:24px}`])}function getHtml$h(){return html`<!--_html_template_start_-->
<div class="container" aria-hidden="true">
  <div id="focusIndicator"></div>
  <div id="iconContainer">
    <div id="icon" style="-webkit-mask-image: url(${this.iconPath_()});"></div>
  </div>
  <div id="textContainer" part="match-text-container">
    ${this.computeContents_()}
  </div>
  <cr-icon-button id="remove" class="action-icon icon-clear"
    aria-label="${this.computeRemoveButtonAriaLabel_()}"
    @click="${this.onRemoveButtonClick_}"
    @mousedown="${this.onRemoveButtonMouseDown_}"
    title="${this.removeButtonTitle_}"
    ?hidden="${!this.match.supportsDeletion}"
    tabindex="2">
  </cr-icon-button>
</div>
  <!--_html_template_end_-->`}let PageHandlerFactoryPendingReceiver$1=class PageHandlerFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"composebox.mojom.PageHandlerFactory",scope)}};let PageHandlerFactoryRemote$1=class PageHandlerFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver$1,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}createPageHandler(page,handler,searchboxPage,searchboxHandler){this.proxy.sendMessage(0,PageHandlerFactory_CreatePageHandler_ParamsSpec$1.$,null,[page,handler,searchboxPage,searchboxHandler],false)}};let PageHandlerFactory$1=class PageHandlerFactory{static get $interfaceName(){return"composebox.mojom.PageHandlerFactory"}static getRemote(){let remote=new PageHandlerFactoryRemote$1;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}};let PageHandlerPendingReceiver$1=class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"composebox.mojom.PageHandler",scope)}};let PageHandlerRemote$1=class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver$1,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}focusChanged(focused){this.proxy.sendMessage(0,PageHandler_FocusChanged_ParamsSpec.$,null,[focused],false)}setDeepSearchMode(enabled){this.proxy.sendMessage(1,PageHandler_SetDeepSearchMode_ParamsSpec.$,null,[enabled],false)}setCreateImageMode(enabled,imagePresent){this.proxy.sendMessage(2,PageHandler_SetCreateImageMode_ParamsSpec.$,null,[enabled,imagePresent],false)}handleLensButtonClick(){this.proxy.sendMessage(3,PageHandler_HandleLensButtonClick_ParamsSpec.$,null,[],false)}handleFileUpload(isImage){this.proxy.sendMessage(4,PageHandler_HandleFileUpload_ParamsSpec.$,null,[isImage],false)}navigateUrl(url){this.proxy.sendMessage(5,PageHandler_NavigateUrl_ParamsSpec.$,null,[url],false)}};let PagePendingReceiver$1=class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"composebox.mojom.Page",scope)}};let PageRemote$1=class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver$1,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}};let PageCallbackRouter$1=class PageCallbackRouter{helper_internal_;$;router_;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote$1);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}};const PageHandlerFactory_CreatePageHandler_ParamsSpec$1={$:{}};const PageHandler_FocusChanged_ParamsSpec={$:{}};const PageHandler_SetDeepSearchMode_ParamsSpec={$:{}};const PageHandler_SetCreateImageMode_ParamsSpec={$:{}};const PageHandler_HandleLensButtonClick_ParamsSpec={$:{}};const PageHandler_HandleFileUpload_ParamsSpec={$:{}};const PageHandler_NavigateUrl_ParamsSpec={$:{}};mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec$1.$,"PageHandlerFactory_CreatePageHandler_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageRemote$1),null,false,0,undefined,undefined),mojo.internal.StructField("handler",8,0,mojo.internal.InterfaceRequest(PageHandlerPendingReceiver$1),null,false,0,undefined,undefined),mojo.internal.StructField("searchboxPage",12,0,mojo.internal.InterfaceProxy(PageRemote$2),null,false,0,undefined,undefined),mojo.internal.StructField("searchboxHandler",20,0,mojo.internal.InterfaceRequest(PageHandlerPendingReceiver$2),null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_FocusChanged_ParamsSpec.$,"PageHandler_FocusChanged_Params",[mojo.internal.StructField("focused",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetDeepSearchMode_ParamsSpec.$,"PageHandler_SetDeepSearchMode_Params",[mojo.internal.StructField("enabled",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetCreateImageMode_ParamsSpec.$,"PageHandler_SetCreateImageMode_Params",[mojo.internal.StructField("enabled",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("imagePresent",0,1,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_HandleLensButtonClick_ParamsSpec.$,"PageHandler_HandleLensButtonClick_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_HandleFileUpload_ParamsSpec.$,"PageHandler_HandleFileUpload_Params",[mojo.internal.StructField("isImage",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_NavigateUrl_ParamsSpec.$,"PageHandler_NavigateUrl_Params",[mojo.internal.StructField("url",0,0,UrlSpec.$,null,false,0,undefined,undefined)],[[0,16]]);function createAutocompleteMatch$1(){return{isHidden:false,a11yLabel:"",actions:[],allowedToBeDefaultMatch:false,isSearchType:false,isEnterpriseSearchAggregatorPeopleType:false,swapContentsAndDescription:false,supportsDeletion:false,suggestionGroupId:-1,contents:"",contentsClass:[{offset:0,style:0}],description:"",descriptionClass:[{offset:0,style:0}],destinationUrl:{url:""},inlineAutocompletion:"",fillIntoEdit:"",iconPath:"",iconUrl:{url:""},imageDominantColor:"",imageUrl:"",isNoncannedAimSuggestion:false,removeButtonA11yLabel:"",type:"",isRichSuggestion:false,isWeatherAnswerSuggestion:null,answer:null,tailSuggestCommonPrefix:null,hasInstantKeyword:false,keywordChipHint:"",keywordChipA11y:""}}class ComposeboxProxyImpl{handler;callbackRouter;searchboxHandler;searchboxCallbackRouter;constructor(handler,callbackRouter,searchboxHandler,searchboxCallbackRouter){this.handler=handler;this.callbackRouter=callbackRouter;this.searchboxHandler=searchboxHandler;this.searchboxCallbackRouter=searchboxCallbackRouter}static getInstance(){if(instance$q){return instance$q}const callbackRouter=new PageCallbackRouter$1;const handler=new PageHandlerRemote$1;const factory=PageHandlerFactory$1.getRemote();const searchboxHandler=new PageHandlerRemote$2;const searchboxCallbackRouter=new PageCallbackRouter$2;factory.createPageHandler(callbackRouter.$.bindNewPipeAndPassRemote(),handler.$.bindNewPipeAndPassReceiver(),searchboxCallbackRouter.$.bindNewPipeAndPassRemote(),searchboxHandler.$.bindNewPipeAndPassReceiver());instance$q=new ComposeboxProxyImpl(handler,callbackRouter,searchboxHandler,searchboxCallbackRouter);return instance$q}static setInstance(newInstance){instance$q=newInstance}}let instance$q=null;const LINE_HEIGHT_PX=24;const MAX_DEEP_SEARCH_LINES=2;class ComposeboxMatchElement extends CrLitElement{static get is(){return"cr-composebox-match"}static get styles(){return getCss$k()}render(){return getHtml$h.bind(this)()}static get properties(){return{match:{type:Object},matchIndex:{type:Number},inDeepSearchMode:{type:Boolean},removeButtonTitle_:{type:String}}}#match_accessor_storage=createAutocompleteMatch$1();get match(){return this.#match_accessor_storage}set match(value){this.#match_accessor_storage=value}#matchIndex_accessor_storage=-1;get matchIndex(){return this.#matchIndex_accessor_storage}set matchIndex(value){this.#matchIndex_accessor_storage=value}#inDeepSearchMode_accessor_storage=false;get inDeepSearchMode(){return this.#inDeepSearchMode_accessor_storage}set inDeepSearchMode(value){this.#inDeepSearchMode_accessor_storage=value}searchboxHandler_;#removeButtonTitle__accessor_storage=loadTimeData.getString("removeSuggestion");get removeButtonTitle_(){return this.#removeButtonTitle__accessor_storage}set removeButtonTitle_(value){this.#removeButtonTitle__accessor_storage=value}resizeObserver_=null;constructor(){super();this.searchboxHandler_=ComposeboxProxyImpl.getInstance().searchboxHandler}connectedCallback(){super.connectedCallback();this.addEventListener("click",(event=>this.onMouseClick_(event)));this.addEventListener("focusin",(()=>this.onMatchFocusin_()));this.addEventListener("mousedown",(event=>event.preventDefault()));this.resizeObserver_=new ResizeObserver((()=>this.clampDeepSearchContents_()));this.resizeObserver_.observe(this.$.textContainer)}disconnectedCallback(){super.disconnectedCallback();if(this.resizeObserver_){this.resizeObserver_.unobserve(this.$.textContainer)}}clampDeepSearchContents_(){if(!this.inDeepSearchMode){return}const textContainer=this.$.textContainer;textContainer.textContent=this.match.contents;const maxHeight=LINE_HEIGHT_PX*MAX_DEEP_SEARCH_LINES;if(textContainer.scrollHeight<=maxHeight){return}const words=this.match.contents.split(" ");while(words.length>0){words.pop();textContainer.textContent=words.join(" ")+"...";if(textContainer.scrollHeight<=maxHeight){break}}}computeContents_(){return this.match.contents}computeRemoveButtonAriaLabel_(){return this.match.removeButtonA11yLabel}iconPath_(){return this.match.iconPath||""}onMatchFocusin_(){this.fire("match-focusin",{index:this.matchIndex})}onMouseClick_(e){if(e.button>1){return}e.preventDefault();this.searchboxHandler_.openAutocompleteMatch(this.matchIndex,this.match.destinationUrl,true,e.button||0,e.altKey,e.ctrlKey,e.metaKey,e.shiftKey);this.fire("match-click")}onRemoveButtonClick_(e){if(e.button!==0){return}e.preventDefault();e.stopPropagation();this.searchboxHandler_.deleteAutocompleteMatch(this.matchIndex,this.match.destinationUrl)}onRemoveButtonMouseDown_(e){e.preventDefault()}}customElements.define(ComposeboxMatchElement.is,ComposeboxMatchElement);let instance$p=null;function getCss$j(){return instance$p||(instance$p=[...[getCss$r()],css`:host{display:flex;flex-direction:column;padding-inline-end:16px}:host([hidden]){display:none}cr-composebox-match[hidden]{display:none}`])}function getHtml$g(){return html`<!--_html_template_start_-->
  <div>
    ${this.result?.matches.map(((item,index)=>html`
      <cr-composebox-match
          aria-label="${this.computeAriaLabel_(item)}"
          exportparts="match-text-container"
          tabindex="0"
          role="option"
          .match="${item}"
          .matchIndex="${index}"
          .inDeepSearchMode="${this.inDeepSearchMode}"
          ?selected="${this.isSelected_(item)}"
          ?is-last="${this.isLastMatch_(index)}"
          ?hidden="${this.hideVerbatimMatch_(index)||index>this.getMaxVisibleIndex_()}">
      </cr-composebox-match>
    `))}
  </div>
  <!--_html_template_end_-->`}function remainder$1(lhs,rhs){return(lhs%rhs+rhs)%rhs}class ComposeboxDropdownElement extends CrLitElement{static get is(){return"cr-composebox-dropdown"}static get styles(){return getCss$j()}render(){return getHtml$g.bind(this)()}static get properties(){return{result:{type:Object},selectedMatchIndex:{type:Number,notify:true},lastQueriedInput:{type:String,notify:true},maxSuggestions:{type:Number},inDeepSearchMode:{type:Boolean}}}#result_accessor_storage=null;get result(){return this.#result_accessor_storage}set result(value){this.#result_accessor_storage=value}#selectedMatchIndex_accessor_storage=-1;get selectedMatchIndex(){return this.#selectedMatchIndex_accessor_storage}set selectedMatchIndex(value){this.#selectedMatchIndex_accessor_storage=value}#lastQueriedInput_accessor_storage="";get lastQueriedInput(){return this.#lastQueriedInput_accessor_storage}set lastQueriedInput(value){this.#lastQueriedInput_accessor_storage=value}#maxSuggestions_accessor_storage=null;get maxSuggestions(){return this.#maxSuggestions_accessor_storage}set maxSuggestions(value){this.#maxSuggestions_accessor_storage=value}#inDeepSearchMode_accessor_storage=false;get inDeepSearchMode(){return this.#inDeepSearchMode_accessor_storage}set inDeepSearchMode(value){this.#inDeepSearchMode_accessor_storage=value}unselect(){this.selectedMatchIndex=-1}focusSelected(){const selectableMatchElements=this.shadowRoot.querySelectorAll("cr-composebox-match");selectableMatchElements[this.selectedMatchIndex]?.focus()}selectFirst(){this.selectedMatchIndex=0}selectIndex(index){this.selectedMatchIndex=index}selectPrevious(){if(!this.result){this.selectedMatchIndex=-1;return}let previous;const isTypedSuggest=this.lastQueriedInput.trim().length>0;const maxVisibleIndex=this.getMaxVisibleIndex_();if(isTypedSuggest&&this.selectedMatchIndex===1){previous=maxVisibleIndex}else{previous=Math.max(this.selectedMatchIndex,0)-1}this.selectedMatchIndex=remainder$1(previous,maxVisibleIndex+1)}selectLast(){this.selectedMatchIndex=this.result?this.getMaxVisibleIndex_():-1}selectNext(){if(!this.result){this.selectedMatchIndex=-1;return}let next;const isTypedSuggest=this.lastQueriedInput.trim().length>0;const maxVisibleIndex=this.getMaxVisibleIndex_();if(isTypedSuggest&&this.selectedMatchIndex===maxVisibleIndex){next=1}else{next=this.selectedMatchIndex+1}this.selectedMatchIndex=remainder$1(next,maxVisibleIndex+1)}matchIndex_(match){return this.result?.matches.indexOf(match)??-1}isSelected_(match){return this.matchIndex_(match)===this.selectedMatchIndex}getMaxVisibleIndex_(){if(!this.result){return-1}if(!this.maxSuggestions||this.maxSuggestions<0){return this.result.matches.length-1}let maxVisibleSuggestionIndex=this.maxSuggestions?this.maxSuggestions:0;if(!this.hideVerbatimMatch_(0)){maxVisibleSuggestionIndex--}return Math.min(maxVisibleSuggestionIndex,this.result.matches.length-1)}isLastMatch_(index){assert(this.result);return index===this.getMaxVisibleIndex_()}hideVerbatimMatch_(index){assert(this.result);if(!this.result.input){return false}return index===0}computeAriaLabel_(match){return match.a11yLabel}}customElements.define(ComposeboxDropdownElement.is,ComposeboxDropdownElement);let instance$o=null;function getCss$i(){return instance$o||(instance$o=[...[getCss$r()],css`:host{--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0}#container{align-items:flex-start;border-radius:var(--expanded-border-radius);box-sizing:border-box;background-color:transparent;display:flex;inset:0;padding:7px 0;position:absolute;z-index:4}#input::-webkit-scrollbar{display:none}#input{background-color:transparent;border:none;flex:1;height:100%;mask-image:linear-gradient(to bottom,transparent 0px,black 7px,black calc(100% - 7px),transparent 100%);outline:none;overflow-y:auto;resize:none;width:100%}#input,#error-container{box-sizing:border-box;color:var(--color-composebox-voice-search-font,rgba(71,71,71,1));flex-grow:1;font-family:inherit;font-size:18px;line-height:24px;padding:var(--composebox-voice-search-top-padding,11px) 40px 0px 20px;width:100%}#error-container a{color:var(--color-composebox-link);text-decoration:underline}#closeButton{--cr-icon-button-fill-color:var(--color-composebox-cancel-button-light);--cr-icon-button-icon-size:20px;--cr-icon-button-size:36px;inset-inline-end:12px;margin-inline-start:16px;position:absolute;top:var(--composebox-cancel-button-top,12px);transition:var(--submit-enabled-transition,255ms)}`])}function getHtml$f(){return html`
    <div id="container">
      <div id="error-container" ?hidden="${!this.showErrorScrim_}">
        <span id="error-message">${this.errorMessage_}</span>
        <a id="details" target="_blank" href="${this.detailsUrl_}"
            @click="${this.onLinkClick_}">
          ${this.i18n("voiceDetails")}
        </a>
      </div>
      <textarea id="input"
          .value="${this.finalResult_+(this.interimResult_||"")}"
          placeholder="${this.listeningPlaceholder_}"
          ?hidden="${this.showErrorScrim_}" disabled>
      </textarea>
      <cr-icon-button id="closeButton" class="icon-clear"
          part="voice-close-button"
          title="${this.i18n("voiceClose")}" @click="${this.onCloseClick_}">
      </cr-icon-button>
    </div>
  `}let instance$n=null;class WindowProxy{static getInstance(){return instance$n||(instance$n=new WindowProxy)}static setInstance(obj){instance$n=obj}setTimeout(callback,duration){return window.setTimeout(callback,duration)}clearTimeout(id){window.clearTimeout(id!==null?id:undefined)}}const RECOGNITION_CONFIDENCE_THRESHOLD=.5;const IDLE_TIMEOUT_MS=8e3;var State;(function(State){State[State["UNINITIALIZED"]=-1]="UNINITIALIZED";State[State["STARTED"]=0]="STARTED";State[State["AUDIO_RECEIVED"]=1]="AUDIO_RECEIVED";State[State["SPEECH_RECEIVED"]=2]="SPEECH_RECEIVED";State[State["RESULT_RECEIVED"]=3]="RESULT_RECEIVED";State[State["ERROR_RECEIVED"]=4]="ERROR_RECEIVED";State[State["RESULT_FINAL"]=5]="RESULT_FINAL"})(State||(State={}));var Error$1;(function(Error){Error[Error["NOT_ALLOWED"]=0]="NOT_ALLOWED"})(Error$1||(Error$1={}));const ComposeboxVoiceSearchElementBase=I18nMixinLit(CrLitElement);class ComposeboxVoiceSearchElement extends ComposeboxVoiceSearchElementBase{static get is(){return"cr-composebox-voice-search"}static get styles(){return getCss$i()}render(){return getHtml$f.bind(this)()}static get properties(){return{transcript_:{type:String},listeningPlaceholder_:{type:String},state_:{type:Number},finalResult_:{type:String},interimResult_:{type:String},errorMessage_:{type:String},error_:{type:Number}}}#state__accessor_storage=State.UNINITIALIZED;get state_(){return this.#state__accessor_storage}set state_(value){this.#state__accessor_storage=value}#transcript__accessor_storage="";get transcript_(){return this.#transcript__accessor_storage}set transcript_(value){this.#transcript__accessor_storage=value}#listeningPlaceholder__accessor_storage=loadTimeData.getString("voiceListening");get listeningPlaceholder_(){return this.#listeningPlaceholder__accessor_storage}set listeningPlaceholder_(value){this.#listeningPlaceholder__accessor_storage=value}voiceRecognition_;#finalResult__accessor_storage="";get finalResult_(){return this.#finalResult__accessor_storage}set finalResult_(value){this.#finalResult__accessor_storage=value}#interimResult__accessor_storage="";get interimResult_(){return this.#interimResult__accessor_storage}set interimResult_(value){this.#interimResult__accessor_storage=value}timerId_=null;#error__accessor_storage=null;get error_(){return this.#error__accessor_storage}set error_(value){this.#error__accessor_storage=value}#errorMessage__accessor_storage="";get errorMessage_(){return this.#errorMessage__accessor_storage}set errorMessage_(value){this.#errorMessage__accessor_storage=value}detailsUrl_=`https://support.google.com/chrome/?p=ui_voice_search&hl=${window.navigator.language}`;pageHandler_=ComposeboxProxyImpl.getInstance().handler;get showErrorScrim_(){return!!this.errorMessage_}constructor(){super();this.voiceRecognition_=new window.webkitSpeechRecognition;this.voiceRecognition_.continuous=false;this.voiceRecognition_.interimResults=true;this.voiceRecognition_.lang=window.navigator.language;this.voiceRecognition_.onresult=this.onResult_.bind(this);this.voiceRecognition_.onend=this.onEnd_.bind(this);this.voiceRecognition_.onaudiostart=this.onAudioStart_.bind(this);this.voiceRecognition_.onspeechstart=this.onSpeechStart_.bind(this);this.voiceRecognition_.onerror=e=>{this.onError_(e.error)}}disconnectedCallback(){super.disconnectedCallback();this.voiceRecognition_.abort()}start(){this.errorMessage_="";this.voiceRecognition_.start();this.state_=State.STARTED;this.resetIdleTimer_()}stop(){this.voiceRecognition_.stop()}resetIdleTimer_(){WindowProxy.getInstance().clearTimeout(this.timerId_);this.timerId_=WindowProxy.getInstance().setTimeout(this.onIdleTimeout_.bind(this),IDLE_TIMEOUT_MS)}onIdleTimeout_(){if(this.state_===State.RESULT_FINAL){return}if(this.finalResult_){this.onFinalResult_();return}this.voiceRecognition_.abort()}onAudioStart_(){this.resetIdleTimer_();this.state_=State.AUDIO_RECEIVED}onSpeechStart_(){this.resetIdleTimer_();this.state_=State.SPEECH_RECEIVED;this.fire("speech-received")}onResult_(e){this.resetIdleTimer_();const results=e.results;if(results.length===0){return}this.state_=State.RESULT_RECEIVED;this.interimResult_="";this.finalResult_="";const speechResult=results[e.resultIndex];assert(speechResult);if(!!speechResult&&speechResult.isFinal){this.finalResult_=speechResult[0].transcript;this.onFinalResult_();return}for(let j=0;j<results.length;j++){const resultList=results[j];const result=resultList[0];assert(result);if(result.confidence>RECOGNITION_CONFIDENCE_THRESHOLD){this.finalResult_+=result.transcript}else{this.interimResult_+=result.transcript}}this.transcript_=this.finalResult_+this.interimResult_;this.fire("transcript-update",this.transcript_)}onEnd_(){switch(this.state_){case State.STARTED:case State.AUDIO_RECEIVED:case State.SPEECH_RECEIVED:case State.RESULT_RECEIVED:this.fire("voice-search-cancel");return;case State.ERROR_RECEIVED:if(this.error_!==Error$1.NOT_ALLOWED){this.resetState_();this.fire("voice-search-cancel")}return;case State.RESULT_FINAL:return;default:return}}onError_(webkitError){this.state_=State.ERROR_RECEIVED;switch(webkitError){case"not-allowed":this.error_=Error$1.NOT_ALLOWED;this.errorMessage_=loadTimeData.getString("voicePermissionError");return;default:return}}voiceModeEndCleanup_(){this.voiceRecognition_.abort();this.resetState_()}onFinalResult_(){if(!this.finalResult_){return}this.state_=State.RESULT_FINAL;this.fire("voice-search-final-result",this.finalResult_);this.voiceModeEndCleanup_()}onCloseClick_(){this.voiceModeEndCleanup_();this.fire("voice-search-cancel")}resetState_(){this.state_=State.UNINITIALIZED;this.finalResult_="";this.interimResult_="";this.error_=null;this.errorMessage_=""}onLinkClick_(e){e.preventDefault();const href=e.currentTarget.href;if(href){this.pageHandler_.navigateUrl({url:href})}this.fire("voice-search-cancel")}}customElements.define(ComposeboxVoiceSearchElement.is,ComposeboxVoiceSearchElement);function emptyHTML(){return window.trustedTypes?window.trustedTypes.emptyHTML:""}class CustomElement extends HTMLElement{static get template(){return emptyHTML()}constructor(){super();this.attachShadow({mode:"open"});const template=document.createElement("template");template.innerHTML=this.constructor.template||emptyHTML();this.shadowRoot.appendChild(template.content.cloneNode(true))}$(query){return this.shadowRoot.querySelector(query)}$all(query){return this.shadowRoot.querySelectorAll(query)}getRequiredElement(query){const el=this.shadowRoot.querySelector(query);assert(el);assert(el instanceof HTMLElement);return el}}function getTemplate(){return getTrustedHTML`<!--_html_template_start_--><style>:host{clip:rect(0 0 0 0);height:1px;overflow:hidden;position:fixed;width:1px}</style>

<div id="messages" role="alert" aria-live="polite" aria-relevant="additions">
</div>
<!--_html_template_end_-->`}const TIMEOUT_MS=150;const instances=new Map;function getInstance(container=document.body){if(instances.has(container)){return instances.get(container)}assert(container.isConnected);const instance=new CrA11yAnnouncerElement;container.appendChild(instance);instances.set(container,instance);return instance}class CrA11yAnnouncerElement extends CustomElement{static get is(){return"cr-a11y-announcer"}static get template(){return getTemplate()}currentTimeout_=null;messages_=[];disconnectedCallback(){if(this.currentTimeout_!==null){clearTimeout(this.currentTimeout_);this.currentTimeout_=null}for(const[parent,instance]of instances){if(instance===this){instances.delete(parent);break}}}announce(message,timeout=TIMEOUT_MS){if(this.currentTimeout_!==null){clearTimeout(this.currentTimeout_);this.currentTimeout_=null}this.messages_.push(message);this.currentTimeout_=setTimeout((()=>{const messagesDiv=this.shadowRoot.querySelector("#messages");messagesDiv.innerHTML=window.trustedTypes.emptyHTML;messagesDiv.removeAttribute("role");messagesDiv.setAttribute("role","alert");for(const message of this.messages_){const div=document.createElement("div");div.textContent=message;messagesDiv.appendChild(div)}this.dispatchEvent(new CustomEvent("cr-a11y-announcer-messages-sent",{bubbles:true,detail:{messages:this.messages_.slice()}}));this.messages_.length=0;this.currentTimeout_=null}),timeout)}}customElements.define(CrA11yAnnouncerElement.is,CrA11yAnnouncerElement);let instance$m=null;function getCss$h(){return instance$m||(instance$m=[...[],css`#errorScrim{align-items:center;background-color:var(--color-composebox-error-scrim-background);border-radius:inherit;color:var(--color-composebox-error-scrim-foreground);display:flex;flex-direction:column;font-size:13px;font-weight:500;gap:18px;justify-content:center;height:100%;position:absolute;width:100%;z-index:101}:host([compact-mode]) #errorScrim{flex-direction:row;justify-content:space-between}#errorScrim>p{margin:0}:host([compact-mode]) #errorScrim>p{margin:24px}#dismissErrorButton{--cr-button-background-color:var(--color-composebox-error-scrim-button-background);--cr-button-border-color:var(--color-composebox-error-scrim-foreground);--cr-button-text-color:var(--color-composebox-error-scrim-button-text);--cr-icon-button-hover-background-color:var(--color-composebox-error-scrim-button-background-hover);border:none;font-size:13px;gap:4px;height:36px;width:79px}:host([compact-mode]) #dismissErrorButton{margin-right:10px}`])}function getHtml$e(){return html`<!--_html_template_start_-->
  ${this.showErrorScrim_?html`
    <div id="errorScrim">
      <p id="errorMessage">${this.errorMessage_}</p>
      <cr-button id="dismissErrorButton"
          @click="${this.onDismissErrorButtonClick_}">
        <cr-icon icon="cr:close" slot="prefix-icon"></cr-icon>
        <div>${this.i18n("dismissButton")}</div>
      </cr-button>
    </div>
  `:""}
<!--_html_template_end_-->`}class ErrorScrimElement extends(I18nMixinLit(CrLitElement)){static get is(){return"ntp-error-scrim"}static get styles(){return getCss$h()}render(){return getHtml$e.bind(this)()}static get properties(){return{compactMode:{type:Boolean},showErrorScrim_:{reflect:true,type:Boolean},errorMessage_:{type:String}}}#compactMode_accessor_storage=false;get compactMode(){return this.#compactMode_accessor_storage}set compactMode(value){this.#compactMode_accessor_storage=value}#showErrorScrim__accessor_storage=false;get showErrorScrim_(){return this.#showErrorScrim__accessor_storage}set showErrorScrim_(value){this.#showErrorScrim__accessor_storage=value}#errorMessage__accessor_storage="";get errorMessage_(){return this.#errorMessage__accessor_storage}set errorMessage_(value){this.#errorMessage__accessor_storage=value}updated(changedProperties){super.updated(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("showErrorScrim_")){if(this.showErrorScrim_){const announcer=getInstance();announcer.announce(this.errorMessage_);const dismissErrorButton=this.shadowRoot.querySelector("#dismissErrorButton");if(dismissErrorButton){dismissErrorButton.focus()}}this.fire("error-scrim-visibility-changed",{showErrorScrim:this.showErrorScrim_})}}setErrorMessage(errorMessage){this.errorMessage_=errorMessage;this.showErrorScrim_=true}isErrorScrimShowing(){return this.showErrorScrim_}onDismissErrorButtonClick_(){this.errorMessage_="";this.showErrorScrim_=false}}customElements.define(ErrorScrimElement.is,ErrorScrimElement);let instance$l=null;function getCss$g(){return instance$l||(instance$l=[...[getCss$z(),getCss$r()],css`[actionable]{cursor:pointer}.hr{border-top:var(--cr-separator-line)}iron-list.cr-separators>*:not([first]){border-top:var(--cr-separator-line)}[scrollable]{border-color:transparent;border-style:solid;border-width:1px 0;overflow-y:auto}[scrollable].is-scrolled{border-top-color:var(--cr-scrollable-border-color)}[scrollable].can-scroll:not(.scrolled-to-bottom){border-bottom-color:var(--cr-scrollable-border-color)}[scrollable] iron-list>:not(.no-outline):focus-visible,[selectable]:focus-visible,[selectable]>:focus-visible{outline:solid 2px var(--cr-focus-outline-color);outline-offset:-2px}.scroll-container{display:flex;flex-direction:column;min-height:1px}[selectable]>*{cursor:pointer}.cr-centered-card-container{box-sizing:border-box;display:block;height:inherit;margin:0 auto;max-width:var(--cr-centered-card-max-width);min-width:550px;position:relative;width:calc(100% * var(--cr-centered-card-width-percentage))}.cr-container-shadow{height:var(--cr-container-shadow-height);left:0;margin:0 0 var(--cr-container-shadow-margin);opacity:0;pointer-events:none;position:relative;right:0;top:0;transition:opacity 500ms;z-index:1}#cr-container-shadow-bottom{margin-bottom:0;margin-top:var(--cr-container-shadow-margin);transform:scaleY(-1)}#cr-container-shadow-top:has(+#container.can-scroll:not(.scrolled-to-top)),#container.can-scroll:not(.scrolled-to-bottom)+#cr-container-shadow-bottom,#cr-container-shadow-bottom.force-shadow,#cr-container-shadow-top.force-shadow{opacity:var(--cr-container-shadow-max-opacity)}.cr-row{align-items:center;border-top:var(--cr-separator-line);display:flex;min-height:var(--cr-section-min-height);padding:0 var(--cr-section-padding)}.cr-row.first,.cr-row.continuation{border-top:none}.cr-row-gap{padding-inline-start:16px}.cr-button-gap{margin-inline-start:8px}paper-tooltip::part(tooltip),cr-tooltip::part(tooltip){border-radius:var(--paper-tooltip-border-radius,2px);font-size:92.31%;font-weight:500;max-width:330px;min-width:var(--paper-tooltip-min-width,200px);padding:var(--paper-tooltip-padding,10px 8px)}.cr-padded-text{padding-block-end:var(--cr-section-vertical-padding);padding-block-start:var(--cr-section-vertical-padding)}.cr-title-text{color:var(--cr-title-text-color);font-size:107.6923%;font-weight:500}.cr-secondary-text{color:var(--cr-secondary-text-color);font-weight:400}.cr-form-field-label{color:var(--cr-form-field-label-color);display:block;font-size:var(--cr-form-field-label-font-size);font-weight:500;letter-spacing:.4px;line-height:var(--cr-form-field-label-line-height);margin-bottom:8px}.cr-vertical-tab{align-items:center;display:flex}.cr-vertical-tab::before{border-radius:0 3px 3px 0;content:'';display:block;flex-shrink:0;height:var(--cr-vertical-tab-height,100%);width:4px}.cr-vertical-tab.selected::before{background:var(--cr-vertical-tab-selected-color,var(--cr-checked-color))}:host-context([dir=rtl]) .cr-vertical-tab::before{transform:scaleX(-1)}.iph-anchor-highlight{background-color:var(--cr-iph-anchor-highlight-color)}`])}let instance$k=null;function getCss$f(){return instance$k||(instance$k=[...[getCss$g()],css`:host{--cr-localized-link-display:inline;display:block}:host([link-disabled]){cursor:pointer;opacity:var(--cr-disabled-opacity);pointer-events:none}a{display:var(--cr-localized-link-display)}a[href]{color:var(--cr-link-color)}a[is=action-link]{user-select:none}#container{display:contents}`])}function getHtml$d(){return html`
<!-- innerHTML is set via setContainerInnerHtml_. -->
<div id="container"></div>`}class LocalizedLinkElement extends CrLitElement{static get is(){return"localized-link"}static get styles(){return getCss$f()}render(){return getHtml$d.bind(this)()}static get properties(){return{localizedString:{type:String},linkUrl:{type:String},linkDisabled:{type:Boolean,reflect:true},containerInnerHTML_:{type:String}}}#localizedString_accessor_storage="";get localizedString(){return this.#localizedString_accessor_storage}set localizedString(value){this.#localizedString_accessor_storage=value}#linkUrl_accessor_storage="";get linkUrl(){return this.#linkUrl_accessor_storage}set linkUrl(value){this.#linkUrl_accessor_storage=value}#linkDisabled_accessor_storage=false;get linkDisabled(){return this.#linkDisabled_accessor_storage}set linkDisabled(value){this.#linkDisabled_accessor_storage=value}#containerInnerHTML__accessor_storage="";get containerInnerHTML_(){return this.#containerInnerHTML__accessor_storage}set containerInnerHTML_(value){this.#containerInnerHTML__accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("localizedString")||changedProperties.has("linkUrl")){this.containerInnerHTML_=this.getAriaLabelledContent_(this.localizedString,this.linkUrl)}}updated(changedProperties){super.updated(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("containerInnerHTML_")){this.setContainerInnerHtml_()}if(changedProperties.has("linkDisabled")){this.updateAnchorTagTabIndex_()}}getAriaLabelledContent_(localizedString,linkUrl){const tempEl=document.createElement("div");tempEl.innerHTML=sanitizeInnerHtml(localizedString,{attrs:["id"]});const ariaLabelledByIds=[];tempEl.childNodes.forEach(((node,index)=>{if(node.nodeType===Node.TEXT_NODE){const spanNode=document.createElement("span");spanNode.textContent=node.textContent;spanNode.id=`id${index}`;ariaLabelledByIds.push(spanNode.id);spanNode.setAttribute("aria-hidden","true");node.replaceWith(spanNode);return}if(node.nodeType===Node.ELEMENT_NODE&&node.nodeName==="A"){const element=node;element.id=`id${index}`;ariaLabelledByIds.push(element.id);return}assertNotReached("localized-link has invalid node types")}));const anchorTags=tempEl.querySelectorAll("a");if(anchorTags.length===0){return localizedString}assert(anchorTags.length===1,"localized-link should contain exactly one anchor tag");const anchorTag=anchorTags[0];anchorTag.setAttribute("aria-labelledby",ariaLabelledByIds.join(" "));anchorTag.tabIndex=this.linkDisabled?-1:0;if(linkUrl!==""){anchorTag.href=linkUrl;anchorTag.target="_blank"}return tempEl.innerHTML}setContainerInnerHtml_(){this.$.container.innerHTML=sanitizeInnerHtml(this.containerInnerHTML_,{attrs:["aria-hidden","aria-labelledby","id","tabindex"]});const anchorTag=this.shadowRoot.querySelector("a");if(anchorTag){anchorTag.addEventListener("click",(event=>this.onAnchorTagClick_(event)));anchorTag.addEventListener("auxclick",(event=>{if(event.button===1){this.onAnchorTagClick_(event)}}))}}onAnchorTagClick_(event){if(this.linkDisabled){event.preventDefault();return}this.fire("link-clicked",{event:event});event.stopPropagation()}updateAnchorTagTabIndex_(){const anchorTag=this.shadowRoot.querySelector("a");if(!anchorTag){return}anchorTag.tabIndex=this.linkDisabled?-1:0}}customElements.define(LocalizedLinkElement.is,LocalizedLinkElement);let instance$j=null;function getCss$e(){return instance$j||(instance$j=[...[],css`:host{--expand-ease-in-duration:200ms;--expand-ease-out-duration:700ms;--expand-duration:calc(var(--expand-ease-in-duration) + var(--expand-ease-out-duration))}.eclipse-svg-wrapper{height:55px;inset:0;position:absolute;z-index:0}.eclipse-svg{opacity:0;position:absolute;inset:0;pointer-events:none;overflow:visible}:host([is-expanding_]) .eclipse-svg{animation:open-eclipse 175ms 125ms var(--standard-curve) forwards}:host(:not([is-expanding_])) .eclipse-svg{animation:close-eclipse 200ms var(--standard-curve) forwards}@keyframes open-eclipse{0%{display:none}20%{opacity:.1}100%{display:block;opacity:1}}@keyframes close-eclipse{0%{display:block;opacity:1}20%{opacity:.1}100%{display:none;opacity:0}}.eclipse-solid-fill{background-color:transparent;fill:transparent}.blurred-rects-outer{translate:50% 150%}.blurred-rects{transform-box:fill-box;transform-origin:center;rotate:80deg;animation:rotate-glow-rects 5s var(--expand-duration) linear infinite}@keyframes rotate-glow-rects{from{rotate:80deg}to{rotate:495deg}}`])}function getHtml$c(){return html`<!--_html_template_start_-->
    <div id="eclipseSvgWrapper" class="eclipse-svg-wrapper">
      <svg id="eclipseSvg" class="eclipse-svg" width="100%" height="100%">
        <defs>
          <linearGradient id="fadeEnds" x1="0%" y1="0%" x2="100%" y2="0%">
            <stop offset="0%" stop-color="black" />
            <stop offset="13%" stop-color="white" />
            <stop offset="87%" stop-color="white" />
            <stop offset="100%" stop-color="black" />
          </linearGradient>

          <filter id="lowerBlur" x="-20%" y="0%" width="140%" height="400%">
            <feGaussianBlur in="SourceGraphic" stdDeviation="15" />
          </filter>

          <clipPath id="clipPath">
            <path id="clipPathShape" />
          </clipPath>

          <path id="thinPath" />
          <path id="lowerGlowPath" />

          <mask id="mask">
            <use href="#thinPath" fill="url(#fadeEnds)" />
            <g clip-path="url(#clipPath)" filter="url(#lowerBlur)">
              <use href="#lowerGlowPath"
                   fill="white" opacity=".35" transform="scale(1, 1.5)" />
              <use href="#lowerGlowPath"
                   fill="white" opacity="0.0875" transform="scale(1, 4.125)" />
              <use href="#lowerGlowPath"
                   fill="white" opacity="0.0525" transform="scale(1, 6)" />
            </g>
          </mask>
        </defs>

        <use href="#lowerGlowPath" class="eclipse-solid-fill" />
        <g mask="url(#mask)">
          <g class="blurred-rects-outer">
            <image
                href="${blurredRectUrl}"
                id="blurredRects"
                class="blurred-rects"
                transform="scale(10)"
            />
          </g>
        </g>
      </svg>
    </div>
  <!--_html_template_end_-->`}const blurredRectUrl="//resources/cr_components/search/images/eclipse_wave_blurred_rect.png";const BEZIER_TENSION_RATIO=.38;const MAX_AMPLITUDE=-25;const MIN_AMPLITUDE=-0;const MAX_VERTICAL_SHIFT=-10;const MIN_VERTICAL_SHIFT=-0;const WAVE_SIDE_MARGIN_IDLE=56;const WAVE_SIDE_MARGIN_PEAK=10;const STROKE_WIDTH=3;const MS_PER_FRAME=16.67;const CIRCLE_RAD=Math.PI*2;const MIN_FRAMES_PER_SYLLABLE=6;const MAX_FRAMES_PER_SYLLABLE=8;const FRAME_LATENCY=-12;const SMOOTHING_WINDOW_SIZE=3;const SMOOTHING_BUFFER_SIZE=5;function clamp(value,minVal,maxVal){return Math.min(Math.max(value,minVal),maxVal)}function mapToRange(value,inputMin,inputMax,outputMin,outputMax,shouldClamp=false){if(shouldClamp){value=clamp(value,inputMin,inputMax)}return(value-inputMin)*((outputMax-outputMin)/(inputMax-inputMin))+outputMin}function countSyllablesHeuristic(word){word=word.toLocaleLowerCase();if(word.length===0){return 0}if(word.length<=3){return 1}word=word.replace(/(?:[^laeiouy]es|(?<=[^td])ed|[^laeiouy]e)$/,"");word=word.replace(/^y/,"");const vowelGroups=word.match(/[aeiouy]{1,2}/g);return vowelGroups?vowelGroups.length:1}function weightedAverage(numArray,amountToAverage){let weightedSum=0;let sumOfWeights=0;for(let i=0;i<amountToAverage;i++){const weight=amountToAverage-i;weightedSum+=(numArray[i]??0)*weight;sumOfWeights+=weight}return sumOfWeights===0?0:weightedSum/sumOfWeights}function bezierEasing(controlX1,controlX2,timeProgress){if(timeProgress<=0){return 0}if(timeProgress>=1){return 1}let currentT=timeProgress;const coeffA=3*controlX1;const coeffB=3*(controlX2-controlX1)-coeffA;const coeffC=1-coeffA-coeffB;for(let i=0;i<8;i++){const currentX=((coeffC*currentT+coeffB)*currentT+coeffA)*currentT;if(Math.abs(currentX-timeProgress)<1e-6){break}const currentSlope=(3*coeffC*currentT+2*coeffB)*currentT+coeffA;if(Math.abs(currentSlope)<1e-6){break}currentT-=(currentX-timeProgress)/currentSlope}return 3*currentT*currentT-2*currentT*currentT*currentT}class AudioWaveElement extends CrLitElement{static get styles(){return getCss$e()}render(){return getHtml$c.bind(this)()}static get properties(){return{isListening:{reflect:true,type:Boolean},isExpanding_:{reflect:true,type:Boolean},transcript:{type:String},receivedSpeech:{type:Boolean}}}#isListening_accessor_storage=false;get isListening(){return this.#isListening_accessor_storage}set isListening(value){this.#isListening_accessor_storage=value}#transcript_accessor_storage="";get transcript(){return this.#transcript_accessor_storage}set transcript(value){this.#transcript_accessor_storage=value}#receivedSpeech_accessor_storage=false;get receivedSpeech(){return this.#receivedSpeech_accessor_storage}set receivedSpeech(value){this.#receivedSpeech_accessor_storage=value}#isExpanding__accessor_storage=true;get isExpanding_(){return this.#isExpanding__accessor_storage}set isExpanding_(value){this.#isExpanding__accessor_storage=value}containerWidth_=0;animationFrameId_=null;decayingAmplitude_=0;frame_=0;lastUpdateTime_=performance.now();lastWordCount_=0;volumeHistory_=[];activeSimulatedBumps_=[];firstSyllable_=true;resizeObserver=new ResizeObserver((entries=>{for(const entry of entries){this.containerWidth_=entry.contentRect.width}}));connectedCallback(){super.connectedCallback();if(this.$.eclipseSvg){this.resizeObserver.observe(this.$.eclipseSvg)}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("isListening")){this.isListening?this.onStartListen():this.onStopListen();this.receivedSpeech=false}if(changedProperties.has("transcript")){this.handleNewWords()}if(changedProperties.has("receivedSpeech")){if(this.receivedSpeech){this.decayingAmplitude_=.4;for(let i=0;i<this.volumeHistory_.length;i++){this.volumeHistory_[i]=Math.max(this.volumeHistory_[i]??0,.3)}this.makeSimulatedAudioBump(15,25,this.frame_,.14,.05);if(this.transcript===""){this.firstSyllable_=false}}}}disconnectedCallback(){super.disconnectedCallback();this.onStopListen();this.resizeObserver.disconnect()}onStartListen(){this.isExpanding_=true;this.volumeHistory_=new Array(SMOOTHING_BUFFER_SIZE).fill(.001);if(this.animationFrameId_===null){this.animationFrameId_=requestAnimationFrame(this.processFrame)}}onStopListen(){this.frame_=0;this.decayingAmplitude_=0;if(this.animationFrameId_!==null){cancelAnimationFrame(this.animationFrameId_);this.animationFrameId_=null}this.isExpanding_=false}processFrame=()=>{if(!this.isListening){this.animationFrameId_=null;return}const now=performance.now();const elapsed=now-this.lastUpdateTime_;if(elapsed>MS_PER_FRAME){this.updateVolume();let level=this.volumeHistory_[0];{level=weightedAverage(this.volumeHistory_,SMOOTHING_WINDOW_SIZE)}level=bezierEasing(.4,.6,level??0);this.drawEclipseWavePath(level);this.lastUpdateTime_=now-elapsed%MS_PER_FRAME}if(this.isListening){this.animationFrameId_=requestAnimationFrame(this.processFrame)}};drawEclipseWavePath(rawInputLevel){this.frame_++;this.decayingAmplitude_=Math.max(this.decayingAmplitude_,rawInputLevel);this.decayingAmplitude_*=.85;const currentSidePadding=mapToRange(Math.pow(this.decayingAmplitude_,2.5),0,1,WAVE_SIDE_MARGIN_IDLE,WAVE_SIDE_MARGIN_PEAK);const anchorLeftX=currentSidePadding;const anchorRightX=this.containerWidth_-currentSidePadding;const waveCenterX=(anchorLeftX+anchorRightX)/2;const waveHalfWidth=(anchorRightX-anchorLeftX)/2;const getParabolicDepth=xPosition=>{if(waveHalfWidth===0){return 0}const normalizedX=(xPosition-waveCenterX)/waveHalfWidth;const audioDisplacement=mapToRange(this.decayingAmplitude_,0,1,MIN_AMPLITUDE,MAX_AMPLITUDE);const baseOffset=mapToRange(this.decayingAmplitude_,0,1,MIN_VERTICAL_SHIFT,MAX_VERTICAL_SHIFT);return audioDisplacement*(1-Math.pow(normalizedX,2))+baseOffset};const controlPointXLeft=this.containerWidth_*BEZIER_TENSION_RATIO;const controlPointXRight=this.containerWidth_*(1-BEZIER_TENSION_RATIO);const controlPointY=getParabolicDepth(controlPointXLeft);const maskTranslateY=mapToRange(this.decayingAmplitude_,0,1,MIN_VERTICAL_SHIFT,MAX_VERTICAL_SHIFT);const buildBezierPath=(thickness,isSolidLine)=>{const topY=thickness*-.5+controlPointY;const bottomY=thickness*.5+(isSolidLine?controlPointY:-controlPointY);return`M ${anchorLeftX},${0}\n                  C ${controlPointXLeft},${topY} ${controlPointXRight},${topY} ${anchorRightX},${0}\n                  C ${controlPointXRight},${bottomY} ${controlPointXLeft},${bottomY} ${anchorLeftX},${0}\n                  Z`};this.$.thinPath.setAttribute("d",buildBezierPath(STROKE_WIDTH,true));this.$.lowerGlowPath.setAttribute("d",buildBezierPath(STROKE_WIDTH,false));const currentTransform=`translate(0, ${maskTranslateY})`;this.$.mask.setAttribute("transform",currentTransform);this.$.thinPath.setAttribute("transform",currentTransform);this.$.lowerGlowPath.setAttribute("transform",currentTransform);this.$.clipPathShape.setAttribute("transform",currentTransform);const bottomClipY=1e3;const topControlY=STROKE_WIDTH*-.5+controlPointY;const clipPathString=`M ${0},${-maskTranslateY*.25}\n    L ${anchorLeftX},${0}\n    C ${controlPointXLeft},${topControlY} ${controlPointXRight},${topControlY} ${anchorRightX},${0}\n    L ${this.containerWidth_},${-maskTranslateY*.25}\n    L ${this.containerWidth_},${bottomClipY}\n    L ${0},${bottomClipY}\n    Z`;this.$.clipPathShape.setAttribute("d",clipPathString)}updateVolume(){const startRamp=Math.min(1,this.frame_/40);let ambientSimulatedMotion=.01+(1+Math.cos(this.frame_/60*CIRCLE_RAD))*.05;ambientSimulatedMotion*=.25+(1+Math.cos((this.frame_+100)/400*CIRCLE_RAD))*.2*startRamp;ambientSimulatedMotion+=.01*Math.random();ambientSimulatedMotion*=startRamp;this.volumeHistory_.unshift(ambientSimulatedMotion+this.getSimulatedAudioBumpsSum());if(this.volumeHistory_.length>SMOOTHING_BUFFER_SIZE){this.volumeHistory_.length=SMOOTHING_BUFFER_SIZE}}handleNewWords(){const trimmedTranscript=this.transcript.trim();if(trimmedTranscript===""){this.lastWordCount_=0;return}const words=trimmedTranscript.split(/\s+/);const currentWordCount=words.length;if(currentWordCount<=this.lastWordCount_){this.lastWordCount_=currentWordCount;return}const newWordCount=currentWordCount-this.lastWordCount_;const newWords=words.slice(-newWordCount);this.lastWordCount_=currentWordCount;this.triggerSyllableBumps(newWords)}triggerSyllableBumps(words){let frameOffset=FRAME_LATENCY;words.forEach((word=>{const syllableCount=countSyllablesHeuristic(word);for(let i=0;i<syllableCount;i++){if(!this.firstSyllable_){this.makeSimulatedAudioBump(25,15,this.frame_+frameOffset,.12,.08);frameOffset+=MIN_FRAMES_PER_SYLLABLE+(MAX_FRAMES_PER_SYLLABLE-MIN_FRAMES_PER_SYLLABLE)*Math.random()}else{this.firstSyllable_=false}}frameOffset+=2}))}makeSimulatedAudioBump(durationMultiplier,durationOffset,startTime,maxVolMultiplier,maxVolOffset){this.activeSimulatedBumps_.push({duration:Math.random()*durationMultiplier+durationOffset,startTime:startTime,maxVol:maxVolOffset+Math.random()*maxVolMultiplier})}getSimulatedAudioBumpsSum(){let simulatedVolumeSum=0;let writeIndex=0;for(let i=0;i<this.activeSimulatedBumps_.length;i++){const bump=this.activeSimulatedBumps_[i];const bumpRelativeTime=this.frame_-bump.startTime;const progress=bumpRelativeTime/bump.duration;if(progress>=1){continue}if(this.frame_>=bump.startTime){let newBumpAddition=(1-(1+Math.cos(progress*CIRCLE_RAD))*.5)*bump.maxVol;newBumpAddition=clamp(newBumpAddition,0,1);simulatedVolumeSum+=newBumpAddition}this.activeSimulatedBumps_[writeIndex]=bump;writeIndex++}this.activeSimulatedBumps_.length=writeIndex;return simulatedVolumeSum}}customElements.define("audio-wave",AudioWaveElement);let instance$i=null;function getCss$d(){return instance$i||(instance$i=[...[],css`:host{--drag-placeholder-font-color:rgba(86,89,94,1);--drag-placeholder-font-family:inherit;--drag-placeholder-line-height:24px;--drag-placeholder-font-size:16px;--end-angle-expand_:245deg;--end-angle-listen_:210deg;--end-angle-submit_:330deg;--expand-timing_:var(--glif-rotation-duration_) var(--standard-curve,--search-animated-glow-standard-curve);--glif-rotation-duration_:var(--search-animated-glif-rotation-duration,2s);--glow-stroke-width_:2px;--search-animated-glow-background:rgb(255,255,255);--search-animated-glow-background-z-index:103;--search-animated-glow-drag-drop-placeholder-z-index:104;--search-animated-glow-gradient-after-z-index:101;--search-animated-glow-gradient-z-index:102;--search-animated-glow-brand-gradient:conic-gradient(rgba(52,168,82,0) 0deg,rgba(52,168,82,1) 38.9738deg,rgba(255,211,20,1) 62.3678deg,rgba(255,70,65,1) 87.0062deg,rgba(49,134,255,1) 107.428deg,rgba(49,134,255,0.5) 204.48deg,rgba(49,134,255,0) 308.88deg,rgba(52,168,82,0) 360deg);--search-animated-glow-gradient-curve:cubic-bezier(0.2,0,0,1);--search-animated-glow-expand-duration:600ms;--search-animated-glow-standard-curve:cubic-bezier(0.4,0,0.2,1);--start-angle-expand_:30deg;--start-angle-submit_:200deg;--start-angle-listen_:35deg;border-radius:inherit}#dragDropPlaceholder{color:var(--drag-placeholder-font-color);display:none;font-family:var(--drag-placeholder-font-family);font-size:var(--drag-placeholder-font-size);left:20px;line-height:var(--drag-placeholder-line-height);opacity:0;pointer-events:none;position:absolute;top:var(--search-animated-glow-drag-drop-placeholder-top,21px);transition:opacity 300ms}:host([animation-state='dragging']) #dragDropPlaceholder{display:block;opacity:1;z-index:var(--search-animated-glow-drag-drop-placeholder-z-index,4)}.gradient,.double-gradient,.double-gradient-mask{border-radius:inherit;contain:paint;inset:0;position:absolute}:host([animation-state='expanding']) .gradient.gradient-outer-glow{animation:blur-expand var(--expand-timing_)}@keyframes blur-expand{17%{filter:blur(30px);opacity:17.5%}}.gradient::before,.double-gradient::before{aspect-ratio:1/1;background:var(--search-animated-glow-brand-gradient);border-radius:50%;contain:paint;content:'';height:auto;left:50%;opacity:0;position:absolute;rotate:0deg;scale:1 0.6;top:50%;translate:-50% -50%;width:145%}:host([entrypoint-name='Omnibox'][animation-state='expanding']) .double-gradient::before,:host(:not([entrypoint-name='Omnibox'])[animation-state='expanding']) .gradient::before{animation:gradient-spin-expand var(--glif-rotation-duration_) var(--search-animated-glow-gradient-curve) forwards}:host([entrypoint-name='Omnibox'][animation-state='expanding']) .gradient::before{--gradient-spin-expand-peak-opacity_:0.4;animation:gradient-spin-expand var(--glif-rotation-duration_) var(--search-animated-glow-gradient-curve) forwards}@media (prefers-color-scheme:dark){:host([entrypoint-name='Omnibox'][animation-state='expanding']) .gradient::before{--gradient-spin-expand-peak-opacity_:0.3}}:host([entrypoint-name='Omnibox'][animation-state='expanding']) .background,:host([entrypoint-name='Omnibox'][animation-state='expanding']) .gradient{border:var(--glow-stroke-width_) solid transparent}:host([animation-state='dragging']) .gradient,:host(:not([entrypoint-name='Omnibox'])) .double-gradient{pointer-events:none;z-index:var(--search-animated-glow-gradient-z-index,2)}:host([animation-state='listening']){--search-animated-glif-rotation-duration:1.5s}:host([animation-state='listening']) .gradient::before{animation:gradient-spin-listen var(--glif-rotation-duration_) var(--search-animated-glow-gradient-curve) forwards}:host([animation-state='dragging']) .gradient::before,:host([animation-state='dragging']) .double-gradient::before{animation:ambient-spin 6s linear infinite;filter:blur(20px);opacity:1;scale:1 0.8;z-index:var(--search-animated-glow-gradient-z-index,2)}:host([animation-state='submitting']) .gradient::before,:host([animation-state='submitting']) .gradient.gradient-outer-glow::before{animation:gradient-spin-submit var(--glif-rotation-duration_) var(--search-animated-glow-gradient-curve) forwards}:host([animation-state='submitting']) .gradient.gradient-outer-glow{animation:blur-close var(--glif-rotation-duration_) var(--search-animated-glow-gradient-curve)}.gradient::after{background-color:var(--cr-composebox-background-color,--search-animated-glow-background);border-radius:inherit;content:'';inset:0px;opacity:0;pointer-events:none;position:absolute;transition:opacity 500ms;z-index:var(--search-animated-glow-gradient-after-z-index,1)}:host([animation-state='dragging']) .gradient::after{opacity:1}@keyframes ambient-spin{from{transform:rotate(0deg)}to{transform:rotate(360deg)}}@keyframes blur-close{17%{filter:blur(30px);opacity:17.5%}}@keyframes gradient-spin-expand{0%{opacity:0;transform:rotate(var(--start-angle-expand_))}17%{opacity:var(--gradient-spin-expand-peak-opacity_,1)}100%{opacity:0;transform:rotate(var(--end-angle-expand_))}}@keyframes gradient-spin-submit{0%{opacity:0;transform:rotate(var(--start-angle-submit_))}17%{opacity:1}100%{opacity:0;transform:rotate(var(--end-angle-submit_))}}@keyframes gradient-spin-listen{0%{opacity:0;transform:rotate(var(--start-angle-listen_))}8%{opacity:1}100%{opacity:0;transform:rotate(var(--end-angle-listen_))}}.background{animation:gradient-border-width var(--expand-timing_);border:0 solid transparent;border-radius:inherit;contain:paint;inset:0;transition:border-width 100ms;position:absolute}@keyframes gradient-border-width{0%{border-width:0}17%{border-width:var(--glow-stroke-width_)}100%{border-width:0}}.double-gradient-mask::before,.background::before{background-color:var(--cr-composebox-background-color,--search-animated-glow-background);border-radius:inherit;content:'';contain:paint;filter:blur(0);position:absolute}.background::before{inset:0;transition:opacity 300ms,z-index 1ms 300ms}.double-gradient-mask::before{inset:var(--glow-stroke-width_)}:host([animation-state='expanding']) .background::before{animation:plate-background-blur-on-expand var(--expand-timing_)}:host([animation-state='expanding'][is-collapsible]) .background::before{animation:color-pulse-on-expand var(--expand-duration,--search-animated-glow-expand-duration) var(--standard-curve,--search-animated-glow-standard-curve)}:host([animation-state='listening']) .background::before{animation:plate-background-blur-on-expand var(--expand-timing_),color-pulse-on-expand-listen var(--expand-timing_)}@keyframes plate-background-blur-on-expand{0%{filter:blur(0)}17%{filter:blur(2px)}100%{filter:blur(0)}}@keyframes color-pulse-on-expand{40%{background:var(--color-composebox-scrim-background)}58%{background:var(--color-composebox-scrim-background)}}@keyframes color-pulse-on-expand-listen{17%{background:var(--color-composebox-scrim-background)}100%{background:var(--color-composebox-scrim-background)}}:host([entrypoint-name='Omnibox'][animation-state='expanding']) .background::before{animation:none;filter:blur(8px)}:host([animation-state='dragging']) .background{animation:none;border-width:2px;pointer-events:none;z-index:var(--search-animated-glow-background-z-index,3)}:host([animation-state='expanding']) .background{animation:gradient-border-width-close-expand var(--expand-timing_)}:host([animation-state='submitting']) .background{animation:gradient-border-width-close-submit var(--expand-timing_)}:host([animation-state='listening']) .background{animation:gradient-border-width-close-listen var(--expand-timing_)}:host([animation-state='dragging']) .background::before{animation:none;background-color:rgba(240,242,245);filter:blur(28px);z-index:var(--search-animated-glow-background-z-index,3)}@keyframes gradient-border-width-close-expand{0%{border-width:0}17%{border-width:var(--glow-stroke-width_)}100%{border-width:0}}@keyframes gradient-border-width-close-listen{0%{border-width:0}11%{border-width:var(--glow-stroke-width_)}100%{border-width:0}}@keyframes gradient-border-width-close-submit{0%{border-width:0}17%{border-width:var(--glow-stroke-width_)}100%{border-width:0}}`])}var GlowAnimationState;(function(GlowAnimationState){GlowAnimationState["NONE"]="";GlowAnimationState["DRAGGING"]="dragging";GlowAnimationState["EXPANDING"]="expanding";GlowAnimationState["SUBMITTING"]="submitting";GlowAnimationState["LISTENING"]="listening"})(GlowAnimationState||(GlowAnimationState={}));function getHtml$b(){return html`<!--_html_template_start_-->
    <div id="dragDropPlaceholder">${this.dragDropPlaceholder}</div>
    <div class="gradient gradient-outer-glow"></div>
    <div class="double-gradient"></div>
    <div class="double-gradient-mask"></div>
    <div class="gradient"></div>
    <div class="background"
        part="composebox-background">
    </div>
    ${this.requiresVoice?html`
      <audio-wave
          ?is-listening="${this.animationState===GlowAnimationState.LISTENING}"
          .transcript="${this.transcript}"
          .receivedSpeech="${this.receivedSpeech}">
      </audio-wave>
    `:""}
  <!--_html_template_end_-->`}class SearchAnimatedGlowElement extends CrLitElement{static get is(){return"search-animated-glow"}static get styles(){return getCss$d()}render(){return getHtml$b.bind(this)()}static get properties(){return{animationState:{type:String,reflect:true},entrypointName:{type:String},dragDropPlaceholder:{type:String},requiresVoice:{type:Boolean},isCollapsible:{type:Boolean,reflect:true},transcript:{type:String},receivedSpeech:{type:Boolean}}}#animationState_accessor_storage=GlowAnimationState.NONE;get animationState(){return this.#animationState_accessor_storage}set animationState(value){this.#animationState_accessor_storage=value}#dragDropPlaceholder_accessor_storage=loadTimeData.getString("composeboxDragAndDropHint");get dragDropPlaceholder(){return this.#dragDropPlaceholder_accessor_storage}set dragDropPlaceholder(value){this.#dragDropPlaceholder_accessor_storage=value}#requiresVoice_accessor_storage=false;get requiresVoice(){return this.#requiresVoice_accessor_storage}set requiresVoice(value){this.#requiresVoice_accessor_storage=value}#isCollapsible_accessor_storage=false;get isCollapsible(){return this.#isCollapsible_accessor_storage}set isCollapsible(value){this.#isCollapsible_accessor_storage=value}#transcript_accessor_storage="";get transcript(){return this.#transcript_accessor_storage}set transcript(value){this.#transcript_accessor_storage=value}#receivedSpeech_accessor_storage=false;get receivedSpeech(){return this.#receivedSpeech_accessor_storage}set receivedSpeech(value){this.#receivedSpeech_accessor_storage=value}}customElements.define(SearchAnimatedGlowElement.is,SearchAnimatedGlowElement);class DragAndDropHandler{host_;dragAndDropEnabled_=false;enterCounter_=0;constructor(host,dragAndDropEnabled){this.host_=host;this.dragAndDropEnabled_=dragAndDropEnabled;this.handleDragEnter=this.handleDragEnter.bind(this);this.handleDragLeave=this.handleDragLeave.bind(this);this.handleDragOver=this.handleDragOver.bind(this);this.handleDrop=this.handleDrop.bind(this)}handleDragEnter(e){if(!this.dragAndDropEnabled_){return}e.preventDefault();this.enterCounter_++;if(this.enterCounter_===1){this.host_.isDraggingFile=true;this.host_.animationState=GlowAnimationState.DRAGGING}}handleDragOver(e){if(!this.dragAndDropEnabled_){return}e.preventDefault()}handleDrop(e){if(!this.dragAndDropEnabled_){return}e.preventDefault();this.enterCounter_=0;const files=e.dataTransfer?.files;if(files&&files.length>0){this.host_.getDropTarget().addDroppedFiles(files)}this.host_.isDraggingFile=false;this.host_.animationState=GlowAnimationState.NONE}handleDragLeave(e){if(!this.dragAndDropEnabled_){return}e.preventDefault();this.enterCounter_--;if(this.enterCounter_===0){this.host_.isDraggingFile=false;this.host_.animationState=GlowAnimationState.NONE}}}let instance$h=null;function getCss$c(){return instance$h||(instance$h=[...[getCss$r()],css`:host{--color-composebox-submit-button-hover:var(--color-searchbox-results-background-hovered);--composebox-cancel-button-top:var(--cr-composebox-cancel-button-top,12px);--cr-composebox-outline-hcm:solid var(--color-composebox-outline-hcm);--cr-composebox-submit-container-size:40px;--cr-icon-button-size:36px;--input-bottom-spacing:10px;--text-input-top-spacing:10px;--text-input-inline-end-spacing:80px;--text-input-inline-start-spacing:16px;--text-input-max-height:190px;--expanded-border-radius:var(--cr-composebox-expanded-border-radius,26px);--standard-curve:cubic-bezier(0.4,0,0.2,1);--emphasized-accelerate:cubic-bezier(0.3,0,0.8,0.15);--emphasized-curve:linear(0,0.002,0.01 3.6%,0.02 4.9%,0.034,0.053,0.074,0.1,0.128,0.16,0.194 13.4%,0.271 15%,0.344 16.1%,0.477 17.5%,0.544 18.3%,0.607,0.66 20.6%,0.717 22.4%,0.742,0.765,0.788,0.808,0.827,0.845 30.4%,0.865 32.6%,0.866,0.865 32.7%,0.869 33.1%,0.883 35.1%,0.9 37.7%,0.916 40.6%,0.929 43.8%,0.942 47.2%,0.953 51%,0.963 55%,0.972 59.3%,0.979 64%,0.986 69%,0.991 74.4%,0.998 86.4%,1);--border-radius-transition:border-radius var(--collapse-duration) var(--emphasized-curve);--fade-duration:100ms;--height-expand-duration:600ms;--icon-entry-transition:opacity var(--expand-ease-out-duration) linear 800ms;--icon-exit-transition:opacity var(--collapse-ease-in-duration) var(--emphasized-accelerate);--lens-icon-animation-duration:1100ms;--submit-enabled-transition:opacity 255ms;border-radius:30px;box-shadow:var(--cr-searchbox-shadow);font-size:var(--cr-composebox-font-size,18px);transition:var(--border-radius-transition),box-shadow 500ms cubic-bezier(0.4,0.0,0.2,1);width:var(--cr-composebox-width,337px)}:host(:not([searchbox-next-enabled])){--expand-ease-in-duration:400ms;--expand-delay:300ms;--expand-ease-out-duration:300ms;--expand-duration:calc(var(--expand-ease-in-duration) + var(--expand-delay) + var(--expand-ease-out-duration));--collapse-ease-in-duration:100ms;--collapse-ease-out-duration:500ms;--collapse-duration:calc(var(--collapse-ease-in-duration) + var(--collapse-ease-out-duration))}:host([searchbox-next-enabled]){--cr-composebox-font-size:var(--cr-composebox-custom-font-size,16px);--contextual-entrypoint-and-carousel-context-menu-container-padding-inline-start:0px;--input-bottom-spacing:var(--cr-composebox-input-bottom-spacing,12px);--text-input-inline-start-spacing:var(--cr-composebox-text-input-inline-start,18px)}:host([searchbox-next-enabled]) #input::placeholder{font-size:var(--cr-composebox-input-placeholder-font-size,18px);font-weight:400}:host([expanding_]){border-radius:var(--expanded-border-radius)}#errorScrim{border-radius:inherit}#composebox{display:flex;flex-direction:column;pointer-events:auto;position:relative;overflow:hidden;transition:opacity var(--fade-duration) ease-in-out,visibility var(--fade-duration) ease-in-out}:host([is-dragging-file_]) #composebox *{pointer-events:none}search-animated-glow{pointer-events:none;inset:-2px;z-index:1}:host([is-collapsible]) #composebox{min-height:60px;max-height:60px;transition:max-height var(--collapse-duration) var(--emphasized-curve),min-height var(--collapse-duration) var(--emphasized-curve),opacity var(--fade-duration) ease-in-out,visibility var(--fade-duration) ease-in-out}:host(:not([is-collapsible])) #composebox{height:60px}:host([expanding_]) #composebox{height:calc-size(auto,size);max-height:var(--cr-composebox-max-height,422px);transition:max-height var(--expand-duration) var(--emphasized-curve),min-height var(--expand-duration) var(--emphasized-curve),opacity var(--fade-duration) ease-in-out,visibility var(--fade-duration) ease-in-out}:host([is-collapsible][expanding_]) #composebox{min-height:136px;max-height:254px}:host([is-collapsible][expanding_][show-file-carousel_][carousel-on-top_]) #composebox{min-height:calc(136px + 52px)}#inputContainer{box-sizing:border-box;display:flex;flex-direction:column;padding-bottom:var(--input-bottom-spacing);overflow:hidden;width:100%}#textContainer{display:flex;flex-direction:row;padding-block-start:var(--cr-composebox-text-container-padding-block-start,8px);padding-block-end:0;padding-inline:var(--text-input-inline-start-spacing) 0}#iconContainer{--text-input-top-spacing:8px;align-items:center;display:flex;height:48px;justify-content:center}#aimIcon{-webkit-mask-image:url(//resources/cr_components/searchbox/icons/search_spark.svg);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:cover;background-color:var(--color-composebox-input-icon);height:20px;width:20px}@media (forced-colors:active){#aimIcon{background-color:Highlight;border-radius:4px}}#inputWrapper{position:relative;width:100%}#input,#smartCompose{box-sizing:border-box;font-family:inherit;font-size:var(--cr-composebox-font-size,inherit);line-height:24px;min-height:48px;max-height:var(--text-input-max-height);padding-block:var(--text-input-top-spacing) 0;padding-inline:12px var(--text-input-inline-end-spacing);scrollbar-width:none;width:100%}:host(:not[searchbox-next-enabled]) #input{transition:padding var(--height-expand-duration) var(--standard-curve)}#input{background-color:inherit;border:none;caret-color:var(--color-composebox-font-light);color:var(--color-composebox-font-light);field-sizing:content;mask-image:linear-gradient(transparent 7px,black calc(var(--text-input-top-spacing) + 7px));height:calc-size(fit-content,min(size + 4px,var(--text-input-max-height)));outline:none;position:relative;resize:none}:host(:not([disable-caret-color-animation])) #input:focus{caret-color:var(--google-blue-500);animation:color-change 5s infinite}#input::placeholder{color:var(--cr-composebox-input-placeholder-color,var(--color-composebox-type-ahead))}#smartCompose{pointer-events:none;position:absolute;overflow:scroll;top:0;left:0}:host(:not([smart-compose-enabled_])) #smartCompose{display:none}#invisibleText{color:transparent;white-space:pre-wrap}#ghostText{color:var(--color-composebox-type-ahead);white-space:pre-wrap}#tabChip{align-items:center;border:1px solid var(--color-composebox-type-ahead-chip);border-radius:8px;box-sizing:border-box;color:var(--color-composebox-type-ahead-chip);font-size:12px;font-weight:700;line-height:24px;margin-left:4px;padding:6px 8px}:host([expanding_]) #input,:host([expanding_]) #smartCompose{--text-input-top-spacing:12px}:host([expanding_][is-collapsible]) #input{--text-input-top-spacing:24px}@keyframes color-change{0%,100%{caret-color:var(--google-blue-500)}25%{caret-color:var(--google-red-500)}50%{caret-color:var(--google-yellow-500)}75%{caret-color:var(--google-green-500)}}#input::-webkit-search-decoration,#input::-webkit-search-results-button,#input::-webkit-search-results-decoration,#input::-webkit-search-cancel-button{display:none}:host([expanding_][show-dropdown_]) cr-composebox-dropdown{padding-bottom:8px}.action-icon{--cr-icon-button-focus-outline-color:var(--color-searchbox-results-icon-focused-outline);--cr-icon-button-hover-background-color:var(--color-searchbox-results-background-hovered);--cr-icon-button-margin-end:0;--cr-icon-button-size:36px;position:absolute;right:16px}:host-context([dir='rtl']) .action-icon{left:16px;right:unset}#cancelIcon{--cr-icon-button-fill-color:var(--color-composebox-cancel-button-light);--cr-icon-button-icon-size:20px;position:absolute;top:var(--composebox-cancel-button-top);inset-inline-end:12px;transition:var(--submit-enabled-transition)}:host([searchbox-layout-mode="Compact"]){--search-animated-glow-drag-drop-placeholder-top:16px;--composebox-cancel-button-top:10px;--composebox-voice-search-top-padding:9px}:host([expanding_][is-collapsible]) #cancelIcon{top:16px}:host([is-collapsible]:not([submit-enabled_])) #cancelIcon{opacity:0;pointer-events:none}@keyframes fade-out-in{0%{opacity:0}73%{opacity:0}}#lensIcon{--cr-icon-button-icon-size:20px;--cr-icon-image:url(//resources/cr_components/searchbox/icons/camera.svg);bottom:var(--input-bottom-spacing);display:none;opacity:1;position:absolute;inset-inline-end:16px;top:6px}#lensIcon:focus-visible:focus{box-shadow:none;outline:2px solid var(--color-searchbox-results-icon-focused-outline);outline-offset:2px}:host([expanding_]) #lensIcon{animation:fade-out-in var(--lens-icon-animation-duration) linear;inset-inline-end:68px;top:auto}:host([lens-button-disabled]) #lensIcon{opacity:0.3}:host(:not([show-submit_])) #submitContainer,:host([show-submit_]:not([submit-enabled_])) #submitContainer{display:none}#submitContainer{border-radius:50%;cursor:default;height:var(--cr-composebox-submit-container-size,var(--cr-icon-button-size));bottom:var(--input-bottom-spacing);position:absolute;inset-inline-end:12px;width:var(--cr-composebox-submit-container-size,var(--cr-icon-button-size))}:host([show-submit_][submit-enabled_]) #submitContainer{cursor:pointer}#submitOverlay{border-radius:inherit;display:inherit;height:var(--cr-icon-button-size);margin-inline-start:2px;margin-top:2px;position:absolute;width:var(--cr-icon-button-size);z-index:2}:host([show-submit_][submit-enabled_]) #submitContainer:hover #submitOverlay{background-color:var(--cr-composebox-submit-button-hover-color,var(--color-composebox-submit-button-hover))}#submitIcon{--cr-icon-button-fill-color:var(--color-composebox-submit-button-icon,white);--cr-icon-button-icon-size:16px;background-color:var(--color-composebox-submit-button-background);margin-inline-start:0px;inset-inline-start:2px;opacity:30%;top:2px;transition:var(--submit-enabled-transition)}#submitContainer:has(#submitIcon[disabled]){cursor:not-allowed}#submitContainer:has(#submitIcon[disabled]):hover #submitOverlay{background-color:transparent}#submitContainer #submitIcon[disabled]{opacity:0.4}#submitContainer:focus-visible{outline:none}#submitContainer:focus-visible #submitIcon,#submitIcon:focus-visible:focus{box-shadow:none;outline:2px solid var(--color-searchbox-results-icon-focused-outline);outline-offset:2px}:host([show-submit_][submit-enabled_]) #submitIcon{display:block;opacity:100%}.icon-fade{opacity:0;transition:var(--icon-exit-transition)}:host([expanding_]) .icon-fade{opacity:1;transition:var(--icon-entry-transition)}@media (forced-colors:active){:host,.action-icon{border:var(--composebox-outline-hcm)}}#suggestionActivity{color:var(--color-composebox-suggestion-activity);display:flex;font-size:12px;font-weight:400;justify-content:flex-end;line-height:18px;padding-bottom:10px;padding-inline-end:18px;position:relative}:host([expanding_][show-file-carousel_][carousel-on-top_]) #inputContainer{padding-top:60px;--text-input-max-height:130px}.carousel-divider{border-radius:100px;border-top:1px solid var(--color-composebox-file-carousel-divider);margin-inline-end:16px;margin-inline-start:var(--text-input-inline-start-spacing);margin-top:8px;margin-bottom:10px}:host([searchbox-layout-mode="Compact"]) contextual-entrypoint-and-carousel::part(context-menu-entrypoint-icon){position:absolute;top:10px}:host([searchbox-next-enabled][searchbox-layout-mode^="Tall"][show-dropdown_]){--expanded-border-radius:var(--cr-composebox-expanded-border-radius,24px)}:host([searchbox-next-enabled][searchbox-layout-mode="Compact"]){--expanded-border-radius:var(--cr-composebox-expanded-border-radius,30px);--input-bottom-spacing:10px}:host([searchbox-next-enabled][searchbox-layout-mode="Compact"]) #iconContainer{display:none}:host([searchbox-next-enabled][searchbox-layout-mode="Compact"]) #textContainer{--text-input-inline-start-spacing:40px;padding-block:6px 0}:host([searchbox-next-enabled]) #input,:host([searchbox-next-enabled]) #smartCompose{--text-input-top-spacing:10px}:host([searchbox-next-enabled]) #iconContainer{height:44px}:host([searchbox-next-enabled]) #submitIcon{--cr-icon-button-icon-size:12px}:host([searchbox-next-enabled][searchbox-layout-mode="Compact"]) #context{margin-top:var(--cr-composebox-context-margin-top,-48px)}:host([expanding_][show-dropdown_][searchbox-next-enabled][searchbox-layout-mode="Compact"]) cr-composebox-dropdown{padding-bottom:0;padding-top:8px}:host-context([searchbox-layout-mode='TallTopContext']) contextual-entrypoint-and-carousel::part(carousel-divider){margin-top:10px}contextual-entrypoint-and-carousel::part(voice-icon){--cr-icon-button-fill-color:var(--color-composebox-font-light);--cr-icon-button-hover-background-color:var(--color-composebox-context-entrypoint-hover-background);--cr-icon-button-margin-end:0px;--cr-icon-button-margin-start:0px;--cr-icon-button-size:36px}@media (forced-colors:active){contextual-entrypoint-and-carousel::part(voice-icon){--cr-icon-button-fill-color:ButtonText}}:host([searchbox-next-enabled][searchbox-layout-mode='Compact']) #submitOverlay,:host([searchbox-next-enabled][searchbox-layout-mode='TallBottomContext']) #submitOverlay{position:relative}:host(:not([searchbox-next-enabled])) contextual-entrypoint-and-carousel::part(voice-icon),:host([searchbox-layout-mode='TallBottomContext']) contextual-entrypoint-and-carousel::part(voice-icon){bottom:12px;inset-inline-end:14px;position:absolute}:host([show-submit_][submit-enabled_]:not([searchbox-next-enabled])) contextual-entrypoint-and-carousel::part(voice-icon){inset-inline-end:calc(var(--cr-icon-button-size) + 18px)}:host([searchbox-layout-mode='TallTopContext']) contextual-entrypoint-and-carousel::part(voice-icon){margin-inline-end:14px;margin-inline-start:auto;position:static}:host([show-submit_][submit-enabled_][searchbox-layout-mode='TallTopContext']) contextual-entrypoint-and-carousel::part(voice-icon){margin-inline-end:0px}:host([show-submit_][submit-enabled_][searchbox-layout-mode='TallTopContext']) #submitContainer{margin-inline-end:10px;margin-inline-start:var(--cr-composebox-submit-button-margin-inline-start,4px);position:static}:host([show-submit_][submit-enabled_][searchbox-layout-mode='TallTopContext']) #submitIcon{margin-inline-end:12px;position:relative}:host([searchbox-layout-mode='Compact']) contextual-entrypoint-and-carousel::part(voice-icon){position:absolute;inset-inline-end:calc(var(--cr-composebox-submit-container-size) + 12px);top:10px}:host([searchbox-next-enabled][searchbox-layout-mode='Compact']) contextual-entrypoint-and-carousel::part(carousel-container),:host([searchbox-next-enabled][searchbox-layout-mode='TallBottomContext']) contextual-entrypoint-and-carousel::part(carousel-container){align-items:flex-end;display:flex;flex-direction:row}:host([show-submit_][submit-enabled_][searchbox-layout-mode='Compact']) #submitContainer{margin-inline-end:0px;margin-inline-start:auto;position:relative}:host([show-submit_][submit-enabled_][searchbox-layout-mode='Compact'][context-files-size_="0"]) #submitContainer{bottom:0px;margin-inline-end:-2px;margin-top:16px}:host([show-submit_][submit-enabled_][searchbox-layout-mode='Compact']:not([context-files-size_="0"])) #submitContainer{bottom:14px}:host([show-submit_][submit-enabled_][searchbox-layout-mode='TallBottomContext']) #submitContainer{inset-inline-end:10px;position:absolute}:host([show-submit_][submit-enabled_][searchbox-layout-mode='TallBottomContext']:not([show-dropdown_])) #submitContainer{bottom:10px}:host([show-submit_][submit-enabled_][searchbox-layout-mode='TallBottomContext'][show-dropdown_]) #submitContainer{top:var(--cr-composebox-submit-container-top,58px)}:host([show-submit_][submit-enabled_][searchbox-layout-mode='TallBottomContext'][show-dropdown_][context-files-size_="0"]) contextual-entrypoint-and-carousel::part(carousel-divider){--contextual-entrypoint-and-carousel-carousel-divider-margin-top:50px}:host([show-submit_][submit-enabled_][searchbox-layout-mode='Compact'][show-dropdown_][context-files-size_="0"]) contextual-entrypoint-and-carousel::part(carousel-divider){--contextual-entrypoint-and-carousel-carousel-divider-margin-top:12px}:host([show-submit_][submit-enabled_][searchbox-layout-mode='TallBottomContext'][show-dropdown_]:not([context-files-size_="0"])) contextual-entrypoint-and-carousel::part(carousel-divider),:host([show-submit_][submit-enabled_][searchbox-layout-mode='Compact'][show-dropdown_]:not([context-files-size_="0"])) contextual-entrypoint-and-carousel::part(carousel-divider){--contextual-entrypoint-and-carousel-carousel-divider-margin-top:8px}:host([show-submit_][submit-enabled_][searchbox-layout-mode='TallBottomContext']) contextual-entrypoint-and-carousel::part(voice-icon){inset-inline-end:calc(var(--cr-composebox-submit-container-size) + 18px)}:host([show-submit_][submit-enabled_][searchbox-layout-mode='TallBottomContext'][show-dropdown_]) contextual-entrypoint-and-carousel::part(voice-icon){bottom:unset;top:var(--cr-composebox-voice-icon-top,60px)}:host([searchbox-next-enabled]) contextual-entrypoint-and-carousel::part(context-menu-entrypoint-icon){--cr-icon-button-icon-size:24px;--cr-icon-button-margin-start:2px;--cr-icon-button-size:36px}:host([searchbox-next-enabled][searchbox-layout-mode^="Tall"]) contextual-entrypoint-and-carousel::part(context-menu-entrypoint-icon){--cr-icon-button-icon-size:20px}:host([searchbox-layout-mode='Compact']) contextual-entrypoint-and-carousel::part(cr-composebox-file-carousel){margin-top:14px}:host([in-voice-search-mode_]){box-shadow:2px 10px 18px -5px rgb(0,0,0,0.1)}:host([in-voice-search-mode_]) #suggestionActivity{display:none}:host([in-voice-search-mode_]) .icon-fade{opacity:0;transition:var(--icon-exit-transition)}:host([in-voice-search-mode_]) #composebox{opacity:0;visibility:hidden}cr-composebox-voice-search{opacity:1;@starting-style {opacity:0}transition:opacity 100ms ease-in-out,display 200ms allow-discrete;z-index:2}:host(:not([in-voice-search-mode_])) cr-composebox-voice-search{display:none;opacity:0}`])}function getHtml$a(){const submitContainer=html`
    <div id="submitContainer" class="icon-fade" part="submit"
        slot="${this.searchboxNextEnabled?"submit-button":nothing}"
        tabindex="-1"
        @click="${this.submitQuery_}"
        @focusin="${this.handleSubmitFocusIn_}">
      <div id="submitOverlay" part="submit-overlay"
          title="${this.i18n("composeboxSubmitButtonTitle")}">
      </div>
      <cr-icon-button
        class="action-icon icon-arrow-upward"
        id="submitIcon"
        part="action-icon submit-icon"
        tabindex="0"
        ?disabled="${!this.canSubmitFilesAndInput_}">
      </cr-icon-button>
    </div>`;return html`<!--_html_template_start_-->
  ${!this.disableComposeboxAnimation?html`
    <search-animated-glow
        animation-state="${this.animationState}"
        .entrypointName="${this.entrypointName}"
        .requiresVoice="${this.shouldShowVoiceSearchAnimation_()}"
        .transcript="${this.transcript_}"
        .receivedSpeech="${this.receivedSpeech_}"
        exportparts="composebox-background">
    </search-animated-glow>
  `:""}
  <ntp-error-scrim id="errorScrim" part="error-scrim"
    ?compact-mode="${this.searchboxLayoutMode==="Compact"&&this.contextFilesSize_===0}"
    @error-scrim-visibility-changed="${this.onErrorScrimVisibilityChanged_}">
  </ntp-error-scrim>
  <div id="composebox" @keydown="${this.onKeydown_}"
      @focusin="${this.handleComposeboxFocusIn_}"
      @focusout="${this.handleComposeboxFocusOut_}"
      @dragenter="${this.dragAndDropHandler_.handleDragEnter}"
      @dragover="${this.dragAndDropHandler_.handleDragOver}"
      @dragleave="${this.dragAndDropHandler_.handleDragLeave}"
      @drop="${this.dragAndDropHandler_.handleDrop}"
      @paste="${this.onPaste_}">
    <div id="inputContainer" part="input-container">
      <div id="textContainer" part="text-container">
        <div id="iconContainer" part="icon-container">
          <div id="aimIcon"></div>
        </div>
        <div id="inputWrapper">
          <textarea
            aria-expanded="${this.showDropdown_}" aria-controls="matches"
            role="combobox" autocomplete="off" id="input"
            type="search" spellcheck="false"
            placeholder="${this.inputPlaceholder_}"
            part="input"
            .value="${this.input_}"
            @input="${this.handleInput_}"
            @scroll="${this.handleScroll_}"
            @focusin="${this.handleInputFocusIn_}"
            @focusout="${this.handleInputFocusOut_}"></textarea>
          ${this.shouldShowSmartComposeInlineHint_()?html`
            <div id="smartCompose">
              <!-- Comments in between spans to eliminate spacing between
                   spans -->
              <span id="invisibleText">${this.input_}</span><!--
              --><span id="ghostText">${this.smartComposeInlineHint_}</span><!--
              --><span id="tabChip">${this.i18n("composeboxSmartComposeTabTitle")}</span>
            </div>
          `:""}
        </div>
      </div>
      <div id="cancelContainer" class="icon-fade" part="cancel">
        <cr-icon-button
            class="action-icon icon-clear"
            id="cancelIcon"
            part="action-icon cancel-icon"
            title="${this.computeCancelButtonTitle_()}"
            @click="${this.onCancelClick_}"
            ?disabled="${this.isCollapsible&&!this.submitEnabled_}">
        </cr-icon-button>
      </div>
      <contextual-entrypoint-and-carousel id="context" part="context-entrypoint"
          class="${this.carouselOnTop_&&this.isCollapsible?"icon-fade":""}"
          exportparts="context-menu-entrypoint-icon,
              cr-composebox-file-carousel, upload-container, voice-icon,
              carousel-divider, carousel-container, thumbnail"
          in-composebox
          .tabSuggestions="${this.tabSuggestions}"
          .entrypointName="${this.entrypointName?this.entrypointName:"Composebox"}"
          @add-tab-context="${this.addTabContext_}"
          @open-voice-search="${this.openAimVoiceSearch_}"
          @add-file-context="${this.addFileContext_}"
          @delete-context="${this.deleteContext_}"
          @on-file-validation-error="${this.onFileValidationError_}"
          @set-deep-search-mode="${this.setDeepSearchMode_}"
          @set-create-image-mode="${this.setCreateImageMode_}"
          @get-tab-preview="${this.getTabPreview_}"
          @open-file-dialog="${this.onOpenFileDialog_}"
          @context-menu-container-click="${this.searchboxLayoutMode==="Compact"?nothing:this.focusInput}"
          ?show-dropdown="${this.showDropdown_}"
          ?show-recent-tab-chip="${false}"
          searchbox-layout-mode="${this.searchboxLayoutMode}"
          ?carousel-on-top_="${this.carouselOnTop_}"
          ?show-voice-search="${this.shouldShowVoiceSearch_()}"
          .submitButtonShown="${this.searchboxNextEnabled&&this.submitEnabled_&&this.showSubmit_}">
        <cr-composebox-dropdown
            id="matches"
            part="dropdown"
            exportparts="match-text-container"
            role="listbox"
            .result="${this.result_}"
            .selectedMatchIndex="${this.selectedMatchIndex_}"
            .maxSuggestions="${this.maxSuggestions}"
            .inDeepSearchMode="${this.inDeepSearchMode_}"
            @selected-match-index-changed="${this.onSelectedMatchIndexChanged_}"
            @match-focusin="${this.onMatchFocusin_}"
            @match-click="${this.onMatchClick_}"
            ?hidden="${!this.showDropdown_}"
            .lastQueriedInput="${this.lastQueriedInput_}">
        </cr-composebox-dropdown>
        ${this.searchboxNextEnabled?submitContainer:""}
      </contextual-entrypoint-and-carousel>
    </div>
    <!-- A seperate container is needed for the submit button so the
    expand/collapse animation can be applied without affecting the submit
    button enabled/disabled state. -->
    ${this.showLensButton?html`<cr-icon-button
        class="action-icon"
        id="lensIcon"
        part="action-icon lens-icon"
        title="${this.i18n("lensSearchButtonLabel")}"
        @click="${this.onLensClick_}"
        ?disabled="${this.lensButtonDisabled}"
        @mousedown="${this.onLensIconMouseDown_}">
    </cr-icon-button>`:""}
    <!-- Elements rendered under the input container. -->
    <!-- TODO: Move the submit button and Lens icon into this slot. -->
    <slot name="footer"></slot>
    <!-- A seperate container is needed for the submit button so the
       expand/collapse animation can be applied without affecting the submit
       button enabled/disabled state. -->
    ${this.searchboxNextEnabled?"":submitContainer}
  </div>
  <cr-composebox-voice-search id="voiceSearch"
      @voice-search-cancel="${this.onVoiceSearchClose_}"
      @voice-search-final-result="${this.onVoiceSearchFinalResult_}"
      @transcript-update="${this.onTranscriptUpdate_}"
      @speech-received="${this.onSpeechReceived_}"
      exportparts="voice-close-button">
  </cr-composebox-voice-search>
  ${this.shouldShowSuggestionActivityLink_()?html`
    <div id="suggestionActivity">
      <localized-link
        localized-string="${this.i18nAdvanced("suggestionActivityLink")}">
      </localized-link>
    </div>
  `:""}
<!--_html_template_end_-->`}var VoiceSearchAction;(function(VoiceSearchAction){VoiceSearchAction[VoiceSearchAction["ACTIVATE"]=0]="ACTIVATE";VoiceSearchAction[VoiceSearchAction["QUERY_SUBMITTED"]=1]="QUERY_SUBMITTED"})(VoiceSearchAction||(VoiceSearchAction={}));const DEBOUNCE_TIMEOUT_MS=20;function debounce(context,func,delay){let timeout;return function(...args){clearTimeout(timeout);timeout=setTimeout((()=>func.apply(context,args)),delay)}}class ComposeboxElement extends(I18nMixinLit(CrLitElement)){static get is(){return"cr-composebox"}static get styles(){return getCss$c()}render(){return getHtml$a.bind(this)()}static get properties(){return{showLensButton:{type:Boolean},lensButtonTriggersOverlay:{type:Boolean},input_:{type:String},isCollapsible:{reflect:true,type:Boolean},expanding_:{reflect:true,type:Boolean},result_:{type:Object},submitEnabled_:{reflect:true,type:Boolean},selectedMatchIndex_:{type:Number},showDropdown_:{reflect:true,type:Boolean},showSubmit_:{reflect:true,type:Boolean},animationState:{reflect:true,type:String},enableImageContextualSuggestions_:{reflect:true,type:Boolean},inputPlaceholder_:{reflect:true,type:String},smartComposeEnabled_:{reflect:true,type:Boolean},smartComposeInlineHint_:{type:String},showFileCarousel_:{reflect:true,type:Boolean},inDeepSearchMode_:{reflect:true,type:Boolean},isDraggingFile:{reflect:true,type:Boolean},inCreateImageMode_:{reflect:true,type:Boolean},ntpRealboxNextEnabled:{type:Boolean},searchboxNextEnabled:{type:Boolean,reflect:true},tabSuggestions:{type:Array},lensButtonDisabled:{reflect:true,type:Boolean},errorScrimVisible_:{type:Boolean},contextFilesSize_:{type:Number,reflect:true},searchboxLayoutMode:{type:String,reflect:true},carouselOnTop_:{type:Boolean},inVoiceSearchMode_:{type:Boolean,reflect:true},entrypointName:{type:String},transcript_:{type:String},receivedSpeech_:{type:Boolean},maxSuggestions:{type:Number},disableVoiceSearchAnimation:{type:Boolean},disableCaretColorAnimation:{type:Boolean,reflect:true},disableComposeboxAnimation:{type:Boolean},fileUploadsComplete:{type:Boolean},canSubmitFilesAndInput_:{type:Boolean}}}#disableCaretColorAnimation_accessor_storage=false;get disableCaretColorAnimation(){return this.#disableCaretColorAnimation_accessor_storage}set disableCaretColorAnimation(value){this.#disableCaretColorAnimation_accessor_storage=value}#disableComposeboxAnimation_accessor_storage=false;get disableComposeboxAnimation(){return this.#disableComposeboxAnimation_accessor_storage}set disableComposeboxAnimation(value){this.#disableComposeboxAnimation_accessor_storage=value}#lensButtonTriggersOverlay_accessor_storage=false;get lensButtonTriggersOverlay(){return this.#lensButtonTriggersOverlay_accessor_storage}set lensButtonTriggersOverlay(value){this.#lensButtonTriggersOverlay_accessor_storage=value}#fileUploadsComplete_accessor_storage=true;get fileUploadsComplete(){return this.#fileUploadsComplete_accessor_storage}set fileUploadsComplete(value){this.#fileUploadsComplete_accessor_storage=value}#maxSuggestions_accessor_storage=null;get maxSuggestions(){return this.#maxSuggestions_accessor_storage}set maxSuggestions(value){this.#maxSuggestions_accessor_storage=value}#showLensButton_accessor_storage=true;get showLensButton(){return this.#showLensButton_accessor_storage}set showLensButton(value){this.#showLensButton_accessor_storage=value}#ntpRealboxNextEnabled_accessor_storage=false;get ntpRealboxNextEnabled(){return this.#ntpRealboxNextEnabled_accessor_storage}set ntpRealboxNextEnabled(value){this.#ntpRealboxNextEnabled_accessor_storage=value}#searchboxNextEnabled_accessor_storage=false;get searchboxNextEnabled(){return this.#searchboxNextEnabled_accessor_storage}set searchboxNextEnabled(value){this.#searchboxNextEnabled_accessor_storage=value}#searchboxLayoutMode_accessor_storage="";get searchboxLayoutMode(){return this.#searchboxLayoutMode_accessor_storage}set searchboxLayoutMode(value){this.#searchboxLayoutMode_accessor_storage=value}#carouselOnTop__accessor_storage=false;get carouselOnTop_(){return this.#carouselOnTop__accessor_storage}set carouselOnTop_(value){this.#carouselOnTop__accessor_storage=value}#isDraggingFile_accessor_storage=false;get isDraggingFile(){return this.#isDraggingFile_accessor_storage}set isDraggingFile(value){this.#isDraggingFile_accessor_storage=value}#animationState_accessor_storage=GlowAnimationState.NONE;get animationState(){return this.#animationState_accessor_storage}set animationState(value){this.#animationState_accessor_storage=value}#entrypointName_accessor_storage="";get entrypointName(){return this.#entrypointName_accessor_storage}set entrypointName(value){this.#entrypointName_accessor_storage=value}#disableVoiceSearchAnimation_accessor_storage=false;get disableVoiceSearchAnimation(){return this.#disableVoiceSearchAnimation_accessor_storage}set disableVoiceSearchAnimation(value){this.#disableVoiceSearchAnimation_accessor_storage=value}#tabSuggestions_accessor_storage=[];get tabSuggestions(){return this.#tabSuggestions_accessor_storage}set tabSuggestions(value){this.#tabSuggestions_accessor_storage=value}#lensButtonDisabled_accessor_storage=false;get lensButtonDisabled(){return this.#lensButtonDisabled_accessor_storage}set lensButtonDisabled(value){this.#lensButtonDisabled_accessor_storage=value}composeboxNoFlickerSuggestionsFix_=loadTimeData.getBoolean("composeboxNoFlickerSuggestionsFix");#isCollapsible_accessor_storage=false;get isCollapsible(){return this.#isCollapsible_accessor_storage}set isCollapsible(value){this.#isCollapsible_accessor_storage=value}#expanding__accessor_storage=false;get expanding_(){return this.#expanding__accessor_storage}set expanding_(value){this.#expanding__accessor_storage=value}#input__accessor_storage="";get input_(){return this.#input__accessor_storage}set input_(value){this.#input__accessor_storage=value}#showDropdown__accessor_storage=loadTimeData.getBoolean("composeboxShowZps");get showDropdown_(){return this.#showDropdown__accessor_storage}set showDropdown_(value){this.#showDropdown__accessor_storage=value}#showSubmit__accessor_storage=loadTimeData.getBoolean("composeboxShowSubmit");get showSubmit_(){return this.#showSubmit__accessor_storage}set showSubmit_(value){this.#showSubmit__accessor_storage=value}#enableImageContextualSuggestions__accessor_storage=loadTimeData.getBoolean("composeboxShowImageSuggest");get enableImageContextualSuggestions_(){return this.#enableImageContextualSuggestions__accessor_storage}set enableImageContextualSuggestions_(value){this.#enableImageContextualSuggestions__accessor_storage=value}#selectedMatchIndex__accessor_storage=-1;get selectedMatchIndex_(){return this.#selectedMatchIndex__accessor_storage}set selectedMatchIndex_(value){this.#selectedMatchIndex__accessor_storage=value}#submitEnabled__accessor_storage=false;get submitEnabled_(){return this.#submitEnabled__accessor_storage}set submitEnabled_(value){this.#submitEnabled__accessor_storage=value}#result__accessor_storage=null;get result_(){return this.#result__accessor_storage}set result_(value){this.#result__accessor_storage=value}#smartComposeInlineHint__accessor_storage="";get smartComposeInlineHint_(){return this.#smartComposeInlineHint__accessor_storage}set smartComposeInlineHint_(value){this.#smartComposeInlineHint__accessor_storage=value}#smartComposeEnabled__accessor_storage=loadTimeData.getBoolean("composeboxSmartComposeEnabled");get smartComposeEnabled_(){return this.#smartComposeEnabled__accessor_storage}set smartComposeEnabled_(value){this.#smartComposeEnabled__accessor_storage=value}#inputPlaceholder__accessor_storage=loadTimeData.getString("searchboxComposePlaceholder");get inputPlaceholder_(){return this.#inputPlaceholder__accessor_storage}set inputPlaceholder_(value){this.#inputPlaceholder__accessor_storage=value}#showFileCarousel__accessor_storage=false;get showFileCarousel_(){return this.#showFileCarousel__accessor_storage}set showFileCarousel_(value){this.#showFileCarousel__accessor_storage=value}#inCreateImageMode__accessor_storage=false;get inCreateImageMode_(){return this.#inCreateImageMode__accessor_storage}set inCreateImageMode_(value){this.#inCreateImageMode__accessor_storage=value}#inDeepSearchMode__accessor_storage=false;get inDeepSearchMode_(){return this.#inDeepSearchMode__accessor_storage}set inDeepSearchMode_(value){this.#inDeepSearchMode__accessor_storage=value}#errorScrimVisible__accessor_storage=false;get errorScrimVisible_(){return this.#errorScrimVisible__accessor_storage}set errorScrimVisible_(value){this.#errorScrimVisible__accessor_storage=value}#contextFilesSize__accessor_storage=0;get contextFilesSize_(){return this.#contextFilesSize__accessor_storage}set contextFilesSize_(value){this.#contextFilesSize__accessor_storage=value}#transcript__accessor_storage="";get transcript_(){return this.#transcript__accessor_storage}set transcript_(value){this.#transcript__accessor_storage=value}#receivedSpeech__accessor_storage=false;get receivedSpeech_(){return this.#receivedSpeech__accessor_storage}set receivedSpeech_(value){this.#receivedSpeech__accessor_storage=value}#canSubmitFilesAndInput__accessor_storage=true;get canSubmitFilesAndInput_(){return this.#canSubmitFilesAndInput__accessor_storage}set canSubmitFilesAndInput_(value){this.#canSubmitFilesAndInput__accessor_storage=value}lastQueriedInput_="";showVoiceSearchInSteadyComposebox_=loadTimeData.getBoolean("steadyComposeboxShowVoiceSearch");showVoiceSearchInExpandedComposebox_=loadTimeData.getBoolean("expandedComposeboxShowVoiceSearch");dragAndDropHandler_;showTypedSuggest_=loadTimeData.getBoolean("composeboxShowTypedSuggest");showTypedSuggestWithContext_=loadTimeData.getBoolean("composeboxShowTypedSuggestWithContext");showZps=loadTimeData.getBoolean("composeboxShowZps");browserProxy=ComposeboxProxyImpl.getInstance();searchboxCallbackRouter_;pageHandler_;searchboxHandler_;eventTracker_=new EventTracker;searchboxListenerIds=[];resizeObservers_=[];composeboxCloseByEscape_=loadTimeData.getBoolean("composeboxCloseByEscape");dragAndDropEnabled_=loadTimeData.getBoolean("composeboxContextDragAndDropEnabled");clearAllInputsWhenSubmittingQuery_=loadTimeData.valueExists("clearAllInputsWhenSubmittingQuery")?loadTimeData.getBoolean("clearAllInputsWhenSubmittingQuery"):false;autoSubmitVoiceSearch=loadTimeData.valueExists("autoSubmitVoiceSearchQuery")?loadTimeData.getBoolean("autoSubmitVoiceSearchQuery"):true;#inVoiceSearchMode__accessor_storage=false;get inVoiceSearchMode_(){return this.#inVoiceSearchMode__accessor_storage}set inVoiceSearchMode_(value){this.#inVoiceSearchMode__accessor_storage=value}selectedMatch_=null;haveReceivedAutcompleteResponse_=false;isVoiceInput_=false;pendingUploads_=new Set([]);constructor(){super();this.pageHandler_=ComposeboxProxyImpl.getInstance().handler;this.searchboxCallbackRouter_=ComposeboxProxyImpl.getInstance().searchboxCallbackRouter;this.searchboxHandler_=ComposeboxProxyImpl.getInstance().searchboxHandler;this.dragAndDropHandler_=new DragAndDropHandler(this,this.dragAndDropEnabled_)}connectedCallback(){super.connectedCallback();this.expanding_=!this.isCollapsible;this.animationState=this.isCollapsible?GlowAnimationState.NONE:GlowAnimationState.EXPANDING;this.searchboxListenerIds=[this.searchboxCallbackRouter_.autocompleteResultChanged.addListener(this.onAutocompleteResultChanged_.bind(this)),this.searchboxCallbackRouter_.onContextualInputStatusChanged.addListener(this.onContextualInputStatusChanged_.bind(this)),this.searchboxCallbackRouter_.onTabStripChanged.addListener(this.refreshTabSuggestions_.bind(this)),this.searchboxCallbackRouter_.addFileContext.addListener(this.addFileContextFromBrowser_.bind(this)),this.searchboxCallbackRouter_.updateAutoSuggestedTabContext.addListener(this.updateAutoSuggestedTabContext_.bind(this))];this.eventTracker_.add(this.$.input,"input",(()=>{this.submitEnabled_=this.computeSubmitEnabled_()}));this.eventTracker_.add(this.$.context,"on-context-files-changed",(e=>{this.contextFilesSize_=e.detail.files;this.showFileCarousel_=this.contextFilesSize_>0;this.submitEnabled_=this.computeSubmitEnabled_()}));this.eventTracker_.add(this.$.context,"carousel-resize",(e=>{this.fire("composebox-resize",{carouselHeight:e.detail.height})}));this.focusInput();if(this.showZps&&!this.searchboxNextEnabled){this.queryAutocomplete(false)}this.searchboxHandler_.notifySessionStarted();this.refreshTabSuggestions_();if(this.ntpRealboxNextEnabled){this.fire("composebox-initialized",{initializeComposeboxState:this.initializeState_.bind(this)})}this.setupResizeObservers_()}setupResizeObservers_(){const composeboxResizeObserver=new ResizeObserver(debounce(this,(()=>{this.fire("composebox-resize",{height:this.offsetHeight})}),DEBOUNCE_TIMEOUT_MS));this.resizeObservers_.push(composeboxResizeObserver);composeboxResizeObserver.observe(this);const composeboxDropdownResizeObserver=new ResizeObserver(debounce(this,(()=>{this.fire("composebox-resize",{dropdownHeight:this.$.matches.offsetHeight})}),DEBOUNCE_TIMEOUT_MS));this.resizeObservers_.push(composeboxDropdownResizeObserver);composeboxDropdownResizeObserver.observe(this.$.matches)}disconnectedCallback(){super.disconnectedCallback();this.searchboxHandler_.notifySessionAbandoned();this.searchboxListenerIds.forEach((id=>assert(this.browserProxy.searchboxCallbackRouter.removeListener(id))));this.searchboxListenerIds=[];this.eventTracker_.removeAll();for(const observer of this.resizeObservers_){observer.disconnect()}this.resizeObservers_=[]}willUpdate(changedProperties){super.willUpdate(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("input_")||changedPrivateProperties.has("result_")||changedPrivateProperties.has("contextFilesSize_")||changedPrivateProperties.has("errorScrimVisible_")){this.showDropdown_=this.computeShowDropdown_()}if(changedPrivateProperties.has("submitEnabled_")||changedPrivateProperties.has("fileUploadsComplete")){this.canSubmitFilesAndInput_=this.submitEnabled_&&this.fileUploadsComplete}}updated(changedProperties){super.updated(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("selectedMatchIndex_")){if(this.selectedMatch_){if(!(this.selectedMatchIndex_===0&&this.selectedMatch_.allowedToBeDefaultMatch)){const text=this.selectedMatch_.fillIntoEdit;assert(text);this.input_=text;this.submitEnabled_=true}}else if(!this.lastQueriedInput_){this.clearInput();this.submitEnabled_=this.contextFilesSize_>0}else{this.input_=this.lastQueriedInput_}}if(changedPrivateProperties.has("smartComposeInlineHint_")){if(this.smartComposeInlineHint_){this.adjustInputForSmartCompose();const announcer=getInstance();announcer.announce(this.smartComposeInlineHint_+", "+this.i18n("composeboxSmartComposeTitle"))}else{this.$.input.style.height="unset"}}}getDropTarget(){return this.$.context}focusInput(){this.$.input.focus()}getText(){return this.input_}get isVoiceInput(){return this.isVoiceInput_}playGlowAnimation(){this.animationState=GlowAnimationState.NONE;if(this.expanding_&&!this.submitEnabled_){requestAnimationFrame((()=>{this.animationState=GlowAnimationState.EXPANDING}))}}setText(text){this.input_=text}resetModes(){this.$.context.resetModes()}closeDropdown(){this.clearAutocompleteMatches()}getSmartComposeForTesting(){return this.smartComposeInlineHint_}getMatchesElement(){return this.$.matches}getHasAutomaticActiveTabChipToken(){return this.$.context.hasAutomaticActiveTabChipToken()}getAutomaticActiveTabChipElement(){return this.$.context.getAutomaticActiveTabChipElement()}initializeState_(text="",files=[],mode=ComposeboxMode.DEFAULT){if(text){this.input_=text;this.lastQueriedInput_=text}if(this.showZps&&files.length===0){this.queryAutocomplete(false)}if(files.length>0){this.$.context.setContextFiles(files)}if(mode!==ComposeboxMode.DEFAULT){this.$.context.setInitialMode(mode)}}computeCancelButtonTitle_(){return this.input_.trim().length>0||this.contextFilesSize_>0?this.i18n("composeboxCancelButtonTitleInput"):this.i18n("composeboxCancelButtonTitle")}computeShowDropdown_(){if(this.contextFilesSize_>1){return false}if(!this.result_?.matches.length){return false}if(this.errorScrimVisible_){return false}if(this.showTypedSuggest_&&this.lastQueriedInput_.trim()){if(!this.showTypedSuggestWithContext_&&this.contextFilesSize_>0){return false}if(this.$.input.scrollHeight<=48&&this.result_?.matches.length>1){return true}}return this.showZps&&!this.lastQueriedInput_}computeSubmitEnabled_(){return this.input_.trim().length>0||this.contextFilesSize_>0&&this.$.context.hasDeletableFiles()}shouldShowSuggestionActivityLink_(){if(!this.result_||!this.showDropdown_){return false}return this.result_.matches.some((match=>match.isNoncannedAimSuggestion))}shouldShowSmartComposeInlineHint_(){return!!this.smartComposeInlineHint_}shouldShowVoiceSearch_(){const isExpanded=this.showDropdown_||this.contextFilesSize_>0;return isExpanded?this.showVoiceSearchInExpandedComposebox_:this.showVoiceSearchInSteadyComposebox_}shouldShowVoiceSearchAnimation_(){return!this.disableVoiceSearchAnimation&&this.shouldShowVoiceSearch_()}onFileValidationError_(e){this.$.errorScrim.setErrorMessage(e.detail.errorMessage)}onTranscriptUpdate_(e){this.transcript_=e.detail}onSpeechReceived_(){this.receivedSpeech_=true}async deleteContext_(e){if(this.inCreateImageMode_){await this.setCreateImageMode_({detail:{inCreateImageMode:true,imagePresent:this.$.context.hasImageFiles()}})}this.pendingUploads_.delete(e.detail.uuid);this.fileUploadsComplete=this.pendingUploads_.size===0;this.searchboxHandler_.deleteContext(e.detail.uuid,e.detail.fromAutoSuggestedChip||false);this.focusInput();this.queryAutocomplete(true)}async addFileContext_(e){const composeboxFiles=new Map;for(const file of e.detail.files){const fileBuffer=await file.arrayBuffer();const bigBuffer={bytes:Array.from(new Uint8Array(fileBuffer))};const{token:token}=await this.searchboxHandler_.addFileContext({fileName:file.name,imageDataUrl:null,mimeType:file.type,isDeletable:true,selectionTime:new Date},bigBuffer);const attachment={uuid:token,name:file.name,dataUrl:null,objectUrl:file.type.includes("image")?URL.createObjectURL(file):null,type:file.type,status:FileUploadStatus$1.kNotUploaded,url:null,tabId:null,isDeletable:true};this.pendingUploads_.add(token);composeboxFiles.set(token,attachment);const announcer=getInstance();announcer.announce(this.i18n("composeboxFileUploadStartedText"))}this.fileUploadsComplete=false;e.detail.onContextAdded(composeboxFiles);this.focusInput()}addFileContextFromBrowser_(uuid,fileInfo){const attachment={uuid:uuid,name:fileInfo.fileName,dataUrl:fileInfo.imageDataUrl??null,objectUrl:null,type:fileInfo.imageDataUrl?"image":"pdf",status:fileInfo.imageDataUrl?FileUploadStatus$1.kUploadSuccessful:FileUploadStatus$1.kNotUploaded,url:null,tabId:null,isDeletable:fileInfo.isDeletable};this.$.context.onFileContextAdded(attachment)}updateAutoSuggestedTabContext_(tab){this.$.context.updateAutoActiveTabContext(tab)}async addTabContext_(e){const{token:token}=await this.searchboxHandler_.addTabContext(e.detail.id,e.detail.delayUpload);if(!token){return}const attachment={uuid:token,name:e.detail.title,dataUrl:null,objectUrl:null,type:"tab",status:FileUploadStatus$1.kNotUploaded,url:e.detail.url,tabId:e.detail.id,isDeletable:true};e.detail.onContextAdded(attachment);this.focusInput()}onPaste_(event){if(!event.clipboardData?.items){return}const dataTransfer=new DataTransfer;for(const item of event.clipboardData.items){if(item.kind==="file"){const file=item.getAsFile();if(file){dataTransfer.items.add(file)}}}const fileList=dataTransfer.files;if(fileList.length>0){event.preventDefault();this.$.context.addPastedFiles(fileList)}}async refreshTabSuggestions_(){const{tabs:tabs}=await this.searchboxHandler_.getRecentTabs();this.tabSuggestions=[...tabs]}async getTabPreview_(e){const{previewDataUrl:previewDataUrl}=await this.searchboxHandler_.getTabPreview(e.detail.tabId);e.detail.onPreviewFetched(previewDataUrl||"")}voiceSearchEndCleanup_(){this.inVoiceSearchMode_=false;this.animationState=GlowAnimationState.NONE}async onVoiceSearchFinalResult_(e){e.stopPropagation();this.voiceSearchEndCleanup_();if(this.autoSubmitVoiceSearch){this.fire("voice-search-action",{value:VoiceSearchAction.QUERY_SUBMITTED});this.searchboxHandler_.submitQuery(e.detail,0,false,false,false,false)}else{this.input_=e.detail;this.clearAutocompleteMatches();this.submitEnabled_=this.computeSubmitEnabled_();this.isVoiceInput_=true;await this.updateComplete;this.focusInput()}}openAimVoiceSearch_(){this.inVoiceSearchMode_=true;this.animationState=GlowAnimationState.LISTENING;this.fire("voice-search-action",{value:VoiceSearchAction.ACTIVATE});this.$.voiceSearch.start()}onVoiceSearchClose_(){this.voiceSearchEndCleanup_();this.receivedSpeech_=false}onCancelClick_(){if(this.hasContent_()){this.resetModes();this.clearAllInputs(false);this.focusInput();this.queryAutocomplete(true)}else{this.closeComposebox_()}}handleEscapeKeyLogic(){if(!this.composeboxCloseByEscape_&&this.hasContent_()){this.resetModes();this.clearAllInputs(false);this.focusInput();this.queryAutocomplete(true)}else{this.closeComposebox_()}}hasContent_(){return this.inDeepSearchMode_||this.inCreateImageMode_||this.input_.trim().length>0||this.contextFilesSize_>0}onLensClick_(){if(this.lensButtonTriggersOverlay){this.pageHandler_.handleLensButtonClick()}else{this.pageHandler_.handleFileUpload(true)}}onOpenFileDialog_(e){this.pageHandler_.handleFileUpload(e.detail.isImage)}onLensIconMouseDown_(e){e.preventDefault()}updateInputPlaceholder_(){if(this.inDeepSearchMode_){this.inputPlaceholder_=loadTimeData.getString("composeDeepSearchPlaceholder")}else if(this.inCreateImageMode_){this.inputPlaceholder_=loadTimeData.getString("composeCreateImagePlaceholder")}else{this.inputPlaceholder_=loadTimeData.getString("searchboxComposePlaceholder")}}async setDeepSearchMode_(e){this.inDeepSearchMode_=e.detail.inDeepSearchMode;this.pageHandler_.setDeepSearchMode(e.detail.inDeepSearchMode);this.queryAutocomplete(true);this.updateInputPlaceholder_();await this.updateComplete;this.focusInput()}async setCreateImageMode_(e){this.inCreateImageMode_=e.detail.inCreateImageMode;this.pageHandler_.setCreateImageMode(e.detail.inCreateImageMode,e.detail.imagePresent);this.queryAutocomplete(true);this.updateInputPlaceholder_();await this.updateComplete;this.focusInput()}onErrorScrimVisibilityChanged_(e){this.errorScrimVisible_=e.detail.showErrorScrim}handleInput_(e){const inputElement=e.target;if(inputElement.value===""){this.isVoiceInput_=false}this.input_=inputElement.value;if(this.composeboxNoFlickerSuggestionsFix_){if(this.input_===""){this.searchboxHandler_.stopAutocomplete(true)}this.queryAutocomplete(false)}else{this.queryAutocomplete(this.input_==="")}}onKeydown_(e){const KEYDOWN_HANDLED_KEYS=["ArrowDown","ArrowUp","Enter","Escape","PageDown","PageUp","Tab"];if(!KEYDOWN_HANDLED_KEYS.includes(e.key)){return}if(this.shadowRoot.activeElement===this.$.input){if((e.key==="ArrowDown"||e.key==="ArrowUp")&&!this.showDropdown_){return}if(e.key==="Tab"){if(e.shiftKey){this.$.matches.unselect()}else if(this.smartComposeEnabled_&&this.smartComposeInlineHint_){this.input_=this.input_+this.smartComposeInlineHint_;this.smartComposeInlineHint_="";e.preventDefault();this.queryAutocomplete(true)}return}}if(e.key==="Enter"&&this.canSubmitFilesAndInput_){if(this.shadowRoot.activeElement===this.$.matches||!e.shiftKey){e.preventDefault();this.submitQuery_(e)}}if(e.key==="Escape"){this.handleEscapeKeyLogic();e.stopPropagation();e.preventDefault();return}if(!this.result_||this.result_.matches.length===0){return}if(hasKeyModifiers(e)){return}if(e.key==="ArrowDown"){this.$.matches.selectNext()}else if(e.key==="ArrowUp"){this.$.matches.selectPrevious()}else if(e.key==="Escape"||e.key==="PageUp"){this.selectFirstMatch()}else if(e.key==="PageDown"){this.$.matches.selectLast()}else if(e.key==="Tab"){if(this.selectedMatchIndex_===this.result_.matches.length-1){if(this.selectedMatch_.supportsDeletion){const focusedMatchElem=this.shadowRoot.activeElement?.shadowRoot?.activeElement;const focusedButtonElem=focusedMatchElem?.shadowRoot?.activeElement;if(focusedButtonElem?.id==="remove"){this.$.matches.unselect()}}else{this.$.matches.unselect()}}return}this.smartComposeInlineHint_="";e.preventDefault();if(this.shadowRoot.activeElement===this.$.matches){this.$.matches.focusSelected()}}handleInputFocusIn_(){if(this.lastQueriedInput_){this.selectFirstMatch()}if(this.ntpRealboxNextEnabled){this.fire("composebox-input-focus-changed",{value:true})}}handleInputFocusOut_(){if(this.ntpRealboxNextEnabled){this.fire("composebox-input-focus-changed",{value:false})}}handleComposeboxFocusIn_(e){if(this.$.composebox.contains(e.relatedTarget)){return}if(this.isCollapsible){this.queryAutocomplete(true)}this.expanding_=true;this.pageHandler_.focusChanged(true);this.fire("composebox-focus-in")}handleComposeboxFocusOut_(e){if(this.$.composebox.contains(e.relatedTarget)){return}this.expanding_=this.isCollapsible?this.submitEnabled_:true;this.pageHandler_.focusChanged(false);this.fire("composebox-focus-out")}handleScroll_(){const smartCompose=this.shadowRoot.querySelector("#smartCompose");if(!smartCompose){return}smartCompose.scrollTop=this.$.input.scrollTop}handleSubmitFocusIn_(){if(this.input_&&!this.selectedMatch_){this.selectFirstMatch()}}addSearchContext(context){if(context){if(context.input.length>0){this.input_=context.input}this.$.context.addSearchContext(context)}if(this.showZps){this.queryAutocomplete(false)}}closeComposebox_(){this.resetModes();this.fire("close-composebox",{composeboxText:this.input_});if(this.isCollapsible){this.expanding_=false;this.animationState=GlowAnimationState.NONE;this.$.input.blur()}}submitQuery_(e){if(!this.canSubmitFilesAndInput_){return}assert(this.selectedMatchIndex_>=0&&this.result_||this.contextFilesSize_>0||this.isVoiceInput_,"Cannot submit query with no autocomplete matches and no files in "+"context.");if(this.selectedMatchIndex_>=0){const match=this.result_.matches[this.selectedMatchIndex_];assert(match);this.searchboxHandler_.openAutocompleteMatch(this.selectedMatchIndex_,match.destinationUrl,true,e.button||0,e.altKey,e.ctrlKey,e.metaKey,e.shiftKey)}else{this.searchboxHandler_.submitQuery(this.input_.trim(),e.button||0,e.altKey,e.ctrlKey,e.metaKey,e.shiftKey)}this.isVoiceInput_=false;this.animationState=GlowAnimationState.SUBMITTING;if(this.isCollapsible||this.clearAllInputsWhenSubmittingQuery_){this.clearAllInputs(true)}if(this.isCollapsible){this.submitEnabled_=this.computeSubmitEnabled_();assert(!this.submitEnabled_);this.$.input.blur()}this.fire("composebox-submit")}onMatchFocusin_(e){this.$.matches.selectIndex(e.detail.index)}onMatchClick_(){this.clearAutocompleteMatches()}onSelectedMatchIndexChanged_(e){this.selectedMatchIndex_=e.detail.value;this.selectedMatch_=this.result_?.matches[this.selectedMatchIndex_]||null}clearAutocompleteMatches(){this.showDropdown_=false;this.result_=null;this.$.matches.unselect();this.searchboxHandler_.stopAutocomplete(true);this.lastQueriedInput_=""}getRemainingFilesToUpload(){return this.pendingUploads_}setPendingUploads(files){this.pendingUploads_=new Set(files)}onAutocompleteResultChanged_(result){if(this.lastQueriedInput_===null||this.lastQueriedInput_.trimStart()!==result.input){return}if(this.composeboxNoFlickerSuggestionsFix_&&this.showTypedSuggest_&&!this.haveReceivedAutcompleteResponse_){if(this.result_&&this.result_.matches.length>0&&result.matches.length<=1){result.matches.push(...this.result_.matches.filter((match=>match.type!=="search-what-you-typed")))}this.haveReceivedAutcompleteResponse_=true}this.haveReceivedAutcompleteResponse_=true;this.result_=result;const hasMatches=this.result_.matches.length>0;const firstMatch=hasMatches?this.result_.matches[0]:null;if(firstMatch&&firstMatch.allowedToBeDefaultMatch){this.selectFirstMatch()}else if(this.input_.trim()&&hasMatches&&this.selectedMatchIndex_>=0&&this.selectedMatchIndex_<this.result_.matches.length){this.$.matches.selectIndex(this.selectedMatchIndex_);this.selectedMatch_=this.result_.matches[this.selectedMatchIndex_];this.input_=this.selectedMatch_.fillIntoEdit}else{this.$.matches.unselect()}this.smartComposeInlineHint_=this.result_.smartComposeInlineHint?this.result_.smartComposeInlineHint:""}async onContextualInputStatusChanged_(token,status,errorType){const{file:file,errorMessage:errorMessage}=this.$.context.updateFileStatus(token,status,errorType);if(errorMessage){if(!this.$.errorScrim.isErrorScrimShowing()){this.$.errorScrim.setErrorMessage(errorMessage)}}else if(file){if(status===FileUploadStatus$1.kProcessingSuggestSignalsReady&&this.showZps&&!file.type.includes("image")){this.queryAutocomplete(true)}if(file.status===FileUploadStatus$1.kProcessing){this.pendingUploads_.add(file.uuid)}const isFinished=file?.status===FileUploadStatus$1.kValidationFailed||file.status===FileUploadStatus$1.kUploadSuccessful||file.status===FileUploadStatus$1.kUploadExpired||file.status===FileUploadStatus$1.kUploadFailed;if(isFinished){this.pendingUploads_.delete(file.uuid);this.fileUploadsComplete=this.pendingUploads_.size===0}if(status===FileUploadStatus$1.kProcessingSuggestSignalsReady&&file.type.includes("image")){if(this.inCreateImageMode_){await this.setCreateImageMode_({detail:{inCreateImageMode:true,imagePresent:true}})}else if(this.enableImageContextualSuggestions_){this.queryAutocomplete(true)}else{this.showDropdown_=false}}if(status===FileUploadStatus$1.kProcessing&&file.type.includes("tab")){this.queryAutocomplete(true)}if(status===FileUploadStatus$1.kUploadSuccessful){const announcer=getInstance();announcer.announce(this.i18n("composeboxFileUploadCompleteText"))}}}adjustInputForSmartCompose(){const smartCompose=this.shadowRoot.querySelector("#smartCompose");const ghostHeight=smartCompose.scrollHeight;const maxHeight=190;this.$.input.style.height=`${Math.min(ghostHeight,maxHeight)}px`;if(ghostHeight>48){this.$.input.style.minHeight=`68px`;smartCompose.style.minHeight=`68px`}if(ghostHeight>maxHeight){smartCompose.scrollTop=this.$.input.scrollTop}}queryAutocomplete(clearMatches){if(this.isVoiceInput_){return}if(clearMatches){this.clearAutocompleteMatches()}this.lastQueriedInput_=this.input_;this.haveReceivedAutcompleteResponse_=false;this.searchboxHandler_.queryAutocomplete(this.input_,false)}clearAllInputs(querySubmitted){this.clearInput();const remainingFiles=this.$.context.resetContextFiles();this.setPendingUploads(remainingFiles);this.contextFilesSize_=0;this.smartComposeInlineHint_="";if(!querySubmitted){this.searchboxHandler_.clearFiles()}this.submitEnabled_=this.computeSubmitEnabled_();assert(!this.submitEnabled_);this.fileUploadsComplete=this.pendingUploads_.size===0}clearInput(){this.input_="";this.isVoiceInput_=false}getInputText(){return this.input_}selectFirstMatch(){if(this.result_?.matches.length){this.$.matches.selectFirst()}}}customElements.define(ComposeboxElement.is,ComposeboxElement);let instance$g=null;let BrowserProxy$1=class BrowserProxy{callbackRouter;constructor(){this.callbackRouter=new PageCallbackRouter$3;const pageHandlerRemote=PageHandler$1.getRemote();pageHandlerRemote.setPage(this.callbackRouter.$.bindNewPipeAndPassRemote())}static getInstance(){return instance$g||(instance$g=new BrowserProxy)}static setInstance(newInstance){instance$g=newInstance}};const COLORS_CSS_SELECTOR="link[href*='//theme/colors.css']";let documentInstance=null;class ColorChangeUpdater{listenerId_=null;root_;constructor(root){assert(documentInstance===null||root!==document);this.root_=root}start(){if(this.listenerId_!==null){return}this.listenerId_=BrowserProxy$1.getInstance().callbackRouter.onColorProviderChanged.addListener(this.onColorProviderChanged.bind(this))}async onColorProviderChanged(){await this.refreshColorsCss()}async refreshColorsCss(){const colorCssNode=this.root_.querySelector(COLORS_CSS_SELECTOR);if(!colorCssNode){return false}const href=colorCssNode.getAttribute("href");if(!href){return false}const hrefURL=new URL(href,location.href);const params=new URLSearchParams(hrefURL.search);params.set("version",(new Date).getTime().toString());const newHref=`${hrefURL.origin}${hrefURL.pathname}?${params.toString()}`;const newColorsCssLink=document.createElement("link");newColorsCssLink.setAttribute("href",newHref);newColorsCssLink.rel="stylesheet";newColorsCssLink.type="text/css";const newColorsLoaded=new Promise((resolve=>{newColorsCssLink.onload=resolve}));if(this.root_===document){document.getElementsByTagName("body")[0].appendChild(newColorsCssLink)}else{this.root_.appendChild(newColorsCssLink)}await newColorsLoaded;const oldColorCssNode=document.querySelector(COLORS_CSS_SELECTOR);if(oldColorCssNode){oldColorCssNode.remove()}return true}static forDocument(){return documentInstance||(documentInstance=new ColorChangeUpdater(document))}}function createAutocompleteMatch(){return{isHidden:false,a11yLabel:"",actions:[],allowedToBeDefaultMatch:false,isSearchType:false,isEnterpriseSearchAggregatorPeopleType:false,swapContentsAndDescription:false,supportsDeletion:false,suggestionGroupId:-1,contents:"",contentsClass:[{offset:0,style:0}],description:"",descriptionClass:[{offset:0,style:0}],destinationUrl:{url:""},inlineAutocompletion:"",fillIntoEdit:"",iconPath:"",iconUrl:{url:""},imageDominantColor:"",imageUrl:"",isNoncannedAimSuggestion:false,removeButtonA11yLabel:"",type:"",isRichSuggestion:false,isWeatherAnswerSuggestion:null,answer:null,tailSuggestCommonPrefix:null,hasInstantKeyword:false,keywordChipHint:"",keywordChipA11y:""}}class SearchboxBrowserProxy{static getInstance(){return instance$f||(instance$f=new SearchboxBrowserProxy)}static setInstance(newInstance){instance$f=newInstance}handler;callbackRouter;constructor(){this.handler=PageHandler.getRemote();this.callbackRouter=new PageCallbackRouter$2;this.handler.setPage(this.callbackRouter.$.bindNewPipeAndPassRemote())}}let instance$f=null;let instance$e=null;function getCss$b(){return instance$e||(instance$e=[...[],css`:host{--color-composebox-file-carousel-divider:var(--color-omnibox-composebox-divider);--color-composebox-file-chip-background:var(--color-omnibox-composebox-chip-background);--color-composebox-file-chip-favicon-background:var(--color-omnibox-composebox-favicon-background);--color-composebox-file-chip-text:var(--color-omnibox-text);--color-composebox-pdf-chip-icon-border:var(--color-sys-on-surface-subtle);--cr-composebox-font-size:14px;--color-searchbox-results-background-hovered:var(--color-omnibox-results-background-hovered);--color-searchbox-results-background-selected:var(--color-omnibox-results-background-selected);--color-searchbox-results-button-hover:var(--color-omnibox-results-button-ink-drop-row-hovered);--color-searchbox-results-focus-indicator:var(--color-omnibox-results-focus-indicator);--color-searchbox-results-foreground:var(--color-omnibox-text);--color-searchbox-results-foreground-selected:var(--color-omnibox-results-text-selected);--color-searchbox-results-icon-focused-outline:var(--color-omnibox-results-focus-indicator);--color-searchbox-results-icon-selected:var(--color-omnibox-results-icon-selected);--omnibox-font-size:14.3px}`])}let instance$d=null;function getCss$a(){return instance$d||(instance$d=[...[getCss$b()],css`:host{--composebox-context-menu-entrypoint-button-color:var(--color-sys-on-surface);--cr-composebox-custom-font-size:var(--omnibox-font-size);--cr-composebox-expanded-border-radius:16px;--cr-composebox-file-thumbnail-remove-button-fill-color:var(--color-omnibox-results-icon);--cr-composebox-input-bottom-spacing:8px;--cr-composebox-input-placeholder-font-size:var(--omnibox-font-size);--cr-composebox-match-height:40px;--cr-composebox-match-icon-container-padding-inline-start:20px;--cr-composebox-match-icon-size:16px;--cr-composebox-match-match-padding-bottom:0;--cr-composebox-match-remove-button-top:4px;--cr-composebox-match-text-container-font-size:var(--omnibox-font-size);--cr-composebox-max-height:800px;--cr-composebox-text-container-padding-block-start:0;--search-animated-glif-rotation-duration:2000ms;--cr-composebox-cancel-button-top:5px;--cr-composebox-voice-icon-fill-color:var(--color-sys-on-surface)}cr-composebox{--color-composebox-background:var(--color-omnibox-results-background);--color-composebox-cancel-button:unset;--color-composebox-cancel-button-light:var(--color-omnibox-text-dimmed);--color-composebox-context-entrypoint-hover-background:var(--color-omnibox-action-icon-hover);--color-composebox-context-entrypoint-text:var(--color-omnibox-context-entrypoint-text);--color-composebox-context-entrypoint-text-disabled:var(--color-omnibox-composebox-foreground-disabled);--color-composebox-file-carousel-remove-button:var(--color-omnibox-results-button-ink-drop-row-hovered);--color-composebox-file-carousel-remove-gradient-start:var(--color-omnibox-composebox-chip-background);--color-composebox-file-carousel-remove-gradient-end:color-mix(in srgb,var(--color-composebox-file-carousel-remove-gradient-start),transparent 100%);--color-composebox-file-carousel-url:var(--color-omnibox-text-dimmed);--color-composebox-file-image-overlay:var(--color-omnibox-text);--color-composebox-font:var(--color-omnibox-text);--color-composebox-font-light:var(--color-omnibox-text);--color-composebox-hover:unset;--color-composebox-input-icon:var(--color-omnibox-results-icon);--color-composebox-lens-button:unset;--color-composebox-pdf-chip-icon:var(--color-omnibox-text-dimmed);--color-composebox-recent-tab-chip-outline:unset;--color-composebox-scrim-background:unset;--color-composebox-submit-button-background:var(--color-omnibox-composebox-submit-button-background);--color-composebox-submit-button-icon:var(--color-omnibox-composebox-submit-button-icon);--color-composebox-submit-button-hover:var(--color-omnibox-action-icon-hover);--color-composebox-suggestion-activity:unset;--color-composebox-type-ahead:var(--color-omnibox-composebox-foreground-disabled);--color-composebox-type-ahead-chip:var(--color-omnibox-composebox-foreground-disabled);--color-composebox-upload-button:var(--omnibox-results-chip-background);--color-composebox-upload-button-disabled:var(--color-omnibox-composebox-foreground-disabled);--color-composebox-voice-search-font:var(--color-omnibox-text);--cr-composebox-background-color:var(--color-omnibox-results-background);--cr-composebox-input-placeholder-color:var(--color-omnibox-text-dimmed);--cr-composebox-outline-hcm:none;--cr-composebox-submit-button-margin-inline-start:auto;--cr-composebox-suggestion-activity-bottom:0;--cr-composebox-suggestion-activity-margin-top:0;--cr-composebox-submit-container-top:auto;--cr-composebox-voice-icon-top:auto;position:relative}cr-composebox[searchbox-layout-mode="Compact"]{--input-bottom-spacing:14px;--cr-composebox-context-margin-top:-12px}cr-composebox[searchbox-layout-mode="Compact"]::part(context-menu-entrypoint-icon){--cr-icon-button-icon-size:20px;--cr-icon-button-size:28px;left:12px;top:14px}cr-composebox::part(voice-icon){--cr-icon-button-fill-color:var(--cr-composebox-voice-icon-fill-color)}cr-composebox[searchbox-layout-mode="TallBottomContext"]::part(voice-icon){bottom:6px}cr-composebox[show-submit_][submit-enabled_][searchbox-layout-mode="TallBottomContext"]:not([show-dropdown_])::part(submit){bottom:6px}cr-composebox[searchbox-layout-mode="TallTopContext"]{--cr-composebox-submit-button-margin-inline-start:0}cr-composebox[show-submit_][submit-enabled_][searchbox-layout-mode='TallBottomContext']::part(voice-icon){inset-inline-end:calc(var(--cr-composebox-submit-container-size) + 6px);margin-inline-end:6px}cr-composebox[show-submit_][submit-enabled_][searchbox-layout-mode="TallTopContext"]::part(voice-icon){margin-inline-end:-2px}cr-composebox[searchbox-layout-mode="TallBottomContext"][show-dropdown_]::part(voice-icon){bottom:9px}:host-context([dir='rtl']) cr-composebox[searchbox-layout-mode="Compact"]::part(context-menu-entrypoint-icon){left:unset;right:12px}`])}function getHtml$9(){return html`<!--_html_template_start_-->
<div id="content">
  <cr-composebox id="composebox" searchbox-next-enabled
      searchbox-layout-mode="${this.searchboxLayoutMode_}"
      ?disable-caret-color-animation="${this.disableCaretColorAnimation_}"
      ?disable-composebox-animation="${this.disableComposeboxAnimation_}"
      ?disable-voice-search-animation="${true}"
      @context-menu-entrypoint-click="${this.onContextualEntryPointClicked_}"
      @close-composebox="${this.onCloseComposebox_}"
      @composebox-submit="${this.onComposeboxSubmit_}"
      entrypoint-name="Omnibox">
  </cr-composebox>
</div>
<!--_html_template_end_-->`}class PageHandlerFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"omnibox_popup_aim.mojom.PageHandlerFactory",scope)}}class PageHandlerFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}createPageHandler(page,handler){this.proxy.sendMessage(0,PageHandlerFactory_CreatePageHandler_ParamsSpec.$,null,[page,handler],false)}}class PageHandlerFactory{static get $interfaceName(){return"omnibox_popup_aim.mojom.PageHandlerFactory"}static getRemote(){let remote=new PageHandlerFactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"omnibox_popup_aim.mojom.PageHandler",scope)}}class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}requestClose(){this.proxy.sendMessage(0,PageHandler_RequestClose_ParamsSpec.$,null,[],false)}navigateCurrentTab(url){this.proxy.sendMessage(1,PageHandler_NavigateCurrentTab_ParamsSpec.$,null,[url],false)}}class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"omnibox_popup_aim.mojom.Page",scope)}}class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onPopupShown(context){this.proxy.sendMessage(0,Page_OnPopupShown_ParamsSpec.$,null,[context],false)}addContext(context){this.proxy.sendMessage(1,Page_AddContext_ParamsSpec.$,null,[context],false)}onPopupHidden(){return this.proxy.sendMessage(2,Page_OnPopupHidden_ParamsSpec.$,Page_OnPopupHidden_ResponseParamsSpec.$,[],false)}setPreserveContextOnClose(preserveContextOnClose){this.proxy.sendMessage(3,Page_SetPreserveContextOnClose_ParamsSpec.$,null,[preserveContextOnClose],false)}}class PageCallbackRouter{helper_internal_;$;router_;onPopupShown;addContext;onPopupHidden;setPreserveContextOnClose;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onPopupShown=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Page_OnPopupShown_ParamsSpec.$,null,this.onPopupShown.createReceiverHandler(false),false);this.addContext=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,Page_AddContext_ParamsSpec.$,null,this.addContext.createReceiverHandler(false),false);this.onPopupHidden=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,Page_OnPopupHidden_ParamsSpec.$,Page_OnPopupHidden_ResponseParamsSpec.$,this.onPopupHidden.createReceiverHandler(true),false);this.setPreserveContextOnClose=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,Page_SetPreserveContextOnClose_ParamsSpec.$,null,this.setPreserveContextOnClose.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}const PageHandlerFactory_CreatePageHandler_ParamsSpec={$:{}};const PageHandler_RequestClose_ParamsSpec={$:{}};const PageHandler_NavigateCurrentTab_ParamsSpec={$:{}};const Page_OnPopupShown_ParamsSpec={$:{}};const Page_AddContext_ParamsSpec={$:{}};const Page_OnPopupHidden_ParamsSpec={$:{}};const Page_OnPopupHidden_ResponseParamsSpec={$:{}};const Page_SetPreserveContextOnClose_ParamsSpec={$:{}};mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$,"PageHandlerFactory_CreatePageHandler_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageRemote),null,false,0,undefined,undefined),mojo.internal.StructField("handler",8,0,mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_RequestClose_ParamsSpec.$,"PageHandler_RequestClose_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_NavigateCurrentTab_ParamsSpec.$,"PageHandler_NavigateCurrentTab_Params",[mojo.internal.StructField("url",0,0,UrlSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnPopupShown_ParamsSpec.$,"Page_OnPopupShown_Params",[mojo.internal.StructField("context",0,0,SearchContextSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_AddContext_ParamsSpec.$,"Page_AddContext_Params",[mojo.internal.StructField("context",0,0,SearchContextSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnPopupHidden_ParamsSpec.$,"Page_OnPopupHidden_Params",[],[[0,8]]);mojo.internal.Struct(Page_OnPopupHidden_ResponseParamsSpec.$,"Page_OnPopupHidden_ResponseParams",[mojo.internal.StructField("input",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_SetPreserveContextOnClose_ParamsSpec.$,"Page_SetPreserveContextOnClose_Params",[mojo.internal.StructField("preserveContextOnClose",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);class BrowserProxy{callbackRouter=new PageCallbackRouter;handler=new PageHandlerRemote;constructor(){const factory=PageHandlerFactory.getRemote();factory.createPageHandler(this.callbackRouter.$.bindNewPipeAndPassRemote(),this.handler.$.bindNewPipeAndPassReceiver())}static getInstance(){return instance$c||(instance$c=new BrowserProxy)}static setInstance(obj){instance$c=obj}}let instance$c=null;class OmniboxAimAppElement extends CrLitElement{static get is(){return"omnibox-aim-app"}static get styles(){return getCss$a()}render(){return getHtml$9.bind(this)()}searchboxLayoutMode_=loadTimeData.getString("searchboxLayoutMode");disableCaretColorAnimation_=loadTimeData.getBoolean("caretColorAnimationDisabled");disableComposeboxAnimation_=loadTimeData.getBoolean("composeboxAnimationDisabled");isDebug_=new URLSearchParams(window.location.search).has("debug");eventTracker_=new EventTracker;searchboxPageHandler_;pageHandler_;callbackRouter_;listenerIds_=[];preserveContextOnClose_=false;constructor(){super();ColorChangeUpdater.forDocument().start();this.searchboxPageHandler_=SearchboxBrowserProxy.getInstance().handler;this.callbackRouter_=BrowserProxy.getInstance().callbackRouter;this.pageHandler_=BrowserProxy.getInstance().handler}connectedCallback(){super.connectedCallback();this.listenerIds_=[this.callbackRouter_.onPopupShown.addListener(this.onPopupShown_.bind(this)),this.callbackRouter_.addContext.addListener(this.addContext_.bind(this)),this.callbackRouter_.onPopupHidden.addListener(this.onPopupHidden_.bind(this)),this.callbackRouter_.setPreserveContextOnClose.addListener(this.setPreserveContextOnClose_.bind(this))];this.$.composebox.focusInput();if(!this.isDebug_){this.eventTracker_.add(document.documentElement,"contextmenu",(e=>{e.preventDefault()}))}this.setupLocalizedLinkListener()}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll();for(const listenerId of this.listenerIds_){this.callbackRouter_.removeListener(listenerId)}this.listenerIds_=[]}setupLocalizedLinkListener(){const link=this.$.composebox.shadowRoot.querySelector("localized-link")?.shadowRoot.querySelector("#container a");if(link){link.addEventListener("click",this.onLinkClick_.bind(this))}}onContextualEntryPointClicked_(e){e.preventDefault();const point={x:e.detail.x,y:e.detail.y};this.searchboxPageHandler_.showContextMenu(point)}onCloseComposebox_(){this.pageHandler_.requestClose()}setPreserveContextOnClose_(preserveContextOnClose){assert(document.visibilityState==="visible");this.preserveContextOnClose_=preserveContextOnClose}onPopupShown_(context){if(!this.preserveContextOnClose_){this.$.composebox.playGlowAnimation()}this.$.composebox.addSearchContext(context);this.$.composebox.focusInput();this.preserveContextOnClose_=false}addContext_(context){this.$.composebox.addSearchContext(context);this.$.composebox.focusInput()}onPopupHidden_(){if(this.$.composebox.isVoiceInput){this.$.composebox.clearInput()}const input=this.$.composebox.getInputText();if(!this.preserveContextOnClose_){this.$.composebox.clearAllInputs(false);this.$.composebox.clearAutocompleteMatches();this.$.composebox.resetModes()}return Promise.resolve({input:input})}onComposeboxSubmit_(){this.$.composebox.clearAllInputs(true)}onLinkClick_(e){e.preventDefault();const href=e.currentTarget.href;this.pageHandler_.navigateCurrentTab({url:href})}}customElements.define(OmniboxAimAppElement.is,OmniboxAimAppElement);let instance$b=null;function getCss$9(){return instance$b||(instance$b=[...[getCss$z()],css`:host{--cr-searchbox-icon-border-radius:8px;align-items:center;display:flex;flex-shrink:0;justify-content:center;width:var(--cr-searchbox-icon-container-size,32px)}:host(:not([is-lens-searchbox_])){--cr-searchbox-icon-border-radius:4px}#container{align-items:center;aspect-ratio:1/1;border-radius:var(--cr-searchbox-icon-border-radius);display:flex;justify-content:center;overflow:hidden;position:relative;width:100%}:host([has-image_]:not([in-searchbox]):not([is-weather-answer])) #container{background-color:var(--color-searchbox-results-icon-container-background,var(--container-bg-color))}:host([has-icon-container-background]:not([in-searchbox])) #container{background-color:var(--color-searchbox-answer-icon-background)}:host([is-weather-answer]:not([in-searchbox])) #container{background-color:var(--color-searchbox-results-background)}#image{display:none;height:100%;object-fit:contain;width:100%}:host([has-image_]:not([in-searchbox])) #image{display:initial}:host([is-answer]) #image{max-height:24px;max-width:24px}#icon{height:24px;width:24px}#faviconImageContainer{width:24px;height:24px;display:flex;justify-content:center;align-items:center}#faviconImage{height:16px;width:16px}#icon{-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-searchbox-results-search-icon-size,16px);background-color:var(--color-searchbox-search-icon-background)}:host([in-searchbox][is-lens-searchbox_]) #icon{background-color:var(--color-searchbox-google-g-background);height:var(--cr-searchbox-icon-size-in-searchbox);width:var(--cr-searchbox-icon-size-in-searchbox)}@media (forced-colors:active){:host([in-searchbox][is-lens-searchbox_]) #icon{background-color:ButtonText}}:host([in-searchbox][favicon-image_*='//resources/cr_components/omnibox/icons/google_g.svg']) #faviconImage{width:24px;height:24px}:host([in-searchbox]) #icon{-webkit-mask-size:var(--cr-searchbox-icon-size-in-searchbox)}:host([in-searchbox]) #faviconImage{width:var(--cr-searchbox-icon-size-in-searchbox);height:var(--cr-searchbox-icon-size-in-searchbox)}:host([has-icon-container-background]:not([in-searchbox])) #icon{background-color:var(--color-searchbox-answer-icon-foreground)}:host([has-icon-container-background][is-starter-pack]:not([in-searchbox])) #icon,:host([has-icon-container-background][is-featured-enterprise-search]:not([in-searchbox])) #icon{background-color:var(--color-searchbox-results-starter-pack-icon,var(--color-searchbox-answer-icon-foreground))}#iconImg{height:var(--cr-searchbox-results-search-icon-size,16px);width:var(--cr-searchbox-results-search-icon-size,16px)}:host([in-searchbox]) #iconImg{height:var(--cr-searchbox-icon-size-in-searchbox);width:var(--cr-searchbox-icon-size-in-searchbox)}:host([has-image_]:not([in-searchbox])) #icon,:host([has-image_]:not([in-searchbox])) #iconImg,:host([has-image_]:not([in-searchbox])) #faviconImageContainer{display:none}:host(:not([in-searchbox])[is-lens-searchbox_]) #container{background-color:var(--color-searchbox-results-icon-container-background);border-radius:4000px}`])}function getHtml$8(){return html`<!--_html_template_start_-->
<div id="container"
    style="--container-bg-color:${this.getContainerBgColor_()};">
  <img id="image" src="${this.imageSrc_}" ?hidden="${!this.showImage_}"
      @load="${this.onImageLoad_}" @error="${this.onImageError_}">

  <div ?hidden="${this.showIconImg_}">
    <div id="icon" style="-webkit-mask-image: ${this.maskImage};"
        ?hidden="${this.showFaviconImage_}">
    </div>
    <div id="faviconImageContainer"
        ?hidden="${!this.showFaviconImage_}">
      <img id="faviconImage" src="${this.faviconImage_}"
          srcset="${this.faviconImageSrcSet_}"
          @load="${this.onFaviconLoad_}"
          @error="${this.onFaviconError_}">
    </div>
  </div>

  <img id="iconImg" src="${this.iconSrc_}" ?hidden="${!this.showIconImg_}"
      @load="${this.onIconLoad_}">
</div>
<!--_html_template_end_-->`}const CALCULATOR="search-calculator-answer";const DOCUMENT_MATCH_TYPE="document";const FEATURED_ENTERPRISE_SEARCH="featured-enterprise-search";const HISTORY_CLUSTER_MATCH_TYPE="history-cluster";const PEDAL="pedal";const STARTER_PACK="starter-pack";class SearchboxIconElement extends CrLitElement{static get is(){return"cr-searchbox-icon"}static get styles(){return getCss$9()}render(){return getHtml$8.bind(this)()}static get properties(){return{defaultIcon:{type:String},hasIconContainerBackground:{type:Boolean,reflect:true},inSearchbox:{type:Boolean,reflect:true},isAnswer:{type:Boolean,reflect:true},isStarterPack:{type:Boolean,reflect:true},isFeaturedEnterpriseSearch:{type:Boolean,reflect:true},isWeatherAnswer:{type:Boolean,reflect:true},isEnterpriseSearchAggregatorPeopleType:{type:Boolean,reflect:true},maskImage:{type:String,reflect:true},match:{type:Object},faviconImage_:{type:String,reflect:true},faviconImageSrcSet_:{state:true,type:String},hasImage_:{type:Boolean,reflect:true},showFaviconImage_:{state:true,type:Boolean},faviconLoading_:{state:true,type:Boolean},faviconError_:{state:true,type:Boolean},iconSrc_:{state:true,type:String},iconLoading_:{state:true,type:Boolean},showIconImg_:{state:true,type:Boolean},showImage_:{state:true,type:Boolean},imageSrc_:{state:true,type:String},imageLoading_:{state:true,type:Boolean},imageError_:{state:true,type:Boolean},isTopChromeSearchbox_:{state:true,type:Boolean},isLensSearchbox_:{type:Boolean,reflect:true}}}#defaultIcon_accessor_storage="";get defaultIcon(){return this.#defaultIcon_accessor_storage}set defaultIcon(value){this.#defaultIcon_accessor_storage=value}#hasIconContainerBackground_accessor_storage=false;get hasIconContainerBackground(){return this.#hasIconContainerBackground_accessor_storage}set hasIconContainerBackground(value){this.#hasIconContainerBackground_accessor_storage=value}#inSearchbox_accessor_storage=false;get inSearchbox(){return this.#inSearchbox_accessor_storage}set inSearchbox(value){this.#inSearchbox_accessor_storage=value}#isAnswer_accessor_storage=false;get isAnswer(){return this.#isAnswer_accessor_storage}set isAnswer(value){this.#isAnswer_accessor_storage=value}#isStarterPack_accessor_storage=false;get isStarterPack(){return this.#isStarterPack_accessor_storage}set isStarterPack(value){this.#isStarterPack_accessor_storage=value}#isFeaturedEnterpriseSearch_accessor_storage=false;get isFeaturedEnterpriseSearch(){return this.#isFeaturedEnterpriseSearch_accessor_storage}set isFeaturedEnterpriseSearch(value){this.#isFeaturedEnterpriseSearch_accessor_storage=value}#isWeatherAnswer_accessor_storage=false;get isWeatherAnswer(){return this.#isWeatherAnswer_accessor_storage}set isWeatherAnswer(value){this.#isWeatherAnswer_accessor_storage=value}#isEnterpriseSearchAggregatorPeopleType_accessor_storage=false;get isEnterpriseSearchAggregatorPeopleType(){return this.#isEnterpriseSearchAggregatorPeopleType_accessor_storage}set isEnterpriseSearchAggregatorPeopleType(value){this.#isEnterpriseSearchAggregatorPeopleType_accessor_storage=value}#maskImage_accessor_storage="";get maskImage(){return this.#maskImage_accessor_storage}set maskImage(value){this.#maskImage_accessor_storage=value}#match_accessor_storage=null;get match(){return this.#match_accessor_storage}set match(value){this.#match_accessor_storage=value}#faviconImage__accessor_storage="";get faviconImage_(){return this.#faviconImage__accessor_storage}set faviconImage_(value){this.#faviconImage__accessor_storage=value}#faviconImageSrcSet__accessor_storage="";get faviconImageSrcSet_(){return this.#faviconImageSrcSet__accessor_storage}set faviconImageSrcSet_(value){this.#faviconImageSrcSet__accessor_storage=value}#hasImage__accessor_storage=false;get hasImage_(){return this.#hasImage__accessor_storage}set hasImage_(value){this.#hasImage__accessor_storage=value}#showFaviconImage__accessor_storage=false;get showFaviconImage_(){return this.#showFaviconImage__accessor_storage}set showFaviconImage_(value){this.#showFaviconImage__accessor_storage=value}#faviconLoading__accessor_storage=false;get faviconLoading_(){return this.#faviconLoading__accessor_storage}set faviconLoading_(value){this.#faviconLoading__accessor_storage=value}#faviconError__accessor_storage=false;get faviconError_(){return this.#faviconError__accessor_storage}set faviconError_(value){this.#faviconError__accessor_storage=value}#iconSrc__accessor_storage="";get iconSrc_(){return this.#iconSrc__accessor_storage}set iconSrc_(value){this.#iconSrc__accessor_storage=value}#iconLoading__accessor_storage=false;get iconLoading_(){return this.#iconLoading__accessor_storage}set iconLoading_(value){this.#iconLoading__accessor_storage=value}#showIconImg__accessor_storage=false;get showIconImg_(){return this.#showIconImg__accessor_storage}set showIconImg_(value){this.#showIconImg__accessor_storage=value}#showImage__accessor_storage=false;get showImage_(){return this.#showImage__accessor_storage}set showImage_(value){this.#showImage__accessor_storage=value}#imageSrc__accessor_storage="";get imageSrc_(){return this.#imageSrc__accessor_storage}set imageSrc_(value){this.#imageSrc__accessor_storage=value}#imageLoading__accessor_storage=false;get imageLoading_(){return this.#imageLoading__accessor_storage}set imageLoading_(value){this.#imageLoading__accessor_storage=value}#imageError__accessor_storage=false;get imageError_(){return this.#imageError__accessor_storage}set imageError_(value){this.#imageError__accessor_storage=value}#isTopChromeSearchbox__accessor_storage=loadTimeData.getBoolean("isTopChromeSearchbox");get isTopChromeSearchbox_(){return this.#isTopChromeSearchbox__accessor_storage}set isTopChromeSearchbox_(value){this.#isTopChromeSearchbox__accessor_storage=value}#isLensSearchbox__accessor_storage=loadTimeData.getBoolean("isLensSearchbox");get isLensSearchbox_(){return this.#isLensSearchbox__accessor_storage}set isLensSearchbox_(value){this.#isLensSearchbox__accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("match")){this.iconSrc_=this.computeIconSrc_();this.imageSrc_=this.computeImageSrc_();this.isAnswer=this.computeIsAnswer_();this.isEnterpriseSearchAggregatorPeopleType=this.computeIsEnterpriseSearchAggregatorPeopleType_();this.isStarterPack=this.computeIsStarterPack_();this.isFeaturedEnterpriseSearch=this.computeIsFeaturedEnterpriseSearch();this.isWeatherAnswer=this.computeIsWeatherAnswer_();this.hasImage_=this.computeHasImage_();this.maskImage=this.computeMaskImage_()}if(changedProperties.has("match")||changedProperties.has("isWeatherAnswer")){this.hasIconContainerBackground=this.computeHasIconContainerBackground_()}const changedPrivateProperties=changedProperties;if(changedProperties.has("match")||changedProperties.has("defaultIcon")||changedPrivateProperties.has("isTopChromeSearchbox_")){this.faviconImage_=this.computeFaviconImage_()}if(changedProperties.has("match")||changedPrivateProperties.has("faviconImage_")||changedPrivateProperties.has("isTopChromeSearchbox_")){this.faviconImageSrcSet_=this.computeFaviconImageSrcSet_()}if(changedPrivateProperties.has("faviconImage_")){this.faviconLoading_=!!this.faviconImage_;this.faviconError_=false}if(changedProperties.has("match")||changedPrivateProperties.has("isLensSearchbox_")||changedPrivateProperties.has("faviconImage_")||changedPrivateProperties.has("faviconLoading_")||changedPrivateProperties.has("faviconError_")){this.showFaviconImage_=this.computeShowFaviconImage_()}if(changedPrivateProperties.has("iconSrc_")){this.iconLoading_=!!this.iconSrc_}if(changedPrivateProperties.has("imageSrc_")){this.imageLoading_=!!this.imageSrc_;this.imageError_=false}if(changedPrivateProperties.has("imageSrc_")||changedPrivateProperties.has("imageError_")){this.showImage_=this.computeShowImage_()}if(changedProperties.has("match")||changedPrivateProperties.has("isLensSearchbox_")||changedPrivateProperties.has("iconLoading_")){this.showIconImg_=this.computeShowIconImg_()}}computeFaviconUrl_(scaleFactor){if(!this.match?.destinationUrl.url){return""}return getFaviconUrl(this.match.destinationUrl.url,{forceLightMode:!this.isTopChromeSearchbox_,forceEmptyDefaultFavicon:true,scaleFactor:`${scaleFactor}x`})}computeFaviconImageSrcSet_(){if(!this.faviconImage_.startsWith("chrome://favicon2/")){return""}return[`${this.computeFaviconUrl_(1)} 1x`,`${this.computeFaviconUrl_(2)} 2x`].join(", ")}computeFaviconImage_(){if(this.match&&!this.match.isSearchType){if(this.match.type===DOCUMENT_MATCH_TYPE||this.match.type===PEDAL||this.match.isEnterpriseSearchAggregatorPeopleType){return this.match.iconPath}if(this.match.type!==HISTORY_CLUSTER_MATCH_TYPE&&this.match.type!==FEATURED_ENTERPRISE_SEARCH){return this.computeFaviconUrl_(1)}}if(this.defaultIcon==="//resources/cr_components/searchbox/icons/google_g.svg"||this.defaultIcon==="//resources/cr_components/searchbox/icons/google_g_gradient.svg"){return this.defaultIcon}return""}computeIsAnswer_(){return!!this.match&&!!this.match.answer}computeIsWeatherAnswer_(){return this.match?.isWeatherAnswerSuggestion||false}computeHasImage_(){return!!this.match&&!!this.match.imageUrl}computeIsEnterpriseSearchAggregatorPeopleType_(){return this.match?.isEnterpriseSearchAggregatorPeopleType||false}computeShowIconImg_(){return!this.isLensSearchbox_&&!!this.match&&!!this.match.iconUrl.url&&!this.iconLoading_}computeMaskImage_(){if(this.isLensSearchbox_&&this.inSearchbox){return`url(${this.defaultIcon})`}if(this.match&&(!this.match.isRichSuggestion||this.match.type===STARTER_PACK||this.match.type===FEATURED_ENTERPRISE_SEARCH||this.match.isEnterpriseSearchAggregatorPeopleType||!this.inSearchbox)){return`url(${this.match.iconPath})`}else{return`url(${this.defaultIcon})`}}computeShowFaviconImage_(){if(!this.faviconImage_){return false}if(this.faviconLoading_||this.faviconError_){return false}if(!this.isLensSearchbox_&&this.match&&!this.match.isSearchType&&this.match.type!==STARTER_PACK&&this.match.type!==PEDAL){return true}const themedIcons=["calendar","drive_docs","drive_folder","drive_form","drive_image","drive_logo","drive_pdf","drive_sheets","drive_slides","drive_video","google_agentspace_logo","google_agentspace_logo_25","google_g","google_g_gradient","note","sites"];for(const icon of themedIcons){if(this.faviconImage_==="//resources/cr_components/searchbox/icons/"+icon+".svg"){return true}}return false}computeSrc_(url){if(!url){return""}if(url.startsWith("data:image/")){return url}return`//image?staticEncode=true&encodeType=webp&url=${url}`}computeIconSrc_(){return this.computeSrc_(this.match?.iconUrl?.url)}computeShowImage_(){return!!this.imageSrc_&&!this.imageError_}computeImageSrc_(){return this.computeSrc_(this.match?.imageUrl)}getContainerBgColor_(){return(this.imageLoading_||this.imageError_)&&this.match?.imageDominantColor?this.match.imageDominantColor?`${this.match.imageDominantColor}40`:"var(--cr-searchbox-match-icon-container-background-fallback)":"transparent"}onFaviconLoad_(){this.faviconLoading_=false;this.faviconError_=false}onFaviconError_(){this.faviconLoading_=false;this.faviconError_=true}onIconLoad_(){this.iconLoading_=false}onImageLoad_(){this.imageLoading_=false;this.imageError_=false}onImageError_(){this.imageLoading_=false;this.imageError_=true}computeHasIconContainerBackground_(){if(this.match){return this.match.type===PEDAL||this.match.type===HISTORY_CLUSTER_MATCH_TYPE||this.match.type===CALCULATOR||this.match.type===STARTER_PACK||this.match.type===FEATURED_ENTERPRISE_SEARCH||!!this.match.answer&&!this.isWeatherAnswer}return false}computeIsStarterPack_(){return this.match?.type===STARTER_PACK}computeIsFeaturedEnterpriseSearch(){return this.match?.type===FEATURED_ENTERPRISE_SEARCH}}customElements.define(SearchboxIconElement.is,SearchboxIconElement);let instance$a=null;function getCss$8(){return instance$a||(instance$a=[...[getCss$g()],css`:host{border:solid 1px var(--color-searchbox-results-action-chip);border-radius:8px;display:flex;height:var(--cr-searchbox-results-action-chip-height,28px);min-width:0;outline:none;padding-inline-end:8px;padding-inline-start:8px;position:relative;transition:background-color 0.25s}:host(:hover){background-color:var(--color-searchbox-results-button-hover)}:host(:focus),:host(.selected){margin:2px;box-shadow:none}:host(.selected:hover){background-color:var(--color-searchbox-results-button-selected-hover)}:host(:active) #overlay{background-color:var(--color-omnibox-results-button-ink-drop-selected-row-hovered)}:host(.selected:active) #overlay{background-color:var(--color-omnibox-results-button-ink-drop-selected-row-selected)}#overlay{--overlay-inset:calc(var(--border-width) * -1);border-radius:inherit;display:inherit;position:absolute;top:var(--overlay-inset);left:var(--overlay-inset);right:var(--overlay-inset);bottom:var(--overlay-inset)}.contents{align-items:center;display:flex;min-width:0}#action-icon{flex-shrink:0;-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:15px;background-color:var(--color-searchbox-results-action-chip-icon);background-position:center center;background-repeat:no-repeat;height:16px;width:16px}:host-context(:is(:focus,[selected])) #action-icon{background-color:var(--color-searchbox-results-action-chip-icon-selected,var(--color-searchbox-results-action-chip-icon))}#text{overflow:hidden;padding-inline-start:8px;text-overflow:ellipsis;white-space:nowrap}`])}function getHtml$7(){return html`<!--_html_template_start_-->
<div id="overlay"></div>
<div class="contents" title="${this.suggestionContents}">
  <div id="action-icon" style="${this.iconStyle_}"></div>
  <div id="text" .innerHTML="${this.hintHtml_}"></div>
</div>
<!--_html_template_end_-->`}class SearchboxActionElement extends CrLitElement{static get is(){return"cr-searchbox-action"}static get styles(){return getCss$8()}render(){return getHtml$7.bind(this)()}static get properties(){return{hint:{type:String},hintHtml_:{state:true,type:String},suggestionContents:{type:String},iconPath:{type:String},iconStyle_:{state:true,type:String},ariaLabel:{type:String},actionIndex:{type:Number}}}#hint_accessor_storage="";get hint(){return this.#hint_accessor_storage}set hint(value){this.#hint_accessor_storage=value}#hintHtml__accessor_storage=window.trustedTypes.emptyHTML;get hintHtml_(){return this.#hintHtml__accessor_storage}set hintHtml_(value){this.#hintHtml__accessor_storage=value}#suggestionContents_accessor_storage="";get suggestionContents(){return this.#suggestionContents_accessor_storage}set suggestionContents(value){this.#suggestionContents_accessor_storage=value}#iconPath_accessor_storage="";get iconPath(){return this.#iconPath_accessor_storage}set iconPath(value){this.#iconPath_accessor_storage=value}#iconStyle__accessor_storage="";get iconStyle_(){return this.#iconStyle__accessor_storage}set iconStyle_(value){this.#iconStyle__accessor_storage=value}#ariaLabel_accessor_storage="";get ariaLabel(){return this.#ariaLabel_accessor_storage}set ariaLabel(value){this.#ariaLabel_accessor_storage=value}#actionIndex_accessor_storage=-1;get actionIndex(){return this.#actionIndex_accessor_storage}set actionIndex(value){this.#actionIndex_accessor_storage=value}firstUpdated(){this.addEventListener("click",(event=>this.onActionClick_(event)));this.addEventListener("keydown",(event=>this.onActionKeyDown_(event)));this.addEventListener("mousedown",(event=>this.onActionMouseDown_(event)))}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("hint")){this.hintHtml_=this.computeHintHtml_()}if(changedProperties.has("iconPath")){this.iconStyle_=this.computeActionIconStyle_()}}onActionClick_(e){this.fire("execute-action",{event:e,actionIndex:this.actionIndex});e.preventDefault();e.stopPropagation()}onActionKeyDown_(e){if(e.key&&(e.key==="Enter"||e.key===" ")){this.onActionClick_(e)}}onActionMouseDown_(e){e.preventDefault()}computeHintHtml_(){if(this.hint){return sanitizeInnerHtml(this.hint)}return window.trustedTypes.emptyHTML}computeActionIconStyle_(){if(this.iconPath.startsWith("data:image/")){return`background-image: url(${this.iconPath})`}return`-webkit-mask-image: url(${this.iconPath})`}}customElements.define(SearchboxActionElement.is,SearchboxActionElement);let instance$9=null;function getCss$7(){return instance$9||(instance$9=[...[],css`.action-icon{--cr-icon-button-active-background-color:var(--color-new-tab-page-active-background);--cr-icon-button-fill-color:var(--color-searchbox-results-icon);--cr-icon-button-focus-outline-color:var(--color-searchbox-results-icon-focused-outline);--cr-icon-button-hover-background-color:var(--color-searchbox-results-button-hover);--cr-icon-button-icon-size:16px;--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0;--cr-icon-button-size:24px}`])}let instance$8=null;function getCss$6(){return instance$8||(instance$8=[...[getCss$z(),getCss$r(),getCss$7()],css`:host{display:block;outline:none}#actions-focus-border{overflow:hidden}#actions-focus-border:focus-within,#actions-focus-border:focus-within:has(#action:active),#actions-focus-border:has(#action.selected),#actions-focus-border:has(#keyword.selected){outline:2px solid var(--color-searchbox-results-action-chip-focus-outline);border-radius:10px;margin-inline-start:-2px}#actions-focus-border:has(#action:active){outline:none}.container{align-items:center;cursor:default;display:flex;overflow:hidden;padding-bottom:var(--cr-searchbox-match-padding,6px);padding-inline-end:16px;padding-inline-start:var(--cr-searchbox-match-padding-inline-start,12px);padding-top:var(--cr-searchbox-match-padding,6px);position:relative}.container+.container{flex-direction:row;margin-inline-start:40px;padding-top:0;padding-bottom:12px}:host([has-action]) .container{height:38px;padding-top:3px;padding-bottom:3px}:host([is-top-chrome-searchbox_]:is([has-action],[has-keyword])) .container{height:40px;padding-top:0;padding-bottom:0}:host(:not([is-lens-searchbox_])) .container:not(.actions){margin-inline-end:16px;border-start-end-radius:24px;border-end-end-radius:24px}:host-context([has-secondary-side]):host-context([can-show-secondary-side]) .container:not(.actions){margin-inline-end:0px}.container:not(.actions):hover{background-color:var(--color-searchbox-results-background-hovered)}:host(:is(:focus-visible,[selected])) .container:not(.actions){background-color:var(--color-searchbox-results-background-selected,var(--color-searchbox-results-background-hovered))}:host([enable-csb-motion-tweaks_][is-lens-searchbox_]) .container{height:48px;padding-bottom:0;padding-top:0}.actions.container{align-self:center;flex-grow:1;flex-shrink:0;padding-bottom:0;padding-inline-end:0px;padding-inline-start:0px;padding-top:0;display:none}:host-context(.vertical) .actions.container{display:flex}:host([has-action]) .actions.container{padding-inline-end:8px;padding-inline-start:8px}#contents,#description{overflow:hidden;text-overflow:ellipsis}#ellipsis{inset-inline-end:0;position:absolute}:host([show-thumbnail]) #ellipsis{position:relative}#focus-indicator{--searchbox-match-focus-indicator-width_:7px;background-color:var(--color-searchbox-results-focus-indicator);border-radius:3px;display:none;height:100%;inset-inline-start:round(up,calc(-1 * var(--searchbox-match-focus-indicator-width_) / 2),1px);position:absolute;width:var(--searchbox-match-focus-indicator-width_)}:host-context(.vertical):host(:is(:focus-visible,[selected]:not(:focus-within))) #focus-indicator:not(.selected-within){display:block}:host-context(cr-searchbox-match:-webkit-any(:focus-within,[selected])) #icon{--color-searchbox-search-icon-background:var(--color-searchbox-results-dim-selected)}#prefix{opacity:0}#separator{white-space:pre}#tail-suggest-prefix{position:relative}#text-container{align-items:center;display:flex;flex-grow:0;overflow:hidden;padding-inline-end:8px;padding-inline-start:var(--cr-searchbox-match-text-padding-inline-start,8px);white-space:nowrap}#suggestion{display:inherit;overflow:inherit;flex-direction:inherit;max-width:100%}:host([is-top-chrome-searchbox_]) #text-container #suggestion{display:inline-block;min-width:0;flex:1 1 auto;white-space:nowrap;text-overflow:ellipsis}:host([is-lens-searchbox_]) #text-container{display:-webkit-box;line-clamp:2;-webkit-line-clamp:2;-webkit-box-orient:vertical;white-space:normal}:host([has-action]) #text-container{padding-inline-end:4px}:host([is-rich-suggestion]) #text-container{align-items:flex-start;flex-direction:column}:host([is-rich-suggestion]) #separator{display:none}:host([is-rich-suggestion]) #contents,:host([is-rich-suggestion]) #description{width:100%}:host([is-rich-suggestion]) #description{font-size:.875em}.match{font-weight:var(--cr-searchbox-match-font-weight,600)}:host(:not([is-top-chrome-searchbox_])) #contents span:not(.match),#ellipsis{color:var(--color-searchbox-results-typed-prefix,--color-searchbox-results-foreground)}:host-context([has-empty-input]) #contents span,:host-context([has-empty-input]) #ellipsis{color:var(--color-searchbox-results-foreground)}#description,.dim{color:var(--color-searchbox-results-foreground-dimmed)}:host-context(cr-searchbox-match:-webkit-any(:focus-within,[selected])):host([is-entity-suggestion]) #description,:host-context(cr-searchbox-match:-webkit-any(:focus-within,[selected])) .dim{color:var(--color-searchbox-results-dim-selected)}#description:has(.url),.url{color:var(--color-searchbox-results-url)}:host-context(cr-searchbox-match:-webkit-any(:focus-within,[selected])) .url{color:var(--color-searchbox-results-url-selected)}#remove{display:none;margin-inline-end:1px}:host-context(cr-searchbox-match:-webkit-any(:focus-within,[selected])) #remove{--cr-icon-button-fill-color:var(--color-searchbox-results-icon-selected)}:host-context(cr-searchbox-match:-webkit-any(:focus-within,[selected])) #remove:hover{--cr-icon-button-hover-background-color:var(--color-searchbox-results-button-selected-hover)}:host-context(.vertical) .container:hover #remove,:host-context(cr-searchbox-match:-webkit-any(:focus-within,[selected])):host-context(.vertical) #remove{display:inline-flex}.selected:not(#action):not(#keyword){box-shadow:inset 0 0 0 2px var(--color-searchbox-results-icon-focused-outline)}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]),:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) .container{border-radius:16px}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) .container{box-sizing:border-box;flex-direction:column;margin-inline-end:0;padding:6px;padding-block-end:16px;width:102px;height:auto}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) .focus-indicator{display:none}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) #icon{--cr-searchbox-icon-border-radius:12px;--color-searchbox-results-icon-container-background:transparent;height:90px;margin-block-end:8px;width:90px}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) #text-container{padding:0;white-space:normal;width:100%}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) #contents,:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) #description{-webkit-box-orient:vertical;-webkit-line-clamp:2;display:-webkit-box;font-weight:400;overflow:hidden}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) #contents{font-size:13px;line-height:20px;margin-block-end:4px}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) #description{font-size:12px;line-height:16px}`])}function getHtml$6(){return html`<!--_html_template_start_-->
<div class="container" aria-hidden="true">
  <div id="focus-indicator" class="${this.getFocusIndicatorCssClass_()}"></div>
  <cr-searchbox-icon id="icon" .match="${this.match}"></cr-searchbox-icon>
  <div id="text-container">
    <span id="tail-suggest-prefix" ?hidden="${!this.tailSuggestPrefix_}">
      <span id="prefix">${this.tailSuggestPrefix_}</span>
      <!-- This is equivalent to AutocompleteMatch::kEllipsis which is
           prepended to the match content in other surfaces-->
      <span id="ellipsis">...&nbsp;</span>
    </span>
    <!-- When a thumbnail is in the searchbox all results should have an
         ellipsis prepended to the suggestion. -->
    <span id="ellipsis" ?hidden="${!this.showEllipsis}">...&nbsp;</span>
    <span id="suggestion">
      <span id="contents" .innerHTML="${this.contentsHtml_}"></span>
      <span id="separator" class="dim">${this.separatorText_}</span>
      <span id="description" .innerHTML="${this.descriptionHtml_}"></span>
    </span>
  </div>
  <div aria-hidden="true">
    ${this.match.keywordChipHint?html`
      <div id="actions-focus-border">
        <cr-searchbox-action id="keyword"
            class="${this.getKeywordCssClass_()}"
            hint="${this.match.keywordChipHint}"
            icon-path="//resources/images/icon_search.svg"
            aria-label="${this.match.keywordChipA11y}"
            @execute-action="${this.onActivateKeyword_}"
            tabindex="1">
        </cr-searchbox-action>
      </div>
    `:""}
  </div>
  <div id="actions-container" class="actions container" aria-hidden="true">
    ${this.match.actions.map(((item,index)=>html`
      <div id="actions-focus-border">
        <cr-searchbox-action id="action"
            class="${this.getActionCssClass_(index)}"
            hint="${item.hint}"
            suggestion-contents="${item.suggestionContents}"
            icon-path="${item.iconPath}"
            aria-label="${item.a11yLabel}"
            action-index="${index}"
            @execute-action="${this.onExecuteAction_}" tabindex="2">
        </cr-searchbox-action>
      </div>
    `))}
  </div>
  <cr-icon-button id="remove"
      class="action-icon icon-clear ${this.getRemoveCssClass_()}"
      tabindex="3"
      aria-label="${this.removeButtonAriaLabel_}"
      title="${this.removeButtonTitle_}"
      ?hidden="${!this.match.supportsDeletion}"
      @click="${this.onRemoveButtonClick_}"
      @mousedown="${this.onRemoveButtonMouseDown_}">
  </cr-icon-button>
</div>
<!--_html_template_end_-->`}function mojoTimeTicks(timeTicks){return{internalValue:BigInt(Math.floor(timeTicks*1e3))}}function sideTypeToClass(sideType){switch(sideType){case SideType.kDefaultPrimary:return"primary-side";case SideType.kSecondary:return"secondary-side";default:assertNotReached("Unexpected side type")}}function renderTypeToClass(renderType){switch(renderType){case RenderType.kDefaultVertical:return"vertical";case RenderType.kHorizontal:return"horizontal";case RenderType.kGrid:return"grid";default:assertNotReached("Unexpected render type")}}var AcMatchClassificationStyle;(function(AcMatchClassificationStyle){AcMatchClassificationStyle[AcMatchClassificationStyle["NONE"]=0]="NONE";AcMatchClassificationStyle[AcMatchClassificationStyle["URL"]=1]="URL";AcMatchClassificationStyle[AcMatchClassificationStyle["MATCH"]=2]="MATCH";AcMatchClassificationStyle[AcMatchClassificationStyle["DIM"]=4]="DIM"})(AcMatchClassificationStyle||(AcMatchClassificationStyle={}));const ENTITY_MATCH_TYPE="search-suggest-entity";const defaultSelection={line:-1,state:SelectionLineState.kNormal,actionIndex:0};class SearchboxMatchElement extends CrLitElement{static get is(){return"cr-searchbox-match"}static get styles(){return getCss$6()}render(){return getHtml$6.bind(this)()}static get properties(){return{ariaLabel:{type:String},hasAction:{type:Boolean,reflect:true},hasImage:{type:Boolean,reflect:true},hasKeyword:{type:Boolean,reflect:true},isEntitySuggestion:{type:Boolean,reflect:true},isRichSuggestion:{type:Boolean,reflect:true},match:{type:Object},selection:{type:Object},matchIndex:{type:Number},showThumbnail:{type:Boolean,reflect:true},showEllipsis:{type:Boolean},sideType:{type:Number},isTopChromeSearchbox_:{type:Boolean,reflect:true},isLensSearchbox_:{type:Boolean,reflect:true},forceHideEllipsis_:{type:Boolean},contentsHtml_:{type:String},descriptionHtml_:{type:String},enableCsbMotionTweaks_:{type:Boolean,reflect:true},removeButtonAriaLabel_:{type:String},removeButtonTitle_:{type:String},separatorText_:{type:String},tailSuggestPrefix_:{type:String}}}#ariaLabel_accessor_storage="";get ariaLabel(){return this.#ariaLabel_accessor_storage}set ariaLabel(value){this.#ariaLabel_accessor_storage=value}#hasAction_accessor_storage=false;get hasAction(){return this.#hasAction_accessor_storage}set hasAction(value){this.#hasAction_accessor_storage=value}#hasImage_accessor_storage=false;get hasImage(){return this.#hasImage_accessor_storage}set hasImage(value){this.#hasImage_accessor_storage=value}#hasKeyword_accessor_storage=false;get hasKeyword(){return this.#hasKeyword_accessor_storage}set hasKeyword(value){this.#hasKeyword_accessor_storage=value}#isEntitySuggestion_accessor_storage=false;get isEntitySuggestion(){return this.#isEntitySuggestion_accessor_storage}set isEntitySuggestion(value){this.#isEntitySuggestion_accessor_storage=value}#isRichSuggestion_accessor_storage=false;get isRichSuggestion(){return this.#isRichSuggestion_accessor_storage}set isRichSuggestion(value){this.#isRichSuggestion_accessor_storage=value}#match_accessor_storage=createAutocompleteMatch();get match(){return this.#match_accessor_storage}set match(value){this.#match_accessor_storage=value}#selection_accessor_storage=defaultSelection;get selection(){return this.#selection_accessor_storage}set selection(value){this.#selection_accessor_storage=value}#matchIndex_accessor_storage=-1;get matchIndex(){return this.#matchIndex_accessor_storage}set matchIndex(value){this.#matchIndex_accessor_storage=value}#sideType_accessor_storage=SideType.kDefaultPrimary;get sideType(){return this.#sideType_accessor_storage}set sideType(value){this.#sideType_accessor_storage=value}#showThumbnail_accessor_storage=false;get showThumbnail(){return this.#showThumbnail_accessor_storage}set showThumbnail(value){this.#showThumbnail_accessor_storage=value}#showEllipsis_accessor_storage=false;get showEllipsis(){return this.#showEllipsis_accessor_storage}set showEllipsis(value){this.#showEllipsis_accessor_storage=value}#isTopChromeSearchbox__accessor_storage=loadTimeData.getBoolean("isTopChromeSearchbox");get isTopChromeSearchbox_(){return this.#isTopChromeSearchbox__accessor_storage}set isTopChromeSearchbox_(value){this.#isTopChromeSearchbox__accessor_storage=value}#isLensSearchbox__accessor_storage=loadTimeData.getBoolean("isLensSearchbox");get isLensSearchbox_(){return this.#isLensSearchbox__accessor_storage}set isLensSearchbox_(value){this.#isLensSearchbox__accessor_storage=value}#forceHideEllipsis__accessor_storage=loadTimeData.getBoolean("forceHideEllipsis");get forceHideEllipsis_(){return this.#forceHideEllipsis__accessor_storage}set forceHideEllipsis_(value){this.#forceHideEllipsis__accessor_storage=value}#contentsHtml__accessor_storage=window.trustedTypes.emptyHTML;get contentsHtml_(){return this.#contentsHtml__accessor_storage}set contentsHtml_(value){this.#contentsHtml__accessor_storage=value}#descriptionHtml__accessor_storage=window.trustedTypes.emptyHTML;get descriptionHtml_(){return this.#descriptionHtml__accessor_storage}set descriptionHtml_(value){this.#descriptionHtml__accessor_storage=value}#enableCsbMotionTweaks__accessor_storage=loadTimeData.getBoolean("enableCsbMotionTweaks");get enableCsbMotionTweaks_(){return this.#enableCsbMotionTweaks__accessor_storage}set enableCsbMotionTweaks_(value){this.#enableCsbMotionTweaks__accessor_storage=value}#removeButtonAriaLabel__accessor_storage="";get removeButtonAriaLabel_(){return this.#removeButtonAriaLabel__accessor_storage}set removeButtonAriaLabel_(value){this.#removeButtonAriaLabel__accessor_storage=value}#removeButtonTitle__accessor_storage=loadTimeData.getString("removeSuggestion");get removeButtonTitle_(){return this.#removeButtonTitle__accessor_storage}set removeButtonTitle_(value){this.#removeButtonTitle__accessor_storage=value}#separatorText__accessor_storage="";get separatorText_(){return this.#separatorText__accessor_storage}set separatorText_(value){this.#separatorText__accessor_storage=value}#tailSuggestPrefix__accessor_storage="";get tailSuggestPrefix_(){return this.#tailSuggestPrefix__accessor_storage}set tailSuggestPrefix_(value){this.#tailSuggestPrefix__accessor_storage=value}pageHandler_;constructor(){super();this.pageHandler_=SearchboxBrowserProxy.getInstance().handler}firstUpdated(){this.addEventListener("click",(event=>this.onMatchClick_(event)));this.addEventListener("focusin",(()=>this.onMatchFocusin_()));this.addEventListener("mousedown",(()=>this.onMatchMouseDown_()))}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("match")){this.ariaLabel=this.computeAriaLabel_();this.contentsHtml_=this.computeContentsHtml_();this.descriptionHtml_=this.computeDescriptionHtml_();this.hasAction=this.computeHasAction_();this.hasKeyword=this.computeHasKeyword_();this.hasImage=this.computeHasImage_();this.isEntitySuggestion=this.computeIsEntitySuggestion_();this.isRichSuggestion=this.computeIsRichSuggestion_();this.removeButtonAriaLabel_=this.computeRemoveButtonAriaLabel_();this.separatorText_=this.computeSeparatorText_();this.tailSuggestPrefix_=this.computeTailSuggestPrefix_();this.selection=defaultSelection}const changedPrivateProperties=changedProperties;if(changedProperties.has("showThumbnail")||changedPrivateProperties.has("isLensSearchbox_")||changedPrivateProperties.has("forceHideEllipsis_")){this.showEllipsis=this.computeShowEllipsis_()}}onActivateKeyword_(e){const event=e.detail.event;this.pageHandler_.activateKeyword(this.matchIndex,this.match.destinationUrl,mojoTimeTicks(Date.now()),event.pointerType==="mouse")}onExecuteAction_(e){const event=e.detail.event;this.pageHandler_.executeAction(this.matchIndex,e.detail.actionIndex,this.match.destinationUrl,mojoTimeTicks(Date.now()),event.button||0,event.altKey,event.ctrlKey,event.metaKey,event.shiftKey)}onMatchClick_(e){if(e.button>1){return}e.preventDefault();e.stopPropagation();this.pageHandler_.openAutocompleteMatch(this.matchIndex,this.match.destinationUrl,true,e.button||0,e.altKey,e.ctrlKey,e.metaKey,e.shiftKey);const backgroundTab=(e.metaKey||e.ctrlKey)&&e.shiftKey;if(!backgroundTab){this.fire("match-click")}}onMatchFocusin_(){this.fire("match-focusin",this.matchIndex)}onMatchMouseDown_(){this.pageHandler_.onNavigationLikely(this.matchIndex,this.match.destinationUrl,NavigationPredictor.kMouseDown)}onRemoveButtonClick_(e){if(e.button!==0){return}e.preventDefault();e.stopPropagation();this.pageHandler_.deleteAutocompleteMatch(this.matchIndex,this.match.destinationUrl)}onRemoveButtonMouseDown_(e){e.preventDefault()}computeAriaLabel_(){if(!this.match){return""}return this.match.a11yLabel}sanitizeInnerHtml_(innerHtml){try{return sanitizeInnerHtml(innerHtml,{attrs:["class"]})}catch(e){return window.trustedTypes.emptyHTML}}computeContentsHtml_(){if(!this.match){return window.trustedTypes.emptyHTML}return this.sanitizeInnerHtml_(this.renderTextWithClassifications_(this.getMatchContents_(),this.getMatchContentsClassifications_()).innerHTML)}computeDescriptionHtml_(){if(!this.match){return window.trustedTypes.emptyHTML}return this.sanitizeInnerHtml_(this.renderTextWithClassifications_(this.getMatchDescription_(),this.match.answer?[]:this.getMatchDescriptionClassifications_()).innerHTML)}computeHasAction_(){return this.match?.actions?.length>0}computeHasKeyword_(){return this.match&&!!this.match.keywordChipHint}computeHasImage_(){return this.match&&!!this.match.imageUrl}computeIsEntitySuggestion_(){return this.match&&this.match.type===ENTITY_MATCH_TYPE}computeIsRichSuggestion_(){return!this.isTopChromeSearchbox_&&this.match&&this.match.isRichSuggestion}computeRemoveButtonAriaLabel_(){if(!this.match){return""}return this.match.removeButtonA11yLabel}computeSeparatorText_(){return this.getMatchDescription_()?loadTimeData.getString("searchboxSeparator"):""}computeTailSuggestPrefix_(){if(!this.match||!this.match.tailSuggestCommonPrefix){return""}const prefix=this.match.tailSuggestCommonPrefix;if(prefix.slice(-1)===" "){return prefix.slice(0,-1)+" "}return prefix}computeShowEllipsis_(){if(this.isLensSearchbox_&&this.forceHideEllipsis_){return false}return this.showThumbnail}convertClassificationStyleToCssClasses_(style){const classes=[];if(style&AcMatchClassificationStyle.DIM){classes.push("dim")}if(style&AcMatchClassificationStyle.MATCH){classes.push("match")}if(style&AcMatchClassificationStyle.URL){classes.push("url")}return classes}createSpanWithClasses_(text,classes){const span=document.createElement("span");if(classes.length){span.classList.add(...classes)}span.textContent=text;return span}renderTextWithClassifications_(text,classifications){const container=document.createElement("span");if(classifications.length===0){container.appendChild(this.createSpanWithClasses_(text,[]));return container}const firstClassification=classifications[0];if(firstClassification.offset>0){const prefix=text.substring(0,firstClassification.offset);container.appendChild(this.createSpanWithClasses_(prefix,[]))}classifications.map((({offset:offset,style:style},index)=>{const nextOffset=index+1<classifications.length?classifications[index+1].offset:text.length;const subString=text.substring(offset,nextOffset);const classes=this.convertClassificationStyleToCssClasses_(style);container.appendChild(this.createSpanWithClasses_(subString,classes))}));return container}getMatchContents_(){if(!this.match){return""}const match=this.match;const matchContents=match.answer?match.answer.firstLine:match.contents;const matchDescription=match.answer?match.answer.secondLine:match.description;return match.swapContentsAndDescription?matchDescription:matchContents}getMatchDescription_(){if(!this.match){return""}const match=this.match;const matchContents=match.answer?match.answer.firstLine:match.contents;const matchDescription=match.answer?match.answer.secondLine:match.description;return match.swapContentsAndDescription?matchContents:matchDescription}getMatchContentsClassifications_(){if(!this.match){return[]}const match=this.match;return match.swapContentsAndDescription?match.descriptionClass:match.contentsClass}getMatchDescriptionClassifications_(){if(!this.match){return[]}const match=this.match;return match.swapContentsAndDescription?match.contentsClass:match.descriptionClass}getFocusIndicatorCssClass_(){return this.selection.line===this.matchIndex&&this.selection.state!==SelectionLineState.kNormal&&!this.match.hasInstantKeyword?"selected-within":""}getKeywordCssClass_(){return this.selection.line===this.matchIndex&&this.selection.state===SelectionLineState.kKeywordMode?"selected":""}getActionCssClass_(actionIndex){return this.selection.line===this.matchIndex&&this.selection.state===SelectionLineState.kFocusedButtonAction&&this.selection.actionIndex===actionIndex?"selected":""}getRemoveCssClass_(){return this.selection.line===this.matchIndex&&this.selection.state===SelectionLineState.kFocusedButtonRemoveSuggestion?"selected":""}}customElements.define(SearchboxMatchElement.is,SearchboxMatchElement);class PageMetricsHostPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"metrics_reporter.mojom.PageMetricsHost",scope)}}class PageMetricsHostRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageMetricsHostPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onPageRemoteCreated(page){this.proxy.sendMessage(0,PageMetricsHost_OnPageRemoteCreated_ParamsSpec.$,null,[page],false)}onGetMark(name){return this.proxy.sendMessage(1,PageMetricsHost_OnGetMark_ParamsSpec.$,PageMetricsHost_OnGetMark_ResponseParamsSpec.$,[name],false)}onClearMark(name){this.proxy.sendMessage(2,PageMetricsHost_OnClearMark_ParamsSpec.$,null,[name],false)}onUmaReportTime(name,time){this.proxy.sendMessage(3,PageMetricsHost_OnUmaReportTime_ParamsSpec.$,null,[name,time],false)}}class PageMetricsHost{static get $interfaceName(){return"metrics_reporter.mojom.PageMetricsHost"}static getRemote(){let remote=new PageMetricsHostRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}class PageMetricsPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"metrics_reporter.mojom.PageMetrics",scope)}}class PageMetricsRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageMetricsPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onGetMark(name){return this.proxy.sendMessage(0,PageMetrics_OnGetMark_ParamsSpec.$,PageMetrics_OnGetMark_ResponseParamsSpec.$,[name],false)}onClearMark(name){this.proxy.sendMessage(1,PageMetrics_OnClearMark_ParamsSpec.$,null,[name],false)}}class PageMetricsCallbackRouter{helper_internal_;$;router_;onGetMark;onClearMark;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageMetricsRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onGetMark=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PageMetrics_OnGetMark_ParamsSpec.$,PageMetrics_OnGetMark_ResponseParamsSpec.$,this.onGetMark.createReceiverHandler(true),false);this.onClearMark=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,PageMetrics_OnClearMark_ParamsSpec.$,null,this.onClearMark.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}const PageMetricsHost_OnPageRemoteCreated_ParamsSpec={$:{}};const PageMetricsHost_OnGetMark_ParamsSpec={$:{}};const PageMetricsHost_OnGetMark_ResponseParamsSpec={$:{}};const PageMetricsHost_OnClearMark_ParamsSpec={$:{}};const PageMetricsHost_OnUmaReportTime_ParamsSpec={$:{}};const PageMetrics_OnGetMark_ParamsSpec={$:{}};const PageMetrics_OnGetMark_ResponseParamsSpec={$:{}};const PageMetrics_OnClearMark_ParamsSpec={$:{}};mojo.internal.Struct(PageMetricsHost_OnPageRemoteCreated_ParamsSpec.$,"PageMetricsHost_OnPageRemoteCreated_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageMetricsRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageMetricsHost_OnGetMark_ParamsSpec.$,"PageMetricsHost_OnGetMark_Params",[mojo.internal.StructField("name",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageMetricsHost_OnGetMark_ResponseParamsSpec.$,"PageMetricsHost_OnGetMark_ResponseParams",[mojo.internal.StructField("markedTime",0,0,TimeDeltaSpec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageMetricsHost_OnClearMark_ParamsSpec.$,"PageMetricsHost_OnClearMark_Params",[mojo.internal.StructField("name",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageMetricsHost_OnUmaReportTime_ParamsSpec.$,"PageMetricsHost_OnUmaReportTime_Params",[mojo.internal.StructField("name",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("time",8,0,TimeDeltaSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageMetrics_OnGetMark_ParamsSpec.$,"PageMetrics_OnGetMark_Params",[mojo.internal.StructField("name",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageMetrics_OnGetMark_ResponseParamsSpec.$,"PageMetrics_OnGetMark_ResponseParams",[mojo.internal.StructField("markedTime",0,0,TimeDeltaSpec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageMetrics_OnClearMark_ParamsSpec.$,"PageMetrics_OnClearMark_Params",[mojo.internal.StructField("name",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);class BrowserProxyImpl{callbackRouter;host;constructor(){this.callbackRouter=new PageMetricsCallbackRouter;this.host=PageMetricsHost.getRemote();this.host.onPageRemoteCreated(this.callbackRouter.$.bindNewPipeAndPassRemote())}getMark(name){return this.host.onGetMark(name)}clearMark(name){this.host.onClearMark(name)}umaReportTime(name,time){this.host.onUmaReportTime(name,time)}now(){return chrome.timeTicks.nowInMicroseconds()}getCallbackRouter(){return this.callbackRouter}static getInstance(){return instance$7||(instance$7=new BrowserProxyImpl)}static setInstance(obj){instance$7=obj}}let instance$7=null;function timeFromMojo(delta){return delta.microseconds}function timeToMojo(mark){return{microseconds:mark}}class MetricsReporterImpl{marks_=new Map;browserProxy_=BrowserProxyImpl.getInstance();constructor(){const callbackRouter=this.browserProxy_.getCallbackRouter();callbackRouter.onGetMark.addListener((name=>({markedTime:this.marks_.has(name)?timeToMojo(this.marks_.get(name)):null})));callbackRouter.onClearMark.addListener((name=>this.marks_.delete(name)))}static getInstance(){return instance$6||(instance$6=new MetricsReporterImpl)}static setInstanceForTest(newInstance){instance$6=newInstance}mark(name,time){this.marks_.set(name,time??this.browserProxy_.now())}async measure(startMark,endMark){let endTime;if(endMark){const entry=this.marks_.get(endMark);assert(entry,`Mark "${endMark}" does not exist locally.`);endTime=entry}else{endTime=this.browserProxy_.now()}let startTime;if(this.marks_.has(startMark)){startTime=this.marks_.get(startMark)}else{const remoteStartTime=await this.browserProxy_.getMark(startMark);assert(remoteStartTime.markedTime,`Mark "${startMark}" does not exist locally or remotely.`);startTime=timeFromMojo(remoteStartTime.markedTime)}return endTime-startTime}async hasMark(name){if(this.marks_.has(name)){return true}const remoteMark=await this.browserProxy_.getMark(name);return remoteMark!==null&&remoteMark.markedTime!==null}hasLocalMark(name){return this.marks_.has(name)}clearMark(name){this.marks_.delete(name);this.browserProxy_.clearMark(name)}umaReportTime(histogram,time){this.browserProxy_.umaReportTime(histogram,timeToMojo(time))}}let instance$6=null;let instance$5=null;function getCss$5(){return instance$5||(instance$5=[...[getCss$r(),getCss$7()],css`:host{user-select:none}#content{background-color:var(--color-searchbox-results-background);border-radius:calc(0.5 * var(--cr-searchbox-height));box-shadow:var(--cr-searchbox-shadow);display:flex;gap:16px;margin-bottom:var(--cr-searchbox-results-margin-bottom,8px);overflow:hidden;padding-bottom:8px;padding-top:var(--cr-searchbox-height)}@media (forced-colors:active){#content{border:1px solid ActiveBorder}}.matches{display:contents}cr-searchbox-match{color:var(--color-searchbox-results-foreground)}cr-searchbox-match:-webkit-any(:focus-within,[selected]){color:var(--color-searchbox-results-foreground-selected)}.header{align-items:center;box-sizing:border-box;display:flex;font-size:inherit;font-weight:inherit;height:44px;margin-block-end:0;margin-block-start:0;outline:none;padding-bottom:6px;padding-inline-end:16px;padding-inline-start:var(--cr-searchbox-dropdown-header-padding-inline-start,12px);padding-top:6px}.header .text{color:var(--color-searchbox-results-foreground-dimmed);font-size:.875em;font-weight:500;overflow:hidden;padding-inline-end:1px;text-overflow:ellipsis;white-space:nowrap}@media (forced-colors:active){cr-searchbox-match:-webkit-any(:hover,:focus-within,[selected]){background-color:Highlight}}.primary-side{flex:1;min-width:0}:host-context([is-lens-searchbox_]) .primary-side::before{content:'';position:relative;height:1px;background-color:var(--color-searchbox-dropdown-divider);top:0;width:calc(var(--cr-searchbox-width) - 24px);display:block;inset-inline-start:12px;margin-block-end:4px}.secondary-side{display:var(--cr-searchbox-secondary-side-display,none);min-width:0;padding-block-end:8px;padding-inline-end:16px;width:314px}.secondary-side .header{padding-inline-end:0;padding-inline-start:0}.secondary-side .matches{display:block}.secondary-side .matches.horizontal{display:flex;gap:4px}`])}function getMatchesForGroupHtml(sideType,groupId){const hasHeader=this.hasHeaderForGroup_(groupId);const matchesHtml=html`
    <div class="matches ${this.renderTypeClassForGroup_(groupId)}">
    ${this.matchesForGroup_(groupId).map((match=>html`
      <cr-searchbox-match tabindex="0" role="option"
          aria-describedby="${hasHeader?`hg_${groupId}`:nothing}"
          .match="${match}" match-index="${this.matchIndex_(match)}"
          side-type="${sideType}"
          ?selected="${this.isSelected_(match)}"
          ?show-thumbnail="${this.showThumbnail}">
      </cr-searchbox-match>
    `))}
    </div>
  `;return hasHeader?html`
    <!-- Header cannot be tabbed into but gets focus when clicked. This
        stops the dropdown from losing focus and closing as a result. -->
    <h3 class="header" data-id="${groupId}" tabindex="-1"
        id="hg_${groupId}"
        @mousedown="${this.onHeaderMousedown_}">
        <span class="text">${this.headerForGroup_(groupId)}</span>
    </h3>
    ${matchesHtml}`:matchesHtml}function getHtml$5(){return html`<!--_html_template_start_-->
<div id="content" part="dropdown-content">
${this.sideTypes_().map((sideType=>html`
  <div class="${this.sideTypeClass_(sideType)}">
    ${this.groupIdsForSideType_(sideType).map((groupId=>getMatchesForGroupHtml.bind(this)(sideType,groupId)))}
  </div>
`))}
</div>
<!--_html_template_end_-->`}const remainder=(lhs,rhs)=>(lhs%rhs+rhs)%rhs;class SearchboxDropdownElement extends CrLitElement{static get is(){return"cr-searchbox-dropdown"}static get styles(){return getCss$5()}render(){return getHtml$5.bind(this)()}static get properties(){return{canShowSecondarySide:{type:Boolean},hadSecondarySide:{type:Boolean,notify:true},hasSecondarySide:{type:Boolean,notify:true,reflect:true},hasEmptyInput:{type:Boolean,reflect:true},result:{type:Object},selectedMatchIndex:{type:Number,notify:true},showThumbnail:{type:Boolean},showSecondarySide_:{type:Boolean}}}#canShowSecondarySide_accessor_storage=false;get canShowSecondarySide(){return this.#canShowSecondarySide_accessor_storage}set canShowSecondarySide(value){this.#canShowSecondarySide_accessor_storage=value}#hadSecondarySide_accessor_storage=false;get hadSecondarySide(){return this.#hadSecondarySide_accessor_storage}set hadSecondarySide(value){this.#hadSecondarySide_accessor_storage=value}#hasSecondarySide_accessor_storage=false;get hasSecondarySide(){return this.#hasSecondarySide_accessor_storage}set hasSecondarySide(value){this.#hasSecondarySide_accessor_storage=value}#hasEmptyInput_accessor_storage=false;get hasEmptyInput(){return this.#hasEmptyInput_accessor_storage}set hasEmptyInput(value){this.#hasEmptyInput_accessor_storage=value}#result_accessor_storage=null;get result(){return this.#result_accessor_storage}set result(value){this.#result_accessor_storage=value}#selectedMatchIndex_accessor_storage=-1;get selectedMatchIndex(){return this.#selectedMatchIndex_accessor_storage}set selectedMatchIndex(value){this.#selectedMatchIndex_accessor_storage=value}#showThumbnail_accessor_storage=false;get showThumbnail(){return this.#showThumbnail_accessor_storage}set showThumbnail(value){this.#showThumbnail_accessor_storage=value}#showSecondarySide__accessor_storage=false;get showSecondarySide_(){return this.#showSecondarySide__accessor_storage}set showSecondarySide_(value){this.#showSecondarySide__accessor_storage=value}selectableMatchElements_=[];willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("result")){this.hasSecondarySide=this.computeHasSecondarySide_();this.hasEmptyInput=this.computeHasEmptyInput_()}if(changedProperties.has("result")||changedProperties.has("canShowSecondarySide")){this.showSecondarySide_=this.computeShowSecondarySide_()}}updated(changedProperties){super.updated(changedProperties);this.onResultRepaint_();this.selectableMatchElements_=[...this.shadowRoot.querySelectorAll("cr-searchbox-match")]}get selectableMatchElements(){return this.selectableMatchElements_.filter((matchEl=>matchEl.sideType===SideType.kDefaultPrimary||this.showSecondarySide_))}unselect(){this.selectedMatchIndex=-1}focusSelected(){this.selectableMatchElements[this.selectedMatchIndex]?.focus()}selectFirst(){this.selectedMatchIndex=0;return this.updateComplete}selectIndex(index){this.selectedMatchIndex=index;return this.updateComplete}updateSelection(oldSelection,selection){if(oldSelection.line!==selection.line){const oldMatch=this.selectableMatchElements[this.selectedMatchIndex];if(oldMatch){oldMatch.selection=selection}}this.selectIndex(selection.line);const newMatch=this.selectableMatchElements[this.selectedMatchIndex];if(newMatch){newMatch.selection=selection}}selectPrevious(){const previous=Math.max(this.selectedMatchIndex,0)-1;this.selectedMatchIndex=remainder(previous,this.selectableMatchElements.length);return this.updateComplete}selectLast(){this.selectedMatchIndex=this.selectableMatchElements.length-1;return this.updateComplete}selectNext(){const next=this.selectedMatchIndex+1;this.selectedMatchIndex=remainder(next,this.selectableMatchElements.length);return this.updateComplete}onHeaderMousedown_(e){e.preventDefault()}onResultRepaint_(){if(!loadTimeData.getBoolean("reportMetrics")){return}const metricsReporter=MetricsReporterImpl.getInstance();metricsReporter.measure("CharTyped").then((duration=>{metricsReporter.umaReportTime(loadTimeData.getString("charTypedToPaintMetricName"),duration)})).then((()=>{metricsReporter.clearMark("CharTyped")})).catch((()=>{}));metricsReporter.measure("ResultChanged").then((duration=>{metricsReporter.umaReportTime(loadTimeData.getString("resultChangedToPaintMetricName"),duration)})).then((()=>{metricsReporter.clearMark("ResultChanged")})).catch((()=>{}))}sideTypeClass_(side){return sideTypeToClass(side)}renderTypeClassForGroup_(groupId){return renderTypeToClass(this.result?.suggestionGroupsMap[groupId]?.renderType??RenderType.kDefaultVertical)}computeHasSecondarySide_(){const hasSecondarySide=!!this.groupIdsForSideType_(SideType.kSecondary).length;if(!this.hadSecondarySide){this.hadSecondarySide=hasSecondarySide}return hasSecondarySide}computeHasEmptyInput_(){return!!this.result&&this.result.input===""}isSelected_(match){return this.matchIndex_(match)===this.selectedMatchIndex}groupIdsForSideType_(side){return[...new Set(this.result?.matches.map((match=>match.suggestionGroupId)).filter((groupId=>this.sideTypeForGroup_(groupId)===side)))]}hasHeaderForGroup_(groupId){return!!this.headerForGroup_(groupId)}headerForGroup_(groupId){return this.result?.suggestionGroupsMap[groupId]?this.result.suggestionGroupsMap[groupId].header:""}matchIndex_(match){return this.result?.matches.indexOf(match)??-1}matchesForGroup_(groupId){return(this.result?.matches??[]).filter((match=>match.suggestionGroupId===groupId&&!match.isHidden))}sideTypes_(){return this.showSecondarySide_?[SideType.kDefaultPrimary,SideType.kSecondary]:[SideType.kDefaultPrimary]}sideTypeForGroup_(groupId){return this.result?.suggestionGroupsMap[groupId]?.sideType??SideType.kDefaultPrimary}computeShowSecondarySide_(){if(!this.canShowSecondarySide){return false}const primaryGroupIds=this.groupIdsForSideType_(SideType.kDefaultPrimary);return primaryGroupIds.some((groupId=>this.matchesForGroup_(groupId).length>0))}}customElements.define(SearchboxDropdownElement.is,SearchboxDropdownElement);let instance$4=null;function getCss$4(){return instance$4||(instance$4=[...[getCss$b()],css`:host{--cr-searchbox-dropdown-header-padding-inline-start:16px;--cr-searchbox-results-search-icon-size:16px;--cr-searchbox-icon-container-size:28px;--cr-searchbox-match-icon-container-background-fallback:var(--color-omnibox-results-background-hovered);--cr-searchbox-match-padding:6px;--cr-searchbox-match-padding-inline-start:16px;--cr-searchbox-match-text-padding-inline-start:12px;--cr-searchbox-min-width:75%;--cr-searchbox-results-action-chip-height:26px;--cr-searchbox-results-margin-bottom:0;--cr-searchbox-width:100%;--cr-searchbox-match-font-weight:700;--text-input-inline-start-spacing:16px;--contextual-entrypoint-and-carousel-context-menu-container-padding-inline-start:0;--contextual-entrypoint-and-carousel-carousel-divider-margin-top:8px;--contextual-entrypoint-and-carousel-carousel-divider-margin-bottom:8px;font-size:var(--omnibox-font-size);--color-searchbox-answer-icon-background:var(--color-omnibox-answer-icon-g-m3-background);--color-searchbox-answer-icon-foreground:var(--color-omnibox-answer-icon-g-m3-foreground);--color-searchbox-results-action-chip-focus-outline:var(--color-omnibox-results-focus-indicator);--color-searchbox-results-action-chip:var(--color-omnibox-results-button-border);--color-searchbox-results-action-chip-icon:var(--color-omnibox-results-button-icon);--color-searchbox-results-action-chip-icon-selected:var(--color-omnibox-results-button-icon-selected);--color-searchbox-results-background:var(--color-omnibox-results-background);--color-searchbox-results-button-selected-hover:var(--color-omnibox-results-button-ink-drop-row-selected);--color-searchbox-results-dim-selected:var(--color-omnibox-results-text-dimmed-selected);--color-searchbox-results-foreground-dimmed:var(--color-omnibox-results-text-dimmed);--color-searchbox-results-icon:var(--color-omnibox-results-icon);--color-searchbox-results-icon-container-background:unset;--color-searchbox-results-starter-pack-icon:var(--color-omnibox-results-starter-pack-icon);--color-searchbox-results-typed-prefix:unset;--color-searchbox-results-url-selected:var(--color-omnibox-results-url-selected);--color-searchbox-results-url:var(--color-omnibox-results-url);--color-searchbox-search-icon-background:var(--color-omnibox-results-icon)}contextual-entrypoint-and-carousel{--composebox-context-menu-entrypoint-button-color:var(--color-omnibox-context-entrypoint-text);--composebox-lens-search-icon-color:var(--color-omnibox-composebox-primary-action);--composebox-lens-search-button-text-color:var(--color-omnibox-text);--color-composebox-context-entrypoint-hover-background:var(--color-omnibox-action-icon-hover);--color-composebox-context-entrypoint-text:var(--color-omnibox-context-entrypoint-text);--color-composebox-lens-search-button-border-color:var(--color-omnibox-keyword-separator);--color-composebox-recent-tab-chip-outline:var(--color-omnibox-keyword-separator)}contextual-entrypoint-and-carousel[searchbox-layout-mode="TallBottomContext"]{--contextual-entrypoint-and-carousel-context-menu-container-margin-bottom:9px}contextual-entrypoint-and-carousel[searchbox-layout-mode="TallTopContext"]{--contextual-entrypoint-and-carousel-contextual-chip-padding-bottom:10px;&:not([show-dropdown]){--contextual-entrypoint-and-carousel-contextual-chip-padding-bottom:0px;--contextual-entrypoint-and-carousel-context-menu-container-margin-bottom:9px}}contextual-entrypoint-and-carousel[searchbox-layout-mode="Compact"]{--contextual-entrypoint-and-carousel-context-entrypoint-padding-inline:0px;--contextual-entrypoint-and-carousel-context-menu-container-padding-inline-start:12px;--contextual-entrypoint-and-carousel-contextual-chip-padding-bottom:16px}:host([can-show-secondary-side][has-secondary-side]){--cr-searchbox-secondary-side-display:block}:host([is-debug]){display:block;width:50%}`])}function getHtml$4(){const searchboxDropdown=html`
<cr-searchbox-dropdown part="searchbox-dropdown"
    exportparts="dropdown-content"
    role="listbox" .result="${this.result_}"
    ?can-show-secondary-side="${this.canShowSecondarySide}"
    ?has-secondary-side="${this.hasSecondarySide}"
    @has-secondary-side-changed="${this.onHasSecondarySideChanged_}"
    @dom-change="${this.onResultRepaint_}"
    ?hidden="${!this.hasVisibleMatches_}">
</cr-searchbox-dropdown>
  `;return html`<!--_html_template_start_-->
${this.showContextEntrypoint_?html`
<!-- WebUI Omnibox popup w/ "Add Context" button -->
<div class="dropdownContainer">
  <contextual-entrypoint-and-carousel id="context"
      part="contextual-entrypoint-and-carousel"
      exportparts="composebox-entrypoint, context-menu-entrypoint-icon"
      entrypoint-name="Omnibox"
      searchbox-layout-mode="${this.searchboxLayoutMode_}"
      .tabSuggestions="${this.tabSuggestions_}"
      ?hide-entrypoint-button="${this.shouldHideEntrypointButton_}"
      ?show-dropdown="${this.hasVisibleMatches_}"
      ?show-lens-search-chip="${this.isLensSearchEligible_}"
      ?show-recent-tab-chip="${this.computeShowRecentTabChip_()}"
      @add-tab-context="${this.addTabContext_}"
      @context-menu-entrypoint-click="${this.onContextualEntryPointClicked_}"
      @lens-search-click="${this.onLensSearchChipClicked_}">
    ${searchboxDropdown}
  </contextual-entrypoint-and-carousel>
</div>`:html`
<!-- WebUI Omnibox popup w/o "Add Context" button -->
  ${searchboxDropdown}`}
<!--_html_template_end_-->`}const canShowSecondarySideMediaQueryList=window.matchMedia("(min-width: 675px)");class OmniboxPopupAppElement extends(I18nMixinLit(CrLitElement)){static get is(){return"omnibox-popup-app"}static get styles(){return getCss$4()}render(){return getHtml$4.bind(this)()}static get properties(){return{canShowSecondarySide:{type:Boolean,reflect:true},hasSecondarySide:{type:Boolean,reflect:true},isDebug:{type:Boolean,reflect:true},hasVisibleMatches_:{type:Boolean,reflect:true},isInKeywordMode_:{type:Boolean},result_:{type:Object},searchboxLayoutMode_:{type:String},showContextEntrypoint_:{type:Boolean},showAiModePrefEnabled_:{type:Boolean},isContentSharingEnabled_:{type:Boolean},isLensSearchEnabled_:{type:Boolean},isLensSearchEligible_:{type:Boolean},isAimEligible_:{type:Boolean},isRecentTabChipEnabled_:{type:Boolean},tabSuggestions_:{type:Array}}}#canShowSecondarySide_accessor_storage=canShowSecondarySideMediaQueryList.matches;get canShowSecondarySide(){return this.#canShowSecondarySide_accessor_storage}set canShowSecondarySide(value){this.#canShowSecondarySide_accessor_storage=value}#hasSecondarySide_accessor_storage=false;get hasSecondarySide(){return this.#hasSecondarySide_accessor_storage}set hasSecondarySide(value){this.#hasSecondarySide_accessor_storage=value}#isDebug_accessor_storage=false;get isDebug(){return this.#isDebug_accessor_storage}set isDebug(value){this.#isDebug_accessor_storage=value}#isInKeywordMode__accessor_storage=false;get isInKeywordMode_(){return this.#isInKeywordMode__accessor_storage}set isInKeywordMode_(value){this.#isInKeywordMode__accessor_storage=value}#showAiModePrefEnabled__accessor_storage=false;get showAiModePrefEnabled_(){return this.#showAiModePrefEnabled__accessor_storage}set showAiModePrefEnabled_(value){this.#showAiModePrefEnabled__accessor_storage=value}#hasVisibleMatches__accessor_storage=false;get hasVisibleMatches_(){return this.#hasVisibleMatches__accessor_storage}set hasVisibleMatches_(value){this.#hasVisibleMatches__accessor_storage=value}#result__accessor_storage=null;get result_(){return this.#result__accessor_storage}set result_(value){this.#result__accessor_storage=value}#searchboxLayoutMode__accessor_storage=loadTimeData.getString("searchboxLayoutMode");get searchboxLayoutMode_(){return this.#searchboxLayoutMode__accessor_storage}set searchboxLayoutMode_(value){this.#searchboxLayoutMode__accessor_storage=value}#showContextEntrypoint__accessor_storage=false;get showContextEntrypoint_(){return this.#showContextEntrypoint__accessor_storage}set showContextEntrypoint_(value){this.#showContextEntrypoint__accessor_storage=value}#isContentSharingEnabled__accessor_storage=false;get isContentSharingEnabled_(){return this.#isContentSharingEnabled__accessor_storage}set isContentSharingEnabled_(value){this.#isContentSharingEnabled__accessor_storage=value}#isLensSearchEnabled__accessor_storage=loadTimeData.getBoolean("composeboxShowLensSearchChip");get isLensSearchEnabled_(){return this.#isLensSearchEnabled__accessor_storage}set isLensSearchEnabled_(value){this.#isLensSearchEnabled__accessor_storage=value}#isRecentTabChipEnabled__accessor_storage=loadTimeData.getBoolean("composeboxShowRecentTabChip");get isRecentTabChipEnabled_(){return this.#isRecentTabChipEnabled__accessor_storage}set isRecentTabChipEnabled_(value){this.#isRecentTabChipEnabled__accessor_storage=value}#isLensSearchEligible__accessor_storage=false;get isLensSearchEligible_(){return this.#isLensSearchEligible__accessor_storage}set isLensSearchEligible_(value){this.#isLensSearchEligible__accessor_storage=value}#isAimEligible__accessor_storage=false;get isAimEligible_(){return this.#isAimEligible__accessor_storage}set isAimEligible_(value){this.#isAimEligible__accessor_storage=value}#tabSuggestions__accessor_storage=[];get tabSuggestions_(){return this.#tabSuggestions__accessor_storage}set tabSuggestions_(value){this.#tabSuggestions__accessor_storage=value}callbackRouter_;eventTracker_=new EventTracker;listenerIds_=[];pageHandler_;constructor(){super();this.callbackRouter_=SearchboxBrowserProxy.getInstance().callbackRouter;this.isDebug=new URLSearchParams(window.location.search).has("debug");this.pageHandler_=SearchboxBrowserProxy.getInstance().handler;ColorChangeUpdater.forDocument().start()}connectedCallback(){super.connectedCallback();this.listenerIds_=[this.callbackRouter_.autocompleteResultChanged.addListener(this.onAutocompleteResultChanged_.bind(this)),this.callbackRouter_.onShow.addListener(this.onShow_.bind(this)),this.callbackRouter_.updateSelection.addListener(this.onUpdateSelection_.bind(this)),this.callbackRouter_.setKeywordSelected.addListener((isKeywordSelected=>{this.isInKeywordMode_=isKeywordSelected})),this.callbackRouter_.updateLensSearchEligibility.addListener((eligible=>{this.isLensSearchEligible_=this.isLensSearchEnabled_&&eligible})),this.callbackRouter_.onTabStripChanged.addListener(this.refreshTabSuggestions_.bind(this)),this.callbackRouter_.updateAimEligibility.addListener((eligible=>{this.isAimEligible_=eligible})),this.callbackRouter_.onShowAiModePrefChanged.addListener((canShow=>{this.showAiModePrefEnabled_=canShow})),this.callbackRouter_.updateContentSharingPolicy.addListener((enabled=>{this.isContentSharingEnabled_=enabled}))];canShowSecondarySideMediaQueryList.addEventListener("change",this.onCanShowSecondarySideChanged_.bind(this));this.refreshTabSuggestions_();if(!this.isDebug){this.eventTracker_.add(document.documentElement,"contextmenu",(e=>{e.preventDefault()}))}}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll();for(const listenerId of this.listenerIds_){this.callbackRouter_.removeListener(listenerId)}this.listenerIds_=[];canShowSecondarySideMediaQueryList.removeEventListener("change",this.onCanShowSecondarySideChanged_.bind(this))}willUpdate(changedProperties){super.willUpdate(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("result_")){this.hasVisibleMatches_=this.result_?.matches.some((match=>!match.isHidden))??false}if(changedPrivateProperties.has("isAimEligible_")||changedPrivateProperties.has("searchboxLayoutMode_")||changedPrivateProperties.has("isInKeywordMode_")||changedPrivateProperties.has("showAiModePrefEnabled_")||changedPrivateProperties.has("tabSuggestions_")||changedPrivateProperties.has("result_")||changedPrivateProperties.has("isLensSearchEligible_")||changedPrivateProperties.has("isContentSharingEnabled_")){this.showContextEntrypoint_=this.computeShowContextEntrypoint_()}}getDropdown(){return this.shadowRoot.querySelector("cr-searchbox-dropdown")}get shouldHideEntrypointButton_(){return this.searchboxLayoutMode_==="Compact"}computeShowContextEntrypoint_(){const isTallSearchbox=this.searchboxLayoutMode_.startsWith("Tall");const showRecentTabChip=this.computeShowRecentTabChip_();const showContextualChips=showRecentTabChip||this.isLensSearchEligible_;const showContextualChipsInCompactMode=showContextualChips&&this.searchboxLayoutMode_==="Compact";return this.isAimEligible_&&this.showAiModePrefEnabled_&&(isTallSearchbox||showContextualChipsInCompactMode)&&!this.isInKeywordMode_&&this.isContentSharingEnabled_}onCanShowSecondarySideChanged_(e){this.canShowSecondarySide=e.matches}onAutocompleteResultChanged_(result){if(this.isDebug&&!result.matches.length){return}this.result_=result;if(result.matches[0]?.allowedToBeDefaultMatch){this.getDropdown().selectFirst()}else if(this.getDropdown().selectedMatchIndex>=result.matches.length){this.getDropdown().unselect()}}onShow_(){if(this.showContextEntrypoint_){this.$.context.blurEntrypoint()}}onResultRepaint_(){const metricsReporter=MetricsReporterImpl.getInstance();metricsReporter.measure("ResultChanged").then((duration=>metricsReporter.umaReportTime("WebUIOmnibox.ResultChangedToRepaintLatency.ToPaint",duration))).then((()=>metricsReporter.clearMark("ResultChanged"))).catch((()=>{}))}onUpdateSelection_(oldSelection,selection){this.getDropdown().updateSelection(oldSelection,selection)}onHasSecondarySideChanged_(e){this.hasSecondarySide=e.detail.value}onContextualEntryPointClicked_(e){e.preventDefault();const point={x:e.detail.x,y:e.detail.y};this.pageHandler_.showContextMenu(point)}async refreshTabSuggestions_(){const{tabs:tabs}=await this.pageHandler_.getRecentTabs();this.tabSuggestions_=[...tabs]}onLensSearchChipClicked_(){this.pageHandler_.openLensSearch()}addTabContext_(e){this.pageHandler_.addTabContext(e.detail.id,e.detail.delayUpload)}computeShowRecentTabChip_(){const input=this.result_?.input;let recentTabForChip=this.tabSuggestions_.find((tab=>tab.showInCurrentTabChip))||null;if(!recentTabForChip){recentTabForChip=this.tabSuggestions_.find((tab=>tab.showInPreviousTabChip))||null}return loadTimeData.getBoolean("composeboxShowRecentTabChip")&&(input?.length===0||this.stripUrl_(input)===this.stripUrl_(recentTabForChip?.url.url))}stripUrl_(url){if(!url){return""}return url.replace(/^https?:\/\/(?:www\.)?/,"").replace(/\/$/,"")}}customElements.define(OmniboxPopupAppElement.is,OmniboxPopupAppElement);let instance$3=null;function getCss$3(){return instance$3||(instance$3=[...[],css`:host{--cr-hover-background-color:#FFFFFF;--cr-button-height:32px;flex-shrink:0}#composeButton{background-color:#F3F5F6;color:#1F1F1F;font-weight:400;font-family:inherit;font-size:inherit;border:none;position:relative;gap:3px}.compose-container{z-index:100;position:relative;padding-inline-end:12px;padding-inline-start:8px}.compose-icon{filter:invert(1);vertical-align:text-bottom;height:18px;width:18px;padding-top:2px;padding-left:1px}#glowAnimationWrapper{--anim-duration:2s;--glif-angle-start:99deg;--glif-angle-range:245deg;--mask-angle-start:-150deg;--mask-angle-range:355deg;--acceleration:cubic-bezier(0.4,0,0.2,1);--glif-gradient:conic-gradient(rgba(52,168,82,0) 0deg,rgba(52,168,82,1) 38.9738deg,rgba(255,211,20,1) 62.3678deg,rgba(255,70,65,1) 87.0062deg,rgba(49,134,255,1) 107.428deg,rgba(49,134,255,0.5) 204.48deg,rgba(49,134,255,0) 308.88deg,rgba(52,168,82,0) 360deg);--mask-gradient:conic-gradient(transparent,16.56deg,273.24deg,transparent 333.36deg,transparent 360deg)}@keyframes rotate-glif-anim{from{rotate:var(--glif-angle-start)}to{rotate:calc(var(--glif-angle-start) + var(--glif-angle-range))}}@keyframes rotate-mask-anim{from{rotate:var(--mask-angle-start)}to{rotate:calc(var(--mask-angle-start) + var(--mask-angle-range))}}@keyframes rotate-glif-anim-infinite{from{rotate:var(--glif-angle-start)}to{rotate:calc(var(--glif-angle-start) + 360deg)}}@keyframes rotate-mask-anim-infinite{from{rotate:var(--mask-angle-start)}to{rotate:calc(var(--mask-angle-start) + 360deg)}}@keyframes fade-in-out{0%{opacity:0}10%{opacity:1}60%{opacity:1}100%{opacity:0}}@keyframes fade-in-out-infinite{0%{opacity:0}10%{opacity:1}60%{opacity:1}100%{opacity:1}}.glow-container{align-items:center;border-radius:100px;display:flex;height:36px;margin-inline-end:8px;padding-inline:2px;position:relative;top:6px;z-index:var(--cr-searchbox-compose-button-z-index,100)}:host-context([ntp-realbox-next-enabled]){--cr-button-height:36px}:host-context([ntp-realbox-next-enabled]) #composeButton{font-size:13px;font-weight:500}:host-context([ntp-realbox-next-enabled]) .glow-container{height:var(--cr-searchbox-icon-size);top:8px}:host-context([searchbox-layout-mode^='Tall']) .glow-container{top:var(--cr-searchbox-compose-button-position-top);transform:none}.gradient-and-mask-wrapper{overflow:hidden;position:absolute;inset:0;border-radius:100px;opacity:0;pointer-events:none;transition:opacity 500ms ease-out}.play .gradient-and-mask-wrapper{opacity:1;pointer-events:auto}#glowAnimationWrapper:hover .gradient-and-mask-wrapper{opacity:1;pointer-events:auto}.outer-glow{filter:blur(40px)}:host([ntp-realbox-next-enabled_]) .outer-glow{filter:blur(2px)}#glowAnimationWrapper:hover .outer-glow{filter:none}:host([ntp-realbox-next-enabled_]) #glowAnimationWrapper:hover .outer-glow{filter:blur(2px)}.gradient,.mask{position:absolute;inset:0;transform-origin:center;translate:0 -50%;top:50%;scale:1.1 0.6;border-radius:50%;aspect-ratio:1/1}.gradient:before,.mask:before{content:'';position:absolute;inset:0;transform-origin:center}.gradient:before{background:var(--glif-gradient);rotate:var(--glif-angle-start)}.play .gradient:before{animation:rotate-glif-anim var(--anim-duration) var(--acceleration) forwards,fade-in-out var(--anim-duration) linear forwards}.mask:before{background:var(--mask-gradient);rotate:var(--mask-angle-start)}:host([ntp-realbox-next-enabled_]) .gradient:before{background:var(--glif-gradient);rotate:calc(var(--glif-angle-start) + var(--mouse-angle,0deg))}:host([ntp-realbox-next-enabled_]) .play .gradient:before{animation:fade-in-out var(--anim-duration) linear forwards}:host([ntp-realbox-next-enabled_]) .mask:before{background:var(--mask-gradient);rotate:calc(var(--mask-angle-start) + var(--mouse-angle,0deg))}.play .mask:before{animation:rotate-mask-anim var(--anim-duration) var(--acceleration) forwards}#glowAnimationWrapper:hover .mask:before{--anim-duration:8s;animation:rotate-mask-anim-infinite var(--anim-duration) linear infinite,fade-in-out-infinite var(--anim-duration) linear forwards}#glowAnimationWrapper:hover .gradient:before{--anim-duration:8s;animation:rotate-glif-anim-infinite var(--anim-duration) linear infinite,fade-in-out-infinite var(--anim-duration) linear forwards}:host([ntp-realbox-next-enabled_]) #glowAnimationWrapper:hover .mask:before{--anim-duration:8s;animation:fade-in-out-infinite var(--anim-duration) linear forwards}:host([ntp-realbox-next-enabled_])
#glowAnimationWrapper:hover
.gradient:before{--anim-duration:8s;animation:fade-in-out-infinite var(--anim-duration) linear forwards}`])}function getHtml$3(){return html`<!--_html_template_start_-->
<div id="glowAnimationWrapper" class="glow-container play">
  <div class="gradient-and-mask-wrapper outer-glow">
    <div class="gradient"></div>
    <div class="mask"></div>
  </div>
  <div class="gradient-and-mask-wrapper">
    <div class="gradient"></div>
    <div class="mask"></div>
  </div>
  <cr-button @click="${this.onClick_}" id="composeButton"
      class="compose-container"
      title="${this.i18n("searchboxComposeButtonTitle")}">
    <img slot="prefix-icon" src="${this.composeIcon_}" class="compose-icon">
    ${this.i18n("searchboxComposeButtonText")}
  </cr-button>
</div>
<!--_html_template_end_-->`}const SearchboxComposeButtonElementBase=I18nMixinLit(CrLitElement);class SearchboxComposeButtonElement extends SearchboxComposeButtonElementBase{aimButtonAngle=0;currentAngle=0;velocity=0;animationFrame=0;rotationEase=.01;friction=.9;then=performance.now();static get is(){return"cr-searchbox-compose-button"}static get styles(){return getCss$3()}render(){return getHtml$3.bind(this)()}static get properties(){return{composeIcon_:{type:String,reflect:true},showAnimation_:{type:Boolean,reflect:true},ntpRealboxNextEnabled_:{type:Boolean,reflect:true}}}#ntpRealboxNextEnabled__accessor_storage=loadTimeData.getBoolean("ntpRealboxNextEnabled");get ntpRealboxNextEnabled_(){return this.#ntpRealboxNextEnabled__accessor_storage}set ntpRealboxNextEnabled_(value){this.#ntpRealboxNextEnabled__accessor_storage=value}#composeIcon__accessor_storage="//resources/cr_components/searchbox/icons/search_spark.svg";get composeIcon_(){return this.#composeIcon__accessor_storage}set composeIcon_(value){this.#composeIcon__accessor_storage=value}#showAnimation__accessor_storage=loadTimeData.getBoolean("searchboxShowComposeAnimation");get showAnimation_(){return this.#showAnimation__accessor_storage}set showAnimation_(value){this.#showAnimation__accessor_storage=value}firstUpdated(){if(this.$.glowAnimationWrapper){if(this.ntpRealboxNextEnabled_){this.$.glowAnimationWrapper.addEventListener("mouseenter",this.onMouseEnter_);this.$.glowAnimationWrapper.addEventListener("mouseleave",this.onMouseLeave_)}if(!this.showAnimation_){this.$.glowAnimationWrapper.classList.remove("play")}else{this.$.glowAnimationWrapper.addEventListener("animationend",(()=>{this.$.glowAnimationWrapper.classList.remove("play")}))}}}onMouseEnter_=()=>{if(this.$.glowAnimationWrapper){this.$.glowAnimationWrapper.classList.remove("play-landing-animation");this.$.glowAnimationWrapper.addEventListener("mousemove",this.onMouseMove);this.animationFrame=requestAnimationFrame(this.updateRotation)}};onMouseLeave_=()=>{if(this.$.glowAnimationWrapper){this.$.glowAnimationWrapper.removeEventListener("mousemove",this.onMouseMove);cancelAnimationFrame(this.animationFrame)}};onClick_(e){e.preventDefault();this.fire("compose-click",{button:e.button,ctrlKey:e.ctrlKey,metaKey:e.metaKey,shiftKey:e.shiftKey})}updateRotation=()=>{const now=performance.now();const elapsed=now-this.then;if(elapsed>16.67){let delta=this.currentAngle-this.aimButtonAngle;if(Math.abs(delta)>10){delta=(delta%360+540)%360-180;const normalizedDelta=this.clampValue(0,100,Math.abs(delta))/300;this.velocity+=delta*this.rotationEase*normalizedDelta;this.aimButtonAngle+=this.velocity;this.velocity*=this.friction;this.setRotationCss(this.aimButtonAngle)}this.then=now-elapsed%16.67}this.animationFrame=requestAnimationFrame(this.updateRotation)};setRotationCss(angle){this.$.glowAnimationWrapper.style.setProperty("--mouse-angle",`${angle+180}deg`)}onMouseMove=e=>{this.setCurrentAngle(e.clientX,e.clientY)};setCurrentAngle(mouseX,mouseY){const elRect=this.$.glowAnimationWrapper.getBoundingClientRect();const elX=elRect.x+elRect.width*.5;const elY=elRect.y+elRect.height*.5;this.currentAngle=this.getAngleTo(mouseX,mouseY,elX,elY)}getAngleTo(x1,y1,x2,y2){return Math.atan2(y2-y1,x2-x1)*(180/Math.PI)}clampValue(min,max,val){return Math.max(min,Math.min(val,max))}}customElements.define(SearchboxComposeButtonElement.is,SearchboxComposeButtonElement);let instance$2=null;function getCss$2(){return instance$2||(instance$2=[...[getCss$r()],css`:host{align-items:center;display:flex;flex-shrink:0;justify-content:center;outline:none}#container{align-items:center;aspect-ratio:1/1;border-radius:12px;display:flex;justify-content:center;overflow:hidden;position:relative;width:48px;height:40px}:host([enable-thumbnail-sizing-tweaks_]) #container{border-radius:8px;height:32px;width:40px}#image{display:initial;height:100%;object-fit:cover;user-select:none;width:100%}.overlay{position:absolute;justify-content:center;align-items:center;background-color:#0000000D;display:flex;width:100%;height:100%}:host([is-deletable_]:hover) .overlay,:host(:focus-visible) .overlay{background-color:var(--color-searchbox-thumbnail-overlay)}#remove{display:none}:host(:hover) #remove,:host(:focus-visible) #remove{display:flex}:host(:focus-visible) #container{border:solid 3px var(--color-searchbox-thumbnail-border);box-sizing:border-box}#remove{margin-inline-start:0px;margin-inline-end:0px;--cr-icon-button-fill-color:white;background-color:transparent}`])}function getHtml$2(){return html`<!--_html_template_start_-->
<div id="container" aria-hidden="true">
  <img id="image" src="${this.thumbnailUrl_}">
  <div class="overlay">
    ${this.isDeletable_?html`
      <cr-icon-button id="remove" class="action-icon icon-clear"
          @click="${this.onRemoveButtonClick_}">
      </cr-icon-button>
    `:""}
  </div>
</div>
<!--_html_template_end_-->`}class SearchboxThumbnailElement extends CrLitElement{static get is(){return"cr-searchbox-thumbnail"}static get styles(){return getCss$2()}render(){return getHtml$2.bind(this)()}static get properties(){return{thumbnailUrl_:{type:String},isDeletable_:{type:Boolean,reflect:true},enableThumbnailSizingTweaks_:{type:Boolean,reflect:true}}}#thumbnailUrl__accessor_storage="";get thumbnailUrl_(){return this.#thumbnailUrl__accessor_storage}set thumbnailUrl_(value){this.#thumbnailUrl__accessor_storage=value}#isDeletable__accessor_storage=false;get isDeletable_(){return this.#isDeletable__accessor_storage}set isDeletable_(value){this.#isDeletable__accessor_storage=value}#enableThumbnailSizingTweaks__accessor_storage=loadTimeData.getBoolean("enableThumbnailSizingTweaks");get enableThumbnailSizingTweaks_(){return this.#enableThumbnailSizingTweaks__accessor_storage}set enableThumbnailSizingTweaks_(value){this.#enableThumbnailSizingTweaks__accessor_storage=value}onRemoveButtonClick_(e){e.preventDefault();this.fire("remove-thumbnail-click")}}customElements.define(SearchboxThumbnailElement.is,SearchboxThumbnailElement);const WebUiListenerMixinLit=superClass=>{class WebUiListenerMixinLit extends superClass{webUiListeners_=[];addWebUiListener(eventName,callback){this.webUiListeners_.push(addWebUiListener(eventName,callback))}disconnectedCallback(){super.disconnectedCallback();while(this.webUiListeners_.length>0){removeWebUiListener(this.webUiListeners_.pop())}}}return WebUiListenerMixinLit};let instance$1=null;function getCss$1(){return instance$1||(instance$1=[...[getCss$r()],css`:host{--cr-searchbox-width:var(--cr-searchbox-min-width);--cr-searchbox-border-radius:calc(0.5 * var(--cr-searchbox-height));--cr-searchbox-icon-width:26px;--cr-searchbox-inner-icon-margin:8px;--cr-searchbox-voice-icon-offset:16px;--cr-searchbox-voice-search-button-width:0px;--cr-compose-button-width:104px;--cr-searchbox-icon-spacing:11px;border-radius:var(--cr-searchbox-border-radius);font-size:var(--cr-searchbox-font-size,16px);height:var(--cr-searchbox-height);width:var(--cr-searchbox-width);z-index:99}:host([is-lens-searchbox_]:not([dropdown-is-visible])){--cr-searchbox-shadow:none}:host([searchbox-chrome-refresh-theming][dropdown-is-visible]){--cr-searchbox-shadow:0 0 12px 4px var(--color-searchbox-shadow)}:host([searchbox-chrome-refresh-theming]:not([searchbox-steady-state-shadow]):not([dropdown-is-visible])){--cr-searchbox-shadow:none}:host-context([searchbox-width-behavior_='revert']):host([can-show-secondary-side]:not([dropdown-is-visible])){--cr-searchbox-width:var(--cr-searchbox-min-width)}:host([can-show-secondary-side][has-secondary-side]){--cr-searchbox-secondary-side-display:block}:host([is-dark]){--cr-searchbox-shadow:0 2px 6px 0 var(--color-searchbox-shadow)}:host([searchbox-voice-search-enabled_]){--cr-searchbox-voice-search-button-width:var(--cr-searchbox-icon-width)}:host([searchbox-lens-search-enabled_]){--cr-searchbox-voice-icon-offset:53px}@media (forced-colors:active){:host{border:1px solid ActiveBorder}}:host([dropdown-is-visible]:not([is-lens-searchbox_])){box-shadow:none}:host([match-searchbox]){box-shadow:none}:host([match-searchbox]:not([dropdown-is-visible]):hover){border:1px solid transparent;box-shadow:var(--cr-searchbox-shadow)}:host([match-searchbox]:not([is-dark]):not([dropdown-is-visible]):not(:hover)){border:1px solid var(--color-searchbox-border)}#inputWrapper{background-color:var(--color-searchbox-background);border-radius:var(--cr-searchbox-border-radius);box-shadow:var(--cr-searchbox-shadow);display:flex;flex-direction:column;height:auto;min-height:var(--cr-searchbox-height);overflow:hidden;position:relative;width:100%}:host([is-lens-searchbox_]) #inputWrapper{box-shadow:none}:host([multi-line-enabled]) textarea{background-color:transparent;box-sizing:border-box;field-sizing:content;line-height:24px;max-height:190px;overflow-y:auto;overflow-x:hidden;padding-top:calc((var(--cr-searchbox-height) - 24px) / 2);resize:none;scrollbar-width:none;white-space:pre-wrap}:host([multi-line-enabled]) #input::-webkit-scrollbar{display:none}:is(input,textarea){background-color:transparent;border:none;color:var(--color-searchbox-foreground);font-family:inherit;font-size:inherit;height:100%;outline:none;padding-top:20px;position:relative;width:100%}:host-context([searchbox-layout-mode='Compact']) :is(input,textarea){padding-inline-start:0}:host-context([multi-line-enabled][searchbox-layout-mode='Compact']) textarea{padding-bottom:10px;padding-top:16px}:host-context(:not([ntp-realbox-next-enabled])) input{align-self:center;padding-top:0}:host-context([searchbox-layout-mode='Compact']) input{padding-top:2px}:host([searchbox-chrome-refresh-theming]) :is(input,textarea)::selection{background-color:var(--color-searchbox-selection-background);color:var(--color-searchbox-selection-foreground)}input::-webkit-search-decoration,input::-webkit-search-results-button,input::-webkit-search-results-decoration{display:none}input::-webkit-search-cancel-button{appearance:none;margin:0}:is(input,textarea)::placeholder{color:var(--color-searchbox-placeholder);opacity:var(--placeholder-opacity);white-space:nowrap}:is(input,textarea):focus::placeholder{visibility:hidden}:host([is-lens-searchbox_]) :is(input,textarea):focus::placeholder{visibility:visible}:host([is-lens-searchbox_][dropdown-is-visible]) :is(input,textarea){background-color:var(--color-bubble-searchbox-results-input-background,--color-searchbox-results-background)}:host([is-lens-searchbox_]:not([dropdown-is-visible])) :is(input,textarea):focus{background-color:var(--color-searchbox-background)}cr-searchbox-icon{height:100%;padding-inline-end:4px;padding-inline-start:var(--cr-searchbox-icon-left-position);position:relative;top:var(--cr-searchbox-icon-top-position);pointer-events:none}:host(:not([ntp-realbox-next-enabled])) cr-searchbox-icon{align-self:center}@media (forced-colors:active){cr-searchbox-icon{background-color:Highlight;border-radius:4px}}:host-context([is-back-arrow-visible]) #icon{display:none}.searchbox-icon-button{background-color:transparent;background-position:center;background-repeat:no-repeat;background-size:21px 21px;border:none;border-radius:2px;cursor:pointer;height:100%;outline:none;padding:0;pointer-events:auto;position:static;right:16px;width:var(--cr-searchbox-icon-width)}.searchbox-icon-button-container{align-items:center;border-radius:50%;display:flex;flex-shrink:0;height:36px;justify-content:center;position:relative;width:36px;z-index:100}:host(:not([ntp-realbox-next-enabled])) .searchbox-icon-button-container{align-self:center}@media (forced-colors:active){.searchbox-icon-button-container{background-color:ButtonText}.searchbox-icon-button-container:focus-within{outline:2px solid Highlight;outline-offset:2px}}:host-context(.focus-outline-visible) .searchbox-icon-button-container:focus-within{box-shadow:0 0 0 2px var(--cr-focus-outline-color)}:host(:not([use-webkit-search-icons_])) #voiceSearchButton{background-image:url(//resources/cr_components/searchbox/icons/mic.svg)}:host(:not([use-webkit-search-icons_])) #lensSearchButton{background-image:url(//resources/cr_components/searchbox/icons/camera.svg)}:host([use-webkit-search-icons_]) #voiceSearchButton{-webkit-mask-image:url(//resources/cr_components/searchbox/icons/mic.svg)}:host([use-webkit-search-icons_]) #lensSearchButton{-webkit-mask-image:url(//resources/cr_components/searchbox/icons/camera.svg)}:host([use-webkit-search-icons_]) #voiceSearchButton,:host([use-webkit-search-icons_]) #lensSearchButton{-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:21px 21px;background-color:var(--color-searchbox-lens-voice-icon-background)}:host([use-webkit-search-icons_][compose-button-enabled]) #voiceSearchButton,:host([use-webkit-search-icons_][compose-button-enabled]) #lensSearchButton{background-color:#1F1F1F}:host([compose-button-enabled][searchbox-lens-search-enabled_]){--cr-searchbox-voice-icon-offset:calc(16px + 2 * var(--cr-searchbox-icon-spacing) + var(--cr-searchbox-icon-width) + var(--cr-compose-button-width))}:host([compose-button-enabled][dropdown-is-visible]) .searchbox-icon-button-container{display:none}:host([searchbox-layout-mode^='Tall']) contextual-entrypoint-and-carousel{z-index:100}:is(input,textarea),cr-searchbox-icon,.searchbox-icon-button{z-index:100}.truncate{overflow:hidden;text-overflow:ellipsis}#thumbnailContainer{align-self:center;padding-inline:10px;z-index:101}:host([ntp-realbox-next-enabled]) :is(input,textarea)::placeholder{font-size:18px;color:var(--cr-composebox-input-placeholder-color,var(--color-composebox-type-ahead));font-weight:400}:host([ntp-realbox-next-enabled]) :is(input,textarea):focus::placeholder{visibility:visible}:host([ntp-realbox-next-enabled]){--cr-searchbox-border-radius:26px;--cr-searchbox-dropdown-padding-bottom:12px;--cr-searchbox-icon-size:40px;--cr-searchbox-voice-lens-size:36px;--contextual-entrypoint-and-carousel-context-menu-container-padding-inline-start:0px;--text-input-inline-start-spacing:16px}cr-searchbox-dropdown::part(dropdown-content){background-color:unset;border-radius:unset;box-shadow:unset;gap:unset;margin-bottom:unset;overflow:unset;padding-top:unset}:host([ntp-realbox-next-enabled]) contextual-entrypoint-and-carousel::part(context-menu-entrypoint-icon){--cr-icon-button-icon-size:24px;--cr-icon-button-margin-start:2px;--cr-icon-button-size:36px}:host([ntp-realbox-next-enabled]:not([context-menu-glif-animation-state="ineligible"])) contextual-entrypoint-and-carousel::part(context-menu-entrypoint-icon){--cr-icon-button-margin-start:0px}:host([ntp-realbox-next-enabled][searchbox-layout-mode^='Tall']) contextual-entrypoint-and-carousel::part(context-menu-entrypoint-icon){--cr-icon-button-icon-size:20px}:host([ntp-realbox-next-enabled][searchbox-layout-mode='Compact']) contextual-entrypoint-and-carousel::part(context-menu-and-tools){padding-block:10px}:host([ntp-realbox-next-enabled]) contextual-entrypoint-and-carousel{position:relative}:host([ntp-realbox-next-enabled]) contextual-entrypoint-and-carousel::part(composebox-entrypoint){padding-inline-end:6px;z-index:100}:host-context([ntp-realbox-next-enabled][context-menu-glif-animation-state="ineligible"]) contextual-entrypoint-and-carousel::part(composebox-entrypoint){padding-inline-end:14px}:host([ntp-realbox-next-enabled]) contextual-entrypoint-and-carousel::part(tool-chips-container){--contextual-entrypoint-and-carousel-context-menu-container-margin-bottom:6px;position:relative;z-index:100}:host([ntp-realbox-next-enabled]) contextual-entrypoint-and-carousel::part(cr-composebox-file-carousel){margin-top:16px}:host([ntp-realbox-next-enabled]) .dropdownContainer,:host([ntp-realbox-next-enabled]) .contextualEntrypointContainer{overflow:visible}#inputContainer{background-color:var(--color-searchbox-background);border-radius:26px;box-shadow:var(--cr-searchbox-shadow);display:flex;flex-direction:column;width:100%}#inputInnerContainer{align-items:flex-start;display:flex;min-height:48px;position:relative;width:100%}:host([is-lens-searchbox_]) #inputInnerContainer{min-height:52px}:host([searchbox-layout-mode^='Tall']) #inputInnerContainer{padding-bottom:14px}#inputInnerBottomContainer{align-items:flex-start;display:flex;padding-bottom:10px;position:relative;width:100%}:host([ntp-realbox-next-enabled]) .contextualEntrypointContainer{left:unset;position:relative;right:unset;top:unset;width:100%}:host([ntp-realbox-next-enabled][dropdown-is-visible]),:host([ntp-realbox-next-enabled]:not([context-files-count_="0"])){box-shadow:none}:host([ntp-realbox-next-enabled]) #errorScrim{border-radius:23px}.searchbox-icon-button-container.lens{margin-inline-end:10px}.searchbox-icon-button-container.voice{margin-inline-end:4px}:host([ntp-realbox-next-enabled]) .searchbox-icon-button-container.lens:hover,:host([ntp-realbox-next-enabled]) .searchbox-icon-button-container.voice:hover{background-color:var(--color-new-tab-page-realbox-next-icon-hover);border-radius:50%}:host([searchbox-layout-mode^='Tall']){--cr-searchbox-compose-button-position-top:12px;--cr-searchbox-dropdown-padding-top:60px;--cr-searchbox-height:108px;--cr-searchbox-input-padding-top_:18px}@media (forced-colors:active){:host([searchbox-layout-mode^='Tall']) .dropdownContainer,:host([searchbox-layout-mode^='Tall']) .contextualEntrypointContainer{border:1px solid ActiveBorder}}:host([searchbox-layout-mode^='Tall']) input{height:44px;padding-top:14px}:host([multi-line-enabled][searchbox-layout-mode^='Tall']) textarea{height:auto;padding-top:var(--cr-searchbox-input-padding-top_)}:host([searchbox-layout-mode^='Tall']:not([dropdown-is-visible]):not([input-focused_])) :is(input,textarea){padding-inline-start:24px}:host([searchbox-layout-mode^='Tall']:not([dropdown-is-visible]):not([input-focused_])) cr-searchbox-icon,:host([searchbox-layout-mode^='Tall'][dropdown-is-visible]) .searchbox-icon-button-container{display:none}:host([searchbox-layout-mode^='Tall'][dropdown-is-visible]) cr-searchbox-icon,:host([searchbox-layout-mode^='Tall'][input-focused_]) cr-searchbox-icon{height:24px;top:var(--cr-searchbox-input-padding-top_)}:host-context([searchbox-layout-mode^='Tall']) #composeButton{--cr-button-height:36px}:host-context([searchbox-layout-mode='TallTopContext']) contextual-entrypoint-and-carousel::part(carousel-divider){margin-top:10px}:host([searchbox-layout-mode='Compact']){--cr-searchbox-border-radius:30px;--cr-searchbox-dropdown-padding-bottom:10px;--cr-searchbox-dropdown-padding-top:10px;--cr-searchbox-height:56px}:host([searchbox-layout-mode='Compact']) cr-searchbox-icon{display:none}:host([searchbox-layout-mode='Compact']) .searchbox-icon-button-container{top:10px}:host([searchbox-layout-mode='Compact'][compose-button-enabled] [searchbox-lens-search-enabled_]) .searchbox-icon-button-container.lens{inset-inline-end:calc(var(--cr-searchbox-icon-spacing) + var(--cr-compose-button-width))}:host([searchbox-layout-mode='Compact'][compose-button-enabled] [searchbox-lens-search-enabled_]) .searchbox-icon-button-container.voice{inset-inline-end:calc(var(--cr-searchbox-voice-lens-size) + var(--cr-searchbox-icon-spacing) + var(--cr-compose-button-width))}:host([ntp-realbox-next-enabled]) contextual-entrypoint-and-carousel::part(voice-icon){--cr-icon-button-fill-color:var(--color-composebox-font-light);--cr-icon-button-hover-background-color:var(--color-composebox-context-entrypoint-hover-background);--cr-icon-button-margin-end:0px;--cr-icon-button-margin-start:0px;--cr-icon-button-size:36px}:host([searchbox-layout-mode='TallBottomContext']) contextual-entrypoint-and-carousel::part(voice-icon){bottom:10px;inset-inline-end:14px;position:absolute}:host([searchbox-layout-mode='TallTopContext']) contextual-entrypoint-and-carousel::part(voice-icon){margin-inline-end:14px;margin-inline-start:auto;position:static}:host([searchbox-layout-mode='Compact']) contextual-entrypoint-and-carousel::part(voice-icon){margin-inline-end:calc(var(--cr-compose-button-width));margin-inline-start:auto;z-index:100}:host([searchbox-layout-mode="Compact"]){--search-animated-glow-drag-drop-placeholder-top:16px}:host([ntp-realbox-next-enabled][is-dragging-file]){--cr-searchbox-compose-button-z-index:99}:host([ntp-realbox-next-enabled][is-dragging-file]) :is(input,textarea),:host([ntp-realbox-next-enabled][is-dragging-file]) cr-searchbox-icon,:host([ntp-realbox-next-enabled][is-dragging-file]) .searchbox-icon-button-container,:host([ntp-realbox-next-enabled][is-dragging-file]) .searchbox-icon-button{opacity:0}#recentTabChipContainer{padding-bottom:10px;padding-inline:16px;padding-top:6px}:host([ntp-realbox-next-enabled][searchbox-layout-mode='Compact']) .contextualEntrypointContainerCompact{box-shadow:none;width:auto}`])}function getHtml$1(){const compactLayout=this.ntpRealboxNextEnabled&&this.searchboxLayoutMode==="Compact";const dropdown=html`
    <cr-searchbox-dropdown id="matches" part="searchbox-dropdown"
        class="${!this.ntpRealboxNextEnabled?"dropdownContainer":nothing}"
        exportparts="dropdown-content"
        role="listbox" .result="${this.result_}"
        selected-match-index="${this.selectedMatchIndex_}"
        @selected-match-index-changed="${this.onSelectedMatchIndexChanged_}"
        ?can-show-secondary-side="${this.canShowSecondarySide}"
        ?had-secondary-side="${this.hadSecondarySide}"
        @had-secondary-side-changed="${this.onHadSecondarySideChanged_}"
        ?has-secondary-side="${this.hasSecondarySide}"
        @has-secondary-side-changed="${this.onHasSecondarySideChanged_}"
        @match-focusin="${this.onMatchFocusin_}"
        @match-click="${this.onMatchClick_}"
        ?hidden="${!this.dropdownIsVisible}"
        ?show-thumbnail="${this.showThumbnail}">
    </cr-searchbox-dropdown>`;const contextualEntrypoint=html`
    <contextual-entrypoint-and-carousel id="context"
        part="contextual-entrypoint-and-carousel"
        exportparts="composebox-entrypoint, context-menu-entrypoint-icon, voice-icon, context-menu-and-tools"
        .tabSuggestions="${this.tabSuggestions_}"
        entrypoint-name="Realbox"
        @add-tab-context="${this.addTabContext_}"
        @add-file-context="${this.addFileContext_}"
        @on-file-validation-error="${this.onFileValidationError_}"
        @set-deep-search-mode="${this.setDeepSearchMode_}"
        @set-create-image-mode="${this.setCreateImageMode_}"
        @open-voice-search="${this.onVoiceSearchClick_}"
        @get-tab-preview="${this.getTabPreview_}"
        @context-menu-container-click="${this.onContextMenuContainerClick_}"
        ?show-dropdown="${this.dropdownIsVisible}"
        ?show-recent-tab-chip="${this.computeShowRecentTabChip_()}"
        ?show-voice-search="${this.shouldShowVoiceSearch_}"
        searchbox-layout-mode="${this.searchboxLayoutMode}"
        context-menu-glif-animation-state="${this.contextMenuGlifAnimationState}">
      ${!compactLayout?dropdown:nothing}
    </contextual-entrypoint-and-carousel>`;const inputContent=html`
  <cr-searchbox-icon id="icon" .match="${this.selectedMatch_}"
      default-icon="${this.searchboxIcon_}" in-searchbox>
  </cr-searchbox-icon>
  ${this.showThumbnail?html`
    <div id="thumbnailContainer">
      <cr-searchbox-thumbnail id="thumbnail" thumbnail-url_="${this.thumbnailUrl_}"
          ?is-deletable_="${this.isThumbnailDeletable_}"
          @remove-thumbnail-click="${this.onRemoveThumbnailClick_}"
          role="button" aria-label="${this.i18n("searchboxThumbnailLabel")}"
          tabindex="${this.getThumbnailTabindex_()}">
      </cr-searchbox-thumbnail>
    </div>
  `:nothing}
  ${this.multiLineEnabled?html`
    <textarea id="input" autocomplete="off"
        part="searchbox-input"
        spellcheck="false" aria-live="${this.inputAriaLive_}" role="combobox"
        aria-expanded="${this.dropdownIsVisible}" aria-controls="matches"
        aria-description="${this.searchboxAriaDescription}"
        placeholder="${this.computePlaceholderText_(this.placeholderText)}"
        @copy="${this.onInputCutCopy_}"
        @cut="${this.onInputCutCopy_}" @focus="${this.onInputFocus_}"
        @focusout="${this.onInputFocusout_}"
        @input="${this.onInputInput_}" @keydown="${this.onInputKeydown_}"
        @keyup="${this.onInputKeyup_}" @mousedown="${this.onInputMouseDown_}"
        @paste="${this.onInputPaste_}"></textarea>
  `:html`
    <input id="input" class="truncate" type="search" autocomplete="off"
        part="searchbox-input"
        spellcheck="false" aria-live="${this.inputAriaLive_}" role="combobox"
        aria-expanded="${this.dropdownIsVisible}" aria-controls="matches"
        aria-description="${this.searchboxAriaDescription}"
        placeholder="${this.computePlaceholderText_(this.placeholderText)}"
        @copy="${this.onInputCutCopy_}"
        @cut="${this.onInputCutCopy_}" @focus="${this.onInputFocus_}"
        @focusout="${this.onInputFocusout_}"
        @input="${this.onInputInput_}" @keydown="${this.onInputKeydown_}"
        @keyup="${this.onInputKeyup_}" @mousedown="${this.onInputMouseDown_}"
        @paste="${this.onInputPaste_}">
    </input>
  `}`;const voiceSearchButton=html`
    ${this.searchboxVoiceSearchEnabled_?html`
      <div class="searchbox-icon-button-container voice">
        <button id="voiceSearchButton" class="searchbox-icon-button"
            @click="${this.onVoiceSearchClick_}"
            title="${this.i18n("voiceSearchButtonLabel")}">
        </button>
      </div>
    `:nothing}`;const lensSearchButton=html`
    ${this.searchboxLensSearchEnabled_?html`
      <div class="searchbox-icon-button-container lens">
        <button id="lensSearchButton" class="searchbox-icon-button lens"
            @click="${this.onLensSearchClick_}"
            title="${this.i18n("lensSearchButtonLabel")}">
        </button>
      </div>
    `:nothing}`;const composeButton=html`
    ${this.composeButtonEnabled?html`
      <cr-searchbox-compose-button id="composeButton"
          @compose-click="${this.onComposeButtonClick_}">
      </cr-searchbox-compose-button>
    `:nothing}`;return html`<!--_html_template_start_-->
<div id="inputWrapper" @focusout="${this.onInputWrapperFocusout_}"
    @keydown="${this.onInputWrapperKeydown_}"
    @dragenter="${this.dragAndDropHandler?.handleDragEnter}"
    @dragover="${this.dragAndDropHandler?.handleDragOver}"
    @dragleave="${this.dragAndDropHandler?.handleDragLeave}"
    @drop="${this.dragAndDropHandler?.handleDrop}">
  ${this.ntpRealboxNextEnabled?html`
      <ntp-error-scrim id="errorScrim"
          ?compact-mode="${this.searchboxLayoutMode==="Compact"}">
      </ntp-error-scrim>
      <search-animated-glow animation-state="${this.animationState}" part="animated-glow">
      </search-animated-glow>
      ${compactLayout?html`
        <div id="inputInnerContainer">
          <div class="contextualEntrypointContainer contextualEntrypointContainerCompact">
            ${contextualEntrypoint}
          </div>
          ${inputContent}
          ${voiceSearchButton}
          ${lensSearchButton}
          ${composeButton}
        </div>
        <div class="dropdownContainer">
          ${dropdown}
          ${this.recentTabForChip_&&this.dropdownIsVisible&&this.isInputEmpty()?html`
          <div id="recentTabChipContainer">
            <composebox-recent-tab-chip
                .recentTab="${this.recentTabForChip_}"
                @add-tab-context="${this.addTabContext_}">
            </composebox-recent-tab-chip>
          </div>
          `:nothing}
        </div>
      `:html`
        <div id="inputInnerContainer">
          ${inputContent}
          ${composeButton}
        </div>
        <div id="inputInnerBottomContainer">
          <div class="contextualEntrypointContainer">
            ${contextualEntrypoint}
          </div>
          ${voiceSearchButton}
          ${lensSearchButton}
        </div>
      `}
    `:html`
      <div id="inputInnerContainer">
        ${inputContent}
        ${voiceSearchButton}
        ${lensSearchButton}
        ${composeButton}
      </div>
      ${dropdown}
    `}
</div>
<!--_html_template_end_-->`}const LENS_GHOST_LOADER_TAG_NAME="cr-searchbox-ghost-loader";const DESKTOP_CHROME_NTP_REALBOX_ENTRY_POINT_VALUE="42";const MULTILINE_INPUT_HEIGHT_THRESHOLD=50;CSS.registerProperty({name:"--placeholder-opacity",syntax:"<number>",initialValue:"1",inherits:true});var AnimationState;(function(AnimationState){AnimationState[AnimationState["FADE_IN"]=0]="FADE_IN";AnimationState[AnimationState["HOLD"]=1]="HOLD";AnimationState[AnimationState["FADE_OUT"]=2]="FADE_OUT"})(AnimationState||(AnimationState={}));class PlaceholderTextCycler{input_;animation_=null;placeholderTexts_=[];placeholderTextsCurrentIndex_=0;changePlaceholderTextIntervalMs_=4e3;fadePlaceholderTextDurationMs_=250;constructor(animatedPlaceholderContainer,placeholderTexts,changeTextAnimationIntervalMs,fadeTextAnimationDurationMs){assert(placeholderTexts.length>0);this.input_=animatedPlaceholderContainer;this.placeholderTexts_=placeholderTexts;this.changePlaceholderTextIntervalMs_=changeTextAnimationIntervalMs;this.fadePlaceholderTextDurationMs_=fadeTextAnimationDurationMs}start(){this.stop();this.placeholderTextsCurrentIndex_=0;this.animate_(AnimationState.HOLD)}stop(){if(this.animation_){this.animation_.cancel();this.animation_=null}this.placeholderTextsCurrentIndex_=0;this.input_.placeholder=this.placeholderTexts_[this.placeholderTextsCurrentIndex_]}animate_(state){let animationDetails=null;switch(state){case AnimationState.FADE_IN:this.input_.placeholder=this.placeholderTexts_[this.placeholderTextsCurrentIndex_];animationDetails={startOpacity:0,endOpacity:1,duration:this.fadePlaceholderTextDurationMs_,nextAnimationState:AnimationState.HOLD};break;case AnimationState.HOLD:animationDetails={startOpacity:1,endOpacity:1,duration:this.changePlaceholderTextIntervalMs_,nextAnimationState:AnimationState.FADE_OUT};break;case AnimationState.FADE_OUT:this.placeholderTextsCurrentIndex_=(this.placeholderTextsCurrentIndex_+1)%this.placeholderTexts_.length;animationDetails={startOpacity:1,endOpacity:0,duration:this.fadePlaceholderTextDurationMs_,nextAnimationState:AnimationState.FADE_IN};break}this.animation_=this.input_.animate([{"--placeholder-opacity":animationDetails.startOpacity},{"--placeholder-opacity":animationDetails.endOpacity}],{duration:animationDetails.duration});this.animation_.onfinish=()=>{if(this.animation_){this.animate_(animationDetails.nextAnimationState)}}}}const SearchboxElementBase=I18nMixinLit(WebUiListenerMixinLit(CrLitElement));class SearchboxElement extends SearchboxElementBase{static get is(){return"cr-searchbox"}static get styles(){return getCss$1()}render(){return getHtml$1.bind(this)()}static get properties(){return{canShowSecondarySide:{type:Boolean,reflect:true},colorSourceIsBaseline:{type:Boolean,reflect:true},dropdownIsVisible:{type:Boolean,reflect:true},hadSecondarySide:{type:Boolean,reflect:true,notify:true},hasSecondarySide:{type:Boolean,reflect:true},isDark:{type:Boolean,reflect:true},matchSearchbox:{type:Boolean,reflect:true},multiLineEnabled:{type:Boolean,reflect:true},searchboxAriaDescription:{type:String},searchboxLensSearchEnabled:{type:Boolean,reflect:true},searchboxChromeRefreshTheming:{type:Boolean,reflect:true},searchboxSteadyStateShadow:{type:Boolean,reflect:true},searchboxLayoutMode:{type:String,reflect:true},ntpRealboxNextEnabled:{type:Boolean,reflect:true},contextMenuGlifAnimationState:{type:String,reflect:true},cyclingPlaceholders:{type:Boolean},composeboxEnabled:{type:Boolean},composeButtonEnabled:{type:Boolean},placeholderText:{type:String,reflect:true,notify:true},inputFocused_:{type:Boolean,reflect:true},isLensSearchbox_:{type:Boolean,reflect:true},enableThumbnailSizingTweaks_:{type:Boolean,reflect:true},isDeletingInput_:{type:Boolean},lastIgnoredEnterEvent_:{type:Object},lastInput_:{type:Object},lastQueriedInput_:{type:String},pastedInInput_:{type:Boolean},searchboxIcon_:{type:String},searchboxVoiceSearchEnabled_:{type:Boolean,reflect:true},searchboxLensSearchEnabled_:{type:Boolean,reflect:true},result_:{type:Object},selectedMatch_:{type:Object},selectedMatchIndex_:{type:Number},showThumbnail:{type:Boolean,reflect:true},thumbnailUrl_:{type:String},isThumbnailDeletable_:{type:Boolean},inputAriaLive_:{type:String},useWebkitSearchIcons_:{type:Boolean,reflect:true},tabSuggestions_:{type:Array},recentTabForChip_:{type:Object},isDraggingFile:{reflect:true,type:Boolean},animationState:{reflect:true,type:String}}}#canShowSecondarySide_accessor_storage=false;get canShowSecondarySide(){return this.#canShowSecondarySide_accessor_storage}set canShowSecondarySide(value){this.#canShowSecondarySide_accessor_storage=value}#colorSourceIsBaseline_accessor_storage=false;get colorSourceIsBaseline(){return this.#colorSourceIsBaseline_accessor_storage}set colorSourceIsBaseline(value){this.#colorSourceIsBaseline_accessor_storage=value}#dropdownIsVisible_accessor_storage=false;get dropdownIsVisible(){return this.#dropdownIsVisible_accessor_storage}set dropdownIsVisible(value){this.#dropdownIsVisible_accessor_storage=value}#hadSecondarySide_accessor_storage=false;get hadSecondarySide(){return this.#hadSecondarySide_accessor_storage}set hadSecondarySide(value){this.#hadSecondarySide_accessor_storage=value}#hasSecondarySide_accessor_storage=false;get hasSecondarySide(){return this.#hasSecondarySide_accessor_storage}set hasSecondarySide(value){this.#hasSecondarySide_accessor_storage=value}#isDark_accessor_storage=false;get isDark(){return this.#isDark_accessor_storage}set isDark(value){this.#isDark_accessor_storage=value}#matchSearchbox_accessor_storage=loadTimeData.getBoolean("searchboxMatchSearchboxTheme");get matchSearchbox(){return this.#matchSearchbox_accessor_storage}set matchSearchbox(value){this.#matchSearchbox_accessor_storage=value}#multiLineEnabled_accessor_storage=false;get multiLineEnabled(){return this.#multiLineEnabled_accessor_storage}set multiLineEnabled(value){this.#multiLineEnabled_accessor_storage=value}#searchboxAriaDescription_accessor_storage="";get searchboxAriaDescription(){return this.#searchboxAriaDescription_accessor_storage}set searchboxAriaDescription(value){this.#searchboxAriaDescription_accessor_storage=value}#searchboxLensSearchEnabled_accessor_storage=loadTimeData.getBoolean("searchboxLensSearch");get searchboxLensSearchEnabled(){return this.#searchboxLensSearchEnabled_accessor_storage}set searchboxLensSearchEnabled(value){this.#searchboxLensSearchEnabled_accessor_storage=value}#searchboxChromeRefreshTheming_accessor_storage=loadTimeData.getBoolean("searchboxCr23Theming");get searchboxChromeRefreshTheming(){return this.#searchboxChromeRefreshTheming_accessor_storage}set searchboxChromeRefreshTheming(value){this.#searchboxChromeRefreshTheming_accessor_storage=value}#searchboxSteadyStateShadow_accessor_storage=loadTimeData.getBoolean("searchboxCr23SteadyStateShadow");get searchboxSteadyStateShadow(){return this.#searchboxSteadyStateShadow_accessor_storage}set searchboxSteadyStateShadow(value){this.#searchboxSteadyStateShadow_accessor_storage=value}#searchboxLayoutMode_accessor_storage="";get searchboxLayoutMode(){return this.#searchboxLayoutMode_accessor_storage}set searchboxLayoutMode(value){this.#searchboxLayoutMode_accessor_storage=value}#ntpRealboxNextEnabled_accessor_storage=false;get ntpRealboxNextEnabled(){return this.#ntpRealboxNextEnabled_accessor_storage}set ntpRealboxNextEnabled(value){this.#ntpRealboxNextEnabled_accessor_storage=value}#contextMenuGlifAnimationState_accessor_storage=GlifAnimationState.INELIGIBLE;get contextMenuGlifAnimationState(){return this.#contextMenuGlifAnimationState_accessor_storage}set contextMenuGlifAnimationState(value){this.#contextMenuGlifAnimationState_accessor_storage=value}#cyclingPlaceholders_accessor_storage=false;get cyclingPlaceholders(){return this.#cyclingPlaceholders_accessor_storage}set cyclingPlaceholders(value){this.#cyclingPlaceholders_accessor_storage=value}#composeboxEnabled_accessor_storage=false;get composeboxEnabled(){return this.#composeboxEnabled_accessor_storage}set composeboxEnabled(value){this.#composeboxEnabled_accessor_storage=value}#composeButtonEnabled_accessor_storage=false;get composeButtonEnabled(){return this.#composeButtonEnabled_accessor_storage}set composeButtonEnabled(value){this.#composeButtonEnabled_accessor_storage=value}#showThumbnail_accessor_storage=false;get showThumbnail(){return this.#showThumbnail_accessor_storage}set showThumbnail(value){this.#showThumbnail_accessor_storage=value}#placeholderText_accessor_storage="";get placeholderText(){return this.#placeholderText_accessor_storage}set placeholderText(value){this.#placeholderText_accessor_storage=value}#isDraggingFile_accessor_storage=false;get isDraggingFile(){return this.#isDraggingFile_accessor_storage}set isDraggingFile(value){this.#isDraggingFile_accessor_storage=value}#animationState_accessor_storage=GlowAnimationState.NONE;get animationState(){return this.#animationState_accessor_storage}set animationState(value){this.#animationState_accessor_storage=value}#inputAriaLive__accessor_storage="";get inputAriaLive_(){return this.#inputAriaLive__accessor_storage}set inputAriaLive_(value){this.#inputAriaLive__accessor_storage=value}#inputFocused__accessor_storage=false;get inputFocused_(){return this.#inputFocused__accessor_storage}set inputFocused_(value){this.#inputFocused__accessor_storage=value}#isLensSearchbox__accessor_storage=loadTimeData.getBoolean("isLensSearchbox");get isLensSearchbox_(){return this.#isLensSearchbox__accessor_storage}set isLensSearchbox_(value){this.#isLensSearchbox__accessor_storage=value}#enableThumbnailSizingTweaks__accessor_storage=loadTimeData.getBoolean("enableThumbnailSizingTweaks");get enableThumbnailSizingTweaks_(){return this.#enableThumbnailSizingTweaks__accessor_storage}set enableThumbnailSizingTweaks_(value){this.#enableThumbnailSizingTweaks__accessor_storage=value}#isDeletingInput__accessor_storage=false;get isDeletingInput_(){return this.#isDeletingInput__accessor_storage}set isDeletingInput_(value){this.#isDeletingInput__accessor_storage=value}#lastIgnoredEnterEvent__accessor_storage=null;get lastIgnoredEnterEvent_(){return this.#lastIgnoredEnterEvent__accessor_storage}set lastIgnoredEnterEvent_(value){this.#lastIgnoredEnterEvent__accessor_storage=value}#lastInput__accessor_storage={text:"",inline:""};get lastInput_(){return this.#lastInput__accessor_storage}set lastInput_(value){this.#lastInput__accessor_storage=value}#lastQueriedInput__accessor_storage=null;get lastQueriedInput_(){return this.#lastQueriedInput__accessor_storage}set lastQueriedInput_(value){this.#lastQueriedInput__accessor_storage=value}#pastedInInput__accessor_storage=false;get pastedInInput_(){return this.#pastedInInput__accessor_storage}set pastedInInput_(value){this.#pastedInInput__accessor_storage=value}#searchboxIcon__accessor_storage=loadTimeData.getString("searchboxDefaultIcon");get searchboxIcon_(){return this.#searchboxIcon__accessor_storage}set searchboxIcon_(value){this.#searchboxIcon__accessor_storage=value}#searchboxVoiceSearchEnabled__accessor_storage=loadTimeData.getBoolean("searchboxVoiceSearch");get searchboxVoiceSearchEnabled_(){return this.#searchboxVoiceSearchEnabled__accessor_storage}set searchboxVoiceSearchEnabled_(value){this.#searchboxVoiceSearchEnabled__accessor_storage=value}#searchboxLensSearchEnabled__accessor_storage=loadTimeData.getBoolean("searchboxLensSearch");get searchboxLensSearchEnabled_(){return this.#searchboxLensSearchEnabled__accessor_storage}set searchboxLensSearchEnabled_(value){this.#searchboxLensSearchEnabled__accessor_storage=value}#result__accessor_storage=null;get result_(){return this.#result__accessor_storage}set result_(value){this.#result__accessor_storage=value}#selectedMatch__accessor_storage=null;get selectedMatch_(){return this.#selectedMatch__accessor_storage}set selectedMatch_(value){this.#selectedMatch__accessor_storage=value}#selectedMatchIndex__accessor_storage=-1;get selectedMatchIndex_(){return this.#selectedMatchIndex__accessor_storage}set selectedMatchIndex_(value){this.#selectedMatchIndex__accessor_storage=value}#thumbnailUrl__accessor_storage="";get thumbnailUrl_(){return this.#thumbnailUrl__accessor_storage}set thumbnailUrl_(value){this.#thumbnailUrl__accessor_storage=value}#isThumbnailDeletable__accessor_storage=false;get isThumbnailDeletable_(){return this.#isThumbnailDeletable__accessor_storage}set isThumbnailDeletable_(value){this.#isThumbnailDeletable__accessor_storage=value}#useWebkitSearchIcons__accessor_storage=false;get useWebkitSearchIcons_(){return this.#useWebkitSearchIcons__accessor_storage}set useWebkitSearchIcons_(value){this.#useWebkitSearchIcons__accessor_storage=value}#tabSuggestions__accessor_storage=[];get tabSuggestions_(){return this.#tabSuggestions__accessor_storage}set tabSuggestions_(value){this.#tabSuggestions__accessor_storage=value}#recentTabForChip__accessor_storage=null;get recentTabForChip_(){return this.#recentTabForChip__accessor_storage}set recentTabForChip_(value){this.#recentTabForChip__accessor_storage=value}showVoiceSearchInExpandedRealbox=loadTimeData.getBoolean("expandedSearchboxShowVoiceSearch")??false;get shouldShowVoiceSearch_(){return this.dropdownIsVisible&&this.showVoiceSearchInExpandedRealbox}pageHandler_;callbackRouter_;dragAndDropHandler=null;dragAndDropEnabled_=loadTimeData.getBoolean("composeboxContextDragAndDropEnabled");autocompleteResultChangedListenerId_=null;inputTextChangedListenerId_=null;thumbnailChangedListenerId_=null;onTabStripChangedListenerId_=null;placeholderCycler_=null;constructor(){performance.mark("realbox-creation-start");super();this.pageHandler_=SearchboxBrowserProxy.getInstance().handler;this.callbackRouter_=SearchboxBrowserProxy.getInstance().callbackRouter}async connectedCallback(){super.connectedCallback();this.autocompleteResultChangedListenerId_=this.callbackRouter_.autocompleteResultChanged.addListener(this.onAutocompleteResultChanged_.bind(this));this.inputTextChangedListenerId_=this.callbackRouter_.setInputText.addListener(this.onSetInputText_.bind(this));this.thumbnailChangedListenerId_=this.callbackRouter_.setThumbnail.addListener(this.onSetThumbnail_.bind(this));this.onTabStripChangedListenerId_=this.callbackRouter_.onTabStripChanged.addListener(this.refreshTabSuggestions_.bind(this));if(this.cyclingPlaceholders){const{config:config}=await this.pageHandler_.getPlaceholderConfig();const texts=config.texts;assert(texts[0]);this.placeholderText=texts[0];this.placeholderCycler_=new PlaceholderTextCycler(this.$.input,texts,Number(config.changeTextAnimationInterval.microseconds/1000n),Number(config.fadeTextAnimationDuration.microseconds/1000n));this.placeholderCycler_.start()}if(this.ntpRealboxNextEnabled){this.dragAndDropHandler=new DragAndDropHandler(this,this.dragAndDropEnabled_);this.refreshTabSuggestions_()}}disconnectedCallback(){super.disconnectedCallback();assert(this.autocompleteResultChangedListenerId_);this.callbackRouter_.removeListener(this.autocompleteResultChangedListenerId_);assert(this.inputTextChangedListenerId_);this.callbackRouter_.removeListener(this.inputTextChangedListenerId_);assert(this.thumbnailChangedListenerId_);this.callbackRouter_.removeListener(this.thumbnailChangedListenerId_);assert(this.onTabStripChangedListenerId_);this.callbackRouter_.removeListener(this.onTabStripChangedListenerId_);this.placeholderCycler_?.stop()}firstUpdated(){performance.measure("realbox-creation","realbox-creation-start")}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("composeButtonEnabled")||changedProperties.has("searchboxChromeRefreshTheming")||changedProperties.has("colorSourceIsBaseline")){this.useWebkitSearchIcons_=this.composeButtonEnabled||this.searchboxChromeRefreshTheming&&!this.colorSourceIsBaseline}const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("result_")||changedPrivateProperties.has("selectedMatchIndex_")){this.selectedMatch_=this.computeSelectedMatch_()}if(changedPrivateProperties.has("selectedMatch_")){this.inputAriaLive_=this.computeInputAriaLive_()}if(changedPrivateProperties.has("thumbnailUrl_")){this.showThumbnail=!!this.thumbnailUrl_}if(this.ntpRealboxNextEnabled){if(changedPrivateProperties.has("inputFocused_")){this.fire("searchbox-input-focus-changed",{value:this.inputFocused_})}}if(changedPrivateProperties.has("tabSuggestions_")){this.recentTabForChip_=this.tabSuggestions_.find((tab=>tab.showInCurrentTabChip))||null;if(!this.recentTabForChip_){this.recentTabForChip_=this.tabSuggestions_.find((tab=>tab.showInPreviousTabChip))||null}}}computeInputAriaLive_(){return this.selectedMatch_?"off":"polite"}getSuggestionsElement(){return this.$.matches}getDropTarget(){return this.$.context}isInputEmpty(){return!this.$.input.value.trim()}queryAutocomplete(){if(this.dropdownIsVisible){return}this.queryAutocomplete_(this.$.input.value)}setInputText(text){this.onSetInputText_(text)}focusInput(){this.$.input.focus()}selectAll(){this.$.input.select()}async onAutocompleteResultChanged_(result){if(this.lastQueriedInput_===null||this.lastQueriedInput_.trimStart()!==result.input){return}this.result_=result;const hasMatches=result.matches?.length>0;const hasPrimaryMatches=result.matches?.some((match=>{const sideType=result.suggestionGroupsMap[match.suggestionGroupId]?.sideType||SideType.kDefaultPrimary;return sideType===SideType.kDefaultPrimary}));this.dropdownIsVisible=hasPrimaryMatches;if(this.multiLineEnabled){const isUserTyping=result.input.trim().length>0;const matchNum=result.matches?.length||0;if(isUserTyping&&matchNum<=1){this.dropdownIsVisible=false}}const firstMatch=hasMatches?this.result_.matches[0]:null;if(firstMatch&&firstMatch.allowedToBeDefaultMatch){this.$.matches.selectFirst();this.updateInput_({text:this.lastQueriedInput_,inline:firstMatch.inlineAutocompletion});if(this.lastIgnoredEnterEvent_){this.navigateToMatch_(0,this.lastIgnoredEnterEvent_);this.lastIgnoredEnterEvent_=null}}else if(this.$.input.value.trim()&&hasMatches&&this.selectedMatchIndex_>=0&&this.selectedMatchIndex_<this.result_.matches.length){await this.$.matches.selectIndex(this.selectedMatchIndex_);this.updateInput_({text:this.selectedMatch_.fillIntoEdit,inline:"",moveCursorToEnd:true})}else{this.$.matches.unselect();this.updateInput_({inline:""})}}onSetInputText_(inputText){this.updateInput_({text:inputText,inline:""})}onSetThumbnail_(thumbnailUrl,isDeletable){this.thumbnailUrl_=thumbnailUrl;this.isThumbnailDeletable_=isDeletable}onInputCutCopy_(e){if(!this.$.input.value||this.$.input.selectionStart!==0||this.$.input.selectionEnd!==this.$.input.value.length||!this.result_||this.result_.matches.length===0){return}if(this.selectedMatch_&&!this.selectedMatch_.isSearchType){e.clipboardData.setData("text/plain",this.selectedMatch_.destinationUrl.url);e.preventDefault();if(e.type==="cut"){this.updateInput_({text:"",inline:""});this.clearAutocompleteMatches_()}}}onInputFocus_(){this.inputFocused_=true;this.pageHandler_.onFocusChanged(true);this.placeholderCycler_?.stop()}onInputFocusout_(){this.inputFocused_=false}onInputInput_(e){const inputValue=this.$.input.value;const lastInputValue=this.lastInput_.text+this.lastInput_.inline;if(lastInputValue===inputValue){return}this.updateInput_({text:inputValue,inline:""});if(loadTimeData.getBoolean("reportMetrics")){const charTyped=!this.isDeletingInput_&&!!inputValue.trim();const metricsReporter=MetricsReporterImpl.getInstance();if(charTyped){if(!metricsReporter.hasLocalMark("CharTyped")){metricsReporter.mark("CharTyped")}}else{metricsReporter.clearMark("CharTyped")}}if(inputValue.trim()||this.isLensSearchbox_){this.queryAutocomplete_(inputValue,e.isComposing)}else{this.clearAutocompleteMatches_()}this.pastedInInput_=false}onInputKeydown_(e){if(!this.lastInput_.inline){return}const inputValue=this.$.input.value;const inputSelection=inputValue.substring(this.$.input.selectionStart,this.$.input.selectionEnd);const lastInputValue=this.lastInput_.text+this.lastInput_.inline;if(inputSelection===this.lastInput_.inline&&inputValue===lastInputValue&&this.lastInput_.inline[0].toLocaleLowerCase()===e.key.toLocaleLowerCase()){const text=this.lastInput_.text+e.key;assert(text);this.updateInput_({text:text,inline:this.lastInput_.inline.substr(1)});if(loadTimeData.getBoolean("reportMetrics")){const metricsReporter=MetricsReporterImpl.getInstance();if(!metricsReporter.hasLocalMark("CharTyped")){metricsReporter.mark("CharTyped")}}this.queryAutocomplete_(this.lastInput_.text);e.preventDefault()}}onInputKeyup_(e){if(e.key!=="Tab"||this.dropdownIsVisible){return}if(!this.$.input.value||this.showThumbnail){this.queryAutocomplete_(this.$.input.value)}}onInputMouseDown_(e){if(e&&e.button!==0){return}this.inputFocused_=true;if(this.dropdownIsVisible){return}this.queryAutocomplete_(this.$.input.value)}onInputPaste_(e){if(this.ntpRealboxNextEnabled&&e.clipboardData?.files&&e.clipboardData.files.length>0){const files=Array.from(e.clipboardData.files);if(files.length>0){e.preventDefault();const dataTransfer=new DataTransfer;files.forEach((file=>dataTransfer.items.add(file)));this.$.context.addPastedFiles(dataTransfer.files);return}}this.pastedInInput_=true}onInputWrapperFocusout_(e){const newlyFocusedEl=e.relatedTarget;if(this.$.inputWrapper.contains(newlyFocusedEl)){return}if(this.isLensSearchbox_&&newlyFocusedEl?.tagName.toLowerCase()===LENS_GHOST_LOADER_TAG_NAME){return}if(this.lastQueriedInput_===""){this.updateInput_({text:"",inline:""});this.clearAutocompleteMatches_()}else{this.dropdownIsVisible=false;this.pageHandler_.stopAutocomplete(false)}this.pageHandler_.onFocusChanged(false);this.placeholderCycler_?.start()}async onInputWrapperKeydown_(e){const KEYDOWN_HANDLED_KEYS=["ArrowDown","ArrowUp","Backspace","Delete","Enter","Escape","PageDown","PageUp","Tab"];if(!KEYDOWN_HANDLED_KEYS.includes(e.key)){return}if(e.defaultPrevented){return}if(this.showThumbnail){const thumbnail=this.shadowRoot.querySelector("cr-searchbox-thumbnail");if(thumbnail===this.shadowRoot.activeElement){if(e.key==="Backspace"||e.key==="Enter"){this.thumbnailUrl_="";this.$.input.focus();this.clearAutocompleteMatches_();this.pageHandler_.onThumbnailRemoved();const inputValue=this.$.input.value;this.queryAutocomplete_(inputValue);e.preventDefault()}else if(e.key==="Tab"&&!e.shiftKey){this.$.input.focus();e.preventDefault()}else if(this.dropdownIsVisible&&(e.key==="ArrowUp"||e.key==="ArrowDown")){this.$.input.focus()}}else if(this.isThumbnailDeletable_&&this.$.input.selectionStart===0&&this.$.input.selectionEnd===0&&this.$.input===this.shadowRoot.activeElement&&(e.key==="Backspace"||e.key==="Tab"&&e.shiftKey)){thumbnail?.focus();e.preventDefault()}}if(this.composeButtonEnabled&&e.key==="Tab"&&this.lastInput_.inline&&this.$.input===this.shadowRoot.activeElement){if(e.shiftKey){this.updateInput_({inline:""});return}const newText=this.lastInput_.text+this.lastInput_.inline;this.updateInput_({text:newText,inline:"",moveCursorToEnd:true});this.queryAutocomplete_(newText);e.preventDefault();return}if(e.key==="Backspace"||e.key==="Tab"){return}const matchNum=this.result_?.matches.length||0;const isMultiline=this.$.input.scrollHeight>MULTILINE_INPUT_HEIGHT_THRESHOLD;if(!this.dropdownIsVisible){if(e.key==="ArrowUp"||e.key==="ArrowDown"){if(isMultiline||matchNum<=1){return}const inputValue=this.$.input.value;if(inputValue.trim()||!inputValue){this.queryAutocomplete_(inputValue)}e.preventDefault();return}}if(e.key==="Escape"){this.dispatchEvent(new CustomEvent("escape-searchbox",{bubbles:true,composed:true,detail:{event:e,emptyInput:!this.$.input.value}}))}if(!this.result_||this.result_.matches.length===0){return}if(e.key==="Delete"){if(e.shiftKey&&!e.altKey&&!e.ctrlKey&&!e.metaKey){if(this.selectedMatch_&&this.selectedMatch_.supportsDeletion){this.pageHandler_.deleteAutocompleteMatch(this.selectedMatchIndex_,this.selectedMatch_.destinationUrl);e.preventDefault()}}return}if(e.isComposing){return}if(e.key==="Enter"){if(this.multiLineEnabled&&e.shiftKey){return}const array=[this.$.matches,this.$.input];if(array.includes(e.target)){if(this.lastQueriedInput_!==null&&this.lastQueriedInput_.trimStart()===this.result_.input){if(this.selectedMatch_){this.navigateToMatch_(this.selectedMatchIndex_,e)}}else{this.lastIgnoredEnterEvent_=e;e.preventDefault()}}return}if(hasKeyModifiers(e)){return}if(e.key==="Escape"&&this.selectedMatchIndex_<=0){this.updateInput_({text:"",inline:""});this.clearAutocompleteMatches_();e.preventDefault();return}e.preventDefault();if(e.key==="ArrowDown"){await this.$.matches.selectNext();this.pageHandler_.onNavigationLikely(this.selectedMatchIndex_,this.selectedMatch_.destinationUrl,NavigationPredictor.kUpOrDownArrowButton)}else if(e.key==="ArrowUp"){await this.$.matches.selectPrevious();this.pageHandler_.onNavigationLikely(this.selectedMatchIndex_,this.selectedMatch_.destinationUrl,NavigationPredictor.kUpOrDownArrowButton)}else if(e.key==="Escape"||e.key==="PageUp"){await this.$.matches.selectFirst()}else if(e.key==="PageDown"){await this.$.matches.selectLast()}if(this.shadowRoot.activeElement===this.$.matches){this.$.matches.focusSelected()}const newFill=this.selectedMatch_.fillIntoEdit;const newInline=this.selectedMatchIndex_===0&&this.selectedMatch_.allowedToBeDefaultMatch?this.selectedMatch_.inlineAutocompletion:"";const newFillEnd=newFill.length-newInline.length;const text=newFill.substr(0,newFillEnd);assert(text);this.updateInput_({text:text,inline:newInline,moveCursorToEnd:newInline.length===0})}async onMatchFocusin_(e){await this.$.matches.selectIndex(e.detail);this.updateInput_({text:this.selectedMatch_.fillIntoEdit,inline:"",moveCursorToEnd:true})}onMatchClick_(){this.clearAutocompleteMatches_()}onVoiceSearchClick_(){this.dispatchEvent(new Event("open-voice-search"))}onLensSearchClick_(){this.dropdownIsVisible=false;this.dispatchEvent(new Event("open-lens-search"))}addFileContext_(e){const uploads=[];for(const file of e.detail.files){const attachment={file:file};uploads.push(attachment)}this.openComposebox_(uploads)}addTabContext_(e){const attachment={tabId:e.detail.id,url:e.detail.url,title:e.detail.title,delayUpload:e.detail.delayUpload,origin:e.detail.origin};this.openComposebox_([attachment])}async refreshTabSuggestions_(){const{tabs:tabs}=await this.pageHandler_.getRecentTabs();this.tabSuggestions_=[...tabs]}onFileValidationError_(e){this.$.errorScrim.setErrorMessage(e.detail.errorMessage)}async getTabPreview_(e){const{previewDataUrl:previewDataUrl}=await this.pageHandler_.getTabPreview(e.detail.tabId);e.detail.onPreviewFetched(previewDataUrl||"")}onContextMenuContainerClick_(){if(this.inputFocused_||this.searchboxLayoutMode==="Compact"){return}this.focusInput();this.onInputMouseDown_(null)}onComposeButtonClick_(e){if(!this.composeboxEnabled||this.$.input.value.trim()){const searchParams=new URLSearchParams;searchParams.append("sourceid","chrome");searchParams.append("udm","50");searchParams.append("aep",DESKTOP_CHROME_NTP_REALBOX_ENTRY_POINT_VALUE);if(this.$.input.value.trim()){searchParams.append("q",this.$.input.value.trim())}const queryUrl=new URL("/search",loadTimeData.getString("googleBaseUrl"));queryUrl.search=searchParams.toString();const href=queryUrl.href;if(e.detail.ctrlKey||e.detail.metaKey){window.open(href,"_blank")}else if(e.detail.shiftKey){window.open(href,"_blank","noopener")}else{window.open(href,"_self")}}else{this.openComposebox_()}chrome.metricsPrivate.recordBoolean("NewTabPage.ComposeEntrypoint.Click.UserTextPresent",!this.isInputEmpty())}setDeepSearchMode_(){this.openComposebox_([],ComposeboxMode.DEEP_SEARCH)}setCreateImageMode_(){this.openComposebox_([],ComposeboxMode.CREATE_IMAGE)}openComposebox_(uploads=[],mode=ComposeboxMode.DEFAULT){this.dispatchEvent(new CustomEvent("open-composebox",{detail:{searchboxText:this.$.input.value,contextFiles:uploads,mode:mode},bubbles:true,composed:true}));this.setInputText("")}hasThumbnail(){return!!this.thumbnailUrl_}onRemoveThumbnailClick_(){this.thumbnailUrl_="";this.$.input.focus();this.clearAutocompleteMatches_();this.pageHandler_.onThumbnailRemoved();const inputValue=this.$.input.value;this.queryAutocomplete_(inputValue)}computeSelectedMatch_(){if(!this.result_||!this.result_.matches){return null}return this.result_.matches[this.selectedMatchIndex_]||null}computeShowRecentTabChip_(){return loadTimeData.valueExists("composeboxShowRecentTabChip")&&loadTimeData.getBoolean("composeboxShowRecentTabChip")&&this.result_?.input.length===0}computePlaceholderText_(placeholderText){if(placeholderText){return placeholderText}return this.showThumbnail?this.i18n("searchBoxHintMultimodal"):this.i18n("searchBoxHint")}clearAutocompleteMatches_(){this.dropdownIsVisible=false;this.result_=null;this.$.matches.unselect();this.pageHandler_.stopAutocomplete(true);this.lastQueriedInput_=null}navigateToMatch_(matchIndex,e){assert(matchIndex>=0);const match=this.result_.matches[matchIndex];assert(match);this.pageHandler_.openAutocompleteMatch(matchIndex,match.destinationUrl,this.dropdownIsVisible,e.button||0,e.altKey,e.ctrlKey,e.metaKey,e.shiftKey);this.updateInput_({text:match.fillIntoEdit,inline:"",moveCursorToEnd:true});this.clearAutocompleteMatches_();e.preventDefault()}queryAutocomplete_(input,preventInlineAutocomplete=false){this.lastQueriedInput_=input;const caretNotAtEnd=this.$.input.selectionStart!==input.length;preventInlineAutocomplete=preventInlineAutocomplete||this.isDeletingInput_||this.pastedInInput_||caretNotAtEnd;this.pageHandler_.queryAutocomplete(input,preventInlineAutocomplete);this.dispatchEvent(new CustomEvent("query-autocomplete",{bubbles:true,composed:true,detail:{inputValue:input}}))}updateInput_(update){const newInput=Object.assign({},this.lastInput_,update);const newInputValue=newInput.text+newInput.inline;const lastInputValue=this.lastInput_.text+this.lastInput_.inline;const inlineDiffers=newInput.inline!==this.lastInput_.inline;const preserveSelection=!inlineDiffers&&!update.moveCursorToEnd;let needsSelectionUpdate=!preserveSelection;const oldSelectionStart=this.$.input.selectionStart;const oldSelectionEnd=this.$.input.selectionEnd;if(newInputValue!==this.$.input.value){this.$.input.value=newInputValue;needsSelectionUpdate=true}if(newInputValue.trim()&&needsSelectionUpdate){this.$.input.selectionStart=preserveSelection?oldSelectionStart:update.moveCursorToEnd?newInputValue.length:newInput.text.length;this.$.input.selectionEnd=preserveSelection?oldSelectionEnd:newInputValue.length}this.isDeletingInput_=lastInputValue.length>newInputValue.length&&lastInputValue.startsWith(newInputValue);this.lastInput_=newInput}getThumbnailTabindex_(){return this.isThumbnailDeletable_?"1":""}onSelectedMatchIndexChanged_(e){this.selectedMatchIndex_=e.detail.value}onHadSecondarySideChanged_(e){this.hadSecondarySide=e.detail.value}onHasSecondarySideChanged_(e){this.hasSecondarySide=e.detail.value}}customElements.define(SearchboxElement.is,SearchboxElement);let instance=null;function getCss(){return instance||(instance=[...[],css`cr-searchbox{--cr-searchbox-height:36px;--cr-searchbox-icon-left-position:12px;--cr-searchbox-icon-top-position:0;display:block}:host([omnibox-popup-debug-enabled_]) cr-searchbox::part(searchbox-input){background-color:lightgreen}cr-searchbox::part(dropdown-content){border-radius:0}`])}function getHtml(){return html`<!--_html_template_start_-->
<cr-searchbox></cr-searchbox>
<!--_html_template_end_-->`}class OmniboxFullAppElement extends CrLitElement{static get is(){return"omnibox-full-app"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{omniboxPopupDebugEnabled_:{type:Boolean,reflect:true}}}#omniboxPopupDebugEnabled__accessor_storage=loadTimeData.getBoolean("omniboxPopupDebugEnabled");get omniboxPopupDebugEnabled_(){return this.#omniboxPopupDebugEnabled__accessor_storage}set omniboxPopupDebugEnabled_(value){this.#omniboxPopupDebugEnabled__accessor_storage=value}isDebug_=new URLSearchParams(window.location.search).has("debug");eventTracker_=new EventTracker;connectedCallback(){super.connectedCallback();this.eventTracker_.add(document.documentElement,"visibilitychange",this.onVisibilitychange_.bind(this));this.onVisibilitychange_();if(!this.isDebug_){this.eventTracker_.add(document.documentElement,"contextmenu",(e=>{e.preventDefault()}))}}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}onVisibilitychange_(){if(document.visibilityState!=="visible"){return}const searchbox=this.shadowRoot.querySelector("cr-searchbox");assert(searchbox);searchbox.focusInput()}}customElements.define(OmniboxFullAppElement.is,OmniboxFullAppElement);export{BrowserProxy,OmniboxAimAppElement,OmniboxPopupAppElement,PageCallbackRouter,PageHandlerRemote,PageRemote,SearchboxBrowserProxy,createAutocompleteMatch};