// chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { ColorSpec as tabGroups_mojom_ColorSpec } from './tab_group_types.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ntp.tab_groups.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createNewTabGroup() {
        this.proxy.sendMessage(0, PageHandler_CreateNewTabGroup_ParamsSpec.$, null, [], false);
    }
    getTabGroups() {
        return this.proxy.sendMessage(1, PageHandler_GetTabGroups_ParamsSpec.$, PageHandler_GetTabGroups_ResponseParamsSpec.$, [], false);
    }
    openTabGroup(id) {
        this.proxy.sendMessage(2, PageHandler_OpenTabGroup_ParamsSpec.$, null, [
            id
        ], false);
    }
    dismissModule() {
        this.proxy.sendMessage(3, PageHandler_DismissModule_ParamsSpec.$, null, [], false);
    }
    restoreModule() {
        this.proxy.sendMessage(4, PageHandler_RestoreModule_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_CreateNewTabGroup_ParamsSpec.$, null, impl.createNewTabGroup.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_GetTabGroups_ParamsSpec.$, PageHandler_GetTabGroups_ResponseParamsSpec.$, impl.getTabGroups.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_OpenTabGroup_ParamsSpec.$, null, impl.openTabGroup.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_DismissModule_ParamsSpec.$, null, impl.dismissModule.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_RestoreModule_ParamsSpec.$, null, impl.restoreModule.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "ntp.tab_groups.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    createNewTabGroup;
    getTabGroups;
    openTabGroup;
    dismissModule;
    restoreModule;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createNewTabGroup =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_CreateNewTabGroup_ParamsSpec.$, null, this.createNewTabGroup.createReceiverHandler(false /* expectsResponse */), false);
        this.getTabGroups =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_GetTabGroups_ParamsSpec.$, PageHandler_GetTabGroups_ResponseParamsSpec.$, this.getTabGroups.createReceiverHandler(true /* expectsResponse */), false);
        this.openTabGroup =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_OpenTabGroup_ParamsSpec.$, null, this.openTabGroup.createReceiverHandler(false /* expectsResponse */), false);
        this.dismissModule =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_DismissModule_ParamsSpec.$, null, this.dismissModule.createReceiverHandler(false /* expectsResponse */), false);
        this.restoreModule =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_RestoreModule_ParamsSpec.$, null, this.restoreModule.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const TabGroupSpec = { $: {} };
export const PageHandler_CreateNewTabGroup_ParamsSpec = { $: {} };
export const PageHandler_GetTabGroups_ParamsSpec = { $: {} };
export const PageHandler_GetTabGroups_ResponseParamsSpec = { $: {} };
export const PageHandler_OpenTabGroup_ParamsSpec = { $: {} };
export const PageHandler_DismissModule_ParamsSpec = { $: {} };
export const PageHandler_RestoreModule_ParamsSpec = { $: {} };
mojo.internal.Struct(TabGroupSpec.$, 'TabGroup', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('updateTime', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceName', 24, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('totalTabCount', 32, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('color', 36, 0, tabGroups_mojom_ColorSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('faviconUrls', 40, 0, mojo.internal.Array(url_mojom_UrlSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isSharedTabGroup', 48, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 64],]);
mojo.internal.Struct(PageHandler_CreateNewTabGroup_ParamsSpec.$, 'PageHandler_CreateNewTabGroup_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetTabGroups_ParamsSpec.$, 'PageHandler_GetTabGroups_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetTabGroups_ResponseParamsSpec.$, 'PageHandler_GetTabGroups_ResponseParams', [
    mojo.internal.StructField('tabGroups', 0, 0, mojo.internal.Array(TabGroupSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('showZeroState', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_OpenTabGroup_ParamsSpec.$, 'PageHandler_OpenTabGroup_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_DismissModule_ParamsSpec.$, 'PageHandler_DismissModule_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_RestoreModule_ParamsSpec.$, 'PageHandler_RestoreModule_Params', [], [[0, 8],]);
