// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import './setup_list.js';
import { EventTracker } from 'chrome://resources/js/event_tracker.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { getCss } from './setup_list_module_wrapper.css.js';
import { getHtml } from './setup_list_module_wrapper.html.js';
/** Faux module container for the NTP Setup List. */
export class SetupListModuleWrapperElement extends CrLitElement {
    static get is() {
        return 'setup-list-module-wrapper';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            moduleHidden_: { type: Boolean },
            moduleReady_: { type: Boolean },
            /** Data about the most recent un-doable action. */
            undoData_: { type: Object },
            maxPromos: { type: Number, attribute: true, useDefault: true },
            maxCompletedPromos: { type: Number, attribute: true, useDefault: true },
        };
    }
    #maxPromos_accessor_storage = 0;
    get maxPromos() { return this.#maxPromos_accessor_storage; }
    set maxPromos(value) { this.#maxPromos_accessor_storage = value; }
    #maxCompletedPromos_accessor_storage = 0;
    get maxCompletedPromos() { return this.#maxCompletedPromos_accessor_storage; }
    set maxCompletedPromos(value) { this.#maxCompletedPromos_accessor_storage = value; }
    #moduleHidden__accessor_storage = false;
    get moduleHidden_() { return this.#moduleHidden__accessor_storage; }
    set moduleHidden_(value) { this.#moduleHidden__accessor_storage = value; }
    #moduleReady__accessor_storage = false;
    get moduleReady_() { return this.#moduleReady__accessor_storage; }
    set moduleReady_(value) { this.#moduleReady__accessor_storage = value; }
    #undoData__accessor_storage = null;
    get undoData_() { return this.#undoData__accessor_storage; }
    set undoData_(value) { this.#undoData__accessor_storage = value; }
    eventTracker_ = new EventTracker();
    connectedCallback() {
        super.connectedCallback();
        this.eventTracker_.add(window, 'keydown', this.onWindowKeydown_.bind(this));
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.eventTracker_.removeAll();
    }
    onHideModule_(e) {
        this.moduleHidden_ = true;
        const restoreCallback = e.detail.restoreCallback;
        this.undoData_ = {
            message: e.detail.message,
            undo: () => {
                this.moduleHidden_ = false;
                if (restoreCallback) {
                    restoreCallback();
                }
            },
        };
        this.$.undoToast.show();
    }
    onModuleReady_(e) {
        this.moduleReady_ = e.detail;
    }
    isModuleHidden_() {
        return !this.moduleReady_ || this.moduleHidden_;
    }
    onUndoButtonClick_() {
        if (!this.undoData_) {
            return;
        }
        // Restore to the previous state.
        this.undoData_.undo();
        // Notify the user.
        this.$.undoToast.hide();
        this.undoData_ = null;
    }
    onWindowKeydown_(e) {
        let ctrlKeyPressed = e.ctrlKey;
        // 
        ctrlKeyPressed = ctrlKeyPressed || e.metaKey;
        // 
        if (ctrlKeyPressed && e.key === 'z') {
            this.onUndoButtonClick_();
        }
    }
}
customElements.define(SetupListModuleWrapperElement.is, SetupListModuleWrapperElement);
