import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import './setup_list.js';
import type { CrToastElement } from 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { SetupListElement } from './setup_list.js';
export type UndoActionEvent = CustomEvent<{
    message: string;
    restoreCallback?: () => void;
}>;
export type ReadyEvent = CustomEvent<boolean>;
declare global {
    interface HTMLElementEventMap {
        'disable-module': UndoActionEvent;
        'dismiss-module-instance': UndoActionEvent;
        'module-ready': ReadyEvent;
    }
}
export interface SetupListModuleWrapperElement {
    $: {
        container: HTMLElement;
        moduleElement: HTMLElement;
        setupList: SetupListElement;
        undoToast: CrToastElement;
        undoToastMessage: HTMLElement;
    };
}
/** Faux module container for the NTP Setup List. */
export declare class SetupListModuleWrapperElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        moduleHidden_: {
            type: BooleanConstructor;
        };
        moduleReady_: {
            type: BooleanConstructor;
        };
        /** Data about the most recent un-doable action. */
        undoData_: {
            type: ObjectConstructor;
        };
        maxPromos: {
            type: NumberConstructor;
            attribute: boolean;
            useDefault: boolean;
        };
        maxCompletedPromos: {
            type: NumberConstructor;
            attribute: boolean;
            useDefault: boolean;
        };
    };
    accessor maxPromos: number;
    accessor maxCompletedPromos: number;
    protected accessor moduleHidden_: boolean;
    protected accessor moduleReady_: boolean;
    protected accessor undoData_: {
        message: string;
        undo?: () => void;
    } | null;
    private eventTracker_;
    connectedCallback(): void;
    disconnectedCallback(): void;
    protected onHideModule_(e: UndoActionEvent): void;
    protected onModuleReady_(e: CustomEvent): void;
    protected isModuleHidden_(): boolean;
    protected onUndoButtonClick_(): void;
    private onWindowKeydown_;
}
declare global {
    interface HTMLElementTagNameMap {
        'setup-list-module-wrapper': SetupListModuleWrapperElement;
    }
}
