import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import './ntp_promo_icons.html.js';
import './setup_list_item.js';
import '../modules/icons.html.js';
import '../modules/info_dialog.js';
import '../modules/module_header.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { ModuleHeaderElement } from '../modules/module_header.js';
import type { Promo } from '../ntp_promo.mojom-webui.js';
export interface SetupListElement {
    $: {
        moduleHeaderElementV2: ModuleHeaderElement;
        promos: HTMLElement;
    };
}
declare const SetupListElement_base: typeof CrLitElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin_lit.js").I18nMixinLitInterface);
export declare class SetupListElement extends SetupListElement_base {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        maxPromos: {
            type: NumberConstructor;
            attribute: boolean;
            useDefault: boolean;
        };
        maxCompletedPromos: {
            type: NumberConstructor;
            attribute: boolean;
            useDefault: boolean;
        };
        completedPromos_: {
            type: ArrayConstructor;
        };
        eligiblePromos_: {
            type: ArrayConstructor;
        };
        showInfoDialog_: {
            type: BooleanConstructor;
        };
        allowFaviconServerFallback_: {
            type: BooleanConstructor;
        };
    };
    accessor maxPromos: number;
    accessor maxCompletedPromos: number;
    protected accessor completedPromos_: Promo[];
    protected accessor eligiblePromos_: Promo[];
    protected accessor showInfoDialog_: boolean;
    private handler_;
    private callbackRouter_;
    private listenerIds_;
    private notifiedShown_;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    onSetPromos(eligible: Promo[], completed: Promo[]): void;
    protected onPromoClick_(e: CustomEvent): void;
    protected onDisableButtonClick_(): void;
    protected onDismissButtonClick_(): void;
    protected onInfoButtonClick_(): void;
    protected onInfoDialogClose_(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'setup-list': SetupListElement;
    }
}
export {};
