import { html } from '//resources/lit/v3_0/lit.rollup.js';
export function getHtml() {
    return html `<!--_html_template_start_--><div id="container">
  ${this.moduleInstances_.map(item => html `
    <ntp-module-wrapper .module="${item}"
        ?hidden="${this.moduleDisabled_(item)}"
        @disable-module="${this.onDisableModule_}"
        @dismiss-module-element="${this.onDismissModuleElement_}"
        @dismiss-module-instance="${this.onDismissModuleInstance_}">
    </ntp-module-wrapper>
  `)}
</div>
<cr-toast id="undoToast" duration="10000">
  <div id="undoToastMessage">${this.undoData_?.message || ''}</div>
  ${this.undoData_?.undo ? html `
    <cr-button id="undoButton"
        aria-label="$i18n{undoDescription}"
        @click="${this.onUndoButtonClick_}">
      $i18n{undo}
    </cr-button>
  ` : ''}
</cr-toast>
<!--_html_template_end_-->`;
}
