import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { File } from '../../file_suggestion.mojom-webui.js';
export interface FileSuggestionElement {
    $: {
        files: HTMLElement;
    };
}
/**
 * Shared component for file modules, which serve as an inside look to recent
 * activity within a user's Google Drive or Microsoft Sharepoint.
 */
export declare class FileSuggestionElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        files: {
            type: ArrayConstructor;
        };
        moduleName: {
            type: StringConstructor;
        };
    };
    accessor files: File[];
    accessor moduleName: string;
    protected onFileClick_(e: Event): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'ntp-file-suggestion': FileSuggestionElement;
    }
}
