import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import type { CrToastElement } from 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { Promo } from './new_tab_page.mojom-webui.js';
/**
 * List of possible Promo Dismiss actions. This enum must match with the
 * numbering for NtpPromoDismissAction in histogram/enums.xml. These values are
 * persisted to logs. Entries should not be renumbered, removed or reused.
 */
export declare enum PromoDismissAction {
    DISMISS = 0,
    RESTORE = 1,
    MAX_VALUE = 1
}
export declare function recordPromoDismissAction(action: PromoDismissAction): void;
/**
 * If a promo exists with content and can be shown, an element containing
 * the rendered promo is returned with an id #promoContainer. Otherwise, null is
 * returned.
 */
export declare function renderPromo(promo: Promo): Promise<{
    container: Element;
    id: string | null;
} | null>;
export interface MiddleSlotPromoElement {
    $: {
        promoAndDismissContainer: HTMLElement;
        dismissPromoButtonToast: CrToastElement;
        dismissPromoButtonToastMessage: HTMLElement;
        undoDismissPromoButton: HTMLElement;
    };
}
export declare class MiddleSlotPromoElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        shownMiddleSlotPromoId_: {
            type: StringConstructor;
            reflect: boolean;
        };
        promo_: {
            type: ObjectConstructor;
        };
    };
    protected accessor shownMiddleSlotPromoId_: string;
    private accessor promo_;
    private blocklistedMiddleSlotPromoId_;
    private eventTracker_;
    private pageHandler_;
    private setPromoListenerId_;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    updated(changedProperties: PropertyValues<this>): void;
    private hidePromoContainer_;
    private onPromoChange_;
    private onWindowKeydown_;
    protected onDismissPromoButtonClick_(): void;
    protected onUndoDismissPromoButtonClick_(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'ntp-middle-slot-promo': MiddleSlotPromoElement;
    }
}
