import { html } from '//resources/lit/v3_0/lit.rollup.js';
import { nothing } from '//resources/lit/v3_0/lit.rollup.js';
export function getHtml() {
    return html `<!--_html_template_start_--><!-- #html_wrapper_imports_start
import {nothing} from '//resources/lit/v3_0/lit.rollup.js';
#html_wrapper_imports_end -->
<div id="content">
  ${this.lazyRender_ && this.microsoftModuleEnabled_ ? html `
    <iframe id="microsoftAuth" src="${this.microsoftAuthIframePath_}"></iframe>
  ` : ''}
  ${this.lazyRender_ && this.oneGoogleBarEnabled_ ?
        (this.ntpRealboxNextEnabled_ ?
            html `
        <div id="oneGoogleBarStackingContext">
          <div id="oneGoogleBarScrim" ?hidden="${!this.showBackgroundImage_}"
              ?fixed="${this.scrolledToTop_}"></div>
          <ntp-iframe id="oneGoogleBar" src="${this.oneGoogleBarIframePath_}"
              ?hidden="${!this.oneGoogleBarLoaded_}"
              allow="camera ${this.oneGoogleBarIframeOrigin_}; display-capture ${this.oneGoogleBarIframeOrigin_}"> <!-- presubmit: ignore-long-line -->
          </ntp-iframe>
        </div>
        ` :
            html `
        <div id="oneGoogleBarScrim" ?hidden="${!this.showBackgroundImage_}"
            ?fixed="${this.scrolledToTop_}"></div>
        <ntp-iframe id="oneGoogleBar" src="${this.oneGoogleBarIframePath_}"
            ?hidden="${!this.oneGoogleBarLoaded_}"
            allow="camera ${this.oneGoogleBarIframeOrigin_}; display-capture ${this.oneGoogleBarIframeOrigin_}"> <!-- presubmit: ignore-long-line -->
        </ntp-iframe>
        `) : ''}
  <!-- TODO(crbug.com/40743294): Instead of ?hidden="\${!this.logoEnabled_}" it would
       be nicer to use Lit's conditional rendering. However, that breaks
       StartupBrowserCreatorPickerNoParamsTest.ShowPickerWhenAlreadyLaunched on
       the msan builder. See crbug.com/1169070. -->
  <ntp-logo id="logo" ?single-colored="${this.singleColoredLogo_}"
      .theme="${this.theme_}" ?hidden="${!this.logoEnabled_}">
  </ntp-logo>
  ${this.ntpRealboxNextEnabled_ ? html `
    <div id="scrim"
        @click="${this.showComposebox_ && this.composeboxCloseByClickOutside_ ? this.onComposeboxClickOutside_ : nothing}"
        ?hidden="${!this.showScrim_}"></div>
  ` : ''}
  <div id="searchboxContainer">
    <cr-searchbox id="searchbox" ?is-dark="${this.isThemeDark_()}"
        placeholder-text="$i18n{searchBoxPlaceholder}"
        ?color-source-is-baseline="${this.colorSourceIsBaseline}"
        @open-composebox="${this.openComposebox_}"
        @open-lens-search="${this.onOpenLensSearch_}"
        @open-voice-search="${this.onOpenVoiceSearch_}" ?shown="${this.realboxShown_}"
        ?had-secondary-side="${this.realboxHadSecondarySide}"
        @had-secondary-side-changed="${this.onRealboxHadSecondarySideChanged_}"
        @context-menu-entrypoint-click="${this.onContextMenuEntrypointClick_}"
        ?can-show-secondary-side="${this.realboxCanShowSecondarySide}"
        ?compose-button-enabled="${this.composeButtonEnabled}"
        ?composebox-enabled="${this.composeboxEnabled}"
        searchbox-layout-mode="${this.realboxLayoutMode_}"
        ?ntp-realbox-next-enabled="${this.ntpRealboxNextEnabled_}"
        ?cycling-placeholders="${this.searchboxCyclingPlaceholders_}"
        @searchbox-input-focus-changed="${this.onInputFocusChanged_}"
        context-menu-glif-animation-state="${this.contextMenuGlifAnimationState_}"
        ?multi-line-enabled="${this.multiLineEnabled_}">
    </cr-searchbox>
    ${this.showComposebox_ ? html `
      ${this.enableModalComposebox_ ? html `
        <div id="dialogAnchor"></div>
        <dialog id="composeboxDialog">
          <cr-composebox id="composebox"
              ?ntp-realbox-next-enabled="${this.ntpRealboxNextEnabled_}"
              ?searchbox-next-enabled="${this.ntpRealboxNextEnabled_}"
              ?disable-caret-color-animation="${true}"
              @composebox-initialized="${this.onComposeboxInitialized_}"
              @close-composebox="${this.closeComposebox_}"
              @composebox-input-focus-changed="${this.onInputFocusChanged_}"
              @context-menu-entrypoint-click="${this.onContextMenuEntrypointClick_}"
              @voice-search-action="${this.onComposeVoiceSearchAction_}"
              searchbox-layout-mode="${this.realboxLayoutMode_}">
          </cr-composebox>
        </dialog>
      ` : html `
        <cr-composebox id="composebox"
            ?ntp-realbox-next-enabled="${this.ntpRealboxNextEnabled_}"
            ?searchbox-next-enabled="${this.ntpRealboxNextEnabled_}"
            ?disable-caret-color-animation="${true}"
            @composebox-initialized="${this.onComposeboxInitialized_}"
            @close-composebox="${this.closeComposebox_}"
            @composebox-input-focus-changed="${this.onInputFocusChanged_}"
            @voice-search-query="${this.onComposeVoiceSearchAction_}"
            searchbox-layout-mode="${this.realboxLayoutMode_}">
        </cr-composebox>
      `}
    ` : ''}
    ${this.showLensUploadDialog_ ? html `
      <ntp-lens-upload-dialog id="lensUploadDialog"
          @close-lens-search="${this.onCloseLensSearch_}">
      </ntp-lens-upload-dialog>
    ` : ''}
  </div>
  ${this.lazyRender_
        && this.ntpNextFeaturesEnabled_ && this.isActionChipsVisible_ ? html `
    <ntp-action-chips
        ?theme-has-background-image="${this.themeHasBackgroundImage_()}"
        @action-chip-click="${this.openComposebox_}"
        @action-chips-retrieval-state-changed="${this.onActionChipsRetrievalStateChanged_}">
    </ntp-action-chips>
  ` : ''}
  ${this.lazyRender_ ? html `
    <cr-toast id="webstoreToast" duration="10000" hidden>
      <div>$i18n{webstoreThemesToastMessage}</div>
      <cr-button @click="${this.onWebstoreToastButtonClick_}">
        $i18n{webstoreThemesToastButtonText}
      </cr-button>
    </cr-toast>
  ` : ''}
  ${this.lazyRender_ ? html `
    ${this.shortcutsEnabled_ ? html `
      <cr-most-visited id="mostVisited" .theme="${this.theme_?.mostVisited || null}"
          single-row reflow-on-overflow
          ?expandable-tiles-enabled="${this.ntpNextFeaturesEnabled_}"
          max-tiles-before-show-more="${this.maxTilesBeforeShowMore_}"
          @most-visited-auto-removed="${this.showAutoRemovedToast_}">
      </cr-most-visited>
    ` : ''}
    ${this.middleSlotPromoEnabled_ ? html `
      <ntp-middle-slot-promo
          @ntp-middle-slot-promo-loaded="${this.onMiddleSlotPromoLoaded_}"
          ?hidden="${!this.promoAndModulesLoaded_}">
      </ntp-middle-slot-promo>
    ` : ''}
    ${this.modulesEnabled_ ? html `
      ${html `
        <ntp-modules id="modules"
            ?modules-shown-to-user="${this.modulesShownToUser}"
            @modules-shown-to-user-changed="${this.onModulesShownToUserChanged_}"
            @customize-module="${this.onCustomizeModule_}"
            @modules-loaded="${this.onModulesLoaded_}"
            @modules-auto-removed="${this.showAutoRemovedToast_}"
            ?hidden="${!this.promoAndModulesLoaded_}">
        </ntp-modules>
      `}
    ` : ''}
    ${this.shortcutsEnabled_ || this.modulesEnabled_ ? html `
      <cr-toast id="undoToast" duration="10000">
        <div id="undoToastMessage">${this.undoAutoRemovalMessage_ || ''}</div>
        <cr-button id="undoButton"
            aria-label="$i18n{undoDescription}"
            @click="${this.onAutoRemovalUndoClick_}">
          $i18n{undo}
        </cr-button>
      </cr-toast>
    ` : ''}
    ${this.showBrowserPromo_ ? (() => {
        switch (this.browserPromoType_) {
            case "simple":
                return html `
        <individual-promos maxPromos="${this.browserPromoLimit_}">
        </individual-promos>

      `;
            case "setuplist":
                return html `
        <setup-list-module-wrapper maxPromos="${this.browserPromoLimit_}"
            maxCompletedPromos="${this.browserPromoCompletedLimit_}">
        </setup-list-module-wrapper>
      `;
            default:
                return '';
        }
    })() : ''}
  ${!this.isFooterVisible_ ? html `
      <a id="backgroundImageAttribution"
          href="${this.backgroundImageAttributionUrl_}"
          ?hidden="${!this.backgroundImageAttribution1_}">
        <div id="backgroundImageAttribution1Container">
          <div id="linkIcon" ?hidden="${!this.backgroundImageAttributionUrl_}"></div>
          <div id="backgroundImageAttribution1">
            ${this.backgroundImageAttribution1_}
          </div>
        </div>
        <div id="backgroundImageAttribution2"
            ?hidden="${!this.backgroundImageAttribution2_}">
          ${this.backgroundImageAttribution2_}
        </div>
      </a>
      <ntp-customize-buttons id="customizeButtons"
          ?modules-shown-to-user="${this.modulesShownToUser}"
          ?show-background-image="${this.showBackgroundImage_}"
          ?show-customize="${this.showCustomize_}"
          ?show-customize-chrome-text="${this.showCustomizeChromeText_}"
          ?show-wallpaper-search="${this.showWallpaperSearch_}"
          ?show-wallpaper-search-button="${this.showWallpaperSearchButton_}"
          ?wallpaper-search-button-animation-enabled="${this.wallpaperSearchButtonAnimationEnabled_}"
          @customize-click="${this.onCustomizeClick_}"
          @wallpaper-search-click="${this.onWallpaperSearchClick_}" show-shadow>
      </ntp-customize-buttons>
    ` : ''}
    ${this.showThemeAttribution_() ? html `
      <div id="themeAttribution">
        <div>$i18n{themeCreatedBy}</div>
        <img src="${this.theme_.backgroundImage.attributionUrl.url}">
      </div>
    ` : ''}
  ` : ''}
  <div id="contentBottomSpacer"></div>
</div>
${this.showVoiceSearchOverlay_ ? html `
  <ntp-voice-search-overlay @close="${this.onVoiceSearchOverlayClose_}">
  </ntp-voice-search-overlay>
` : ''}
${!this.ntpRealboxNextEnabled_ && this.showComposebox_ ? html `
  <div id="scrim"
      @click="${this.composeboxCloseByClickOutside_ ? this.onComposeboxClickOutside_ : nothing}"></div>
` : ''}
<svg>
  <defs>
    <clipPath id="oneGoogleBarClipPath">
      <!-- Set an initial non-empty clip-path so the OneGoogleBar resize events
           are processed. When the clip-path is empty, it's possible for the
           OneGoogleBar to get into a state where it does not send  the
           'overlayUpdates' message which is used to populate this
           clip-path. -->
      <rect x="0" y="0" width="1" height="1"></rect>
    </clipPath>
  </defs>
</svg>
<!--_html_template_end_-->`;
}
