import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { ActionChip, TabInfo } from '../action_chips.mojom-webui.js';
/**
 * The enum value sent as part of action-chips-retrieval-state-changed.
 * The handler of the event should expect to receive UPDATED multiple times.
 */
export declare enum ActionChipsRetrievalState {
    INITIAL = 0,
    REQUESTED = 1,
    UPDATED = 2
}
/**
 * The element for displaying Action Chips.
 */
export declare class ActionChipsElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    static get properties(): {
        actionChips_: {
            type: ArrayConstructor;
            state: boolean;
        };
        showSimplifiedUI_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        showDismissalUI_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        themeHasBackgroundImage: {
            type: BooleanConstructor;
            reflect: boolean;
        };
    };
    private handler;
    private callbackRouter;
    protected accessor actionChips_: ActionChip[];
    accessor themeHasBackgroundImage: boolean;
    protected accessor showSimplifiedUI_: boolean;
    protected accessor showDismissalUI_: boolean;
    private onActionChipChangedListenerId_;
    private initialLoadStartTime_;
    private delayTabUploads_;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    protected getAdditionalIconClasses_(chip: ActionChip): string;
    protected getId_(chip: ActionChip, index: number): string | null;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    updated(changedProperties: PropertyValues<this>): void;
    protected onCreateImageClick_(): void;
    protected onDeepDiveClick_(chip: ActionChip): void;
    protected onDeepSearchClick_(): void;
    protected onTabContextClick_(tab: TabInfo): void;
    protected handleClick_(chip: ActionChip): void;
    protected removeChip_(chip: ActionChip, e: MouseEvent): void;
    protected getFaviconUrl_(url: string): string;
    protected getMostRecentTabFaviconUrl_(chip: ActionChip): string;
    private onActionChipClick_;
    protected recentTabChipTitle_(chip: ActionChip): string;
    protected isDeepDiveChip_(chip: ActionChip): boolean;
    protected isRecentTabChip_(chip: ActionChip): boolean;
    protected showDashSimplifiedUI_(chip: ActionChip): boolean;
    protected getChipTitle_(chip: ActionChip): string;
}
declare global {
    interface HTMLElementTagNameMap {
        'ntp-action-chips': ActionChipsElement;
    }
}
