import {html} from '//resources/lit/v3_0/lit.rollup.js';
import type {OutlookCalendarModuleElement} from './outlook_calendar_module.js';

export function getHtml(this: OutlookCalendarModuleElement) {
  return html`<!--_html_template_start_--><ntp-module-header
    id="moduleHeaderElementV2"
    header-text="$i18n{modulesOutlookCalendarTitle}"
    .menuItems="${this.getMenuItems_()}"
    more-actions-text="${this.i18nRecursive('',
                          'modulesMoreActions',
                          'modulesOutlookCalendarTitle')}"
    @disable-button-click="${this.onDisableButtonClick_}"
    @dismiss-button-click="${this.onDismissButtonClick_}"
    @info-button-click="${this.onInfoButtonClick_}"
    @signout-button-click="${this.onSignOutButtonClick_}">
</ntp-module-header>
<ntp-calendar id="outlook-calendar"
    .events="${this.events_}"
    module-name="OutlookCalendar"
    calendar-link="https://outlook.office.com/calendar/">
</ntp-calendar>
${this.showInfoDialog_ ? html`
   <ntp-info-dialog show-on-attach
       .innerHTML="${this.i18nAdvanced('modulesOutlookCalendarInfo')}"
       @close="${this.onInfoDialogClose_}">
   </ntp-info-dialog>
 ` : ''}
<!--_html_template_end_-->`;
}