import {html} from '//resources/lit/v3_0/lit.rollup.js';
import type {MiddleSlotPromoElement} from './middle_slot_promo.js';

export function getHtml(this: MiddleSlotPromoElement) {
  return html`<!--_html_template_start_--><!-- Visibility is toggled in TS -->
<div id="promoAndDismissContainer" hidden>
  <!-- Promo parts are added by TS. -->
  ${this.shownMiddleSlotPromoId_ ? html`
    <cr-icon-button id="dismissPromoButton"
        class="icon-clear"
        aria-label="$i18n{close}"
        title="$i18n{close}"
        @click="${this.onDismissPromoButtonClick_}">
    </cr-icon-button>
  ` : ''}
</div>
<cr-toast id="dismissPromoButtonToast" duration="10000">
  <div id="dismissPromoButtonToastMessage">
    $i18n{undoDismissPromoButtonToast}
  </div>
  <cr-button id="undoDismissPromoButton"
      aria-label="$i18n{undoDescription}"
      @click="${this.onUndoDismissPromoButtonClick_}">
    $i18n{undo}
  </cr-button>
</cr-toast>
<!--_html_template_end_-->`;
}