import {html} from '//resources/lit/v3_0/lit.rollup.js';
import type {LogoElement} from './logo.js';

export function getHtml(this: LogoElement) {
  return html`<!--_html_template_start_-->${this.showLogo_ ? html`
  <div id="logo"></div>
` : ''}
${this.showDoodle_ ? html`
  <div id="doodle" title="${this.doodle_!.description}">
    <div id="imageDoodle" ?hidden="${!this.imageDoodle_}"
        tabindex="${this.imageDoodleTabIndex_}" @click="${this.onImageClick_}"
        @keydown="${this.onImageKeydown_}">
      <div id="imageContainer">
        <!-- The static image is always visible and the animated image is
             stacked on top of the static image so that there is no flicker
             when starting the animation. -->
        <img id="image" src="${this.imageUrl_}" @load="${this.onImageLoad_}">
        <ntp-iframe id="animation" src="${this.animationUrl_}"
            ?hidden="${!this.showAnimation_}">
        </ntp-iframe>
      </div>
      <cr-button id="shareButton" title="$i18n{shareDoodle}"
          @click="${this.onShareButtonClick_}">
        <div id="shareButtonIcon"></div>
      </cr-button>
    </div>
    ${this.iframeUrl_ ? html`
      <ntp-iframe id="iframe" src="${this.iframeUrl_}" ?expanded="${this.expanded_}"
          allow="autoplay; clipboard-write">
      </ntp-iframe>
    ` : ''}
  </div>
` : ''}
${this.showShareDialog_ ? html`
  <ntp-doodle-share-dialog .title="${this.doodle_!.description}"
      .url="${this.doodle_!.image!.shareUrl}"
      @close="${this.onShareDialogClose_}" @share="${this.onShare_}">
  </ntp-doodle-share-dialog>
` : ''}
<!--_html_template_end_-->`;
}