import { I as I18nMixinLit, g as getCss$d, a as getFaviconUrl, b as getCss$e, s as sanitizeInnerHtml, P as PageHandler, c as PageCallbackRouter, d as getCss$f, e as assertNotReached, S as SideType, R as RenderType, f as SelectionLineState, N as NavigationPredictor, h as assert, G as GlifAnimationState, i as GlowAnimationState, D as DragAndDropHandler, j as hasKeyModifiers, C as ComposeboxMode, W as WindowProxy, E as EventTracker, k as NewTabPageProxy, l as skColorToRgba, m as getTrustedHTML, n as RectFSpec, o as debounceEnd, p as isWindows, r as recordLinearValue, q as ParentTrustedDocumentProxy, t as recordDuration, F as FocusOutlineManager, u as recordBoolean, v as recordLoadDuration, w as recordVoiceAction, A as Action, V as VoiceSearchAction, x as recordSparseValueWithPersistentHash, y as recordEnumeration, z as hexColorToSkColor, B as Command, H as BrowserCommandProxy, J as ActionChipsRetrievalState, K as getTrustedScriptURL } from './shared.rollup.js';
export { M as CrAutoImgElement, L as CustomizeButtonsElement, a0 as VoiceError, Y as checkTransparency, Z as isBMP, _ as isPNG, $ as isWebP, O as processFile, Q as recordLogValue, T as recordOccurrence, U as recordPerdecage, X as recordSmallCount } from './shared.rollup.js';
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
import { css, html, CrLitElement, nothing } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { mojo } from 'chrome://resources/mojo/mojo/public/js/bindings.js';
import { TimeDeltaSpec } from 'chrome://resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { addWebUiListener, removeWebUiListener } from 'chrome://resources/js/cr.js';
import { DoodleShareChannel, DoodleImageType, NtpBackgroundImageSource } from './new_tab_page.mojom-webui.js';
import 'chrome://new-tab-page/strings.m.js';
import { PageCallbackRouter as PageCallbackRouter$1, PageHandler as PageHandler$1 } from 'chrome://resources/cr_components/color_change_listener/color_change_listener.mojom-webui.js';
import { CustomizeButtonsHandlerRemote, CustomizeButtonsDocumentCallbackRouter, CustomizeButtonsHandlerFactory, SidePanelOpenTrigger } from './customize_buttons.mojom-webui.js';
import { CustomizeChromeSection } from './customize_chrome.mojom-webui.js';
import { ShowNtpPromosResult } from './ntp_promo.mojom-webui.js';
import './action_chips.mojom-webui.js';
import 'chrome://resources/cr_components/composebox/composebox_query.mojom-webui.js';
import 'chrome://resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import 'chrome://resources/mojo/url/mojom/url.mojom-webui.js';
import 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import 'chrome://resources/cr_components/composebox/composebox.mojom-webui.js';

let instance$j = null;
function getCss$c() {
    return instance$j || (instance$j = [...[], css `:host{--cr-hover-background-color:#FFFFFF;--cr-button-height:32px;flex-shrink:0}#composeButton{background-color:#F3F5F6;color:#1F1F1F;font-weight:400;font-family:inherit;font-size:inherit;border:none;position:relative;gap:3px}.compose-container{z-index:100;position:relative;padding-inline-end:12px;padding-inline-start:8px}.compose-icon{filter:invert(1);vertical-align:text-bottom;height:18px;width:18px;padding-top:2px;padding-left:1px}#glowAnimationWrapper{--anim-duration:2s;--glif-angle-start:99deg;--glif-angle-range:245deg;--mask-angle-start:-150deg;--mask-angle-range:355deg;--acceleration:cubic-bezier(0.4,0,0.2,1);--glif-gradient:conic-gradient(rgba(52,168,82,0) 0deg,rgba(52,168,82,1) 38.9738deg,rgba(255,211,20,1) 62.3678deg,rgba(255,70,65,1) 87.0062deg,rgba(49,134,255,1) 107.428deg,rgba(49,134,255,0.5) 204.48deg,rgba(49,134,255,0) 308.88deg,rgba(52,168,82,0) 360deg);--mask-gradient:conic-gradient(transparent,16.56deg,273.24deg,transparent 333.36deg,transparent 360deg)}@keyframes rotate-glif-anim{from{rotate:var(--glif-angle-start)}to{rotate:calc(var(--glif-angle-start) + var(--glif-angle-range))}}@keyframes rotate-mask-anim{from{rotate:var(--mask-angle-start)}to{rotate:calc(var(--mask-angle-start) + var(--mask-angle-range))}}@keyframes rotate-glif-anim-infinite{from{rotate:var(--glif-angle-start)}to{rotate:calc(var(--glif-angle-start) + 360deg)}}@keyframes rotate-mask-anim-infinite{from{rotate:var(--mask-angle-start)}to{rotate:calc(var(--mask-angle-start) + 360deg)}}@keyframes fade-in-out{0%{opacity:0}10%{opacity:1}60%{opacity:1}100%{opacity:0}}@keyframes fade-in-out-infinite{0%{opacity:0}10%{opacity:1}60%{opacity:1}100%{opacity:1}}.glow-container{align-items:center;border-radius:100px;display:flex;height:36px;margin-inline-end:8px;padding-inline:2px;position:relative;top:6px;z-index:var(--cr-searchbox-compose-button-z-index,100)}:host-context([ntp-realbox-next-enabled]){--cr-button-height:36px}:host-context([ntp-realbox-next-enabled]) #composeButton{font-size:13px;font-weight:500}:host-context([ntp-realbox-next-enabled]) .glow-container{height:var(--cr-searchbox-icon-size);top:8px}:host-context([searchbox-layout-mode^='Tall']) .glow-container{top:var(--cr-searchbox-compose-button-position-top);transform:none}.gradient-and-mask-wrapper{overflow:hidden;position:absolute;inset:0;border-radius:100px;opacity:0;pointer-events:none;transition:opacity 500ms ease-out}.play .gradient-and-mask-wrapper{opacity:1;pointer-events:auto}#glowAnimationWrapper:hover .gradient-and-mask-wrapper{opacity:1;pointer-events:auto}.outer-glow{filter:blur(40px)}:host([ntp-realbox-next-enabled_]) .outer-glow{filter:blur(2px)}#glowAnimationWrapper:hover .outer-glow{filter:none}:host([ntp-realbox-next-enabled_]) #glowAnimationWrapper:hover .outer-glow{filter:blur(2px)}.gradient,.mask{position:absolute;inset:0;transform-origin:center;translate:0 -50%;top:50%;scale:1.1 0.6;border-radius:50%;aspect-ratio:1/1}.gradient:before,.mask:before{content:'';position:absolute;inset:0;transform-origin:center}.gradient:before{background:var(--glif-gradient);rotate:var(--glif-angle-start)}.play .gradient:before{animation:rotate-glif-anim var(--anim-duration) var(--acceleration) forwards,fade-in-out var(--anim-duration) linear forwards}.mask:before{background:var(--mask-gradient);rotate:var(--mask-angle-start)}:host([ntp-realbox-next-enabled_]) .gradient:before{background:var(--glif-gradient);rotate:calc(var(--glif-angle-start) + var(--mouse-angle,0deg))}:host([ntp-realbox-next-enabled_]) .play .gradient:before{animation:fade-in-out var(--anim-duration) linear forwards}:host([ntp-realbox-next-enabled_]) .mask:before{background:var(--mask-gradient);rotate:calc(var(--mask-angle-start) + var(--mouse-angle,0deg))}.play .mask:before{animation:rotate-mask-anim var(--anim-duration) var(--acceleration) forwards}#glowAnimationWrapper:hover .mask:before{--anim-duration:8s;animation:rotate-mask-anim-infinite var(--anim-duration) linear infinite,fade-in-out-infinite var(--anim-duration) linear forwards}#glowAnimationWrapper:hover .gradient:before{--anim-duration:8s;animation:rotate-glif-anim-infinite var(--anim-duration) linear infinite,fade-in-out-infinite var(--anim-duration) linear forwards}:host([ntp-realbox-next-enabled_]) #glowAnimationWrapper:hover .mask:before{--anim-duration:8s;animation:fade-in-out-infinite var(--anim-duration) linear forwards}:host([ntp-realbox-next-enabled_])
#glowAnimationWrapper:hover
.gradient:before{--anim-duration:8s;animation:fade-in-out-infinite var(--anim-duration) linear forwards}`]);
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$b() {
    // clang-format off
    return html `<!--_html_template_start_-->
<div id="glowAnimationWrapper" class="glow-container play">
  <div class="gradient-and-mask-wrapper outer-glow">
    <div class="gradient"></div>
    <div class="mask"></div>
  </div>
  <div class="gradient-and-mask-wrapper">
    <div class="gradient"></div>
    <div class="mask"></div>
  </div>
  <cr-button @click="${this.onClick_}" id="composeButton"
      class="compose-container"
      title="${this.i18n('searchboxComposeButtonTitle')}">
    <img slot="prefix-icon" src="${this.composeIcon_}" class="compose-icon">
    ${this.i18n('searchboxComposeButtonText')}
  </cr-button>
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SearchboxComposeButtonElementBase = I18nMixinLit(CrLitElement);
class SearchboxComposeButtonElement extends SearchboxComposeButtonElementBase {
    aimButtonAngle = 0;
    currentAngle = 0;
    velocity = 0;
    animationFrame = 0;
    rotationEase = 0.01;
    friction = 0.9;
    then = performance.now();
    static get is() {
        return 'cr-searchbox-compose-button';
    }
    static get styles() {
        return getCss$c();
    }
    render() {
        return getHtml$b.bind(this)();
    }
    static get properties() {
        return {
            composeIcon_: {
                type: String,
                reflect: true,
            },
            showAnimation_: {
                type: Boolean,
                reflect: true,
            },
            ntpRealboxNextEnabled_: {
                type: Boolean,
                reflect: true,
            },
        };
    }
    #ntpRealboxNextEnabled__accessor_storage = loadTimeData.getBoolean('ntpRealboxNextEnabled');
    get ntpRealboxNextEnabled_() { return this.#ntpRealboxNextEnabled__accessor_storage; }
    set ntpRealboxNextEnabled_(value) { this.#ntpRealboxNextEnabled__accessor_storage = value; }
    #composeIcon__accessor_storage = '//resources/cr_components/searchbox/icons/search_spark.svg';
    get composeIcon_() { return this.#composeIcon__accessor_storage; }
    set composeIcon_(value) { this.#composeIcon__accessor_storage = value; }
    #showAnimation__accessor_storage = loadTimeData.getBoolean('searchboxShowComposeAnimation');
    get showAnimation_() { return this.#showAnimation__accessor_storage; }
    set showAnimation_(value) { this.#showAnimation__accessor_storage = value; }
    firstUpdated() {
        if (this.$.glowAnimationWrapper) {
            if (this.ntpRealboxNextEnabled_) {
                this.$.glowAnimationWrapper.addEventListener('mouseenter', this.onMouseEnter_);
                this.$.glowAnimationWrapper.addEventListener('mouseleave', this.onMouseLeave_);
            }
            if (!this.showAnimation_) {
                this.$.glowAnimationWrapper.classList.remove('play');
            }
            else {
                this.$.glowAnimationWrapper.addEventListener('animationend', () => {
                    this.$.glowAnimationWrapper.classList.remove('play');
                });
            }
        }
    }
    onMouseEnter_ = () => {
        if (this.$.glowAnimationWrapper) {
            this.$.glowAnimationWrapper.classList.remove('play-landing-animation');
            this.$.glowAnimationWrapper.addEventListener('mousemove', this.onMouseMove);
            this.animationFrame = requestAnimationFrame(this.updateRotation);
        }
    };
    onMouseLeave_ = () => {
        if (this.$.glowAnimationWrapper) {
            this.$.glowAnimationWrapper.removeEventListener('mousemove', this.onMouseMove);
            cancelAnimationFrame(this.animationFrame);
        }
    };
    onClick_(e) {
        e.preventDefault();
        this.fire('compose-click', {
            button: e.button,
            ctrlKey: e.ctrlKey,
            metaKey: e.metaKey,
            shiftKey: e.shiftKey,
        });
    }
    updateRotation = () => {
        const now = performance.now();
        const elapsed = now - this.then;
        // Prevents updating more than 60 fps.
        if (elapsed > 16.67) {
            let delta = this.currentAngle - this.aimButtonAngle;
            // If the delta is too small to be noticeable, don't calculate and update.
            if (Math.abs(delta) > 10) {
                // Converts the delta into the shortest angle from -180 to 180 degrees.
                delta = (((delta % 360) + 540) % 360) - 180;
                // Normalizes the delta to a clamped decimal between 0.0 and 1.0.
                const normalizedDelta = this.clampValue(0, 100, Math.abs(delta)) / 300;
                // Multiply delta by the ease and normalized delta for ease-in
                // cushioning.
                this.velocity += delta * this.rotationEase * normalizedDelta;
                // Apply velocity to the current angle.
                this.aimButtonAngle += this.velocity;
                // Apply friction to the velocity so it does not accelerate
                // indefinitely.
                this.velocity *= this.friction;
                this.setRotationCss(this.aimButtonAngle);
            }
            this.then = now - (elapsed % 16.67);
        }
        this.animationFrame = requestAnimationFrame(this.updateRotation);
    };
    setRotationCss(angle) {
        this.$.glowAnimationWrapper.style.setProperty('--mouse-angle', `${angle + 180}deg`);
    }
    onMouseMove = (e) => {
        this.setCurrentAngle(e.clientX, e.clientY);
    };
    setCurrentAngle(mouseX, mouseY) {
        const elRect = this.$.glowAnimationWrapper.getBoundingClientRect();
        const elX = elRect.x + elRect.width * 0.5;
        const elY = elRect.y + elRect.height * 0.5;
        this.currentAngle = this.getAngleTo(mouseX, mouseY, elX, elY);
    }
    getAngleTo(x1, y1, x2, y2) {
        return Math.atan2(y2 - y1, x2 - x1) * (180 / Math.PI);
    }
    clampValue(min, max, val) {
        return Math.max(min, Math.min(val, max));
    }
}
customElements.define(SearchboxComposeButtonElement.is, SearchboxComposeButtonElement);

let instance$i = null;
function getCss$b() {
    return instance$i || (instance$i = [...[getCss$d()], css `:host{--cr-searchbox-icon-border-radius:8px;align-items:center;display:flex;flex-shrink:0;justify-content:center;width:var(--cr-searchbox-icon-container-size,32px)}:host(:not([is-lens-searchbox_])){--cr-searchbox-icon-border-radius:4px}#container{align-items:center;aspect-ratio:1/1;border-radius:var(--cr-searchbox-icon-border-radius);display:flex;justify-content:center;overflow:hidden;position:relative;width:100%}:host([has-image_]:not([in-searchbox]):not([is-weather-answer])) #container{background-color:var(--color-searchbox-results-icon-container-background,var(--container-bg-color))}:host([has-icon-container-background]:not([in-searchbox])) #container{background-color:var(--color-searchbox-answer-icon-background)}:host([is-weather-answer]:not([in-searchbox])) #container{background-color:var(--color-searchbox-results-background)}#image{display:none;height:100%;object-fit:contain;width:100%}:host([has-image_]:not([in-searchbox])) #image{display:initial}:host([is-answer]) #image{max-height:24px;max-width:24px}#icon{height:24px;width:24px}#faviconImageContainer{width:24px;height:24px;display:flex;justify-content:center;align-items:center}#faviconImage{height:16px;width:16px}#icon{-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-searchbox-results-search-icon-size,16px);background-color:var(--color-searchbox-search-icon-background)}:host([in-searchbox][is-lens-searchbox_]) #icon{background-color:var(--color-searchbox-google-g-background);height:var(--cr-searchbox-icon-size-in-searchbox);width:var(--cr-searchbox-icon-size-in-searchbox)}@media (forced-colors:active){:host([in-searchbox][is-lens-searchbox_]) #icon{background-color:ButtonText}}:host([in-searchbox][favicon-image_*='//resources/cr_components/omnibox/icons/google_g.svg']) #faviconImage{width:24px;height:24px}:host([in-searchbox]) #icon{-webkit-mask-size:var(--cr-searchbox-icon-size-in-searchbox)}:host([in-searchbox]) #faviconImage{width:var(--cr-searchbox-icon-size-in-searchbox);height:var(--cr-searchbox-icon-size-in-searchbox)}:host([has-icon-container-background]:not([in-searchbox])) #icon{background-color:var(--color-searchbox-answer-icon-foreground)}:host([has-icon-container-background][is-starter-pack]:not([in-searchbox])) #icon,:host([has-icon-container-background][is-featured-enterprise-search]:not([in-searchbox])) #icon{background-color:var(--color-searchbox-results-starter-pack-icon,var(--color-searchbox-answer-icon-foreground))}#iconImg{height:var(--cr-searchbox-results-search-icon-size,16px);width:var(--cr-searchbox-results-search-icon-size,16px)}:host([in-searchbox]) #iconImg{height:var(--cr-searchbox-icon-size-in-searchbox);width:var(--cr-searchbox-icon-size-in-searchbox)}:host([has-image_]:not([in-searchbox])) #icon,:host([has-image_]:not([in-searchbox])) #iconImg,:host([has-image_]:not([in-searchbox])) #faviconImageContainer{display:none}:host(:not([in-searchbox])[is-lens-searchbox_]) #container{background-color:var(--color-searchbox-results-icon-container-background);border-radius:4000px}`]);
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$a() {
    // clang-format off
    return html `<!--_html_template_start_-->
<div id="container"
    style="--container-bg-color:${this.getContainerBgColor_()};">
  <img id="image" src="${this.imageSrc_}" ?hidden="${!this.showImage_}"
      @load="${this.onImageLoad_}" @error="${this.onImageError_}">

  <div ?hidden="${this.showIconImg_}">
    <div id="icon" style="-webkit-mask-image: ${this.maskImage};"
        ?hidden="${this.showFaviconImage_}">
    </div>
    <div id="faviconImageContainer"
        ?hidden="${!this.showFaviconImage_}">
      <img id="faviconImage" src="${this.faviconImage_}"
          srcset="${this.faviconImageSrcSet_}"
          @load="${this.onFaviconLoad_}"
          @error="${this.onFaviconError_}">
    </div>
  </div>

  <img id="iconImg" src="${this.iconSrc_}" ?hidden="${!this.showIconImg_}"
      @load="${this.onIconLoad_}">
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CALCULATOR = 'search-calculator-answer';
const DOCUMENT_MATCH_TYPE = 'document';
const FEATURED_ENTERPRISE_SEARCH = 'featured-enterprise-search';
const HISTORY_CLUSTER_MATCH_TYPE = 'history-cluster';
const PEDAL = 'pedal';
const STARTER_PACK = 'starter-pack';
// The LHS icon. Used on autocomplete matches as well as the searchbox input to
// render icons, favicons, and entity images.
class SearchboxIconElement extends CrLitElement {
    static get is() {
        return 'cr-searchbox-icon';
    }
    static get styles() {
        return getCss$b();
    }
    render() {
        return getHtml$a.bind(this)();
    }
    static get properties() {
        return {
            //========================================================================
            // Public properties
            //========================================================================
            /**
             * The default icon to show when no match is selected and/or for
             * non-navigation matches. Only set in the context of the searchbox input.
             */
            defaultIcon: { type: String },
            /**  Whether icon should have a background. */
            hasIconContainerBackground: {
                type: Boolean,
                reflect: true,
            },
            /**
             * Whether icon is in searchbox or not. Used to prevent
             * the match icon of rich suggestions from showing in the context of the
             * searchbox input.
             */
            inSearchbox: {
                type: Boolean,
                reflect: true,
            },
            /**
             * Whether icon belongs to an answer or not. Used to prevent
             * the match image from taking size of container.
             */
            isAnswer: {
                type: Boolean,
                reflect: true,
            },
            /**
             * Whether icon belongs to a starter pack match.
             */
            isStarterPack: {
                type: Boolean,
                reflect: true,
            },
            /**
             * Whether icon belongs to a featured enterprise search match.
             */
            isFeaturedEnterpriseSearch: {
                type: Boolean,
                reflect: true,
            },
            /**
             * Whether suggestion answer is of answer type weather. Weather answers
             * don't have the same background as other suggestion answers.
             */
            isWeatherAnswer: {
                type: Boolean,
                reflect: true,
            },
            /**
             * Whether suggestion is an enterprise search aggregator people
             * suggestion. Enterprise search aggregator people suggestions should not
             * use a set background color when image is missing, unlike other rich
             * suggestion answers.
             */
            isEnterpriseSearchAggregatorPeopleType: {
                type: Boolean,
                reflect: true,
            },
            /** Used as a mask image on #icon if `faviconImage_` is empty. */
            maskImage: {
                type: String,
                reflect: true,
            },
            match: { type: Object },
            //========================================================================
            // Private properties
            //========================================================================
            /** Used as the image src for the #faviconImage if non-empty. */
            faviconImage_: {
                type: String,
                reflect: true,
            },
            /**
             * Used as the image srcset for the #faviconImage if non-empty.
             */
            faviconImageSrcSet_: { state: true, type: String },
            /**
             * Whether the match features an image (as opposed to an icon or favicon).
             */
            hasImage_: {
                type: Boolean,
                reflect: true,
            },
            /**
             * Whether to use the favicon image instead of the default vector icon
             * for the suggestion.
             */
            showFaviconImage_: { state: true, type: Boolean },
            /**
             * Flag indicating whether or not a favicon is loading.
             */
            faviconLoading_: { state: true, type: Boolean },
            /**
             * Flag indicating whether or not a favicon was successfully loaded.
             * This is used to force the WebUI popup to make use of the default vector
             * icon when the favicon image is unavailable.
             */
            faviconError_: { state: true, type: Boolean },
            /** Used as the image src for the #iconImg if non-empty. */
            iconSrc_: { state: true, type: String },
            /**
             * Flag indicating whether or not an icon image is loading. This is used
             * to show a default icon while the image is loading.
             */
            iconLoading_: { state: true, type: Boolean },
            /**
             * Whether to use the icon image instead of the default icon for the
             * suggestion.
             */
            showIconImg_: { state: true, type: Boolean },
            showImage_: { state: true, type: Boolean },
            imageSrc_: { state: true, type: String },
            /**
             * Flag indicating whether or not an image is loading. This is used to
             * show a placeholder color while the image is loading.
             */
            imageLoading_: { state: true, type: Boolean },
            /**
             * Flag indicating whether or not an image was successfully loaded. This
             * is used to suppress the default "broken image" icon as needed.
             */
            imageError_: {
                state: true,
                type: Boolean,
            },
            isTopChromeSearchbox_: { state: true, type: Boolean },
            isLensSearchbox_: {
                type: Boolean,
                reflect: true,
            },
        };
    }
    #defaultIcon_accessor_storage = '';
    get defaultIcon() { return this.#defaultIcon_accessor_storage; }
    set defaultIcon(value) { this.#defaultIcon_accessor_storage = value; }
    #hasIconContainerBackground_accessor_storage = false;
    get hasIconContainerBackground() { return this.#hasIconContainerBackground_accessor_storage; }
    set hasIconContainerBackground(value) { this.#hasIconContainerBackground_accessor_storage = value; }
    #inSearchbox_accessor_storage = false;
    get inSearchbox() { return this.#inSearchbox_accessor_storage; }
    set inSearchbox(value) { this.#inSearchbox_accessor_storage = value; }
    #isAnswer_accessor_storage = false;
    get isAnswer() { return this.#isAnswer_accessor_storage; }
    set isAnswer(value) { this.#isAnswer_accessor_storage = value; }
    #isStarterPack_accessor_storage = false;
    get isStarterPack() { return this.#isStarterPack_accessor_storage; }
    set isStarterPack(value) { this.#isStarterPack_accessor_storage = value; }
    #isFeaturedEnterpriseSearch_accessor_storage = false;
    get isFeaturedEnterpriseSearch() { return this.#isFeaturedEnterpriseSearch_accessor_storage; }
    set isFeaturedEnterpriseSearch(value) { this.#isFeaturedEnterpriseSearch_accessor_storage = value; }
    #isWeatherAnswer_accessor_storage = false;
    get isWeatherAnswer() { return this.#isWeatherAnswer_accessor_storage; }
    set isWeatherAnswer(value) { this.#isWeatherAnswer_accessor_storage = value; }
    #isEnterpriseSearchAggregatorPeopleType_accessor_storage = false;
    get isEnterpriseSearchAggregatorPeopleType() { return this.#isEnterpriseSearchAggregatorPeopleType_accessor_storage; }
    set isEnterpriseSearchAggregatorPeopleType(value) { this.#isEnterpriseSearchAggregatorPeopleType_accessor_storage = value; }
    #maskImage_accessor_storage = '';
    get maskImage() { return this.#maskImage_accessor_storage; }
    set maskImage(value) { this.#maskImage_accessor_storage = value; }
    #match_accessor_storage = null;
    get match() { return this.#match_accessor_storage; }
    set match(value) { this.#match_accessor_storage = value; }
    #faviconImage__accessor_storage = '';
    get faviconImage_() { return this.#faviconImage__accessor_storage; }
    set faviconImage_(value) { this.#faviconImage__accessor_storage = value; }
    #faviconImageSrcSet__accessor_storage = '';
    get faviconImageSrcSet_() { return this.#faviconImageSrcSet__accessor_storage; }
    set faviconImageSrcSet_(value) { this.#faviconImageSrcSet__accessor_storage = value; }
    #hasImage__accessor_storage = false;
    get hasImage_() { return this.#hasImage__accessor_storage; }
    set hasImage_(value) { this.#hasImage__accessor_storage = value; }
    #showFaviconImage__accessor_storage = false;
    get showFaviconImage_() { return this.#showFaviconImage__accessor_storage; }
    set showFaviconImage_(value) { this.#showFaviconImage__accessor_storage = value; }
    #faviconLoading__accessor_storage = false;
    get faviconLoading_() { return this.#faviconLoading__accessor_storage; }
    set faviconLoading_(value) { this.#faviconLoading__accessor_storage = value; }
    #faviconError__accessor_storage = false;
    get faviconError_() { return this.#faviconError__accessor_storage; }
    set faviconError_(value) { this.#faviconError__accessor_storage = value; }
    #iconSrc__accessor_storage = '';
    get iconSrc_() { return this.#iconSrc__accessor_storage; }
    set iconSrc_(value) { this.#iconSrc__accessor_storage = value; }
    #iconLoading__accessor_storage = false;
    get iconLoading_() { return this.#iconLoading__accessor_storage; }
    set iconLoading_(value) { this.#iconLoading__accessor_storage = value; }
    #showIconImg__accessor_storage = false;
    get showIconImg_() { return this.#showIconImg__accessor_storage; }
    set showIconImg_(value) { this.#showIconImg__accessor_storage = value; }
    #showImage__accessor_storage = false;
    get showImage_() { return this.#showImage__accessor_storage; }
    set showImage_(value) { this.#showImage__accessor_storage = value; }
    #imageSrc__accessor_storage = '';
    get imageSrc_() { return this.#imageSrc__accessor_storage; }
    set imageSrc_(value) { this.#imageSrc__accessor_storage = value; }
    #imageLoading__accessor_storage = false;
    get imageLoading_() { return this.#imageLoading__accessor_storage; }
    set imageLoading_(value) { this.#imageLoading__accessor_storage = value; }
    #imageError__accessor_storage = false;
    get imageError_() { return this.#imageError__accessor_storage; }
    set imageError_(value) { this.#imageError__accessor_storage = value; }
    #isTopChromeSearchbox__accessor_storage = loadTimeData.getBoolean('isTopChromeSearchbox');
    get isTopChromeSearchbox_() { return this.#isTopChromeSearchbox__accessor_storage; }
    set isTopChromeSearchbox_(value) { this.#isTopChromeSearchbox__accessor_storage = value; }
    #isLensSearchbox__accessor_storage = loadTimeData.getBoolean('isLensSearchbox');
    get isLensSearchbox_() { return this.#isLensSearchbox__accessor_storage; }
    set isLensSearchbox_(value) { this.#isLensSearchbox__accessor_storage = value; }
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('match')) {
            this.iconSrc_ = this.computeIconSrc_();
            this.imageSrc_ = this.computeImageSrc_();
            this.isAnswer = this.computeIsAnswer_();
            this.isEnterpriseSearchAggregatorPeopleType =
                this.computeIsEnterpriseSearchAggregatorPeopleType_();
            this.isStarterPack = this.computeIsStarterPack_();
            this.isFeaturedEnterpriseSearch =
                this.computeIsFeaturedEnterpriseSearch();
            this.isWeatherAnswer = this.computeIsWeatherAnswer_();
            this.hasImage_ = this.computeHasImage_();
            this.maskImage = this.computeMaskImage_();
        }
        if (changedProperties.has('match') ||
            changedProperties.has('isWeatherAnswer')) {
            this.hasIconContainerBackground =
                this.computeHasIconContainerBackground_();
        }
        const changedPrivateProperties = changedProperties;
        if (changedProperties.has('match') ||
            changedProperties.has('defaultIcon') ||
            changedPrivateProperties.has('isTopChromeSearchbox_')) {
            this.faviconImage_ = this.computeFaviconImage_();
        }
        if (changedProperties.has('match') ||
            changedPrivateProperties.has('faviconImage_') ||
            changedPrivateProperties.has('isTopChromeSearchbox_')) {
            this.faviconImageSrcSet_ = this.computeFaviconImageSrcSet_();
        }
        if (changedPrivateProperties.has('faviconImage_')) {
            // If `faviconImage_` changes to a new truthy value, a new favicon is
            // being loaded.
            this.faviconLoading_ = !!this.faviconImage_;
            this.faviconError_ = false;
        }
        if (changedProperties.has('match') ||
            changedPrivateProperties.has('isLensSearchbox_') ||
            changedPrivateProperties.has('faviconImage_') ||
            changedPrivateProperties.has('faviconLoading_') ||
            changedPrivateProperties.has('faviconError_')) {
            this.showFaviconImage_ = this.computeShowFaviconImage_();
        }
        if (changedPrivateProperties.has('iconSrc_')) {
            // If iconSrc_ changes to a new truthy value, a new icon is being loaded.
            this.iconLoading_ = !!this.iconSrc_;
        }
        if (changedPrivateProperties.has('imageSrc_')) {
            // If imageSrc_ changes to a new truthy value, a new image is being
            // loaded.
            this.imageLoading_ = !!this.imageSrc_;
            this.imageError_ = false;
        }
        if (changedPrivateProperties.has('imageSrc_') ||
            changedPrivateProperties.has('imageError_')) {
            this.showImage_ = this.computeShowImage_();
        }
        if (changedProperties.has('match') ||
            changedPrivateProperties.has('isLensSearchbox_') ||
            changedPrivateProperties.has('iconLoading_')) {
            this.showIconImg_ = this.computeShowIconImg_();
        }
    }
    //============================================================================
    // Helpers
    //============================================================================
    computeFaviconUrl_(scaleFactor) {
        if (!this.match?.destinationUrl.url) {
            return '';
        }
        return getFaviconUrl(
        /* url= */ this.match.destinationUrl.url, {
            forceLightMode: !this.isTopChromeSearchbox_,
            forceEmptyDefaultFavicon: true,
            scaleFactor: `${scaleFactor}x`,
        });
    }
    computeFaviconImageSrcSet_() {
        if (!this.faviconImage_.startsWith('chrome://favicon2/')) {
            return '';
        }
        return [
            `${this.computeFaviconUrl_(/* scaleFactor= */ 1)} 1x`,
            `${this.computeFaviconUrl_(/* scaleFactor= */ 2)} 2x`,
        ].join(', ');
    }
    computeFaviconImage_() {
        if (this.match && !this.match.isSearchType) {
            if (this.match.type === DOCUMENT_MATCH_TYPE ||
                this.match.type === PEDAL ||
                this.match.isEnterpriseSearchAggregatorPeopleType) {
                return this.match.iconPath;
            }
            // Featured enterprise search suggestions have the icon set match.iconUrl.
            if (this.match.type !== HISTORY_CLUSTER_MATCH_TYPE &&
                this.match.type !== FEATURED_ENTERPRISE_SEARCH) {
                return this.computeFaviconUrl_(/* scaleFactor= */ 1);
            }
        }
        if (this.defaultIcon ===
            '//resources/cr_components/searchbox/icons/google_g.svg' ||
            this.defaultIcon ===
                '//resources/cr_components/searchbox/icons/google_g_gradient.svg') {
            // The google_g.svg is a fully colored icon, so it needs to be displayed
            // as a favicon image as mask images will mask the colors.
            return this.defaultIcon;
        }
        return '';
    }
    computeIsAnswer_() {
        return !!this.match && !!this.match.answer;
    }
    computeIsWeatherAnswer_() {
        return this.match?.isWeatherAnswerSuggestion || false;
    }
    computeHasImage_() {
        return !!this.match && !!this.match.imageUrl;
    }
    computeIsEnterpriseSearchAggregatorPeopleType_() {
        return this.match?.isEnterpriseSearchAggregatorPeopleType || false;
    }
    computeShowIconImg_() {
        // Lens searchbox should not use icon URL.
        return !this.isLensSearchbox_ && !!this.match && !!this.match.iconUrl.url &&
            !this.iconLoading_;
    }
    computeMaskImage_() {
        // Lens searchboxes should always have the Google G in the searchbox.
        if (this.isLensSearchbox_ && this.inSearchbox) {
            return `url(${this.defaultIcon})`;
        }
        // Enterprise search aggregator people and starter pack/featured enterprise
        // search suggestions should show icon even in searchbox.
        if (this.match &&
            (!this.match.isRichSuggestion || this.match.type === STARTER_PACK ||
                this.match.type === FEATURED_ENTERPRISE_SEARCH ||
                this.match.isEnterpriseSearchAggregatorPeopleType ||
                !this.inSearchbox)) {
            return `url(${this.match.iconPath})`;
        }
        else {
            return `url(${this.defaultIcon})`;
        }
    }
    // Controls whether the favicon image should be used instead of the mask
    // image.
    computeShowFaviconImage_() {
        if (!this.faviconImage_) {
            return false;
        }
        // If the favicon resource is still loading or there was an error, then
        // fall back to rendering the default vector icon (generic globe icon).
        if (this.faviconLoading_ || this.faviconError_) {
            return false;
        }
        // Navigation suggestions should always use the background image, except for
        // Lens searchboxes and pedal/starter pack suggestions, which prefer to use
        // the default icon in the mask image.
        if (!this.isLensSearchbox_ && this.match && !this.match.isSearchType &&
            this.match.type !== STARTER_PACK && this.match.type !== PEDAL) {
            return true;
        }
        // The following icons should not use the GM3 foreground color.
        // TODO(niharm): Refactor logic in C++ and send via mojom in
        // "chrome/browser/ui/webui/searchbox/searchbox_handler.cc".
        const themedIcons = [
            'calendar',
            'drive_docs',
            'drive_folder',
            'drive_form',
            'drive_image',
            'drive_logo',
            'drive_pdf',
            'drive_sheets',
            'drive_slides',
            'drive_video',
            'google_agentspace_logo',
            'google_agentspace_logo_25',
            'google_g',
            'google_g_gradient',
            'note',
            'sites',
        ];
        for (const icon of themedIcons) {
            if (this.faviconImage_ ===
                '//resources/cr_components/searchbox/icons/' + icon + '.svg') {
                return true;
            }
        }
        return false;
    }
    computeSrc_(url) {
        if (!url) {
            return '';
        }
        if (url.startsWith('data:image/')) {
            // Zero-prefix matches come with the data URI content in |url|.
            return url;
        }
        return `//image?staticEncode=true&encodeType=webp&url=${url}`;
    }
    computeIconSrc_() {
        return this.computeSrc_(this.match?.iconUrl?.url);
    }
    computeShowImage_() {
        return !!this.imageSrc_ && !this.imageError_;
    }
    computeImageSrc_() {
        return this.computeSrc_(this.match?.imageUrl);
    }
    getContainerBgColor_() {
        // If the match has an image dominant color, show that color in place of the
        // image until it loads. This helps the image appear to load more smoothly.
        return ((this.imageLoading_ || this.imageError_) &&
            this.match?.imageDominantColor) ?
            // .25 opacity matching c/b/u/views/omnibox/omnibox_match_cell_view.cc.
            (this.match.imageDominantColor ?
                `${this.match.imageDominantColor}40` :
                'var(--cr-searchbox-match-icon-container-background-fallback)') :
            'transparent';
    }
    onFaviconLoad_() {
        this.faviconLoading_ = false;
        this.faviconError_ = false;
    }
    onFaviconError_() {
        this.faviconLoading_ = false;
        this.faviconError_ = true;
    }
    onIconLoad_() {
        this.iconLoading_ = false;
    }
    onImageLoad_() {
        this.imageLoading_ = false;
        this.imageError_ = false;
    }
    onImageError_() {
        this.imageLoading_ = false;
        this.imageError_ = true;
    }
    // All pedals, starter pack/featured enterprise search suggestions, and AiS
    // except weather should have a colored background container that matches the
    // current theme.
    // TODO(niharm): Refactor logic in C++ and send via mojom in
    // "chrome/browser/ui/webui/searchbox/searchbox_handler.cc".
    computeHasIconContainerBackground_() {
        if (this.match) {
            return this.match.type === PEDAL ||
                this.match.type === HISTORY_CLUSTER_MATCH_TYPE ||
                this.match.type === CALCULATOR || this.match.type === STARTER_PACK ||
                this.match.type === FEATURED_ENTERPRISE_SEARCH ||
                (!!this.match.answer && !this.isWeatherAnswer);
        }
        return false;
    }
    computeIsStarterPack_() {
        return this.match?.type === STARTER_PACK;
    }
    computeIsFeaturedEnterpriseSearch() {
        return this.match?.type === FEATURED_ENTERPRISE_SEARCH;
    }
}
customElements.define(SearchboxIconElement.is, SearchboxIconElement);

let instance$h = null;
function getCss$a() {
    return instance$h || (instance$h = [...[getCss$e()], css `:host{border:solid 1px var(--color-searchbox-results-action-chip);border-radius:8px;display:flex;height:var(--cr-searchbox-results-action-chip-height,28px);min-width:0;outline:none;padding-inline-end:8px;padding-inline-start:8px;position:relative;transition:background-color 0.25s}:host(:hover){background-color:var(--color-searchbox-results-button-hover)}:host(:focus),:host(.selected){margin:2px;box-shadow:none}:host(.selected:hover){background-color:var(--color-searchbox-results-button-selected-hover)}:host(:active) #overlay{background-color:var(--color-omnibox-results-button-ink-drop-selected-row-hovered)}:host(.selected:active) #overlay{background-color:var(--color-omnibox-results-button-ink-drop-selected-row-selected)}#overlay{--overlay-inset:calc(var(--border-width) * -1);border-radius:inherit;display:inherit;position:absolute;top:var(--overlay-inset);left:var(--overlay-inset);right:var(--overlay-inset);bottom:var(--overlay-inset)}.contents{align-items:center;display:flex;min-width:0}#action-icon{flex-shrink:0;-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:15px;background-color:var(--color-searchbox-results-action-chip-icon);background-position:center center;background-repeat:no-repeat;height:16px;width:16px}:host-context(:is(:focus,[selected])) #action-icon{background-color:var(--color-searchbox-results-action-chip-icon-selected,var(--color-searchbox-results-action-chip-icon))}#text{overflow:hidden;padding-inline-start:8px;text-overflow:ellipsis;white-space:nowrap}`]);
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$9() {
    // clang-format off
    return html `<!--_html_template_start_-->
<div id="overlay"></div>
<div class="contents" title="${this.suggestionContents}">
  <div id="action-icon" style="${this.iconStyle_}"></div>
  <div id="text" .innerHTML="${this.hintHtml_}"></div>
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Displays a UI chip for an `AutocompleteMatch`. E.g. for keywords ('Search
// YouTube') or actions ('Clear browsing data').
class SearchboxActionElement extends CrLitElement {
    static get is() {
        return 'cr-searchbox-action';
    }
    static get styles() {
        return getCss$a();
    }
    render() {
        return getHtml$9.bind(this)();
    }
    static get properties() {
        return {
            hint: { type: String },
            hintHtml_: {
                state: true,
                type: String,
            },
            suggestionContents: { type: String },
            iconPath: { type: String },
            iconStyle_: {
                state: true,
                type: String,
            },
            ariaLabel: { type: String },
            // Index of the action in the autocomplete result. Used to inform handler
            // of action that was selected.
            actionIndex: { type: Number },
        };
    }
    #hint_accessor_storage = '';
    get hint() { return this.#hint_accessor_storage; }
    set hint(value) { this.#hint_accessor_storage = value; }
    #hintHtml__accessor_storage = window.trustedTypes.emptyHTML;
    get hintHtml_() { return this.#hintHtml__accessor_storage; }
    set hintHtml_(value) { this.#hintHtml__accessor_storage = value; }
    #suggestionContents_accessor_storage = '';
    get suggestionContents() { return this.#suggestionContents_accessor_storage; }
    set suggestionContents(value) { this.#suggestionContents_accessor_storage = value; }
    #iconPath_accessor_storage = '';
    get iconPath() { return this.#iconPath_accessor_storage; }
    set iconPath(value) { this.#iconPath_accessor_storage = value; }
    #iconStyle__accessor_storage = '';
    get iconStyle_() { return this.#iconStyle__accessor_storage; }
    set iconStyle_(value) { this.#iconStyle__accessor_storage = value; }
    #ariaLabel_accessor_storage = '';
    get ariaLabel() { return this.#ariaLabel_accessor_storage; }
    set ariaLabel(value) { this.#ariaLabel_accessor_storage = value; }
    #actionIndex_accessor_storage = -1;
    get actionIndex() { return this.#actionIndex_accessor_storage; }
    set actionIndex(value) { this.#actionIndex_accessor_storage = value; }
    firstUpdated() {
        this.addEventListener('click', (event) => this.onActionClick_(event));
        this.addEventListener('keydown', (event) => this.onActionKeyDown_(event));
        this.addEventListener('mousedown', (event) => this.onActionMouseDown_(event));
    }
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('hint')) {
            this.hintHtml_ = this.computeHintHtml_();
        }
        if (changedProperties.has('iconPath')) {
            this.iconStyle_ = this.computeActionIconStyle_();
        }
    }
    onActionClick_(e) {
        this.fire('execute-action', {
            event: e,
            actionIndex: this.actionIndex,
        });
        e.preventDefault(); // Prevents default browser action (navigation).
        e.stopPropagation(); // Prevents <iron-selector> from selecting the match.
    }
    onActionKeyDown_(e) {
        if (e.key && (e.key === 'Enter' || e.key === ' ')) {
            this.onActionClick_(e);
        }
    }
    onActionMouseDown_(e) {
        e.preventDefault(); // Prevents default browser action (focus).
    }
    //============================================================================
    // Helpers
    //============================================================================
    computeHintHtml_() {
        if (this.hint) {
            return sanitizeInnerHtml(this.hint);
        }
        return window.trustedTypes.emptyHTML;
    }
    computeActionIconStyle_() {
        // If this is a custom icon, shouldn't follow the standard theming given to
        // all other action icons.
        if (this.iconPath.startsWith('data:image/')) {
            return `background-image: url(${this.iconPath})`;
        }
        return `-webkit-mask-image: url(${this.iconPath})`;
    }
}
customElements.define(SearchboxActionElement.is, SearchboxActionElement);

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function createAutocompleteMatch() {
    return {
        isHidden: false,
        a11yLabel: '',
        actions: [],
        allowedToBeDefaultMatch: false,
        isSearchType: false,
        isEnterpriseSearchAggregatorPeopleType: false,
        swapContentsAndDescription: false,
        supportsDeletion: false,
        suggestionGroupId: -1,
        contents: '',
        contentsClass: [{ offset: 0, style: 0 }],
        description: '',
        descriptionClass: [{ offset: 0, style: 0 }],
        destinationUrl: { url: '' },
        inlineAutocompletion: '',
        fillIntoEdit: '',
        iconPath: '',
        iconUrl: { url: '' },
        imageDominantColor: '',
        imageUrl: '',
        isNoncannedAimSuggestion: false,
        removeButtonA11yLabel: '',
        type: '',
        isRichSuggestion: false,
        isWeatherAnswerSuggestion: null,
        answer: null,
        tailSuggestCommonPrefix: null,
        hasInstantKeyword: false,
        keywordChipHint: '',
        keywordChipA11y: '',
    };
}
class SearchboxBrowserProxy {
    static getInstance() {
        return instance$g || (instance$g = new SearchboxBrowserProxy());
    }
    static setInstance(newInstance) {
        instance$g = newInstance;
    }
    handler;
    callbackRouter;
    constructor() {
        this.handler = PageHandler.getRemote();
        this.callbackRouter = new PageCallbackRouter();
        this.handler.setPage(this.callbackRouter.$.bindNewPipeAndPassRemote());
    }
}
let instance$g = null;

let instance$f = null;
function getCss$9() {
    return instance$f || (instance$f = [...[], css `.action-icon{--cr-icon-button-active-background-color:var(--color-new-tab-page-active-background);--cr-icon-button-fill-color:var(--color-searchbox-results-icon);--cr-icon-button-focus-outline-color:var(--color-searchbox-results-icon-focused-outline);--cr-icon-button-hover-background-color:var(--color-searchbox-results-button-hover);--cr-icon-button-icon-size:16px;--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0;--cr-icon-button-size:24px}`]);
}

let instance$e = null;
function getCss$8() {
    return instance$e || (instance$e = [...[getCss$d(), getCss$f(), getCss$9()], css `:host{display:block;outline:none}#actions-focus-border{overflow:hidden}#actions-focus-border:focus-within,#actions-focus-border:focus-within:has(#action:active),#actions-focus-border:has(#action.selected),#actions-focus-border:has(#keyword.selected){outline:2px solid var(--color-searchbox-results-action-chip-focus-outline);border-radius:10px;margin-inline-start:-2px}#actions-focus-border:has(#action:active){outline:none}.container{align-items:center;cursor:default;display:flex;overflow:hidden;padding-bottom:var(--cr-searchbox-match-padding,6px);padding-inline-end:16px;padding-inline-start:var(--cr-searchbox-match-padding-inline-start,12px);padding-top:var(--cr-searchbox-match-padding,6px);position:relative}.container+.container{flex-direction:row;margin-inline-start:40px;padding-top:0;padding-bottom:12px}:host([has-action]) .container{height:38px;padding-top:3px;padding-bottom:3px}:host([is-top-chrome-searchbox_]:is([has-action],[has-keyword])) .container{height:40px;padding-top:0;padding-bottom:0}:host(:not([is-lens-searchbox_])) .container:not(.actions){margin-inline-end:16px;border-start-end-radius:24px;border-end-end-radius:24px}:host-context([has-secondary-side]):host-context([can-show-secondary-side]) .container:not(.actions){margin-inline-end:0px}.container:not(.actions):hover{background-color:var(--color-searchbox-results-background-hovered)}:host(:is(:focus-visible,[selected])) .container:not(.actions){background-color:var(--color-searchbox-results-background-selected,var(--color-searchbox-results-background-hovered))}:host([enable-csb-motion-tweaks_][is-lens-searchbox_]) .container{height:48px;padding-bottom:0;padding-top:0}.actions.container{align-self:center;flex-grow:1;flex-shrink:0;padding-bottom:0;padding-inline-end:0px;padding-inline-start:0px;padding-top:0;display:none}:host-context(.vertical) .actions.container{display:flex}:host([has-action]) .actions.container{padding-inline-end:8px;padding-inline-start:8px}#contents,#description{overflow:hidden;text-overflow:ellipsis}#ellipsis{inset-inline-end:0;position:absolute}:host([show-thumbnail]) #ellipsis{position:relative}#focus-indicator{--searchbox-match-focus-indicator-width_:7px;background-color:var(--color-searchbox-results-focus-indicator);border-radius:3px;display:none;height:100%;inset-inline-start:round(up,calc(-1 * var(--searchbox-match-focus-indicator-width_) / 2),1px);position:absolute;width:var(--searchbox-match-focus-indicator-width_)}:host-context(.vertical):host(:is(:focus-visible,[selected]:not(:focus-within))) #focus-indicator:not(.selected-within){display:block}:host-context(cr-searchbox-match:-webkit-any(:focus-within,[selected])) #icon{--color-searchbox-search-icon-background:var(--color-searchbox-results-dim-selected)}#prefix{opacity:0}#separator{white-space:pre}#tail-suggest-prefix{position:relative}#text-container{align-items:center;display:flex;flex-grow:0;overflow:hidden;padding-inline-end:8px;padding-inline-start:var(--cr-searchbox-match-text-padding-inline-start,8px);white-space:nowrap}#suggestion{display:inherit;overflow:inherit;flex-direction:inherit;max-width:100%}:host([is-top-chrome-searchbox_]) #text-container #suggestion{display:inline-block;min-width:0;flex:1 1 auto;white-space:nowrap;text-overflow:ellipsis}:host([is-lens-searchbox_]) #text-container{display:-webkit-box;line-clamp:2;-webkit-line-clamp:2;-webkit-box-orient:vertical;white-space:normal}:host([has-action]) #text-container{padding-inline-end:4px}:host([is-rich-suggestion]) #text-container{align-items:flex-start;flex-direction:column}:host([is-rich-suggestion]) #separator{display:none}:host([is-rich-suggestion]) #contents,:host([is-rich-suggestion]) #description{width:100%}:host([is-rich-suggestion]) #description{font-size:.875em}.match{font-weight:var(--cr-searchbox-match-font-weight,600)}:host(:not([is-top-chrome-searchbox_])) #contents span:not(.match),#ellipsis{color:var(--color-searchbox-results-typed-prefix,--color-searchbox-results-foreground)}:host-context([has-empty-input]) #contents span,:host-context([has-empty-input]) #ellipsis{color:var(--color-searchbox-results-foreground)}#description,.dim{color:var(--color-searchbox-results-foreground-dimmed)}:host-context(cr-searchbox-match:-webkit-any(:focus-within,[selected])):host([is-entity-suggestion]) #description,:host-context(cr-searchbox-match:-webkit-any(:focus-within,[selected])) .dim{color:var(--color-searchbox-results-dim-selected)}#description:has(.url),.url{color:var(--color-searchbox-results-url)}:host-context(cr-searchbox-match:-webkit-any(:focus-within,[selected])) .url{color:var(--color-searchbox-results-url-selected)}#remove{display:none;margin-inline-end:1px}:host-context(cr-searchbox-match:-webkit-any(:focus-within,[selected])) #remove{--cr-icon-button-fill-color:var(--color-searchbox-results-icon-selected)}:host-context(cr-searchbox-match:-webkit-any(:focus-within,[selected])) #remove:hover{--cr-icon-button-hover-background-color:var(--color-searchbox-results-button-selected-hover)}:host-context(.vertical) .container:hover #remove,:host-context(cr-searchbox-match:-webkit-any(:focus-within,[selected])):host-context(.vertical) #remove{display:inline-flex}.selected:not(#action):not(#keyword){box-shadow:inset 0 0 0 2px var(--color-searchbox-results-icon-focused-outline)}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]),:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) .container{border-radius:16px}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) .container{box-sizing:border-box;flex-direction:column;margin-inline-end:0;padding:6px;padding-block-end:16px;width:102px;height:auto}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) .focus-indicator{display:none}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) #icon{--cr-searchbox-icon-border-radius:12px;--color-searchbox-results-icon-container-background:transparent;height:90px;margin-block-end:8px;width:90px}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) #text-container{padding:0;white-space:normal;width:100%}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) #contents,:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) #description{-webkit-box-orient:vertical;-webkit-line-clamp:2;display:-webkit-box;font-weight:400;overflow:hidden}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) #contents{font-size:13px;line-height:20px;margin-block-end:4px}:host-context(.secondary-side):host-context(.horizontal):host([is-entity-suggestion][has-image]) #description{font-size:12px;line-height:16px}`]);
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$8() {
    // clang-format off
    return html `<!--_html_template_start_-->
<div class="container" aria-hidden="true">
  <div id="focus-indicator" class="${this.getFocusIndicatorCssClass_()}"></div>
  <cr-searchbox-icon id="icon" .match="${this.match}"></cr-searchbox-icon>
  <div id="text-container">
    <span id="tail-suggest-prefix" ?hidden="${!this.tailSuggestPrefix_}">
      <span id="prefix">${this.tailSuggestPrefix_}</span>
      <!-- This is equivalent to AutocompleteMatch::kEllipsis which is
           prepended to the match content in other surfaces-->
      <span id="ellipsis">...&nbsp;</span>
    </span>
    <!-- When a thumbnail is in the searchbox all results should have an
         ellipsis prepended to the suggestion. -->
    <span id="ellipsis" ?hidden="${!this.showEllipsis}">...&nbsp;</span>
    <span id="suggestion">
      <span id="contents" .innerHTML="${this.contentsHtml_}"></span>
      <span id="separator" class="dim">${this.separatorText_}</span>
      <span id="description" .innerHTML="${this.descriptionHtml_}"></span>
    </span>
  </div>
  <div aria-hidden="true">
    ${this.match.keywordChipHint ? html `
      <div id="actions-focus-border">
        <cr-searchbox-action id="keyword"
            class="${this.getKeywordCssClass_()}"
            hint="${this.match.keywordChipHint}"
            icon-path="//resources/images/icon_search.svg"
            aria-label="${this.match.keywordChipA11y}"
            @execute-action="${this.onActivateKeyword_}"
            tabindex="1">
        </cr-searchbox-action>
      </div>
    ` : ''}
  </div>
  <div id="actions-container" class="actions container" aria-hidden="true">
    ${this.match.actions.map((item, index) => html `
      <div id="actions-focus-border">
        <cr-searchbox-action id="action"
            class="${this.getActionCssClass_(index)}"
            hint="${item.hint}"
            suggestion-contents="${item.suggestionContents}"
            icon-path="${item.iconPath}"
            aria-label="${item.a11yLabel}"
            action-index="${index}"
            @execute-action="${this.onExecuteAction_}" tabindex="2">
        </cr-searchbox-action>
      </div>
    `)}
  </div>
  <cr-icon-button id="remove"
      class="action-icon icon-clear ${this.getRemoveCssClass_()}"
      tabindex="3"
      aria-label="${this.removeButtonAriaLabel_}"
      title="${this.removeButtonTitle_}"
      ?hidden="${!this.match.supportsDeletion}"
      @click="${this.onRemoveButtonClick_}"
      @mousedown="${this.onRemoveButtonMouseDown_}">
  </cr-icon-button>
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Converts a time ticks in milliseconds to TimeTicks.
 * @param timeTicks time ticks in milliseconds
 */
function mojoTimeTicks(timeTicks) {
    return { internalValue: BigInt(Math.floor(timeTicks * 1000)) };
}
/** Converts a side type to a string to be used in CSS. */
function sideTypeToClass(sideType) {
    switch (sideType) {
        case SideType.kDefaultPrimary:
            return 'primary-side';
        case SideType.kSecondary:
            return 'secondary-side';
        default:
            assertNotReached('Unexpected side type');
    }
}
/** Converts a render type to a string to be used in CSS. */
function renderTypeToClass(renderType) {
    switch (renderType) {
        case RenderType.kDefaultVertical:
            return 'vertical';
        case RenderType.kHorizontal:
            return 'horizontal';
        case RenderType.kGrid:
            return 'grid';
        default:
            assertNotReached('Unexpected render type');
    }
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// clang-format off
/**
 * Bitmap used to decode the value of ACMatchClassification style
 * field.
 * See components/omnibox/browser/autocomplete_match.h.
 */
var AcMatchClassificationStyle;
(function (AcMatchClassificationStyle) {
    AcMatchClassificationStyle[AcMatchClassificationStyle["NONE"] = 0] = "NONE";
    AcMatchClassificationStyle[AcMatchClassificationStyle["URL"] = 1] = "URL";
    AcMatchClassificationStyle[AcMatchClassificationStyle["MATCH"] = 2] = "MATCH";
    AcMatchClassificationStyle[AcMatchClassificationStyle["DIM"] = 4] = "DIM";
})(AcMatchClassificationStyle || (AcMatchClassificationStyle = {}));
// clang-format on
const ENTITY_MATCH_TYPE = 'search-suggest-entity';
// Represents the initial selection when a match is created or reset.
const defaultSelection = {
    line: -1,
    state: SelectionLineState.kNormal,
    actionIndex: 0,
};
// Displays an autocomplete match.
class SearchboxMatchElement extends CrLitElement {
    static get is() {
        return 'cr-searchbox-match';
    }
    static get styles() {
        return getCss$8();
    }
    render() {
        return getHtml$8.bind(this)();
    }
    static get properties() {
        return {
            //========================================================================
            // Public properties
            //========================================================================
            /** Element's 'aria-label' attribute. */
            ariaLabel: { type: String },
            hasAction: {
                type: Boolean,
                reflect: true,
            },
            /**
             * Whether the match features an image (as opposed to an icon or favicon).
             */
            hasImage: {
                type: Boolean,
                reflect: true,
            },
            hasKeyword: {
                type: Boolean,
                reflect: true,
            },
            /**
             * Whether the match is an entity suggestion (with or without an image).
             */
            isEntitySuggestion: {
                type: Boolean,
                reflect: true,
            },
            /**
             * Whether the match should be rendered in a two-row layout. Currently
             * limited to matches that feature an image, calculator, and answers.
             */
            isRichSuggestion: {
                type: Boolean,
                reflect: true,
            },
            match: { type: Object },
            selection: { type: Object },
            /**
             * Index of the match in the autocomplete result. Used to inform embedder
             * of events such as deletion, click, etc.
             */
            matchIndex: { type: Number },
            showThumbnail: {
                type: Boolean,
                reflect: true,
            },
            showEllipsis: { type: Boolean },
            sideType: { type: Number },
            //========================================================================
            // Private properties
            //========================================================================
            isTopChromeSearchbox_: {
                type: Boolean,
                reflect: true,
            },
            isLensSearchbox_: {
                type: Boolean,
                reflect: true,
            },
            forceHideEllipsis_: { type: Boolean },
            /** Rendered match contents based on autocomplete provided styling. */
            contentsHtml_: { type: String },
            /** Rendered match description based on autocomplete provided styling. */
            descriptionHtml_: { type: String },
            enableCsbMotionTweaks_: {
                type: Boolean,
                reflect: true,
            },
            /** Remove button's 'aria-label' attribute. */
            removeButtonAriaLabel_: { type: String },
            removeButtonTitle_: { type: String },
            /** Used to separate the contents from the description. */
            separatorText_: { type: String },
            /** Rendered tail suggest common prefix. */
            tailSuggestPrefix_: { type: String },
        };
    }
    #ariaLabel_accessor_storage = '';
    get ariaLabel() { return this.#ariaLabel_accessor_storage; }
    set ariaLabel(value) { this.#ariaLabel_accessor_storage = value; }
    #hasAction_accessor_storage = false;
    get hasAction() { return this.#hasAction_accessor_storage; }
    set hasAction(value) { this.#hasAction_accessor_storage = value; }
    #hasImage_accessor_storage = false;
    get hasImage() { return this.#hasImage_accessor_storage; }
    set hasImage(value) { this.#hasImage_accessor_storage = value; }
    #hasKeyword_accessor_storage = false;
    get hasKeyword() { return this.#hasKeyword_accessor_storage; }
    set hasKeyword(value) { this.#hasKeyword_accessor_storage = value; }
    #isEntitySuggestion_accessor_storage = false;
    get isEntitySuggestion() { return this.#isEntitySuggestion_accessor_storage; }
    set isEntitySuggestion(value) { this.#isEntitySuggestion_accessor_storage = value; }
    #isRichSuggestion_accessor_storage = false;
    get isRichSuggestion() { return this.#isRichSuggestion_accessor_storage; }
    set isRichSuggestion(value) { this.#isRichSuggestion_accessor_storage = value; }
    #match_accessor_storage = createAutocompleteMatch();
    get match() { return this.#match_accessor_storage; }
    set match(value) { this.#match_accessor_storage = value; }
    #selection_accessor_storage = defaultSelection;
    get selection() { return this.#selection_accessor_storage; }
    set selection(value) { this.#selection_accessor_storage = value; }
    #matchIndex_accessor_storage = -1;
    get matchIndex() { return this.#matchIndex_accessor_storage; }
    set matchIndex(value) { this.#matchIndex_accessor_storage = value; }
    #sideType_accessor_storage = SideType.kDefaultPrimary;
    get sideType() { return this.#sideType_accessor_storage; }
    set sideType(value) { this.#sideType_accessor_storage = value; }
    #showThumbnail_accessor_storage = false;
    get showThumbnail() { return this.#showThumbnail_accessor_storage; }
    set showThumbnail(value) { this.#showThumbnail_accessor_storage = value; }
    #showEllipsis_accessor_storage = false;
    get showEllipsis() { return this.#showEllipsis_accessor_storage; }
    set showEllipsis(value) { this.#showEllipsis_accessor_storage = value; }
    #isTopChromeSearchbox__accessor_storage = loadTimeData.getBoolean('isTopChromeSearchbox');
    get isTopChromeSearchbox_() { return this.#isTopChromeSearchbox__accessor_storage; }
    set isTopChromeSearchbox_(value) { this.#isTopChromeSearchbox__accessor_storage = value; }
    #isLensSearchbox__accessor_storage = loadTimeData.getBoolean('isLensSearchbox');
    get isLensSearchbox_() { return this.#isLensSearchbox__accessor_storage; }
    set isLensSearchbox_(value) { this.#isLensSearchbox__accessor_storage = value; }
    #forceHideEllipsis__accessor_storage = loadTimeData.getBoolean('forceHideEllipsis');
    get forceHideEllipsis_() { return this.#forceHideEllipsis__accessor_storage; }
    set forceHideEllipsis_(value) { this.#forceHideEllipsis__accessor_storage = value; }
    #contentsHtml__accessor_storage = window.trustedTypes.emptyHTML;
    get contentsHtml_() { return this.#contentsHtml__accessor_storage; }
    set contentsHtml_(value) { this.#contentsHtml__accessor_storage = value; }
    #descriptionHtml__accessor_storage = window.trustedTypes.emptyHTML;
    get descriptionHtml_() { return this.#descriptionHtml__accessor_storage; }
    set descriptionHtml_(value) { this.#descriptionHtml__accessor_storage = value; }
    #enableCsbMotionTweaks__accessor_storage = loadTimeData.getBoolean('enableCsbMotionTweaks');
    get enableCsbMotionTweaks_() { return this.#enableCsbMotionTweaks__accessor_storage; }
    set enableCsbMotionTweaks_(value) { this.#enableCsbMotionTweaks__accessor_storage = value; }
    #removeButtonAriaLabel__accessor_storage = '';
    get removeButtonAriaLabel_() { return this.#removeButtonAriaLabel__accessor_storage; }
    set removeButtonAriaLabel_(value) { this.#removeButtonAriaLabel__accessor_storage = value; }
    #removeButtonTitle__accessor_storage = loadTimeData.getString('removeSuggestion');
    get removeButtonTitle_() { return this.#removeButtonTitle__accessor_storage; }
    set removeButtonTitle_(value) { this.#removeButtonTitle__accessor_storage = value; }
    #separatorText__accessor_storage = '';
    get separatorText_() { return this.#separatorText__accessor_storage; }
    set separatorText_(value) { this.#separatorText__accessor_storage = value; }
    #tailSuggestPrefix__accessor_storage = '';
    get tailSuggestPrefix_() { return this.#tailSuggestPrefix__accessor_storage; }
    set tailSuggestPrefix_(value) { this.#tailSuggestPrefix__accessor_storage = value; }
    pageHandler_;
    constructor() {
        super();
        this.pageHandler_ = SearchboxBrowserProxy.getInstance().handler;
    }
    firstUpdated() {
        this.addEventListener('click', (event) => this.onMatchClick_(event));
        this.addEventListener('focusin', () => this.onMatchFocusin_());
        this.addEventListener('mousedown', () => this.onMatchMouseDown_());
    }
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('match')) {
            this.ariaLabel = this.computeAriaLabel_();
            this.contentsHtml_ = this.computeContentsHtml_();
            this.descriptionHtml_ = this.computeDescriptionHtml_();
            this.hasAction = this.computeHasAction_();
            this.hasKeyword = this.computeHasKeyword_();
            this.hasImage = this.computeHasImage_();
            this.isEntitySuggestion = this.computeIsEntitySuggestion_();
            this.isRichSuggestion = this.computeIsRichSuggestion_();
            this.removeButtonAriaLabel_ = this.computeRemoveButtonAriaLabel_();
            this.separatorText_ = this.computeSeparatorText_();
            this.tailSuggestPrefix_ = this.computeTailSuggestPrefix_();
            this.selection = defaultSelection;
        }
        const changedPrivateProperties = changedProperties;
        if (changedProperties.has('showThumbnail') ||
            changedPrivateProperties.has('isLensSearchbox_') ||
            changedPrivateProperties.has('forceHideEllipsis_')) {
            this.showEllipsis = this.computeShowEllipsis_();
        }
    }
    //============================================================================
    // Event handlers
    //============================================================================
    onActivateKeyword_(e) {
        // Keyboard activation isn't possible because when the keyword chip is
        // focused, focus is redirected to the omnibox view.
        const event = e.detail.event;
        this.pageHandler_.activateKeyword(this.matchIndex, this.match.destinationUrl, mojoTimeTicks(Date.now()), 
        // Distinguish mouse and touch or pen events for logging purposes.
        event.pointerType === 'mouse');
    }
    /**
     * containing index of the action that was removed as well as modifier key
     * presses.
     */
    onExecuteAction_(e) {
        const event = e.detail.event;
        this.pageHandler_.executeAction(this.matchIndex, e.detail.actionIndex, this.match.destinationUrl, mojoTimeTicks(Date.now()), event.button || 0, event.altKey, event.ctrlKey, event.metaKey, event.shiftKey);
    }
    onMatchClick_(e) {
        if (e.button > 1) {
            // Only handle main (generally left) and middle button presses.
            return;
        }
        e.preventDefault(); // Prevents default browser action (navigation).
        e.stopPropagation(); // Prevents <iron-selector> from selecting the match.
        this.pageHandler_.openAutocompleteMatch(this.matchIndex, this.match.destinationUrl, 
        /* are_matches_showing */ true, e.button || 0, e.altKey, e.ctrlKey, e.metaKey, e.shiftKey);
        // Duplicates the logic in `ui::DispositionFromClick()`.
        const backgroundTab = (e.metaKey || e.ctrlKey) && e.shiftKey;
        // 'match-click' event is used to close the dropdown. Don't do so when
        // opening a background tab so users can open multiple matches.
        if (!backgroundTab) {
            this.fire('match-click');
        }
    }
    onMatchFocusin_() {
        this.fire('match-focusin', this.matchIndex);
    }
    onMatchMouseDown_() {
        this.pageHandler_.onNavigationLikely(this.matchIndex, this.match.destinationUrl, NavigationPredictor.kMouseDown);
    }
    onRemoveButtonClick_(e) {
        if (e.button !== 0) {
            // Only handle main (generally left) button presses.
            return;
        }
        e.preventDefault(); // Prevents default browser action (navigation).
        e.stopPropagation(); // Prevents <iron-selector> from selecting the match.
        this.pageHandler_.deleteAutocompleteMatch(this.matchIndex, this.match.destinationUrl);
    }
    onRemoveButtonMouseDown_(e) {
        e.preventDefault(); // Prevents default browser action (focus).
    }
    //============================================================================
    // Helpers
    //============================================================================
    computeAriaLabel_() {
        if (!this.match) {
            return '';
        }
        return this.match.a11yLabel;
    }
    /**
     * Sanitizes .innerHTML from `renderTextWithClassifications_()` through
     * `sanitizeInnerHtml` to ensure it only contains allowed tags.
     * @param innerHtml The .innerHTML from `renderTextWithClassifications_()`
     * @return Sanitized TrustedHTML safe for rendering
     */
    sanitizeInnerHtml_(innerHtml) {
        try {
            return sanitizeInnerHtml(innerHtml, { attrs: ['class'] });
        }
        catch (e) {
            // If sanitization fails return empty HTML.
            return window.trustedTypes.emptyHTML;
        }
    }
    computeContentsHtml_() {
        if (!this.match) {
            return window.trustedTypes.emptyHTML;
        }
        // `match.answer.firstLine` is generated by appending an optional additional
        // text from the answer's first line to `match.contents`, making the latter
        // a prefix of the former. Thus `match.answer.firstLine` can be rendered
        // using the markup in `match.contentsClass` which contains positions in
        // `match.contents` and the markup to be applied to those positions.
        // See //chrome/browser/ui/webui/searchbox/searchbox_handler.cc
        return this.sanitizeInnerHtml_(this.renderTextWithClassifications_(this.getMatchContents_(), this.getMatchContentsClassifications_())
            .innerHTML);
    }
    computeDescriptionHtml_() {
        if (!this.match) {
            return window.trustedTypes.emptyHTML;
        }
        return this.sanitizeInnerHtml_(this.renderTextWithClassifications_(this.getMatchDescription_(), this.match.answer ? [] :
            this.getMatchDescriptionClassifications_())
            .innerHTML);
    }
    computeHasAction_() {
        return this.match?.actions?.length > 0;
    }
    computeHasKeyword_() {
        return this.match && !!this.match.keywordChipHint;
    }
    computeHasImage_() {
        return this.match && !!this.match.imageUrl;
    }
    computeIsEntitySuggestion_() {
        return this.match && this.match.type === ENTITY_MATCH_TYPE;
    }
    computeIsRichSuggestion_() {
        // When the searchbox is embedded in the top-chrome (i.e. Omnibox), all
        // suggestions should be rendered using a one-line layout.
        return !this.isTopChromeSearchbox_ && this.match &&
            this.match.isRichSuggestion;
    }
    computeRemoveButtonAriaLabel_() {
        if (!this.match) {
            return '';
        }
        return this.match.removeButtonA11yLabel;
    }
    computeSeparatorText_() {
        return this.getMatchDescription_() ?
            loadTimeData.getString('searchboxSeparator') :
            '';
    }
    computeTailSuggestPrefix_() {
        if (!this.match || !this.match.tailSuggestCommonPrefix) {
            return '';
        }
        const prefix = this.match.tailSuggestCommonPrefix;
        // Replace last space with non breaking space since spans collapse
        // trailing white spaces and the prefix always ends with a white space.
        if (prefix.slice(-1) === ' ') {
            return prefix.slice(0, -1) + '\u00A0';
        }
        return prefix;
    }
    computeShowEllipsis_() {
        if (this.isLensSearchbox_ && this.forceHideEllipsis_) {
            return false;
        }
        return this.showThumbnail;
    }
    /**
     * Decodes the AcMatchClassificationStyle entries encoded in the given
     * ACMatchClassification style field, maps each entry to a CSS
     * class and returns them.
     */
    convertClassificationStyleToCssClasses_(style) {
        const classes = [];
        if (style & AcMatchClassificationStyle.DIM) {
            classes.push('dim');
        }
        if (style & AcMatchClassificationStyle.MATCH) {
            classes.push('match');
        }
        if (style & AcMatchClassificationStyle.URL) {
            classes.push('url');
        }
        return classes;
    }
    createSpanWithClasses_(text, classes) {
        const span = document.createElement('span');
        if (classes.length) {
            span.classList.add(...classes);
        }
        span.textContent = text;
        return span;
    }
    /**
     * Renders |text| based on the given ACMatchClassification(s)
     * Each classification contains an 'offset' and an encoded list of styles for
     * styling a substring starting with the 'offset' and ending with the next.
     * @return A <span> with <span> children for each styled substring.
     */
    renderTextWithClassifications_(text, classifications) {
        const container = document.createElement('span');
        // If no classifications are provided, render the entire text unstyled.
        if (classifications.length === 0) {
            container.appendChild(this.createSpanWithClasses_(text, []));
            return container;
        }
        // If the first classification doesn't start at 0, render the prefix text
        // unstyled. `AutocompleteMatch::ValidateClassifications()` guarantees the
        // first offset is 0, however this is only validated in debug builds.
        const firstClassification = classifications[0];
        if (firstClassification.offset > 0) {
            const prefix = text.substring(0, firstClassification.offset);
            container.appendChild(this.createSpanWithClasses_(prefix, []));
        }
        classifications.map(({ offset, style }, index) => {
            // Each classification defines a region from its offset to the next
            // classification's offset or end of string for the last one. This covers
            // the entire string with no gaps.
            const nextOffset = index + 1 < classifications.length ?
                classifications[index + 1].offset :
                text.length;
            const subString = text.substring(offset, nextOffset);
            const classes = this.convertClassificationStyleToCssClasses_(style);
            container.appendChild(this.createSpanWithClasses_(subString, classes));
        });
        return container;
    }
    getMatchContents_() {
        if (!this.match) {
            return '';
        }
        const match = this.match;
        const matchContents = match.answer ? match.answer.firstLine : match.contents;
        const matchDescription = match.answer ? match.answer.secondLine : match.description;
        return match.swapContentsAndDescription ? matchDescription : matchContents;
    }
    getMatchDescription_() {
        if (!this.match) {
            return '';
        }
        const match = this.match;
        const matchContents = match.answer ? match.answer.firstLine : match.contents;
        const matchDescription = match.answer ? match.answer.secondLine : match.description;
        return match.swapContentsAndDescription ? matchContents : matchDescription;
    }
    getMatchContentsClassifications_() {
        if (!this.match) {
            return [];
        }
        const match = this.match;
        return match.swapContentsAndDescription ? match.descriptionClass :
            match.contentsClass;
    }
    getMatchDescriptionClassifications_() {
        if (!this.match) {
            return [];
        }
        const match = this.match;
        return match.swapContentsAndDescription ? match.contentsClass :
            match.descriptionClass;
    }
    getFocusIndicatorCssClass_() {
        return this.selection.line === this.matchIndex &&
            this.selection.state !== SelectionLineState.kNormal &&
            !this.match.hasInstantKeyword ?
            'selected-within' :
            '';
    }
    getKeywordCssClass_() {
        return this.selection.line === this.matchIndex &&
            this.selection.state === SelectionLineState.kKeywordMode ?
            'selected' :
            '';
    }
    getActionCssClass_(actionIndex) {
        return this.selection.line === this.matchIndex &&
            this.selection.state === SelectionLineState.kFocusedButtonAction &&
            this.selection.actionIndex === actionIndex ?
            'selected' :
            '';
    }
    getRemoveCssClass_() {
        return this.selection.line === this.matchIndex &&
            this.selection.state ===
                SelectionLineState.kFocusedButtonRemoveSuggestion ?
            'selected' :
            '';
    }
}
customElements.define(SearchboxMatchElement.is, SearchboxMatchElement);

// ui/webui/resources/js/metrics_reporter/metrics_reporter.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PageMetricsHostPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'metrics_reporter.mojom.PageMetricsHost', scope);
    }
}
class PageMetricsHostRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageMetricsHostPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onPageRemoteCreated(page) {
        this.proxy.sendMessage(0, PageMetricsHost_OnPageRemoteCreated_ParamsSpec.$, null, [
            page
        ], false);
    }
    onGetMark(name) {
        return this.proxy.sendMessage(1, PageMetricsHost_OnGetMark_ParamsSpec.$, PageMetricsHost_OnGetMark_ResponseParamsSpec.$, [
            name
        ], false);
    }
    onClearMark(name) {
        this.proxy.sendMessage(2, PageMetricsHost_OnClearMark_ParamsSpec.$, null, [
            name
        ], false);
    }
    onUmaReportTime(name, time) {
        this.proxy.sendMessage(3, PageMetricsHost_OnUmaReportTime_ParamsSpec.$, null, [
            name,
            time
        ], false);
    }
}
class PageMetricsHost {
    static get $interfaceName() {
        return "metrics_reporter.mojom.PageMetricsHost";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageMetricsHostRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
class PageMetricsPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'metrics_reporter.mojom.PageMetrics', scope);
    }
}
class PageMetricsRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageMetricsPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onGetMark(name) {
        return this.proxy.sendMessage(0, PageMetrics_OnGetMark_ParamsSpec.$, PageMetrics_OnGetMark_ResponseParamsSpec.$, [
            name
        ], false);
    }
    onClearMark(name) {
        this.proxy.sendMessage(1, PageMetrics_OnClearMark_ParamsSpec.$, null, [
            name
        ], false);
    }
}
/**
 * An object which receives request messages for the PageMetrics
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class PageMetricsCallbackRouter {
    helper_internal_;
    $;
    router_;
    onGetMark;
    onClearMark;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageMetricsRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onGetMark =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageMetrics_OnGetMark_ParamsSpec.$, PageMetrics_OnGetMark_ResponseParamsSpec.$, this.onGetMark.createReceiverHandler(true /* expectsResponse */), false);
        this.onClearMark =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageMetrics_OnClearMark_ParamsSpec.$, null, this.onClearMark.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
const PageMetricsHost_OnPageRemoteCreated_ParamsSpec = { $: {} };
const PageMetricsHost_OnGetMark_ParamsSpec = { $: {} };
const PageMetricsHost_OnGetMark_ResponseParamsSpec = { $: {} };
const PageMetricsHost_OnClearMark_ParamsSpec = { $: {} };
const PageMetricsHost_OnUmaReportTime_ParamsSpec = { $: {} };
const PageMetrics_OnGetMark_ParamsSpec = { $: {} };
const PageMetrics_OnGetMark_ResponseParamsSpec = { $: {} };
const PageMetrics_OnClearMark_ParamsSpec = { $: {} };
mojo.internal.Struct(PageMetricsHost_OnPageRemoteCreated_ParamsSpec.$, 'PageMetricsHost_OnPageRemoteCreated_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageMetricsRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageMetricsHost_OnGetMark_ParamsSpec.$, 'PageMetricsHost_OnGetMark_Params', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageMetricsHost_OnGetMark_ResponseParamsSpec.$, 'PageMetricsHost_OnGetMark_ResponseParams', [
    mojo.internal.StructField('markedTime', 0, 0, TimeDeltaSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageMetricsHost_OnClearMark_ParamsSpec.$, 'PageMetricsHost_OnClearMark_Params', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageMetricsHost_OnUmaReportTime_ParamsSpec.$, 'PageMetricsHost_OnUmaReportTime_Params', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('time', 8, 0, TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageMetrics_OnGetMark_ParamsSpec.$, 'PageMetrics_OnGetMark_Params', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageMetrics_OnGetMark_ResponseParamsSpec.$, 'PageMetrics_OnGetMark_ResponseParams', [
    mojo.internal.StructField('markedTime', 0, 0, TimeDeltaSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageMetrics_OnClearMark_ParamsSpec.$, 'PageMetrics_OnClearMark_Params', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class BrowserProxyImpl {
    callbackRouter;
    host;
    constructor() {
        this.callbackRouter = new PageMetricsCallbackRouter();
        this.host = PageMetricsHost.getRemote();
        this.host.onPageRemoteCreated(this.callbackRouter.$.bindNewPipeAndPassRemote());
    }
    getMark(name) {
        return this.host.onGetMark(name);
    }
    clearMark(name) {
        this.host.onClearMark(name);
    }
    umaReportTime(name, time) {
        this.host.onUmaReportTime(name, time);
    }
    now() {
        return chrome.timeTicks.nowInMicroseconds();
    }
    getCallbackRouter() {
        return this.callbackRouter;
    }
    static getInstance() {
        return instance$d || (instance$d = new BrowserProxyImpl());
    }
    static setInstance(obj) {
        instance$d = obj;
    }
}
let instance$d = null;

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function timeFromMojo(delta) {
    return delta.microseconds;
}
function timeToMojo(mark) {
    return { microseconds: mark };
}
class MetricsReporterImpl {
    marks_ = new Map();
    browserProxy_ = BrowserProxyImpl.getInstance();
    constructor() {
        const callbackRouter = this.browserProxy_.getCallbackRouter();
        callbackRouter.onGetMark.addListener((name) => ({
            markedTime: this.marks_.has(name) ? timeToMojo(this.marks_.get(name)) : null,
        }));
        callbackRouter.onClearMark.addListener((name) => this.marks_.delete(name));
    }
    static getInstance() {
        return instance$c || (instance$c = new MetricsReporterImpl());
    }
    static setInstanceForTest(newInstance) {
        instance$c = newInstance;
    }
    mark(name, time) {
        this.marks_.set(name, time ?? this.browserProxy_.now());
    }
    async measure(startMark, endMark) {
        let endTime;
        if (endMark) {
            const entry = this.marks_.get(endMark);
            assert(entry, `Mark "${endMark}" does not exist locally.`);
            endTime = entry;
        }
        else {
            endTime = this.browserProxy_.now();
        }
        let startTime;
        if (this.marks_.has(startMark)) {
            startTime = this.marks_.get(startMark);
        }
        else {
            const remoteStartTime = await this.browserProxy_.getMark(startMark);
            assert(remoteStartTime.markedTime, `Mark "${startMark}" does not exist locally or remotely.`);
            startTime = timeFromMojo(remoteStartTime.markedTime);
        }
        return endTime - startTime;
    }
    async hasMark(name) {
        if (this.marks_.has(name)) {
            return true;
        }
        const remoteMark = await this.browserProxy_.getMark(name);
        return remoteMark !== null && remoteMark.markedTime !== null;
    }
    hasLocalMark(name) {
        return this.marks_.has(name);
    }
    clearMark(name) {
        this.marks_.delete(name);
        this.browserProxy_.clearMark(name);
    }
    umaReportTime(histogram, time) {
        this.browserProxy_.umaReportTime(histogram, timeToMojo(time));
    }
}
let instance$c = null;

let instance$b = null;
function getCss$7() {
    return instance$b || (instance$b = [...[getCss$f(), getCss$9()], css `:host{user-select:none}#content{background-color:var(--color-searchbox-results-background);border-radius:calc(0.5 * var(--cr-searchbox-height));box-shadow:var(--cr-searchbox-shadow);display:flex;gap:16px;margin-bottom:var(--cr-searchbox-results-margin-bottom,8px);overflow:hidden;padding-bottom:8px;padding-top:var(--cr-searchbox-height)}@media (forced-colors:active){#content{border:1px solid ActiveBorder}}.matches{display:contents}cr-searchbox-match{color:var(--color-searchbox-results-foreground)}cr-searchbox-match:-webkit-any(:focus-within,[selected]){color:var(--color-searchbox-results-foreground-selected)}.header{align-items:center;box-sizing:border-box;display:flex;font-size:inherit;font-weight:inherit;height:44px;margin-block-end:0;margin-block-start:0;outline:none;padding-bottom:6px;padding-inline-end:16px;padding-inline-start:var(--cr-searchbox-dropdown-header-padding-inline-start,12px);padding-top:6px}.header .text{color:var(--color-searchbox-results-foreground-dimmed);font-size:.875em;font-weight:500;overflow:hidden;padding-inline-end:1px;text-overflow:ellipsis;white-space:nowrap}@media (forced-colors:active){cr-searchbox-match:-webkit-any(:hover,:focus-within,[selected]){background-color:Highlight}}.primary-side{flex:1;min-width:0}:host-context([is-lens-searchbox_]) .primary-side::before{content:'';position:relative;height:1px;background-color:var(--color-searchbox-dropdown-divider);top:0;width:calc(var(--cr-searchbox-width) - 24px);display:block;inset-inline-start:12px;margin-block-end:4px}.secondary-side{display:var(--cr-searchbox-secondary-side-display,none);min-width:0;padding-block-end:8px;padding-inline-end:16px;width:314px}.secondary-side .header{padding-inline-end:0;padding-inline-start:0}.secondary-side .matches{display:block}.secondary-side .matches.horizontal{display:flex;gap:4px}`]);
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getMatchesForGroupHtml(sideType, groupId) {
    const hasHeader = this.hasHeaderForGroup_(groupId);
    // clang-format off
    const matchesHtml = html `
    <div class="matches ${this.renderTypeClassForGroup_(groupId)}">
    ${this.matchesForGroup_(groupId).map(match => html `
      <cr-searchbox-match tabindex="0" role="option"
          aria-describedby="${hasHeader ? `hg_${groupId}` : nothing}"
          .match="${match}" match-index="${this.matchIndex_(match)}"
          side-type="${sideType}"
          ?selected="${this.isSelected_(match)}"
          ?show-thumbnail="${this.showThumbnail}">
      </cr-searchbox-match>
    `)}
    </div>
  `;
    return hasHeader ? html `
    <!-- Header cannot be tabbed into but gets focus when clicked. This
        stops the dropdown from losing focus and closing as a result. -->
    <h3 class="header" data-id="${groupId}" tabindex="-1"
        id="hg_${groupId}"
        @mousedown="${this.onHeaderMousedown_}">
        <span class="text">${this.headerForGroup_(groupId)}</span>
    </h3>
    ${matchesHtml}` : matchesHtml;
    // clang-format on
}
function getHtml$7() {
    // clang-format off
    return html `<!--_html_template_start_-->
<div id="content" part="dropdown-content">
${this.sideTypes_().map(sideType => html `
  <div class="${this.sideTypeClass_(sideType)}">
    ${this.groupIdsForSideType_(sideType)
        .map(groupId => getMatchesForGroupHtml.bind(this)(sideType, groupId))}
  </div>
`)}
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// The '%' operator in JS returns negative numbers. This workaround avoids that.
const remainder = (lhs, rhs) => ((lhs % rhs) + rhs) % rhs;
// A dropdown element that contains autocomplete matches. Provides an API for
// the embedder (i.e., <cr-searchbox>) to change the selection.
class SearchboxDropdownElement extends CrLitElement {
    static get is() {
        return 'cr-searchbox-dropdown';
    }
    static get styles() {
        return getCss$7();
    }
    render() {
        return getHtml$7.bind(this)();
    }
    static get properties() {
        return {
            //========================================================================
            // Public properties
            //========================================================================
            /**
             * Whether the secondary side can be shown based on the feature state and
             * the width available to the dropdown.
             */
            canShowSecondarySide: { type: Boolean },
            /**
             * Whether the secondary side was at any point available to be shown.
             */
            hadSecondarySide: {
                type: Boolean,
                notify: true,
            },
            /*
             * Whether the secondary side is currently available to be shown.
             */
            hasSecondarySide: {
                type: Boolean,
                notify: true,
                reflect: true,
            },
            hasEmptyInput: {
                type: Boolean,
                reflect: true,
            },
            result: { type: Object },
            /** Index of the selected match. */
            selectedMatchIndex: {
                type: Number,
                notify: true,
            },
            showThumbnail: { type: Boolean },
            //========================================================================
            // Private properties
            //========================================================================
            /**
             * Computed value for whether or not the dropdown should show the
             * secondary side. This depends on whether the parent has set
             * `canShowSecondarySide` to true and whether there are visible primary
             * matches.
             */
            showSecondarySide_: { type: Boolean },
        };
    }
    #canShowSecondarySide_accessor_storage = false;
    get canShowSecondarySide() { return this.#canShowSecondarySide_accessor_storage; }
    set canShowSecondarySide(value) { this.#canShowSecondarySide_accessor_storage = value; }
    #hadSecondarySide_accessor_storage = false;
    get hadSecondarySide() { return this.#hadSecondarySide_accessor_storage; }
    set hadSecondarySide(value) { this.#hadSecondarySide_accessor_storage = value; }
    #hasSecondarySide_accessor_storage = false;
    get hasSecondarySide() { return this.#hasSecondarySide_accessor_storage; }
    set hasSecondarySide(value) { this.#hasSecondarySide_accessor_storage = value; }
    #hasEmptyInput_accessor_storage = false;
    get hasEmptyInput() { return this.#hasEmptyInput_accessor_storage; }
    set hasEmptyInput(value) { this.#hasEmptyInput_accessor_storage = value; }
    #result_accessor_storage = null;
    get result() { return this.#result_accessor_storage; }
    set result(value) { this.#result_accessor_storage = value; }
    #selectedMatchIndex_accessor_storage = -1;
    get selectedMatchIndex() { return this.#selectedMatchIndex_accessor_storage; }
    set selectedMatchIndex(value) { this.#selectedMatchIndex_accessor_storage = value; }
    #showThumbnail_accessor_storage = false;
    get showThumbnail() { return this.#showThumbnail_accessor_storage; }
    set showThumbnail(value) { this.#showThumbnail_accessor_storage = value; }
    #showSecondarySide__accessor_storage = false;
    get showSecondarySide_() { return this.#showSecondarySide__accessor_storage; }
    set showSecondarySide_(value) { this.#showSecondarySide__accessor_storage = value; }
    /** The list of selectable match elements. */
    selectableMatchElements_ = [];
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('result')) {
            this.hasSecondarySide = this.computeHasSecondarySide_();
            this.hasEmptyInput = this.computeHasEmptyInput_();
        }
        if (changedProperties.has('result') ||
            changedProperties.has('canShowSecondarySide')) {
            this.showSecondarySide_ = this.computeShowSecondarySide_();
        }
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        this.onResultRepaint_();
        // Update the list of selectable match elements.
        this.selectableMatchElements_ =
            [...this.shadowRoot.querySelectorAll('cr-searchbox-match')];
    }
    //============================================================================
    // Public methods
    //============================================================================
    /** Filters out secondary matches, if any, unless they can be shown. */
    get selectableMatchElements() {
        return this.selectableMatchElements_.filter(matchEl => matchEl.sideType === SideType.kDefaultPrimary ||
            this.showSecondarySide_);
    }
    /** Unselects the currently selected match, if any. */
    unselect() {
        this.selectedMatchIndex = -1;
    }
    /** Focuses the selected match, if any. */
    focusSelected() {
        this.selectableMatchElements[this.selectedMatchIndex]?.focus();
    }
    /** Selects the first match. */
    selectFirst() {
        this.selectedMatchIndex = 0;
        return this.updateComplete;
    }
    /** Selects the match at the given index. */
    selectIndex(index) {
        this.selectedMatchIndex = index;
        return this.updateComplete;
    }
    updateSelection(oldSelection, selection) {
        // If the updated selection is a new match, remove any remaining selection
        // on the previously selected match.
        if (oldSelection.line !== selection.line) {
            const oldMatch = this.selectableMatchElements[this.selectedMatchIndex];
            if (oldMatch) {
                oldMatch.selection = selection;
            }
        }
        this.selectIndex(selection.line);
        const newMatch = this.selectableMatchElements[this.selectedMatchIndex];
        if (newMatch) {
            newMatch.selection = selection;
        }
    }
    /**
     * Selects the previous match with respect to the currently selected one.
     * Selects the last match if the first one or no match is currently selected.
     */
    selectPrevious() {
        // The value of -1 for |this.selectedMatchIndex| indicates no selection.
        // Therefore subtract one from the maximum of its value and 0.
        const previous = Math.max(this.selectedMatchIndex, 0) - 1;
        this.selectedMatchIndex =
            remainder(previous, this.selectableMatchElements.length);
        return this.updateComplete;
    }
    /** Selects the last match. */
    selectLast() {
        this.selectedMatchIndex = this.selectableMatchElements.length - 1;
        return this.updateComplete;
    }
    /**
     * Selects the next match with respect to the currently selected one.
     * Selects the first match if the last one or no match is currently selected.
     */
    selectNext() {
        const next = this.selectedMatchIndex + 1;
        this.selectedMatchIndex =
            remainder(next, this.selectableMatchElements.length);
        return this.updateComplete;
    }
    //============================================================================
    // Event handlers
    //============================================================================
    onHeaderMousedown_(e) {
        e.preventDefault(); // Prevents default browser action (focus).
    }
    onResultRepaint_() {
        if (!loadTimeData.getBoolean('reportMetrics')) {
            return;
        }
        const metricsReporter = MetricsReporterImpl.getInstance();
        metricsReporter.measure('CharTyped')
            .then(duration => {
            metricsReporter.umaReportTime(loadTimeData.getString('charTypedToPaintMetricName'), duration);
        })
            .then(() => {
            metricsReporter.clearMark('CharTyped');
        })
            .catch(() => { }); // Fail silently if 'CharTyped' is not marked.
        metricsReporter.measure('ResultChanged')
            .then(duration => {
            metricsReporter.umaReportTime(loadTimeData.getString('resultChangedToPaintMetricName'), duration);
        })
            .then(() => {
            metricsReporter.clearMark('ResultChanged');
        })
            .catch(() => { }); // Fail silently if 'ResultChanged' is not marked.
    }
    //============================================================================
    // Helpers
    //============================================================================
    sideTypeClass_(side) {
        return sideTypeToClass(side);
    }
    renderTypeClassForGroup_(groupId) {
        return renderTypeToClass(this.result?.suggestionGroupsMap[groupId]?.renderType ??
            RenderType.kDefaultVertical);
    }
    computeHasSecondarySide_() {
        const hasSecondarySide = !!this.groupIdsForSideType_(SideType.kSecondary).length;
        if (!this.hadSecondarySide) {
            this.hadSecondarySide = hasSecondarySide;
        }
        return hasSecondarySide;
    }
    computeHasEmptyInput_() {
        return !!this.result && this.result.input === '';
    }
    isSelected_(match) {
        return this.matchIndex_(match) === this.selectedMatchIndex;
    }
    /**
     * @returns The unique suggestion group IDs that belong to the given side type
     *     while preserving the order in which they appear in the list of matches.
     */
    groupIdsForSideType_(side) {
        return [...new Set(this.result?.matches.map(match => match.suggestionGroupId)
                .filter(groupId => this.sideTypeForGroup_(groupId) === side))];
    }
    /**
     * @returns Whether the given suggestion group ID has a header.
     */
    hasHeaderForGroup_(groupId) {
        return !!this.headerForGroup_(groupId);
    }
    /**
     * @returns The header for the given suggestion group ID, if any.
     */
    headerForGroup_(groupId) {
        return this.result?.suggestionGroupsMap[groupId] ?
            this.result.suggestionGroupsMap[groupId].header :
            '';
    }
    /**
     * @returns Index of the match in the autocomplete result. Passed to the match
     *     so it knows its position in the list of matches.
     */
    matchIndex_(match) {
        return this.result?.matches.indexOf(match) ?? -1;
    }
    /**
     * @returns The list of visible matches that belong to the given suggestion
     *     group ID.
     */
    matchesForGroup_(groupId) {
        return (this.result?.matches ?? [])
            .filter(match => (match.suggestionGroupId === groupId && !match.isHidden));
    }
    /**
     * @returns The list of side types to show.
     */
    sideTypes_() {
        return this.showSecondarySide_ ?
            [SideType.kDefaultPrimary, SideType.kSecondary] :
            [SideType.kDefaultPrimary];
    }
    /**
     * @returns The side type for the given suggestion group ID.
     */
    sideTypeForGroup_(groupId) {
        return this.result?.suggestionGroupsMap[groupId]?.sideType ??
            SideType.kDefaultPrimary;
    }
    computeShowSecondarySide_() {
        if (!this.canShowSecondarySide) {
            // Parent prohibits showing secondary side.
            return false;
        }
        // Only show secondary side if there are primary matches visible.
        const primaryGroupIds = this.groupIdsForSideType_(SideType.kDefaultPrimary);
        return primaryGroupIds.some((groupId) => {
            return this.matchesForGroup_(groupId).length > 0;
        });
    }
}
customElements.define(SearchboxDropdownElement.is, SearchboxDropdownElement);

let instance$a = null;
function getCss$6() {
    return instance$a || (instance$a = [...[getCss$f()], css `:host{align-items:center;display:flex;flex-shrink:0;justify-content:center;outline:none}#container{align-items:center;aspect-ratio:1/1;border-radius:12px;display:flex;justify-content:center;overflow:hidden;position:relative;width:48px;height:40px}:host([enable-thumbnail-sizing-tweaks_]) #container{border-radius:8px;height:32px;width:40px}#image{display:initial;height:100%;object-fit:cover;user-select:none;width:100%}.overlay{position:absolute;justify-content:center;align-items:center;background-color:#0000000D;display:flex;width:100%;height:100%}:host([is-deletable_]:hover) .overlay,:host(:focus-visible) .overlay{background-color:var(--color-searchbox-thumbnail-overlay)}#remove{display:none}:host(:hover) #remove,:host(:focus-visible) #remove{display:flex}:host(:focus-visible) #container{border:solid 3px var(--color-searchbox-thumbnail-border);box-sizing:border-box}#remove{margin-inline-start:0px;margin-inline-end:0px;--cr-icon-button-fill-color:white;background-color:transparent}`]);
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$6() {
    // clang-format off
    return html `<!--_html_template_start_-->
<div id="container" aria-hidden="true">
  <img id="image" src="${this.thumbnailUrl_}">
  <div class="overlay">
    ${this.isDeletable_ ? html `
      <cr-icon-button id="remove" class="action-icon icon-clear"
          @click="${this.onRemoveButtonClick_}">
      </cr-icon-button>
    ` : ''}
  </div>
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Displays a thumbnail in the searchbox input.
class SearchboxThumbnailElement extends CrLitElement {
    static get is() {
        return 'cr-searchbox-thumbnail';
    }
    static get styles() {
        return getCss$6();
    }
    render() {
        return getHtml$6.bind(this)();
    }
    static get properties() {
        return {
            //========================================================================
            // Private properties
            //========================================================================
            thumbnailUrl_: { type: String },
            isDeletable_: {
                type: Boolean,
                reflect: true,
            },
            enableThumbnailSizingTweaks_: {
                type: Boolean,
                reflect: true,
            },
        };
    }
    #thumbnailUrl__accessor_storage = '';
    // The URL of the thumbnail to display.
    get thumbnailUrl_() { return this.#thumbnailUrl__accessor_storage; }
    set thumbnailUrl_(value) { this.#thumbnailUrl__accessor_storage = value; }
    #isDeletable__accessor_storage = false;
    // Whether the user can delete the thumbnail.
    get isDeletable_() { return this.#isDeletable__accessor_storage; }
    set isDeletable_(value) { this.#isDeletable__accessor_storage = value; }
    #enableThumbnailSizingTweaks__accessor_storage = loadTimeData.getBoolean('enableThumbnailSizingTweaks');
    // Whether to enable thumbnail sizing tweaks.
    get enableThumbnailSizingTweaks_() { return this.#enableThumbnailSizingTweaks__accessor_storage; }
    set enableThumbnailSizingTweaks_(value) { this.#enableThumbnailSizingTweaks__accessor_storage = value; }
    //============================================================================
    // Event handlers
    //============================================================================
    onRemoveButtonClick_(e) {
        e.preventDefault();
        this.fire('remove-thumbnail-click');
    }
}
customElements.define(SearchboxThumbnailElement.is, SearchboxThumbnailElement);

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const WebUiListenerMixinLit = (superClass) => {
    class WebUiListenerMixinLit extends superClass {
        /**
         * Holds WebUI listeners that need to be removed when this element is
         * destroyed.
         */
        webUiListeners_ = [];
        /**
         * Adds a WebUI listener and registers it for automatic removal when
         * this element is detached. Note: Do not use this method if you intend
         * to remove this listener manually (use addWebUiListener directly
         * instead).
         *
         * @param eventName The event to listen to.
         * @param callback The callback run when the event is fired.
         */
        addWebUiListener(eventName, callback) {
            this.webUiListeners_.push(addWebUiListener(eventName, callback));
        }
        disconnectedCallback() {
            super.disconnectedCallback();
            while (this.webUiListeners_.length > 0) {
                removeWebUiListener(this.webUiListeners_.pop());
            }
        }
    }
    return WebUiListenerMixinLit;
};

let instance$9 = null;
function getCss$5() {
    return instance$9 || (instance$9 = [...[getCss$f()], css `:host{--cr-searchbox-width:var(--cr-searchbox-min-width);--cr-searchbox-border-radius:calc(0.5 * var(--cr-searchbox-height));--cr-searchbox-icon-width:26px;--cr-searchbox-inner-icon-margin:8px;--cr-searchbox-voice-icon-offset:16px;--cr-searchbox-voice-search-button-width:0px;--cr-compose-button-width:104px;--cr-searchbox-icon-spacing:11px;border-radius:var(--cr-searchbox-border-radius);font-size:var(--cr-searchbox-font-size,16px);height:var(--cr-searchbox-height);width:var(--cr-searchbox-width);z-index:99}:host([is-lens-searchbox_]:not([dropdown-is-visible])){--cr-searchbox-shadow:none}:host([searchbox-chrome-refresh-theming][dropdown-is-visible]){--cr-searchbox-shadow:0 0 12px 4px var(--color-searchbox-shadow)}:host([searchbox-chrome-refresh-theming]:not([searchbox-steady-state-shadow]):not([dropdown-is-visible])){--cr-searchbox-shadow:none}:host-context([searchbox-width-behavior_='revert']):host([can-show-secondary-side]:not([dropdown-is-visible])){--cr-searchbox-width:var(--cr-searchbox-min-width)}:host([can-show-secondary-side][has-secondary-side]){--cr-searchbox-secondary-side-display:block}:host([is-dark]){--cr-searchbox-shadow:0 2px 6px 0 var(--color-searchbox-shadow)}:host([searchbox-voice-search-enabled_]){--cr-searchbox-voice-search-button-width:var(--cr-searchbox-icon-width)}:host([searchbox-lens-search-enabled_]){--cr-searchbox-voice-icon-offset:53px}@media (forced-colors:active){:host{border:1px solid ActiveBorder}}:host([dropdown-is-visible]:not([is-lens-searchbox_])){box-shadow:none}:host([match-searchbox]){box-shadow:none}:host([match-searchbox]:not([dropdown-is-visible]):hover){border:1px solid transparent;box-shadow:var(--cr-searchbox-shadow)}:host([match-searchbox]:not([is-dark]):not([dropdown-is-visible]):not(:hover)){border:1px solid var(--color-searchbox-border)}#inputWrapper{background-color:var(--color-searchbox-background);border-radius:var(--cr-searchbox-border-radius);box-shadow:var(--cr-searchbox-shadow);display:flex;flex-direction:column;height:auto;min-height:var(--cr-searchbox-height);overflow:hidden;position:relative;width:100%}:host([is-lens-searchbox_]) #inputWrapper{box-shadow:none}:host([multi-line-enabled]) textarea{background-color:transparent;box-sizing:border-box;field-sizing:content;line-height:24px;max-height:190px;overflow-y:auto;overflow-x:hidden;padding-top:calc((var(--cr-searchbox-height) - 24px) / 2);resize:none;scrollbar-width:none;white-space:pre-wrap}:host([multi-line-enabled]) #input::-webkit-scrollbar{display:none}:is(input,textarea){background-color:transparent;border:none;color:var(--color-searchbox-foreground);font-family:inherit;font-size:inherit;height:100%;outline:none;padding-top:20px;position:relative;width:100%}:host-context([searchbox-layout-mode='Compact']) :is(input,textarea){padding-inline-start:0}:host-context([multi-line-enabled][searchbox-layout-mode='Compact']) textarea{padding-bottom:10px;padding-top:16px}:host-context(:not([ntp-realbox-next-enabled])) input{align-self:center;padding-top:0}:host-context([searchbox-layout-mode='Compact']) input{padding-top:2px}:host([searchbox-chrome-refresh-theming]) :is(input,textarea)::selection{background-color:var(--color-searchbox-selection-background);color:var(--color-searchbox-selection-foreground)}input::-webkit-search-decoration,input::-webkit-search-results-button,input::-webkit-search-results-decoration{display:none}input::-webkit-search-cancel-button{appearance:none;margin:0}:is(input,textarea)::placeholder{color:var(--color-searchbox-placeholder);opacity:var(--placeholder-opacity);white-space:nowrap}:is(input,textarea):focus::placeholder{visibility:hidden}:host([is-lens-searchbox_]) :is(input,textarea):focus::placeholder{visibility:visible}:host([is-lens-searchbox_][dropdown-is-visible]) :is(input,textarea){background-color:var(--color-bubble-searchbox-results-input-background,--color-searchbox-results-background)}:host([is-lens-searchbox_]:not([dropdown-is-visible])) :is(input,textarea):focus{background-color:var(--color-searchbox-background)}cr-searchbox-icon{height:100%;padding-inline-end:4px;padding-inline-start:var(--cr-searchbox-icon-left-position);position:relative;top:var(--cr-searchbox-icon-top-position);pointer-events:none}:host(:not([ntp-realbox-next-enabled])) cr-searchbox-icon{align-self:center}@media (forced-colors:active){cr-searchbox-icon{background-color:Highlight;border-radius:4px}}:host-context([is-back-arrow-visible]) #icon{display:none}.searchbox-icon-button{background-color:transparent;background-position:center;background-repeat:no-repeat;background-size:21px 21px;border:none;border-radius:2px;cursor:pointer;height:100%;outline:none;padding:0;pointer-events:auto;position:static;right:16px;width:var(--cr-searchbox-icon-width)}.searchbox-icon-button-container{align-items:center;border-radius:50%;display:flex;flex-shrink:0;height:36px;justify-content:center;position:relative;width:36px;z-index:100}:host(:not([ntp-realbox-next-enabled])) .searchbox-icon-button-container{align-self:center}@media (forced-colors:active){.searchbox-icon-button-container{background-color:ButtonText}.searchbox-icon-button-container:focus-within{outline:2px solid Highlight;outline-offset:2px}}:host-context(.focus-outline-visible) .searchbox-icon-button-container:focus-within{box-shadow:0 0 0 2px var(--cr-focus-outline-color)}:host(:not([use-webkit-search-icons_])) #voiceSearchButton{background-image:url(//resources/cr_components/searchbox/icons/mic.svg)}:host(:not([use-webkit-search-icons_])) #lensSearchButton{background-image:url(//resources/cr_components/searchbox/icons/camera.svg)}:host([use-webkit-search-icons_]) #voiceSearchButton{-webkit-mask-image:url(//resources/cr_components/searchbox/icons/mic.svg)}:host([use-webkit-search-icons_]) #lensSearchButton{-webkit-mask-image:url(//resources/cr_components/searchbox/icons/camera.svg)}:host([use-webkit-search-icons_]) #voiceSearchButton,:host([use-webkit-search-icons_]) #lensSearchButton{-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:21px 21px;background-color:var(--color-searchbox-lens-voice-icon-background)}:host([use-webkit-search-icons_][compose-button-enabled]) #voiceSearchButton,:host([use-webkit-search-icons_][compose-button-enabled]) #lensSearchButton{background-color:#1F1F1F}:host([compose-button-enabled][searchbox-lens-search-enabled_]){--cr-searchbox-voice-icon-offset:calc(16px + 2 * var(--cr-searchbox-icon-spacing) + var(--cr-searchbox-icon-width) + var(--cr-compose-button-width))}:host([compose-button-enabled][dropdown-is-visible]) .searchbox-icon-button-container{display:none}:host([searchbox-layout-mode^='Tall']) contextual-entrypoint-and-carousel{z-index:100}:is(input,textarea),cr-searchbox-icon,.searchbox-icon-button{z-index:100}.truncate{overflow:hidden;text-overflow:ellipsis}#thumbnailContainer{align-self:center;padding-inline:10px;z-index:101}:host([ntp-realbox-next-enabled]) :is(input,textarea)::placeholder{font-size:18px;color:var(--cr-composebox-input-placeholder-color,var(--color-composebox-type-ahead));font-weight:400}:host([ntp-realbox-next-enabled]) :is(input,textarea):focus::placeholder{visibility:visible}:host([ntp-realbox-next-enabled]){--cr-searchbox-border-radius:26px;--cr-searchbox-dropdown-padding-bottom:12px;--cr-searchbox-icon-size:40px;--cr-searchbox-voice-lens-size:36px;--contextual-entrypoint-and-carousel-context-menu-container-padding-inline-start:0px;--text-input-inline-start-spacing:16px}cr-searchbox-dropdown::part(dropdown-content){background-color:unset;border-radius:unset;box-shadow:unset;gap:unset;margin-bottom:unset;overflow:unset;padding-top:unset}:host([ntp-realbox-next-enabled]) contextual-entrypoint-and-carousel::part(context-menu-entrypoint-icon){--cr-icon-button-icon-size:24px;--cr-icon-button-margin-start:2px;--cr-icon-button-size:36px}:host([ntp-realbox-next-enabled]:not([context-menu-glif-animation-state="ineligible"])) contextual-entrypoint-and-carousel::part(context-menu-entrypoint-icon){--cr-icon-button-margin-start:0px}:host([ntp-realbox-next-enabled][searchbox-layout-mode^='Tall']) contextual-entrypoint-and-carousel::part(context-menu-entrypoint-icon){--cr-icon-button-icon-size:20px}:host([ntp-realbox-next-enabled][searchbox-layout-mode='Compact']) contextual-entrypoint-and-carousel::part(context-menu-and-tools){padding-block:10px}:host([ntp-realbox-next-enabled]) contextual-entrypoint-and-carousel{position:relative}:host([ntp-realbox-next-enabled]) contextual-entrypoint-and-carousel::part(composebox-entrypoint){padding-inline-end:6px;z-index:100}:host-context([ntp-realbox-next-enabled][context-menu-glif-animation-state="ineligible"]) contextual-entrypoint-and-carousel::part(composebox-entrypoint){padding-inline-end:14px}:host([ntp-realbox-next-enabled]) contextual-entrypoint-and-carousel::part(tool-chips-container){--contextual-entrypoint-and-carousel-context-menu-container-margin-bottom:6px;position:relative;z-index:100}:host([ntp-realbox-next-enabled]) contextual-entrypoint-and-carousel::part(cr-composebox-file-carousel){margin-top:16px}:host([ntp-realbox-next-enabled]) .dropdownContainer,:host([ntp-realbox-next-enabled]) .contextualEntrypointContainer{overflow:visible}#inputContainer{background-color:var(--color-searchbox-background);border-radius:26px;box-shadow:var(--cr-searchbox-shadow);display:flex;flex-direction:column;width:100%}#inputInnerContainer{align-items:flex-start;display:flex;min-height:48px;position:relative;width:100%}:host([is-lens-searchbox_]) #inputInnerContainer{min-height:52px}:host([searchbox-layout-mode^='Tall']) #inputInnerContainer{padding-bottom:14px}#inputInnerBottomContainer{align-items:flex-start;display:flex;padding-bottom:10px;position:relative;width:100%}:host([ntp-realbox-next-enabled]) .contextualEntrypointContainer{left:unset;position:relative;right:unset;top:unset;width:100%}:host([ntp-realbox-next-enabled][dropdown-is-visible]),:host([ntp-realbox-next-enabled]:not([context-files-count_="0"])){box-shadow:none}:host([ntp-realbox-next-enabled]) #errorScrim{border-radius:23px}.searchbox-icon-button-container.lens{margin-inline-end:10px}.searchbox-icon-button-container.voice{margin-inline-end:4px}:host([ntp-realbox-next-enabled]) .searchbox-icon-button-container.lens:hover,:host([ntp-realbox-next-enabled]) .searchbox-icon-button-container.voice:hover{background-color:var(--color-new-tab-page-realbox-next-icon-hover);border-radius:50%}:host([searchbox-layout-mode^='Tall']){--cr-searchbox-compose-button-position-top:12px;--cr-searchbox-dropdown-padding-top:60px;--cr-searchbox-height:108px;--cr-searchbox-input-padding-top_:18px}@media (forced-colors:active){:host([searchbox-layout-mode^='Tall']) .dropdownContainer,:host([searchbox-layout-mode^='Tall']) .contextualEntrypointContainer{border:1px solid ActiveBorder}}:host([searchbox-layout-mode^='Tall']) input{height:44px;padding-top:14px}:host([multi-line-enabled][searchbox-layout-mode^='Tall']) textarea{height:auto;padding-top:var(--cr-searchbox-input-padding-top_)}:host([searchbox-layout-mode^='Tall']:not([dropdown-is-visible]):not([input-focused_])) :is(input,textarea){padding-inline-start:24px}:host([searchbox-layout-mode^='Tall']:not([dropdown-is-visible]):not([input-focused_])) cr-searchbox-icon,:host([searchbox-layout-mode^='Tall'][dropdown-is-visible]) .searchbox-icon-button-container{display:none}:host([searchbox-layout-mode^='Tall'][dropdown-is-visible]) cr-searchbox-icon,:host([searchbox-layout-mode^='Tall'][input-focused_]) cr-searchbox-icon{height:24px;top:var(--cr-searchbox-input-padding-top_)}:host-context([searchbox-layout-mode^='Tall']) #composeButton{--cr-button-height:36px}:host-context([searchbox-layout-mode='TallTopContext']) contextual-entrypoint-and-carousel::part(carousel-divider){margin-top:10px}:host([searchbox-layout-mode='Compact']){--cr-searchbox-border-radius:30px;--cr-searchbox-dropdown-padding-bottom:10px;--cr-searchbox-dropdown-padding-top:10px;--cr-searchbox-height:56px}:host([searchbox-layout-mode='Compact']) cr-searchbox-icon{display:none}:host([searchbox-layout-mode='Compact']) .searchbox-icon-button-container{top:10px}:host([searchbox-layout-mode='Compact'][compose-button-enabled] [searchbox-lens-search-enabled_]) .searchbox-icon-button-container.lens{inset-inline-end:calc(var(--cr-searchbox-icon-spacing) + var(--cr-compose-button-width))}:host([searchbox-layout-mode='Compact'][compose-button-enabled] [searchbox-lens-search-enabled_]) .searchbox-icon-button-container.voice{inset-inline-end:calc(var(--cr-searchbox-voice-lens-size) + var(--cr-searchbox-icon-spacing) + var(--cr-compose-button-width))}:host([ntp-realbox-next-enabled]) contextual-entrypoint-and-carousel::part(voice-icon){--cr-icon-button-fill-color:var(--color-composebox-font-light);--cr-icon-button-hover-background-color:var(--color-composebox-context-entrypoint-hover-background);--cr-icon-button-margin-end:0px;--cr-icon-button-margin-start:0px;--cr-icon-button-size:36px}:host([searchbox-layout-mode='TallBottomContext']) contextual-entrypoint-and-carousel::part(voice-icon){bottom:10px;inset-inline-end:14px;position:absolute}:host([searchbox-layout-mode='TallTopContext']) contextual-entrypoint-and-carousel::part(voice-icon){margin-inline-end:14px;margin-inline-start:auto;position:static}:host([searchbox-layout-mode='Compact']) contextual-entrypoint-and-carousel::part(voice-icon){margin-inline-end:calc(var(--cr-compose-button-width));margin-inline-start:auto;z-index:100}:host([searchbox-layout-mode="Compact"]){--search-animated-glow-drag-drop-placeholder-top:16px}:host([ntp-realbox-next-enabled][is-dragging-file]){--cr-searchbox-compose-button-z-index:99}:host([ntp-realbox-next-enabled][is-dragging-file]) :is(input,textarea),:host([ntp-realbox-next-enabled][is-dragging-file]) cr-searchbox-icon,:host([ntp-realbox-next-enabled][is-dragging-file]) .searchbox-icon-button-container,:host([ntp-realbox-next-enabled][is-dragging-file]) .searchbox-icon-button{opacity:0}#recentTabChipContainer{padding-bottom:10px;padding-inline:16px;padding-top:6px}:host([ntp-realbox-next-enabled][searchbox-layout-mode='Compact']) .contextualEntrypointContainerCompact{box-shadow:none;width:auto}`]);
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$5() {
    // clang-format off
    const compactLayout = this.ntpRealboxNextEnabled && this.searchboxLayoutMode === 'Compact';
    const dropdown = html `
    <cr-searchbox-dropdown id="matches" part="searchbox-dropdown"
        class="${!this.ntpRealboxNextEnabled ? 'dropdownContainer' : nothing}"
        exportparts="dropdown-content"
        role="listbox" .result="${this.result_}"
        selected-match-index="${this.selectedMatchIndex_}"
        @selected-match-index-changed="${this.onSelectedMatchIndexChanged_}"
        ?can-show-secondary-side="${this.canShowSecondarySide}"
        ?had-secondary-side="${this.hadSecondarySide}"
        @had-secondary-side-changed="${this.onHadSecondarySideChanged_}"
        ?has-secondary-side="${this.hasSecondarySide}"
        @has-secondary-side-changed="${this.onHasSecondarySideChanged_}"
        @match-focusin="${this.onMatchFocusin_}"
        @match-click="${this.onMatchClick_}"
        ?hidden="${!this.dropdownIsVisible}"
        ?show-thumbnail="${this.showThumbnail}">
    </cr-searchbox-dropdown>`;
    const contextualEntrypoint = html `
    <contextual-entrypoint-and-carousel id="context"
        part="contextual-entrypoint-and-carousel"
        exportparts="composebox-entrypoint, context-menu-entrypoint-icon, voice-icon, context-menu-and-tools"
        .tabSuggestions="${this.tabSuggestions_}"
        entrypoint-name="Realbox"
        @add-tab-context="${this.addTabContext_}"
        @add-file-context="${this.addFileContext_}"
        @on-file-validation-error="${this.onFileValidationError_}"
        @set-deep-search-mode="${this.setDeepSearchMode_}"
        @set-create-image-mode="${this.setCreateImageMode_}"
        @open-voice-search="${this.onVoiceSearchClick_}"
        @get-tab-preview="${this.getTabPreview_}"
        @context-menu-container-click="${this.onContextMenuContainerClick_}"
        ?show-dropdown="${this.dropdownIsVisible}"
        ?show-recent-tab-chip="${this.computeShowRecentTabChip_()}"
        ?show-voice-search="${this.shouldShowVoiceSearch_}"
        searchbox-layout-mode="${this.searchboxLayoutMode}"
        context-menu-glif-animation-state="${this.contextMenuGlifAnimationState}">
      ${!compactLayout ? dropdown : nothing}
    </contextual-entrypoint-and-carousel>`;
    const inputContent = html `
  <cr-searchbox-icon id="icon" .match="${this.selectedMatch_}"
      default-icon="${this.searchboxIcon_}" in-searchbox>
  </cr-searchbox-icon>
  ${this.showThumbnail ? html `
    <div id="thumbnailContainer">
      <cr-searchbox-thumbnail id="thumbnail" thumbnail-url_="${this.thumbnailUrl_}"
          ?is-deletable_="${this.isThumbnailDeletable_}"
          @remove-thumbnail-click="${this.onRemoveThumbnailClick_}"
          role="button" aria-label="${this.i18n('searchboxThumbnailLabel')}"
          tabindex="${this.getThumbnailTabindex_()}">
      </cr-searchbox-thumbnail>
    </div>
  ` : nothing}
  ${this.multiLineEnabled ? html `
    <textarea id="input" autocomplete="off"
        part="searchbox-input"
        spellcheck="false" aria-live="${this.inputAriaLive_}" role="combobox"
        aria-expanded="${this.dropdownIsVisible}" aria-controls="matches"
        aria-description="${this.searchboxAriaDescription}"
        placeholder="${this.computePlaceholderText_(this.placeholderText)}"
        @copy="${this.onInputCutCopy_}"
        @cut="${this.onInputCutCopy_}" @focus="${this.onInputFocus_}"
        @focusout="${this.onInputFocusout_}"
        @input="${this.onInputInput_}" @keydown="${this.onInputKeydown_}"
        @keyup="${this.onInputKeyup_}" @mousedown="${this.onInputMouseDown_}"
        @paste="${this.onInputPaste_}"></textarea>
  ` : html `
    <input id="input" class="truncate" type="search" autocomplete="off"
        part="searchbox-input"
        spellcheck="false" aria-live="${this.inputAriaLive_}" role="combobox"
        aria-expanded="${this.dropdownIsVisible}" aria-controls="matches"
        aria-description="${this.searchboxAriaDescription}"
        placeholder="${this.computePlaceholderText_(this.placeholderText)}"
        @copy="${this.onInputCutCopy_}"
        @cut="${this.onInputCutCopy_}" @focus="${this.onInputFocus_}"
        @focusout="${this.onInputFocusout_}"
        @input="${this.onInputInput_}" @keydown="${this.onInputKeydown_}"
        @keyup="${this.onInputKeyup_}" @mousedown="${this.onInputMouseDown_}"
        @paste="${this.onInputPaste_}">
    </input>
  `}`;
    const voiceSearchButton = html `
    ${this.searchboxVoiceSearchEnabled_ ? html `
      <div class="searchbox-icon-button-container voice">
        <button id="voiceSearchButton" class="searchbox-icon-button"
            @click="${this.onVoiceSearchClick_}"
            title="${this.i18n('voiceSearchButtonLabel')}">
        </button>
      </div>
    ` : nothing}`;
    const lensSearchButton = html `
    ${this.searchboxLensSearchEnabled_ ? html `
      <div class="searchbox-icon-button-container lens">
        <button id="lensSearchButton" class="searchbox-icon-button lens"
            @click="${this.onLensSearchClick_}"
            title="${this.i18n('lensSearchButtonLabel')}">
        </button>
      </div>
    ` : nothing}`;
    const composeButton = html `
    ${this.composeButtonEnabled ? html `
      <cr-searchbox-compose-button id="composeButton"
          @compose-click="${this.onComposeButtonClick_}">
      </cr-searchbox-compose-button>
    ` : nothing}`;
    return html `<!--_html_template_start_-->
<div id="inputWrapper" @focusout="${this.onInputWrapperFocusout_}"
    @keydown="${this.onInputWrapperKeydown_}"
    @dragenter="${this.dragAndDropHandler?.handleDragEnter}"
    @dragover="${this.dragAndDropHandler?.handleDragOver}"
    @dragleave="${this.dragAndDropHandler?.handleDragLeave}"
    @drop="${this.dragAndDropHandler?.handleDrop}">
  ${this.ntpRealboxNextEnabled ?
        html `
      <ntp-error-scrim id="errorScrim"
          ?compact-mode="${this.searchboxLayoutMode === 'Compact'}">
      </ntp-error-scrim>
      <search-animated-glow animation-state="${this.animationState}" part="animated-glow">
      </search-animated-glow>
      ${compactLayout ? html `
        <div id="inputInnerContainer">
          <div class="contextualEntrypointContainer contextualEntrypointContainerCompact">
            ${contextualEntrypoint}
          </div>
          ${inputContent}
          ${voiceSearchButton}
          ${lensSearchButton}
          ${composeButton}
        </div>
        <div class="dropdownContainer">
          ${dropdown}
          ${this.recentTabForChip_ && this.dropdownIsVisible && this.isInputEmpty() ? html `
          <div id="recentTabChipContainer">
            <composebox-recent-tab-chip
                .recentTab="${this.recentTabForChip_}"
                @add-tab-context="${this.addTabContext_}">
            </composebox-recent-tab-chip>
          </div>
          ` : nothing}
        </div>
      ` : html `
        <div id="inputInnerContainer">
          ${inputContent}
          ${composeButton}
        </div>
        <div id="inputInnerBottomContainer">
          <div class="contextualEntrypointContainer">
            ${contextualEntrypoint}
          </div>
          ${voiceSearchButton}
          ${lensSearchButton}
        </div>
      `}
    ` :
        html `
      <div id="inputInnerContainer">
        ${inputContent}
        ${voiceSearchButton}
        ${lensSearchButton}
        ${composeButton}
      </div>
      ${dropdown}
    `}
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// LINT.IfChange(GhostLoaderTagName)
const LENS_GHOST_LOADER_TAG_NAME = 'cr-searchbox-ghost-loader';
// LINT.ThenChange(/chrome/browser/resources/lens/shared/searchbox_ghost_loader.ts:GhostLoaderTagName)
const DESKTOP_CHROME_NTP_REALBOX_ENTRY_POINT_VALUE = '42';
const MULTILINE_INPUT_HEIGHT_THRESHOLD = 50;
// Register --placeholder-opacity as type <number> so that we can animate it.
CSS.registerProperty({
    name: '--placeholder-opacity',
    syntax: '<number>',
    initialValue: '1',
    inherits: true,
});
var AnimationState;
(function (AnimationState) {
    AnimationState[AnimationState["FADE_IN"] = 0] = "FADE_IN";
    AnimationState[AnimationState["HOLD"] = 1] = "HOLD";
    AnimationState[AnimationState["FADE_OUT"] = 2] = "FADE_OUT";
})(AnimationState || (AnimationState = {}));
/**
 * Responsible for cycling placeholder text animations on an HTMLInputElement.
 */
class PlaceholderTextCycler {
    input_;
    animation_ = null;
    placeholderTexts_ = [];
    placeholderTextsCurrentIndex_ = 0;
    changePlaceholderTextIntervalMs_ = 4000;
    fadePlaceholderTextDurationMs_ = 250;
    constructor(animatedPlaceholderContainer, placeholderTexts, changeTextAnimationIntervalMs, fadeTextAnimationDurationMs) {
        assert(placeholderTexts.length > 0);
        this.input_ = animatedPlaceholderContainer;
        this.placeholderTexts_ = placeholderTexts;
        this.changePlaceholderTextIntervalMs_ = changeTextAnimationIntervalMs;
        this.fadePlaceholderTextDurationMs_ = fadeTextAnimationDurationMs;
    }
    start() {
        this.stop();
        this.placeholderTextsCurrentIndex_ = 0;
        this.animate_(AnimationState.HOLD);
    }
    stop() {
        if (this.animation_) {
            this.animation_.cancel();
            this.animation_ = null;
        }
        this.placeholderTextsCurrentIndex_ = 0;
        this.input_.placeholder =
            this.placeholderTexts_[this.placeholderTextsCurrentIndex_];
    }
    animate_(state) {
        let animationDetails = null;
        switch (state) {
            case AnimationState.FADE_IN:
                this.input_.placeholder =
                    this.placeholderTexts_[this.placeholderTextsCurrentIndex_];
                animationDetails = {
                    startOpacity: 0,
                    endOpacity: 1,
                    duration: this.fadePlaceholderTextDurationMs_,
                    nextAnimationState: AnimationState.HOLD,
                };
                break;
            case AnimationState.HOLD:
                animationDetails = {
                    startOpacity: 1,
                    endOpacity: 1,
                    duration: this.changePlaceholderTextIntervalMs_,
                    nextAnimationState: AnimationState.FADE_OUT,
                };
                break;
            case AnimationState.FADE_OUT:
                this.placeholderTextsCurrentIndex_ =
                    (this.placeholderTextsCurrentIndex_ + 1) %
                        this.placeholderTexts_.length;
                animationDetails = {
                    startOpacity: 1,
                    endOpacity: 0,
                    duration: this.fadePlaceholderTextDurationMs_,
                    nextAnimationState: AnimationState.FADE_IN,
                };
                break;
        }
        this.animation_ = this.input_.animate([
            { '--placeholder-opacity': animationDetails.startOpacity },
            { '--placeholder-opacity': animationDetails.endOpacity },
        ], { duration: animationDetails.duration });
        this.animation_.onfinish = () => {
            if (this.animation_) {
                this.animate_(animationDetails.nextAnimationState);
            }
        };
    }
}
const SearchboxElementBase = I18nMixinLit(WebUiListenerMixinLit(CrLitElement));
/** A real search box that behaves just like the Omnibox. */
class SearchboxElement extends SearchboxElementBase {
    static get is() {
        return 'cr-searchbox';
    }
    static get styles() {
        return getCss$5();
    }
    render() {
        return getHtml$5.bind(this)();
    }
    static get properties() {
        return {
            //========================================================================
            // Public properties
            //========================================================================
            /**
             * Whether the secondary side can be shown based on the feature state and
             * the width available to the dropdown.
             */
            canShowSecondarySide: {
                type: Boolean,
                reflect: true,
            },
            colorSourceIsBaseline: {
                type: Boolean,
                reflect: true,
            },
            /** Whether the cr-searchbox-dropdown should be visible. */
            dropdownIsVisible: {
                type: Boolean,
                reflect: true,
            },
            /**
             * Whether the secondary side was at any point available to be shown.
             */
            hadSecondarySide: {
                type: Boolean,
                reflect: true,
                notify: true,
            },
            /*
             * Whether the secondary side is currently available to be shown.
             */
            hasSecondarySide: {
                type: Boolean,
                reflect: true,
            },
            /** Whether the theme is dark. */
            isDark: {
                type: Boolean,
                reflect: true,
            },
            /** Whether the searchbox should match the searchbox. */
            matchSearchbox: {
                type: Boolean,
                reflect: true,
            },
            multiLineEnabled: {
                type: Boolean,
                reflect: true,
            },
            /** The aria description to include on the input element. */
            searchboxAriaDescription: { type: String },
            /** Whether the Google Lens icon should be visible in the searchbox. */
            searchboxLensSearchEnabled: {
                type: Boolean,
                reflect: true,
            },
            searchboxChromeRefreshTheming: {
                type: Boolean,
                reflect: true,
            },
            searchboxSteadyStateShadow: {
                type: Boolean,
                reflect: true,
            },
            searchboxLayoutMode: {
                type: String,
                reflect: true,
            },
            ntpRealboxNextEnabled: {
                type: Boolean,
                reflect: true,
            },
            contextMenuGlifAnimationState: {
                type: String,
                reflect: true,
            },
            cyclingPlaceholders: {
                type: Boolean,
            },
            composeboxEnabled: { type: Boolean },
            composeButtonEnabled: { type: Boolean },
            placeholderText: {
                type: String,
                reflect: true,
                notify: true,
            },
            //========================================================================
            // Private properties
            //========================================================================
            inputFocused_: {
                type: Boolean,
                reflect: true,
            },
            isLensSearchbox_: {
                type: Boolean,
                reflect: true,
            },
            enableThumbnailSizingTweaks_: {
                type: Boolean,
                reflect: true,
            },
            /**
             * Whether user is deleting text in the input. Used to prevent the default
             * match from offering inline autocompletion.
             */
            isDeletingInput_: { type: Boolean },
            /**
             * The 'Enter' keydown event that was ignored due to matches being stale.
             * Used to navigate to the default match once up-to-date matches arrive.
             */
            lastIgnoredEnterEvent_: { type: Object },
            /**
             * Last state of the input (text and inline autocompletion). Updated
             * by the user input or by the currently selected autocomplete match.
             */
            lastInput_: { type: Object },
            /** The last queried input text. */
            lastQueriedInput_: { type: String },
            /**
             * True if user just pasted into the input. Used to prevent the default
             * match from offering inline autocompletion.
             */
            pastedInInput_: { type: Boolean },
            /** Searchbox default icon (i.e., Google G icon or the search loupe). */
            searchboxIcon_: { type: String },
            /** Whether the voice search icon should be visible in the searchbox. */
            searchboxVoiceSearchEnabled_: {
                type: Boolean,
                reflect: true,
            },
            /** Whether the Google Lens icon should be visible in the searchbox. */
            searchboxLensSearchEnabled_: {
                type: Boolean,
                reflect: true,
            },
            result_: { type: Object },
            /** The currently selected match, if any. */
            selectedMatch_: { type: Object },
            /**
             * Index of the currently selected match, if any.
             * Do not modify this. Use <cr-searchbox-dropdown> API to change
             * selection.
             */
            selectedMatchIndex_: { type: Number },
            showThumbnail: {
                type: Boolean,
                reflect: true,
            },
            thumbnailUrl_: { type: String },
            isThumbnailDeletable_: { type: Boolean },
            /** The value of the input element's 'aria-live' attribute. */
            inputAriaLive_: { type: String },
            useWebkitSearchIcons_: {
                type: Boolean,
                reflect: true,
            },
            tabSuggestions_: { type: Array },
            recentTabForChip_: { type: Object },
            isDraggingFile: {
                reflect: true,
                type: Boolean,
            },
            animationState: {
                reflect: true,
                type: String,
            },
        };
    }
    #canShowSecondarySide_accessor_storage = false;
    get canShowSecondarySide() { return this.#canShowSecondarySide_accessor_storage; }
    set canShowSecondarySide(value) { this.#canShowSecondarySide_accessor_storage = value; }
    #colorSourceIsBaseline_accessor_storage = false;
    get colorSourceIsBaseline() { return this.#colorSourceIsBaseline_accessor_storage; }
    set colorSourceIsBaseline(value) { this.#colorSourceIsBaseline_accessor_storage = value; }
    #dropdownIsVisible_accessor_storage = false;
    get dropdownIsVisible() { return this.#dropdownIsVisible_accessor_storage; }
    set dropdownIsVisible(value) { this.#dropdownIsVisible_accessor_storage = value; }
    #hadSecondarySide_accessor_storage = false;
    get hadSecondarySide() { return this.#hadSecondarySide_accessor_storage; }
    set hadSecondarySide(value) { this.#hadSecondarySide_accessor_storage = value; }
    #hasSecondarySide_accessor_storage = false;
    get hasSecondarySide() { return this.#hasSecondarySide_accessor_storage; }
    set hasSecondarySide(value) { this.#hasSecondarySide_accessor_storage = value; }
    #isDark_accessor_storage = false;
    get isDark() { return this.#isDark_accessor_storage; }
    set isDark(value) { this.#isDark_accessor_storage = value; }
    #matchSearchbox_accessor_storage = loadTimeData.getBoolean('searchboxMatchSearchboxTheme');
    get matchSearchbox() { return this.#matchSearchbox_accessor_storage; }
    set matchSearchbox(value) { this.#matchSearchbox_accessor_storage = value; }
    #multiLineEnabled_accessor_storage = false;
    get multiLineEnabled() { return this.#multiLineEnabled_accessor_storage; }
    set multiLineEnabled(value) { this.#multiLineEnabled_accessor_storage = value; }
    #searchboxAriaDescription_accessor_storage = '';
    get searchboxAriaDescription() { return this.#searchboxAriaDescription_accessor_storage; }
    set searchboxAriaDescription(value) { this.#searchboxAriaDescription_accessor_storage = value; }
    #searchboxLensSearchEnabled_accessor_storage = loadTimeData.getBoolean('searchboxLensSearch');
    get searchboxLensSearchEnabled() { return this.#searchboxLensSearchEnabled_accessor_storage; }
    set searchboxLensSearchEnabled(value) { this.#searchboxLensSearchEnabled_accessor_storage = value; }
    #searchboxChromeRefreshTheming_accessor_storage = loadTimeData.getBoolean('searchboxCr23Theming');
    get searchboxChromeRefreshTheming() { return this.#searchboxChromeRefreshTheming_accessor_storage; }
    set searchboxChromeRefreshTheming(value) { this.#searchboxChromeRefreshTheming_accessor_storage = value; }
    #searchboxSteadyStateShadow_accessor_storage = loadTimeData.getBoolean('searchboxCr23SteadyStateShadow');
    get searchboxSteadyStateShadow() { return this.#searchboxSteadyStateShadow_accessor_storage; }
    set searchboxSteadyStateShadow(value) { this.#searchboxSteadyStateShadow_accessor_storage = value; }
    #searchboxLayoutMode_accessor_storage = '';
    get searchboxLayoutMode() { return this.#searchboxLayoutMode_accessor_storage; }
    set searchboxLayoutMode(value) { this.#searchboxLayoutMode_accessor_storage = value; }
    #ntpRealboxNextEnabled_accessor_storage = false;
    get ntpRealboxNextEnabled() { return this.#ntpRealboxNextEnabled_accessor_storage; }
    set ntpRealboxNextEnabled(value) { this.#ntpRealboxNextEnabled_accessor_storage = value; }
    #contextMenuGlifAnimationState_accessor_storage = GlifAnimationState.INELIGIBLE;
    get contextMenuGlifAnimationState() { return this.#contextMenuGlifAnimationState_accessor_storage; }
    set contextMenuGlifAnimationState(value) { this.#contextMenuGlifAnimationState_accessor_storage = value; }
    #cyclingPlaceholders_accessor_storage = false;
    get cyclingPlaceholders() { return this.#cyclingPlaceholders_accessor_storage; }
    set cyclingPlaceholders(value) { this.#cyclingPlaceholders_accessor_storage = value; }
    #composeboxEnabled_accessor_storage = false;
    get composeboxEnabled() { return this.#composeboxEnabled_accessor_storage; }
    set composeboxEnabled(value) { this.#composeboxEnabled_accessor_storage = value; }
    #composeButtonEnabled_accessor_storage = false;
    get composeButtonEnabled() { return this.#composeButtonEnabled_accessor_storage; }
    set composeButtonEnabled(value) { this.#composeButtonEnabled_accessor_storage = value; }
    #showThumbnail_accessor_storage = false;
    get showThumbnail() { return this.#showThumbnail_accessor_storage; }
    set showThumbnail(value) { this.#showThumbnail_accessor_storage = value; }
    #placeholderText_accessor_storage = '';
    get placeholderText() { return this.#placeholderText_accessor_storage; }
    set placeholderText(value) { this.#placeholderText_accessor_storage = value; }
    #isDraggingFile_accessor_storage = false;
    get isDraggingFile() { return this.#isDraggingFile_accessor_storage; }
    set isDraggingFile(value) { this.#isDraggingFile_accessor_storage = value; }
    #animationState_accessor_storage = GlowAnimationState.NONE;
    get animationState() { return this.#animationState_accessor_storage; }
    set animationState(value) { this.#animationState_accessor_storage = value; }
    #inputAriaLive__accessor_storage = '';
    get inputAriaLive_() { return this.#inputAriaLive__accessor_storage; }
    set inputAriaLive_(value) { this.#inputAriaLive__accessor_storage = value; }
    #inputFocused__accessor_storage = false;
    get inputFocused_() { return this.#inputFocused__accessor_storage; }
    set inputFocused_(value) { this.#inputFocused__accessor_storage = value; }
    #isLensSearchbox__accessor_storage = loadTimeData.getBoolean('isLensSearchbox');
    get isLensSearchbox_() { return this.#isLensSearchbox__accessor_storage; }
    set isLensSearchbox_(value) { this.#isLensSearchbox__accessor_storage = value; }
    #enableThumbnailSizingTweaks__accessor_storage = loadTimeData.getBoolean('enableThumbnailSizingTweaks');
    get enableThumbnailSizingTweaks_() { return this.#enableThumbnailSizingTweaks__accessor_storage; }
    set enableThumbnailSizingTweaks_(value) { this.#enableThumbnailSizingTweaks__accessor_storage = value; }
    #isDeletingInput__accessor_storage = false;
    get isDeletingInput_() { return this.#isDeletingInput__accessor_storage; }
    set isDeletingInput_(value) { this.#isDeletingInput__accessor_storage = value; }
    #lastIgnoredEnterEvent__accessor_storage = null;
    get lastIgnoredEnterEvent_() { return this.#lastIgnoredEnterEvent__accessor_storage; }
    set lastIgnoredEnterEvent_(value) { this.#lastIgnoredEnterEvent__accessor_storage = value; }
    #lastInput__accessor_storage = { text: '', inline: '' };
    get lastInput_() { return this.#lastInput__accessor_storage; }
    set lastInput_(value) { this.#lastInput__accessor_storage = value; }
    #lastQueriedInput__accessor_storage = null;
    get lastQueriedInput_() { return this.#lastQueriedInput__accessor_storage; }
    set lastQueriedInput_(value) { this.#lastQueriedInput__accessor_storage = value; }
    #pastedInInput__accessor_storage = false;
    get pastedInInput_() { return this.#pastedInInput__accessor_storage; }
    set pastedInInput_(value) { this.#pastedInInput__accessor_storage = value; }
    #searchboxIcon__accessor_storage = loadTimeData.getString('searchboxDefaultIcon');
    get searchboxIcon_() { return this.#searchboxIcon__accessor_storage; }
    set searchboxIcon_(value) { this.#searchboxIcon__accessor_storage = value; }
    #searchboxVoiceSearchEnabled__accessor_storage = loadTimeData.getBoolean('searchboxVoiceSearch');
    get searchboxVoiceSearchEnabled_() { return this.#searchboxVoiceSearchEnabled__accessor_storage; }
    set searchboxVoiceSearchEnabled_(value) { this.#searchboxVoiceSearchEnabled__accessor_storage = value; }
    #searchboxLensSearchEnabled__accessor_storage = loadTimeData.getBoolean('searchboxLensSearch');
    get searchboxLensSearchEnabled_() { return this.#searchboxLensSearchEnabled__accessor_storage; }
    set searchboxLensSearchEnabled_(value) { this.#searchboxLensSearchEnabled__accessor_storage = value; }
    #result__accessor_storage = null;
    get result_() { return this.#result__accessor_storage; }
    set result_(value) { this.#result__accessor_storage = value; }
    #selectedMatch__accessor_storage = null;
    get selectedMatch_() { return this.#selectedMatch__accessor_storage; }
    set selectedMatch_(value) { this.#selectedMatch__accessor_storage = value; }
    #selectedMatchIndex__accessor_storage = -1;
    get selectedMatchIndex_() { return this.#selectedMatchIndex__accessor_storage; }
    set selectedMatchIndex_(value) { this.#selectedMatchIndex__accessor_storage = value; }
    #thumbnailUrl__accessor_storage = '';
    get thumbnailUrl_() { return this.#thumbnailUrl__accessor_storage; }
    set thumbnailUrl_(value) { this.#thumbnailUrl__accessor_storage = value; }
    #isThumbnailDeletable__accessor_storage = false;
    get isThumbnailDeletable_() { return this.#isThumbnailDeletable__accessor_storage; }
    set isThumbnailDeletable_(value) { this.#isThumbnailDeletable__accessor_storage = value; }
    #useWebkitSearchIcons__accessor_storage = false;
    get useWebkitSearchIcons_() { return this.#useWebkitSearchIcons__accessor_storage; }
    set useWebkitSearchIcons_(value) { this.#useWebkitSearchIcons__accessor_storage = value; }
    #tabSuggestions__accessor_storage = [];
    get tabSuggestions_() { return this.#tabSuggestions__accessor_storage; }
    set tabSuggestions_(value) { this.#tabSuggestions__accessor_storage = value; }
    #recentTabForChip__accessor_storage = null;
    get recentTabForChip_() { return this.#recentTabForChip__accessor_storage; }
    set recentTabForChip_(value) { this.#recentTabForChip__accessor_storage = value; }
    showVoiceSearchInExpandedRealbox = loadTimeData.getBoolean('expandedSearchboxShowVoiceSearch') ?? false;
    get shouldShowVoiceSearch_() {
        return this.dropdownIsVisible && this.showVoiceSearchInExpandedRealbox;
    }
    pageHandler_;
    callbackRouter_;
    dragAndDropHandler = null;
    dragAndDropEnabled_ = loadTimeData.getBoolean('composeboxContextDragAndDropEnabled');
    autocompleteResultChangedListenerId_ = null;
    inputTextChangedListenerId_ = null;
    thumbnailChangedListenerId_ = null;
    onTabStripChangedListenerId_ = null;
    placeholderCycler_ = null;
    constructor() {
        performance.mark('realbox-creation-start');
        super();
        this.pageHandler_ = SearchboxBrowserProxy.getInstance().handler;
        this.callbackRouter_ = SearchboxBrowserProxy.getInstance().callbackRouter;
    }
    async connectedCallback() {
        super.connectedCallback();
        this.autocompleteResultChangedListenerId_ =
            this.callbackRouter_.autocompleteResultChanged.addListener(this.onAutocompleteResultChanged_.bind(this));
        this.inputTextChangedListenerId_ =
            this.callbackRouter_.setInputText.addListener(this.onSetInputText_.bind(this));
        this.thumbnailChangedListenerId_ =
            this.callbackRouter_.setThumbnail.addListener(this.onSetThumbnail_.bind(this));
        this.onTabStripChangedListenerId_ =
            this.callbackRouter_.onTabStripChanged.addListener(this.refreshTabSuggestions_.bind(this));
        if (this.cyclingPlaceholders) {
            const { config } = await this.pageHandler_.getPlaceholderConfig();
            const texts = config.texts;
            assert(texts[0]);
            this.placeholderText = texts[0];
            this.placeholderCycler_ = new PlaceholderTextCycler(this.$.input, texts, Number(config.changeTextAnimationInterval.microseconds / 1000n), Number(config.fadeTextAnimationDuration.microseconds / 1000n));
            this.placeholderCycler_.start();
        }
        if (this.ntpRealboxNextEnabled) {
            this.dragAndDropHandler =
                new DragAndDropHandler(this, this.dragAndDropEnabled_);
            this.refreshTabSuggestions_();
        }
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        assert(this.autocompleteResultChangedListenerId_);
        this.callbackRouter_.removeListener(this.autocompleteResultChangedListenerId_);
        assert(this.inputTextChangedListenerId_);
        this.callbackRouter_.removeListener(this.inputTextChangedListenerId_);
        assert(this.thumbnailChangedListenerId_);
        this.callbackRouter_.removeListener(this.thumbnailChangedListenerId_);
        assert(this.onTabStripChangedListenerId_);
        this.callbackRouter_.removeListener(this.onTabStripChangedListenerId_);
        this.placeholderCycler_?.stop();
    }
    firstUpdated() {
        performance.measure('realbox-creation', 'realbox-creation-start');
    }
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('composeButtonEnabled') ||
            changedProperties.has('searchboxChromeRefreshTheming') ||
            changedProperties.has('colorSourceIsBaseline')) {
            this.useWebkitSearchIcons_ = this.composeButtonEnabled ||
                (this.searchboxChromeRefreshTheming && !this.colorSourceIsBaseline);
        }
        const changedPrivateProperties = changedProperties;
        if (changedPrivateProperties.has('result_') ||
            changedPrivateProperties.has('selectedMatchIndex_')) {
            this.selectedMatch_ = this.computeSelectedMatch_();
        }
        if (changedPrivateProperties.has('selectedMatch_')) {
            this.inputAriaLive_ = this.computeInputAriaLive_();
        }
        if (changedPrivateProperties.has('thumbnailUrl_')) {
            this.showThumbnail = !!this.thumbnailUrl_;
        }
        if (this.ntpRealboxNextEnabled) {
            if (changedPrivateProperties.has('inputFocused_')) {
                this.fire('searchbox-input-focus-changed', { value: this.inputFocused_ });
            }
        }
        if (changedPrivateProperties.has('tabSuggestions_')) {
            this.recentTabForChip_ =
                this.tabSuggestions_.find(tab => tab.showInCurrentTabChip) || null;
            if (!this.recentTabForChip_) {
                this.recentTabForChip_ =
                    this.tabSuggestions_.find(tab => tab.showInPreviousTabChip) || null;
            }
        }
    }
    computeInputAriaLive_() {
        return this.selectedMatch_ ? 'off' : 'polite';
    }
    getSuggestionsElement() {
        return this.$.matches;
    }
    getDropTarget() {
        return this.$.context;
    }
    isInputEmpty() {
        return !this.$.input.value.trim();
    }
    queryAutocomplete() {
        // Query autocomplete if dropdown is not visible
        if (this.dropdownIsVisible) {
            return;
        }
        this.queryAutocomplete_(this.$.input.value);
    }
    setInputText(text) {
        this.onSetInputText_(text);
    }
    focusInput() {
        this.$.input.focus();
    }
    selectAll() {
        this.$.input.select();
    }
    //============================================================================
    // Callbacks
    //============================================================================
    async onAutocompleteResultChanged_(result) {
        if (this.lastQueriedInput_ === null ||
            this.lastQueriedInput_.trimStart() !== result.input) {
            return; // Stale result; ignore.
        }
        this.result_ = result;
        const hasMatches = result.matches?.length > 0;
        const hasPrimaryMatches = result.matches?.some(match => {
            const sideType = result.suggestionGroupsMap[match.suggestionGroupId]?.sideType ||
                SideType.kDefaultPrimary;
            return sideType === SideType.kDefaultPrimary;
        });
        this.dropdownIsVisible = hasPrimaryMatches;
        if (this.multiLineEnabled) {
            const isUserTyping = result.input.trim().length > 0;
            const matchNum = result.matches?.length || 0;
            if (isUserTyping && (matchNum <= 1)) {
                this.dropdownIsVisible = false;
            }
        }
        const firstMatch = hasMatches ? this.result_.matches[0] : null;
        if (firstMatch && firstMatch.allowedToBeDefaultMatch) {
            // Select the default match and update the input.
            this.$.matches.selectFirst();
            this.updateInput_({
                text: this.lastQueriedInput_,
                inline: firstMatch.inlineAutocompletion,
            });
            // Navigate to the default up-to-date match if the user typed and pressed
            // 'Enter' too fast.
            if (this.lastIgnoredEnterEvent_) {
                this.navigateToMatch_(0, this.lastIgnoredEnterEvent_);
                this.lastIgnoredEnterEvent_ = null;
            }
        }
        else if (this.$.input.value.trim() && hasMatches &&
            this.selectedMatchIndex_ >= 0 &&
            this.selectedMatchIndex_ < this.result_.matches.length) {
            // Restore the selection and update the input. Don't restore when the
            // user deletes all their input and autocomplete is queried or else the
            // empty input will change to the value of the first result.
            await this.$.matches.selectIndex(this.selectedMatchIndex_);
            this.updateInput_({
                text: this.selectedMatch_.fillIntoEdit,
                inline: '',
                moveCursorToEnd: true,
            });
        }
        else {
            // Remove the selection and update the input.
            this.$.matches.unselect();
            this.updateInput_({
                inline: '',
            });
        }
    }
    onSetInputText_(inputText) {
        this.updateInput_({ text: inputText, inline: '' });
    }
    onSetThumbnail_(thumbnailUrl, isDeletable) {
        this.thumbnailUrl_ = thumbnailUrl;
        this.isThumbnailDeletable_ = isDeletable;
    }
    //============================================================================
    // Event handlers
    //============================================================================
    onInputCutCopy_(e) {
        // Only handle cut/copy when input has content and it's all selected.
        if (!this.$.input.value || this.$.input.selectionStart !== 0 ||
            this.$.input.selectionEnd !== this.$.input.value.length ||
            !this.result_ || this.result_.matches.length === 0) {
            return;
        }
        if (this.selectedMatch_ && !this.selectedMatch_.isSearchType) {
            e.clipboardData.setData('text/plain', this.selectedMatch_.destinationUrl.url);
            e.preventDefault();
            if (e.type === 'cut') {
                this.updateInput_({ text: '', inline: '' });
                this.clearAutocompleteMatches_();
            }
        }
    }
    onInputFocus_() {
        this.inputFocused_ = true;
        this.pageHandler_.onFocusChanged(true);
        this.placeholderCycler_?.stop();
    }
    onInputFocusout_() {
        this.inputFocused_ = false;
    }
    onInputInput_(e) {
        const inputValue = this.$.input.value;
        const lastInputValue = this.lastInput_.text + this.lastInput_.inline;
        if (lastInputValue === inputValue) {
            return;
        }
        this.updateInput_({ text: inputValue, inline: '' });
        // If a character has been typed, mark 'CharTyped'. Otherwise clear it. If
        // 'CharTyped' mark already exists, there's a pending typed character for
        // which the results have not been painted yet. In that case, keep the
        // earlier mark.
        if (loadTimeData.getBoolean('reportMetrics')) {
            const charTyped = !this.isDeletingInput_ && !!inputValue.trim();
            const metricsReporter = MetricsReporterImpl.getInstance();
            if (charTyped) {
                if (!metricsReporter.hasLocalMark('CharTyped')) {
                    metricsReporter.mark('CharTyped');
                }
            }
            else {
                metricsReporter.clearMark('CharTyped');
            }
        }
        // For lens searchboxes, requery autcomplete for all updates to the input
        // (even if the input is empty).
        if (inputValue.trim() || this.isLensSearchbox_) {
            // TODO(crbug.com/40732045): Rather than disabling inline autocompletion
            // when the input event is fired within a composition session, change the
            // mechanism via which inline autocompletion is shown in the searchbox.
            this.queryAutocomplete_(inputValue, e.isComposing);
        }
        else {
            this.clearAutocompleteMatches_();
        }
        this.pastedInInput_ = false;
    }
    onInputKeydown_(e) {
        // Ignore this event if the input does not have any inline autocompletion.
        if (!this.lastInput_.inline) {
            return;
        }
        const inputValue = this.$.input.value;
        const inputSelection = inputValue.substring(this.$.input.selectionStart, this.$.input.selectionEnd);
        const lastInputValue = this.lastInput_.text + this.lastInput_.inline;
        // If the current input state (its value and selection) matches its last
        // state (text and inline autocompletion) and the user types the next
        // character in the inline autocompletion, stop the keydown event. Just move
        // the selection and requery autocomplete. This is needed to avoid flicker.
        if (inputSelection === this.lastInput_.inline &&
            inputValue === lastInputValue &&
            this.lastInput_.inline[0].toLocaleLowerCase() ===
                e.key.toLocaleLowerCase()) {
            const text = this.lastInput_.text + e.key;
            assert(text);
            this.updateInput_({
                text: text,
                inline: this.lastInput_.inline.substr(1),
            });
            // If 'CharTyped' mark already exists, there's a pending typed character
            // for which the results have not been painted yet. In that case, keep the
            // earlier mark.
            if (loadTimeData.getBoolean('reportMetrics')) {
                const metricsReporter = MetricsReporterImpl.getInstance();
                if (!metricsReporter.hasLocalMark('CharTyped')) {
                    metricsReporter.mark('CharTyped');
                }
            }
            this.queryAutocomplete_(this.lastInput_.text);
            e.preventDefault();
        }
    }
    onInputKeyup_(e) {
        if (e.key !== 'Tab' || this.dropdownIsVisible) {
            return;
        }
        // Query autocomplete if user is tabbing into an empty input or a non-empty
        // input if thumbnail is showing.
        if (!this.$.input.value || this.showThumbnail) {
            this.queryAutocomplete_(this.$.input.value);
        }
    }
    onInputMouseDown_(e) {
        // Non-main (generally left) mouse clicks are ignored.
        if (e && e.button !== 0) {
            return;
        }
        this.inputFocused_ = true;
        // Query autocomplete if dropdown is not visible
        if (this.dropdownIsVisible) {
            return;
        }
        this.queryAutocomplete_(this.$.input.value);
    }
    onInputPaste_(e) {
        if (this.ntpRealboxNextEnabled && e.clipboardData?.files &&
            e.clipboardData.files.length > 0) {
            const files = Array.from(e.clipboardData.files);
            if (files.length > 0) {
                e.preventDefault();
                const dataTransfer = new DataTransfer();
                files.forEach(file => dataTransfer.items.add(file));
                this.$.context.addPastedFiles(dataTransfer.files);
                return;
            }
        }
        this.pastedInInput_ = true;
    }
    onInputWrapperFocusout_(e) {
        const newlyFocusedEl = e.relatedTarget;
        // Hide the matches and stop autocomplete only when the focus goes outside
        // of the searchbox wrapper. If focus is still in the searchbox wrapper,
        // exit early.
        if (this.$.inputWrapper.contains(newlyFocusedEl)) {
            return;
        }
        // If this is a Lens searchbox, treat the ghost loader as keeping searchbox
        // focus.
        // TODO(380467089): This workaround wouldn't be needed if the ghost loader
        // was part of the searchbox element. Remove this workaround once they are
        // combined.
        if (this.isLensSearchbox_ &&
            newlyFocusedEl?.tagName.toLowerCase() === LENS_GHOST_LOADER_TAG_NAME) {
            return;
        }
        if (this.lastQueriedInput_ === '') {
            // Clear the input as well as the matches if the input was empty when
            // the matches arrived.
            this.updateInput_({ text: '', inline: '' });
            this.clearAutocompleteMatches_();
        }
        else {
            this.dropdownIsVisible = false;
            // Stop autocomplete but leave (potentially stale) results and continue
            // listening for key presses. These stale results should never be shown.
            // They correspond to the potentially stale suggestion left in the
            // searchbox when blurred. That stale result may be navigated to by
            // focusing and pressing 'Enter'.
            this.pageHandler_.stopAutocomplete(/*clearResult=*/ false);
        }
        this.pageHandler_.onFocusChanged(false);
        this.placeholderCycler_?.start();
    }
    async onInputWrapperKeydown_(e) {
        const KEYDOWN_HANDLED_KEYS = [
            'ArrowDown',
            'ArrowUp',
            'Backspace',
            'Delete',
            'Enter',
            'Escape',
            'PageDown',
            'PageUp',
            'Tab',
        ];
        if (!KEYDOWN_HANDLED_KEYS.includes(e.key)) {
            return;
        }
        if (e.defaultPrevented) {
            // Ignore previously handled events.
            return;
        }
        if (this.showThumbnail) {
            const thumbnail = this.shadowRoot.querySelector('cr-searchbox-thumbnail');
            if (thumbnail === this.shadowRoot.activeElement) {
                if (e.key === 'Backspace' || e.key === 'Enter') {
                    // Remove thumbnail, focus input, and notify browser.
                    this.thumbnailUrl_ = '';
                    this.$.input.focus();
                    this.clearAutocompleteMatches_();
                    this.pageHandler_.onThumbnailRemoved();
                    const inputValue = this.$.input.value;
                    // Clearing the autocomplete matches above doesn't allow for
                    // navigation directly after removing the thumbnail. Must manually
                    // query autocomplete after removing the thumbnail since the
                    // thumbnail isn't part of the text input.
                    this.queryAutocomplete_(inputValue);
                    e.preventDefault();
                }
                else if (e.key === 'Tab' && !e.shiftKey) {
                    this.$.input.focus();
                    e.preventDefault();
                }
                else if (this.dropdownIsVisible &&
                    (e.key === 'ArrowUp' || e.key === 'ArrowDown')) {
                    // If the dropdown is visible, arrowing up and down unfocuses the
                    // thumbnail and follows standard arrow up/down behavior (selects
                    // the next/previous match).
                    this.$.input.focus();
                }
            }
            else if (this.isThumbnailDeletable_ && this.$.input.selectionStart === 0 &&
                this.$.input.selectionEnd === 0 &&
                this.$.input === this.shadowRoot.activeElement &&
                (e.key === 'Backspace' || (e.key === 'Tab' && e.shiftKey))) {
                // Backspacing or shift-tabbing the thumbnail results in the thumbnail
                // being focused.
                thumbnail?.focus();
                e.preventDefault();
            }
        }
        if (this.composeButtonEnabled && e.key === 'Tab' &&
            this.lastInput_.inline &&
            this.$.input === this.shadowRoot.activeElement) {
            if (e.shiftKey) {
                this.updateInput_({ inline: '' });
                return;
            }
            const newText = this.lastInput_.text + this.lastInput_.inline;
            this.updateInput_({
                text: newText,
                inline: '',
                moveCursorToEnd: true,
            });
            this.queryAutocomplete_(newText);
            e.preventDefault();
            return;
        }
        if (e.key === 'Backspace' || e.key === 'Tab') {
            return;
        }
        const matchNum = this.result_?.matches.length || 0;
        const isMultiline = this.$.input.scrollHeight > MULTILINE_INPUT_HEIGHT_THRESHOLD;
        // ArrowUp/ArrowDown query autocomplete when matches are not visible.
        if (!this.dropdownIsVisible) {
            if (e.key === 'ArrowUp' || e.key === 'ArrowDown') {
                if (isMultiline || matchNum <= 1) {
                    return;
                }
                const inputValue = this.$.input.value;
                if (inputValue.trim() || !inputValue) {
                    this.queryAutocomplete_(inputValue);
                }
                e.preventDefault();
                return;
            }
        }
        if (e.key === 'Escape') {
            this.dispatchEvent(new CustomEvent('escape-searchbox', {
                bubbles: true,
                composed: true,
                detail: {
                    event: e,
                    emptyInput: !this.$.input.value,
                },
            }));
        }
        // Do not handle the following keys if there are no matches available.
        if (!this.result_ || this.result_.matches.length === 0) {
            return;
        }
        if (e.key === 'Delete') {
            if (e.shiftKey && !e.altKey && !e.ctrlKey && !e.metaKey) {
                if (this.selectedMatch_ && this.selectedMatch_.supportsDeletion) {
                    this.pageHandler_.deleteAutocompleteMatch(this.selectedMatchIndex_, this.selectedMatch_.destinationUrl);
                    e.preventDefault();
                }
            }
            return;
        }
        // Do not handle the following keys if inside an IME composition session.
        if (e.isComposing) {
            return;
        }
        if (e.key === 'Enter') {
            if (this.multiLineEnabled && e.shiftKey) {
                return;
            }
            const array = [this.$.matches, this.$.input];
            if (array.includes(e.target)) {
                if (this.lastQueriedInput_ !== null &&
                    this.lastQueriedInput_.trimStart() === this.result_.input) {
                    if (this.selectedMatch_) {
                        this.navigateToMatch_(this.selectedMatchIndex_, e);
                    }
                }
                else {
                    // User typed and pressed 'Enter' too quickly. Ignore this for now
                    // because the matches are stale. Navigate to the default match (if
                    // one exists) once the up-to-date matches arrive.
                    this.lastIgnoredEnterEvent_ = e;
                    e.preventDefault();
                }
            }
            return;
        }
        // Do not handle the following keys if there are key modifiers.
        if (hasKeyModifiers(e)) {
            return;
        }
        // Clear the input as well as the matches when 'Escape' is pressed if the
        // the first match is selected or there are no selected matches.
        if (e.key === 'Escape' && this.selectedMatchIndex_ <= 0) {
            this.updateInput_({ text: '', inline: '' });
            this.clearAutocompleteMatches_();
            e.preventDefault();
            return;
        }
        e.preventDefault();
        if (e.key === 'ArrowDown') {
            await this.$.matches.selectNext();
            this.pageHandler_.onNavigationLikely(this.selectedMatchIndex_, this.selectedMatch_.destinationUrl, NavigationPredictor.kUpOrDownArrowButton);
        }
        else if (e.key === 'ArrowUp') {
            await this.$.matches.selectPrevious();
            this.pageHandler_.onNavigationLikely(this.selectedMatchIndex_, this.selectedMatch_.destinationUrl, NavigationPredictor.kUpOrDownArrowButton);
        }
        else if (e.key === 'Escape' || e.key === 'PageUp') {
            await this.$.matches.selectFirst();
        }
        else if (e.key === 'PageDown') {
            await this.$.matches.selectLast();
        }
        // Focus the selected match if focus is currently in the matches.
        if (this.shadowRoot.activeElement === this.$.matches) {
            this.$.matches.focusSelected();
        }
        // Update the input.
        const newFill = this.selectedMatch_.fillIntoEdit;
        const newInline = this.selectedMatchIndex_ === 0 &&
            this.selectedMatch_.allowedToBeDefaultMatch ?
            this.selectedMatch_.inlineAutocompletion :
            '';
        const newFillEnd = newFill.length - newInline.length;
        const text = newFill.substr(0, newFillEnd);
        assert(text);
        this.updateInput_({
            text: text,
            inline: newInline,
            moveCursorToEnd: newInline.length === 0,
        });
    }
    /**
     * @param e Event containing index of the match that received focus.
     */
    async onMatchFocusin_(e) {
        // Select the match that received focus.
        await this.$.matches.selectIndex(e.detail);
        // Input selection (if any) likely drops due to focus change. Simply fill
        // the input with the match and move the cursor to the end.
        this.updateInput_({
            text: this.selectedMatch_.fillIntoEdit,
            inline: '',
            moveCursorToEnd: true,
        });
    }
    onMatchClick_() {
        this.clearAutocompleteMatches_();
    }
    onVoiceSearchClick_() {
        this.dispatchEvent(new Event('open-voice-search'));
    }
    onLensSearchClick_() {
        this.dropdownIsVisible = false;
        this.dispatchEvent(new Event('open-lens-search'));
    }
    addFileContext_(e) {
        const uploads = [];
        for (const file of e.detail.files) {
            const attachment = {
                file: file,
            };
            uploads.push(attachment);
        }
        this.openComposebox_(uploads);
    }
    addTabContext_(e) {
        const attachment = {
            tabId: e.detail.id,
            url: e.detail.url,
            title: e.detail.title,
            delayUpload: e.detail.delayUpload,
            origin: e.detail.origin,
        };
        this.openComposebox_([attachment]);
    }
    async refreshTabSuggestions_() {
        const { tabs } = await this.pageHandler_.getRecentTabs();
        this.tabSuggestions_ = [...tabs];
    }
    onFileValidationError_(e) {
        this.$.errorScrim.setErrorMessage(e.detail.errorMessage);
    }
    async getTabPreview_(e) {
        const { previewDataUrl } = await this.pageHandler_.getTabPreview(e.detail.tabId);
        e.detail.onPreviewFetched(previewDataUrl || '');
    }
    onContextMenuContainerClick_() {
        if (this.inputFocused_ || this.searchboxLayoutMode === 'Compact') {
            return;
        }
        this.focusInput();
        this.onInputMouseDown_(null);
    }
    onComposeButtonClick_(e) {
        // TODO(crbug.com/463667769): Call submitQuery here since RealboxHandler is
        // now a `ContextualSearchboxHandler`.
        if (!this.composeboxEnabled || this.$.input.value.trim()) {
            // Construct navigation url.
            const searchParams = new URLSearchParams();
            searchParams.append('sourceid', 'chrome');
            searchParams.append('udm', '50');
            searchParams.append('aep', DESKTOP_CHROME_NTP_REALBOX_ENTRY_POINT_VALUE);
            if (this.$.input.value.trim()) {
                searchParams.append('q', this.$.input.value.trim());
            }
            const queryUrl = new URL('/search', loadTimeData.getString('googleBaseUrl'));
            queryUrl.search = searchParams.toString();
            const href = queryUrl.href;
            // Handle mouse events.
            if (e.detail.ctrlKey || e.detail.metaKey) {
                window.open(href, '_blank');
            }
            else if (e.detail.shiftKey) {
                window.open(href, '_blank', 'noopener');
            }
            else {
                window.open(href, '_self');
            }
        }
        else {
            this.openComposebox_();
        }
        chrome.metricsPrivate.recordBoolean('NewTabPage.ComposeEntrypoint.Click.UserTextPresent', !this.isInputEmpty());
    }
    setDeepSearchMode_() {
        this.openComposebox_([], ComposeboxMode.DEEP_SEARCH);
    }
    setCreateImageMode_() {
        this.openComposebox_([], ComposeboxMode.CREATE_IMAGE);
    }
    openComposebox_(uploads = [], mode = ComposeboxMode.DEFAULT) {
        this.dispatchEvent(new CustomEvent('open-composebox', {
            detail: {
                searchboxText: this.$.input.value,
                contextFiles: uploads,
                mode: mode,
            },
            bubbles: true,
            composed: true,
        }));
        this.setInputText('');
    }
    hasThumbnail() {
        return !!this.thumbnailUrl_;
    }
    onRemoveThumbnailClick_() {
        /* Remove thumbnail, focus input, and notify browser. */
        this.thumbnailUrl_ = '';
        this.$.input.focus();
        this.clearAutocompleteMatches_();
        this.pageHandler_.onThumbnailRemoved();
        // Clearing the autocomplete matches above doesn't allow for
        // navigation directly after removing the thumbnail. Must manually
        // query autocomplete after removing the thumbnail since the
        // thumbnail isn't part of the text input.
        const inputValue = this.$.input.value;
        this.queryAutocomplete_(inputValue);
    }
    //============================================================================
    // Helpers
    //============================================================================
    computeSelectedMatch_() {
        if (!this.result_ || !this.result_.matches) {
            return null;
        }
        return this.result_.matches[this.selectedMatchIndex_] || null;
    }
    computeShowRecentTabChip_() {
        // composeboxShowRecentTabChip is unavailable in the WebUI Browser.
        return loadTimeData.valueExists('composeboxShowRecentTabChip') &&
            loadTimeData.getBoolean('composeboxShowRecentTabChip') &&
            this.result_?.input.length === 0;
    }
    computePlaceholderText_(placeholderText) {
        if (placeholderText) {
            return placeholderText;
        }
        return this.showThumbnail ? this.i18n('searchBoxHintMultimodal') :
            this.i18n('searchBoxHint');
    }
    /**
     * Clears the autocomplete result on the page and on the autocomplete backend.
     */
    clearAutocompleteMatches_() {
        this.dropdownIsVisible = false;
        this.result_ = null;
        this.$.matches.unselect();
        this.pageHandler_.stopAutocomplete(/*clearResult=*/ true);
        // Autocomplete sends updates once it is stopped. Invalidate those results
        // by setting the |this.lastQueriedInput_| to its default value.
        this.lastQueriedInput_ = null;
    }
    navigateToMatch_(matchIndex, e) {
        assert(matchIndex >= 0);
        const match = this.result_.matches[matchIndex];
        assert(match);
        this.pageHandler_.openAutocompleteMatch(matchIndex, match.destinationUrl, this.dropdownIsVisible, e.button || 0, e.altKey, e.ctrlKey, e.metaKey, e.shiftKey);
        this.updateInput_({
            text: match.fillIntoEdit,
            inline: '',
            moveCursorToEnd: true,
        });
        this.clearAutocompleteMatches_();
        e.preventDefault();
    }
    queryAutocomplete_(input, preventInlineAutocomplete = false) {
        this.lastQueriedInput_ = input;
        const caretNotAtEnd = this.$.input.selectionStart !== input.length;
        preventInlineAutocomplete = preventInlineAutocomplete ||
            this.isDeletingInput_ || this.pastedInInput_ || caretNotAtEnd;
        this.pageHandler_.queryAutocomplete(input, preventInlineAutocomplete);
        this.dispatchEvent(new CustomEvent('query-autocomplete', {
            bubbles: true,
            composed: true,
            detail: { inputValue: input },
        }));
    }
    /**
     * Updates the input state (text and inline autocompletion) with |update|.
     */
    updateInput_(update) {
        const newInput = Object.assign({}, this.lastInput_, update);
        const newInputValue = newInput.text + newInput.inline;
        const lastInputValue = this.lastInput_.text + this.lastInput_.inline;
        const inlineDiffers = newInput.inline !== this.lastInput_.inline;
        const preserveSelection = !inlineDiffers && !update.moveCursorToEnd;
        let needsSelectionUpdate = !preserveSelection;
        const oldSelectionStart = this.$.input.selectionStart;
        const oldSelectionEnd = this.$.input.selectionEnd;
        if (newInputValue !== this.$.input.value) {
            this.$.input.value = newInputValue;
            needsSelectionUpdate = true; // Setting .value blows away selection.
        }
        if (newInputValue.trim() && needsSelectionUpdate) {
            // If the cursor is to be moved to the end (implies selection should not
            // be perserved), set the selection start to same as the selection end.
            this.$.input.selectionStart = preserveSelection ? oldSelectionStart :
                update.moveCursorToEnd ? newInputValue.length :
                    newInput.text.length;
            this.$.input.selectionEnd =
                preserveSelection ? oldSelectionEnd : newInputValue.length;
        }
        this.isDeletingInput_ = lastInputValue.length > newInputValue.length &&
            lastInputValue.startsWith(newInputValue);
        this.lastInput_ = newInput;
    }
    getThumbnailTabindex_() {
        // If the thumbnail can't be deleted, returning an empty string will set the
        // tabindex to nothing, which will make the thumbnail not focusable.
        return this.isThumbnailDeletable_ ? '1' : '';
    }
    onSelectedMatchIndexChanged_(e) {
        this.selectedMatchIndex_ = e.detail.value;
    }
    onHadSecondarySideChanged_(e) {
        this.hadSecondarySide = e.detail.value;
    }
    onHasSecondarySideChanged_(e) {
        this.hasSecondarySide = e.detail.value;
    }
}
customElements.define(SearchboxElement.is, SearchboxElement);

let instance$8 = null;
function getCss$4() {
    return instance$8 || (instance$8 = [...[], css `:host(:not([hidden])){display:block}#iframe{border:none;border-radius:inherit;display:block;height:inherit;max-height:inherit;max-width:inherit;width:inherit}`]);
}

function getHtml$4() {
    return html `<!--_html_template_start_--><!-- #html_wrapper_imports_start
import {nothing} from 'chrome://resources/lit/v3_0/lit.rollup.js';
#html_wrapper_imports_end -->
<iframe id="iframe" .src="${this.getSrc_()}" .allow="${this.allow || nothing}">
</iframe>
<!--_html_template_end_-->`;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function $$(element, selector) {
    return element.shadowRoot.querySelector(selector);
}
/**
 * Queries |selector| on |root| and returns the resulting element. Throws
 * exception if there is no resulting element or if element is not of type
 * |type|.
 */
function strictQuery(root, selector, type) {
    const element = root.querySelector(selector);
    assert(element && element instanceof type);
    return element;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Wrapper around <iframe> element that lets us mock out loading
 * and postMessaging in tests.
 */
class IframeElement extends CrLitElement {
    static get is() {
        return 'ntp-iframe';
    }
    static get styles() {
        return getCss$4();
    }
    render() {
        return getHtml$4.bind(this)();
    }
    static get properties() {
        return {
            allow: {
                reflect: true,
                type: String,
            },
            src: {
                reflect: true,
                type: String,
            },
        };
    }
    #allow_accessor_storage = '';
    get allow() { return this.#allow_accessor_storage; }
    set allow(value) { this.#allow_accessor_storage = value; }
    #src_accessor_storage = '';
    get src() { return this.#src_accessor_storage; }
    set src(value) { this.#src_accessor_storage = value; }
    // Sends message to iframe.
    postMessage(message) {
        assert(this.shadowRoot);
        WindowProxy.getInstance().postMessage(strictQuery(this.shadowRoot, '#iframe', HTMLIFrameElement), message, new URL(this.src).origin);
    }
    getSrc_() {
        return WindowProxy.getInstance().createIframeSrc(this.src);
    }
}
customElements.define(IframeElement.is, IframeElement);

let instance$7 = null;
function getCss$3() {
    return instance$7 || (instance$7 = [...[], css `#dialog::part(dialog){max-width:300px}#buttons{display:flex;flex-direction:row;justify-content:center;margin-bottom:28px;margin-top:20px}#buttons cr-button{background-position:center;background-repeat:no-repeat;background-size:cover;border:none;height:48px;min-width:48px;width:48px}#buttons cr-button:hover{opacity:0.8}#buttons>:not(:last-child){margin-inline-end:12px}#facebookButton{background-image:url(icons/facebook.svg)}#twitterButton{background-image:url(icons/twitter.svg)}#emailButton{background-image:url(icons/mail.svg)}#url{--cr-input-error-display:none}#copyButton{--cr-icon-image:url(icons/copy.svg);margin-inline-start:2px}`]);
}

function getHtml$3() {
    return html `<!--_html_template_start_--><cr-dialog id="dialog" show-on-attach>
  <div id="title" slot="title">${this.title}</div>
  <div slot="body">
    <div id="buttons">
      <cr-button id="facebookButton" title="$i18n{facebook}"
          @click="${this.onFacebookClick_}">
      </cr-button>
      <cr-button id="twitterButton" title="$i18n{twitter}"
          @click="${this.onTwitterClick_}">
      </cr-button>
      <cr-button id="emailButton" title="$i18n{email}"
          @click="${this.onEmailClick_}">
      </cr-button>
    </div>
    <cr-input readonly label="$i18n{doodleLink}" id="url"
        .value="${this.url.url}">
      <cr-icon-button id="copyButton" slot="suffix" title="$i18n{copyLink}"
          @click="${this.onCopyClick_}">
      </cr-icon-button>
    </cr-input>
  </div>
  <div slot="button-container">
    <cr-button id="doneButton" class="action-button"
        @click="${this.onCloseClick_}">
      $i18n{doneButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The ID of the doodle app for Facebook. Used to share doodles to Facebook.
 */
const FACEBOOK_APP_ID = 738026486351791;
/** Dialog that lets the user share the doodle. */
class DoodleShareDialogElement extends CrLitElement {
    static get is() {
        return 'ntp-doodle-share-dialog';
    }
    static get styles() {
        return getCss$3();
    }
    render() {
        return getHtml$3.bind(this)();
    }
    static get properties() {
        return {
            /** Title shown on the dialog. */
            title: { type: String },
            /** Share URL provided to the user. */
            url: { type: Object },
        };
    }
    #title_accessor_storage = '';
    get title() { return this.#title_accessor_storage; }
    set title(value) { this.#title_accessor_storage = value; }
    #url_accessor_storage = { url: '' };
    get url() { return this.#url_accessor_storage; }
    set url(value) { this.#url_accessor_storage = value; }
    onFacebookClick_() {
        const url = 'https://www.facebook.com/dialog/share' +
            `?app_id=${FACEBOOK_APP_ID}` +
            `&href=${encodeURIComponent(this.url.url)}` +
            `&hashtag=${encodeURIComponent('#GoogleDoodle')}`;
        WindowProxy.getInstance().open(url);
        this.notifyShare_(DoodleShareChannel.kFacebook);
    }
    onTwitterClick_() {
        const url = 'https://twitter.com/intent/tweet' +
            `?text=${encodeURIComponent(`${this.title}\n${this.url.url}`)}`;
        WindowProxy.getInstance().open(url);
        this.notifyShare_(DoodleShareChannel.kTwitter);
    }
    onEmailClick_() {
        const url = `mailto:?subject=${encodeURIComponent(this.title)}` +
            `&body=${encodeURIComponent(this.url.url)}`;
        WindowProxy.getInstance().navigate(url);
        this.notifyShare_(DoodleShareChannel.kEmail);
    }
    onCopyClick_() {
        this.$.url.select();
        navigator.clipboard.writeText(this.url.url);
        this.notifyShare_(DoodleShareChannel.kLinkCopy);
    }
    onCloseClick_() {
        this.$.dialog.close();
    }
    notifyShare_(channel) {
        this.fire('share', channel);
    }
}
customElements.define(DoodleShareDialogElement.is, DoodleShareDialogElement);

let instance$6 = null;
function getCss$2() {
    return instance$6 || (instance$6 = [...[getCss$d()], css `:host{--ntp-logo-height:168px;display:flex;flex-direction:column;flex-shrink:0;justify-content:flex-end;min-height:var(--ntp-logo-height)}:host([doodle-boxed_]){justify-content:flex-end}#logo{forced-color-adjust:none;height:92px;width:272px}:host([single-colored]) #logo{-webkit-mask-image:url(./icons/google_logo.svg);-webkit-mask-repeat:no-repeat;-webkit-mask-size:100%;background-color:var(--ntp-logo-color)}:host(:not([single-colored])) #logo{background-image:url(./icons/google_logo.svg)}#imageDoodle{cursor:pointer;outline:none}#imageDoodle[tabindex='-1']{cursor:auto}:host([doodle-boxed_]) #imageDoodle{background-color:var(--ntp-logo-box-color);border-radius:20px;padding:16px 24px}:host-context(.focus-outline-visible) #imageDoodle:focus{box-shadow:0 0 0 2px rgba(var(--google-blue-600-rgb),.4)}#imageContainer{display:flex;height:fit-content;position:relative;width:fit-content}#image{max-height:var(--ntp-logo-height);max-width:100%}:host([doodle-boxed_]) #image{max-height:128px}#animation{height:100%;pointer-events:none;position:absolute;width:100%}#doodle{position:relative}#shareButton{background-color:var(--color-new-tab-page-doodle-share-button-background,none);border:none;height:32px;min-width:32px;padding:0;position:absolute;width:32px;bottom:0}:host-context([dir='ltr']) #shareButton{right:-40px}:host-context([dir='rtl']) #shareButton{left:-40px}#shareButtonIcon{width:18px;height:18px;margin:7px;vertical-align:bottom;mask-image:url(chrome://new-tab-page/icons/share_unfilled.svg);background-color:var(--color-new-tab-page-doodle-share-button-icon,none)}#iframe{border:none;height:var(--height,var(--ntp-logo-height));transition-duration:var(--duration,100ms);transition-property:height,width;width:var(--width,100%)}#iframe:not([expanded]){max-height:var(--ntp-logo-height)}`]);
}

function getHtml$2() {
    return html `<!--_html_template_start_-->${this.showLogo_ ? html `
  <div id="logo"></div>
` : ''}
${this.showDoodle_ ? html `
  <div id="doodle" title="${this.doodle_.description}">
    <div id="imageDoodle" ?hidden="${!this.imageDoodle_}"
        tabindex="${this.imageDoodleTabIndex_}" @click="${this.onImageClick_}"
        @keydown="${this.onImageKeydown_}">
      <div id="imageContainer">
        <!-- The static image is always visible and the animated image is
             stacked on top of the static image so that there is no flicker
             when starting the animation. -->
        <img id="image" src="${this.imageUrl_}" @load="${this.onImageLoad_}">
        <ntp-iframe id="animation" src="${this.animationUrl_}"
            ?hidden="${!this.showAnimation_}">
        </ntp-iframe>
      </div>
      <cr-button id="shareButton" title="$i18n{shareDoodle}"
          @click="${this.onShareButtonClick_}">
        <div id="shareButtonIcon"></div>
      </cr-button>
    </div>
    ${this.iframeUrl_ ? html `
      <ntp-iframe id="iframe" src="${this.iframeUrl_}" ?expanded="${this.expanded_}"
          allow="autoplay; clipboard-write">
      </ntp-iframe>
    ` : ''}
  </div>
` : ''}
${this.showShareDialog_ ? html `
  <ntp-doodle-share-dialog .title="${this.doodle_.description}"
      .url="${this.doodle_.image.shareUrl}"
      @close="${this.onShareDialogClose_}" @share="${this.onShare_}">
  </ntp-doodle-share-dialog>
` : ''}
<!--_html_template_end_-->`;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Shows the Google logo or a doodle if available.
class LogoElement extends CrLitElement {
    static get is() {
        return 'ntp-logo';
    }
    static get styles() {
        return getCss$2();
    }
    render() {
        return getHtml$2.bind(this)();
    }
    static get properties() {
        return {
            /**
             * If true displays the Google logo single-colored.
             */
            singleColored: {
                reflect: true,
                type: Boolean,
            },
            /**
             * Used to determine if we should display a dark mode doodle.
             */
            theme: { type: Object },
            loaded_: { type: Boolean },
            doodle_: { type: Object },
            imageDoodle_: { type: Object },
            showLogo_: { type: Boolean },
            showDoodle_: { type: Boolean },
            doodleBoxed_: {
                reflect: true,
                type: Boolean,
            },
            imageUrl_: { type: String },
            showAnimation_: { type: Boolean },
            animationUrl_: { type: String },
            iframeUrl_: { type: String },
            duration_: { type: String },
            height_: { type: String },
            width_: { type: String },
            expanded_: { type: Boolean },
            showShareDialog_: { type: Boolean },
            imageDoodleTabIndex_: { type: Number },
        };
    }
    #singleColored_accessor_storage = false;
    get singleColored() { return this.#singleColored_accessor_storage; }
    set singleColored(value) { this.#singleColored_accessor_storage = value; }
    #theme_accessor_storage = null;
    get theme() { return this.#theme_accessor_storage; }
    set theme(value) { this.#theme_accessor_storage = value; }
    #loaded__accessor_storage = false;
    get loaded_() { return this.#loaded__accessor_storage; }
    set loaded_(value) { this.#loaded__accessor_storage = value; }
    #doodle__accessor_storage = null;
    get doodle_() { return this.#doodle__accessor_storage; }
    set doodle_(value) { this.#doodle__accessor_storage = value; }
    #imageDoodle__accessor_storage = null;
    get imageDoodle_() { return this.#imageDoodle__accessor_storage; }
    set imageDoodle_(value) { this.#imageDoodle__accessor_storage = value; }
    #showLogo__accessor_storage = false;
    get showLogo_() { return this.#showLogo__accessor_storage; }
    set showLogo_(value) { this.#showLogo__accessor_storage = value; }
    #showDoodle__accessor_storage = false;
    get showDoodle_() { return this.#showDoodle__accessor_storage; }
    set showDoodle_(value) { this.#showDoodle__accessor_storage = value; }
    #doodleBoxed__accessor_storage = false;
    get doodleBoxed_() { return this.#doodleBoxed__accessor_storage; }
    set doodleBoxed_(value) { this.#doodleBoxed__accessor_storage = value; }
    #imageUrl__accessor_storage = '';
    get imageUrl_() { return this.#imageUrl__accessor_storage; }
    set imageUrl_(value) { this.#imageUrl__accessor_storage = value; }
    #showAnimation__accessor_storage = false;
    get showAnimation_() { return this.#showAnimation__accessor_storage; }
    set showAnimation_(value) { this.#showAnimation__accessor_storage = value; }
    #animationUrl__accessor_storage = '';
    get animationUrl_() { return this.#animationUrl__accessor_storage; }
    set animationUrl_(value) { this.#animationUrl__accessor_storage = value; }
    #iframeUrl__accessor_storage = '';
    get iframeUrl_() { return this.#iframeUrl__accessor_storage; }
    set iframeUrl_(value) { this.#iframeUrl__accessor_storage = value; }
    #duration__accessor_storage = '';
    get duration_() { return this.#duration__accessor_storage; }
    set duration_(value) { this.#duration__accessor_storage = value; }
    #height__accessor_storage = '';
    get height_() { return this.#height__accessor_storage; }
    set height_(value) { this.#height__accessor_storage = value; }
    #width__accessor_storage = '';
    get width_() { return this.#width__accessor_storage; }
    set width_(value) { this.#width__accessor_storage = value; }
    #expanded__accessor_storage = false;
    get expanded_() { return this.#expanded__accessor_storage; }
    set expanded_(value) { this.#expanded__accessor_storage = value; }
    #showShareDialog__accessor_storage = false;
    get showShareDialog_() { return this.#showShareDialog__accessor_storage; }
    set showShareDialog_(value) { this.#showShareDialog__accessor_storage = value; }
    #imageDoodleTabIndex__accessor_storage = -1;
    get imageDoodleTabIndex_() { return this.#imageDoodleTabIndex__accessor_storage; }
    set imageDoodleTabIndex_(value) { this.#imageDoodleTabIndex__accessor_storage = value; }
    eventTracker_ = new EventTracker();
    pageHandler_;
    imageClickParams_ = null;
    interactionLogUrl_ = null;
    shareId_ = null;
    constructor() {
        performance.mark('logo-creation-start');
        super();
        this.pageHandler_ = NewTabPageProxy.getInstance().handler;
        this.pageHandler_.getDoodle().then(({ doodle }) => {
            this.doodle_ = doodle;
            this.loaded_ = true;
            if (this.doodle_ && this.doodle_.interactive) {
                this.width_ = `${this.doodle_.interactive.width}px`;
                this.height_ = `${this.doodle_.interactive.height}px`;
            }
        });
    }
    connectedCallback() {
        super.connectedCallback();
        this.eventTracker_.add(window, 'message', ({ data }) => {
            if (data['cmd'] === 'resizeDoodle') {
                assert(data.duration);
                this.duration_ = data.duration;
                assert(data.height);
                this.height_ = data.height;
                assert(data.width);
                this.width_ = data.width;
                this.expanded_ = true;
            }
            else if (data['cmd'] === 'sendMode') {
                this.sendMode_();
            }
        });
        // Make sure the doodle gets the mode in case it has already requested it.
        this.sendMode_();
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.eventTracker_.removeAll();
    }
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        this.imageDoodle_ = this.computeImageDoodle_();
        this.imageUrl_ = this.computeImageUrl_();
        this.animationUrl_ = this.computeAnimationUrl_();
        this.showDoodle_ = this.computeShowDoodle_();
        this.iframeUrl_ = this.computeIframeUrl_();
        this.showLogo_ = this.computeShowLogo_();
        this.doodleBoxed_ = this.computeDoodleBoxed_();
        this.imageDoodleTabIndex_ = this.computeImageDoodleTabIndex_();
    }
    firstUpdated() {
        performance.measure('logo-creation', 'logo-creation-start');
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        if (changedProperties.has('theme')) {
            this.sendMode_();
        }
        const changedPrivateProperties = changedProperties;
        if (changedPrivateProperties.has('duration_') ||
            changedPrivateProperties.has('height_') ||
            changedPrivateProperties.has('width_')) {
            this.onDurationHeightWidthChange_();
        }
        if (changedPrivateProperties.has('imageDoodle_')) {
            this.onImageDoodleChange_();
        }
    }
    onImageDoodleChange_() {
        if (this.imageDoodle_) {
            this.style.setProperty('--ntp-logo-box-color', skColorToRgba(this.imageDoodle_.backgroundColor));
        }
        else {
            this.style.removeProperty('--ntp-logo-box-color');
        }
        // Stop the animation (if it is running) and reset logging params since
        // mode change constitutes a new doodle session.
        this.showAnimation_ = false;
        this.imageClickParams_ = null;
        this.interactionLogUrl_ = null;
        this.shareId_ = null;
    }
    computeImageDoodle_() {
        return this.doodle_ && this.doodle_.image && this.theme &&
            (this.theme.isDark ? this.doodle_.image.dark :
                this.doodle_.image.light) ||
            null;
    }
    computeShowLogo_() {
        return !!this.loaded_ && !this.showDoodle_;
    }
    computeShowDoodle_() {
        return !!this.imageDoodle_ ||
            /* We hide interactive doodles when offline. Otherwise, the iframe
               would show an ugly error page. */
            !!this.doodle_ && !!this.doodle_.interactive && window.navigator.onLine;
    }
    /**
     * @returns The NTP's background color or null if the NTP does not have
     * a single background color, e.g. when a background image is set.
     */
    computeBackgroundColor_() {
        if (!this.theme || !!this.theme.backgroundImage) {
            return null;
        }
        return this.theme.backgroundColor;
    }
    computeDoodleBoxed_() {
        const backgroundColor = this.computeBackgroundColor_();
        return !backgroundColor ||
            !!this.imageDoodle_ &&
                this.imageDoodle_.backgroundColor.value !== backgroundColor.value;
    }
    /**
     * Called when a simple or animated doodle was clicked. Starts animation if
     * clicking preview image of animated doodle. Otherwise, opens
     * doodle-associated URL in new tab/window.
     */
    onImageClick_() {
        if ($$(this, '#imageDoodle').tabIndex < 0) {
            return;
        }
        if (this.isCtaImageShown_()) {
            this.showAnimation_ = true;
            this.pageHandler_.onDoodleImageClicked(DoodleImageType.kCta, this.interactionLogUrl_);
            // TODO(tiborg): This is technically not correct since we don't know if
            // the animation has loaded yet. However, since the animation is loaded
            // inside an iframe retrieving the proper load signal is not trivial. In
            // practice this should be good enough but we could improve that in the
            // future.
            this.logImageRendered_(DoodleImageType.kAnimation, this.imageDoodle_.animationImpressionLogUrl);
            if (!this.doodle_.image.onClickUrl) {
                $$(this, '#imageDoodle').blur();
            }
            return;
        }
        assert(this.doodle_.image.onClickUrl);
        this.pageHandler_.onDoodleImageClicked(this.showAnimation_ ? DoodleImageType.kAnimation :
            DoodleImageType.kStatic, null);
        const onClickUrl = new URL(this.doodle_.image.onClickUrl.url);
        if (this.imageClickParams_) {
            for (const param of new URLSearchParams(this.imageClickParams_)) {
                onClickUrl.searchParams.append(param[0], param[1]);
            }
        }
        WindowProxy.getInstance().open(onClickUrl.toString());
    }
    onImageLoad_() {
        this.logImageRendered_(this.isCtaImageShown_() ? DoodleImageType.kCta :
            DoodleImageType.kStatic, this.imageDoodle_.imageImpressionLogUrl);
    }
    async logImageRendered_(type, logUrl) {
        const { imageClickParams, interactionLogUrl, shareId } = await this.pageHandler_.onDoodleImageRendered(type, WindowProxy.getInstance().now(), logUrl);
        this.imageClickParams_ = imageClickParams;
        this.interactionLogUrl_ = interactionLogUrl;
        this.shareId_ = shareId;
    }
    onImageKeydown_(e) {
        if ([' ', 'Enter'].includes(e.key)) {
            this.onImageClick_();
        }
    }
    onShare_(e) {
        const doodleId = new URL(this.doodle_.image.onClickUrl.url).searchParams.get('ct');
        if (!doodleId) {
            return;
        }
        this.pageHandler_.onDoodleShared(e.detail, doodleId, this.shareId_);
    }
    isCtaImageShown_() {
        return !this.showAnimation_ && !!this.imageDoodle_ &&
            !!this.imageDoodle_.animationUrl;
    }
    /**
     * Sends a postMessage to the interactive doodle whether the current theme is
     * dark or light. Won't do anything if we don't have an interactive doodle or
     * we haven't been told yet whether the current theme is dark or light.
     */
    sendMode_() {
        if (!this.theme) {
            return;
        }
        const iframe = $$(this, '#iframe');
        if (!iframe) {
            return;
        }
        iframe.postMessage({ cmd: 'changeMode', dark: this.theme.isDark });
    }
    computeImageUrl_() {
        return this.imageDoodle_ ? this.imageDoodle_.imageUrl.url : '';
    }
    computeAnimationUrl_() {
        return this.imageDoodle_ && this.imageDoodle_.animationUrl ?
            `chrome-untrusted://new-tab-page/image?${this.imageDoodle_.animationUrl.url}` :
            '';
    }
    computeIframeUrl_() {
        if (this.doodle_ && this.doodle_.interactive) {
            const url = new URL(this.doodle_.interactive.url.url);
            url.searchParams.append('theme_messages', '0');
            return url.href;
        }
        else {
            return '';
        }
    }
    onShareButtonClick_(e) {
        e.stopPropagation();
        this.showShareDialog_ = true;
    }
    onShareDialogClose_() {
        this.showShareDialog_ = false;
    }
    onDurationHeightWidthChange_() {
        this.duration_ ? this.style.setProperty('--duration', this.duration_) :
            this.style.removeProperty('--duration');
        this.height_ ? this.style.setProperty('--height', this.height_) :
            this.style.removeProperty('--height');
        this.width_ ? this.style.setProperty('--width', this.width_) :
            this.style.removeProperty('--width');
    }
    computeImageDoodleTabIndex_() {
        return (this.doodle_ && this.doodle_.image &&
            (this.isCtaImageShown_() || this.doodle_.image.onClickUrl)) ?
            0 :
            -1;
    }
}
customElements.define(LogoElement.is, LogoElement);

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview This file provides a singleton class that exposes the Mojo
 * handler interface used for one way communication between the JS and the
 * browser.
 * TODO(tluk): Convert this into typescript once all dependencies have been
 * fully migrated.
 */
let instance$5 = null;
class BrowserProxy {
    callbackRouter;
    constructor() {
        this.callbackRouter = new PageCallbackRouter$1();
        const pageHandlerRemote = PageHandler$1.getRemote();
        pageHandlerRemote.setPage(this.callbackRouter.$.bindNewPipeAndPassRemote());
    }
    static getInstance() {
        return instance$5 || (instance$5 = new BrowserProxy());
    }
    static setInstance(newInstance) {
        instance$5 = newInstance;
    }
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview This file holds the functions that allow WebUI to update its
 * colors CSS stylesheet when a ColorProvider change in the browser is detected.
 */
/**
 * The CSS selector used to get the <link> node with the colors.css stylesheet.
 * The wildcard is needed since the URL ends with a timestamp.
 */
const COLORS_CSS_SELECTOR = 'link[href*=\'//theme/colors.css\']';
let documentInstance = null;
// 
class ColorChangeUpdater {
    listenerId_ = null;
    root_;
    // 
    constructor(root) {
        assert(documentInstance === null || root !== document);
        this.root_ = root;
    }
    /**
     * Starts listening for ColorProvider changes from the browser and updates the
     * `root_` whenever changes occur.
     */
    start() {
        if (this.listenerId_ !== null) {
            return;
        }
        this.listenerId_ = BrowserProxy.getInstance()
            .callbackRouter.onColorProviderChanged.addListener(this.onColorProviderChanged.bind(this));
    }
    // TODO(dpapad): Figure out how to properly trigger
    // `callbackRouter.onColorProviderChanged` listeners from tests and make this
    // method private.
    async onColorProviderChanged() {
        await this.refreshColorsCss();
        // 
    }
    /**
     * Forces `root_` to refresh its colors.css stylesheet. This is used to
     * fetch an updated stylesheet when the ColorProvider associated with the
     * WebUI has changed.
     * @return A promise which resolves to true once the new colors are loaded and
     *     installed into the DOM. In the case of an error returns false. When a
     *     new colors.css is loaded, this will always freshly query the existing
     *     colors.css, allowing multiple calls to successfully remove existing,
     *     outdated CSS.
     */
    async refreshColorsCss() {
        const colorCssNode = this.root_.querySelector(COLORS_CSS_SELECTOR);
        if (!colorCssNode) {
            return false;
        }
        const href = colorCssNode.getAttribute('href');
        if (!href) {
            return false;
        }
        const hrefURL = new URL(href, location.href);
        const params = new URLSearchParams(hrefURL.search);
        params.set('version', new Date().getTime().toString());
        const newHref = `${hrefURL.origin}${hrefURL.pathname}?${params.toString()}`;
        // A flickering effect may take place when setting the href property of
        // the existing color css node with a new value. In order to avoid
        // flickering, we create a new link element and once it is loaded we
        // remove the old one. See crbug.com/1365320 for additional details.
        const newColorsCssLink = document.createElement('link');
        newColorsCssLink.setAttribute('href', newHref);
        newColorsCssLink.rel = 'stylesheet';
        newColorsCssLink.type = 'text/css';
        const newColorsLoaded = new Promise(resolve => {
            newColorsCssLink.onload = resolve;
        });
        if (this.root_ === document) {
            document.getElementsByTagName('body')[0].appendChild(newColorsCssLink);
        }
        else {
            this.root_.appendChild(newColorsCssLink);
        }
        await newColorsLoaded;
        const oldColorCssNode = document.querySelector(COLORS_CSS_SELECTOR);
        if (oldColorCssNode) {
            oldColorCssNode.remove();
        }
        return true;
    }
    static forDocument() {
        return documentInstance ||
            (documentInstance = new ColorChangeUpdater(document));
    }
}

const div = document.createElement('div');
div.innerHTML = getTrustedHTML `<cr-iconset name="iph" size="24">
  <svg>
    <defs>
      <!--
      These icons are copied from Material UI and optimized through SVGOMG
      See http://goo.gl/Y1OdAq for instructions on adding additional icons.
      -->
      <g id="celebration">
        <path fill="none" d="M0 0h20v20H0z"></path>
        <path fill-rule="evenodd"
          d="m2 22 14-5-9-9-5 14Zm10.35-5.82L5.3 18.7l2.52-7.05 4.53 4.53ZM14.53 12.53l5.59-5.59a1.25 1.25 0 0 1 1.77 0l.59.59 1.06-1.06-.59-.59a2.758 2.758 0 0 0-3.89 0l-5.59 5.59 1.06 1.06ZM10.06 6.88l-.59.59 1.06 1.06.59-.59a2.758 2.758 0 0 0 0-3.89l-.59-.59-1.06 1.07.59.59c.48.48.48 1.28 0 1.76ZM17.06 11.88l-1.59 1.59 1.06 1.06 1.59-1.59a1.25 1.25 0 0 1 1.77 0l1.61 1.61 1.06-1.06-1.61-1.61a2.758 2.758 0 0 0-3.89 0ZM15.06 5.88l-3.59 3.59 1.06 1.06 3.59-3.59a2.758 2.758 0 0 0 0-3.89l-1.59-1.59-1.06 1.06 1.59 1.59c.48.49.48 1.29 0 1.77Z">
        </path>
      </g>
      <g id="lightbulb_outline">
        <path fill="none" d="M0 0h24v24H0z"></path>
        <path
          d="M9 21c0 .55.45 1 1 1h4c.55 0 1-.45 1-1v-1H9v1zm3-19C8.14 2 5 5.14 5 9c0 2.38 1.19 4.47 3 5.74V17c0 .55.45 1 1 1h6c.55 0 1-.45 1-1v-2.26c1.81-1.27 3-3.36 3-5.74 0-3.86-3.14-7-7-7zm2 11.7V16h-4v-2.3C8.48 12.63 7 11.53 7 9c0-2.76 2.24-5 5-5s5 2.24 5 5c0 2.49-1.51 3.65-3 4.7z">
        </path>
      </g>
      <g id="lightbulb_outline_chrome_refresh" width="20" height="20" viewBox="0 -960 960 960">
        <path
          d="M479.779-81.413q-30.975 0-52.812-22.704-21.837-22.704-21.837-55.035h149.74q0 32.631-22.058 55.185-22.058 22.554-53.033 22.554ZM333.848-209.065v-75.587h292.304v75.587H333.848Zm-15-125.5Q254.696-374 219.282-440.533q-35.413-66.532-35.413-142.163 0-123.288 86.364-209.59 86.363-86.301 209.739-86.301t209.767 86.301q86.392 86.302 86.392 209.59 0 75.87-35.413 142.283Q705.304-374 641.152-334.565H318.848Zm26.348-83h269.608q37.283-30.522 57.805-73.566 20.521-43.043 20.521-91.512 0-89.424-61.812-151.184-61.813-61.76-151.087-61.76-89.274 0-151.318 61.76-62.043 61.76-62.043 151.184 0 48.469 20.521 91.512 20.522 43.044 57.805 73.566Zm134.804 0Z">
        </path>
      </g>
    </defs>
  </svg>
</cr-iconset>
`;
const iconsets = div.querySelectorAll('cr-iconset');
for (const iconset of iconsets) {
    document.head.appendChild(iconset);
}

let instance$4 = null;
function getCss$1() {
    return instance$4 || (instance$4 = [...[getCss$d()], css `:host{--help-bubble-background:var(--color-feature-promo-bubble-background,var(--google-blue-700));--help-bubble-foreground:var(--color-feature-promo-bubble-foreground,var(--google-grey-200));--help-bubble-border-radius:12px;--help-bubble-close-button-icon-size:16px;--help-bubble-close-button-size:20px;--help-bubble-element-spacing:8px;--help-bubble-padding:20px;--help-bubble-font-weight:400;border-radius:var(--help-bubble-border-radius);box-shadow:0 6px 10px 4px rgba(60,64,67,0.15),0 2px 3px rgba(60,64,67,0.3);box-sizing:border-box;position:absolute;z-index:1}#arrow{--help-bubble-arrow-size:11.3px;--help-bubble-arrow-size-half:calc(var(--help-bubble-arrow-size) / 2);--help-bubble-arrow-diameter:16px;--help-bubble-arrow-radius:calc(var(--help-bubble-arrow-diameter) / 2);--help-bubble-arrow-edge-offset:22px;--help-bubble-arrow-offset:calc(var(--help-bubble-arrow-edge-offset) + var(--help-bubble-arrow-radius));--help-bubble-arrow-border-radius:2px;position:absolute}#inner-arrow{background-color:var(--help-bubble-background);height:var(--help-bubble-arrow-size);left:calc(0px - var(--help-bubble-arrow-size-half));position:absolute;top:calc(0px - var(--help-bubble-arrow-size-half));transform:rotate(45deg);width:var(--help-bubble-arrow-size);z-index:-1}#arrow.bottom-edge{bottom:0}#arrow.bottom-edge #inner-arrow{border-bottom-right-radius:var(--help-bubble-arrow-border-radius)}#arrow.top-edge{top:0}#arrow.top-edge #inner-arrow{border-top-left-radius:var(--help-bubble-arrow-border-radius)}#arrow.right-edge{right:0}#arrow.right-edge #inner-arrow{border-top-right-radius:var(--help-bubble-arrow-border-radius)}#arrow.left-edge{left:0}#arrow.left-edge #inner-arrow{border-bottom-left-radius:var(--help-bubble-arrow-border-radius)}#arrow.top-position{top:var(--help-bubble-arrow-offset)}#arrow.vertical-center-position{top:50%}#arrow.bottom-position{bottom:var(--help-bubble-arrow-offset)}#arrow.left-position{left:var(--help-bubble-arrow-offset)}#arrow.horizontal-center-position{left:50%}#arrow.right-position{right:var(--help-bubble-arrow-offset)}#topContainer{display:flex;flex-direction:row}#progress{display:inline-block;flex:auto}#progress div{--help-bubble-progress-size:8px;background-color:var(--help-bubble-foreground);border:1px solid var(--help-bubble-foreground);border-radius:50%;display:inline-block;height:var(--help-bubble-progress-size);margin-inline-end:var(--help-bubble-element-spacing);margin-top:5px;width:var(--help-bubble-progress-size)}#progress .total-progress{background-color:var(--help-bubble-background)}#topBody,#mainBody{flex:1;font-size:14px;font-style:normal;font-weight:var(--help-bubble-font-weight);letter-spacing:0.3px;line-height:20px;margin:0}#title{flex:1;font-size:18px;font-style:normal;font-weight:500;line-height:24px;margin:0}.help-bubble{--cr-focus-outline-color:var(--help-bubble-foreground);background-color:var(--help-bubble-background);border-radius:var(--help-bubble-border-radius);box-sizing:border-box;color:var(--help-bubble-foreground);display:flex;flex-direction:column;justify-content:space-between;max-width:340px;min-width:260px;padding:var(--help-bubble-padding);position:relative}#main{display:flex;flex-direction:row;justify-content:flex-start;margin-top:var(--help-bubble-element-spacing)}#middleRowSpacer{margin-inline-start:32px}cr-icon-button,cr-button{--help-bubble-button-foreground:var(--help-bubble-foreground);--help-bubble-button-background:var(--help-bubble-background);--help-bubble-button-hover-alpha:10%}cr-button.default-button{--help-bubble-button-foreground:var(--color-feature-promo-bubble-default-button-foreground,var(--help-bubble-background));--help-bubble-button-background:var(--color-feature-promo-bubble-default-button-background,var(--help-bubble-foreground));--help-bubble-button-hover-alpha:6%}@media (prefers-color-scheme:dark){cr-icon-button,cr-button{--help-bubble-button-hover-alpha:6%}cr-button.default-button{--help-bubble-button-hover-alpha:10%}}cr-icon-button:hover,#buttons cr-button:hover{background-color:color-mix(in srgb,var(--help-bubble-button-foreground) var(--help-bubble-button-hover-alpha),var(--help-bubble-button-background))}cr-icon-button{--cr-icon-button-fill-color:var(--help-bubble-button-foreground);--cr-icon-button-icon-size:var(--help-bubble-close-button-icon-size);--cr-icon-button-size:var(--help-bubble-close-button-size);--cr-icon-button-stroke-color:var(--help-bubble-button-foreground);box-sizing:border-box;display:block;flex:none;float:right;height:var(--cr-icon-button-size);margin:0;margin-inline-start:var(--help-bubble-element-spacing);order:2;width:var(--cr-icon-button-size)}cr-icon-button:focus-visible:focus{box-shadow:inset 0 0 0 1px var(--cr-focus-outline-color)}#bodyIcon{--help-bubble-body-icon-image-size:18px;--help-bubble-body-icon-size:24px;--iron-icon-height:var(--help-bubble-body-icon-image-size);--iron-icon-width:var(--help-bubble-body-icon-image-size);background-color:var(--help-bubble-foreground);border-radius:50%;box-sizing:border-box;color:var(--help-bubble-background);height:var(--help-bubble-body-icon-size);margin-inline-end:var(--help-bubble-element-spacing);padding:calc((var(--help-bubble-body-icon-size) - var(--help-bubble-body-icon-image-size)) / 2);text-align:center;width:var(--help-bubble-body-icon-size)}#bodyIcon cr-icon{display:block}#buttons{display:flex;flex-direction:row;justify-content:flex-end;margin-top:16px}#buttons cr-button{--cr-button-border-color:var(--help-bubble-foreground);--cr-button-text-color:var(--help-bubble-button-foreground);--cr-button-background-color:var(--help-bubble-button-background)}#buttons cr-button:focus{box-shadow:none;outline:2px solid var(--cr-focus-outline-color);outline-offset:1px}#buttons cr-button:not(:first-child){margin-inline-start:var(--help-bubble-element-spacing)}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$1() {
    return html `
<link rel="stylesheet" href="chrome://theme/colors.css?sets=ui,chrome&shadow_host=true">
<div class="help-bubble" role="alertdialog" aria-modal="true"
    aria-labelledby="title" aria-describedby="body" aria-live="assertive"
    @keydown="${this.onKeyDown_}" @click="${this.blockPropagation_}">
  <div id="topContainer">
    <div id="bodyIcon" ?hidden="${!this.shouldShowBodyIcon_()}"
        role="image" aria-label="${this.bodyIconAltText}">
      <cr-icon icon="iph:${this.bodyIconName}"></cr-icon>
    </div>
    <div id="progress" ?hidden="${!this.progress}" role="progressbar"
        aria-valuenow="${this.progress ? this.progress.current : nothing}"
        aria-valuemin="1"
        aria-valuemax="${this.progress ? this.progress.total : nothing}">
      ${this.progressData_.map((_item, index) => html `
        <div class="${this.getProgressClass_(index)}"></div>`)}
    </div>
    <h1 id="title"
        ?hidden="${!this.shouldShowTitleInTopContainer_()}">
      ${this.titleText}
    </h1>
    <p id="topBody"
        ?hidden="${!this.shouldShowBodyInTopContainer_()}">
      ${this.bodyText}
    </p>
    <cr-icon-button id="close" iron-icon="cr:close"
        aria-label="${this.closeButtonAltText}" @click="${this.dismiss_}"
        tabindex="${this.closeButtonTabIndex}">
    </cr-icon-button>
  </div>
  <div id="main" ?hidden="${!this.shouldShowBodyInMain_()}">
    <div id="middleRowSpacer" ?hidden="!${this.shouldShowBodyIcon_()}">
    </div>
    <p id="mainBody">${this.bodyText}</p>
  </div>
  <div id="buttons" ?hidden="${!this.buttons.length}">
    ${this.sortedButtons.map(item => html `
      <cr-button id="${this.getButtonId_(item)}"
          tabindex="${this.getButtonTabIndex_(item)}"
          class="${this.getButtonClass_(item.isDefault)}"
          @click="${this.onButtonClick_}"
          role="button" aria-label="${item.text}">${item.text}</cr-button>`)}
  </div>
  <div id="arrow" class="${this.getArrowClass_()}">
    <div id="inner-arrow"></div>
  </div>
</div>`;
}

// ui/webui/resources/js/tracked_element/tracked_element.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class TrackedElementHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'tracked_element.mojom.TrackedElementHandler', scope);
    }
}
class TrackedElementHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(TrackedElementHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    trackedElementVisibilityChanged(nativeIdentifier, visible, rect) {
        this.proxy.sendMessage(0, TrackedElementHandler_TrackedElementVisibilityChanged_ParamsSpec.$, null, [
            nativeIdentifier,
            visible,
            rect
        ], false);
    }
    trackedElementActivated(nativeIdentifier) {
        this.proxy.sendMessage(1, TrackedElementHandler_TrackedElementActivated_ParamsSpec.$, null, [
            nativeIdentifier
        ], false);
    }
    trackedElementCustomEvent(nativeIdentifier, customEventName) {
        this.proxy.sendMessage(2, TrackedElementHandler_TrackedElementCustomEvent_ParamsSpec.$, null, [
            nativeIdentifier,
            customEventName
        ], false);
    }
}
const TrackedElementHandler_TrackedElementVisibilityChanged_ParamsSpec = { $: {} };
const TrackedElementHandler_TrackedElementActivated_ParamsSpec = { $: {} };
const TrackedElementHandler_TrackedElementCustomEvent_ParamsSpec = { $: {} };
mojo.internal.Struct(TrackedElementHandler_TrackedElementVisibilityChanged_ParamsSpec.$, 'TrackedElementHandler_TrackedElementVisibilityChanged_Params', [
    mojo.internal.StructField('nativeIdentifier', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('visible', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('rect', 16, 0, RectFSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(TrackedElementHandler_TrackedElementActivated_ParamsSpec.$, 'TrackedElementHandler_TrackedElementActivated_Params', [
    mojo.internal.StructField('nativeIdentifier', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TrackedElementHandler_TrackedElementCustomEvent_ParamsSpec.$, 'TrackedElementHandler_TrackedElementCustomEvent_Params', [
    mojo.internal.StructField('nativeIdentifier', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('customEventName', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);

// ui/webui/resources/cr_components/help_bubble/help_bubble.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const HelpBubbleArrowPositionSpec = { $: mojo.internal.Enum() };
var HelpBubbleArrowPosition;
(function (HelpBubbleArrowPosition) {
    HelpBubbleArrowPosition[HelpBubbleArrowPosition["MIN_VALUE"] = 0] = "MIN_VALUE";
    HelpBubbleArrowPosition[HelpBubbleArrowPosition["MAX_VALUE"] = 11] = "MAX_VALUE";
    HelpBubbleArrowPosition[HelpBubbleArrowPosition["TOP_LEFT"] = 0] = "TOP_LEFT";
    HelpBubbleArrowPosition[HelpBubbleArrowPosition["TOP_CENTER"] = 1] = "TOP_CENTER";
    HelpBubbleArrowPosition[HelpBubbleArrowPosition["TOP_RIGHT"] = 2] = "TOP_RIGHT";
    HelpBubbleArrowPosition[HelpBubbleArrowPosition["BOTTOM_LEFT"] = 3] = "BOTTOM_LEFT";
    HelpBubbleArrowPosition[HelpBubbleArrowPosition["BOTTOM_CENTER"] = 4] = "BOTTOM_CENTER";
    HelpBubbleArrowPosition[HelpBubbleArrowPosition["BOTTOM_RIGHT"] = 5] = "BOTTOM_RIGHT";
    HelpBubbleArrowPosition[HelpBubbleArrowPosition["LEFT_TOP"] = 6] = "LEFT_TOP";
    HelpBubbleArrowPosition[HelpBubbleArrowPosition["LEFT_CENTER"] = 7] = "LEFT_CENTER";
    HelpBubbleArrowPosition[HelpBubbleArrowPosition["LEFT_BOTTOM"] = 8] = "LEFT_BOTTOM";
    HelpBubbleArrowPosition[HelpBubbleArrowPosition["RIGHT_TOP"] = 9] = "RIGHT_TOP";
    HelpBubbleArrowPosition[HelpBubbleArrowPosition["RIGHT_CENTER"] = 10] = "RIGHT_CENTER";
    HelpBubbleArrowPosition[HelpBubbleArrowPosition["RIGHT_BOTTOM"] = 11] = "RIGHT_BOTTOM";
})(HelpBubbleArrowPosition || (HelpBubbleArrowPosition = {}));
const HelpBubbleClosedReasonSpec = { $: mojo.internal.Enum() };
var HelpBubbleClosedReason;
(function (HelpBubbleClosedReason) {
    HelpBubbleClosedReason[HelpBubbleClosedReason["MIN_VALUE"] = 0] = "MIN_VALUE";
    HelpBubbleClosedReason[HelpBubbleClosedReason["MAX_VALUE"] = 2] = "MAX_VALUE";
    HelpBubbleClosedReason[HelpBubbleClosedReason["kPageChanged"] = 0] = "kPageChanged";
    HelpBubbleClosedReason[HelpBubbleClosedReason["kDismissedByUser"] = 1] = "kDismissedByUser";
    HelpBubbleClosedReason[HelpBubbleClosedReason["kTimedOut"] = 2] = "kTimedOut";
})(HelpBubbleClosedReason || (HelpBubbleClosedReason = {}));
class HelpBubbleHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'help_bubble.mojom.HelpBubbleHandlerFactory', scope);
    }
}
class HelpBubbleHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(HelpBubbleHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createHelpBubbleHandler(client, handler) {
        this.proxy.sendMessage(0, HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec.$, null, [
            client,
            handler
        ], false);
    }
}
class HelpBubbleHandlerFactory {
    static get $interfaceName() {
        return "help_bubble.mojom.HelpBubbleHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new HelpBubbleHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
class HelpBubbleHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'help_bubble.mojom.HelpBubbleHandler', scope);
    }
}
class HelpBubbleHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(HelpBubbleHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    bindTrackedElementHandler(handler) {
        this.proxy.sendMessage(0, HelpBubbleHandler_BindTrackedElementHandler_ParamsSpec.$, null, [
            handler
        ], false);
    }
    helpBubbleButtonPressed(nativeIdentifier, buttonIndex) {
        this.proxy.sendMessage(1, HelpBubbleHandler_HelpBubbleButtonPressed_ParamsSpec.$, null, [
            nativeIdentifier,
            buttonIndex
        ], false);
    }
    helpBubbleClosed(nativeIdentifier, reason) {
        this.proxy.sendMessage(2, HelpBubbleHandler_HelpBubbleClosed_ParamsSpec.$, null, [
            nativeIdentifier,
            reason
        ], false);
    }
}
class HelpBubbleClientPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'help_bubble.mojom.HelpBubbleClient', scope);
    }
}
class HelpBubbleClientRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(HelpBubbleClientPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    showHelpBubble(params) {
        this.proxy.sendMessage(0, HelpBubbleClient_ShowHelpBubble_ParamsSpec.$, null, [
            params
        ], false);
    }
    toggleFocusForAccessibility(nativeIdentifier) {
        this.proxy.sendMessage(1, HelpBubbleClient_ToggleFocusForAccessibility_ParamsSpec.$, null, [
            nativeIdentifier
        ], false);
    }
    hideHelpBubble(nativeIdentifier) {
        this.proxy.sendMessage(2, HelpBubbleClient_HideHelpBubble_ParamsSpec.$, null, [
            nativeIdentifier
        ], false);
    }
    externalHelpBubbleUpdated(nativeIdentifier, shown) {
        this.proxy.sendMessage(3, HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsSpec.$, null, [
            nativeIdentifier,
            shown
        ], false);
    }
}
/**
 * An object which receives request messages for the HelpBubbleClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class HelpBubbleClientCallbackRouter {
    helper_internal_;
    $;
    router_;
    showHelpBubble;
    toggleFocusForAccessibility;
    hideHelpBubble;
    externalHelpBubbleUpdated;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(HelpBubbleClientRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.showHelpBubble =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, HelpBubbleClient_ShowHelpBubble_ParamsSpec.$, null, this.showHelpBubble.createReceiverHandler(false /* expectsResponse */), false);
        this.toggleFocusForAccessibility =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, HelpBubbleClient_ToggleFocusForAccessibility_ParamsSpec.$, null, this.toggleFocusForAccessibility.createReceiverHandler(false /* expectsResponse */), false);
        this.hideHelpBubble =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, HelpBubbleClient_HideHelpBubble_ParamsSpec.$, null, this.hideHelpBubble.createReceiverHandler(false /* expectsResponse */), false);
        this.externalHelpBubbleUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsSpec.$, null, this.externalHelpBubbleUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
const HelpBubbleButtonParamsSpec = { $: {} };
const ProgressSpec = { $: {} };
const HelpBubbleParamsSpec = { $: {} };
const HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec = { $: {} };
const PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec = { $: {} };
const HelpBubbleHandler_BindTrackedElementHandler_ParamsSpec = { $: {} };
const HelpBubbleHandler_HelpBubbleButtonPressed_ParamsSpec = { $: {} };
const HelpBubbleHandler_HelpBubbleClosed_ParamsSpec = { $: {} };
const HelpBubbleClient_ShowHelpBubble_ParamsSpec = { $: {} };
const HelpBubbleClient_ToggleFocusForAccessibility_ParamsSpec = { $: {} };
const HelpBubbleClient_HideHelpBubble_ParamsSpec = { $: {} };
const HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsSpec = { $: {} };
mojo.internal.Struct(HelpBubbleButtonParamsSpec.$, 'HelpBubbleButtonParams', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isDefault', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ProgressSpec.$, 'Progress', [
    mojo.internal.StructField('current', 0, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('total', 1, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(HelpBubbleParamsSpec.$, 'HelpBubbleParams', [
    mojo.internal.StructField('nativeIdentifier', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('position', 8, 0, HelpBubbleArrowPositionSpec.$, HelpBubbleArrowPosition.TOP_CENTER, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('titleText', 16, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('bodyText', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('closeButtonAltText', 32, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('bodyIconName', 40, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('bodyIconAltText', 48, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('progress', 56, 0, ProgressSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('buttons', 64, 0, mojo.internal.Array(HelpBubbleButtonParamsSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('focus_on_show_hint_$flag', 12, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "focus_on_show_hint_$value",
        originalFieldName: "focusOnShowHint",
    }, undefined),
    mojo.internal.StructField('focus_on_show_hint_$value', 12, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "focusOnShowHint",
    }, undefined),
    mojo.internal.StructField('timeout', 72, 0, TimeDeltaSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 88],]);
mojo.internal.Struct(HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec.$, 'HelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params', [
    mojo.internal.StructField('client', 0, 0, mojo.internal.InterfaceProxy(HelpBubbleClientRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(HelpBubbleHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec.$, 'PdfHelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params', [
    mojo.internal.StructField('client', 0, 0, mojo.internal.InterfaceProxy(HelpBubbleClientRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(HelpBubbleHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(HelpBubbleHandler_BindTrackedElementHandler_ParamsSpec.$, 'HelpBubbleHandler_BindTrackedElementHandler_Params', [
    mojo.internal.StructField('handler', 0, 0, mojo.internal.InterfaceRequest(TrackedElementHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(HelpBubbleHandler_HelpBubbleButtonPressed_ParamsSpec.$, 'HelpBubbleHandler_HelpBubbleButtonPressed_Params', [
    mojo.internal.StructField('nativeIdentifier', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('buttonIndex', 8, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(HelpBubbleHandler_HelpBubbleClosed_ParamsSpec.$, 'HelpBubbleHandler_HelpBubbleClosed_Params', [
    mojo.internal.StructField('nativeIdentifier', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('reason', 8, 0, HelpBubbleClosedReasonSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(HelpBubbleClient_ShowHelpBubble_ParamsSpec.$, 'HelpBubbleClient_ShowHelpBubble_Params', [
    mojo.internal.StructField('params', 0, 0, HelpBubbleParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(HelpBubbleClient_ToggleFocusForAccessibility_ParamsSpec.$, 'HelpBubbleClient_ToggleFocusForAccessibility_Params', [
    mojo.internal.StructField('nativeIdentifier', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(HelpBubbleClient_HideHelpBubble_ParamsSpec.$, 'HelpBubbleClient_HideHelpBubble_Params', [
    mojo.internal.StructField('nativeIdentifier', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsSpec.$, 'HelpBubbleClient_ExternalHelpBubbleUpdated_Params', [
    mojo.internal.StructField('nativeIdentifier', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('shown', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A bubble for displaying in-product help. These are created
 * dynamically by HelpBubbleMixin, and their API should be considered an
 * implementation detail and subject to change (you should not add them to your
 * components directly).
 */
const ACTION_BUTTON_ID_PREFIX = 'action-button-';
const HELP_BUBBLE_DISMISSED_EVENT = 'help-bubble-dismissed';
const HELP_BUBBLE_TIMED_OUT_EVENT = 'help-bubble-timed-out';
const HELP_BUBBLE_SCROLL_ANCHOR_OPTIONS = {
    behavior: 'smooth',
    block: 'center',
};
class HelpBubbleElement extends CrLitElement {
    static get is() {
        return 'help-bubble';
    }
    static get styles() {
        return getCss$1();
    }
    render() {
        return getHtml$1.bind(this)();
    }
    static get properties() {
        return {
            nativeId: {
                type: String,
                reflect: true,
            },
            position: {
                type: Number,
                reflect: true,
            },
            bodyIconName: { type: String },
            bodyIconAltText: { type: String },
            progress: { type: Object },
            titleText: { type: String },
            bodyText: { type: String },
            buttons: { type: Array },
            sortedButtons: { type: Array },
            closeButtonAltText: { type: String },
            closeButtonTabIndex: { type: Number },
            progressData_: {
                type: Array,
                state: true,
            },
        };
    }
    #nativeId_accessor_storage = '';
    get nativeId() { return this.#nativeId_accessor_storage; }
    set nativeId(value) { this.#nativeId_accessor_storage = value; }
    #bodyText_accessor_storage = '';
    get bodyText() { return this.#bodyText_accessor_storage; }
    set bodyText(value) { this.#bodyText_accessor_storage = value; }
    #titleText_accessor_storage = '';
    get titleText() { return this.#titleText_accessor_storage; }
    set titleText(value) { this.#titleText_accessor_storage = value; }
    #closeButtonAltText_accessor_storage = '';
    get closeButtonAltText() { return this.#closeButtonAltText_accessor_storage; }
    set closeButtonAltText(value) { this.#closeButtonAltText_accessor_storage = value; }
    #closeButtonTabIndex_accessor_storage = 0;
    get closeButtonTabIndex() { return this.#closeButtonTabIndex_accessor_storage; }
    set closeButtonTabIndex(value) { this.#closeButtonTabIndex_accessor_storage = value; }
    #position_accessor_storage = HelpBubbleArrowPosition.TOP_CENTER;
    get position() { return this.#position_accessor_storage; }
    set position(value) { this.#position_accessor_storage = value; }
    #buttons_accessor_storage = [];
    get buttons() { return this.#buttons_accessor_storage; }
    set buttons(value) { this.#buttons_accessor_storage = value; }
    #sortedButtons_accessor_storage = [];
    get sortedButtons() { return this.#sortedButtons_accessor_storage; }
    set sortedButtons(value) { this.#sortedButtons_accessor_storage = value; }
    #progress_accessor_storage = null;
    get progress() { return this.#progress_accessor_storage; }
    set progress(value) { this.#progress_accessor_storage = value; }
    #bodyIconName_accessor_storage = null;
    get bodyIconName() { return this.#bodyIconName_accessor_storage; }
    set bodyIconName(value) { this.#bodyIconName_accessor_storage = value; }
    #bodyIconAltText_accessor_storage = '';
    get bodyIconAltText() { return this.#bodyIconAltText_accessor_storage; }
    set bodyIconAltText(value) { this.#bodyIconAltText_accessor_storage = value; }
    timeoutMs = null;
    timeoutTimerId = null;
    debouncedUpdate = null;
    padding = { top: 0, bottom: 0, left: 0, right: 0 };
    fixed = false;
    focusAnchor = false;
    buttonListObserver_ = null;
    /**
     * HTMLElement corresponding to |this.nativeId|.
     */
    anchorElement_ = null;
    #progressData__accessor_storage = [];
    /**
     * Backing data for the dom-repeat that generates progress indicators.
     * The elements are placeholders only.
     */
    get progressData_() { return this.#progressData__accessor_storage; }
    set progressData_(value) { this.#progressData__accessor_storage = value; }
    /**
     * Watches the offsetParent for resize events, allowing the bubble to be
     * repositioned in response. Useful for when the content around a help bubble
     * target can be filtered/expanded/repositioned.
     */
    resizeObserver_ = null;
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('buttons')) {
            this.sortedButtons = this.buttons.toSorted(this.buttonSortFunc_);
        }
    }
    /**
     * Shows the bubble.
     */
    show(anchorElement) {
        this.anchorElement_ = anchorElement;
        // Set up the progress track.
        if (this.progress) {
            this.progressData_ = new Array(this.progress.total);
            this.progressData_.fill(true);
        }
        else {
            this.progressData_ = [];
        }
        this.closeButtonTabIndex =
            this.buttons.length ? this.buttons.length + 2 : 1;
        assert(this.anchorElement_, 'Tried to show a help bubble but anchorElement does not exist');
        // Reset the aria-hidden attribute as screen readers need to access the
        // contents of an opened bubble.
        this.style.display = 'block';
        this.style.position = this.fixed ? 'fixed' : 'absolute';
        this.removeAttribute('aria-hidden');
        this.updatePosition_();
        this.debouncedUpdate = debounceEnd(() => {
            if (this.anchorElement_) {
                this.updatePosition_();
            }
        }, 50);
        this.buttonListObserver_ = new MutationObserver(this.debouncedUpdate);
        this.buttonListObserver_.observe(this.$.buttons, { childList: true });
        window.addEventListener('resize', this.debouncedUpdate);
        if (this.timeoutMs !== null) {
            const timedOutCallback = () => {
                this.fire(HELP_BUBBLE_TIMED_OUT_EVENT, {
                    nativeId: this.nativeId,
                });
            };
            this.timeoutTimerId = setTimeout(timedOutCallback, this.timeoutMs);
        }
        if (this.offsetParent && !this.fixed) {
            this.resizeObserver_ = new ResizeObserver(() => {
                this.updatePosition_();
                this.anchorElement_?.scrollIntoView(HELP_BUBBLE_SCROLL_ANCHOR_OPTIONS);
            });
            this.resizeObserver_.observe(this.offsetParent);
        }
    }
    /**
     * Hides the bubble, clears out its contents, and ensures that screen readers
     * ignore it while hidden.
     *
     * TODO(dfried): We are moving towards formalizing help bubbles as single-use;
     * in which case most of this tear-down logic can be removed since the entire
     * bubble will go away on hide.
     */
    hide() {
        if (this.resizeObserver_) {
            this.resizeObserver_.disconnect();
            this.resizeObserver_ = null;
        }
        this.style.display = 'none';
        this.setAttribute('aria-hidden', 'true');
        this.anchorElement_ = null;
        if (this.timeoutTimerId !== null) {
            clearInterval(this.timeoutTimerId);
            this.timeoutTimerId = null;
        }
        if (this.buttonListObserver_) {
            this.buttonListObserver_.disconnect();
            this.buttonListObserver_ = null;
        }
        if (this.debouncedUpdate) {
            window.removeEventListener('resize', this.debouncedUpdate);
            this.debouncedUpdate = null;
        }
    }
    /**
     * Retrieves the current anchor element, if set and the bubble is showing,
     * otherwise null.
     */
    getAnchorElement() {
        return this.anchorElement_;
    }
    /**
     * Returns the button with the given `buttonIndex`, or null if not found.
     */
    getButtonForTesting(buttonIndex) {
        return this.$.buttons.querySelector(`[id="${ACTION_BUTTON_ID_PREFIX + buttonIndex}"]`);
    }
    /**
     * Focuses a button in the bubble.
     */
    focus() {
        // First try to focus either the default button or any action button.
        const defaultButton = this.$.buttons.querySelector('cr-button.default-button') ||
            this.$.buttons.querySelector('cr-button');
        if (defaultButton) {
            defaultButton.focus();
            return;
        }
        // As a fallback, focus the close button before trying to focus the anchor;
        // this will allow the focus to stay on the close button if the anchor
        // cannot be focused.
        this.$.close.focus();
        // Maybe try to focus the anchor. This is preferable to focusing the close
        // button, but not every element can be focused.
        if (this.anchorElement_ && this.focusAnchor) {
            this.anchorElement_.focus();
        }
    }
    /**
     * Returns whether the default button is leading (true on Windows) vs trailing
     * (all other platforms).
     */
    static isDefaultButtonLeading() {
        return isWindows;
    }
    dismiss_() {
        assert(this.nativeId, 'Dismiss: expected help bubble to have a native id.');
        this.fire(HELP_BUBBLE_DISMISSED_EVENT, {
            nativeId: this.nativeId,
            fromActionButton: false,
        });
    }
    /**
     * Handles ESC keypress (dismiss bubble) and prevents it from propagating up
     * to parent elements.
     */
    onKeyDown_(e) {
        if (e.key === 'Escape') {
            e.stopPropagation();
            this.dismiss_();
        }
    }
    /**
     * Prevent event propagation. Attach to any event that should not bubble up
     * out of the help bubble.
     */
    blockPropagation_(e) {
        e.stopPropagation();
    }
    getProgressClass_(index) {
        return index < this.progress.current ? 'current-progress' :
            'total-progress';
    }
    shouldShowTitleInTopContainer_() {
        return !!this.titleText && !this.progress;
    }
    shouldShowBodyInTopContainer_() {
        return !this.progress && !this.titleText;
    }
    shouldShowBodyInMain_() {
        return !!this.progress || !!this.titleText;
    }
    shouldShowBodyIcon_() {
        return this.bodyIconName !== null && this.bodyIconName !== '';
    }
    onButtonClick_(e) {
        assert(this.nativeId, 'Action button clicked: expected help bubble to have a native ID.');
        // There is no access to the model index here due to limitations of
        // dom-repeat. However, the index is stored in the node's identifier.
        const index = parseInt(e.target.id.substring(ACTION_BUTTON_ID_PREFIX.length));
        this.fire(HELP_BUBBLE_DISMISSED_EVENT, {
            nativeId: this.nativeId,
            fromActionButton: true,
            buttonIndex: index,
        });
    }
    getButtonId_(item) {
        const index = this.buttons.indexOf(item);
        assert(index > -1);
        return ACTION_BUTTON_ID_PREFIX + index;
    }
    getButtonClass_(isDefault) {
        return isDefault ? 'default-button focus-outline-visible' :
            'focus-outline-visible';
    }
    getButtonTabIndex_(item) {
        const index = this.buttons.indexOf(item);
        assert(index > -1);
        return item.isDefault ? 1 : index + 2;
    }
    buttonSortFunc_(button1, button2) {
        // Default button is leading on Windows, trailing on other platforms.
        if (button1.isDefault) {
            return isWindows ? -1 : 1;
        }
        if (button2.isDefault) {
            return isWindows ? 1 : -1;
        }
        return 0;
    }
    /**
     * Determine classes that describe the arrow position relative to the
     * HelpBubble
     */
    getArrowClass_() {
        let classList = '';
        // `*-edge` classes move arrow to a HelpBubble edge
        switch (this.position) {
            case HelpBubbleArrowPosition.TOP_LEFT:
            case HelpBubbleArrowPosition.TOP_CENTER:
            case HelpBubbleArrowPosition.TOP_RIGHT:
                classList = 'top-edge ';
                break;
            case HelpBubbleArrowPosition.BOTTOM_LEFT:
            case HelpBubbleArrowPosition.BOTTOM_CENTER:
            case HelpBubbleArrowPosition.BOTTOM_RIGHT:
                classList = 'bottom-edge ';
                break;
            case HelpBubbleArrowPosition.LEFT_TOP:
            case HelpBubbleArrowPosition.LEFT_CENTER:
            case HelpBubbleArrowPosition.LEFT_BOTTOM:
                classList = 'left-edge ';
                break;
            case HelpBubbleArrowPosition.RIGHT_TOP:
            case HelpBubbleArrowPosition.RIGHT_CENTER:
            case HelpBubbleArrowPosition.RIGHT_BOTTOM:
                classList = 'right-edge ';
                break;
            default:
                assertNotReached('Unknown help bubble position: ' + this.position);
        }
        // `*-position` classes move arrow along the HelpBubble edge
        switch (this.position) {
            case HelpBubbleArrowPosition.TOP_LEFT:
            case HelpBubbleArrowPosition.BOTTOM_LEFT:
                classList += 'left-position';
                break;
            case HelpBubbleArrowPosition.TOP_CENTER:
            case HelpBubbleArrowPosition.BOTTOM_CENTER:
                classList += 'horizontal-center-position';
                break;
            case HelpBubbleArrowPosition.TOP_RIGHT:
            case HelpBubbleArrowPosition.BOTTOM_RIGHT:
                classList += 'right-position';
                break;
            case HelpBubbleArrowPosition.LEFT_TOP:
            case HelpBubbleArrowPosition.RIGHT_TOP:
                classList += 'top-position';
                break;
            case HelpBubbleArrowPosition.LEFT_CENTER:
            case HelpBubbleArrowPosition.RIGHT_CENTER:
                classList += 'vertical-center-position';
                break;
            case HelpBubbleArrowPosition.LEFT_BOTTOM:
            case HelpBubbleArrowPosition.RIGHT_BOTTOM:
                classList += 'bottom-position';
                break;
            default:
                assertNotReached('Unknown help bubble position: ' + this.position);
        }
        return classList;
    }
    /**
     * Sets the bubble position, as relative to that of the anchor element and
     * |this.position|.
     */
    updatePosition_() {
        assert(this.anchorElement_, 'Update position: expected valid anchor element.');
        // How far HelpBubble is from anchorElement
        const ANCHOR_OFFSET = 16;
        const ARROW_WIDTH = 16;
        // The nearest an arrow can be to the adjacent HelpBubble edge
        const ARROW_OFFSET_FROM_EDGE = 22 + (ARROW_WIDTH / 2);
        // Inclusive of 8px visible arrow and 8px margin.
        const anchorRect = this.anchorElement_.getBoundingClientRect();
        const anchorRectCenter = {
            x: anchorRect.left + (anchorRect.width / 2),
            y: anchorRect.top + (anchorRect.height / 2),
        };
        const helpBubbleRect = this.getBoundingClientRect();
        // component is inserted at mixin root so start with anchor offsets
        let offsetX = this.anchorElement_.offsetLeft;
        let offsetY = this.anchorElement_.offsetTop;
        // Move HelpBubble to correct side of the anchorElement
        switch (this.position) {
            case HelpBubbleArrowPosition.TOP_LEFT:
            case HelpBubbleArrowPosition.TOP_CENTER:
            case HelpBubbleArrowPosition.TOP_RIGHT:
                offsetY += anchorRect.height + ANCHOR_OFFSET + this.padding.bottom;
                break;
            case HelpBubbleArrowPosition.BOTTOM_LEFT:
            case HelpBubbleArrowPosition.BOTTOM_CENTER:
            case HelpBubbleArrowPosition.BOTTOM_RIGHT:
                offsetY -= (helpBubbleRect.height + ANCHOR_OFFSET + this.padding.top);
                break;
            case HelpBubbleArrowPosition.LEFT_TOP:
            case HelpBubbleArrowPosition.LEFT_CENTER:
            case HelpBubbleArrowPosition.LEFT_BOTTOM:
                offsetX += anchorRect.width + ANCHOR_OFFSET + this.padding.right;
                break;
            case HelpBubbleArrowPosition.RIGHT_TOP:
            case HelpBubbleArrowPosition.RIGHT_CENTER:
            case HelpBubbleArrowPosition.RIGHT_BOTTOM:
                offsetX -= (helpBubbleRect.width + ANCHOR_OFFSET + this.padding.left);
                break;
            default:
                assertNotReached();
        }
        // Move HelpBubble along the anchorElement edge according to arrow position
        switch (this.position) {
            case HelpBubbleArrowPosition.TOP_LEFT:
            case HelpBubbleArrowPosition.BOTTOM_LEFT:
                // If anchor element width is small, point arrow to center of anchor
                // element
                if ((anchorRect.left + ARROW_OFFSET_FROM_EDGE) > anchorRectCenter.x) {
                    offsetX += (anchorRect.width / 2) - ARROW_OFFSET_FROM_EDGE;
                }
                break;
            case HelpBubbleArrowPosition.TOP_CENTER:
            case HelpBubbleArrowPosition.BOTTOM_CENTER:
                offsetX += (anchorRect.width / 2) - (helpBubbleRect.width / 2);
                break;
            case HelpBubbleArrowPosition.TOP_RIGHT:
            case HelpBubbleArrowPosition.BOTTOM_RIGHT:
                // If anchor element width is small, point arrow to center of anchor
                // element
                if ((anchorRect.right - ARROW_OFFSET_FROM_EDGE) < anchorRectCenter.x) {
                    offsetX += (anchorRect.width / 2) - helpBubbleRect.width +
                        ARROW_OFFSET_FROM_EDGE;
                }
                else {
                    // Right-align bubble and anchor elements
                    offsetX += anchorRect.width - helpBubbleRect.width;
                }
                break;
            case HelpBubbleArrowPosition.LEFT_TOP:
            case HelpBubbleArrowPosition.RIGHT_TOP:
                // If anchor element height is small, point arrow to center of anchor
                // element
                if ((anchorRect.top + ARROW_OFFSET_FROM_EDGE) > anchorRectCenter.y) {
                    offsetY += (anchorRect.height / 2) - ARROW_OFFSET_FROM_EDGE;
                }
                break;
            case HelpBubbleArrowPosition.LEFT_CENTER:
            case HelpBubbleArrowPosition.RIGHT_CENTER:
                offsetY += (anchorRect.height / 2) - (helpBubbleRect.height / 2);
                break;
            case HelpBubbleArrowPosition.LEFT_BOTTOM:
            case HelpBubbleArrowPosition.RIGHT_BOTTOM:
                // If anchor element height is small, point arrow to center of anchor
                // element
                if ((anchorRect.bottom - ARROW_OFFSET_FROM_EDGE) < anchorRectCenter.y) {
                    offsetY += (anchorRect.height / 2) - helpBubbleRect.height +
                        ARROW_OFFSET_FROM_EDGE;
                }
                else {
                    // Bottom-align bubble and anchor elements
                    offsetY += anchorRect.height - helpBubbleRect.height;
                }
                break;
            default:
                assertNotReached();
        }
        this.style.top = offsetY.toString() + 'px';
        this.style.left = offsetX.toString() + 'px';
    }
}
customElements.define(HelpBubbleElement.is, HelpBubbleElement);

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ANCHOR_HIGHLIGHT_CLASS = 'help-anchor-highlight';
// Return whether the current language is right-to-left
function isRtlLang(element) {
    return window.getComputedStyle(element).direction === 'rtl';
}
// Reflect arrow position across y-axis
function reflectArrowPosition(position) {
    switch (position) {
        case HelpBubbleArrowPosition.TOP_LEFT:
            return HelpBubbleArrowPosition.TOP_RIGHT;
        case HelpBubbleArrowPosition.TOP_RIGHT:
            return HelpBubbleArrowPosition.TOP_LEFT;
        case HelpBubbleArrowPosition.BOTTOM_LEFT:
            return HelpBubbleArrowPosition.BOTTOM_RIGHT;
        case HelpBubbleArrowPosition.BOTTOM_RIGHT:
            return HelpBubbleArrowPosition.BOTTOM_LEFT;
        case HelpBubbleArrowPosition.LEFT_TOP:
            return HelpBubbleArrowPosition.RIGHT_TOP;
        case HelpBubbleArrowPosition.LEFT_CENTER:
            return HelpBubbleArrowPosition.RIGHT_CENTER;
        case HelpBubbleArrowPosition.LEFT_BOTTOM:
            return HelpBubbleArrowPosition.RIGHT_BOTTOM;
        case HelpBubbleArrowPosition.RIGHT_TOP:
            return HelpBubbleArrowPosition.LEFT_TOP;
        case HelpBubbleArrowPosition.RIGHT_CENTER:
            return HelpBubbleArrowPosition.LEFT_CENTER;
        case HelpBubbleArrowPosition.RIGHT_BOTTOM:
            return HelpBubbleArrowPosition.LEFT_BOTTOM;
        default:
            return position;
    }
}
/**
 * HelpBubble controller class
 * - There should exist only one HelpBubble instance for each nativeId
 * - The mapping between nativeId and htmlId is held within this instance
 * - The rest of the parameters are passed to createBubble
 */
class HelpBubbleController {
    nativeId_;
    root_;
    anchor_ = null;
    bubble_ = null;
    options_ = { padding: { top: 0, bottom: 0, left: 0, right: 0 }, fixed: false };
    /**
     * Whether a help bubble (webui or external) is being shown for this
     * controller
     */
    isBubbleShowing_ = false;
    /** Keep track of last known anchor visibility status. */
    isAnchorVisible_ = false;
    /** Keep track of last known anchor bounds. */
    lastAnchorBounds_ = { x: 0, y: 0, width: 0, height: 0 };
    /*
     * This flag is used to know whether to send position updates for
     * external bubbles
     */
    isExternal_ = false;
    constructor(nativeId, root) {
        assert(nativeId, 'HelpBubble: nativeId was not defined when registering help bubble');
        assert(root, 'HelpBubble: shadowRoot was not defined when registering help bubble');
        this.nativeId_ = nativeId;
        this.root_ = root;
    }
    isBubbleShowing() {
        return this.isBubbleShowing_;
    }
    canShowBubble() {
        return this.hasAnchor();
    }
    hasBubble() {
        return !!this.bubble_;
    }
    getBubble() {
        return this.bubble_;
    }
    hasAnchor() {
        return !!this.anchor_;
    }
    getAnchor() {
        return this.anchor_;
    }
    getNativeId() {
        return this.nativeId_;
    }
    getPadding() {
        return this.options_.padding;
    }
    getAnchorVisibility() {
        return this.isAnchorVisible_;
    }
    getLastAnchorBounds() {
        return this.lastAnchorBounds_;
    }
    updateAnchorVisibility(isVisible, bounds) {
        const changed = isVisible !== this.isAnchorVisible_ ||
            bounds.x !== this.lastAnchorBounds_.x ||
            bounds.y !== this.lastAnchorBounds_.y ||
            bounds.width !== this.lastAnchorBounds_.width ||
            bounds.height !== this.lastAnchorBounds_.height;
        this.isAnchorVisible_ = isVisible;
        this.lastAnchorBounds_ = bounds;
        return changed;
    }
    isAnchorFixed() {
        return this.options_.fixed;
    }
    isExternal() {
        return this.isExternal_;
    }
    updateExternalShowingStatus(isShowing) {
        this.isExternal_ = true;
        this.isBubbleShowing_ = isShowing;
        this.setAnchorHighlight_(isShowing);
    }
    track(trackable, options) {
        assert(!this.anchor_);
        let anchor = null;
        if (typeof trackable === 'string') {
            anchor = this.root_.querySelector(trackable);
        }
        else if (Array.isArray(trackable)) {
            anchor = this.deepQuery(trackable);
        }
        else if (trackable instanceof HTMLElement) {
            anchor = trackable;
        }
        else {
            assertNotReached('HelpBubble: anchor argument was unrecognized when registering ' +
                'help bubble');
        }
        if (!anchor) {
            return false;
        }
        anchor.dataset['nativeId'] = this.nativeId_;
        this.anchor_ = anchor;
        this.options_ = options;
        return true;
    }
    deepQuery(selectors) {
        let cur = this.root_;
        for (const selector of selectors) {
            if (cur.shadowRoot) {
                cur = cur.shadowRoot;
            }
            const el = cur.querySelector(selector);
            if (!el) {
                return null;
            }
            else {
                cur = el;
            }
        }
        return cur;
    }
    show() {
        this.isExternal_ = false;
        if (!(this.bubble_ && this.anchor_)) {
            return;
        }
        this.bubble_.show(this.anchor_);
        this.isBubbleShowing_ = true;
        this.setAnchorHighlight_(true);
    }
    hide() {
        if (!this.bubble_) {
            return;
        }
        this.bubble_.hide();
        this.bubble_.remove();
        this.bubble_ = null;
        this.isBubbleShowing_ = false;
        this.setAnchorHighlight_(false);
    }
    createBubble(params) {
        assert(this.anchor_, 'HelpBubble: anchor was not defined when showing help bubble');
        assert(this.anchor_.parentNode, 'HelpBubble: anchor element not in DOM');
        this.bubble_ = document.createElement('help-bubble');
        this.bubble_.nativeId = this.nativeId_;
        this.bubble_.position = isRtlLang(this.anchor_) ?
            reflectArrowPosition(params.position) :
            params.position;
        this.bubble_.closeButtonAltText = params.closeButtonAltText;
        this.bubble_.bodyText = params.bodyText;
        this.bubble_.bodyIconName = params.bodyIconName || null;
        this.bubble_.bodyIconAltText = params.bodyIconAltText;
        this.bubble_.titleText = params.titleText || '';
        this.bubble_.progress = params.progress || null;
        this.bubble_.buttons = params.buttons;
        this.bubble_.padding = this.options_.padding;
        this.bubble_.focusAnchor = params.focusOnShowHint === false;
        if (params.timeout) {
            this.bubble_.timeoutMs = Number(params.timeout.microseconds / 1000n);
            assert(this.bubble_.timeoutMs > 0);
        }
        assert(!this.bubble_.progress ||
            this.bubble_.progress.total >= this.bubble_.progress.current);
        assert(this.root_);
        // Because the help bubble uses either absolute or fixed positioning, it
        // need only be placed within the offset parent of the anchor. However it is
        // placed as a sibling to the anchor because that guarantees proper tab
        // order.
        if (getComputedStyle(this.anchor_).getPropertyValue('position') ===
            'fixed') {
            this.bubble_.fixed = true;
        }
        this.anchor_.parentNode.insertBefore(this.bubble_, this.anchor_);
        return this.bubble_;
    }
    /**
     * Styles the anchor element to appear highlighted while the bubble is open,
     * or removes the highlight.
     */
    setAnchorHighlight_(highlight) {
        assert(this.anchor_, 'Set anchor highlight: expected valid anchor element.');
        this.anchor_.classList.toggle(ANCHOR_HIGHLIGHT_CLASS, highlight);
        if (highlight) {
            (this.bubble_ || this.anchor_).focus();
            this.anchor_.scrollIntoView(HELP_BUBBLE_SCROLL_ANCHOR_OPTIONS);
        }
    }
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class HelpBubbleProxyImpl {
    trackedElementHandler_ = new TrackedElementHandlerRemote();
    callbackRouter_ = new HelpBubbleClientCallbackRouter();
    handler_ = new HelpBubbleHandlerRemote();
    constructor() {
        const factory = HelpBubbleHandlerFactory.getRemote();
        factory.createHelpBubbleHandler(this.callbackRouter_.$.bindNewPipeAndPassRemote(), this.handler_.$.bindNewPipeAndPassReceiver());
        this.handler_.bindTrackedElementHandler(this.trackedElementHandler_.$.bindNewPipeAndPassReceiver());
    }
    static getInstance() {
        return instance$3 || (instance$3 = new HelpBubbleProxyImpl());
    }
    static setInstance(obj) {
        instance$3 = obj;
    }
    getTrackedElementHandler() {
        return this.trackedElementHandler_;
    }
    getHandler() {
        return this.handler_;
    }
    getCallbackRouter() {
        return this.callbackRouter_;
    }
}
let instance$3 = null;

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Logic common to components that support a help bubble.
 *
 * A component implementing this mixin should call
 * registerHelpBubble() to associate specific element identifiers
 * referenced  in an IPH or Tutorials journey with the ids of the HTML elements
 * that journey cares about (typically, points for help bubbles to anchor to).
 *
 * Multiple components in the same WebUI may have this mixin. Each mixin will
 * receive ALL help bubble-related messages from its associated WebUIController
 * and determines if any given message is relevant. This is done by checking
 * against registered identifier.
 *
 * See README.md for more information.
 */
const HelpBubbleMixinLit = (superClass) => {
    class HelpBubbleMixinLit extends superClass {
        trackedElementHandler_;
        helpBubbleHandler_;
        helpBubbleCallbackRouter_;
        /**
         * A map from the name of the native identifier used in the tutorial or
         * IPH definition to the target element's HTML ID.
         *
         * Example entry:
         *   "kHeightenSecuritySettingsElementId" => "toggleSecureMode"
         */
        helpBubbleControllerById_ = new Map();
        helpBubbleListenerIds_ = [];
        helpBubbleFixedAnchorObserver_ = null;
        helpBubbleResizeObserver_ = null;
        helpBubbleDismissedEventTracker_ = new EventTracker();
        debouncedAnchorMayHaveChangedCallback_ = null;
        constructor(...args) {
            super(...args);
            const proxy = this.createHelpBubbleProxy();
            this.trackedElementHandler_ = proxy.getTrackedElementHandler();
            this.helpBubbleHandler_ = proxy.getHandler();
            this.helpBubbleCallbackRouter_ = proxy.getCallbackRouter();
        }
        createHelpBubbleProxy() {
            return HelpBubbleProxyImpl.getInstance();
        }
        connectedCallback() {
            super.connectedCallback();
            const router = this.helpBubbleCallbackRouter_;
            this.helpBubbleListenerIds_.push(router.showHelpBubble.addListener(this.onShowHelpBubble_.bind(this)), router.toggleFocusForAccessibility.addListener(this.onToggleHelpBubbleFocusForAccessibility_.bind(this)), router.hideHelpBubble.addListener(this.onHideHelpBubble_.bind(this)), router.externalHelpBubbleUpdated.addListener(this.onExternalHelpBubbleUpdated_.bind(this)));
            const isVisible = (element) => {
                const rect = element.getBoundingClientRect();
                return rect.height > 0 && rect.width > 0;
            };
            this.debouncedAnchorMayHaveChangedCallback_ =
                debounceEnd(this.onAnchorBoundsMayHaveChanged_.bind(this), 50);
            this.helpBubbleResizeObserver_ =
                new ResizeObserver(entries => entries.forEach(({ target }) => {
                    if (target === document.body) {
                        if (this.debouncedAnchorMayHaveChangedCallback_) {
                            this.debouncedAnchorMayHaveChangedCallback_();
                        }
                    }
                    else {
                        this.onAnchorVisibilityChanged_(target, isVisible(target));
                    }
                }));
            this.helpBubbleFixedAnchorObserver_ = new IntersectionObserver(entries => entries.forEach(({ target, isIntersecting }) => this.onAnchorVisibilityChanged_(target, isIntersecting)), { root: null });
            document.addEventListener('scroll', this.debouncedAnchorMayHaveChangedCallback_, { passive: true });
            this.helpBubbleResizeObserver_.observe(document.body);
            // When the component is connected, if the target elements were
            // already registered, they should be observed now. Any targets
            // registered from this point forward will observed on registration.
            this.controllers.forEach(ctrl => this.observeControllerAnchor_(ctrl));
        }
        get controllers() {
            return Array.from(this.helpBubbleControllerById_.values());
        }
        disconnectedCallback() {
            super.disconnectedCallback();
            for (const listenerId of this.helpBubbleListenerIds_) {
                this.helpBubbleCallbackRouter_.removeListener(listenerId);
            }
            this.helpBubbleListenerIds_ = [];
            assert(this.helpBubbleResizeObserver_);
            this.helpBubbleResizeObserver_.disconnect();
            this.helpBubbleResizeObserver_ = null;
            assert(this.helpBubbleFixedAnchorObserver_);
            this.helpBubbleFixedAnchorObserver_.disconnect();
            this.helpBubbleFixedAnchorObserver_ = null;
            this.helpBubbleDismissedEventTracker_.removeAll();
            this.helpBubbleControllerById_.clear();
            if (this.debouncedAnchorMayHaveChangedCallback_) {
                document.removeEventListener('scroll', this.debouncedAnchorMayHaveChangedCallback_);
                this.debouncedAnchorMayHaveChangedCallback_ = null;
            }
        }
        /**
         * Maps `nativeId`, which should be the name of a ui::ElementIdentifier
         * referenced by the WebUIController, with either:
         * - a selector
         * - an array of selectors (will traverse shadow DOM elements)
         * - an arbitrary HTMLElement
         *
         * The referenced element should have block display and non-zero size
         * when visible (inline elements may be supported in the future).
         *
         * Example:
         *   registerHelpBubble(
         *       'kMyComponentTitleLabelElementIdentifier',
         *       '#title');
         *
         * Example:
         *   registerHelpBubble(
         *       'kMyComponentTitleLabelElementIdentifier',
         *       ['#child-component', '#child-component-button']);
         *
         * Example:
         *   registerHelpBubble(
         *       'kMyComponentTitleLabelElementIdentifier',
         *       this.$.list.childNodes[0]);
         *
         * See README.md for full instructions.
         *
         * This method can be called multiple times to re-register the
         * nativeId to a new element/selector. If the help bubble is already
         * showing, the registration will fail and return null. If successful,
         * this method returns the new controller.
         *
         * Optionally, an options object may be supplied to change the
         * default behavior of the help bubble.
         *
         * - Fixed positioning detection:
         *  e.g. `{fixed: true}`
         *  By default, this mixin detects anchor elements when
         *  rendered within the document. This breaks with
         *  fix-positioned elements since they are not in the regular
         *  flow of the document but they are always visible. Passing
         *  {"fixed": true} will detect the anchor element when it is
         *  visible.
         *
         * - Add padding around anchor element:
         *  e.g. `{anchorPaddingTop: 5}`
         *  To add to the default margin around the anchor element in all
         *  4 directions, e.g. {"anchorPaddingTop": 5} adds 5 pixels to
         *  the margin at the top off the anchor element. The margin is
         *  used when calculating how far the help bubble should be spaced
         *  from the anchor element. Larger values equate to a larger visual
         *  gap. These values must be positive integers in the range [0, 20].
         *  This option should be used sparingly where the help bubble would
         *  otherwise conceal important UI.
         */
        registerHelpBubble(nativeId, trackable, options = {}) {
            if (this.helpBubbleControllerById_.has(nativeId)) {
                const ctrl = this.helpBubbleControllerById_.get(nativeId);
                if (ctrl && ctrl.isBubbleShowing()) {
                    return null;
                }
                this.unregisterHelpBubble(nativeId);
            }
            const controller = new HelpBubbleController(nativeId, this.shadowRoot);
            controller.track(trackable, parseOptions(options));
            this.helpBubbleControllerById_.set(nativeId, controller);
            // This can be called before or after `connectedCallback()`, so if the
            // component isn't connected and the observer set up yet, delay
            // observation until it is.
            if (this.helpBubbleResizeObserver_) {
                this.observeControllerAnchor_(controller);
            }
            return controller;
        }
        /**
         * Unregisters a help bubble nativeId.
         *
         * This method will remove listeners, hide the help bubble if
         * showing, and forget the nativeId.
         */
        unregisterHelpBubble(nativeId) {
            const ctrl = this.helpBubbleControllerById_.get(nativeId);
            if (ctrl && ctrl.hasAnchor()) {
                this.onAnchorVisibilityChanged_(ctrl.getAnchor(), false);
                this.unobserveControllerAnchor_(ctrl);
            }
            this.helpBubbleControllerById_.delete(nativeId);
        }
        observeControllerAnchor_(controller) {
            const anchor = controller.getAnchor();
            assert(anchor, 'Help bubble does not have anchor');
            if (controller.isAnchorFixed()) {
                assert(this.helpBubbleFixedAnchorObserver_);
                this.helpBubbleFixedAnchorObserver_.observe(anchor);
            }
            else {
                assert(this.helpBubbleResizeObserver_);
                this.helpBubbleResizeObserver_.observe(anchor);
            }
        }
        unobserveControllerAnchor_(controller) {
            const anchor = controller.getAnchor();
            assert(anchor, 'Help bubble does not have anchor');
            if (controller.isAnchorFixed()) {
                assert(this.helpBubbleFixedAnchorObserver_);
                this.helpBubbleFixedAnchorObserver_.unobserve(anchor);
            }
            else {
                assert(this.helpBubbleResizeObserver_);
                this.helpBubbleResizeObserver_.unobserve(anchor);
            }
        }
        /**
         * Returns whether any help bubble is currently showing in this
         * component.
         */
        isHelpBubbleShowing() {
            return this.controllers.some(ctrl => ctrl.isBubbleShowing());
        }
        /**
         * Returns whether any help bubble is currently showing on a tag
         * with this id.
         */
        isHelpBubbleShowingForTesting(id) {
            const ctrls = this.controllers.filter(this.filterMatchingIdForTesting_(id));
            return !!ctrls[0];
        }
        /**
         * Returns the help bubble currently showing on a tag with this
         * id.
         */
        getHelpBubbleForTesting(id) {
            const ctrls = this.controllers.filter(this.filterMatchingIdForTesting_(id));
            return ctrls[0] ? ctrls[0].getBubble() : null;
        }
        filterMatchingIdForTesting_(anchorId) {
            return ctrl => ctrl.isBubbleShowing() && ctrl.getAnchor() !== null &&
                ctrl.getAnchor().id === anchorId;
        }
        /**
         * Testing method to validate that anchors will be properly
         * located at runtime
         *
         * Call this method in your browser_tests after your help
         * bubbles have been registered. Results are sorted to be
         * deterministic.
         */
        getSortedAnchorStatusesForTesting() {
            return this.controllers
                .sort((a, b) => a.getNativeId().localeCompare(b.getNativeId()))
                .map(ctrl => ([ctrl.getNativeId(), ctrl.hasAnchor()]));
        }
        /**
         * Returns whether a help bubble can be shown
         * This requires:
         * - the mixin is tracking this controller
         * - the controller is in a state to be shown, e.g.
         *   `.canShowBubble()`
         * - no other showing bubbles are anchored to the same element
         */
        canShowHelpBubble(controller) {
            if (!this.helpBubbleControllerById_.has(controller.getNativeId())) {
                return false;
            }
            if (!controller.canShowBubble()) {
                return false;
            }
            const anchor = controller.getAnchor();
            // Make sure no other help bubble is showing for this anchor.
            const anchorIsUsed = this.controllers.some(otherCtrl => otherCtrl.isBubbleShowing() && otherCtrl.getAnchor() === anchor);
            return !anchorIsUsed;
        }
        /**
         * Displays a help bubble with `params` anchored to the HTML element
         * with id `anchorId`. Note that `params.nativeIdentifier` is ignored by
         * this method, since the anchor is already specified.
         */
        showHelpBubble(controller, params) {
            assert(this.canShowHelpBubble(controller), 'Can\'t show help bubble');
            const bubble = controller.createBubble(params);
            this.helpBubbleDismissedEventTracker_.add(bubble, HELP_BUBBLE_DISMISSED_EVENT, this.onHelpBubbleDismissed_.bind(this));
            this.helpBubbleDismissedEventTracker_.add(bubble, HELP_BUBBLE_TIMED_OUT_EVENT, this.onHelpBubbleTimedOut_.bind(this));
            controller.show();
        }
        /**
         * Hides a help bubble anchored to element with id `anchorId` if there
         * is one. Returns true if a bubble was hidden.
         */
        hideHelpBubble(nativeId) {
            const ctrl = this.helpBubbleControllerById_.get(nativeId);
            if (!ctrl || !ctrl.hasBubble()) {
                // `!ctrl` means this identifier is not handled by this mixin
                return false;
            }
            this.helpBubbleDismissedEventTracker_.remove(ctrl.getBubble(), HELP_BUBBLE_DISMISSED_EVENT);
            this.helpBubbleDismissedEventTracker_.remove(ctrl.getBubble(), HELP_BUBBLE_TIMED_OUT_EVENT);
            ctrl.hide();
            return true;
        }
        /**
         * Sends an "activated" event to the ElementTracker system for the
         * element with id `anchorId`, which must have been registered as a help
         * bubble anchor. This event will be processed in the browser and may
         * e.g. cause a Tutorial or interactive test to advance to the next
         * step.
         *
         * TODO(crbug.com/40243127): Figure out how to automatically send the
         * activated event when an anchor element is clicked.
         */
        notifyHelpBubbleAnchorActivated(nativeId) {
            const ctrl = this.helpBubbleControllerById_.get(nativeId);
            if (!ctrl || !ctrl.isBubbleShowing()) {
                return false;
            }
            this.trackedElementHandler_.trackedElementActivated(nativeId);
            return true;
        }
        /**
         * Sends a custom event to the ElementTracker system for the element
         * with id `anchorId`, which must have been registered as a help bubble
         * anchor. This event will be processed in the browser and may e.g.
         * cause a Tutorial or interactive test to advance to the next step.
         *
         * The `customEvent` string should correspond to the name of a
         * ui::CustomElementEventType declared in the browser code.
         */
        notifyHelpBubbleAnchorCustomEvent(nativeId, customEvent) {
            const ctrl = this.helpBubbleControllerById_.get(nativeId);
            if (!ctrl || !ctrl.isBubbleShowing()) {
                return false;
            }
            this.trackedElementHandler_.trackedElementCustomEvent(nativeId, customEvent);
            return true;
        }
        /**
         * This event is emitted by the mojo router
         */
        onAnchorVisibilityChanged_(target, isVisible) {
            const nativeId = target.dataset['nativeId'];
            assert(nativeId);
            const ctrl = this.helpBubbleControllerById_.get(nativeId);
            const hidden = this.hideHelpBubble(nativeId);
            if (hidden) {
                this.helpBubbleHandler_.helpBubbleClosed(nativeId, HelpBubbleClosedReason.kPageChanged);
            }
            const bounds = isVisible ? this.getElementBounds_(target) :
                { x: 0, y: 0, width: 0, height: 0 };
            if (!ctrl || ctrl.updateAnchorVisibility(isVisible, bounds)) {
                this.trackedElementHandler_.trackedElementVisibilityChanged(nativeId, isVisible, bounds);
            }
        }
        /**
         * When the document scrolls or resizes, we need to update cached
         * positions of bubble anchors.
         */
        onAnchorBoundsMayHaveChanged_() {
            for (const ctrl of this.controllers) {
                if (ctrl.hasAnchor() && ctrl.getAnchorVisibility()) {
                    const bounds = this.getElementBounds_(ctrl.getAnchor());
                    if (ctrl.updateAnchorVisibility(true, bounds)) {
                        this.trackedElementHandler_.trackedElementVisibilityChanged(ctrl.getNativeId(), true, bounds);
                    }
                }
            }
        }
        /**
         * Returns bounds of the anchor element
         */
        getElementBounds_(element) {
            const rect = { x: 0, y: 0, width: 0, height: 0 };
            const bounds = element.getBoundingClientRect();
            rect.x = bounds.x;
            rect.y = bounds.y;
            rect.width = bounds.width;
            rect.height = bounds.height;
            const nativeId = element.dataset['nativeId'];
            if (!nativeId) {
                return rect;
            }
            const ctrl = this.helpBubbleControllerById_.get(nativeId);
            if (ctrl) {
                const padding = ctrl.getPadding();
                rect.x -= padding.left;
                rect.y -= padding.top;
                rect.width += padding.left + padding.right;
                rect.height += padding.top + padding.bottom;
            }
            return rect;
        }
        /**
         * This event is emitted by the mojo router
         */
        onShowHelpBubble_(params) {
            if (!this.helpBubbleControllerById_.has(params.nativeIdentifier)) {
                // Identifier not handled by this mixin.
                return;
            }
            const ctrl = this.helpBubbleControllerById_.get(params.nativeIdentifier);
            this.showHelpBubble(ctrl, params);
        }
        /**
         * This event is emitted by the mojo router
         */
        onToggleHelpBubbleFocusForAccessibility_(nativeId) {
            if (!this.helpBubbleControllerById_.has(nativeId)) {
                // Identifier not handled by this mixin.
                return;
            }
            const ctrl = this.helpBubbleControllerById_.get(nativeId);
            if (ctrl) {
                const anchor = ctrl.getAnchor();
                if (anchor) {
                    anchor.focus();
                }
            }
        }
        /**
         * This event is emitted by the mojo router
         */
        onHideHelpBubble_(nativeId) {
            // This may be called with nativeId not handled by this mixin
            // Ignore return value to silently fail
            this.hideHelpBubble(nativeId);
        }
        /**
         * This event is emitted by the mojo router.
         */
        onExternalHelpBubbleUpdated_(nativeId, shown) {
            if (!this.helpBubbleControllerById_.has(nativeId)) {
                // Identifier not handled by this mixin.
                return;
            }
            // Get the associated bubble and update status
            const ctrl = this.helpBubbleControllerById_.get(nativeId);
            ctrl.updateExternalShowingStatus(shown);
        }
        /**
         * This event is emitted by the help-bubble component
         */
        onHelpBubbleDismissed_(e) {
            const nativeId = e.detail.nativeId;
            assert(nativeId);
            const hidden = this.hideHelpBubble(nativeId);
            assert(hidden);
            if (nativeId) {
                if (e.detail.fromActionButton) {
                    this.helpBubbleHandler_.helpBubbleButtonPressed(nativeId, e.detail.buttonIndex);
                }
                else {
                    this.helpBubbleHandler_.helpBubbleClosed(nativeId, HelpBubbleClosedReason.kDismissedByUser);
                }
            }
        }
        /**
         * This event is emitted by the help-bubble component
         */
        onHelpBubbleTimedOut_(e) {
            const nativeId = e.detail.nativeId;
            const ctrl = this.helpBubbleControllerById_.get(nativeId);
            assert(ctrl);
            const hidden = this.hideHelpBubble(nativeId);
            assert(hidden);
            if (nativeId) {
                this.helpBubbleHandler_.helpBubbleClosed(nativeId, HelpBubbleClosedReason.kTimedOut);
            }
        }
    }
    return HelpBubbleMixinLit;
};
function parseOptions(options) {
    const padding = { top: 0, bottom: 0, left: 0, right: 0 };
    padding.top = clampPadding(options.anchorPaddingTop);
    padding.left = clampPadding(options.anchorPaddingLeft);
    padding.bottom = clampPadding(options.anchorPaddingBottom);
    padding.right = clampPadding(options.anchorPaddingRight);
    return {
        padding,
        fixed: !!options.fixed,
    };
}
function clampPadding(n = 0) {
    return Math.max(0, Math.min(20, n));
}

let instance$2 = null;
function getCss() {
    return instance$2 || (instance$2 = [...[getCss$e(), getCss$f()], css `:host{--cr-composebox-input-placeholder-color:var(--color-new-tab-page-common-input-placeholder);--cr-focus-outline-color:var(--color-new-tab-page-focus-ring);--cr-searchbox-height:48px;--cr-searchbox-shadow:0 1px 6px 0 var(--color-searchbox-shadow);--cr-searchbox-icon-left-position:12px;--cr-searchbox-icon-size-in-searchbox:20px;--cr-searchbox-icon-top-position:0;--cr-searchbox-min-width:var(--ntp-search-box-width);--cr-searchbox-results-search-icon-size:20px;--ntp-theme-text-shadow:none;--ntp-one-google-bar-height:56px;--ntp-search-box-width:337px;--ntp-menu-shadow:var(--color-new-tab-page-menu-inner-shadow) 0 1px 2px 0,var(--color-new-tab-page-menu-outer-shadow) 0 2px 6px 2px;--ntp-module-width:360px;--ntp-module-layout-width:360px;--ntp-module-border-radius:16px;--ntp-module-item-border-radius:12px;--ntp-protected-icon-background-color:transparent;--ntp-protected-icon-background-color-hovered:rgba(255,255,255,.1);--ntp-scrim-opacity_:1}:host([show-composebox_]:not([ntp-realbox-next-enabled_])) cr-most-visited,:host([show-composebox_]:not([ntp-realbox-next-enabled_])) ntp-middle-slot-promo,:host([show-composebox_]:not([ntp-realbox-next-enabled_])) ntp-modules,:host([show-composebox_]:not([ntp-realbox-next-enabled_])) #backgroundImageAttribution,:host([show-composebox_]:not([ntp-realbox-next-enabled_])) ntp-customize-buttons,:host([show-composebox_]:not([ntp-realbox-next-enabled_])) setup-list-module-wrapper{display:none}:host([ntp-realbox-next-enabled_]){--ntp-scrim-opacity_:0.5}:host([realbox-can-show-secondary-side][realbox-had-secondary-side]),:host([realbox-can-show-secondary-side]){--ntp-search-box-width:746px}@media (min-width:560px){:host{--ntp-search-box-width:449px}}@media (min-width:672px){:host{--ntp-search-box-width:561px}}@media (min-width:804px){:host{--ntp-module-layout-width:768px;--ntp-module-width:768px}}cr-most-visited{--add-shortcut-background-color:var(--color-new-tab-page-add-shortcut-background);--add-shortcut-foreground-color:var(--color-new-tab-page-add-shortcut-foreground)}:host([show-background-image_]){--ntp-theme-text-shadow:0.5px 0.5px 1px rgba(0,0,0,0.5),0px 0px 2px rgba(0,0,0,0.2),0px 0px 10px rgba(0,0,0,0.1);--ntp-protected-icon-background-color:rgba(0,0,0,.6);--ntp-protected-icon-background-color-hovered:rgba(0,0,0,.7)}#oneGoogleBarStackingContext{display:flex;border:0px;top:0;width:100%;z-index:1000}:host([show-scrim_]) #oneGoogleBarStackingContext{z-index:0}#oneGoogleBarScrim{background:linear-gradient(rgba(0,0,0,0.25) 0%,rgba(0,0,0,0.12) 45%,rgba(0,0,0,0.05) 65%,transparent 100%);height:80px;position:absolute;top:0;width:100%}#oneGoogleBarScrim[fixed]{position:fixed}#oneGoogleBar{height:100%;position:absolute;top:0;width:100%}#content{align-items:center;display:flex;flex-direction:column;height:calc(100vh - var(--ntp-one-google-bar-height));min-width:fit-content;padding-top:var(--ntp-one-google-bar-height);position:relative;z-index:1}:host([show-composebox_]) #content{z-index:unset}#logo{margin-bottom:38px;z-index:1}:host([show-composebox_]) #logo,:host([ntp-realbox-next-enabled_][show-scrim_]) #logo{z-index:2}#searchboxContainer{--cr-focus-outline-color:var(--color-searchbox-results-icon-focused-outline);display:inherit;margin-bottom:16px;position:relative;z-index:2}#modules:not([hidden]){animation:300ms ease-in-out fade-in-animation}@keyframes fade-in-animation{0%{opacity:0}100%{opacity:1}}ntp-middle-slot-promo{max-width:var(--ntp-search-box-width)}cr-searchbox{visibility:hidden}cr-searchbox[shown]{visibility:visible}cr-most-visited{--cr-menu-shadow:var(--ntp-menu-shadow);--most-visited-focus-shadow:var(--ntp-focus-shadow);--most-visited-text-color:var(--color-new-tab-page-most-visited-foreground);--most-visited-text-shadow:var(--ntp-theme-text-shadow)}ntp-middle-slot-promo:not([hidden])~#modules{margin-top:16px}#themeAttribution{align-self:flex-start;bottom:16px;color:var(--color-new-tab-page-secondary-foreground);margin-inline-start:16px;position:fixed}#backgroundImageAttribution{border-radius:8px;bottom:16px;color:var(--color-new-tab-page-attribution-foreground);line-height:20px;max-width:50vw;padding:8px;position:fixed;z-index:-1;background-color:var(--ntp-protected-icon-background-color);text-shadow:none}#backgroundImageAttribution:hover{background-color:var(--ntp-protected-icon-background-color-hovered);background:rgba(var(--google-grey-900-rgb),.1)}:host-context([dir='ltr']) #backgroundImageAttribution{left:16px}:host-context([dir='rtl']) #backgroundImageAttribution{right:16px}#backgroundImageAttribution1Container{align-items:center;display:flex;flex-direction:row}#linkIcon{-webkit-mask-image:url(icons/link.svg);-webkit-mask-repeat:no-repeat;-webkit-mask-size:100%;background-color:var(--color-new-tab-page-attribution-foreground);height:16px;margin-inline-end:8px;width:16px}#backgroundImageAttribution1,#backgroundImageAttribution2{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}#backgroundImageAttribution1{font-size:.875rem}#backgroundImageAttribution2{font-size:.75rem}#customizeButtons{bottom:16px;position:fixed}:host-context([dir='ltr']) #customizeButtons{right:16px}:host-context([dir='rtl']) #customizeButtons{left:16px}#contentBottomSpacer{flex-shrink:0;height:32px;width:1px}svg{position:fixed}cr-composebox{--cr-composebox-width:var(--ntp-search-box-width);--cr-composebox-background-color:var(--color-composebox-background);--text-input-inline-end-spacing:90px}cr-composebox,ntp-lens-upload-dialog{left:0;position:absolute;right:0;top:0;z-index:101}#scrim{background:var(--color-composebox-scrim-background);inset:0;opacity:var(--ntp-scrim-opacity_);position:fixed;transition:all 250ms ease;z-index:1}#webstoreToast{padding:16px}#microsoftAuth{display:none}#dialogAnchor{anchor-name:--dialog-anchor;inset-inline-start:0;position:absolute;top:0}#composeboxDialog{background:transparent;border:none;inset-inline-start:anchor(start);margin:0;overflow:visible;position:absolute;position-anchor:--dialog-anchor;top:anchor(top)}#composeboxDialog::backdrop{display:none}#undoToast{flex-grow:1}`]);
}

function getHtml() {
    return html `<!--_html_template_start_--><!-- #html_wrapper_imports_start
import {nothing} from '//resources/lit/v3_0/lit.rollup.js';
#html_wrapper_imports_end -->
<div id="content">
  ${this.lazyRender_ && this.microsoftModuleEnabled_ ? html `
    <iframe id="microsoftAuth" src="${this.microsoftAuthIframePath_}"></iframe>
  ` : ''}
  ${this.lazyRender_ && this.oneGoogleBarEnabled_ ?
        (this.ntpRealboxNextEnabled_ ?
            html `
        <div id="oneGoogleBarStackingContext">
          <div id="oneGoogleBarScrim" ?hidden="${!this.showBackgroundImage_}"
              ?fixed="${this.scrolledToTop_}"></div>
          <ntp-iframe id="oneGoogleBar" src="${this.oneGoogleBarIframePath_}"
              ?hidden="${!this.oneGoogleBarLoaded_}"
              allow="camera ${this.oneGoogleBarIframeOrigin_}; display-capture ${this.oneGoogleBarIframeOrigin_}"> <!-- presubmit: ignore-long-line -->
          </ntp-iframe>
        </div>
        ` :
            html `
        <div id="oneGoogleBarScrim" ?hidden="${!this.showBackgroundImage_}"
            ?fixed="${this.scrolledToTop_}"></div>
        <ntp-iframe id="oneGoogleBar" src="${this.oneGoogleBarIframePath_}"
            ?hidden="${!this.oneGoogleBarLoaded_}"
            allow="camera ${this.oneGoogleBarIframeOrigin_}; display-capture ${this.oneGoogleBarIframeOrigin_}"> <!-- presubmit: ignore-long-line -->
        </ntp-iframe>
        `) : ''}
  <!-- TODO(crbug.com/40743294): Instead of ?hidden="\${!this.logoEnabled_}" it would
       be nicer to use Lit's conditional rendering. However, that breaks
       StartupBrowserCreatorPickerNoParamsTest.ShowPickerWhenAlreadyLaunched on
       the msan builder. See crbug.com/1169070. -->
  <ntp-logo id="logo" ?single-colored="${this.singleColoredLogo_}"
      .theme="${this.theme_}" ?hidden="${!this.logoEnabled_}">
  </ntp-logo>
  ${this.ntpRealboxNextEnabled_ ? html `
    <div id="scrim"
        @click="${this.showComposebox_ && this.composeboxCloseByClickOutside_ ? this.onComposeboxClickOutside_ : nothing}"
        ?hidden="${!this.showScrim_}"></div>
  ` : ''}
  <div id="searchboxContainer">
    <cr-searchbox id="searchbox" ?is-dark="${this.isThemeDark_()}"
        placeholder-text="$i18n{searchBoxPlaceholder}"
        ?color-source-is-baseline="${this.colorSourceIsBaseline}"
        @open-composebox="${this.openComposebox_}"
        @open-lens-search="${this.onOpenLensSearch_}"
        @open-voice-search="${this.onOpenVoiceSearch_}" ?shown="${this.realboxShown_}"
        ?had-secondary-side="${this.realboxHadSecondarySide}"
        @had-secondary-side-changed="${this.onRealboxHadSecondarySideChanged_}"
        @context-menu-entrypoint-click="${this.onContextMenuEntrypointClick_}"
        ?can-show-secondary-side="${this.realboxCanShowSecondarySide}"
        ?compose-button-enabled="${this.composeButtonEnabled}"
        ?composebox-enabled="${this.composeboxEnabled}"
        searchbox-layout-mode="${this.realboxLayoutMode_}"
        ?ntp-realbox-next-enabled="${this.ntpRealboxNextEnabled_}"
        ?cycling-placeholders="${this.searchboxCyclingPlaceholders_}"
        @searchbox-input-focus-changed="${this.onInputFocusChanged_}"
        context-menu-glif-animation-state="${this.contextMenuGlifAnimationState_}"
        ?multi-line-enabled="${this.multiLineEnabled_}">
    </cr-searchbox>
    ${this.showComposebox_ ? html `
      ${this.enableModalComposebox_ ? html `
        <div id="dialogAnchor"></div>
        <dialog id="composeboxDialog">
          <cr-composebox id="composebox"
              ?ntp-realbox-next-enabled="${this.ntpRealboxNextEnabled_}"
              ?searchbox-next-enabled="${this.ntpRealboxNextEnabled_}"
              ?disable-caret-color-animation="${true}"
              @composebox-initialized="${this.onComposeboxInitialized_}"
              @close-composebox="${this.closeComposebox_}"
              @composebox-input-focus-changed="${this.onInputFocusChanged_}"
              @context-menu-entrypoint-click="${this.onContextMenuEntrypointClick_}"
              @voice-search-action="${this.onComposeVoiceSearchAction_}"
              searchbox-layout-mode="${this.realboxLayoutMode_}">
          </cr-composebox>
        </dialog>
      ` : html `
        <cr-composebox id="composebox"
            ?ntp-realbox-next-enabled="${this.ntpRealboxNextEnabled_}"
            ?searchbox-next-enabled="${this.ntpRealboxNextEnabled_}"
            ?disable-caret-color-animation="${true}"
            @composebox-initialized="${this.onComposeboxInitialized_}"
            @close-composebox="${this.closeComposebox_}"
            @composebox-input-focus-changed="${this.onInputFocusChanged_}"
            @voice-search-query="${this.onComposeVoiceSearchAction_}"
            searchbox-layout-mode="${this.realboxLayoutMode_}">
        </cr-composebox>
      `}
    ` : ''}
    ${this.showLensUploadDialog_ ? html `
      <ntp-lens-upload-dialog id="lensUploadDialog"
          @close-lens-search="${this.onCloseLensSearch_}">
      </ntp-lens-upload-dialog>
    ` : ''}
  </div>
  ${this.lazyRender_
        && this.ntpNextFeaturesEnabled_ && this.isActionChipsVisible_ ? html `
    <ntp-action-chips
        ?theme-has-background-image="${this.themeHasBackgroundImage_()}"
        @action-chip-click="${this.openComposebox_}"
        @action-chips-retrieval-state-changed="${this.onActionChipsRetrievalStateChanged_}">
    </ntp-action-chips>
  ` : ''}
  ${this.lazyRender_ ? html `
    <cr-toast id="webstoreToast" duration="10000" hidden>
      <div>$i18n{webstoreThemesToastMessage}</div>
      <cr-button @click="${this.onWebstoreToastButtonClick_}">
        $i18n{webstoreThemesToastButtonText}
      </cr-button>
    </cr-toast>
  ` : ''}
  ${this.lazyRender_ ? html `
    ${this.shortcutsEnabled_ ? html `
      <cr-most-visited id="mostVisited" .theme="${this.theme_?.mostVisited || null}"
          single-row reflow-on-overflow
          ?expandable-tiles-enabled="${this.ntpNextFeaturesEnabled_}"
          max-tiles-before-show-more="${this.maxTilesBeforeShowMore_}"
          @most-visited-auto-removed="${this.showAutoRemovedToast_}">
      </cr-most-visited>
    ` : ''}
    ${this.middleSlotPromoEnabled_ ? html `
      <ntp-middle-slot-promo
          @ntp-middle-slot-promo-loaded="${this.onMiddleSlotPromoLoaded_}"
          ?hidden="${!this.promoAndModulesLoaded_}">
      </ntp-middle-slot-promo>
    ` : ''}
    ${this.modulesEnabled_ ? html `
      ${html `
        <ntp-modules id="modules"
            ?modules-shown-to-user="${this.modulesShownToUser}"
            @modules-shown-to-user-changed="${this.onModulesShownToUserChanged_}"
            @customize-module="${this.onCustomizeModule_}"
            @modules-loaded="${this.onModulesLoaded_}"
            @modules-auto-removed="${this.showAutoRemovedToast_}"
            ?hidden="${!this.promoAndModulesLoaded_}">
        </ntp-modules>
      `}
    ` : ''}
    ${this.shortcutsEnabled_ || this.modulesEnabled_ ? html `
      <cr-toast id="undoToast" duration="10000">
        <div id="undoToastMessage">${this.undoAutoRemovalMessage_ || ''}</div>
        <cr-button id="undoButton"
            aria-label="$i18n{undoDescription}"
            @click="${this.onAutoRemovalUndoClick_}">
          $i18n{undo}
        </cr-button>
      </cr-toast>
    ` : ''}
    ${this.showBrowserPromo_ ? (() => {
        switch (this.browserPromoType_) {
            case "simple":
                return html `
        <individual-promos maxPromos="${this.browserPromoLimit_}">
        </individual-promos>

      `;
            case "setuplist":
                return html `
        <setup-list-module-wrapper maxPromos="${this.browserPromoLimit_}"
            maxCompletedPromos="${this.browserPromoCompletedLimit_}">
        </setup-list-module-wrapper>
      `;
            default:
                return '';
        }
    })() : ''}
  ${!this.isFooterVisible_ ? html `
      <a id="backgroundImageAttribution"
          href="${this.backgroundImageAttributionUrl_}"
          ?hidden="${!this.backgroundImageAttribution1_}">
        <div id="backgroundImageAttribution1Container">
          <div id="linkIcon" ?hidden="${!this.backgroundImageAttributionUrl_}"></div>
          <div id="backgroundImageAttribution1">
            ${this.backgroundImageAttribution1_}
          </div>
        </div>
        <div id="backgroundImageAttribution2"
            ?hidden="${!this.backgroundImageAttribution2_}">
          ${this.backgroundImageAttribution2_}
        </div>
      </a>
      <ntp-customize-buttons id="customizeButtons"
          ?modules-shown-to-user="${this.modulesShownToUser}"
          ?show-background-image="${this.showBackgroundImage_}"
          ?show-customize="${this.showCustomize_}"
          ?show-customize-chrome-text="${this.showCustomizeChromeText_}"
          ?show-wallpaper-search="${this.showWallpaperSearch_}"
          ?show-wallpaper-search-button="${this.showWallpaperSearchButton_}"
          ?wallpaper-search-button-animation-enabled="${this.wallpaperSearchButtonAnimationEnabled_}"
          @customize-click="${this.onCustomizeClick_}"
          @wallpaper-search-click="${this.onWallpaperSearchClick_}" show-shadow>
      </ntp-customize-buttons>
    ` : ''}
    ${this.showThemeAttribution_() ? html `
      <div id="themeAttribution">
        <div>$i18n{themeCreatedBy}</div>
        <img src="${this.theme_.backgroundImage.attributionUrl.url}">
      </div>
    ` : ''}
  ` : ''}
  <div id="contentBottomSpacer"></div>
</div>
${this.showVoiceSearchOverlay_ ? html `
  <ntp-voice-search-overlay @close="${this.onVoiceSearchOverlayClose_}">
  </ntp-voice-search-overlay>
` : ''}
${!this.ntpRealboxNextEnabled_ && this.showComposebox_ ? html `
  <div id="scrim"
      @click="${this.composeboxCloseByClickOutside_ ? this.onComposeboxClickOutside_ : nothing}"></div>
` : ''}
<svg>
  <defs>
    <clipPath id="oneGoogleBarClipPath">
      <!-- Set an initial non-empty clip-path so the OneGoogleBar resize events
           are processed. When the clip-path is empty, it's possible for the
           OneGoogleBar to get into a state where it does not send  the
           'overlayUpdates' message which is used to populate this
           clip-path. -->
      <rect x="0" y="0" width="1" height="1"></rect>
    </clipPath>
  </defs>
</svg>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview PromiseResolver is a helper class that allows creating a
 * Promise that will be fulfilled (resolved or rejected) some time later.
 *
 * Example:
 *  const resolver = new PromiseResolver();
 *  resolver.promise.then(function(result) {
 *    console.log('resolved with', result);
 *  });
 *  ...
 *  ...
 *  resolver.resolve({hello: 'world'});
 */
class PromiseResolver {
    resolve_ = () => { };
    reject_ = () => { };
    isFulfilled_ = false;
    promise_;
    constructor() {
        this.promise_ = new Promise((resolve, reject) => {
            this.resolve_ = (resolution) => {
                resolve(resolution);
                this.isFulfilled_ = true;
            };
            this.reject_ = (reason) => {
                reject(reason);
                this.isFulfilled_ = true;
            };
        });
    }
    /** Whether this resolver has been resolved or rejected. */
    get isFulfilled() {
        return this.isFulfilled_;
    }
    get promise() {
        return this.promise_;
    }
    get resolve() {
        return this.resolve_;
    }
    get reject() {
        return this.reject_;
    }
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview The background manager brokers access to background related
 * DOM elements. The reason for this abstraction is that the these elements are
 * not owned by any custom elements (this is done so that the aforementioned DOM
 * elements load faster at startup).
 *
 * The background manager expects an iframe with ID 'backgroundImage' to be
 * present in the DOM. It will use that element to set the background image URL.
 */
/**
 * Installs a listener for background image load times and manages a
 * |PromiseResolver| that resolves to the captured load time.
 */
class LoadTimeResolver {
    resolver_ = new PromiseResolver();
    eventTracker_ = new EventTracker();
    constructor(url) {
        this.eventTracker_.add(window, 'message', ({ data }) => {
            if (data.frameType === 'background-image' &&
                data.messageType === 'loaded' && url === data.url) {
                this.resolve_(data.time);
            }
        });
    }
    get promise() {
        return this.resolver_.promise;
    }
    reject() {
        this.resolver_.reject();
        this.eventTracker_.removeAll();
    }
    resolve_(loadTime) {
        this.resolver_.resolve(loadTime);
        this.eventTracker_.removeAll();
    }
}
let instance$1 = null;
class BackgroundManager {
    static getInstance() {
        return instance$1 || (instance$1 = new BackgroundManager());
    }
    static setInstance(newInstance) {
        instance$1 = newInstance;
    }
    backgroundImage_;
    loadTimeResolver_ = null;
    url_;
    constructor() {
        this.backgroundImage_ =
            strictQuery(document.body, '#backgroundImage', HTMLIFrameElement);
        this.url_ = this.backgroundImage_.src;
    }
    /**
     * Sets whether the background image should be shown.
     * @param show True, if the background image should be shown.
     */
    setShowBackgroundImage(show) {
        document.body.toggleAttribute('show-background-image', show);
    }
    /** Sets the background color. */
    setBackgroundColor(color) {
        document.body.style.backgroundColor = skColorToRgba(color);
    }
    /** Sets the background image. */
    setBackgroundImage(image) {
        const url = new URL('chrome-untrusted://new-tab-page/custom_background_image');
        url.searchParams.append('url', image.url.url);
        if (image.url2x) {
            url.searchParams.append('url2x', image.url2x.url);
        }
        if (image.size) {
            url.searchParams.append('size', image.size);
        }
        if (image.repeatX) {
            url.searchParams.append('repeatX', image.repeatX);
        }
        if (image.repeatY) {
            url.searchParams.append('repeatY', image.repeatY);
        }
        if (image.positionX) {
            url.searchParams.append('positionX', image.positionX);
        }
        if (image.positionY) {
            url.searchParams.append('positionY', image.positionY);
        }
        if (url.href === this.url_) {
            return;
        }
        if (this.loadTimeResolver_) {
            this.loadTimeResolver_.reject();
            this.loadTimeResolver_ = null;
        }
        // We use |contentWindow.location.replace| because reloading the iframe by
        // setting its |src| adds a history entry.
        this.backgroundImage_.contentWindow.location.replace(url.href);
        // We track the URL separately because |contentWindow.location.replace| does
        // not update the iframe's src attribute.
        this.url_ = url.href;
    }
    /**
     * Returns promise that resolves with the background image load time.
     *
     * The background image iframe proactively sends the load time as soon as it
     * has loaded. However, this could be before we have installed the message
     * listener in LoadTimeResolver. Therefore, we request the background image
     * iframe to resend the load time in case it has already loaded. With that
     * setup we ensure that the load time is (re)sent _after_ both the NTP top
     * frame and the background image iframe have installed the required message
     * listeners.
     */
    getBackgroundImageLoadTime() {
        if (!this.loadTimeResolver_) {
            this.loadTimeResolver_ = new LoadTimeResolver(this.backgroundImage_.src);
            WindowProxy.getInstance().postMessage(this.backgroundImage_, 'sendLoadTime', 'chrome-untrusted://new-tab-page');
        }
        return this.loadTimeResolver_.promise;
    }
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let instance = null;
/** Holds Mojo interfaces for communication with the browser process. */
class CustomizeButtonsProxy {
    static getInstance() {
        if (!instance) {
            const handler = new CustomizeButtonsHandlerRemote();
            const callbackRouter = new CustomizeButtonsDocumentCallbackRouter();
            CustomizeButtonsHandlerFactory.getRemote().createCustomizeButtonsHandler(callbackRouter.$.bindNewPipeAndPassRemote(), handler.$.bindNewPipeAndPassReceiver());
            instance = new CustomizeButtonsProxy(handler, callbackRouter);
        }
        return instance;
    }
    static setInstance(handler, callbackRouter) {
        instance = new CustomizeButtonsProxy(handler, callbackRouter);
    }
    handler;
    callbackRouter;
    constructor(handler, callbackRouter) {
        this.handler = handler;
        this.callbackRouter = callbackRouter;
    }
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var CustomizeDialogPage;
(function (CustomizeDialogPage) {
    CustomizeDialogPage["BACKGROUNDS"] = "backgrounds";
    CustomizeDialogPage["SHORTCUTS"] = "shortcuts";
    CustomizeDialogPage["MODULES"] = "modules";
    CustomizeDialogPage["THEMES"] = "themes";
    CustomizeDialogPage["WALLPAPER_SEARCH"] = "wallpaper_search";
})(CustomizeDialogPage || (CustomizeDialogPage = {}));

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var ModuleLoadStatus;
(function (ModuleLoadStatus) {
    ModuleLoadStatus[ModuleLoadStatus["MODULE_LOAD_IN_PROGRESS"] = 0] = "MODULE_LOAD_IN_PROGRESS";
    ModuleLoadStatus[ModuleLoadStatus["MODULE_LOAD_NOT_ATTEMPTED"] = 1] = "MODULE_LOAD_NOT_ATTEMPTED";
    ModuleLoadStatus[ModuleLoadStatus["MODULE_LOAD_COMPLETE"] = 2] = "MODULE_LOAD_COMPLETE";
})(ModuleLoadStatus || (ModuleLoadStatus = {}));
/**
 * Elements on the NTP. This enum must match the numbering for NTPElement in
 * enums.xml. These values are persisted to logs. Entries should not be
 * renumbered, removed or reused.
 */
var NtpElement;
(function (NtpElement) {
    NtpElement[NtpElement["OTHER"] = 0] = "OTHER";
    NtpElement[NtpElement["BACKGROUND"] = 1] = "BACKGROUND";
    NtpElement[NtpElement["ONE_GOOGLE_BAR"] = 2] = "ONE_GOOGLE_BAR";
    NtpElement[NtpElement["LOGO"] = 3] = "LOGO";
    NtpElement[NtpElement["REALBOX"] = 4] = "REALBOX";
    NtpElement[NtpElement["MOST_VISITED"] = 5] = "MOST_VISITED";
    NtpElement[NtpElement["MIDDLE_SLOT_PROMO"] = 6] = "MIDDLE_SLOT_PROMO";
    NtpElement[NtpElement["MODULE"] = 7] = "MODULE";
    NtpElement[NtpElement["CUSTOMIZE"] = 8] = "CUSTOMIZE";
    NtpElement[NtpElement["CUSTOMIZE_BUTTON"] = 9] = "CUSTOMIZE_BUTTON";
    NtpElement[NtpElement["CUSTOMIZE_DIALOG"] = 10] = "CUSTOMIZE_DIALOG";
    NtpElement[NtpElement["WALLPAPER_SEARCH_BUTTON"] = 11] = "WALLPAPER_SEARCH_BUTTON";
    NtpElement[NtpElement["ACTION_CHIPS"] = 12] = "ACTION_CHIPS";
    NtpElement[NtpElement["MAX_VALUE"] = 12] = "MAX_VALUE";
})(NtpElement || (NtpElement = {}));
/**
 * Customize Chrome entry points. This enum must match the numbering for
 * NtpCustomizeChromeEntryPoint in enums.xml. These values are persisted to
 * logs. Entries should not be renumbered, removed or reused.
 */
var NtpCustomizeChromeEntryPoint;
(function (NtpCustomizeChromeEntryPoint) {
    NtpCustomizeChromeEntryPoint[NtpCustomizeChromeEntryPoint["CUSTOMIZE_BUTTON"] = 0] = "CUSTOMIZE_BUTTON";
    NtpCustomizeChromeEntryPoint[NtpCustomizeChromeEntryPoint["MODULE"] = 1] = "MODULE";
    NtpCustomizeChromeEntryPoint[NtpCustomizeChromeEntryPoint["URL"] = 2] = "URL";
    NtpCustomizeChromeEntryPoint[NtpCustomizeChromeEntryPoint["WALLPAPER_SEARCH_BUTTON"] = 3] = "WALLPAPER_SEARCH_BUTTON";
    NtpCustomizeChromeEntryPoint[NtpCustomizeChromeEntryPoint["MAX_VALUE"] = 3] = "MAX_VALUE";
})(NtpCustomizeChromeEntryPoint || (NtpCustomizeChromeEntryPoint = {}));
/**
 * Defines the conditions that hide the wallpaper search button on the New Tab
 * Page.
 */
var NtpWallpaperSearchButtonHideCondition;
(function (NtpWallpaperSearchButtonHideCondition) {
    NtpWallpaperSearchButtonHideCondition[NtpWallpaperSearchButtonHideCondition["NONE"] = 0] = "NONE";
    NtpWallpaperSearchButtonHideCondition[NtpWallpaperSearchButtonHideCondition["BACKGROUND_IMAGE_SET"] = 1] = "BACKGROUND_IMAGE_SET";
    NtpWallpaperSearchButtonHideCondition[NtpWallpaperSearchButtonHideCondition["THEME_SET"] = 2] = "THEME_SET";
    NtpWallpaperSearchButtonHideCondition[NtpWallpaperSearchButtonHideCondition["MAX_VALUE"] = 2] = "MAX_VALUE";
})(NtpWallpaperSearchButtonHideCondition || (NtpWallpaperSearchButtonHideCondition = {}));
const CUSTOMIZE_URL_PARAM = 'customize';
const OGB_IFRAME_ORIGIN = 'chrome-untrusted://new-tab-page';
const MSAL_IFRAME_ORIGIN = 'chrome-untrusted://ntp-microsoft-auth';
const CUSTOMIZE_CHROME_BUTTON_ELEMENT_ID = 'CustomizeButtonsHandler::kCustomizeChromeButtonElementId';
// 900px ~= 561px (max value for --ntp-search-box-width) * 1.5 + some margin.
const realboxCanShowSecondarySideMediaQueryList = window.matchMedia('(min-width: 900px)');
function recordClick(element) {
    recordEnumeration('NewTabPage.Click', element, NtpElement.MAX_VALUE + 1);
}
function recordCustomizeChromeOpen(element) {
    recordEnumeration('NewTabPage.CustomizeChromeOpened', element, NtpCustomizeChromeEntryPoint.MAX_VALUE + 1);
}
// Adds a <script> tag that holds the lazy loaded code.
function ensureLazyLoaded() {
    const script = document.createElement('script');
    script.type = 'module';
    script.src = getTrustedScriptURL `./lazy_load.js`;
    document.body.appendChild(script);
}
function recordShowBrowserPromosResult(result) {
    recordEnumeration('UserEducation.NtpPromos.ShowResult', result, ShowNtpPromosResult.MAX_VALUE + 1);
}
const AppElementBase = HelpBubbleMixinLit(CrLitElement);
class AppElement extends AppElementBase {
    static get is() {
        return 'ntp-app';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            oneGoogleBarIframeOrigin_: { type: String },
            oneGoogleBarIframePath_: { type: String },
            oneGoogleBarLoaded_: { type: Boolean },
            theme_: { type: Object },
            showCustomize_: { type: Boolean },
            showCustomizeChromeText_: { type: Boolean },
            showWallpaperSearch_: { type: Boolean },
            isActionChipsVisible_: { type: Boolean },
            isFooterVisible_: { type: Boolean },
            selectedCustomizeDialogPage_: { type: String },
            showVoiceSearchOverlay_: { type: Boolean },
            showBackgroundImage_: {
                reflect: true,
                type: Boolean,
            },
            backgroundImageAttribution1_: { type: String },
            backgroundImageAttribution2_: { type: String },
            backgroundImageAttributionUrl_: { type: String },
            // Used in cr-searchbox component via host-context.
            colorSourceIsBaseline: { type: Boolean },
            logoColor_: { type: String },
            singleColoredLogo_: { type: Boolean },
            /**
             * Whether the secondary side can be shown based on the feature state and
             * the width available to the dropdown for the ntp searchbox.
             */
            realboxCanShowSecondarySide: {
                type: Boolean,
                reflect: true,
            },
            /**
             * Whether the searchbox secondary side was at any point available to
             * be shown.
             */
            realboxHadSecondarySide: {
                type: Boolean,
                reflect: true,
                notify: true,
            },
            composeboxCloseByClickOutside_: { type: Boolean },
            composeboxEnabled: { type: Boolean },
            composeButtonEnabled: { type: Boolean },
            browserPromoType_: { type: String },
            browserPromoLimit_: { type: Number },
            browserPromoCompletedLimit_: { type: Number },
            showBrowserPromo_: { type: Boolean },
            realboxShown_: { type: Boolean },
            logoEnabled_: { type: Boolean },
            oneGoogleBarEnabled_: { type: Boolean },
            shortcutsEnabled_: { type: Boolean },
            middleSlotPromoEnabled_: { type: Boolean },
            modulesEnabled_: { type: Boolean },
            middleSlotPromoLoaded_: { type: Boolean },
            modulesLoadedStatus_: {
                type: Number,
                reflect: true,
            },
            modulesShownToUser: {
                type: Boolean,
                reflect: true,
            },
            microsoftModuleEnabled_: { type: Boolean },
            microsoftAuthIframePath_: { type: String },
            multiLineEnabled_: { type: Boolean },
            ntpRealboxNextEnabled_: {
                type: Boolean,
                reflect: true,
            },
            /**
             * In order to avoid flicker, the promo and modules are hidden until both
             * are loaded. If modules are disabled, the promo is shown as soon as it
             * is loaded.
             */
            promoAndModulesLoaded_: { type: Boolean },
            realboxLayoutMode_: {
                type: String,
                reflect: true,
            },
            searchboxCyclingPlaceholders_: {
                type: Boolean,
            },
            showComposebox_: {
                type: Boolean,
                reflect: true,
            },
            showLensUploadDialog_: { type: Boolean },
            /**
             * If true, renders additional elements that were not deemed crucial to
             * to show up immediately on load.
             */
            lazyRender_: { type: Boolean },
            scrolledToTop_: { type: Boolean },
            wallpaperSearchButtonAnimationEnabled_: { type: Boolean },
            wallpaperSearchButtonEnabled_: { type: Boolean },
            showWallpaperSearchButton_: { type: Boolean },
            /**
             * Whether the composebox has been opened at least once.
             */
            wasComposeboxOpened_: { type: Boolean },
            ntpNextFeaturesEnabled_: { type: Boolean },
            maxTilesBeforeShowMore_: { type: Number },
            searchboxInputFocused_: { type: Boolean },
            composeboxInputFocused_: { type: Boolean },
            /**
             * Whether the scrim is shown in Realbox Next.
             */
            showScrim_: { type: Boolean, reflect: true },
            contextMenuGlifAnimationState_: { type: String },
            undoAutoRemovalCallback_: { type: Object },
            undoAutoRemovalMessage_: { type: Object },
        };
    }
    #oneGoogleBarIframeOrigin__accessor_storage = OGB_IFRAME_ORIGIN;
    get oneGoogleBarIframeOrigin_() { return this.#oneGoogleBarIframeOrigin__accessor_storage; }
    set oneGoogleBarIframeOrigin_(value) { this.#oneGoogleBarIframeOrigin__accessor_storage = value; }
    #oneGoogleBarIframePath__accessor_storage;
    get oneGoogleBarIframePath_() { return this.#oneGoogleBarIframePath__accessor_storage; }
    set oneGoogleBarIframePath_(value) { this.#oneGoogleBarIframePath__accessor_storage = value; }
    #oneGoogleBarLoaded__accessor_storage = false;
    get oneGoogleBarLoaded_() { return this.#oneGoogleBarLoaded__accessor_storage; }
    set oneGoogleBarLoaded_(value) { this.#oneGoogleBarLoaded__accessor_storage = value; }
    #theme__accessor_storage = null;
    get theme_() { return this.#theme__accessor_storage; }
    set theme_(value) { this.#theme__accessor_storage = value; }
    #showCustomize__accessor_storage = false;
    get showCustomize_() { return this.#showCustomize__accessor_storage; }
    set showCustomize_(value) { this.#showCustomize__accessor_storage = value; }
    #showCustomizeChromeText__accessor_storage = false;
    get showCustomizeChromeText_() { return this.#showCustomizeChromeText__accessor_storage; }
    set showCustomizeChromeText_(value) { this.#showCustomizeChromeText__accessor_storage = value; }
    #showWallpaperSearch__accessor_storage = false;
    get showWallpaperSearch_() { return this.#showWallpaperSearch__accessor_storage; }
    set showWallpaperSearch_(value) { this.#showWallpaperSearch__accessor_storage = value; }
    #selectedCustomizeDialogPage__accessor_storage = null;
    get selectedCustomizeDialogPage_() { return this.#selectedCustomizeDialogPage__accessor_storage; }
    set selectedCustomizeDialogPage_(value) { this.#selectedCustomizeDialogPage__accessor_storage = value; }
    #showVoiceSearchOverlay__accessor_storage = false;
    get showVoiceSearchOverlay_() { return this.#showVoiceSearchOverlay__accessor_storage; }
    set showVoiceSearchOverlay_(value) { this.#showVoiceSearchOverlay__accessor_storage = value; }
    #showBackgroundImage__accessor_storage = false;
    get showBackgroundImage_() { return this.#showBackgroundImage__accessor_storage; }
    set showBackgroundImage_(value) { this.#showBackgroundImage__accessor_storage = value; }
    #backgroundImageAttribution1__accessor_storage = '';
    get backgroundImageAttribution1_() { return this.#backgroundImageAttribution1__accessor_storage; }
    set backgroundImageAttribution1_(value) { this.#backgroundImageAttribution1__accessor_storage = value; }
    #backgroundImageAttribution2__accessor_storage = '';
    get backgroundImageAttribution2_() { return this.#backgroundImageAttribution2__accessor_storage; }
    set backgroundImageAttribution2_(value) { this.#backgroundImageAttribution2__accessor_storage = value; }
    #backgroundImageAttributionUrl__accessor_storage = '';
    get backgroundImageAttributionUrl_() { return this.#backgroundImageAttributionUrl__accessor_storage; }
    set backgroundImageAttributionUrl_(value) { this.#backgroundImageAttributionUrl__accessor_storage = value; }
    #colorSourceIsBaseline_accessor_storage = false;
    get colorSourceIsBaseline() { return this.#colorSourceIsBaseline_accessor_storage; }
    set colorSourceIsBaseline(value) { this.#colorSourceIsBaseline_accessor_storage = value; }
    #logoColor__accessor_storage = null;
    get logoColor_() { return this.#logoColor__accessor_storage; }
    set logoColor_(value) { this.#logoColor__accessor_storage = value; }
    #singleColoredLogo__accessor_storage = false;
    get singleColoredLogo_() { return this.#singleColoredLogo__accessor_storage; }
    set singleColoredLogo_(value) { this.#singleColoredLogo__accessor_storage = value; }
    #realboxCanShowSecondarySide_accessor_storage = false;
    get realboxCanShowSecondarySide() { return this.#realboxCanShowSecondarySide_accessor_storage; }
    set realboxCanShowSecondarySide(value) { this.#realboxCanShowSecondarySide_accessor_storage = value; }
    #realboxHadSecondarySide_accessor_storage = false;
    get realboxHadSecondarySide() { return this.#realboxHadSecondarySide_accessor_storage; }
    set realboxHadSecondarySide(value) { this.#realboxHadSecondarySide_accessor_storage = value; }
    #realboxShown__accessor_storage = false;
    get realboxShown_() { return this.#realboxShown__accessor_storage; }
    set realboxShown_(value) { this.#realboxShown__accessor_storage = value; }
    #wasComposeboxOpened__accessor_storage = false;
    get wasComposeboxOpened_() { return this.#wasComposeboxOpened__accessor_storage; }
    set wasComposeboxOpened_(value) { this.#wasComposeboxOpened__accessor_storage = value; }
    #showLensUploadDialog__accessor_storage = false;
    get showLensUploadDialog_() { return this.#showLensUploadDialog__accessor_storage; }
    set showLensUploadDialog_(value) { this.#showLensUploadDialog__accessor_storage = value; }
    #showComposebox__accessor_storage = false;
    get showComposebox_() { return this.#showComposebox__accessor_storage; }
    set showComposebox_(value) { this.#showComposebox__accessor_storage = value; }
    #logoEnabled__accessor_storage = loadTimeData.getBoolean('logoEnabled');
    get logoEnabled_() { return this.#logoEnabled__accessor_storage; }
    set logoEnabled_(value) { this.#logoEnabled__accessor_storage = value; }
    #oneGoogleBarEnabled__accessor_storage = loadTimeData.getBoolean('oneGoogleBarEnabled');
    get oneGoogleBarEnabled_() { return this.#oneGoogleBarEnabled__accessor_storage; }
    set oneGoogleBarEnabled_(value) { this.#oneGoogleBarEnabled__accessor_storage = value; }
    #shortcutsEnabled__accessor_storage = loadTimeData.getBoolean('shortcutsEnabled');
    get shortcutsEnabled_() { return this.#shortcutsEnabled__accessor_storage; }
    set shortcutsEnabled_(value) { this.#shortcutsEnabled__accessor_storage = value; }
    #middleSlotPromoEnabled__accessor_storage = loadTimeData.getBoolean('middleSlotPromoEnabled');
    get middleSlotPromoEnabled_() { return this.#middleSlotPromoEnabled__accessor_storage; }
    set middleSlotPromoEnabled_(value) { this.#middleSlotPromoEnabled__accessor_storage = value; }
    #modulesEnabled__accessor_storage = loadTimeData.getBoolean('modulesEnabled');
    get modulesEnabled_() { return this.#modulesEnabled__accessor_storage; }
    set modulesEnabled_(value) { this.#modulesEnabled__accessor_storage = value; }
    #browserPromoType__accessor_storage = loadTimeData.getString('browserPromoType');
    get browserPromoType_() { return this.#browserPromoType__accessor_storage; }
    set browserPromoType_(value) { this.#browserPromoType__accessor_storage = value; }
    #browserPromoLimit__accessor_storage = loadTimeData.getInteger('browserPromoLimit');
    get browserPromoLimit_() { return this.#browserPromoLimit__accessor_storage; }
    set browserPromoLimit_(value) { this.#browserPromoLimit__accessor_storage = value; }
    #browserPromoCompletedLimit__accessor_storage = loadTimeData.getInteger('browserPromoCompletedLimit');
    get browserPromoCompletedLimit_() { return this.#browserPromoCompletedLimit__accessor_storage; }
    set browserPromoCompletedLimit_(value) { this.#browserPromoCompletedLimit__accessor_storage = value; }
    #showBrowserPromo__accessor_storage = false;
    get showBrowserPromo_() { return this.#showBrowserPromo__accessor_storage; }
    set showBrowserPromo_(value) { this.#showBrowserPromo__accessor_storage = value; }
    #middleSlotPromoLoaded__accessor_storage = false;
    get middleSlotPromoLoaded_() { return this.#middleSlotPromoLoaded__accessor_storage; }
    set middleSlotPromoLoaded_(value) { this.#middleSlotPromoLoaded__accessor_storage = value; }
    #modulesLoadedStatus__accessor_storage = ModuleLoadStatus.MODULE_LOAD_IN_PROGRESS;
    get modulesLoadedStatus_() { return this.#modulesLoadedStatus__accessor_storage; }
    set modulesLoadedStatus_(value) { this.#modulesLoadedStatus__accessor_storage = value; }
    #modulesShownToUser_accessor_storage = false;
    get modulesShownToUser() { return this.#modulesShownToUser_accessor_storage; }
    set modulesShownToUser(value) { this.#modulesShownToUser_accessor_storage = value; }
    #microsoftModuleEnabled__accessor_storage = loadTimeData.getBoolean('microsoftModuleEnabled');
    get microsoftModuleEnabled_() { return this.#microsoftModuleEnabled__accessor_storage; }
    set microsoftModuleEnabled_(value) { this.#microsoftModuleEnabled__accessor_storage = value; }
    #microsoftAuthIframePath__accessor_storage = MSAL_IFRAME_ORIGIN;
    get microsoftAuthIframePath_() { return this.#microsoftAuthIframePath__accessor_storage; }
    set microsoftAuthIframePath_(value) { this.#microsoftAuthIframePath__accessor_storage = value; }
    #multiLineEnabled__accessor_storage = loadTimeData.getBoolean('multiLineEnabled');
    get multiLineEnabled_() { return this.#multiLineEnabled__accessor_storage; }
    set multiLineEnabled_(value) { this.#multiLineEnabled__accessor_storage = value; }
    #promoAndModulesLoaded__accessor_storage = false;
    get promoAndModulesLoaded_() { return this.#promoAndModulesLoaded__accessor_storage; }
    set promoAndModulesLoaded_(value) { this.#promoAndModulesLoaded__accessor_storage = value; }
    #lazyRender__accessor_storage = false;
    get lazyRender_() { return this.#lazyRender__accessor_storage; }
    set lazyRender_(value) { this.#lazyRender__accessor_storage = value; }
    #scrolledToTop__accessor_storage = document.documentElement.scrollTop <= 0;
    get scrolledToTop_() { return this.#scrolledToTop__accessor_storage; }
    set scrolledToTop_(value) { this.#scrolledToTop__accessor_storage = value; }
    #wallpaperSearchButtonAnimationEnabled__accessor_storage = loadTimeData.getBoolean('wallpaperSearchButtonAnimationEnabled');
    get wallpaperSearchButtonAnimationEnabled_() { return this.#wallpaperSearchButtonAnimationEnabled__accessor_storage; }
    set wallpaperSearchButtonAnimationEnabled_(value) { this.#wallpaperSearchButtonAnimationEnabled__accessor_storage = value; }
    #wallpaperSearchButtonEnabled__accessor_storage = loadTimeData.getBoolean('wallpaperSearchButtonEnabled');
    get wallpaperSearchButtonEnabled_() { return this.#wallpaperSearchButtonEnabled__accessor_storage; }
    set wallpaperSearchButtonEnabled_(value) { this.#wallpaperSearchButtonEnabled__accessor_storage = value; }
    #showWallpaperSearchButton__accessor_storage = false;
    get showWallpaperSearchButton_() { return this.#showWallpaperSearchButton__accessor_storage; }
    set showWallpaperSearchButton_(value) { this.#showWallpaperSearchButton__accessor_storage = value; }
    #composeButtonEnabled_accessor_storage = loadTimeData.getBoolean('searchboxShowComposeEntrypoint');
    get composeButtonEnabled() { return this.#composeButtonEnabled_accessor_storage; }
    set composeButtonEnabled(value) { this.#composeButtonEnabled_accessor_storage = value; }
    #composeboxCloseByClickOutside__accessor_storage = loadTimeData.getBoolean('composeboxCloseByClickOutside');
    get composeboxCloseByClickOutside_() { return this.#composeboxCloseByClickOutside__accessor_storage; }
    set composeboxCloseByClickOutside_(value) { this.#composeboxCloseByClickOutside__accessor_storage = value; }
    #composeboxEnabled_accessor_storage = loadTimeData.getBoolean('searchboxShowComposebox');
    get composeboxEnabled() { return this.#composeboxEnabled_accessor_storage; }
    set composeboxEnabled(value) { this.#composeboxEnabled_accessor_storage = value; }
    #isActionChipsVisible__accessor_storage = loadTimeData.getBoolean('actionChipsEnabled');
    get isActionChipsVisible_() { return this.#isActionChipsVisible__accessor_storage; }
    set isActionChipsVisible_(value) { this.#isActionChipsVisible__accessor_storage = value; }
    #isFooterVisible__accessor_storage = false;
    get isFooterVisible_() { return this.#isFooterVisible__accessor_storage; }
    set isFooterVisible_(value) { this.#isFooterVisible__accessor_storage = value; }
    #ntpRealboxNextEnabled__accessor_storage = loadTimeData.getBoolean('ntpRealboxNextEnabled');
    get ntpRealboxNextEnabled_() { return this.#ntpRealboxNextEnabled__accessor_storage; }
    set ntpRealboxNextEnabled_(value) { this.#ntpRealboxNextEnabled__accessor_storage = value; }
    #realboxLayoutMode__accessor_storage = loadTimeData.getString('realboxLayoutMode');
    get realboxLayoutMode_() { return this.#realboxLayoutMode__accessor_storage; }
    set realboxLayoutMode_(value) { this.#realboxLayoutMode__accessor_storage = value; }
    #searchboxCyclingPlaceholders__accessor_storage = loadTimeData.getBoolean('searchboxCyclingPlaceholders');
    get searchboxCyclingPlaceholders_() { return this.#searchboxCyclingPlaceholders__accessor_storage; }
    set searchboxCyclingPlaceholders_(value) { this.#searchboxCyclingPlaceholders__accessor_storage = value; }
    #ntpNextFeaturesEnabled__accessor_storage = loadTimeData.getBoolean('ntpNextFeaturesEnabled');
    get ntpNextFeaturesEnabled_() { return this.#ntpNextFeaturesEnabled__accessor_storage; }
    set ntpNextFeaturesEnabled_(value) { this.#ntpNextFeaturesEnabled__accessor_storage = value; }
    #maxTilesBeforeShowMore__accessor_storage = loadTimeData.getInteger('maxTilesBeforeShowMore');
    get maxTilesBeforeShowMore_() { return this.#maxTilesBeforeShowMore__accessor_storage; }
    set maxTilesBeforeShowMore_(value) { this.#maxTilesBeforeShowMore__accessor_storage = value; }
    #searchboxInputFocused__accessor_storage = false;
    get searchboxInputFocused_() { return this.#searchboxInputFocused__accessor_storage; }
    set searchboxInputFocused_(value) { this.#searchboxInputFocused__accessor_storage = value; }
    #composeboxInputFocused__accessor_storage = false;
    get composeboxInputFocused_() { return this.#composeboxInputFocused__accessor_storage; }
    set composeboxInputFocused_(value) { this.#composeboxInputFocused__accessor_storage = value; }
    #showScrim__accessor_storage = false;
    get showScrim_() { return this.#showScrim__accessor_storage; }
    set showScrim_(value) { this.#showScrim__accessor_storage = value; }
    #contextMenuGlifAnimationState__accessor_storage = this.ntpNextFeaturesEnabled_ && this.isActionChipsVisible_ ?
        GlifAnimationState.SPINNER_ONLY :
        GlifAnimationState.INELIGIBLE;
    get contextMenuGlifAnimationState_() { return this.#contextMenuGlifAnimationState__accessor_storage; }
    set contextMenuGlifAnimationState_(value) { this.#contextMenuGlifAnimationState__accessor_storage = value; }
    #undoAutoRemovalCallback__accessor_storage = null;
    get undoAutoRemovalCallback_() { return this.#undoAutoRemovalCallback__accessor_storage; }
    set undoAutoRemovalCallback_(value) { this.#undoAutoRemovalCallback__accessor_storage = value; }
    #undoAutoRemovalMessage__accessor_storage = null;
    get undoAutoRemovalMessage_() { return this.#undoAutoRemovalMessage__accessor_storage; }
    set undoAutoRemovalMessage_(value) { this.#undoAutoRemovalMessage__accessor_storage = value; }
    enableModalComposebox_ = loadTimeData.getBoolean('enableModalComposebox');
    ephemeralContextMenuDescriptionEnabled_ = loadTimeData.getBoolean('enableEphemeralContextMenuDescription') ?? false;
    showContextMenuDescription_ = loadTimeData.getBoolean('composeboxShowContextMenuDescription');
    callbackRouter_;
    pageHandler_;
    customizeButtonsCallbackRouter_;
    customizeButtonsHandler_;
    backgroundManager_;
    connectMicrosoftAuthToParentDocumentListenerId_ = null;
    setThemeListenerId_ = null;
    setCustomizeChromeSidePanelVisibilityListener_ = null;
    setWallpaperSearchButtonVisibilityListener_ = null;
    setActionChipsVisibilityListenerId_ = null;
    footerVisibilityUpdatedListener_ = null;
    eventTracker_ = new EventTracker();
    shouldPrintPerformance_ = false;
    backgroundImageLoadStartEpoch_ = 0;
    backgroundImageLoadStart_ = 0;
    showWebstoreToastListenerId_ = null;
    pendingComposeboxContextFiles_ = [];
    pendingComposeboxText_ = '';
    pendingComposeboxMode_ = ComposeboxMode.DEFAULT;
    pendingAutoRemovalToasts_ = [];
    constructor() {
        performance.mark('app-creation-start');
        super();
        this.callbackRouter_ = NewTabPageProxy.getInstance().callbackRouter;
        this.pageHandler_ = NewTabPageProxy.getInstance().handler;
        this.customizeButtonsCallbackRouter_ =
            CustomizeButtonsProxy.getInstance().callbackRouter;
        this.customizeButtonsHandler_ = CustomizeButtonsProxy.getInstance().handler;
        this.backgroundManager_ = BackgroundManager.getInstance();
        this.shouldPrintPerformance_ =
            new URLSearchParams(location.search).has('print_perf');
        this.oneGoogleBarIframePath_ = (() => {
            const params = new URLSearchParams();
            params.set('paramsencoded', btoa(window.location.search.replace(/^[?]/, '&')));
            return `${OGB_IFRAME_ORIGIN}/one-google-bar?${params}`;
        })();
        this.showCustomize_ =
            WindowProxy.getInstance().url.searchParams.has(CUSTOMIZE_URL_PARAM);
        this.selectedCustomizeDialogPage_ =
            WindowProxy.getInstance().url.searchParams.get(CUSTOMIZE_URL_PARAM);
        this.realboxCanShowSecondarySide =
            realboxCanShowSecondarySideMediaQueryList.matches;
        /**
         * Initialized with the start of the performance timeline in case the
         * background image load is not triggered by JS.
         */
        this.backgroundImageLoadStartEpoch_ = performance.timeOrigin;
        recordLinearValue('NewTabPage.Height', 
        /*min=*/ 1, 
        /*max=*/ 1000, 
        /*buckets=*/ 200, 
        /*value=*/ Math.floor(window.innerHeight));
        recordLinearValue('NewTabPage.Width', 
        /*min=*/ 1, 
        /*max=*/ 1920, 
        /*buckets=*/ 384, 
        /*value=*/ Math.floor(window.innerWidth));
        ColorChangeUpdater.forDocument().start();
    }
    connectedCallback() {
        super.connectedCallback();
        realboxCanShowSecondarySideMediaQueryList.addEventListener('change', this.onRealboxCanShowSecondarySideChanged_.bind(this));
        // Listen for chrome-untrusted://ntp-microsoft-auth iframe trying to
        // connect to the NTP.
        this.connectMicrosoftAuthToParentDocumentListenerId_ =
            this.callbackRouter_.connectToParentDocument.addListener((childDocumentRemote) => {
                ParentTrustedDocumentProxy.setInstance(childDocumentRemote);
            });
        this.setThemeListenerId_ =
            this.callbackRouter_.setTheme.addListener((theme) => {
                if (!this.theme_) {
                    this.onThemeLoaded_(theme);
                }
                performance.measure('theme-set');
                this.theme_ = theme;
            });
        this.setCustomizeChromeSidePanelVisibilityListener_ =
            this.customizeButtonsCallbackRouter_
                .setCustomizeChromeSidePanelVisibility.addListener((visible) => {
                this.showCustomize_ = visible;
                if (!visible) {
                    this.showWallpaperSearch_ = false;
                }
            });
        this.showWebstoreToastListenerId_ =
            this.callbackRouter_.showWebstoreToast.addListener(() => {
                if (this.showCustomize_) {
                    const toast = $$(this, '#webstoreToast');
                    if (toast) {
                        toast.hidden = false;
                        toast.show();
                    }
                }
            });
        this.setWallpaperSearchButtonVisibilityListener_ =
            this.callbackRouter_.setWallpaperSearchButtonVisibility.addListener((visible) => {
                // Hides the wallpaper search button if the browser indicates that
                // it should be hidden.
                // Note: We don't resurface the button later even if the browser
                // says we should, to avoid issues if Customize Chrome doesn't
                // have the wallpaper search element yet.
                if (!visible) {
                    this.wallpaperSearchButtonEnabled_ = visible;
                }
            });
        this.setActionChipsVisibilityListenerId_ =
            this.callbackRouter_.setActionChipsVisibility.addListener((isVisible) => this.isActionChipsVisible_ = isVisible);
        this.footerVisibilityUpdatedListener_ =
            this.callbackRouter_.footerVisibilityUpdated.addListener((visible) => {
                this.isFooterVisible_ = visible;
            });
        this.pageHandler_.updateFooterVisibility();
        // Open Customize Chrome if there are Customize Chrome URL params.
        if (this.showCustomize_) {
            this.setCustomizeChromeSidePanelVisible_(this.showCustomize_);
            recordCustomizeChromeOpen(NtpCustomizeChromeEntryPoint.URL);
        }
        this.eventTracker_.add(window, 'message', (event) => {
            const data = event.data;
            // Something in OneGoogleBar is sending a message that is received here.
            // Need to ignore it.
            if (typeof data !== 'object') {
                return;
            }
            if ('frameType' in data && data.frameType === 'one-google-bar') {
                this.handleOneGoogleBarMessage_(event);
            }
        });
        this.eventTracker_.add(window, 'keydown', this.onWindowKeydown_.bind(this));
        this.eventTracker_.add(window, 'click', this.onWindowClick_.bind(this), /*capture=*/ true);
        this.eventTracker_.add(document, 'scroll', () => {
            this.scrolledToTop_ = document.documentElement.scrollTop <= 0;
        });
        if (loadTimeData.getString('backgroundImageUrl')) {
            this.backgroundManager_.getBackgroundImageLoadTime().then(time => {
                const duration = time - this.backgroundImageLoadStartEpoch_;
                recordDuration('NewTabPage.Images.ShownTime.BackgroundImage', duration);
                if (this.shouldPrintPerformance_) {
                    this.printPerformanceDatum_('background-image-load', this.backgroundImageLoadStart_, duration);
                    this.printPerformanceDatum_('background-image-loaded', this.backgroundImageLoadStart_ + duration);
                }
            }, () => {
                // Ignore. Failed to capture background image load time.
            });
        }
        FocusOutlineManager.forDocument(document);
        if (this.composeButtonEnabled) {
            recordBoolean('NewTabPage.ComposeEntrypoint.Shown', true);
            this.pageHandler_.incrementComposeButtonShownCount();
        }
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        realboxCanShowSecondarySideMediaQueryList.removeEventListener('change', this.onRealboxCanShowSecondarySideChanged_.bind(this));
        this.callbackRouter_.removeListener(this.connectMicrosoftAuthToParentDocumentListenerId_);
        this.callbackRouter_.removeListener(this.setThemeListenerId_);
        this.callbackRouter_.removeListener(this.showWebstoreToastListenerId_);
        this.callbackRouter_.removeListener(this.setWallpaperSearchButtonVisibilityListener_);
        this.customizeButtonsCallbackRouter_.removeListener(this.setCustomizeChromeSidePanelVisibilityListener_);
        this.callbackRouter_.removeListener(this.setActionChipsVisibilityListenerId_);
        this.callbackRouter_.removeListener(this.footerVisibilityUpdatedListener_);
        this.eventTracker_.removeAll();
    }
    firstUpdated() {
        this.pageHandler_.onAppRendered(WindowProxy.getInstance().now());
        // Let the browser breathe and then render remaining elements.
        WindowProxy.getInstance().waitForLazyRender().then(() => {
            ensureLazyLoaded();
            this.lazyRender_ = true;
        });
        this.printPerformance_();
        performance.measure('app-creation', 'app-creation-start');
        if (!this.modulesEnabled_) {
            this.recordBrowserPromoMetrics_();
        }
    }
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        const changedPrivateProperties = changedProperties;
        if (changedPrivateProperties.has('theme_')) {
            this.showBackgroundImage_ = this.computeShowBackgroundImage_();
            this.backgroundImageAttribution1_ =
                this.computeBackgroundImageAttribution1_();
            this.backgroundImageAttribution2_ =
                this.computeBackgroundImageAttribution2_();
            this.backgroundImageAttributionUrl_ =
                this.computeBackgroundImageAttributionUrl_();
            this.colorSourceIsBaseline = this.computeColorSourceIsBaseline();
            this.logoColor_ = this.computeLogoColor_();
            this.singleColoredLogo_ = this.computeSingleColoredLogo_();
        }
        // theme_, showLensUploadDialog_
        this.realboxShown_ = this.computeRealboxShown_();
        // middleSlotPromoLoaded_, modulesLoadedStatus_
        this.promoAndModulesLoaded_ = this.computePromoAndModulesLoaded_();
        // wallpaperSearchButtonEnabled_, showBackgroundImage_, backgroundColor_
        this.showWallpaperSearchButton_ = this.computeShowWallpaperSearchButton_();
        // showWallpaperSearchButton_, showBackgroundImage_
        this.showCustomizeChromeText_ = this.computeShowCustomizeChromeText_();
        // modulesEnabled_, modulesShownToUser, modulesLoadedStatus_
        this.showBrowserPromo_ = this.computeShowBrowserPromo_();
        if ((changedPrivateProperties.has('modulesLoadedStatus_') &&
            this.modulesLoadedStatus_ !==
                ModuleLoadStatus.MODULE_LOAD_IN_PROGRESS)) {
            this.recordBrowserPromoMetrics_();
        }
        if (this.ntpRealboxNextEnabled_ && [
            'showComposebox_',
            'searchboxInputFocused_',
            'composeboxInputFocused_',
        ].some((prop) => changedPrivateProperties.has(prop))) {
            /**
             * The current requirement is that the scrim should be shown when the
             * focus is placed on one of the input boxes and should be removed when
             * the focus moves outside.
             *
             * The additional OR operation with showComposebox_ is because the logic
             * does not close Composebox when a click outside is made while Composebox
             * is opened. What seems to be happening when showComposebox_ is used/not
             * used are as follows:
             * - Without it:
             *   1. A click outside is made.
             *   2. The focusout event first occurs.
             *   3. composeboxInputFocused_ is set to false.
             *   4. The scrim is removed.
             *   5. The click event fires.
             *   6. Since there is no scrim, the onclick handle of the scrim is not
             *      called.
             * - With it:
             *   1-3. same as above
             *   4. The scrim is kept since showComposebox_ is still true.
             *   5. The onclick handler of the scrim runs and sets showComposebox_ to
             *      false, and everything works as desired.
             */
            this.showScrim_ = this.showComposebox_ || this.searchboxInputFocused_ ||
                this.composeboxInputFocused_;
        }
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        const changedPrivateProperties = changedProperties;
        if (changedPrivateProperties.has('lazyRender_') && this.lazyRender_) {
            this.onLazyRendered_();
        }
        if (changedPrivateProperties.has('theme_')) {
            this.onThemeChange_();
        }
        if (changedPrivateProperties.has('isFooterVisible_') && this.lazyRender_) {
            this.maybeRegisterCustomizeButtonHelpBubble_();
        }
        if (changedPrivateProperties.has('logoColor_')) {
            this.style.setProperty('--ntp-logo-color', this.rgbaOrInherit_(this.logoColor_));
        }
        if (changedPrivateProperties.has('showBackgroundImage_')) {
            this.onShowBackgroundImageChange_();
        }
        if (changedPrivateProperties.has('promoAndModulesLoaded_')) {
            this.onPromoAndModulesLoadedChange_();
        }
        if (changedPrivateProperties.has('showComposebox_') &&
            this.showComposebox_ && this.enableModalComposebox_) {
            const composeboxDialog = this.shadowRoot.querySelector('#composeboxDialog');
            assert(composeboxDialog);
            composeboxDialog.showModal();
        }
        if (changedPrivateProperties.has('oneGoogleBarLoaded_') ||
            changedPrivateProperties.has('theme_') ||
            changedPrivateProperties.has('showComposebox_')) {
            this.updateOneGoogleBarAppearance_();
        }
    }
    // Called to update the OGB of relevant NTP state changes.
    updateOneGoogleBarAppearance_() {
        if (this.oneGoogleBarLoaded_) {
            let isNtpDarkTheme;
            if (this.showComposebox_) {
                isNtpDarkTheme = this.theme_ && this.theme_.isDark;
            }
            else {
                isNtpDarkTheme = this.theme_ &&
                    (!!this.theme_.backgroundImage || this.theme_.isDark);
            }
            $$(this, '#oneGoogleBar').postMessage({
                type: 'updateAppearance',
                // We should be using a light OGB for dark themes and vice versa.
                applyLightTheme: isNtpDarkTheme,
            });
        }
    }
    computeShowCustomizeChromeText_() {
        if (this.showWallpaperSearchButton_) {
            return false;
        }
        return !this.showBackgroundImage_;
    }
    computeBackgroundImageAttribution1_() {
        return this.theme_ && this.theme_.backgroundImageAttribution1 || '';
    }
    computeBackgroundImageAttribution2_() {
        return this.theme_ && this.theme_.backgroundImageAttribution2 || '';
    }
    computeBackgroundImageAttributionUrl_() {
        return this.theme_ && this.theme_.backgroundImageAttributionUrl ?
            this.theme_.backgroundImageAttributionUrl.url :
            '';
    }
    computeRealboxShown_() {
        // Do not show the realbox if the upload dialog is showing.
        return !!this.theme_ && !this.showLensUploadDialog_ &&
            !this.showComposebox_;
    }
    computePromoAndModulesLoaded_() {
        return (!loadTimeData.getBoolean('middleSlotPromoEnabled') ||
            this.middleSlotPromoLoaded_) &&
            (!loadTimeData.getBoolean('modulesEnabled') ||
                this.modulesLoadedStatus_ === ModuleLoadStatus.MODULE_LOAD_COMPLETE);
    }
    onRealboxCanShowSecondarySideChanged_(e) {
        this.realboxCanShowSecondarySide = e.matches;
    }
    onLazyRendered_() {
        // Integration tests use this attribute to determine when lazy load has
        // completed.
        document.documentElement.setAttribute('lazy-loaded', String(true));
        if (this.maybeRegisterCustomizeButtonHelpBubble_()) {
            this.pageHandler_.maybeTriggerAutomaticCustomizeChromePromo();
        }
        if (this.showWallpaperSearchButton_) {
            this.customizeButtonsHandler_.incrementWallpaperSearchButtonShownCount();
        }
    }
    maybeRegisterCustomizeButtonHelpBubble_() {
        if (!this.isFooterVisible_) {
            this.registerHelpBubble(CUSTOMIZE_CHROME_BUTTON_ELEMENT_ID, ['ntp-customize-buttons', '#customizeButton'], { fixed: true });
            return true;
        }
        return false;
    }
    onComposeboxInitialized_(e) {
        e.detail.initializeComposeboxState(this.pendingComposeboxText_, this.pendingComposeboxContextFiles_, this.pendingComposeboxMode_);
        this.pendingComposeboxContextFiles_ = [];
        this.pendingComposeboxText_ = '';
        this.pendingComposeboxMode_ = ComposeboxMode.DEFAULT;
    }
    openComposebox_(e) {
        if (e.detail.searchboxText) {
            this.pendingComposeboxText_ = e.detail.searchboxText;
        }
        if (e.detail.contextFiles && e.detail.contextFiles.length > 0) {
            this.pendingComposeboxContextFiles_ = e.detail.contextFiles;
        }
        this.pendingComposeboxMode_ = e.detail.mode;
        this.toggleComposebox_();
    }
    toggleComposebox_() {
        this.showComposebox_ = !this.showComposebox_;
        if (!this.wasComposeboxOpened_) {
            recordLoadDuration('NewTabPage.Composebox.FromNTPLoadToSessionStart', WindowProxy.getInstance().now());
            this.wasComposeboxOpened_ = true;
        }
    }
    onComposeboxClickOutside_() {
        const composebox = this.shadowRoot.querySelector('#composebox');
        assert(composebox);
        const closeComposebox = new CustomEvent('closeComposebox', {
            detail: { composeboxText: composebox.getText() },
            bubbles: true,
            cancelable: true,
        });
        this.closeComposebox_(closeComposebox);
    }
    closeComposebox_(e) {
        if (this.enableModalComposebox_) {
            const composeboxDialog = this.shadowRoot.querySelector('#composeboxDialog');
            assert(composeboxDialog);
            composeboxDialog.close();
        }
        const composeboxText = e.detail.composeboxText;
        if (composeboxText && composeboxText.trim()) {
            this.$.searchbox.setInputText(composeboxText);
        }
        const composebox = this.shadowRoot.querySelector('#composebox');
        assert(composebox);
        composebox.setText('');
        composebox.resetModes();
        if (this.ntpRealboxNextEnabled_) {
            composebox.closeDropdown();
        }
        this.toggleComposebox_();
        this.logoColor_ = this.computeLogoColor_();
        this.singleColoredLogo_ = this.computeSingleColoredLogo_();
        this.updateOneGoogleBarAppearance_();
    }
    onOpenVoiceSearch_() {
        this.showVoiceSearchOverlay_ = true;
        recordVoiceAction(Action.ACTIVATE);
    }
    onComposeVoiceSearchAction_(e) {
        switch (e.detail.value) {
            case VoiceSearchAction.ACTIVATE:
                recordVoiceAction(Action.ACTIVATE);
                break;
            case VoiceSearchAction.QUERY_SUBMITTED:
                recordVoiceAction(Action.QUERY_SUBMITTED);
                break;
            default:
                assertNotReached();
        }
    }
    onOpenLensSearch_() {
        this.showLensUploadDialog_ = true;
    }
    onCloseLensSearch_() {
        this.showLensUploadDialog_ = false;
    }
    onContextMenuEntrypointClick_() {
        if (this.ephemeralContextMenuDescriptionEnabled_ &&
            this.showContextMenuDescription_) {
            this.pageHandler_.recordContextMenuClick();
        }
    }
    onCustomizeClick_() {
        // Let side panel decide what page or section to show.
        this.selectedCustomizeDialogPage_ = null;
        this.setCustomizeChromeSidePanelVisible_(!this.showCustomize_);
        if (!this.showCustomize_) {
            this.customizeButtonsHandler_.incrementCustomizeChromeButtonOpenCount();
            recordCustomizeChromeOpen(NtpCustomizeChromeEntryPoint.CUSTOMIZE_BUTTON);
        }
    }
    computeShowWallpaperSearchButton_() {
        if (!this.wallpaperSearchButtonEnabled_) {
            return false;
        }
        switch (loadTimeData.getInteger('wallpaperSearchButtonHideCondition')) {
            case NtpWallpaperSearchButtonHideCondition.NONE:
                return true;
            case NtpWallpaperSearchButtonHideCondition.BACKGROUND_IMAGE_SET:
                return !this.showBackgroundImage_;
            case NtpWallpaperSearchButtonHideCondition.THEME_SET:
                return this.colorSourceIsBaseline && !this.showBackgroundImage_;
        }
        return false;
    }
    onWallpaperSearchClick_() {
        // Close the side panel if Wallpaper Search is open.
        if (this.showCustomize_ && this.showWallpaperSearch_) {
            this.selectedCustomizeDialogPage_ = null;
            this.setCustomizeChromeSidePanelVisible_(!this.showCustomize_);
            return;
        }
        // Open Wallpaper Search if the side panel is closed. Otherwise, navigate
        // the side panel to Wallpaper Search.
        this.selectedCustomizeDialogPage_ = CustomizeDialogPage.WALLPAPER_SEARCH;
        this.showWallpaperSearch_ = true;
        this.setCustomizeChromeSidePanelVisible_(this.showWallpaperSearch_);
        if (!this.showCustomize_) {
            this.customizeButtonsHandler_.incrementCustomizeChromeButtonOpenCount();
            recordCustomizeChromeOpen(NtpCustomizeChromeEntryPoint.WALLPAPER_SEARCH_BUTTON);
        }
    }
    onVoiceSearchOverlayClose_() {
        this.showVoiceSearchOverlay_ = false;
    }
    /**
     * Handles <CTRL> + <SHIFT> + <.> (also <CMD> + <SHIFT> + <.> on mac) to open
     * voice search.
     */
    onWindowKeydown_(e) {
        let ctrlKeyPressed = e.ctrlKey;
        // 
        ctrlKeyPressed = ctrlKeyPressed || e.metaKey;
        // 
        if (e.key === 'Escape' && this.showComposebox_) {
            const composebox = this.shadowRoot.querySelector('#composebox');
            if (composebox) {
                composebox.handleEscapeKeyLogic();
                e.preventDefault();
                return;
            }
        }
        if (ctrlKeyPressed && e.code === 'Period' && e.shiftKey) {
            this.showVoiceSearchOverlay_ = true;
            recordVoiceAction(Action.ACTIVATE_KEYBOARD);
        }
    }
    rgbaOrInherit_(skColor) {
        return skColor ? skColorToRgba(skColor) : 'inherit';
    }
    computeShowBackgroundImage_() {
        return !!this.theme_ && !!this.theme_.backgroundImage;
    }
    onShowBackgroundImageChange_() {
        this.backgroundManager_.setShowBackgroundImage(this.showBackgroundImage_);
    }
    onThemeChange_() {
        if (this.theme_) {
            this.backgroundManager_.setBackgroundColor(this.theme_.backgroundColor);
            this.style.setProperty('--color-new-tab-page-attribution-foreground', this.rgbaOrInherit_(this.theme_.textColor));
            this.style.setProperty('--color-new-tab-page-most-visited-foreground', this.rgbaOrInherit_(this.theme_.textColor));
        }
        this.updateBackgroundImagePath_();
    }
    onThemeLoaded_(theme) {
        recordSparseValueWithPersistentHash('NewTabPage.Collections.IdOnLoad', theme.backgroundImageCollectionId ?? '');
        if (!theme.backgroundImage) {
            recordEnumeration('NewTabPage.BackgroundImageSource', NtpBackgroundImageSource.kNoImage, NtpBackgroundImageSource.MAX_VALUE + 1);
        }
        else {
            recordEnumeration('NewTabPage.BackgroundImageSource', theme.backgroundImage.imageSource, NtpBackgroundImageSource.MAX_VALUE + 1);
        }
    }
    onPromoAndModulesLoadedChange_() {
        if (this.promoAndModulesLoaded_ &&
            loadTimeData.getBoolean('modulesEnabled')) {
            recordLoadDuration('NewTabPage.Modules.ShownTime', WindowProxy.getInstance().now());
        }
    }
    /**
     * Set the #backgroundImage |path| only when different and non-empty. Reset
     * the customize dialog background selection if the dialog is closed.
     *
     * The ntp-untrusted-iframe |path| is set directly. When using a data binding
     * instead, the quick updates to the |path| result in iframe loading an error
     * page.
     */
    updateBackgroundImagePath_() {
        const backgroundImage = this.theme_ && this.theme_.backgroundImage;
        if (!backgroundImage) {
            return;
        }
        this.backgroundManager_.setBackgroundImage(backgroundImage);
        if (this.wallpaperSearchButtonAnimationEnabled_ &&
            backgroundImage.imageSource ===
                NtpBackgroundImageSource.kWallpaperSearch ||
            backgroundImage.imageSource ===
                NtpBackgroundImageSource.kWallpaperSearchInspiration) {
            this.wallpaperSearchButtonAnimationEnabled_ = false;
        }
    }
    computeColorSourceIsBaseline() {
        return !!this.theme_ && this.theme_.isBaseline;
    }
    computeLogoColor_() {
        if (!this.theme_) {
            return null;
        }
        return this.theme_.logoColor ||
            (this.theme_.isDark ? hexColorToSkColor('#ffffff') : null);
    }
    computeSingleColoredLogo_() {
        return !!this.theme_ && (!!this.theme_.logoColor || this.theme_.isDark);
    }
    /**
     * Sends the command received from the given source and origin to the browser.
     * Relays the browser response to whether or not a promo containing the given
     * command can be shown back to the source promo frame. |commandSource| and
     * |commandOrigin| are used only to send the response back to the source promo
     * frame and should not be used for anything else.
     * @param  messageData Data received from the source promo frame.
     * @param commandSource Source promo frame.
     * @param commandOrigin Origin of the source promo frame.
     */
    canShowPromoWithBrowserCommand_(messageData, commandSource, commandOrigin) {
        // Make sure we don't send unsupported commands to the browser.
        /** @type {!Command} */
        const commandId = Object.values(Command).includes(messageData.commandId) ?
            messageData.commandId :
            Command.kUnknownCommand;
        BrowserCommandProxy.getInstance().handler.canExecuteCommand(commandId).then(({ canExecute }) => {
            const response = {
                messageType: messageData.messageType,
                [messageData.commandId]: canExecute,
            };
            commandSource.postMessage(response, commandOrigin);
        });
    }
    /**
     * Sends the command and the accompanying mouse click info received from the
     * promo of the given source and origin to the browser. Relays the execution
     * status response back to the source promo frame. |commandSource| and
     * |commandOrigin| are used only to send the execution status response back to
     * the source promo frame and should not be used for anything else.
     * @param commandData Command and mouse click info.
     * @param commandSource Source promo frame.
     * @param commandOrigin Origin of the source promo frame.
     */
    executePromoBrowserCommand_(commandData, commandSource, commandOrigin) {
        // Make sure we don't send unsupported commands to the browser.
        const commandId = Object.values(Command).includes(commandData.commandId) ?
            commandData.commandId :
            Command.kUnknownCommand;
        BrowserCommandProxy.getInstance()
            .handler.executeCommand(commandId, commandData.clickInfo)
            .then(({ commandExecuted }) => {
            commandSource.postMessage(commandExecuted, commandOrigin);
        });
    }
    /**
     * Handles messages from the OneGoogleBar iframe. The messages that are
     * handled include show bar on load and overlay updates.
     *
     * 'overlaysUpdated' message includes the updated array of overlay rects that
     * are shown.
     */
    handleOneGoogleBarMessage_(event) {
        const data = event.data;
        if (data.messageType === 'loaded') {
            const oneGoogleBar = $$(this, '#oneGoogleBar');
            oneGoogleBar.style.clipPath = 'url(#oneGoogleBarClipPath)';
            oneGoogleBar.style.zIndex = '1000';
            this.oneGoogleBarLoaded_ = true;
            this.pageHandler_.onOneGoogleBarRendered(WindowProxy.getInstance().now());
        }
        else if (data.messageType === 'overlaysUpdated') {
            this.$.oneGoogleBarClipPath.querySelectorAll('rect').forEach(el => {
                el.remove();
            });
            const overlayRects = data.data;
            overlayRects.forEach(({ x, y, width, height }) => {
                const rectElement = document.createElementNS('http://www.w3.org/2000/svg', 'rect');
                // Add 8px around every rect to ensure shadows are not cutoff.
                rectElement.setAttribute('x', `${x - 8}`);
                rectElement.setAttribute('y', `${y - 8}`);
                rectElement.setAttribute('width', `${width + 16}`);
                rectElement.setAttribute('height', `${height + 16}`);
                this.$.oneGoogleBarClipPath.appendChild(rectElement);
            });
        }
        else if (data.messageType === 'can-show-promo-with-browser-command') {
            this.canShowPromoWithBrowserCommand_(data, event.source, event.origin);
        }
        else if (data.messageType === 'execute-browser-command') {
            this.executePromoBrowserCommand_(data.data, event.source, event.origin);
        }
        else if (data.messageType === 'click') {
            recordClick(NtpElement.ONE_GOOGLE_BAR);
        }
    }
    onMiddleSlotPromoLoaded_() {
        this.middleSlotPromoLoaded_ = true;
    }
    onModulesLoaded_(e) {
        this.modulesLoadedStatus_ = e.detail ?
            ModuleLoadStatus.MODULE_LOAD_COMPLETE :
            ModuleLoadStatus.MODULE_LOAD_NOT_ATTEMPTED;
    }
    computeShowBrowserPromo_() {
        return !this.modulesEnabled_ ||
            (this.modulesLoadedStatus_ !==
                ModuleLoadStatus.MODULE_LOAD_IN_PROGRESS &&
                !this.modulesShownToUser);
    }
    recordBrowserPromoMetrics_() {
        if (!this.showBrowserPromo_) {
            recordShowBrowserPromosResult(ShowNtpPromosResult.kNotShownDueToPolicy);
            return;
        }
        switch (this.browserPromoType_) {
            case 'disabled':
                recordShowBrowserPromosResult(ShowNtpPromosResult.kNotShownDueToPolicy);
                break;
            case 'empty':
                recordShowBrowserPromosResult(ShowNtpPromosResult.kNotShownNoPromos);
                break;
            case 'simple':
            case 'setuplist':
                recordShowBrowserPromosResult(ShowNtpPromosResult.kShown);
                break;
        }
    }
    onCustomizeModule_() {
        this.showCustomize_ = true;
        this.selectedCustomizeDialogPage_ = CustomizeDialogPage.MODULES;
        recordCustomizeChromeOpen(NtpCustomizeChromeEntryPoint.MODULE);
        this.setCustomizeChromeSidePanelVisible_(this.showCustomize_);
    }
    setCustomizeChromeSidePanelVisible_(visible) {
        let section = CustomizeChromeSection.kUnspecified;
        switch (this.selectedCustomizeDialogPage_) {
            case CustomizeDialogPage.BACKGROUNDS:
            case CustomizeDialogPage.THEMES:
                section = CustomizeChromeSection.kAppearance;
                break;
            case CustomizeDialogPage.SHORTCUTS:
                section = CustomizeChromeSection.kShortcuts;
                break;
            case CustomizeDialogPage.MODULES:
                section = CustomizeChromeSection.kModules;
                break;
            case CustomizeDialogPage.WALLPAPER_SEARCH:
                section = CustomizeChromeSection.kWallpaperSearch;
                break;
        }
        this.customizeButtonsHandler_.setCustomizeChromeSidePanelVisible(visible, section, SidePanelOpenTrigger.kNewTabPage);
    }
    printPerformanceDatum_(name, time, auxTime = 0) {
        if (!this.shouldPrintPerformance_) {
            return;
        }
        console.info(!auxTime ? `${name}: ${time}` : `${name}: ${time} (${auxTime})`);
    }
    /**
     * Prints performance measurements to the console. Also, installs  performance
     * observer to continuously print performance measurements after.
     */
    printPerformance_() {
        if (!this.shouldPrintPerformance_) {
            return;
        }
        const entryTypes = ['paint', 'measure'];
        const log = (entry) => {
            this.printPerformanceDatum_(entry.name, entry.duration ? entry.duration : entry.startTime, entry.duration && entry.startTime ? entry.startTime : 0);
        };
        const observer = new PerformanceObserver(list => {
            list.getEntries().forEach((entry) => {
                log(entry);
            });
        });
        observer.observe({ entryTypes: entryTypes });
        performance.getEntries().forEach((entry) => {
            if (!entryTypes.includes(entry.entryType)) {
                return;
            }
            log(entry);
        });
    }
    onWebstoreToastButtonClick_() {
        window.location.assign(`https://chrome.google.com/webstore/category/collection/chrome_color_themes?hl=${window.navigator.language}`);
    }
    onWindowClick_(e) {
        if (e.composedPath() && e.composedPath()[0] === $$(this, '#content')) {
            recordClick(NtpElement.BACKGROUND);
            return;
        }
        for (const target of e.composedPath()) {
            switch (target) {
                case $$(this, 'ntp-logo'):
                    recordClick(NtpElement.LOGO);
                    return;
                case $$(this, 'cr-searchbox'):
                    recordClick(NtpElement.REALBOX);
                    return;
                case $$(this, 'ntp-action-chips'):
                    recordClick(NtpElement.ACTION_CHIPS);
                    return;
                case $$(this, 'cr-most-visited'):
                    recordClick(NtpElement.MOST_VISITED);
                    return;
                case $$(this, 'ntp-middle-slot-promo'):
                    recordClick(NtpElement.MIDDLE_SLOT_PROMO);
                    return;
                case $$(this, '#modules'):
                    recordClick(NtpElement.MODULE);
                    return;
            }
        }
        const customizeButtonsElement = this.shadowRoot.querySelector('ntp-customize-buttons');
        if (customizeButtonsElement) {
            for (const target of e.composedPath()) {
                switch (target) {
                    case $$(customizeButtonsElement, '#customizeButton'):
                        recordClick(NtpElement.CUSTOMIZE_BUTTON);
                        return;
                    case $$(customizeButtonsElement, '#wallpaperSearchButton'):
                        recordClick(NtpElement.WALLPAPER_SEARCH_BUTTON);
                        return;
                }
            }
        }
        recordClick(NtpElement.OTHER);
    }
    isThemeDark_() {
        return !!this.theme_ && this.theme_.isDark;
    }
    themeHasBackgroundImage_() {
        return !!this.theme_ && !!this.theme_.backgroundImage;
    }
    showThemeAttribution_() {
        return !!this.theme_?.backgroundImage?.attributionUrl;
    }
    onInputFocusChanged_(e) {
        switch (e.type) {
            case 'searchbox-input-focus-changed':
                this.searchboxInputFocused_ = e.detail.value;
                break;
            case 'composebox-input-focus-changed':
                this.composeboxInputFocused_ = e.detail.value;
                break;
        }
    }
    onRealboxHadSecondarySideChanged_(e) {
        this.realboxHadSecondarySide = e.detail.value;
    }
    onModulesShownToUserChanged_(e) {
        this.modulesShownToUser = e.detail.value;
    }
    onActionChipsRetrievalStateChanged_(e) {
        const state = e.detail.state;
        // Mapping of ActionChipsRetrievalState => GlifAnimationState:
        // REQUESTED => SPINNER_ONLY
        // UPDATED => STARTED (or FINISHED if cr_context_menu_entrypoint sets it)
        // To avoid going back (or continuing) GlifAnimationState.STARTED, we stop
        // updating the field when the current state is STARTED or FINISHED.
        // There are a few cases to consider:
        // - IsActionChipsVisible_ is false (and remains so): no event from the
        //   action chips element, and thus the animation state remains INELIGIBLE.
        // - IsActionChipsVisible_ is false and later becomes true: the change
        //   triggers the rendering of the action chips element, and this in turn
        //   causes an event with ActionChipsRetrievalState.REQUESTED to be fired.
        //   After some time, an event with ActionChipsRetrievalState.UPDATED will
        //   fire, and this starts the animation.
        // - IsActionChipsVisible_ is true from the beginning: Same as above.
        if ([GlifAnimationState.STARTED, GlifAnimationState.FINISHED].every(s => s !== this.contextMenuGlifAnimationState_)) {
            if (state === ActionChipsRetrievalState.REQUESTED) {
                this.contextMenuGlifAnimationState_ = GlifAnimationState.SPINNER_ONLY;
            }
            else if (state === ActionChipsRetrievalState.UPDATED) {
                this.contextMenuGlifAnimationState_ = GlifAnimationState.STARTED;
            }
        }
    }
    /**
     * Called whenever an auto-removed feature is being processed and the undo
     * toast needs to be shown. This will queue up the toast in the pending FIFO
     * list and then call the processing function.
     *
     * @param undoToastContext - An event that contains the undo toast message and
     *                           the undo callback function.
     */
    showAutoRemovedToast_(undoToastContext) {
        this.pendingAutoRemovalToasts_.push(undoToastContext.detail);
        this.processPendingAutoRemovalToasts_();
    }
    /**
     * Called whenever the pending toasts need to be processed. This is called
     * whenever a new toast is added to the pending list through an auto-removal
     * event, or when the user clicks on the undo button in the toast.
     *
     * In case the undo toast is already open, then it's a no-op to avoid showing
     * multiple toasts at the same time. Otherwise, the first pending toast is
     * popped and shown.
     */
    processPendingAutoRemovalToasts_() {
        if (this.pendingAutoRemovalToasts_.length === 0) {
            return;
        }
        if (this.$.undoToast.open) {
            return;
        }
        const undoToastContext = this.pendingAutoRemovalToasts_.shift();
        this.undoAutoRemovalCallback_ = undoToastContext.undo;
        this.undoAutoRemovalMessage_ = undoToastContext.message;
        this.$.undoToast.show();
    }
    /**
     * Processes an auto-removal undo click. It will hide the toast, call the
     * undo callback, and call the processing function to handle the next queued
     * toast (if any).
     */
    onAutoRemovalUndoClick_() {
        this.$.undoToast.hide();
        this.undoAutoRemovalCallback_?.();
        this.undoAutoRemovalCallback_ = null;
        this.undoAutoRemovalMessage_ = null;
        this.processPendingAutoRemovalToasts_();
    }
}
customElements.define(AppElement.is, AppElement);

export { $$, AppElement, BackgroundManager, BrowserCommandProxy, BrowserProxyImpl, CUSTOMIZE_CHROME_BUTTON_ELEMENT_ID, CustomizeButtonsProxy, CustomizeDialogPage, DoodleShareDialogElement, IframeElement, LogoElement, MetricsReporterImpl, NewTabPageProxy, NtpCustomizeChromeEntryPoint, NtpElement, PlaceholderTextCycler, SearchboxBrowserProxy, SearchboxElement, SearchboxIconElement, SearchboxMatchElement, Action as VoiceAction, WindowProxy, createAutocompleteMatch, getTrustedHTML, recordBoolean, recordDuration, recordEnumeration, recordLinearValue, recordLoadDuration, recordSparseValueWithPersistentHash };
//# sourceMappingURL=new_tab_page.rollup.js.map
