// chrome/browser/ui/webui/new_tab_footer/new_tab_footer.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  PointSpec as gfx_mojom_PointSpec,
  Point as gfx_mojom_Point
} from '//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const NewTabPageTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum NewTabPageType {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kFirstPartyWebUI = 0,
  kExtension = 1,
  kOther = 2,
}



export type NewTabFooterHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<NewTabFooterHandlerFactoryPendingReceiver>;

export class NewTabFooterHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<NewTabFooterHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<NewTabFooterHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|NewTabFooterHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'new_tab_footer.mojom.NewTabFooterHandlerFactory',
        scope);
  }
}

export interface NewTabFooterHandlerFactoryInterface {
  createNewTabFooterHandler(document: NewTabFooterDocumentRemote, handler: NewTabFooterHandlerPendingReceiver): void;
}

export class NewTabFooterHandlerFactoryRemote implements NewTabFooterHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<NewTabFooterHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<NewTabFooterHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|NewTabFooterHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NewTabFooterHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createNewTabFooterHandler(
      document: NewTabFooterDocumentRemote,
      handler: NewTabFooterHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        NewTabFooterHandlerFactory_CreateNewTabFooterHandler_ParamsSpec.$,
        null,
        [
          document,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NewTabFooterHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NewTabFooterHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    NewTabFooterHandlerFactoryRemote, NewTabFooterHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    NewTabFooterHandlerFactoryRemote, NewTabFooterHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: NewTabFooterHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NewTabFooterHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NewTabFooterHandlerFactory_CreateNewTabFooterHandler_ParamsSpec.$,
        null,
        impl.createNewTabFooterHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NewTabFooterHandlerFactory {
  static get $interfaceName(): string {
    return "new_tab_footer.mojom.NewTabFooterHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): NewTabFooterHandlerFactoryRemote {
    let remote = new NewTabFooterHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the NewTabFooterHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NewTabFooterHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    NewTabFooterHandlerFactoryRemote, NewTabFooterHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    NewTabFooterHandlerFactoryRemote, NewTabFooterHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createNewTabFooterHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NewTabFooterHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createNewTabFooterHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NewTabFooterHandlerFactory_CreateNewTabFooterHandler_ParamsSpec.$,
        null,
        this.createNewTabFooterHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type NewTabFooterHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<NewTabFooterHandlerPendingReceiver>;

export class NewTabFooterHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<NewTabFooterHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<NewTabFooterHandlerPendingReceiver>;
  constructor(handle: MojoHandle|NewTabFooterHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'new_tab_footer.mojom.NewTabFooterHandler',
        scope);
  }
}

export interface NewTabFooterHandlerInterface {
  updateNtpExtensionName(): void;
  updateManagementNotice(): void;
  updateAttachedTabState(): void;
  updateBackgroundAttribution(): void;
  openExtensionOptionsPageWithFallback(): void;
  openManagementPage(): void;
  openUrlInCurrentTab(url: url_mojom_Url): void;
  showContextMenu(point: gfx_mojom_Point): void;
  notifyCustomizationButtonVisible(): void;
}

export class NewTabFooterHandlerRemote implements NewTabFooterHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<NewTabFooterHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<NewTabFooterHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|NewTabFooterHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NewTabFooterHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  updateNtpExtensionName(): void {
    this.proxy.sendMessage(
        0,
        NewTabFooterHandler_UpdateNtpExtensionName_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  updateManagementNotice(): void {
    this.proxy.sendMessage(
        1,
        NewTabFooterHandler_UpdateManagementNotice_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  updateAttachedTabState(): void {
    this.proxy.sendMessage(
        2,
        NewTabFooterHandler_UpdateAttachedTabState_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  updateBackgroundAttribution(): void {
    this.proxy.sendMessage(
        3,
        NewTabFooterHandler_UpdateBackgroundAttribution_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openExtensionOptionsPageWithFallback(): void {
    this.proxy.sendMessage(
        4,
        NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openManagementPage(): void {
    this.proxy.sendMessage(
        5,
        NewTabFooterHandler_OpenManagementPage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openUrlInCurrentTab(
      url: url_mojom_Url): void {
    this.proxy.sendMessage(
        6,
        NewTabFooterHandler_OpenUrlInCurrentTab_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  showContextMenu(
      point: gfx_mojom_Point): void {
    this.proxy.sendMessage(
        7,
        NewTabFooterHandler_ShowContextMenu_ParamsSpec.$,
        null,
        [
          point
        ],
        false);
  }

  notifyCustomizationButtonVisible(): void {
    this.proxy.sendMessage(
        8,
        NewTabFooterHandler_NotifyCustomizationButtonVisible_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NewTabFooterHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NewTabFooterHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    NewTabFooterHandlerRemote, NewTabFooterHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    NewTabFooterHandlerRemote, NewTabFooterHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: NewTabFooterHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NewTabFooterHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NewTabFooterHandler_UpdateNtpExtensionName_ParamsSpec.$,
        null,
        impl.updateNtpExtensionName.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NewTabFooterHandler_UpdateManagementNotice_ParamsSpec.$,
        null,
        impl.updateManagementNotice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        NewTabFooterHandler_UpdateAttachedTabState_ParamsSpec.$,
        null,
        impl.updateAttachedTabState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        NewTabFooterHandler_UpdateBackgroundAttribution_ParamsSpec.$,
        null,
        impl.updateBackgroundAttribution.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_ParamsSpec.$,
        null,
        impl.openExtensionOptionsPageWithFallback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        NewTabFooterHandler_OpenManagementPage_ParamsSpec.$,
        null,
        impl.openManagementPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        NewTabFooterHandler_OpenUrlInCurrentTab_ParamsSpec.$,
        null,
        impl.openUrlInCurrentTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        NewTabFooterHandler_ShowContextMenu_ParamsSpec.$,
        null,
        impl.showContextMenu.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        NewTabFooterHandler_NotifyCustomizationButtonVisible_ParamsSpec.$,
        null,
        impl.notifyCustomizationButtonVisible.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NewTabFooterHandler {
  static get $interfaceName(): string {
    return "new_tab_footer.mojom.NewTabFooterHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): NewTabFooterHandlerRemote {
    let remote = new NewTabFooterHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the NewTabFooterHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NewTabFooterHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    NewTabFooterHandlerRemote, NewTabFooterHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    NewTabFooterHandlerRemote, NewTabFooterHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  updateNtpExtensionName: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateManagementNotice: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateAttachedTabState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateBackgroundAttribution: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openExtensionOptionsPageWithFallback: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openManagementPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openUrlInCurrentTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showContextMenu: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyCustomizationButtonVisible: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NewTabFooterHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.updateNtpExtensionName =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NewTabFooterHandler_UpdateNtpExtensionName_ParamsSpec.$,
        null,
        this.updateNtpExtensionName.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateManagementNotice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NewTabFooterHandler_UpdateManagementNotice_ParamsSpec.$,
        null,
        this.updateManagementNotice.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateAttachedTabState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        NewTabFooterHandler_UpdateAttachedTabState_ParamsSpec.$,
        null,
        this.updateAttachedTabState.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateBackgroundAttribution =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        NewTabFooterHandler_UpdateBackgroundAttribution_ParamsSpec.$,
        null,
        this.updateBackgroundAttribution.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openExtensionOptionsPageWithFallback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_ParamsSpec.$,
        null,
        this.openExtensionOptionsPageWithFallback.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openManagementPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        NewTabFooterHandler_OpenManagementPage_ParamsSpec.$,
        null,
        this.openManagementPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openUrlInCurrentTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        NewTabFooterHandler_OpenUrlInCurrentTab_ParamsSpec.$,
        null,
        this.openUrlInCurrentTab.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showContextMenu =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        NewTabFooterHandler_ShowContextMenu_ParamsSpec.$,
        null,
        this.showContextMenu.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyCustomizationButtonVisible =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        NewTabFooterHandler_NotifyCustomizationButtonVisible_ParamsSpec.$,
        null,
        this.notifyCustomizationButtonVisible.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type NewTabFooterDocumentPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<NewTabFooterDocumentPendingReceiver>;

export class NewTabFooterDocumentPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<NewTabFooterDocument> {

  handle: mojo.internal.interfaceSupport.Endpoint<NewTabFooterDocumentPendingReceiver>;
  constructor(handle: MojoHandle|NewTabFooterDocumentPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'new_tab_footer.mojom.NewTabFooterDocument',
        scope);
  }
}

export interface NewTabFooterDocumentInterface {
  setNtpExtensionName(name: string): void;
  setManagementNotice(notice: (ManagementNotice | null)): void;
  attachedTabStateUpdated(ntpType: NewTabPageType, canCustomizeChrome: boolean): void;
  setBackgroundAttribution(backgroundImageAttribution: (BackgroundAttribution | null)): void;
}

export class NewTabFooterDocumentRemote implements NewTabFooterDocumentInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<NewTabFooterDocumentPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<NewTabFooterDocumentPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|NewTabFooterDocumentPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NewTabFooterDocumentPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setNtpExtensionName(
      name: string): void {
    this.proxy.sendMessage(
        0,
        NewTabFooterDocument_SetNtpExtensionName_ParamsSpec.$,
        null,
        [
          name
        ],
        false);
  }

  setManagementNotice(
      notice: (ManagementNotice | null)): void {
    this.proxy.sendMessage(
        1,
        NewTabFooterDocument_SetManagementNotice_ParamsSpec.$,
        null,
        [
          notice
        ],
        false);
  }

  attachedTabStateUpdated(
      ntpType: NewTabPageType,
      canCustomizeChrome: boolean): void {
    this.proxy.sendMessage(
        2,
        NewTabFooterDocument_AttachedTabStateUpdated_ParamsSpec.$,
        null,
        [
          ntpType,
          canCustomizeChrome
        ],
        false);
  }

  setBackgroundAttribution(
      backgroundImageAttribution: (BackgroundAttribution | null)): void {
    this.proxy.sendMessage(
        3,
        NewTabFooterDocument_SetBackgroundAttribution_ParamsSpec.$,
        null,
        [
          backgroundImageAttribution
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NewTabFooterDocument
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NewTabFooterDocumentReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    NewTabFooterDocumentRemote, NewTabFooterDocumentPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    NewTabFooterDocumentRemote, NewTabFooterDocumentPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: NewTabFooterDocumentInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NewTabFooterDocumentRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NewTabFooterDocument_SetNtpExtensionName_ParamsSpec.$,
        null,
        impl.setNtpExtensionName.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NewTabFooterDocument_SetManagementNotice_ParamsSpec.$,
        null,
        impl.setManagementNotice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        NewTabFooterDocument_AttachedTabStateUpdated_ParamsSpec.$,
        null,
        impl.attachedTabStateUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        NewTabFooterDocument_SetBackgroundAttribution_ParamsSpec.$,
        null,
        impl.setBackgroundAttribution.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NewTabFooterDocument {
  static get $interfaceName(): string {
    return "new_tab_footer.mojom.NewTabFooterDocument";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): NewTabFooterDocumentRemote {
    let remote = new NewTabFooterDocumentRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the NewTabFooterDocument
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NewTabFooterDocumentCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    NewTabFooterDocumentRemote, NewTabFooterDocumentPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    NewTabFooterDocumentRemote, NewTabFooterDocumentPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setNtpExtensionName: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setManagementNotice: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  attachedTabStateUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setBackgroundAttribution: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NewTabFooterDocumentRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setNtpExtensionName =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NewTabFooterDocument_SetNtpExtensionName_ParamsSpec.$,
        null,
        this.setNtpExtensionName.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setManagementNotice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NewTabFooterDocument_SetManagementNotice_ParamsSpec.$,
        null,
        this.setManagementNotice.createReceiverHandler(false /* expectsResponse */),
        false);
    this.attachedTabStateUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        NewTabFooterDocument_AttachedTabStateUpdated_ParamsSpec.$,
        null,
        this.attachedTabStateUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setBackgroundAttribution =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        NewTabFooterDocument_SetBackgroundAttribution_ParamsSpec.$,
        null,
        this.setBackgroundAttribution.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ManagementNoticeSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BackgroundAttributionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NewTabFooterHandlerFactory_CreateNewTabFooterHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NewTabFooterHandler_UpdateNtpExtensionName_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NewTabFooterHandler_UpdateManagementNotice_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NewTabFooterHandler_UpdateAttachedTabState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NewTabFooterHandler_UpdateBackgroundAttribution_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NewTabFooterHandler_OpenManagementPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NewTabFooterHandler_OpenUrlInCurrentTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NewTabFooterHandler_ShowContextMenu_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NewTabFooterHandler_NotifyCustomizationButtonVisible_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NewTabFooterDocument_SetNtpExtensionName_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NewTabFooterDocument_SetManagementNotice_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NewTabFooterDocument_AttachedTabStateUpdated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NewTabFooterDocument_SetBackgroundAttribution_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ManagementNoticeMojoType {
  text: string;
  customBitmapDataUrl: (url_mojom_Url | null);
}


export type ManagementNotice = ManagementNoticeMojoType;
mojo.internal.Struct<ManagementNoticeMojoType>(
    ManagementNoticeSpec.$,
    'ManagementNotice',
    [
      mojo.internal.StructField<ManagementNoticeMojoType, string>(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ManagementNoticeMojoType, url_mojom_Url>(
        'customBitmapDataUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BackgroundAttributionMojoType {
  name: string;
  url: (url_mojom_Url | null);
}


export type BackgroundAttribution = BackgroundAttributionMojoType;
mojo.internal.Struct<BackgroundAttributionMojoType>(
    BackgroundAttributionSpec.$,
    'BackgroundAttribution',
    [
      mojo.internal.StructField<BackgroundAttributionMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundAttributionMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface NewTabFooterHandlerFactory_CreateNewTabFooterHandler_ParamsMojoType {
  document: NewTabFooterDocumentRemote;
  handler: NewTabFooterHandlerPendingReceiver;
}


export type NewTabFooterHandlerFactory_CreateNewTabFooterHandler_Params = NewTabFooterHandlerFactory_CreateNewTabFooterHandler_ParamsMojoType;
mojo.internal.Struct<NewTabFooterHandlerFactory_CreateNewTabFooterHandler_ParamsMojoType>(
    NewTabFooterHandlerFactory_CreateNewTabFooterHandler_ParamsSpec.$,
    'NewTabFooterHandlerFactory_CreateNewTabFooterHandler_Params',
    [
      mojo.internal.StructField<NewTabFooterHandlerFactory_CreateNewTabFooterHandler_ParamsMojoType, NewTabFooterDocumentRemote>(
        'document', 0,
        0,
        mojo.internal.InterfaceProxy(NewTabFooterDocumentRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<NewTabFooterHandlerFactory_CreateNewTabFooterHandler_ParamsMojoType, NewTabFooterHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(NewTabFooterHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface NewTabFooterHandler_UpdateNtpExtensionName_ParamsMojoType {
}


export type NewTabFooterHandler_UpdateNtpExtensionName_Params = NewTabFooterHandler_UpdateNtpExtensionName_ParamsMojoType;
mojo.internal.Struct<NewTabFooterHandler_UpdateNtpExtensionName_ParamsMojoType>(
    NewTabFooterHandler_UpdateNtpExtensionName_ParamsSpec.$,
    'NewTabFooterHandler_UpdateNtpExtensionName_Params',
    [
    ],
    [[0, 8],]);





export interface NewTabFooterHandler_UpdateManagementNotice_ParamsMojoType {
}


export type NewTabFooterHandler_UpdateManagementNotice_Params = NewTabFooterHandler_UpdateManagementNotice_ParamsMojoType;
mojo.internal.Struct<NewTabFooterHandler_UpdateManagementNotice_ParamsMojoType>(
    NewTabFooterHandler_UpdateManagementNotice_ParamsSpec.$,
    'NewTabFooterHandler_UpdateManagementNotice_Params',
    [
    ],
    [[0, 8],]);





export interface NewTabFooterHandler_UpdateAttachedTabState_ParamsMojoType {
}


export type NewTabFooterHandler_UpdateAttachedTabState_Params = NewTabFooterHandler_UpdateAttachedTabState_ParamsMojoType;
mojo.internal.Struct<NewTabFooterHandler_UpdateAttachedTabState_ParamsMojoType>(
    NewTabFooterHandler_UpdateAttachedTabState_ParamsSpec.$,
    'NewTabFooterHandler_UpdateAttachedTabState_Params',
    [
    ],
    [[0, 8],]);





export interface NewTabFooterHandler_UpdateBackgroundAttribution_ParamsMojoType {
}


export type NewTabFooterHandler_UpdateBackgroundAttribution_Params = NewTabFooterHandler_UpdateBackgroundAttribution_ParamsMojoType;
mojo.internal.Struct<NewTabFooterHandler_UpdateBackgroundAttribution_ParamsMojoType>(
    NewTabFooterHandler_UpdateBackgroundAttribution_ParamsSpec.$,
    'NewTabFooterHandler_UpdateBackgroundAttribution_Params',
    [
    ],
    [[0, 8],]);





export interface NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_ParamsMojoType {
}


export type NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_Params = NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_ParamsMojoType;
mojo.internal.Struct<NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_ParamsMojoType>(
    NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_ParamsSpec.$,
    'NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_Params',
    [
    ],
    [[0, 8],]);





export interface NewTabFooterHandler_OpenManagementPage_ParamsMojoType {
}


export type NewTabFooterHandler_OpenManagementPage_Params = NewTabFooterHandler_OpenManagementPage_ParamsMojoType;
mojo.internal.Struct<NewTabFooterHandler_OpenManagementPage_ParamsMojoType>(
    NewTabFooterHandler_OpenManagementPage_ParamsSpec.$,
    'NewTabFooterHandler_OpenManagementPage_Params',
    [
    ],
    [[0, 8],]);





export interface NewTabFooterHandler_OpenUrlInCurrentTab_ParamsMojoType {
  url: url_mojom_Url;
}


export type NewTabFooterHandler_OpenUrlInCurrentTab_Params = NewTabFooterHandler_OpenUrlInCurrentTab_ParamsMojoType;
mojo.internal.Struct<NewTabFooterHandler_OpenUrlInCurrentTab_ParamsMojoType>(
    NewTabFooterHandler_OpenUrlInCurrentTab_ParamsSpec.$,
    'NewTabFooterHandler_OpenUrlInCurrentTab_Params',
    [
      mojo.internal.StructField<NewTabFooterHandler_OpenUrlInCurrentTab_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface NewTabFooterHandler_ShowContextMenu_ParamsMojoType {
  point: gfx_mojom_Point;
}


export type NewTabFooterHandler_ShowContextMenu_Params = NewTabFooterHandler_ShowContextMenu_ParamsMojoType;
mojo.internal.Struct<NewTabFooterHandler_ShowContextMenu_ParamsMojoType>(
    NewTabFooterHandler_ShowContextMenu_ParamsSpec.$,
    'NewTabFooterHandler_ShowContextMenu_Params',
    [
      mojo.internal.StructField<NewTabFooterHandler_ShowContextMenu_ParamsMojoType, gfx_mojom_Point>(
        'point', 0,
        0,
        gfx_mojom_PointSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface NewTabFooterHandler_NotifyCustomizationButtonVisible_ParamsMojoType {
}


export type NewTabFooterHandler_NotifyCustomizationButtonVisible_Params = NewTabFooterHandler_NotifyCustomizationButtonVisible_ParamsMojoType;
mojo.internal.Struct<NewTabFooterHandler_NotifyCustomizationButtonVisible_ParamsMojoType>(
    NewTabFooterHandler_NotifyCustomizationButtonVisible_ParamsSpec.$,
    'NewTabFooterHandler_NotifyCustomizationButtonVisible_Params',
    [
    ],
    [[0, 8],]);





export interface NewTabFooterDocument_SetNtpExtensionName_ParamsMojoType {
  name: string;
}


export type NewTabFooterDocument_SetNtpExtensionName_Params = NewTabFooterDocument_SetNtpExtensionName_ParamsMojoType;
mojo.internal.Struct<NewTabFooterDocument_SetNtpExtensionName_ParamsMojoType>(
    NewTabFooterDocument_SetNtpExtensionName_ParamsSpec.$,
    'NewTabFooterDocument_SetNtpExtensionName_Params',
    [
      mojo.internal.StructField<NewTabFooterDocument_SetNtpExtensionName_ParamsMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface NewTabFooterDocument_SetManagementNotice_ParamsMojoType {
  notice: (ManagementNotice | null);
}


export type NewTabFooterDocument_SetManagementNotice_Params = NewTabFooterDocument_SetManagementNotice_ParamsMojoType;
mojo.internal.Struct<NewTabFooterDocument_SetManagementNotice_ParamsMojoType>(
    NewTabFooterDocument_SetManagementNotice_ParamsSpec.$,
    'NewTabFooterDocument_SetManagementNotice_Params',
    [
      mojo.internal.StructField<NewTabFooterDocument_SetManagementNotice_ParamsMojoType, ManagementNotice>(
        'notice', 0,
        0,
        ManagementNoticeSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface NewTabFooterDocument_AttachedTabStateUpdated_ParamsMojoType {
  ntpType: NewTabPageType;
  canCustomizeChrome: boolean;
}


export type NewTabFooterDocument_AttachedTabStateUpdated_Params = NewTabFooterDocument_AttachedTabStateUpdated_ParamsMojoType;
mojo.internal.Struct<NewTabFooterDocument_AttachedTabStateUpdated_ParamsMojoType>(
    NewTabFooterDocument_AttachedTabStateUpdated_ParamsSpec.$,
    'NewTabFooterDocument_AttachedTabStateUpdated_Params',
    [
      mojo.internal.StructField<NewTabFooterDocument_AttachedTabStateUpdated_ParamsMojoType, NewTabPageType>(
        'ntpType', 0,
        0,
        NewTabPageTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<NewTabFooterDocument_AttachedTabStateUpdated_ParamsMojoType, boolean>(
        'canCustomizeChrome', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface NewTabFooterDocument_SetBackgroundAttribution_ParamsMojoType {
  backgroundImageAttribution: (BackgroundAttribution | null);
}


export type NewTabFooterDocument_SetBackgroundAttribution_Params = NewTabFooterDocument_SetBackgroundAttribution_ParamsMojoType;
mojo.internal.Struct<NewTabFooterDocument_SetBackgroundAttribution_ParamsMojoType>(
    NewTabFooterDocument_SetBackgroundAttribution_ParamsSpec.$,
    'NewTabFooterDocument_SetBackgroundAttribution_Params',
    [
      mojo.internal.StructField<NewTabFooterDocument_SetBackgroundAttribution_ParamsMojoType, BackgroundAttribution>(
        'backgroundImageAttribution', 0,
        0,
        BackgroundAttributionSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



