// services/media_session/public/mojom/media_session.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { String16Spec as mojoBase_mojom_String16Spec } from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import { TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec, TimeTicksSpec as mojoBase_mojom_TimeTicksSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { SizeSpec as gfx_mojom_SizeSpec } from '//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const MediaPlaybackStateSpec = { $: mojo.internal.Enum() };
export var MediaPlaybackState;
(function (MediaPlaybackState) {
    MediaPlaybackState[MediaPlaybackState["MIN_VALUE"] = 0] = "MIN_VALUE";
    MediaPlaybackState[MediaPlaybackState["MAX_VALUE"] = 1] = "MAX_VALUE";
    MediaPlaybackState[MediaPlaybackState["kPaused"] = 0] = "kPaused";
    MediaPlaybackState[MediaPlaybackState["kPlaying"] = 1] = "kPlaying";
})(MediaPlaybackState || (MediaPlaybackState = {}));
export const MediaSessionActionSpec = { $: mojo.internal.Enum() };
export var MediaSessionAction;
(function (MediaSessionAction) {
    MediaSessionAction[MediaSessionAction["MIN_VALUE"] = 0] = "MIN_VALUE";
    MediaSessionAction[MediaSessionAction["MAX_VALUE"] = 20] = "MAX_VALUE";
    MediaSessionAction[MediaSessionAction["kPlay"] = 0] = "kPlay";
    MediaSessionAction[MediaSessionAction["kPause"] = 1] = "kPause";
    MediaSessionAction[MediaSessionAction["kPreviousTrack"] = 2] = "kPreviousTrack";
    MediaSessionAction[MediaSessionAction["kNextTrack"] = 3] = "kNextTrack";
    MediaSessionAction[MediaSessionAction["kSeekBackward"] = 4] = "kSeekBackward";
    MediaSessionAction[MediaSessionAction["kSeekForward"] = 5] = "kSeekForward";
    MediaSessionAction[MediaSessionAction["kSkipAd"] = 6] = "kSkipAd";
    MediaSessionAction[MediaSessionAction["kStop"] = 7] = "kStop";
    MediaSessionAction[MediaSessionAction["kSeekTo"] = 8] = "kSeekTo";
    MediaSessionAction[MediaSessionAction["kScrubTo"] = 9] = "kScrubTo";
    MediaSessionAction[MediaSessionAction["kEnterPictureInPicture"] = 10] = "kEnterPictureInPicture";
    MediaSessionAction[MediaSessionAction["kExitPictureInPicture"] = 11] = "kExitPictureInPicture";
    MediaSessionAction[MediaSessionAction["kSwitchAudioDevice"] = 12] = "kSwitchAudioDevice";
    MediaSessionAction[MediaSessionAction["kToggleMicrophone"] = 13] = "kToggleMicrophone";
    MediaSessionAction[MediaSessionAction["kToggleCamera"] = 14] = "kToggleCamera";
    MediaSessionAction[MediaSessionAction["kHangUp"] = 15] = "kHangUp";
    MediaSessionAction[MediaSessionAction["kRaise"] = 16] = "kRaise";
    MediaSessionAction[MediaSessionAction["kSetMute"] = 17] = "kSetMute";
    MediaSessionAction[MediaSessionAction["kPreviousSlide"] = 18] = "kPreviousSlide";
    MediaSessionAction[MediaSessionAction["kNextSlide"] = 19] = "kNextSlide";
    MediaSessionAction[MediaSessionAction["kEnterAutoPictureInPicture"] = 20] = "kEnterAutoPictureInPicture";
})(MediaSessionAction || (MediaSessionAction = {}));
export const MediaSessionImageTypeSpec = { $: mojo.internal.Enum() };
export var MediaSessionImageType;
(function (MediaSessionImageType) {
    MediaSessionImageType[MediaSessionImageType["MIN_VALUE"] = 0] = "MIN_VALUE";
    MediaSessionImageType[MediaSessionImageType["MAX_VALUE"] = 2] = "MAX_VALUE";
    MediaSessionImageType[MediaSessionImageType["kArtwork"] = 0] = "kArtwork";
    MediaSessionImageType[MediaSessionImageType["kSourceIcon"] = 1] = "kSourceIcon";
    MediaSessionImageType[MediaSessionImageType["kChapter"] = 2] = "kChapter";
})(MediaSessionImageType || (MediaSessionImageType = {}));
export const MediaPictureInPictureStateSpec = { $: mojo.internal.Enum() };
export var MediaPictureInPictureState;
(function (MediaPictureInPictureState) {
    MediaPictureInPictureState[MediaPictureInPictureState["MIN_VALUE"] = 0] = "MIN_VALUE";
    MediaPictureInPictureState[MediaPictureInPictureState["MAX_VALUE"] = 1] = "MAX_VALUE";
    MediaPictureInPictureState[MediaPictureInPictureState["kNotInPictureInPicture"] = 0] = "kNotInPictureInPicture";
    MediaPictureInPictureState[MediaPictureInPictureState["kInPictureInPicture"] = 1] = "kInPictureInPicture";
})(MediaPictureInPictureState || (MediaPictureInPictureState = {}));
export const MediaAudioVideoStateSpec = { $: mojo.internal.Enum() };
export var MediaAudioVideoState;
(function (MediaAudioVideoState) {
    MediaAudioVideoState[MediaAudioVideoState["MIN_VALUE"] = 0] = "MIN_VALUE";
    MediaAudioVideoState[MediaAudioVideoState["MAX_VALUE"] = 3] = "MAX_VALUE";
    MediaAudioVideoState[MediaAudioVideoState["kDeprecatedUnknown"] = 0] = "kDeprecatedUnknown";
    MediaAudioVideoState[MediaAudioVideoState["kAudioOnly"] = 1] = "kAudioOnly";
    MediaAudioVideoState[MediaAudioVideoState["kAudioVideo"] = 2] = "kAudioVideo";
    MediaAudioVideoState[MediaAudioVideoState["kVideoOnly"] = 3] = "kVideoOnly";
})(MediaAudioVideoState || (MediaAudioVideoState = {}));
export const MediaImageBitmapColorTypeSpec = { $: mojo.internal.Enum() };
export var MediaImageBitmapColorType;
(function (MediaImageBitmapColorType) {
    MediaImageBitmapColorType[MediaImageBitmapColorType["MIN_VALUE"] = 0] = "MIN_VALUE";
    MediaImageBitmapColorType[MediaImageBitmapColorType["MAX_VALUE"] = 1] = "MAX_VALUE";
    MediaImageBitmapColorType[MediaImageBitmapColorType["kRGBA_8888"] = 0] = "kRGBA_8888";
    MediaImageBitmapColorType[MediaImageBitmapColorType["kBGRA_8888"] = 1] = "kBGRA_8888";
})(MediaImageBitmapColorType || (MediaImageBitmapColorType = {}));
export const MicrophoneStateSpec = { $: mojo.internal.Enum() };
export var MicrophoneState;
(function (MicrophoneState) {
    MicrophoneState[MicrophoneState["MIN_VALUE"] = 0] = "MIN_VALUE";
    MicrophoneState[MicrophoneState["MAX_VALUE"] = 2] = "MAX_VALUE";
    MicrophoneState[MicrophoneState["kUnknown"] = 0] = "kUnknown";
    MicrophoneState[MicrophoneState["kMuted"] = 1] = "kMuted";
    MicrophoneState[MicrophoneState["kUnmuted"] = 2] = "kUnmuted";
})(MicrophoneState || (MicrophoneState = {}));
export const CameraStateSpec = { $: mojo.internal.Enum() };
export var CameraState;
(function (CameraState) {
    CameraState[CameraState["MIN_VALUE"] = 0] = "MIN_VALUE";
    CameraState[CameraState["MAX_VALUE"] = 2] = "MAX_VALUE";
    CameraState[CameraState["kUnknown"] = 0] = "kUnknown";
    CameraState[CameraState["kTurnedOn"] = 1] = "kTurnedOn";
    CameraState[CameraState["kTurnedOff"] = 2] = "kTurnedOff";
})(CameraState || (CameraState = {}));
export class MediaSessionObserverPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'media_session.mojom.MediaSessionObserver', scope);
    }
}
export class MediaSessionObserverRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MediaSessionObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    mediaSessionInfoChanged(info) {
        this.proxy.sendMessage(0, MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$, null, [
            info
        ], false);
    }
    mediaSessionMetadataChanged(metadata) {
        this.proxy.sendMessage(1, MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$, null, [
            metadata
        ], false);
    }
    mediaSessionActionsChanged(action) {
        this.proxy.sendMessage(2, MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$, null, [
            action
        ], false);
    }
    mediaSessionImagesChanged(images) {
        this.proxy.sendMessage(3, MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$, null, [
            images
        ], false);
    }
    mediaSessionPositionChanged(position) {
        this.proxy.sendMessage(4, MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$, null, [
            position
        ], false);
    }
}
;
/**
 * An object which receives request messages for the MediaSessionObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaSessionObserverReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MediaSessionObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$, null, impl.mediaSessionInfoChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$, null, impl.mediaSessionMetadataChanged.bind(impl), false);
        this.helper_internal_.registerHandler(2, MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$, null, impl.mediaSessionActionsChanged.bind(impl), false);
        this.helper_internal_.registerHandler(3, MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$, null, impl.mediaSessionImagesChanged.bind(impl), false);
        this.helper_internal_.registerHandler(4, MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$, null, impl.mediaSessionPositionChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class MediaSessionObserver {
    static get $interfaceName() {
        return "media_session.mojom.MediaSessionObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new MediaSessionObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the MediaSessionObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaSessionObserverCallbackRouter {
    helper_internal_;
    $;
    router_;
    mediaSessionInfoChanged;
    mediaSessionMetadataChanged;
    mediaSessionActionsChanged;
    mediaSessionImagesChanged;
    mediaSessionPositionChanged;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MediaSessionObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.mediaSessionInfoChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$, null, this.mediaSessionInfoChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.mediaSessionMetadataChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$, null, this.mediaSessionMetadataChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.mediaSessionActionsChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$, null, this.mediaSessionActionsChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.mediaSessionImagesChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$, null, this.mediaSessionImagesChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.mediaSessionPositionChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$, null, this.mediaSessionPositionChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class MediaSessionPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'media_session.mojom.MediaSession', scope);
    }
}
export class MediaSessionRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MediaSessionPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getMediaSessionInfo() {
        return this.proxy.sendMessage(0, MediaSession_GetMediaSessionInfo_ParamsSpec.$, MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$, [], false);
    }
    getDebugInfo() {
        return this.proxy.sendMessage(1, MediaSession_GetDebugInfo_ParamsSpec.$, MediaSession_GetDebugInfo_ResponseParamsSpec.$, [], false);
    }
    startDucking() {
        this.proxy.sendMessage(2, MediaSession_StartDucking_ParamsSpec.$, null, [], false);
    }
    stopDucking() {
        this.proxy.sendMessage(3, MediaSession_StopDucking_ParamsSpec.$, null, [], false);
    }
    suspend(suspendType) {
        this.proxy.sendMessage(4, MediaSession_Suspend_ParamsSpec.$, null, [
            suspendType
        ], false);
    }
    resume(suspendType) {
        this.proxy.sendMessage(5, MediaSession_Resume_ParamsSpec.$, null, [
            suspendType
        ], false);
    }
    addObserver(observer) {
        this.proxy.sendMessage(6, MediaSession_AddObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    previousTrack() {
        this.proxy.sendMessage(7, MediaSession_PreviousTrack_ParamsSpec.$, null, [], false);
    }
    nextTrack() {
        this.proxy.sendMessage(8, MediaSession_NextTrack_ParamsSpec.$, null, [], false);
    }
    seek(seekTime) {
        this.proxy.sendMessage(9, MediaSession_Seek_ParamsSpec.$, null, [
            seekTime
        ], false);
    }
    stop(suspendType) {
        this.proxy.sendMessage(10, MediaSession_Stop_ParamsSpec.$, null, [
            suspendType
        ], false);
    }
    skipAd() {
        this.proxy.sendMessage(11, MediaSession_SkipAd_ParamsSpec.$, null, [], false);
    }
    getMediaImageBitmap(image, minimumSizePx, desiredSizePx) {
        return this.proxy.sendMessage(12, MediaSession_GetMediaImageBitmap_ParamsSpec.$, MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$, [
            image,
            minimumSizePx,
            desiredSizePx
        ], false);
    }
    seekTo(seekTime) {
        this.proxy.sendMessage(13, MediaSession_SeekTo_ParamsSpec.$, null, [
            seekTime
        ], false);
    }
    scrubTo(seekTime) {
        this.proxy.sendMessage(14, MediaSession_ScrubTo_ParamsSpec.$, null, [
            seekTime
        ], false);
    }
    enterPictureInPicture() {
        this.proxy.sendMessage(15, MediaSession_EnterPictureInPicture_ParamsSpec.$, null, [], false);
    }
    exitPictureInPicture() {
        this.proxy.sendMessage(16, MediaSession_ExitPictureInPicture_ParamsSpec.$, null, [], false);
    }
    setAudioSinkId(id) {
        this.proxy.sendMessage(17, MediaSession_SetAudioSinkId_ParamsSpec.$, null, [
            id
        ], false);
    }
    toggleMicrophone() {
        this.proxy.sendMessage(18, MediaSession_ToggleMicrophone_ParamsSpec.$, null, [], false);
    }
    toggleCamera() {
        this.proxy.sendMessage(19, MediaSession_ToggleCamera_ParamsSpec.$, null, [], false);
    }
    hangUp() {
        this.proxy.sendMessage(20, MediaSession_HangUp_ParamsSpec.$, null, [], false);
    }
    raise() {
        this.proxy.sendMessage(21, MediaSession_Raise_ParamsSpec.$, null, [], false);
    }
    setMute(mute) {
        this.proxy.sendMessage(22, MediaSession_SetMute_ParamsSpec.$, null, [
            mute
        ], false);
    }
    requestMediaRemoting() {
        this.proxy.sendMessage(23, MediaSession_RequestMediaRemoting_ParamsSpec.$, null, [], false);
    }
    previousSlide() {
        this.proxy.sendMessage(24, MediaSession_PreviousSlide_ParamsSpec.$, null, [], false);
    }
    nextSlide() {
        this.proxy.sendMessage(25, MediaSession_NextSlide_ParamsSpec.$, null, [], false);
    }
    enterAutoPictureInPicture() {
        this.proxy.sendMessage(26, MediaSession_EnterAutoPictureInPicture_ParamsSpec.$, null, [], false);
    }
    getVisibility() {
        return this.proxy.sendMessage(27, MediaSession_GetVisibility_ParamsSpec.$, MediaSession_GetVisibility_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the MediaSession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaSessionReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MediaSessionRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, MediaSession_GetMediaSessionInfo_ParamsSpec.$, MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$, impl.getMediaSessionInfo.bind(impl), false);
        this.helper_internal_.registerHandler(1, MediaSession_GetDebugInfo_ParamsSpec.$, MediaSession_GetDebugInfo_ResponseParamsSpec.$, impl.getDebugInfo.bind(impl), false);
        this.helper_internal_.registerHandler(2, MediaSession_StartDucking_ParamsSpec.$, null, impl.startDucking.bind(impl), false);
        this.helper_internal_.registerHandler(3, MediaSession_StopDucking_ParamsSpec.$, null, impl.stopDucking.bind(impl), false);
        this.helper_internal_.registerHandler(4, MediaSession_Suspend_ParamsSpec.$, null, impl.suspend.bind(impl), false);
        this.helper_internal_.registerHandler(5, MediaSession_Resume_ParamsSpec.$, null, impl.resume.bind(impl), false);
        this.helper_internal_.registerHandler(6, MediaSession_AddObserver_ParamsSpec.$, null, impl.addObserver.bind(impl), false);
        this.helper_internal_.registerHandler(7, MediaSession_PreviousTrack_ParamsSpec.$, null, impl.previousTrack.bind(impl), false);
        this.helper_internal_.registerHandler(8, MediaSession_NextTrack_ParamsSpec.$, null, impl.nextTrack.bind(impl), false);
        this.helper_internal_.registerHandler(9, MediaSession_Seek_ParamsSpec.$, null, impl.seek.bind(impl), false);
        this.helper_internal_.registerHandler(10, MediaSession_Stop_ParamsSpec.$, null, impl.stop.bind(impl), false);
        this.helper_internal_.registerHandler(11, MediaSession_SkipAd_ParamsSpec.$, null, impl.skipAd.bind(impl), false);
        this.helper_internal_.registerHandler(12, MediaSession_GetMediaImageBitmap_ParamsSpec.$, MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$, impl.getMediaImageBitmap.bind(impl), false);
        this.helper_internal_.registerHandler(13, MediaSession_SeekTo_ParamsSpec.$, null, impl.seekTo.bind(impl), false);
        this.helper_internal_.registerHandler(14, MediaSession_ScrubTo_ParamsSpec.$, null, impl.scrubTo.bind(impl), false);
        this.helper_internal_.registerHandler(15, MediaSession_EnterPictureInPicture_ParamsSpec.$, null, impl.enterPictureInPicture.bind(impl), false);
        this.helper_internal_.registerHandler(16, MediaSession_ExitPictureInPicture_ParamsSpec.$, null, impl.exitPictureInPicture.bind(impl), false);
        this.helper_internal_.registerHandler(17, MediaSession_SetAudioSinkId_ParamsSpec.$, null, impl.setAudioSinkId.bind(impl), false);
        this.helper_internal_.registerHandler(18, MediaSession_ToggleMicrophone_ParamsSpec.$, null, impl.toggleMicrophone.bind(impl), false);
        this.helper_internal_.registerHandler(19, MediaSession_ToggleCamera_ParamsSpec.$, null, impl.toggleCamera.bind(impl), false);
        this.helper_internal_.registerHandler(20, MediaSession_HangUp_ParamsSpec.$, null, impl.hangUp.bind(impl), false);
        this.helper_internal_.registerHandler(21, MediaSession_Raise_ParamsSpec.$, null, impl.raise.bind(impl), false);
        this.helper_internal_.registerHandler(22, MediaSession_SetMute_ParamsSpec.$, null, impl.setMute.bind(impl), false);
        this.helper_internal_.registerHandler(23, MediaSession_RequestMediaRemoting_ParamsSpec.$, null, impl.requestMediaRemoting.bind(impl), false);
        this.helper_internal_.registerHandler(24, MediaSession_PreviousSlide_ParamsSpec.$, null, impl.previousSlide.bind(impl), false);
        this.helper_internal_.registerHandler(25, MediaSession_NextSlide_ParamsSpec.$, null, impl.nextSlide.bind(impl), false);
        this.helper_internal_.registerHandler(26, MediaSession_EnterAutoPictureInPicture_ParamsSpec.$, null, impl.enterAutoPictureInPicture.bind(impl), false);
        this.helper_internal_.registerHandler(27, MediaSession_GetVisibility_ParamsSpec.$, MediaSession_GetVisibility_ResponseParamsSpec.$, impl.getVisibility.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class MediaSession {
    static get $interfaceName() {
        return "media_session.mojom.MediaSession";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new MediaSessionRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
export const MediaSession_SuspendTypeSpec = { $: mojo.internal.Enum() };
export var MediaSession_SuspendType;
(function (MediaSession_SuspendType) {
    MediaSession_SuspendType[MediaSession_SuspendType["MIN_VALUE"] = 0] = "MIN_VALUE";
    MediaSession_SuspendType[MediaSession_SuspendType["MAX_VALUE"] = 2] = "MAX_VALUE";
    MediaSession_SuspendType[MediaSession_SuspendType["kSystem"] = 0] = "kSystem";
    MediaSession_SuspendType[MediaSession_SuspendType["kUI"] = 1] = "kUI";
    MediaSession_SuspendType[MediaSession_SuspendType["kContent"] = 2] = "kContent";
})(MediaSession_SuspendType || (MediaSession_SuspendType = {}));
/**
 * An object which receives request messages for the MediaSession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaSessionCallbackRouter {
    helper_internal_;
    $;
    router_;
    getMediaSessionInfo;
    getDebugInfo;
    startDucking;
    stopDucking;
    suspend;
    resume;
    addObserver;
    previousTrack;
    nextTrack;
    seek;
    stop;
    skipAd;
    getMediaImageBitmap;
    seekTo;
    scrubTo;
    enterPictureInPicture;
    exitPictureInPicture;
    setAudioSinkId;
    toggleMicrophone;
    toggleCamera;
    hangUp;
    raise;
    setMute;
    requestMediaRemoting;
    previousSlide;
    nextSlide;
    enterAutoPictureInPicture;
    getVisibility;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MediaSessionRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getMediaSessionInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, MediaSession_GetMediaSessionInfo_ParamsSpec.$, MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$, this.getMediaSessionInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.getDebugInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, MediaSession_GetDebugInfo_ParamsSpec.$, MediaSession_GetDebugInfo_ResponseParamsSpec.$, this.getDebugInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.startDucking =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, MediaSession_StartDucking_ParamsSpec.$, null, this.startDucking.createReceiverHandler(false /* expectsResponse */), false);
        this.stopDucking =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, MediaSession_StopDucking_ParamsSpec.$, null, this.stopDucking.createReceiverHandler(false /* expectsResponse */), false);
        this.suspend =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, MediaSession_Suspend_ParamsSpec.$, null, this.suspend.createReceiverHandler(false /* expectsResponse */), false);
        this.resume =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, MediaSession_Resume_ParamsSpec.$, null, this.resume.createReceiverHandler(false /* expectsResponse */), false);
        this.addObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, MediaSession_AddObserver_ParamsSpec.$, null, this.addObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.previousTrack =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, MediaSession_PreviousTrack_ParamsSpec.$, null, this.previousTrack.createReceiverHandler(false /* expectsResponse */), false);
        this.nextTrack =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, MediaSession_NextTrack_ParamsSpec.$, null, this.nextTrack.createReceiverHandler(false /* expectsResponse */), false);
        this.seek =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, MediaSession_Seek_ParamsSpec.$, null, this.seek.createReceiverHandler(false /* expectsResponse */), false);
        this.stop =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, MediaSession_Stop_ParamsSpec.$, null, this.stop.createReceiverHandler(false /* expectsResponse */), false);
        this.skipAd =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, MediaSession_SkipAd_ParamsSpec.$, null, this.skipAd.createReceiverHandler(false /* expectsResponse */), false);
        this.getMediaImageBitmap =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, MediaSession_GetMediaImageBitmap_ParamsSpec.$, MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$, this.getMediaImageBitmap.createReceiverHandler(true /* expectsResponse */), false);
        this.seekTo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, MediaSession_SeekTo_ParamsSpec.$, null, this.seekTo.createReceiverHandler(false /* expectsResponse */), false);
        this.scrubTo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, MediaSession_ScrubTo_ParamsSpec.$, null, this.scrubTo.createReceiverHandler(false /* expectsResponse */), false);
        this.enterPictureInPicture =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, MediaSession_EnterPictureInPicture_ParamsSpec.$, null, this.enterPictureInPicture.createReceiverHandler(false /* expectsResponse */), false);
        this.exitPictureInPicture =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, MediaSession_ExitPictureInPicture_ParamsSpec.$, null, this.exitPictureInPicture.createReceiverHandler(false /* expectsResponse */), false);
        this.setAudioSinkId =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(17, MediaSession_SetAudioSinkId_ParamsSpec.$, null, this.setAudioSinkId.createReceiverHandler(false /* expectsResponse */), false);
        this.toggleMicrophone =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(18, MediaSession_ToggleMicrophone_ParamsSpec.$, null, this.toggleMicrophone.createReceiverHandler(false /* expectsResponse */), false);
        this.toggleCamera =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(19, MediaSession_ToggleCamera_ParamsSpec.$, null, this.toggleCamera.createReceiverHandler(false /* expectsResponse */), false);
        this.hangUp =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(20, MediaSession_HangUp_ParamsSpec.$, null, this.hangUp.createReceiverHandler(false /* expectsResponse */), false);
        this.raise =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(21, MediaSession_Raise_ParamsSpec.$, null, this.raise.createReceiverHandler(false /* expectsResponse */), false);
        this.setMute =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(22, MediaSession_SetMute_ParamsSpec.$, null, this.setMute.createReceiverHandler(false /* expectsResponse */), false);
        this.requestMediaRemoting =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(23, MediaSession_RequestMediaRemoting_ParamsSpec.$, null, this.requestMediaRemoting.createReceiverHandler(false /* expectsResponse */), false);
        this.previousSlide =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(24, MediaSession_PreviousSlide_ParamsSpec.$, null, this.previousSlide.createReceiverHandler(false /* expectsResponse */), false);
        this.nextSlide =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(25, MediaSession_NextSlide_ParamsSpec.$, null, this.nextSlide.createReceiverHandler(false /* expectsResponse */), false);
        this.enterAutoPictureInPicture =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(26, MediaSession_EnterAutoPictureInPicture_ParamsSpec.$, null, this.enterAutoPictureInPicture.createReceiverHandler(false /* expectsResponse */), false);
        this.getVisibility =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(27, MediaSession_GetVisibility_ParamsSpec.$, MediaSession_GetVisibility_ResponseParamsSpec.$, this.getVisibility.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const MediaImageSpec = { $: {} };
export const ChapterInformationSpec = { $: {} };
export const MediaMetadataSpec = { $: {} };
export const MediaImageBitmapSpec = { $: {} };
export const MediaPositionSpec = { $: {} };
export const RemotePlaybackMetadataSpec = { $: {} };
export const MediaSessionInfoSpec = { $: {} };
export const MediaSessionDebugInfoSpec = { $: {} };
export const MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec = { $: {} };
export const MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec = { $: {} };
export const MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec = { $: {} };
export const MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec = { $: {} };
export const MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec = { $: {} };
export const MediaSession_GetMediaSessionInfo_ParamsSpec = { $: {} };
export const MediaSession_GetMediaSessionInfo_ResponseParamsSpec = { $: {} };
export const MediaSession_GetDebugInfo_ParamsSpec = { $: {} };
export const MediaSession_GetDebugInfo_ResponseParamsSpec = { $: {} };
export const MediaSession_StartDucking_ParamsSpec = { $: {} };
export const MediaSession_StopDucking_ParamsSpec = { $: {} };
export const MediaSession_Suspend_ParamsSpec = { $: {} };
export const MediaSession_Resume_ParamsSpec = { $: {} };
export const MediaSession_AddObserver_ParamsSpec = { $: {} };
export const MediaSession_PreviousTrack_ParamsSpec = { $: {} };
export const MediaSession_NextTrack_ParamsSpec = { $: {} };
export const MediaSession_Seek_ParamsSpec = { $: {} };
export const MediaSession_Stop_ParamsSpec = { $: {} };
export const MediaSession_SkipAd_ParamsSpec = { $: {} };
export const MediaSession_GetMediaImageBitmap_ParamsSpec = { $: {} };
export const MediaSession_GetMediaImageBitmap_ResponseParamsSpec = { $: {} };
export const MediaSession_SeekTo_ParamsSpec = { $: {} };
export const MediaSession_ScrubTo_ParamsSpec = { $: {} };
export const MediaSession_EnterPictureInPicture_ParamsSpec = { $: {} };
export const MediaSession_ExitPictureInPicture_ParamsSpec = { $: {} };
export const MediaSession_SetAudioSinkId_ParamsSpec = { $: {} };
export const MediaSession_ToggleMicrophone_ParamsSpec = { $: {} };
export const MediaSession_ToggleCamera_ParamsSpec = { $: {} };
export const MediaSession_HangUp_ParamsSpec = { $: {} };
export const MediaSession_Raise_ParamsSpec = { $: {} };
export const MediaSession_SetMute_ParamsSpec = { $: {} };
export const MediaSession_RequestMediaRemoting_ParamsSpec = { $: {} };
export const MediaSession_PreviousSlide_ParamsSpec = { $: {} };
export const MediaSession_NextSlide_ParamsSpec = { $: {} };
export const MediaSession_EnterAutoPictureInPicture_ParamsSpec = { $: {} };
export const MediaSession_GetVisibility_ParamsSpec = { $: {} };
export const MediaSession_GetVisibility_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(MediaImageSpec.$, 'MediaImage', [
    mojo.internal.StructField('src', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 8, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sizes', 16, 0, mojo.internal.Array(gfx_mojom_SizeSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(ChapterInformationSpec.$, 'ChapterInformation', [
    mojo.internal.StructField('title', 0, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('startTime', 8, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('artwork', 16, 0, mojo.internal.Array(MediaImageSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(MediaMetadataSpec.$, 'MediaMetadata', [
    mojo.internal.StructField('title', 0, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('artist', 8, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('album', 16, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sourceTitle', 24, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('chapters', 32, 0, mojo.internal.Array(ChapterInformationSpec.$, false), null, true /* nullable */, 21, undefined, undefined),
], [[0, 40], [21, 48],]);
mojo.internal.Struct(MediaImageBitmapSpec.$, 'MediaImageBitmap', [
    mojo.internal.StructField('width', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('height', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pixelData', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('colorType', 16, 0, MediaImageBitmapColorTypeSpec.$, 0, false /* nullable */, 5, undefined, undefined),
], [[0, 24], [5, 32],]);
mojo.internal.Struct(MediaPositionSpec.$, 'MediaPosition', [
    mojo.internal.StructField('playbackRate', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('duration', 8, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('position', 16, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('lastUpdatedTime', 24, 0, mojoBase_mojom_TimeTicksSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('endOfMedia', 32, 0, mojo.internal.Bool, false, false /* nullable */, 13, undefined, undefined),
], [[0, 40], [13, 48],]);
mojo.internal.Struct(RemotePlaybackMetadataSpec.$, 'RemotePlaybackMetadata', [
    mojo.internal.StructField('videoCodec', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('audioCodec', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('remotePlaybackDisabled', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('remotePlaybackStarted', 16, 1, mojo.internal.Bool, false, false /* nullable */, 17, undefined, undefined),
    mojo.internal.StructField('unusedField', 24, 0, mojo.internal.String, null, true /* nullable */, 17, undefined, undefined),
    mojo.internal.StructField('isEncryptedMedia', 16, 2, mojo.internal.Bool, false, false /* nullable */, 18, undefined, undefined),
], [[0, 32], [17, 40], [18, 40],]);
export const MediaSessionInfo_SessionStateSpec = { $: mojo.internal.Enum() };
export var MediaSessionInfo_SessionState;
(function (MediaSessionInfo_SessionState) {
    MediaSessionInfo_SessionState[MediaSessionInfo_SessionState["MIN_VALUE"] = 0] = "MIN_VALUE";
    MediaSessionInfo_SessionState[MediaSessionInfo_SessionState["MAX_VALUE"] = 3] = "MAX_VALUE";
    MediaSessionInfo_SessionState[MediaSessionInfo_SessionState["kActive"] = 0] = "kActive";
    MediaSessionInfo_SessionState[MediaSessionInfo_SessionState["kDucking"] = 1] = "kDucking";
    MediaSessionInfo_SessionState[MediaSessionInfo_SessionState["kSuspended"] = 2] = "kSuspended";
    MediaSessionInfo_SessionState[MediaSessionInfo_SessionState["kInactive"] = 3] = "kInactive";
})(MediaSessionInfo_SessionState || (MediaSessionInfo_SessionState = {}));
mojo.internal.Struct(MediaSessionInfoSpec.$, 'MediaSessionInfo', [
    mojo.internal.StructField('state', 0, 0, MediaSessionInfo_SessionStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('forceDuck', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('playbackState', 8, 0, MediaPlaybackStateSpec.$, 0, false /* nullable */, 1, undefined, undefined),
    mojo.internal.StructField('isControllable', 4, 1, mojo.internal.Bool, false, false /* nullable */, 2, undefined, undefined),
    mojo.internal.StructField('preferStopForGainFocusLoss', 4, 2, mojo.internal.Bool, false, false /* nullable */, 4, undefined, undefined),
    mojo.internal.StructField('deprecatedIsSensitive', 4, 3, mojo.internal.Bool, false, false /* nullable */, 6, undefined, undefined),
    mojo.internal.StructField('pictureInPictureState', 12, 0, MediaPictureInPictureStateSpec.$, 0, false /* nullable */, 7, undefined, undefined),
    mojo.internal.StructField('deprecatedAudioVideoState', 16, 0, MediaAudioVideoStateSpec.$, 0, false /* nullable */, 8, undefined, undefined),
    mojo.internal.StructField('audioSinkId', 24, 0, mojo.internal.String, null, true /* nullable */, 9, undefined, undefined),
    mojo.internal.StructField('audioVideoStates', 32, 0, mojo.internal.Array(MediaAudioVideoStateSpec.$, false), null, true /* nullable */, 10, undefined, undefined),
    mojo.internal.StructField('microphoneState', 20, 0, MicrophoneStateSpec.$, 0, false /* nullable */, 11, undefined, undefined),
    mojo.internal.StructField('cameraState', 40, 0, CameraStateSpec.$, 0, false /* nullable */, 11, undefined, undefined),
    mojo.internal.StructField('muted', 4, 4, mojo.internal.Bool, false, false /* nullable */, 12, undefined, undefined),
    mojo.internal.StructField('hasPresentation', 4, 5, mojo.internal.Bool, false, false /* nullable */, 14, undefined, undefined),
    mojo.internal.StructField('remotePlaybackMetadata', 48, 0, RemotePlaybackMetadataSpec.$, null, true /* nullable */, 15, undefined, undefined),
    mojo.internal.StructField('hideMetadata', 4, 6, mojo.internal.Bool, false, false /* nullable */, 16, undefined, undefined),
    mojo.internal.StructField('ignoreForActiveSession', 4, 7, mojo.internal.Bool, false, false /* nullable */, 20, undefined, undefined),
    mojo.internal.StructField('meetsVisibilityThreshold', 5, 0, mojo.internal.Bool, false, false /* nullable */, 21, undefined, undefined),
    mojo.internal.StructField('canEnterBrowserInitiatedAutopip', 5, 1, mojo.internal.Bool, false, false /* nullable */, 24, undefined, undefined),
], [[0, 16], [1, 24], [2, 24], [4, 24], [6, 24], [7, 24], [8, 32], [9, 40], [10, 48], [11, 56], [12, 56], [14, 56], [15, 64], [16, 64], [20, 64], [21, 64], [24, 64],]);
mojo.internal.Struct(MediaSessionDebugInfoSpec.$, 'MediaSessionDebugInfo', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('owner', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('state', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$, 'MediaSessionObserver_MediaSessionInfoChanged_Params', [
    mojo.internal.StructField('info', 0, 0, MediaSessionInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$, 'MediaSessionObserver_MediaSessionMetadataChanged_Params', [
    mojo.internal.StructField('metadata', 0, 0, MediaMetadataSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$, 'MediaSessionObserver_MediaSessionActionsChanged_Params', [
    mojo.internal.StructField('action', 0, 0, mojo.internal.Array(MediaSessionActionSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$, 'MediaSessionObserver_MediaSessionImagesChanged_Params', [
    mojo.internal.StructField('images', 0, 0, mojo.internal.Map(MediaSessionImageTypeSpec.$, mojo.internal.Array(MediaImageSpec.$, false), false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$, 'MediaSessionObserver_MediaSessionPositionChanged_Params', [
    mojo.internal.StructField('position', 0, 0, MediaPositionSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSession_GetMediaSessionInfo_ParamsSpec.$, 'MediaSession_GetMediaSessionInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$, 'MediaSession_GetMediaSessionInfo_ResponseParams', [
    mojo.internal.StructField('info', 0, 0, MediaSessionInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSession_GetDebugInfo_ParamsSpec.$, 'MediaSession_GetDebugInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_GetDebugInfo_ResponseParamsSpec.$, 'MediaSession_GetDebugInfo_ResponseParams', [
    mojo.internal.StructField('info', 0, 0, MediaSessionDebugInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSession_StartDucking_ParamsSpec.$, 'MediaSession_StartDucking_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_StopDucking_ParamsSpec.$, 'MediaSession_StopDucking_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_Suspend_ParamsSpec.$, 'MediaSession_Suspend_Params', [
    mojo.internal.StructField('suspendType', 0, 0, MediaSession_SuspendTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSession_Resume_ParamsSpec.$, 'MediaSession_Resume_Params', [
    mojo.internal.StructField('suspendType', 0, 0, MediaSession_SuspendTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSession_AddObserver_ParamsSpec.$, 'MediaSession_AddObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(MediaSessionObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSession_PreviousTrack_ParamsSpec.$, 'MediaSession_PreviousTrack_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_NextTrack_ParamsSpec.$, 'MediaSession_NextTrack_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_Seek_ParamsSpec.$, 'MediaSession_Seek_Params', [
    mojo.internal.StructField('seekTime', 0, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSession_Stop_ParamsSpec.$, 'MediaSession_Stop_Params', [
    mojo.internal.StructField('suspendType', 0, 0, MediaSession_SuspendTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSession_SkipAd_ParamsSpec.$, 'MediaSession_SkipAd_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_GetMediaImageBitmap_ParamsSpec.$, 'MediaSession_GetMediaImageBitmap_Params', [
    mojo.internal.StructField('image', 0, 0, MediaImageSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('minimumSizePx', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('desiredSizePx', 12, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$, 'MediaSession_GetMediaImageBitmap_ResponseParams', [
    mojo.internal.StructField('image', 0, 0, MediaImageBitmapSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSession_SeekTo_ParamsSpec.$, 'MediaSession_SeekTo_Params', [
    mojo.internal.StructField('seekTime', 0, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSession_ScrubTo_ParamsSpec.$, 'MediaSession_ScrubTo_Params', [
    mojo.internal.StructField('seekTime', 0, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSession_EnterPictureInPicture_ParamsSpec.$, 'MediaSession_EnterPictureInPicture_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_ExitPictureInPicture_ParamsSpec.$, 'MediaSession_ExitPictureInPicture_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_SetAudioSinkId_ParamsSpec.$, 'MediaSession_SetAudioSinkId_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSession_ToggleMicrophone_ParamsSpec.$, 'MediaSession_ToggleMicrophone_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_ToggleCamera_ParamsSpec.$, 'MediaSession_ToggleCamera_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_HangUp_ParamsSpec.$, 'MediaSession_HangUp_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_Raise_ParamsSpec.$, 'MediaSession_Raise_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_SetMute_ParamsSpec.$, 'MediaSession_SetMute_Params', [
    mojo.internal.StructField('mute', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MediaSession_RequestMediaRemoting_ParamsSpec.$, 'MediaSession_RequestMediaRemoting_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_PreviousSlide_ParamsSpec.$, 'MediaSession_PreviousSlide_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_NextSlide_ParamsSpec.$, 'MediaSession_NextSlide_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_EnterAutoPictureInPicture_ParamsSpec.$, 'MediaSession_EnterAutoPictureInPicture_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_GetVisibility_ParamsSpec.$, 'MediaSession_GetVisibility_Params', [], [[0, 8],]);
mojo.internal.Struct(MediaSession_GetVisibility_ResponseParamsSpec.$, 'MediaSession_GetVisibility_ResponseParams', [
    mojo.internal.StructField('hasSufficientlyVisibleVideo', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
