// chrome/browser/media/media_engagement_score_details.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  OriginSpec as url_mojom_OriginSpec,
  Origin as url_mojom_Origin
} from '//resources/mojo/url/mojom/origin.mojom-webui.js';







export type MediaEngagementScoreDetailsProviderPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<MediaEngagementScoreDetailsProviderPendingReceiver>;

export class MediaEngagementScoreDetailsProviderPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<MediaEngagementScoreDetailsProvider> {

  handle: mojo.internal.interfaceSupport.Endpoint<MediaEngagementScoreDetailsProviderPendingReceiver>;
  constructor(handle: MojoHandle|MediaEngagementScoreDetailsProviderPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'media.mojom.MediaEngagementScoreDetailsProvider',
        scope);
  }
}

export interface MediaEngagementScoreDetailsProviderInterface {
  getMediaEngagementScoreDetails(): Promise<{
        info: MediaEngagementScoreDetails[], }>;
  getMediaEngagementConfig(): Promise<{
        config: MediaEngagementConfig, }>;
}

export class MediaEngagementScoreDetailsProviderRemote implements MediaEngagementScoreDetailsProviderInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<MediaEngagementScoreDetailsProviderPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<MediaEngagementScoreDetailsProviderPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|MediaEngagementScoreDetailsProviderPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaEngagementScoreDetailsProviderPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getMediaEngagementScoreDetails(): Promise<{
        info: MediaEngagementScoreDetails[], }> {
    return this.proxy.sendMessage(
        0,
        MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ParamsSpec.$,
        MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getMediaEngagementConfig(): Promise<{
        config: MediaEngagementConfig, }> {
    return this.proxy.sendMessage(
        1,
        MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ParamsSpec.$,
        MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaEngagementScoreDetailsProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaEngagementScoreDetailsProviderReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MediaEngagementScoreDetailsProviderRemote, MediaEngagementScoreDetailsProviderPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MediaEngagementScoreDetailsProviderRemote, MediaEngagementScoreDetailsProviderPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: MediaEngagementScoreDetailsProviderInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaEngagementScoreDetailsProviderRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ParamsSpec.$,
        MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParamsSpec.$,
        impl.getMediaEngagementScoreDetails.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ParamsSpec.$,
        MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParamsSpec.$,
        impl.getMediaEngagementConfig.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaEngagementScoreDetailsProvider {
  static get $interfaceName(): string {
    return "media.mojom.MediaEngagementScoreDetailsProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): MediaEngagementScoreDetailsProviderRemote {
    let remote = new MediaEngagementScoreDetailsProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the MediaEngagementScoreDetailsProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaEngagementScoreDetailsProviderCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MediaEngagementScoreDetailsProviderRemote, MediaEngagementScoreDetailsProviderPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MediaEngagementScoreDetailsProviderRemote, MediaEngagementScoreDetailsProviderPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getMediaEngagementScoreDetails: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getMediaEngagementConfig: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaEngagementScoreDetailsProviderRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getMediaEngagementScoreDetails =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ParamsSpec.$,
        MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParamsSpec.$,
        this.getMediaEngagementScoreDetails.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getMediaEngagementConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ParamsSpec.$,
        MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParamsSpec.$,
        this.getMediaEngagementConfig.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const MediaEngagementScoreDetailsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaEngagementConfigSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface MediaEngagementScoreDetailsMojoType {
  origin: url_mojom_Origin;
  totalScore: number;
  visits: number;
  mediaPlaybacks: number;
  lastMediaPlaybackTime: number;
  isHigh: boolean;
}


export type MediaEngagementScoreDetails = MediaEngagementScoreDetailsMojoType;
mojo.internal.Struct<MediaEngagementScoreDetailsMojoType>(
    MediaEngagementScoreDetailsSpec.$,
    'MediaEngagementScoreDetails',
    [
      mojo.internal.StructField<MediaEngagementScoreDetailsMojoType, url_mojom_Origin>(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementScoreDetailsMojoType, number>(
        'totalScore', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementScoreDetailsMojoType, number>(
        'visits', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementScoreDetailsMojoType, number>(
        'mediaPlaybacks', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementScoreDetailsMojoType, number>(
        'lastMediaPlaybackTime', 24,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementScoreDetailsMojoType, boolean>(
        'isHigh', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface MediaEngagementConfigMojoType {
  scoreMinVisits: number;
  featureRecordData: boolean;
  featureBypassAutoplay: boolean;
  featurePreloadData: boolean;
  featureHttpsOnly: boolean;
  featureAutoplayDisableSettings: boolean;
  prefDisableUnifiedAutoplay: boolean;
  hasCustomAutoplayPolicy: boolean;
  highScoreLowerThreshold: number;
  highScoreUpperThreshold: number;
  autoplayPolicy: string;
  preloadVersion: string;
}


export type MediaEngagementConfig = MediaEngagementConfigMojoType;
mojo.internal.Struct<MediaEngagementConfigMojoType>(
    MediaEngagementConfigSpec.$,
    'MediaEngagementConfig',
    [
      mojo.internal.StructField<MediaEngagementConfigMojoType, number>(
        'scoreMinVisits', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementConfigMojoType, number>(
        'highScoreLowerThreshold', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementConfigMojoType, number>(
        'highScoreUpperThreshold', 16,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementConfigMojoType, boolean>(
        'featureRecordData', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementConfigMojoType, boolean>(
        'featureBypassAutoplay', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementConfigMojoType, boolean>(
        'featurePreloadData', 4,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementConfigMojoType, boolean>(
        'featureHttpsOnly', 4,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementConfigMojoType, boolean>(
        'featureAutoplayDisableSettings', 4,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementConfigMojoType, boolean>(
        'prefDisableUnifiedAutoplay', 4,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementConfigMojoType, boolean>(
        'hasCustomAutoplayPolicy', 4,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementConfigMojoType, string>(
        'autoplayPolicy', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaEngagementConfigMojoType, string>(
        'preloadVersion', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ParamsMojoType {
}


export type MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_Params = MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ParamsMojoType;
mojo.internal.Struct<MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ParamsMojoType>(
    MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ParamsSpec.$,
    'MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_Params',
    [
    ],
    [[0, 8],]);





export interface MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParamsMojoType {
  info: MediaEngagementScoreDetails[];
}


export type MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParams = MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParamsMojoType;
mojo.internal.Struct<MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParamsMojoType>(
    MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParamsSpec.$,
    'MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParams',
    [
      mojo.internal.StructField<MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParamsMojoType, MediaEngagementScoreDetails[]>(
        'info', 0,
        0,
        mojo.internal.Array(MediaEngagementScoreDetailsSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ParamsMojoType {
}


export type MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_Params = MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ParamsMojoType;
mojo.internal.Struct<MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ParamsMojoType>(
    MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ParamsSpec.$,
    'MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_Params',
    [
    ],
    [[0, 8],]);





export interface MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParamsMojoType {
  config: MediaEngagementConfig;
}


export type MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParams = MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParamsMojoType;
mojo.internal.Struct<MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParamsMojoType>(
    MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParamsSpec.$,
    'MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParams',
    [
      mojo.internal.StructField<MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParamsMojoType, MediaEngagementConfig>(
        'config', 0,
        0,
        MediaEngagementConfigSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



