import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getFallbackTheme } from './color_utils.js';
import { type GestureEvent } from './selection_utils.js';
export interface RegionSelectionElement {
    $: {
        highlightImgCanvas: HTMLCanvasElement;
        keyboardSelection: HTMLDivElement;
        regionSelectionCanvas: HTMLCanvasElement;
    };
}
declare const RegionSelectionElementBase: typeof PolymerElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class RegionSelectionElement extends RegionSelectionElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        borderGlowEnabled: {
            reflectToAttribute: boolean;
            type: BooleanConstructor;
            value: boolean;
        };
        canvasHeight: NumberConstructor;
        canvasWidth: NumberConstructor;
        canvasPhysicalHeight: NumberConstructor;
        canvasPhysicalWidth: NumberConstructor;
        displayKeyboardSelection: {
            type: BooleanConstructor;
            value: () => boolean;
            reflectToAttribute: boolean;
        };
        hasSelected: {
            reflectToAttribute: boolean;
            type: BooleanConstructor;
            value: boolean;
        };
        isSelecting: {
            reflectToAttribute: boolean;
            type: BooleanConstructor;
            value: boolean;
        };
        screenshotDataUri: StringConstructor;
        shaderLayerColorHexes: {
            type: ArrayConstructor;
            computed: string;
        };
        theme: {
            type: ObjectConstructor;
            value: typeof getFallbackTheme;
        };
        selectionOverlayRect: ObjectConstructor;
    };
    private eventTracker_;
    private borderGlowEnabled;
    private canvasHeight;
    private canvasWidth;
    private canvasPhysicalHeight;
    private canvasPhysicalWidth;
    private hasSelected;
    private isSelecting;
    private context;
    private screenshotDataUri;
    private shaderLayerColorHexes;
    private theme;
    private selectionOverlayRect;
    private displayKeyboardSelection;
    private browserProxy;
    private readonly gradientRegionStrokeEnabled;
    private readonly whiteRegionStrokeEnabled;
    private readonly tapRegionHeight;
    private readonly tapRegionWidth;
    private readonly enableKeyboardSelection;
    ready(): void;
    connectedCallback(): void;
    disconnectedCallback(): void;
    private computeShaderLayerColorHexes_;
    handleGestureStart(): void;
    handleGestureDrag(event: GestureEvent): void;
    handleGestureEnd(event: GestureEvent): boolean;
    private onKeyboardSelection;
    private issueRequest;
    handlePostSelectionDragGestureEnd(): void;
    handlePostSelectionCleared(): void;
    cancelGesture(): void;
    setCanvasSizeTo(width: number, height: number): void;
    private clearCanvas;
    private renderBoundingBox;
    private getNormalizedCenterRotatedBoxFromGesture;
    private getNormalizedCenterRotatedBoxFromTap;
    /**
     * @returns a mojo CenterRotatedBox corresponding to the gesture provided,
     * normalized to the selection overlay dimensions. The gesture is
     * expected to be a drag.
     */
    private getNormalizedCenterRotatedBoxFromDrag;
    private getPostSelectionRegion;
    private getPostSelectionRegionFromTap;
    private getPostSelectionRegionFromDrag;
    private getNormalizedRectangleFromTap;
}
declare global {
    interface HTMLElementTagNameMap {
        'region-selection': RegionSelectionElement;
    }
}
export {};
