import type { SkColor } from '//resources/mojo/skia/public/mojom/skcolor.mojom-webui.js';
import type { OverlayTheme } from './lens.mojom-webui.js';
export declare function getFallbackTheme(): OverlayTheme;
/**
 * Converts an SkColor object to a string in the form
 * "rgba(<red>, <green>, <blue>, <alpha>)", with a custom
 * alpha value.
 * @param skColor The input color.
 * @return The rgba string.
 */
export declare function skColorToRgbaWithCustomAlpha(skColor: SkColor, alpha: number): string;
export declare function getShaderLayerColorHexes(theme: OverlayTheme): string[];
export declare function getShaderLayerColorRgbas(theme: OverlayTheme): string[];
export interface GlifColorHexObject {
    blue: string;
    red: string;
    yellow: string;
    green: string;
}
export declare const GLIF_HEX_COLORS: GlifColorHexObject;
export declare function modifyRgbaTransparency(rgba: string, alpha: number): string;
