// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{assert}from"//resources/js/assert.js";import{skColorToHexColor,skColorToRgba}from"//resources/js/color_utils.js";import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{afterNextRender,PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{CursorTooltipType}from"./cursor_tooltip.js";import{findWordsInRegion}from"./find_words_in_region.js";import{CenterRotatedBox_CoordinateType}from"./geometry.mojom-webui.js";import{bestHit}from"./hit.js";import{SemanticEvent,UserAction}from"./lens.mojom-webui.js";import{INVOCATION_SOURCE}from"./lens_overlay_app.js";import{recordLensOverlayInteraction,recordLensOverlaySemanticEvent}from"./metrics_utils.js";import{CursorType}from"./selection_utils.js";import{Alignment,WritingDirection}from"./text.mojom-webui.js";import{getTemplate}from"./text_layer.html.js";import{getTextSeparator,isWordRenderable,translateWords}from"./text_rendering.js";import{toPercent}from"./values_converter.js";const MIN_FONT_SIZE=3;const MAX_FONT_SIZE=150;const RTL_LANGUAGES=new Set(["ar","bal","bm-Nkoo","ckb","dv","fa","fa-AF","he","iw","ji","ms-Arab","ks","pa-Arab","ps","sd","ug","ur","yi"]);function isRtlLanguage(languageCode){return RTL_LANGUAGES.has(languageCode)}function rotateCoordinateAroundOrigin(pointToRotate,angle){const newX=pointToRotate.x*Math.cos(-angle)-pointToRotate.y*Math.sin(-angle);const newY=pointToRotate.y*Math.cos(-angle)+pointToRotate.x*Math.sin(-angle);return{x:newX,y:newY}}function isInRange(index,start,end){return index>=start&&index<=end||index>=end&&index<=start}export class TextLayerElement extends PolymerElement{static get is(){return"lens-text-layer"}static get template(){return getTemplate()}static get properties(){return{currentTranslateLanguage:String,renderedWords:{type:Array,value:()=>[]},shouldRenderTranslateWords:{type:Boolean,reflectToAttribute:true},highlightedLines:Array,renderedTranslateLines:Array,selectionStartIndex:{type:Number,value:-1},selectionEndIndex:{type:Number,value:-1},isSelectingText:{type:Boolean,value:false,reflectToAttribute:true},debugMode:{type:Boolean,value:loadTimeData.getBoolean("enableDebuggingMode"),reflectToAttribute:true},selectionOverlayRect:{type:Object,observer:"handleSelectionOverlayRectResize"}}}context;renderedTranslateWords;renderedTranslateParagraphs;detectedWordToTranslateIndex;lineNumbers;paragraphNumbers;translatedLineNumbers;translatedParagraphNumbers;lines;paragraphs;contentLanguage;eventTracker_=new EventTracker;listenerIds;selectTextTriggerThreshold=loadTimeData.getValue("selectTextTriggerThreshold");textReceivedTimeout=loadTimeData.getValue("textReceivedTimeout");textReceivedTimeoutID=0;textReceivedTimeoutElapsedOrCleared=false;browserProxy=BrowserProxyImpl.getInstance();ready(){super.ready();this.context=this.$.textRenderCanvas.getContext("2d")}connectedCallback(){super.connectedCallback();this.eventTracker_.add(document,"detect-text-in-region",(e=>{this.detectTextInRegion(e.detail)}));this.eventTracker_.add(document,"translate-mode-state-changed",(e=>{this.shouldRenderTranslateWords=e.detail.translateModeEnabled;this.currentTranslateLanguage=e.detail.targetLanguage;if(e.detail.shouldUnselectWords){this.unselectWords()}}));this.listenerIds=[this.browserProxy.callbackRouter.textReceived.addListener(this.onTextReceived.bind(this)),this.browserProxy.callbackRouter.clearTextSelection.addListener(this.unselectWords.bind(this)),this.browserProxy.callbackRouter.clearAllSelections.addListener(this.unselectWords.bind(this)),this.browserProxy.callbackRouter.setTextSelection.addListener(this.selectWords.bind(this))];this.textReceivedTimeoutID=setTimeout((()=>{this.textReceivedTimeoutElapsedOrCleared=true}),this.textReceivedTimeout)}disconnectedCallback(){super.disconnectedCallback();if(this.renderedWords?.length>0){recordLensOverlaySemanticEvent(SemanticEvent.kTextGleamsViewEnd)}this.listenerIds.forEach((id=>assert(this.browserProxy.callbackRouter.removeListener(id))));this.listenerIds=[];this.eventTracker_.removeAll()}handlePointerEnter(){this.dispatchEvent(new CustomEvent("set-cursor",{bubbles:true,composed:true,detail:{cursor:CursorType.TEXT}}));this.dispatchEvent(new CustomEvent("set-cursor-tooltip",{bubbles:true,composed:true,detail:{tooltipType:CursorTooltipType.TEXT_HIGHLIGHT}}))}handlePointerLeave(){if(this.shouldRenderTranslateWords){return}this.dispatchEvent(new CustomEvent("set-cursor",{bubbles:true,composed:true,detail:{cursor:CursorType.DEFAULT}}));this.dispatchEvent(new CustomEvent("set-cursor-tooltip",{bubbles:true,composed:true,detail:{tooltipType:CursorTooltipType.REGION_SEARCH}}))}detectTextInRegion(box){if(!this.textReceivedTimeoutElapsedOrCleared){this.dispatchEvent(new CustomEvent("hide-selected-region-context-menu",{bubbles:true,composed:true}));return}const selection=findWordsInRegion(this.renderedWords,box,this.selectionOverlayRect);if(selection.iou<this.selectTextTriggerThreshold){this.dispatchEvent(new CustomEvent("show-selected-region-context-menu",{bubbles:true,composed:true,detail:{box:box,selectionStartIndex:-1,selectionEndIndex:-1}}));return}this.dispatchEvent(new CustomEvent("show-selected-region-context-menu",{bubbles:true,composed:true,detail:{box:box,selectionStartIndex:selection.startIndex,selectionEndIndex:selection.endIndex}}))}handleGestureStart(event){this.unselectWords();const translatedWordIndex=this.translatedWordIndexFromPoint(event.startX,event.startY);let wordIndex=translatedWordIndex!==null?translatedWordIndex:this.wordIndexFromPoint(event.startX,event.startY);if(wordIndex===null&&this.shouldRenderTranslateWords){const imageBounds=this.selectionOverlayRect;const normalizedX=(event.startX-imageBounds.left)/imageBounds.width;const normalizedY=(event.startY-imageBounds.top)/imageBounds.height;const hit=bestHit(this.renderedTranslateWords,{x:normalizedX,y:normalizedY});if(hit){wordIndex=this.renderedTranslateWords.indexOf(hit)}}if(wordIndex===null){return false}this.selectWords(wordIndex,wordIndex);this.isSelectingText=true;return true}handleRightClick(event){const translatedWordIndex=this.translatedWordIndexFromPoint(event.clientX,event.clientY);const wordIndex=translatedWordIndex!==null?translatedWordIndex:this.wordIndexFromPoint(event.clientX,event.clientY);if(wordIndex!==null&&isInRange(wordIndex,this.selectionStartIndex,this.selectionEndIndex)){this.dispatchEvent(new CustomEvent("restore-selected-text-context-menu",{bubbles:true,composed:true}));return true}return false}handleGestureDrag(event){const imageBounds=this.selectionOverlayRect;const normalizedX=(event.clientX-imageBounds.left)/imageBounds.width;const normalizedY=(event.clientY-imageBounds.top)/imageBounds.height;const words=this.shouldRenderTranslateWords?this.renderedTranslateWords:this.renderedWords;const hit=bestHit(words,{x:normalizedX,y:normalizedY});if(!hit){return}let startIndex=this.selectionStartIndex;if(startIndex===undefined){startIndex=words.indexOf(hit)}this.selectWords(startIndex,words.indexOf(hit))}handleGestureEnd(){this.sendSelectedText()}handleSelectionOverlayRectResize(){if(!this.shouldRenderTranslateWords){return}this.computeTranslatedWordBoundingBoxes();this.selectWords(this.selectionStartIndex,this.selectionEndIndex)}computeTranslatedWordBoundingBoxes(){if(!this.shouldRenderTranslateWords||!(this.renderedTranslateLines?.length>0)||!(this.renderedTranslateWords?.length>0)){return}const wordSpanElements=this.shadowRoot.querySelectorAll("span[data-word-index]");for(const wordSpanElement of wordSpanElements){const wordIndexString=wordSpanElement.dataset["wordIndex"];const lineIndexString=wordSpanElement.dataset["lineIndex"];assert(wordIndexString);assert(lineIndexString);const wordIndex=parseInt(wordIndexString)??-1;const lineIndex=parseInt(lineIndexString)??-1;assert(wordIndex>=0);assert(lineIndex>=0);const word=this.renderedTranslateWords[wordIndex];const translatedLine=this.renderedTranslateLines[lineIndex];const boundingRect=wordSpanElement.getBoundingClientRect();const centerX=boundingRect.left-this.selectionOverlayRect.left+boundingRect.width/2;const centerY=boundingRect.top-this.selectionOverlayRect.top+boundingRect.height/2;const normalizedCenterX=centerX/this.selectionOverlayRect.width;const normalizedCenterY=centerY/this.selectionOverlayRect.height;const normalizedWidth=wordSpanElement.offsetWidth/this.selectionOverlayRect.width;const normalizedHeight=wordSpanElement.offsetHeight/this.selectionOverlayRect.height;assert(translatedLine.line.geometry);const rotation=translatedLine.line.geometry.boundingBox.rotation;const rect={x:normalizedCenterX,y:normalizedCenterY,width:normalizedWidth,height:normalizedHeight};const centerRotatedBox={box:rect,rotation:rotation,coordinateType:CenterRotatedBox_CoordinateType.kNormalized};const geometry={boundingBox:centerRotatedBox,segmentationPolygon:[]};word.geometry=geometry}}sendSelectedText(){this.isSelectingText=false;const highlightedText=this.getHighlightedText();const lines=this.getHighlightedLines();const containingRect=this.getContainingRect(lines);const formulas=this.getFormulas();this.dispatchEvent(new CustomEvent("show-selected-text-context-menu",{bubbles:true,composed:true,detail:{text:highlightedText,contentLanguage:this.contentLanguage,left:containingRect.left,right:containingRect.right,top:containingRect.top,bottom:containingRect.bottom,selectionStartIndex:this.selectionStartIndex,selectionEndIndex:this.selectionEndIndex}}));if(formulas.length===1){this.browserProxy.handler.issueMathSelectionRequest(highlightedText.replaceAll("\r\n"," "),formulas[0],this.selectionStartIndex,this.selectionEndIndex);recordLensOverlayInteraction(INVOCATION_SOURCE,UserAction.kMathSelection)}else{this.browserProxy.handler.issueTextSelectionRequest(highlightedText.replaceAll("\r\n"," "),this.selectionStartIndex,this.selectionEndIndex,this.shouldRenderTranslateWords);recordLensOverlayInteraction(INVOCATION_SOURCE,this.shouldRenderTranslateWords?UserAction.kTranslateTextSelection:UserAction.kTextSelection)}}selectAndSendWords(selectionStartIndex,selectionEndIndex){this.selectWords(selectionStartIndex,selectionEndIndex);this.sendSelectedText()}selectAndTranslateWords(selectionStartIndex,selectionEndIndex){this.selectWords(selectionStartIndex,selectionEndIndex);this.isSelectingText=false;const highlightedText=this.getHighlightedText();const lines=this.getHighlightedLines();const containingRect=this.getContainingRect(lines);this.dispatchEvent(new CustomEvent("update-selected-text-context-menu",{bubbles:true,composed:true,detail:{text:highlightedText,contentLanguage:this.contentLanguage,left:containingRect.left,right:containingRect.right,top:containingRect.top,bottom:containingRect.bottom,selectionStartIndex:this.selectionStartIndex,selectionEndIndex:this.selectionEndIndex}}));translateWords(this.getHighlightedText(),this.contentLanguage,this.selectionStartIndex,this.selectionEndIndex,this.browserProxy)}cancelGesture(){this.unselectWords()}onSelectionStart(){return}onSelectionFinish(){return}unselectWords(){this.selectWords(-1,-1);this.dispatchEvent(new CustomEvent("hide-selected-text-context-menu",{bubbles:true,composed:true}));this.dispatchEvent(new CustomEvent("hide-selected-region-context-menu",{bubbles:true,composed:true}))}selectWords(selectionStartIndex,selectionEndIndex){this.selectionStartIndex=selectionStartIndex;this.selectionEndIndex=selectionEndIndex;this.highlightedLines=this.getHighlightedLines()}onTextReceived(text){const receivedWords=[];this.lineNumbers=[];this.paragraphNumbers=[];this.lines=[];this.paragraphs=[];this.contentLanguage=text.contentLanguage??"";let lineNumber=0;let paragraphNumber=0;if(this.renderedWords?.length>0){recordLensOverlaySemanticEvent(SemanticEvent.kTextGleamsViewEnd)}let detectedWordIndex=0;let translatedWordIndex=0;let translatedLineNumber=0;const receivedTranslateLines=[];this.translatedLineNumbers=[];this.translatedParagraphNumbers=[];this.renderedTranslateWords=[];this.renderedTranslateLines=[];this.renderedTranslateParagraphs={};this.detectedWordToTranslateIndex={};for(const paragraph of text.textLayout?.paragraphs??[]){const hasParagraphTranslation=paragraph.translation!==null;if(hasParagraphTranslation){assert(paragraph.translation!==null);for(const line of paragraph.translation.lines){const translatedWordDataInLine=[];for(const word of line.words){const translatedWordData={word:word,index:translatedWordIndex};this.renderedTranslateWords.push(word);translatedWordDataInLine.push(translatedWordData);this.translatedLineNumbers.push(translatedLineNumber);this.translatedParagraphNumbers.push(paragraphNumber);translatedWordIndex++}const translatedLineData={alignment:paragraph.translation.alignment??Alignment.kDefaultLeftAlgined,contentLanguage:paragraph.contentLanguage??"",line:line,words:translatedWordDataInLine,paragraphIndex:paragraphNumber};receivedTranslateLines.push(translatedLineData);translatedLineNumber++}this.renderedTranslateParagraphs[paragraphNumber]=paragraph.translation}for(const line of paragraph.lines){for(const word of line.words){if(isWordRenderable(word)){receivedWords.push(word);this.lineNumbers.push(lineNumber);this.paragraphNumbers.push(paragraphNumber);if(!hasParagraphTranslation){this.renderedTranslateWords.push(word);this.translatedLineNumbers.push(translatedLineNumber);this.translatedParagraphNumbers.push(paragraphNumber);this.detectedWordToTranslateIndex[detectedWordIndex]=translatedWordIndex;translatedWordIndex++;translatedLineNumber++}detectedWordIndex++}}this.lines.push(line);lineNumber++;if(!hasParagraphTranslation){translatedLineNumber++}}this.paragraphs.push(paragraph);paragraphNumber++}this.renderedWords=receivedWords;if(this.renderedWords.length>0){recordLensOverlaySemanticEvent(SemanticEvent.kTextGleamsViewStart)}assert(this.lineNumbers.length===this.renderedWords.length);assert(this.paragraphNumbers.length===this.renderedWords.length);assert(this.renderedTranslateWords.length===this.translatedLineNumbers.length);this.renderedTranslateLines=receivedTranslateLines;afterNextRender(this,(()=>{this.computeTranslatedWordBoundingBoxes()}));this.textReceivedTimeoutElapsedOrCleared=true;clearTimeout(this.textReceivedTimeoutID);this.dispatchEvent(new CustomEvent("finished-receiving-text",{bubbles:true,composed:true}));this.dispatchEvent(new CustomEvent("received-content-language",{bubbles:true,composed:true,detail:{contentLanguage:this.contentLanguage}}))}calculateFontSizePixels(translatedLine){const line=translatedLine.line;if(!line.geometry){return MIN_FONT_SIZE}if(line.geometry.boundingBox.coordinateType!==CenterRotatedBox_CoordinateType.kNormalized){return MIN_FONT_SIZE}const isTopToBottom=this.isTranslatedLineVertical(translatedLine);const translatedLineWidth=line.geometry.boundingBox.box.width*this.selectionOverlayRect.width;const translatedLineHeight=line.geometry.boundingBox.box.height*this.selectionOverlayRect.height;const lineWidth=isTopToBottom?translatedLineHeight:translatedLineWidth;const lineHeight=isTopToBottom?translatedLineWidth:translatedLineHeight;this.$.textRenderCanvas.width=lineWidth;this.$.textRenderCanvas.height=lineHeight;this.resetCanvasPixelRatioIfNeeded();let text="";for(let i=0;i<line.words.length;i++){const word=line.words[i];text+=word.plainText;text+=getTextSeparator(word)}const fontFamily=loadTimeData.getString("fontfamilyMd");let low=MIN_FONT_SIZE;let high=MAX_FONT_SIZE;while(low<=high){const mid=Math.floor((low+high)/2);this.context.font=`${mid}px ${fontFamily}`;const textMetrics=this.context.measureText(text);const textHeight=textMetrics.fontBoundingBoxAscent+textMetrics.fontBoundingBoxDescent;if(textMetrics.width>=lineWidth||textHeight>=lineHeight){high=mid-1}else{low=mid+1}}return Math.min(low-1,MAX_FONT_SIZE)}getContainingRect(lines){const left=Math.min(...lines.map((line=>line.left)));const right=Math.max(...lines.map((line=>line.left+line.width)));const top=Math.min(...lines.map((line=>line.top)));const bottom=Math.max(...lines.map((line=>line.top+line.height)));return{left:left,right:right,top:top,bottom:bottom}}getHighlightedLines(){const newHighlightedLines=[];if(this.selectionStartIndex===-1||this.selectionEndIndex===-1){return newHighlightedLines}const startIndex=Math.min(this.selectionStartIndex,this.selectionEndIndex);const endIndex=Math.max(this.selectionStartIndex,this.selectionEndIndex);const words=this.shouldRenderTranslateWords?this.renderedTranslateWords:this.renderedWords;const lineNumbers=this.shouldRenderTranslateWords?this.translatedLineNumbers:this.lineNumbers;let currentLineIndex=lineNumbers[startIndex];let startWord=words[startIndex];let endWord=words[startIndex];for(let i=startIndex;i<=endIndex;i++){if(lineNumbers[i]!==currentLineIndex){newHighlightedLines.push(this.calculateHighlightedLine(startWord,endWord,this.isTopToBottomWritingDirection(i)));startWord=words[i];currentLineIndex=lineNumbers[i]}endWord=words[i]}newHighlightedLines.push(this.calculateHighlightedLine(startWord,endWord,this.isTopToBottomWritingDirection(endIndex)));return newHighlightedLines}calculateHighlightedLine(startWord,endWord,isTopToBottom){assert(startWord.geometry);assert(endWord.geometry);const startWordBoundingBox=startWord.geometry.boundingBox;const endWordBoundingBox=endWord.geometry.boundingBox;const slope=(endWordBoundingBox.box.y-startWordBoundingBox.box.y)/(endWordBoundingBox.box.x-startWordBoundingBox.box.x);let rotationAngle=slope?Math.atan(slope):0;if(isTopToBottom){rotationAngle+=1.5708}const relativeStartCenter=rotateCoordinateAroundOrigin({x:startWordBoundingBox.box.x,y:startWordBoundingBox.box.y},rotationAngle);const relativeEndCenter=rotateCoordinateAroundOrigin({x:endWordBoundingBox.box.x,y:endWordBoundingBox.box.y},rotationAngle);const containingBoxTop=Math.min(relativeStartCenter.y-startWordBoundingBox.box.height/2,relativeEndCenter.y-endWordBoundingBox.box.height/2);const containingBoxLeft=Math.min(relativeStartCenter.x-startWordBoundingBox.box.width/2,relativeEndCenter.x-endWordBoundingBox.box.width/2);const containingBoxBottom=Math.max(relativeStartCenter.y+startWordBoundingBox.box.height/2,relativeEndCenter.y+endWordBoundingBox.box.height/2);const containingBoxRight=Math.max(relativeStartCenter.x+startWordBoundingBox.box.width/2,relativeEndCenter.x+endWordBoundingBox.box.width/2);const containingCenter=rotateCoordinateAroundOrigin({x:(containingBoxRight+containingBoxLeft)/2,y:(containingBoxTop+containingBoxBottom)/2},-rotationAngle);const containingBoxWidth=containingBoxRight-containingBoxLeft;const containingBoxHeight=containingBoxBottom-containingBoxTop;return{top:containingCenter.y-containingBoxHeight/2,left:containingCenter.x-containingBoxWidth/2,width:containingBoxWidth,height:containingBoxHeight,rotation:(startWordBoundingBox.rotation+endWordBoundingBox.rotation)/2}}isTopToBottomWritingDirection(wordIndex){const paragraphNumbers=this.shouldRenderTranslateWords?this.translatedParagraphNumbers:this.paragraphNumbers;const paragraph=this.paragraphs[paragraphNumbers[wordIndex]];return paragraph.writingDirection===WritingDirection.kTopToBottom}getHighlightedText(){if(this.selectionStartIndex===-1||this.selectionEndIndex===-1){return""}const startIndex=Math.min(this.selectionStartIndex,this.selectionEndIndex);const endIndex=Math.max(this.selectionStartIndex,this.selectionEndIndex);const selectedWords=this.shouldRenderTranslateWords?this.renderedTranslateWords.slice(startIndex,endIndex+1):this.renderedWords.slice(startIndex,endIndex+1);const selectedParagraphNumbers=this.shouldRenderTranslateWords?this.translatedParagraphNumbers.slice(startIndex,endIndex+1):this.paragraphNumbers.slice(startIndex,endIndex+1);return selectedWords.map(((word,index)=>{let separator="";if(index<selectedWords.length-1){if(selectedParagraphNumbers[index]!==selectedParagraphNumbers[index+1]){separator="\r\n"}else{separator=getTextSeparator(word)}}return word.plainText+separator})).join("")}getFormulas(){if(this.selectionStartIndex===-1||this.selectionEndIndex===-1){return[]}const startIndex=Math.min(this.selectionStartIndex,this.selectionEndIndex);const endIndex=Math.max(this.selectionStartIndex,this.selectionEndIndex);const selectedWords=this.renderedWords.slice(startIndex,endIndex+1);return selectedWords.flatMap((word=>word?.formulaMetadata?.latex?[word.formulaMetadata.latex]:[]))}getWordStyle(word,wordIndex){const wordBoundingBox=word.geometry.boundingBox;if(wordBoundingBox.coordinateType!==CenterRotatedBox_CoordinateType.kNormalized){return""}const paragraph=this.paragraphs[this.paragraphNumbers[wordIndex]];if(this.shouldRenderTranslateWords&&paragraph.translation){return"display: none;"}const horizontalLineMarginPercent=loadTimeData.getInteger("verticalTextMarginPx")/this.selectionOverlayRect.height;const verticalLineMarginPercent=loadTimeData.getInteger("horizontalTextMarginPx")/this.selectionOverlayRect.width;const styles=[`width: ${toPercent(wordBoundingBox.box.width+2*horizontalLineMarginPercent)}`,`height: ${toPercent(wordBoundingBox.box.height+2*verticalLineMarginPercent)}`,`top: ${toPercent(wordBoundingBox.box.y-wordBoundingBox.box.height/2-verticalLineMarginPercent)}`,`left: ${toPercent(wordBoundingBox.box.x-wordBoundingBox.box.width/2-horizontalLineMarginPercent)}`,`transform: rotate(${wordBoundingBox.rotation}rad)`];return styles.join(";")}getTranslatedLineStyle(translatedLineData){const translatedLine=translatedLineData.line;if(!translatedLine.geometry){return""}const lineBoundingBox=translatedLine.geometry.boundingBox;if(lineBoundingBox.coordinateType!==CenterRotatedBox_CoordinateType.kNormalized){return""}let additionalTopPadding=0;let additionalLeftPadding=0;let additionHorizontalPadding=0;let additionalVerticalPadding=0;if(!translatedLine.backgroundImageData){additionalTopPadding=1;additionalLeftPadding=2;additionHorizontalPadding=4;additionalVerticalPadding=2}const lineFontSizePixels=this.calculateFontSizePixels(translatedLineData);const styles=[`background-color: ${this.getBackgroundColorForLine(translatedLine)}`,`color: ${skColorToHexColor(translatedLine.textColor)}`,`direction: ${this.getTranslateLanguageDirection(this.renderedTranslateParagraphs[translatedLineData.paragraphIndex])}`,`justify-content: ${this.getLineAlignment(translatedLineData.alignment)}`,`font-size: ${lineFontSizePixels}px`,`width: calc(${toPercent(lineBoundingBox.box.width)} + ${additionHorizontalPadding}px)`,`height: calc(${toPercent(lineBoundingBox.box.height)} + ${additionalVerticalPadding}px)`,`top: calc(${toPercent(lineBoundingBox.box.y-lineBoundingBox.box.height/2)} - ${additionalTopPadding}px)`,`left: calc(${toPercent(lineBoundingBox.box.x-lineBoundingBox.box.width/2)} - ${additionalLeftPadding}px)`,`text-shadow: ${this.getOutlineStyleForLine(translatedLine,lineFontSizePixels)}`,`transform: rotate(${lineBoundingBox.rotation}rad)`,`writing-mode: ${this.getWritingModeForLine(translatedLineData)}`];return styles.join(";")}getBackgroundImageDataStyle(translatedLineData){const translatedLine=translatedLineData.line;if(!translatedLine.geometry){return""}const lineBoundingBox=translatedLine.geometry.boundingBox;if(lineBoundingBox.coordinateType!==CenterRotatedBox_CoordinateType.kNormalized){return""}const backgroundImageData=translatedLine.backgroundImageData;if(!backgroundImageData){return""}const paragraph=this.renderedTranslateParagraphs[translatedLineData.paragraphIndex];const screenshotAspectRatio=paragraph.resizedBitmapSize.width/paragraph.resizedBitmapSize.height;const horizontalPadding=backgroundImageData.horizontalPadding*lineBoundingBox.box.height/screenshotAspectRatio;const verticalPadding=backgroundImageData.verticalPadding*lineBoundingBox.box.height;const styles=[`width: ${toPercent(lineBoundingBox.box.width+horizontalPadding)}`,`height: ${toPercent(lineBoundingBox.box.height+verticalPadding)}`,`top: ${toPercent(lineBoundingBox.box.y-lineBoundingBox.box.height/2-.5*verticalPadding)}`,`left: ${toPercent(lineBoundingBox.box.x-lineBoundingBox.box.width/2-.5*horizontalPadding)}`,`transform: rotate(${lineBoundingBox.rotation}rad)`];return styles.join(";")}getOutlineStyleForLine(line,fontSize){if(!line.backgroundImageData){return"none"}const outlineColor=skColorToRgba(line.backgroundPrimaryColor);const outlineWidth=fontSize*.02;return`-${outlineWidth}px ${outlineWidth}px 0 ${outlineColor},\n            ${outlineWidth}px ${outlineWidth}px 0 ${outlineColor},\n            ${outlineWidth}px -${outlineWidth}px 0 ${outlineColor},\n            -${outlineWidth}px -${outlineWidth}px 0 ${outlineColor}`}getBackgroundColorForLine(line){if(line.backgroundImageData){return"transparent"}return skColorToRgba(line.backgroundPrimaryColor)}isTranslatedLineVertical(line){const writingDirection=this.renderedTranslateParagraphs[line.paragraphIndex].writingDirection;return writingDirection===WritingDirection.kTopToBottom}getWritingModeForLine(line){if(this.isTranslatedLineVertical(line)){return"vertical-lr"}return"horizontal-tb"}getLineAlignment(alignment){if(alignment===Alignment.kDefaultLeftAlgined){return"left"}else if(alignment===Alignment.kCenterAligned){return"center"}else if(alignment===Alignment.kRightAligned){return"right"}return"center"}resetCanvasPixelRatioIfNeeded(){const transform=this.context.getTransform();if(transform.a!==window.devicePixelRatio||transform.d!==window.devicePixelRatio){this.context.setTransform(window.devicePixelRatio,0,0,window.devicePixelRatio,0,0)}}getBlobUrlFromImageData(imageData){const imageBytesBuffer=imageData.backgroundImage;assert(imageBytesBuffer.invalidBuffer!==true);let bytes=new Uint8Array;if(imageBytesBuffer.bytes!==undefined){bytes=new Uint8Array(imageBytesBuffer.bytes)}else if(imageBytesBuffer.sharedMemory!==undefined){const{bufferHandle:bufferHandle,size:size}=imageBytesBuffer.sharedMemory;const{buffer:buffer}=bufferHandle.mapBuffer(0,size);bytes=new Uint8Array(buffer)}else{return""}const blob=new Blob([bytes],{type:"image/webp"});return URL.createObjectURL(blob)}getHighlightedLineStyle(line){const styles=[`width: ${toPercent(line.width)}`,`height: ${toPercent(line.height)}`,`top: ${toPercent(line.top)}`,`left: ${toPercent(line.left)}`,`transform: rotate(${line.rotation}rad)`];return styles.join(";")}wordIndexFromPoint(x,y){const elements=this.shadowRoot.elementsFromPoint(x,y);if(elements.length===0){return null}const words=[];for(const element of elements){if(!(element instanceof HTMLElement)){continue}const wordIndex=this.$.wordsContainer.indexForElement(element);if(wordIndex!==null){words.push(this.renderedWords[wordIndex])}}const imageBounds=this.selectionOverlayRect;const normalizedX=(x-imageBounds.left)/imageBounds.width;const normalizedY=(y-imageBounds.top)/imageBounds.height;const detectedWord=bestHit(words,{x:normalizedX,y:normalizedY});if(detectedWord===null){return null}const detectedWordIndex=this.renderedWords.indexOf(detectedWord);if(detectedWordIndex<0){return null}return this.shouldRenderTranslateWords?this.detectedWordToTranslateIndex[detectedWordIndex]:detectedWordIndex}translatedWordIndexFromPoint(x,y){if(!this.shouldRenderTranslateWords){return null}const topMostElement=this.shadowRoot.elementFromPoint(x,y);if(!topMostElement||!(topMostElement instanceof HTMLElement)){return null}const wordIndexString=topMostElement.dataset["wordIndex"];if(!wordIndexString){return null}return parseInt(wordIndexString)??null}getTranslateLanguageDirection(translatedParagraph){const language=translatedParagraph.contentLanguage?translatedParagraph.contentLanguage:this.currentTranslateLanguage;if(!language){return"ltr"}return isRtlLanguage(language)?"rtl":"ltr"}onCopyDetectedText(_startIndex,_endIndex,_callbackFn){}getElementForTesting(){return this}}customElements.define(TextLayerElement.is,TextLayerElement);