// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";import{WritingDirection}from"./text.mojom-webui.js";const DELTA_TOP_ALLOWANCE=.2;const DELTA_WIDTH_ALLOWANCE=.75;const DELTA_ANGLE_ALLOWANCE=.002;export function createHighlightedLines(text,startIndex,endIndex){const words=text.receivedWords;if(words.length<=0){return[]}assert(startIndex>=0);assert(endIndex>=0);assert(endIndex<words.length);const highlightedLines=[];for(let i=startIndex;i<=endIndex;i++){const firstWord=words[i];assert(firstWord);assert(firstWord.geometry);let box=structuredClone(firstWord.geometry.boundingBox);for(let j=i+1;j<=endIndex;j++){const nextWord=words[j];assert(nextWord);assert(nextWord.geometry);if(!shouldCoalesce(box,nextWord.geometry.boundingBox,text,i,j)){break}const newWordBoundingBox=nextWord.geometry.boundingBox;box=getUnionRect(box,newWordBoundingBox);i=j}highlightedLines.push({height:box.box.height,left:box.box.x-box.box.width/2,top:box.box.y-box.box.height/2,width:box.box.width,rotation:box.rotation})}return highlightedLines}function shouldCoalesce(box,nextBox,text,wordIndex,nextIndex){if(!sameLineAndParagraph(text,wordIndex,nextIndex)){return false}const deltaAngle=Math.abs(box.rotation-nextBox.rotation);if(deltaAngle>=DELTA_ANGLE_ALLOWANCE){return false}const wordLeft=box.box.x-box.box.width/2;const wordTop=box.box.y-box.box.height/2;const nextWordLeft=nextBox.box.x-nextBox.box.width/2;const nextWordTop=nextBox.box.y-nextBox.box.height/2;const word=text.receivedWords[wordIndex];const isVerticalWritingDirection=word.writingDirection===WritingDirection.kTopToBottom;const deltaTop=isVerticalWritingDirection?Math.abs(nextWordLeft+nextBox.box.width-(wordLeft+box.box.width)):Math.abs(nextWordTop-wordTop);const maxHeightOrWidth=isVerticalWritingDirection?Math.max(box.box.width,nextBox.box.width):Math.max(box.box.height,nextBox.box.height);const deltaTopAllowance=DELTA_TOP_ALLOWANCE*maxHeightOrWidth;if(deltaTop>=deltaTopAllowance){return false}const minLeftOrTop=isVerticalWritingDirection?Math.min(wordTop,nextWordTop):Math.min(wordLeft,nextWordLeft);const maxRightOrBottom=isVerticalWritingDirection?Math.max(wordTop+box.box.height,nextWordTop+nextBox.box.height):Math.max(wordLeft+box.box.width,nextWordLeft+nextBox.box.width);const unionWidth=maxRightOrBottom-minLeftOrTop;const sumWidth=isVerticalWritingDirection?box.box.height+nextBox.box.height:box.box.width+nextBox.box.width;return sumWidth/unionWidth>=DELTA_WIDTH_ALLOWANCE}function sameLineAndParagraph(text,wordIndex,nextIndex){return text.paragraphNumbers[wordIndex]===text.paragraphNumbers[nextIndex]&&text.lineNumbers[wordIndex]===text.lineNumbers[nextIndex]}function getUnionRect(box,nextBox){assert(box.coordinateType===nextBox.coordinateType);const wordLeft=box.box.x-box.box.width/2;const wordTop=box.box.y-box.box.height/2;const wordRight=box.box.x+box.box.width/2;const wordBottom=box.box.y+box.box.height/2;const nextWordLeft=nextBox.box.x-nextBox.box.width/2;const nextWordTop=nextBox.box.y-nextBox.box.height/2;const nextWordRight=nextBox.box.x+nextBox.box.width/2;const nextWordBottom=nextBox.box.y+nextBox.box.height/2;const unionLeft=Math.min(wordLeft,nextWordLeft);const unionRight=Math.max(wordRight,nextWordRight);const unionTop=Math.min(wordTop,nextWordTop);const unionBottom=Math.max(wordBottom,nextWordBottom);const unionWidth=unionRight-unionLeft;const unionHeight=unionBottom-unionTop;const centerX=unionLeft+unionWidth/2;const centerY=unionTop+unionHeight/2;return{box:{x:centerX,y:centerY,height:unionHeight,width:unionWidth},rotation:box.rotation,coordinateType:box.coordinateType}}