// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{I18nMixin}from"//resources/cr_elements/i18n_mixin.js";import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{getFallbackTheme,getShaderLayerColorHexes,GLIF_HEX_COLORS}from"./color_utils.js";import{CenterRotatedBox_CoordinateType}from"./geometry.mojom-webui.js";import{UserAction}from"./lens.mojom-webui.js";import{INVOCATION_SOURCE}from"./lens_overlay_app.js";import{recordLensOverlayInteraction}from"./metrics_utils.js";import{getTemplate}from"./region_selection.html.js";import{ScreenshotBitmapBrowserProxyImpl}from"./screenshot_bitmap_browser_proxy.js";import{renderScreenshot}from"./screenshot_utils.js";import{focusShimmerOnRegion,GestureState,getRelativeCoordinate,ShimmerControlRequester,unfocusShimmer}from"./selection_utils.js";function fullscreenNormalizedCenterRotatedBox(){return{box:{x:.5,y:.5,width:1,height:1},rotation:0,coordinateType:CenterRotatedBox_CoordinateType.kNormalized}}function fullscreenPostSelectionRegion(){return{top:0,left:0,width:1,height:1}}const RegionSelectionElementBase=I18nMixin(PolymerElement);export class RegionSelectionElement extends RegionSelectionElementBase{static get is(){return"region-selection"}static get template(){return getTemplate()}static get properties(){return{borderGlowEnabled:{reflectToAttribute:true,type:Boolean,value:false},canvasHeight:Number,canvasWidth:Number,canvasPhysicalHeight:Number,canvasPhysicalWidth:Number,displayKeyboardSelection:{type:Boolean,value:()=>loadTimeData.getBoolean("enableKeyboardSelection"),reflectToAttribute:true},hasSelected:{reflectToAttribute:true,type:Boolean,value:false},isSelecting:{reflectToAttribute:true,type:Boolean,value:false},screenshotDataUri:String,shaderLayerColorHexes:{type:Array,computed:"computeShaderLayerColorHexes_(theme)"},theme:{type:Object,value:getFallbackTheme},selectionOverlayRect:Object}}eventTracker_=new EventTracker;context;browserProxy=BrowserProxyImpl.getInstance();gradientRegionStrokeEnabled=loadTimeData.getBoolean("enableGradientRegionStroke");whiteRegionStrokeEnabled=loadTimeData.getBoolean("enableWhiteRegionStroke");tapRegionHeight=loadTimeData.getInteger("tapRegionHeight");tapRegionWidth=loadTimeData.getInteger("tapRegionWidth");enableKeyboardSelection=loadTimeData.getBoolean("enableKeyboardSelection");ready(){super.ready();this.context=this.$.regionSelectionCanvas.getContext("2d")}connectedCallback(){super.connectedCallback();ScreenshotBitmapBrowserProxyImpl.getInstance().fetchScreenshot((screenshot=>{renderScreenshot(this.$.highlightImgCanvas,screenshot)}));ScreenshotBitmapBrowserProxyImpl.getInstance().addOnOverlayReshownListener((screenshot=>{renderScreenshot(this.$.highlightImgCanvas,screenshot)}));if(this.enableKeyboardSelection){this.eventTracker_.add(document,"post-selection-updated",(e=>{this.displayKeyboardSelection=e.detail.height===0&&e.detail.width===0}))}}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}computeShaderLayerColorHexes_(){return getShaderLayerColorHexes(this.theme)}handleGestureStart(){this.isSelecting=true;this.hasSelected=false}handleGestureDrag(event){this.clearCanvas();this.renderBoundingBox(event)}handleGestureEnd(event){const isClick=event.state===GestureState.STARTING;const box=this.getNormalizedCenterRotatedBoxFromGesture(event);const region=this.getPostSelectionRegion(event);const interaction=isClick?UserAction.kTapRegionSelection:UserAction.kRegionSelection;this.issueRequest(isClick,box,region,interaction);return true}onKeyboardSelection(event){if(event instanceof KeyboardEvent&&!(event.key==="Enter"||event.key===" ")){return false}this.issueRequest(false,fullscreenNormalizedCenterRotatedBox(),fullscreenPostSelectionRegion(),UserAction.kFullScreenshotRegionSelection);return true}issueRequest(isClick,box,region,interaction){recordLensOverlayInteraction(INVOCATION_SOURCE,interaction);this.browserProxy.handler.issueLensRegionRequest(box,isClick);unfocusShimmer(this,ShimmerControlRequester.MANUAL_REGION);this.dispatchEvent(new CustomEvent("render-post-selection",{bubbles:true,composed:true,detail:region}));this.dispatchEvent(new CustomEvent("detect-text-in-region",{bubbles:true,composed:true,detail:box}));this.clearCanvas();this.hasSelected=true;this.isSelecting=false}handlePostSelectionDragGestureEnd(){this.hasSelected=true;this.isSelecting=false}handlePostSelectionCleared(){this.hasSelected=false;this.isSelecting=false}cancelGesture(){this.clearCanvas();this.isSelecting=false;this.hasSelected=false}setCanvasSizeTo(width,height){this.canvasWidth=width;this.canvasHeight=height;this.canvasPhysicalWidth=width*window.devicePixelRatio;this.canvasPhysicalHeight=height*window.devicePixelRatio;this.context.setTransform(window.devicePixelRatio,0,0,window.devicePixelRatio,0,0)}clearCanvas(){this.context.clearRect(0,0,this.canvasWidth,this.canvasHeight)}renderBoundingBox(event,idealCornerRadius=24){const parentRect=this.selectionOverlayRect;const relativeDragStart=getRelativeCoordinate({x:event.startX,y:event.startY},parentRect);const relativeDragEnd=getRelativeCoordinate({x:event.clientX,y:event.clientY},parentRect);const width=Math.abs(relativeDragEnd.x-relativeDragStart.x);const height=Math.abs(relativeDragEnd.y-relativeDragStart.y);const left=Math.min(relativeDragStart.x,relativeDragEnd.x);const top=Math.min(relativeDragStart.y,relativeDragEnd.y);const right=Math.max(relativeDragStart.x,relativeDragEnd.x);const bottom=Math.max(relativeDragStart.y,relativeDragEnd.y);const centerX=(left+right)/2;const centerY=(top+bottom)/2;const isDraggingDown=relativeDragEnd.y>relativeDragStart.y;const isDraggingRight=relativeDragEnd.x>relativeDragStart.x;let gradient;if(this.gradientRegionStrokeEnabled){gradient=this.context.createConicGradient(0,centerX,centerY);gradient.addColorStop(0,GLIF_HEX_COLORS.blue);gradient.addColorStop(.45,GLIF_HEX_COLORS.blue);gradient.addColorStop(.6,GLIF_HEX_COLORS.red);gradient.addColorStop(.76,GLIF_HEX_COLORS.yellow);gradient.addColorStop(.92,GLIF_HEX_COLORS.green)}else if(this.whiteRegionStrokeEnabled){gradient=this.context.createLinearGradient(left,bottom,right,top);gradient.addColorStop(0,"rgba(255, 255, 255, 1)");gradient.addColorStop(.92,"rgba(255, 255, 255, 0.5)")}else{gradient=this.context.createLinearGradient(left,bottom,right,top);gradient.addColorStop(0,this.shaderLayerColorHexes[0]);gradient.addColorStop(.5,this.shaderLayerColorHexes[1]);gradient.addColorStop(1,this.shaderLayerColorHexes[2])}const strokeWidth=3;this.context.lineWidth=strokeWidth;this.context.strokeStyle=gradient;this.context.beginPath();const radii=[isDraggingDown||isDraggingRight?idealCornerRadius:0,isDraggingDown||!isDraggingRight?idealCornerRadius:0,!isDraggingDown||!isDraggingRight?idealCornerRadius:0,!isDraggingDown||isDraggingRight?idealCornerRadius:0];this.context.roundRect(left,top,width,height,radii);this.context.save();this.context.clip();this.context.drawImage(this.$.highlightImgCanvas,0,0,this.canvasWidth,this.canvasHeight);if(this.gradientRegionStrokeEnabled){this.context.beginPath();const inset=strokeWidth/2;const strokeRectLeft=left+inset;const strokeRectTop=top+inset;const strokeRectWidth=width-inset*2;const strokeRectHeight=height-inset*2;const strokeRadii=radii.map((r=>Math.max(0,r-inset)));this.context.roundRect(strokeRectLeft,strokeRectTop,strokeRectWidth,strokeRectHeight,strokeRadii);this.context.stroke();this.context.restore()}else{this.context.restore();this.context.stroke()}focusShimmerOnRegion(this,top/this.canvasHeight,left/this.canvasWidth,width/this.canvasWidth,height/this.canvasHeight,ShimmerControlRequester.MANUAL_REGION)}getNormalizedCenterRotatedBoxFromGesture(gesture){if(gesture.state===GestureState.STARTING){return this.getNormalizedCenterRotatedBoxFromTap(gesture)}return this.getNormalizedCenterRotatedBoxFromDrag(gesture)}getNormalizedCenterRotatedBoxFromTap(gesture){const normalizedRect=this.getNormalizedRectangleFromTap(gesture);return{box:{x:normalizedRect.center.x,y:normalizedRect.center.y,width:normalizedRect.width,height:normalizedRect.height},rotation:0,coordinateType:CenterRotatedBox_CoordinateType.kNormalized}}getNormalizedCenterRotatedBoxFromDrag(gesture){const parentRect=this.selectionOverlayRect;const relativeDragStart=getRelativeCoordinate({x:gesture.startX,y:gesture.startY},parentRect);const relativeDragEnd=getRelativeCoordinate({x:gesture.clientX,y:gesture.clientY},parentRect);const normalizedWidth=Math.abs(relativeDragEnd.x-relativeDragStart.x)/parentRect.width;const normalizedHeight=Math.abs(relativeDragEnd.y-relativeDragStart.y)/parentRect.height;const centerX=(relativeDragEnd.x+relativeDragStart.x)/2;const centerY=(relativeDragEnd.y+relativeDragStart.y)/2;const normalizedCenterX=centerX/parentRect.width;const normalizedCenterY=centerY/parentRect.height;return{box:{x:normalizedCenterX,y:normalizedCenterY,width:normalizedWidth,height:normalizedHeight},rotation:0,coordinateType:CenterRotatedBox_CoordinateType.kNormalized}}getPostSelectionRegion(gesture){return gesture.state===GestureState.STARTING?this.getPostSelectionRegionFromTap(gesture):this.getPostSelectionRegionFromDrag(gesture)}getPostSelectionRegionFromTap(gesture){const normalizedRect=this.getNormalizedRectangleFromTap(gesture);return{top:normalizedRect.top,left:normalizedRect.left,width:normalizedRect.width,height:normalizedRect.height}}getPostSelectionRegionFromDrag(gesture){const parentRect=this.selectionOverlayRect;const relativeDragStart=getRelativeCoordinate({x:gesture.startX,y:gesture.startY},parentRect);const relativeDragEnd=getRelativeCoordinate({x:gesture.clientX,y:gesture.clientY},parentRect);const normalizedWidth=Math.abs(relativeDragEnd.x-relativeDragStart.x)/parentRect.width;const normalizedHeight=Math.abs(relativeDragEnd.y-relativeDragStart.y)/parentRect.height;const normalizedTop=Math.min(relativeDragEnd.y,relativeDragStart.y)/parentRect.height;const normalizedLeft=Math.min(relativeDragEnd.x,relativeDragStart.x)/parentRect.width;return{top:normalizedTop,left:normalizedLeft,width:normalizedWidth,height:normalizedHeight}}getNormalizedRectangleFromTap(gesture){const parentRect=this.selectionOverlayRect;const scaleFactor=Math.min(parentRect.height/window.innerHeight,parentRect.width/window.innerWidth);const tapRegionWidth=loadTimeData.getInteger("tapRegionWidth")*scaleFactor;const tapRegionHeight=loadTimeData.getInteger("tapRegionWidth")*scaleFactor;if(parentRect.width<tapRegionWidth||parentRect.height<tapRegionHeight){return{top:0,left:0,center:{x:.5,y:.5},width:1,height:1}}const normalizedWidth=tapRegionWidth/parentRect.width;const normalizedHeight=tapRegionHeight/parentRect.height;const idealCenterPoint=getRelativeCoordinate({x:gesture.clientX,y:gesture.clientY},parentRect);let centerX=Math.max(idealCenterPoint.x,tapRegionWidth/2);let centerY=Math.max(idealCenterPoint.y,tapRegionHeight/2);centerX=Math.min(centerX,parentRect.width-tapRegionWidth/2);centerY=Math.min(centerY,parentRect.height-tapRegionHeight/2);const top=centerY-tapRegionHeight/2;const left=centerX-tapRegionWidth/2;const normalizedTop=top/parentRect.height;const normalizedLeft=left/parentRect.width;const normalizedCenterX=centerX/parentRect.width;const normalizedCenterY=centerY/parentRect.height;return{top:normalizedTop,left:normalizedLeft,center:{x:normalizedCenterX,y:normalizedCenterY},width:normalizedWidth,height:normalizedHeight}}}customElements.define(RegionSelectionElement.is,RegionSelectionElement);