// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{GLIF_HEX_COLORS}from"./color_utils.js";import{getCss}from"./overlay_border_glow.css.js";import{getHtml}from"./overlay_border_glow.html.js";export class OverlayBorderGlowElement extends CrLitElement{static get is(){return"overlay-border-glow"}static get properties(){return{isFadingOut:{type:Boolean,reflect:true},isFadingIn:{type:Boolean,reflect:true},selectionOverlayRect:{type:Object}}}#isFadingOut_accessor_storage=false;get isFadingOut(){return this.#isFadingOut_accessor_storage}set isFadingOut(value){this.#isFadingOut_accessor_storage=value}#isFadingIn_accessor_storage=false;get isFadingIn(){return this.#isFadingIn_accessor_storage}set isFadingIn(value){this.#isFadingIn_accessor_storage=value}#selectionOverlayRect_accessor_storage=new DOMRect(0,0,0,0);get selectionOverlayRect(){return this.#selectionOverlayRect_accessor_storage}set selectionOverlayRect(value){this.#selectionOverlayRect_accessor_storage=value}static get styles(){return getCss()}getGradientColorStyles(){const styles=[`--gradient-blue: ${GLIF_HEX_COLORS.blue}`,`--gradient-red: ${GLIF_HEX_COLORS.red}`,`--gradient-yellow: ${GLIF_HEX_COLORS.yellow}`,`--gradient-green: ${GLIF_HEX_COLORS.green}`];return styles.join(";")}getBoundsStyles(){const longestSide=Math.max(this.selectionOverlayRect.width,this.selectionOverlayRect.height);return`width: ${longestSide*1.5}px; height: ${longestSide*1.5}px`}handleGestureStart(){this.isFadingOut=true}handlePostSelectionUpdated(){this.isFadingOut=true}handleClearSelection(){this.isFadingOut=false;this.isFadingIn=true}render(){return getHtml.bind(this)()}}customElements.define(OverlayBorderGlowElement.is,OverlayBorderGlowElement);window.CSS.registerProperty({name:"--gradient-mask-opacity-middle-val",syntax:"<number>",inherits:false,initialValue:"0"});