// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{CenterRotatedBoxSpec as lens_mojom_CenterRotatedBoxSpec}from"./geometry.mojom-webui.js";import{OverlayObjectSpec as lens_mojom_OverlayObjectSpec}from"./overlay_object.mojom-webui.js";import{PageContentTypeSpec as lens_mojom_PageContentTypeSpec}from"./page_content_type.mojom-webui.js";import{TextSpec as lens_mojom_TextSpec}from"./text.mojom-webui.js";import{LanguageSpec as lens_mojom_LanguageSpec}from"./translate.mojom-webui.js";import{BitmapMappedFromTrustedProcessSpec as skia_mojom_BitmapMappedFromTrustedProcessSpec}from"//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js";import{SkColorSpec as skia_mojom_SkColorSpec}from"//resources/mojo/skia/public/mojom/skcolor.mojom-webui.js";import{ClickModifiersSpec as ui_mojom_ClickModifiersSpec}from"//resources/mojo/ui/base/mojom/window_open_disposition.mojom-webui.js";export const UserActionSpec={$:mojo.internal.Enum()};export var UserAction;(function(UserAction){UserAction[UserAction["MIN_VALUE"]=0]="MIN_VALUE";UserAction[UserAction["MAX_VALUE"]=18]="MAX_VALUE";UserAction[UserAction["kRegionSelection"]=0]="kRegionSelection";UserAction[UserAction["kRegionSelectionChange"]=1]="kRegionSelectionChange";UserAction[UserAction["kTextSelection"]=2]="kTextSelection";UserAction[UserAction["kObjectClick"]=3]="kObjectClick";UserAction[UserAction["kTranslateText"]=4]="kTranslateText";UserAction[UserAction["kCopyText"]=5]="kCopyText";UserAction[UserAction["kMyActivity"]=6]="kMyActivity";UserAction[UserAction["kLearnMore"]=7]="kLearnMore";UserAction[UserAction["kSendFeedback"]=8]="kSendFeedback";UserAction[UserAction["kTapRegionSelection"]=9]="kTapRegionSelection";UserAction[UserAction["kTranslateButtonEnableAction"]=10]="kTranslateButtonEnableAction";UserAction[UserAction["kTranslateButtonDisableAction"]=11]="kTranslateButtonDisableAction";UserAction[UserAction["kTranslateSourceLanguageChanged"]=12]="kTranslateSourceLanguageChanged";UserAction[UserAction["kTranslateTargetLanguageChanged"]=13]="kTranslateTargetLanguageChanged";UserAction[UserAction["kTranslateTextSelection"]=14]="kTranslateTextSelection";UserAction[UserAction["kCopyAsImage"]=15]="kCopyAsImage";UserAction[UserAction["kSaveAsImage"]=16]="kSaveAsImage";UserAction[UserAction["kMathSelection"]=17]="kMathSelection";UserAction[UserAction["kFullScreenshotRegionSelection"]=18]="kFullScreenshotRegionSelection"})(UserAction||(UserAction={}));export const SemanticEventSpec={$:mojo.internal.Enum()};export var SemanticEvent;(function(SemanticEvent){SemanticEvent[SemanticEvent["MIN_VALUE"]=0]="MIN_VALUE";SemanticEvent[SemanticEvent["MAX_VALUE"]=1]="MAX_VALUE";SemanticEvent[SemanticEvent["kTextGleamsViewStart"]=0]="kTextGleamsViewStart";SemanticEvent[SemanticEvent["kTextGleamsViewEnd"]=1]="kTextGleamsViewEnd"})(SemanticEvent||(SemanticEvent={}));export class LensPageHandlerFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"lens.mojom.LensPageHandlerFactory",scope)}}export class LensPageHandlerFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(LensPageHandlerFactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}createPageHandler(handler,page){this.proxy.sendMessage(0,LensPageHandlerFactory_CreatePageHandler_ParamsSpec.$,null,[handler,page],false)}}export class LensPageHandlerFactoryReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LensPageHandlerFactoryRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,LensPageHandlerFactory_CreatePageHandler_ParamsSpec.$,null,impl.createPageHandler.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class LensPageHandlerFactory{static get $interfaceName(){return"lens.mojom.LensPageHandlerFactory"}static getRemote(){let remote=new LensPageHandlerFactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class LensPageHandlerFactoryCallbackRouter{helper_internal_;$;router_;createPageHandler;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LensPageHandlerFactoryRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.createPageHandler=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,LensPageHandlerFactory_CreatePageHandler_ParamsSpec.$,null,this.createPageHandler.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class LensPageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"lens.mojom.LensPageHandler",scope)}}export class LensPageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(LensPageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}activityRequestedByOverlay(clickModifiers){this.proxy.sendMessage(0,LensPageHandler_ActivityRequestedByOverlay_ParamsSpec.$,null,[clickModifiers],false)}closeRequestedByOverlayCloseButton(){this.proxy.sendMessage(1,LensPageHandler_CloseRequestedByOverlayCloseButton_ParamsSpec.$,null,[],false)}closeRequestedByOverlayBackgroundClick(){this.proxy.sendMessage(2,LensPageHandler_CloseRequestedByOverlayBackgroundClick_ParamsSpec.$,null,[],false)}notifyOverlayInitialized(){this.proxy.sendMessage(3,LensPageHandler_NotifyOverlayInitialized_ParamsSpec.$,null,[],false)}addBackgroundBlur(){this.proxy.sendMessage(4,LensPageHandler_AddBackgroundBlur_ParamsSpec.$,null,[],false)}setLiveBlur(enabled){this.proxy.sendMessage(5,LensPageHandler_SetLiveBlur_ParamsSpec.$,null,[enabled],false)}feedbackRequestedByOverlay(){this.proxy.sendMessage(6,LensPageHandler_FeedbackRequestedByOverlay_ParamsSpec.$,null,[],false)}getOverlayInvocationSource(){return this.proxy.sendMessage(7,LensPageHandler_GetOverlayInvocationSource_ParamsSpec.$,LensPageHandler_GetOverlayInvocationSource_ResponseParamsSpec.$,[],false)}infoRequestedByOverlay(clickModifiers){this.proxy.sendMessage(8,LensPageHandler_InfoRequestedByOverlay_ParamsSpec.$,null,[clickModifiers],false)}issueLensRegionRequest(region,isClick){this.proxy.sendMessage(9,LensPageHandler_IssueLensRegionRequest_ParamsSpec.$,null,[region,isClick],false)}issueLensObjectRequest(region,isMaskClick){this.proxy.sendMessage(10,LensPageHandler_IssueLensObjectRequest_ParamsSpec.$,null,[region,isMaskClick],false)}issueTextSelectionRequest(query,selectionStartIndex,selectionEndIndex,isTranslate){this.proxy.sendMessage(11,LensPageHandler_IssueTextSelectionRequest_ParamsSpec.$,null,[query,selectionStartIndex,selectionEndIndex,isTranslate],false)}issueTranslateSelectionRequest(query,contentLanguage,selectionStartIndex,selectionEndIndex){this.proxy.sendMessage(12,LensPageHandler_IssueTranslateSelectionRequest_ParamsSpec.$,null,[query,contentLanguage,selectionStartIndex,selectionEndIndex],false)}issueMathSelectionRequest(query,formula,selectionStartIndex,selectionEndIndex){this.proxy.sendMessage(13,LensPageHandler_IssueMathSelectionRequest_ParamsSpec.$,null,[query,formula,selectionStartIndex,selectionEndIndex],false)}issueTranslateFullPageRequest(sourceLanguage,targetLanguage){this.proxy.sendMessage(14,LensPageHandler_IssueTranslateFullPageRequest_ParamsSpec.$,null,[sourceLanguage,targetLanguage],false)}issueEndTranslateModeRequest(){this.proxy.sendMessage(15,LensPageHandler_IssueEndTranslateModeRequest_ParamsSpec.$,null,[],false)}copyText(text){this.proxy.sendMessage(16,LensPageHandler_CopyText_ParamsSpec.$,null,[text],false)}copyImage(region){this.proxy.sendMessage(17,LensPageHandler_CopyImage_ParamsSpec.$,null,[region],false)}saveAsImage(region){this.proxy.sendMessage(18,LensPageHandler_SaveAsImage_ParamsSpec.$,null,[region],false)}closePreselectionBubble(){this.proxy.sendMessage(19,LensPageHandler_ClosePreselectionBubble_ParamsSpec.$,null,[],false)}recordUkmAndTaskCompletionForLensOverlayInteraction(userAction){this.proxy.sendMessage(20,LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsSpec.$,null,[userAction],false)}recordLensOverlaySemanticEvent(event){this.proxy.sendMessage(21,LensPageHandler_RecordLensOverlaySemanticEvent_ParamsSpec.$,null,[event],false)}maybeShowTranslateFeaturePromo(){this.proxy.sendMessage(22,LensPageHandler_MaybeShowTranslateFeaturePromo_ParamsSpec.$,null,[],false)}maybeCloseTranslateFeaturePromo(featureEngaged){this.proxy.sendMessage(23,LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsSpec.$,null,[featureEngaged],false)}fetchSupportedLanguages(){return this.proxy.sendMessage(24,LensPageHandler_FetchSupportedLanguages_ParamsSpec.$,LensPageHandler_FetchSupportedLanguages_ResponseParamsSpec.$,[],false)}finishReshowOverlay(){this.proxy.sendMessage(25,LensPageHandler_FinishReshowOverlay_ParamsSpec.$,null,[],false)}acceptPrivacyNotice(){this.proxy.sendMessage(26,LensPageHandler_AcceptPrivacyNotice_ParamsSpec.$,null,[],false)}dismissPrivacyNotice(){this.proxy.sendMessage(27,LensPageHandler_DismissPrivacyNotice_ParamsSpec.$,null,[],false)}}export class LensPageHandlerReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LensPageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,LensPageHandler_ActivityRequestedByOverlay_ParamsSpec.$,null,impl.activityRequestedByOverlay.bind(impl),false);this.helper_internal_.registerHandler(1,LensPageHandler_CloseRequestedByOverlayCloseButton_ParamsSpec.$,null,impl.closeRequestedByOverlayCloseButton.bind(impl),false);this.helper_internal_.registerHandler(2,LensPageHandler_CloseRequestedByOverlayBackgroundClick_ParamsSpec.$,null,impl.closeRequestedByOverlayBackgroundClick.bind(impl),false);this.helper_internal_.registerHandler(3,LensPageHandler_NotifyOverlayInitialized_ParamsSpec.$,null,impl.notifyOverlayInitialized.bind(impl),false);this.helper_internal_.registerHandler(4,LensPageHandler_AddBackgroundBlur_ParamsSpec.$,null,impl.addBackgroundBlur.bind(impl),false);this.helper_internal_.registerHandler(5,LensPageHandler_SetLiveBlur_ParamsSpec.$,null,impl.setLiveBlur.bind(impl),false);this.helper_internal_.registerHandler(6,LensPageHandler_FeedbackRequestedByOverlay_ParamsSpec.$,null,impl.feedbackRequestedByOverlay.bind(impl),false);this.helper_internal_.registerHandler(7,LensPageHandler_GetOverlayInvocationSource_ParamsSpec.$,LensPageHandler_GetOverlayInvocationSource_ResponseParamsSpec.$,impl.getOverlayInvocationSource.bind(impl),false);this.helper_internal_.registerHandler(8,LensPageHandler_InfoRequestedByOverlay_ParamsSpec.$,null,impl.infoRequestedByOverlay.bind(impl),false);this.helper_internal_.registerHandler(9,LensPageHandler_IssueLensRegionRequest_ParamsSpec.$,null,impl.issueLensRegionRequest.bind(impl),false);this.helper_internal_.registerHandler(10,LensPageHandler_IssueLensObjectRequest_ParamsSpec.$,null,impl.issueLensObjectRequest.bind(impl),false);this.helper_internal_.registerHandler(11,LensPageHandler_IssueTextSelectionRequest_ParamsSpec.$,null,impl.issueTextSelectionRequest.bind(impl),false);this.helper_internal_.registerHandler(12,LensPageHandler_IssueTranslateSelectionRequest_ParamsSpec.$,null,impl.issueTranslateSelectionRequest.bind(impl),false);this.helper_internal_.registerHandler(13,LensPageHandler_IssueMathSelectionRequest_ParamsSpec.$,null,impl.issueMathSelectionRequest.bind(impl),false);this.helper_internal_.registerHandler(14,LensPageHandler_IssueTranslateFullPageRequest_ParamsSpec.$,null,impl.issueTranslateFullPageRequest.bind(impl),false);this.helper_internal_.registerHandler(15,LensPageHandler_IssueEndTranslateModeRequest_ParamsSpec.$,null,impl.issueEndTranslateModeRequest.bind(impl),false);this.helper_internal_.registerHandler(16,LensPageHandler_CopyText_ParamsSpec.$,null,impl.copyText.bind(impl),false);this.helper_internal_.registerHandler(17,LensPageHandler_CopyImage_ParamsSpec.$,null,impl.copyImage.bind(impl),false);this.helper_internal_.registerHandler(18,LensPageHandler_SaveAsImage_ParamsSpec.$,null,impl.saveAsImage.bind(impl),false);this.helper_internal_.registerHandler(19,LensPageHandler_ClosePreselectionBubble_ParamsSpec.$,null,impl.closePreselectionBubble.bind(impl),false);this.helper_internal_.registerHandler(20,LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsSpec.$,null,impl.recordUkmAndTaskCompletionForLensOverlayInteraction.bind(impl),false);this.helper_internal_.registerHandler(21,LensPageHandler_RecordLensOverlaySemanticEvent_ParamsSpec.$,null,impl.recordLensOverlaySemanticEvent.bind(impl),false);this.helper_internal_.registerHandler(22,LensPageHandler_MaybeShowTranslateFeaturePromo_ParamsSpec.$,null,impl.maybeShowTranslateFeaturePromo.bind(impl),false);this.helper_internal_.registerHandler(23,LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsSpec.$,null,impl.maybeCloseTranslateFeaturePromo.bind(impl),false);this.helper_internal_.registerHandler(24,LensPageHandler_FetchSupportedLanguages_ParamsSpec.$,LensPageHandler_FetchSupportedLanguages_ResponseParamsSpec.$,impl.fetchSupportedLanguages.bind(impl),false);this.helper_internal_.registerHandler(25,LensPageHandler_FinishReshowOverlay_ParamsSpec.$,null,impl.finishReshowOverlay.bind(impl),false);this.helper_internal_.registerHandler(26,LensPageHandler_AcceptPrivacyNotice_ParamsSpec.$,null,impl.acceptPrivacyNotice.bind(impl),false);this.helper_internal_.registerHandler(27,LensPageHandler_DismissPrivacyNotice_ParamsSpec.$,null,impl.dismissPrivacyNotice.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class LensPageHandler{static get $interfaceName(){return"lens.mojom.LensPageHandler"}static getRemote(){let remote=new LensPageHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class LensPageHandlerCallbackRouter{helper_internal_;$;router_;activityRequestedByOverlay;closeRequestedByOverlayCloseButton;closeRequestedByOverlayBackgroundClick;notifyOverlayInitialized;addBackgroundBlur;setLiveBlur;feedbackRequestedByOverlay;getOverlayInvocationSource;infoRequestedByOverlay;issueLensRegionRequest;issueLensObjectRequest;issueTextSelectionRequest;issueTranslateSelectionRequest;issueMathSelectionRequest;issueTranslateFullPageRequest;issueEndTranslateModeRequest;copyText;copyImage;saveAsImage;closePreselectionBubble;recordUkmAndTaskCompletionForLensOverlayInteraction;recordLensOverlaySemanticEvent;maybeShowTranslateFeaturePromo;maybeCloseTranslateFeaturePromo;fetchSupportedLanguages;finishReshowOverlay;acceptPrivacyNotice;dismissPrivacyNotice;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LensPageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.activityRequestedByOverlay=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,LensPageHandler_ActivityRequestedByOverlay_ParamsSpec.$,null,this.activityRequestedByOverlay.createReceiverHandler(false),false);this.closeRequestedByOverlayCloseButton=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,LensPageHandler_CloseRequestedByOverlayCloseButton_ParamsSpec.$,null,this.closeRequestedByOverlayCloseButton.createReceiverHandler(false),false);this.closeRequestedByOverlayBackgroundClick=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,LensPageHandler_CloseRequestedByOverlayBackgroundClick_ParamsSpec.$,null,this.closeRequestedByOverlayBackgroundClick.createReceiverHandler(false),false);this.notifyOverlayInitialized=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,LensPageHandler_NotifyOverlayInitialized_ParamsSpec.$,null,this.notifyOverlayInitialized.createReceiverHandler(false),false);this.addBackgroundBlur=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,LensPageHandler_AddBackgroundBlur_ParamsSpec.$,null,this.addBackgroundBlur.createReceiverHandler(false),false);this.setLiveBlur=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,LensPageHandler_SetLiveBlur_ParamsSpec.$,null,this.setLiveBlur.createReceiverHandler(false),false);this.feedbackRequestedByOverlay=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,LensPageHandler_FeedbackRequestedByOverlay_ParamsSpec.$,null,this.feedbackRequestedByOverlay.createReceiverHandler(false),false);this.getOverlayInvocationSource=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,LensPageHandler_GetOverlayInvocationSource_ParamsSpec.$,LensPageHandler_GetOverlayInvocationSource_ResponseParamsSpec.$,this.getOverlayInvocationSource.createReceiverHandler(true),false);this.infoRequestedByOverlay=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,LensPageHandler_InfoRequestedByOverlay_ParamsSpec.$,null,this.infoRequestedByOverlay.createReceiverHandler(false),false);this.issueLensRegionRequest=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,LensPageHandler_IssueLensRegionRequest_ParamsSpec.$,null,this.issueLensRegionRequest.createReceiverHandler(false),false);this.issueLensObjectRequest=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,LensPageHandler_IssueLensObjectRequest_ParamsSpec.$,null,this.issueLensObjectRequest.createReceiverHandler(false),false);this.issueTextSelectionRequest=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,LensPageHandler_IssueTextSelectionRequest_ParamsSpec.$,null,this.issueTextSelectionRequest.createReceiverHandler(false),false);this.issueTranslateSelectionRequest=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,LensPageHandler_IssueTranslateSelectionRequest_ParamsSpec.$,null,this.issueTranslateSelectionRequest.createReceiverHandler(false),false);this.issueMathSelectionRequest=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(13,LensPageHandler_IssueMathSelectionRequest_ParamsSpec.$,null,this.issueMathSelectionRequest.createReceiverHandler(false),false);this.issueTranslateFullPageRequest=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(14,LensPageHandler_IssueTranslateFullPageRequest_ParamsSpec.$,null,this.issueTranslateFullPageRequest.createReceiverHandler(false),false);this.issueEndTranslateModeRequest=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(15,LensPageHandler_IssueEndTranslateModeRequest_ParamsSpec.$,null,this.issueEndTranslateModeRequest.createReceiverHandler(false),false);this.copyText=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(16,LensPageHandler_CopyText_ParamsSpec.$,null,this.copyText.createReceiverHandler(false),false);this.copyImage=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(17,LensPageHandler_CopyImage_ParamsSpec.$,null,this.copyImage.createReceiverHandler(false),false);this.saveAsImage=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(18,LensPageHandler_SaveAsImage_ParamsSpec.$,null,this.saveAsImage.createReceiverHandler(false),false);this.closePreselectionBubble=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(19,LensPageHandler_ClosePreselectionBubble_ParamsSpec.$,null,this.closePreselectionBubble.createReceiverHandler(false),false);this.recordUkmAndTaskCompletionForLensOverlayInteraction=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(20,LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsSpec.$,null,this.recordUkmAndTaskCompletionForLensOverlayInteraction.createReceiverHandler(false),false);this.recordLensOverlaySemanticEvent=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(21,LensPageHandler_RecordLensOverlaySemanticEvent_ParamsSpec.$,null,this.recordLensOverlaySemanticEvent.createReceiverHandler(false),false);this.maybeShowTranslateFeaturePromo=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(22,LensPageHandler_MaybeShowTranslateFeaturePromo_ParamsSpec.$,null,this.maybeShowTranslateFeaturePromo.createReceiverHandler(false),false);this.maybeCloseTranslateFeaturePromo=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(23,LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsSpec.$,null,this.maybeCloseTranslateFeaturePromo.createReceiverHandler(false),false);this.fetchSupportedLanguages=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(24,LensPageHandler_FetchSupportedLanguages_ParamsSpec.$,LensPageHandler_FetchSupportedLanguages_ResponseParamsSpec.$,this.fetchSupportedLanguages.createReceiverHandler(true),false);this.finishReshowOverlay=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(25,LensPageHandler_FinishReshowOverlay_ParamsSpec.$,null,this.finishReshowOverlay.createReceiverHandler(false),false);this.acceptPrivacyNotice=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(26,LensPageHandler_AcceptPrivacyNotice_ParamsSpec.$,null,this.acceptPrivacyNotice.createReceiverHandler(false),false);this.dismissPrivacyNotice=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(27,LensPageHandler_DismissPrivacyNotice_ParamsSpec.$,null,this.dismissPrivacyNotice.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class LensPagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"lens.mojom.LensPage",scope)}}export class LensPageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(LensPagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}screenshotDataReceived(screenshotData,isSidePanelOpen){this.proxy.sendMessage(0,LensPage_ScreenshotDataReceived_ParamsSpec.$,null,[screenshotData,isSidePanelOpen],false)}notifyHandshakeComplete(){this.proxy.sendMessage(1,LensPage_NotifyHandshakeComplete_ParamsSpec.$,null,[],false)}notifyResultsPanelOpened(){this.proxy.sendMessage(2,LensPage_NotifyResultsPanelOpened_ParamsSpec.$,null,[],false)}notifyOverlayClosing(){this.proxy.sendMessage(3,LensPage_NotifyOverlayClosing_ParamsSpec.$,null,[],false)}objectsReceived(objects){this.proxy.sendMessage(4,LensPage_ObjectsReceived_ParamsSpec.$,null,[objects],false)}textReceived(text){this.proxy.sendMessage(5,LensPage_TextReceived_ParamsSpec.$,null,[text],false)}regionTextReceived(text,isInjectedImage){this.proxy.sendMessage(6,LensPage_RegionTextReceived_ParamsSpec.$,null,[text,isInjectedImage],false)}themeReceived(theme){this.proxy.sendMessage(7,LensPage_ThemeReceived_ParamsSpec.$,null,[theme],false)}shouldShowContextualSearchBox(shouldShow){this.proxy.sendMessage(8,LensPage_ShouldShowContextualSearchBox_ParamsSpec.$,null,[shouldShow],false)}pageContentTypeChanged(newPageContentType){this.proxy.sendMessage(9,LensPage_PageContentTypeChanged_ParamsSpec.$,null,[newPageContentType],false)}setPostRegionSelection(region){this.proxy.sendMessage(10,LensPage_SetPostRegionSelection_ParamsSpec.$,null,[region],false)}setTextSelection(selectionStartIndex,selectionEndIndex){this.proxy.sendMessage(11,LensPage_SetTextSelection_ParamsSpec.$,null,[selectionStartIndex,selectionEndIndex],false)}setTranslateMode(sourceLanguage,targetLanguage){this.proxy.sendMessage(12,LensPage_SetTranslateMode_ParamsSpec.$,null,[sourceLanguage,targetLanguage],false)}clearRegionSelection(){this.proxy.sendMessage(13,LensPage_ClearRegionSelection_ParamsSpec.$,null,[],false)}clearTextSelection(){this.proxy.sendMessage(14,LensPage_ClearTextSelection_ParamsSpec.$,null,[],false)}clearAllSelections(){this.proxy.sendMessage(15,LensPage_ClearAllSelections_ParamsSpec.$,null,[],false)}onCopyCommand(){this.proxy.sendMessage(16,LensPage_OnCopyCommand_ParamsSpec.$,null,[],false)}suppressGhostLoader(){this.proxy.sendMessage(17,LensPage_SuppressGhostLoader_ParamsSpec.$,null,[],false)}onOverlayReshown(screenshotData){this.proxy.sendMessage(18,LensPage_OnOverlayReshown_ParamsSpec.$,null,[screenshotData],false)}}export class LensPageReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LensPageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,LensPage_ScreenshotDataReceived_ParamsSpec.$,null,impl.screenshotDataReceived.bind(impl),false);this.helper_internal_.registerHandler(1,LensPage_NotifyHandshakeComplete_ParamsSpec.$,null,impl.notifyHandshakeComplete.bind(impl),false);this.helper_internal_.registerHandler(2,LensPage_NotifyResultsPanelOpened_ParamsSpec.$,null,impl.notifyResultsPanelOpened.bind(impl),false);this.helper_internal_.registerHandler(3,LensPage_NotifyOverlayClosing_ParamsSpec.$,null,impl.notifyOverlayClosing.bind(impl),false);this.helper_internal_.registerHandler(4,LensPage_ObjectsReceived_ParamsSpec.$,null,impl.objectsReceived.bind(impl),false);this.helper_internal_.registerHandler(5,LensPage_TextReceived_ParamsSpec.$,null,impl.textReceived.bind(impl),false);this.helper_internal_.registerHandler(6,LensPage_RegionTextReceived_ParamsSpec.$,null,impl.regionTextReceived.bind(impl),false);this.helper_internal_.registerHandler(7,LensPage_ThemeReceived_ParamsSpec.$,null,impl.themeReceived.bind(impl),false);this.helper_internal_.registerHandler(8,LensPage_ShouldShowContextualSearchBox_ParamsSpec.$,null,impl.shouldShowContextualSearchBox.bind(impl),false);this.helper_internal_.registerHandler(9,LensPage_PageContentTypeChanged_ParamsSpec.$,null,impl.pageContentTypeChanged.bind(impl),false);this.helper_internal_.registerHandler(10,LensPage_SetPostRegionSelection_ParamsSpec.$,null,impl.setPostRegionSelection.bind(impl),false);this.helper_internal_.registerHandler(11,LensPage_SetTextSelection_ParamsSpec.$,null,impl.setTextSelection.bind(impl),false);this.helper_internal_.registerHandler(12,LensPage_SetTranslateMode_ParamsSpec.$,null,impl.setTranslateMode.bind(impl),false);this.helper_internal_.registerHandler(13,LensPage_ClearRegionSelection_ParamsSpec.$,null,impl.clearRegionSelection.bind(impl),false);this.helper_internal_.registerHandler(14,LensPage_ClearTextSelection_ParamsSpec.$,null,impl.clearTextSelection.bind(impl),false);this.helper_internal_.registerHandler(15,LensPage_ClearAllSelections_ParamsSpec.$,null,impl.clearAllSelections.bind(impl),false);this.helper_internal_.registerHandler(16,LensPage_OnCopyCommand_ParamsSpec.$,null,impl.onCopyCommand.bind(impl),false);this.helper_internal_.registerHandler(17,LensPage_SuppressGhostLoader_ParamsSpec.$,null,impl.suppressGhostLoader.bind(impl),false);this.helper_internal_.registerHandler(18,LensPage_OnOverlayReshown_ParamsSpec.$,null,impl.onOverlayReshown.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class LensPage{static get $interfaceName(){return"lens.mojom.LensPage"}static getRemote(){let remote=new LensPageRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class LensPageCallbackRouter{helper_internal_;$;router_;screenshotDataReceived;notifyHandshakeComplete;notifyResultsPanelOpened;notifyOverlayClosing;objectsReceived;textReceived;regionTextReceived;themeReceived;shouldShowContextualSearchBox;pageContentTypeChanged;setPostRegionSelection;setTextSelection;setTranslateMode;clearRegionSelection;clearTextSelection;clearAllSelections;onCopyCommand;suppressGhostLoader;onOverlayReshown;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LensPageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.screenshotDataReceived=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,LensPage_ScreenshotDataReceived_ParamsSpec.$,null,this.screenshotDataReceived.createReceiverHandler(false),false);this.notifyHandshakeComplete=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,LensPage_NotifyHandshakeComplete_ParamsSpec.$,null,this.notifyHandshakeComplete.createReceiverHandler(false),false);this.notifyResultsPanelOpened=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,LensPage_NotifyResultsPanelOpened_ParamsSpec.$,null,this.notifyResultsPanelOpened.createReceiverHandler(false),false);this.notifyOverlayClosing=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,LensPage_NotifyOverlayClosing_ParamsSpec.$,null,this.notifyOverlayClosing.createReceiverHandler(false),false);this.objectsReceived=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,LensPage_ObjectsReceived_ParamsSpec.$,null,this.objectsReceived.createReceiverHandler(false),false);this.textReceived=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,LensPage_TextReceived_ParamsSpec.$,null,this.textReceived.createReceiverHandler(false),false);this.regionTextReceived=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,LensPage_RegionTextReceived_ParamsSpec.$,null,this.regionTextReceived.createReceiverHandler(false),false);this.themeReceived=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,LensPage_ThemeReceived_ParamsSpec.$,null,this.themeReceived.createReceiverHandler(false),false);this.shouldShowContextualSearchBox=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,LensPage_ShouldShowContextualSearchBox_ParamsSpec.$,null,this.shouldShowContextualSearchBox.createReceiverHandler(false),false);this.pageContentTypeChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,LensPage_PageContentTypeChanged_ParamsSpec.$,null,this.pageContentTypeChanged.createReceiverHandler(false),false);this.setPostRegionSelection=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,LensPage_SetPostRegionSelection_ParamsSpec.$,null,this.setPostRegionSelection.createReceiverHandler(false),false);this.setTextSelection=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,LensPage_SetTextSelection_ParamsSpec.$,null,this.setTextSelection.createReceiverHandler(false),false);this.setTranslateMode=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,LensPage_SetTranslateMode_ParamsSpec.$,null,this.setTranslateMode.createReceiverHandler(false),false);this.clearRegionSelection=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(13,LensPage_ClearRegionSelection_ParamsSpec.$,null,this.clearRegionSelection.createReceiverHandler(false),false);this.clearTextSelection=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(14,LensPage_ClearTextSelection_ParamsSpec.$,null,this.clearTextSelection.createReceiverHandler(false),false);this.clearAllSelections=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(15,LensPage_ClearAllSelections_ParamsSpec.$,null,this.clearAllSelections.createReceiverHandler(false),false);this.onCopyCommand=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(16,LensPage_OnCopyCommand_ParamsSpec.$,null,this.onCopyCommand.createReceiverHandler(false),false);this.suppressGhostLoader=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(17,LensPage_SuppressGhostLoader_ParamsSpec.$,null,this.suppressGhostLoader.createReceiverHandler(false),false);this.onOverlayReshown=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(18,LensPage_OnOverlayReshown_ParamsSpec.$,null,this.onOverlayReshown.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const OverlayThemeSpec={$:{}};export const LensPageHandlerFactory_CreatePageHandler_ParamsSpec={$:{}};export const LensPageHandler_ActivityRequestedByOverlay_ParamsSpec={$:{}};export const LensPageHandler_CloseRequestedByOverlayCloseButton_ParamsSpec={$:{}};export const LensPageHandler_CloseRequestedByOverlayBackgroundClick_ParamsSpec={$:{}};export const LensPageHandler_NotifyOverlayInitialized_ParamsSpec={$:{}};export const LensPageHandler_AddBackgroundBlur_ParamsSpec={$:{}};export const LensPageHandler_SetLiveBlur_ParamsSpec={$:{}};export const LensPageHandler_FeedbackRequestedByOverlay_ParamsSpec={$:{}};export const LensPageHandler_GetOverlayInvocationSource_ParamsSpec={$:{}};export const LensPageHandler_GetOverlayInvocationSource_ResponseParamsSpec={$:{}};export const LensPageHandler_InfoRequestedByOverlay_ParamsSpec={$:{}};export const LensPageHandler_IssueLensRegionRequest_ParamsSpec={$:{}};export const LensPageHandler_IssueLensObjectRequest_ParamsSpec={$:{}};export const LensPageHandler_IssueTextSelectionRequest_ParamsSpec={$:{}};export const LensPageHandler_IssueTranslateSelectionRequest_ParamsSpec={$:{}};export const LensPageHandler_IssueMathSelectionRequest_ParamsSpec={$:{}};export const LensPageHandler_IssueTranslateFullPageRequest_ParamsSpec={$:{}};export const LensPageHandler_IssueEndTranslateModeRequest_ParamsSpec={$:{}};export const LensPageHandler_CopyText_ParamsSpec={$:{}};export const LensPageHandler_CopyImage_ParamsSpec={$:{}};export const LensPageHandler_SaveAsImage_ParamsSpec={$:{}};export const LensPageHandler_ClosePreselectionBubble_ParamsSpec={$:{}};export const LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsSpec={$:{}};export const LensPageHandler_RecordLensOverlaySemanticEvent_ParamsSpec={$:{}};export const LensPageHandler_MaybeShowTranslateFeaturePromo_ParamsSpec={$:{}};export const LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsSpec={$:{}};export const LensPageHandler_FetchSupportedLanguages_ParamsSpec={$:{}};export const LensPageHandler_FetchSupportedLanguages_ResponseParamsSpec={$:{}};export const LensPageHandler_FinishReshowOverlay_ParamsSpec={$:{}};export const LensPageHandler_AcceptPrivacyNotice_ParamsSpec={$:{}};export const LensPageHandler_DismissPrivacyNotice_ParamsSpec={$:{}};export const LensPage_ScreenshotDataReceived_ParamsSpec={$:{}};export const LensPage_NotifyHandshakeComplete_ParamsSpec={$:{}};export const LensPage_NotifyResultsPanelOpened_ParamsSpec={$:{}};export const LensPage_NotifyOverlayClosing_ParamsSpec={$:{}};export const LensPage_ObjectsReceived_ParamsSpec={$:{}};export const LensPage_TextReceived_ParamsSpec={$:{}};export const LensPage_RegionTextReceived_ParamsSpec={$:{}};export const LensPage_ThemeReceived_ParamsSpec={$:{}};export const LensPage_ShouldShowContextualSearchBox_ParamsSpec={$:{}};export const LensPage_PageContentTypeChanged_ParamsSpec={$:{}};export const LensPage_SetPostRegionSelection_ParamsSpec={$:{}};export const LensPage_SetTextSelection_ParamsSpec={$:{}};export const LensPage_SetTranslateMode_ParamsSpec={$:{}};export const LensPage_ClearRegionSelection_ParamsSpec={$:{}};export const LensPage_ClearTextSelection_ParamsSpec={$:{}};export const LensPage_ClearAllSelections_ParamsSpec={$:{}};export const LensPage_OnCopyCommand_ParamsSpec={$:{}};export const LensPage_SuppressGhostLoader_ParamsSpec={$:{}};export const LensPage_OnOverlayReshown_ParamsSpec={$:{}};mojo.internal.Struct(OverlayThemeSpec.$,"OverlayTheme",[mojo.internal.StructField("primary",0,0,skia_mojom_SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("shaderLayer1",8,0,skia_mojom_SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("shaderLayer2",16,0,skia_mojom_SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("shaderLayer3",24,0,skia_mojom_SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("shaderLayer4",32,0,skia_mojom_SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("shaderLayer5",40,0,skia_mojom_SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("scrim",48,0,skia_mojom_SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("surfaceContainerHighestLight",56,0,skia_mojom_SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("surfaceContainerHighestDark",64,0,skia_mojom_SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("selectionElement",72,0,skia_mojom_SkColorSpec.$,null,false,0,undefined,undefined)],[[0,88]]);mojo.internal.Struct(LensPageHandlerFactory_CreatePageHandler_ParamsSpec.$,"LensPageHandlerFactory_CreatePageHandler_Params",[mojo.internal.StructField("handler",0,0,mojo.internal.InterfaceRequest(LensPageHandlerPendingReceiver),null,false,0,undefined,undefined),mojo.internal.StructField("page",4,0,mojo.internal.InterfaceProxy(LensPageRemote),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(LensPageHandler_ActivityRequestedByOverlay_ParamsSpec.$,"LensPageHandler_ActivityRequestedByOverlay_Params",[mojo.internal.StructField("clickModifiers",0,0,ui_mojom_ClickModifiersSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPageHandler_CloseRequestedByOverlayCloseButton_ParamsSpec.$,"LensPageHandler_CloseRequestedByOverlayCloseButton_Params",[],[[0,8]]);mojo.internal.Struct(LensPageHandler_CloseRequestedByOverlayBackgroundClick_ParamsSpec.$,"LensPageHandler_CloseRequestedByOverlayBackgroundClick_Params",[],[[0,8]]);mojo.internal.Struct(LensPageHandler_NotifyOverlayInitialized_ParamsSpec.$,"LensPageHandler_NotifyOverlayInitialized_Params",[],[[0,8]]);mojo.internal.Struct(LensPageHandler_AddBackgroundBlur_ParamsSpec.$,"LensPageHandler_AddBackgroundBlur_Params",[],[[0,8]]);mojo.internal.Struct(LensPageHandler_SetLiveBlur_ParamsSpec.$,"LensPageHandler_SetLiveBlur_Params",[mojo.internal.StructField("enabled",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPageHandler_FeedbackRequestedByOverlay_ParamsSpec.$,"LensPageHandler_FeedbackRequestedByOverlay_Params",[],[[0,8]]);mojo.internal.Struct(LensPageHandler_GetOverlayInvocationSource_ParamsSpec.$,"LensPageHandler_GetOverlayInvocationSource_Params",[],[[0,8]]);mojo.internal.Struct(LensPageHandler_GetOverlayInvocationSource_ResponseParamsSpec.$,"LensPageHandler_GetOverlayInvocationSource_ResponseParams",[mojo.internal.StructField("invocationSource",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPageHandler_InfoRequestedByOverlay_ParamsSpec.$,"LensPageHandler_InfoRequestedByOverlay_Params",[mojo.internal.StructField("clickModifiers",0,0,ui_mojom_ClickModifiersSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPageHandler_IssueLensRegionRequest_ParamsSpec.$,"LensPageHandler_IssueLensRegionRequest_Params",[mojo.internal.StructField("region",0,0,lens_mojom_CenterRotatedBoxSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("isClick",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(LensPageHandler_IssueLensObjectRequest_ParamsSpec.$,"LensPageHandler_IssueLensObjectRequest_Params",[mojo.internal.StructField("region",0,0,lens_mojom_CenterRotatedBoxSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("isMaskClick",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(LensPageHandler_IssueTextSelectionRequest_ParamsSpec.$,"LensPageHandler_IssueTextSelectionRequest_Params",[mojo.internal.StructField("query",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("selectionStartIndex",8,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("selectionEndIndex",12,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("isTranslate",16,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(LensPageHandler_IssueTranslateSelectionRequest_ParamsSpec.$,"LensPageHandler_IssueTranslateSelectionRequest_Params",[mojo.internal.StructField("query",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("contentLanguage",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("selectionStartIndex",16,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("selectionEndIndex",20,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(LensPageHandler_IssueMathSelectionRequest_ParamsSpec.$,"LensPageHandler_IssueMathSelectionRequest_Params",[mojo.internal.StructField("query",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("formula",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("selectionStartIndex",16,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("selectionEndIndex",20,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(LensPageHandler_IssueTranslateFullPageRequest_ParamsSpec.$,"LensPageHandler_IssueTranslateFullPageRequest_Params",[mojo.internal.StructField("sourceLanguage",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("targetLanguage",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(LensPageHandler_IssueEndTranslateModeRequest_ParamsSpec.$,"LensPageHandler_IssueEndTranslateModeRequest_Params",[],[[0,8]]);mojo.internal.Struct(LensPageHandler_CopyText_ParamsSpec.$,"LensPageHandler_CopyText_Params",[mojo.internal.StructField("text",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPageHandler_CopyImage_ParamsSpec.$,"LensPageHandler_CopyImage_Params",[mojo.internal.StructField("region",0,0,lens_mojom_CenterRotatedBoxSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPageHandler_SaveAsImage_ParamsSpec.$,"LensPageHandler_SaveAsImage_Params",[mojo.internal.StructField("region",0,0,lens_mojom_CenterRotatedBoxSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPageHandler_ClosePreselectionBubble_ParamsSpec.$,"LensPageHandler_ClosePreselectionBubble_Params",[],[[0,8]]);mojo.internal.Struct(LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsSpec.$,"LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_Params",[mojo.internal.StructField("userAction",0,0,UserActionSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPageHandler_RecordLensOverlaySemanticEvent_ParamsSpec.$,"LensPageHandler_RecordLensOverlaySemanticEvent_Params",[mojo.internal.StructField("event",0,0,SemanticEventSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPageHandler_MaybeShowTranslateFeaturePromo_ParamsSpec.$,"LensPageHandler_MaybeShowTranslateFeaturePromo_Params",[],[[0,8]]);mojo.internal.Struct(LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsSpec.$,"LensPageHandler_MaybeCloseTranslateFeaturePromo_Params",[mojo.internal.StructField("featureEngaged",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPageHandler_FetchSupportedLanguages_ParamsSpec.$,"LensPageHandler_FetchSupportedLanguages_Params",[],[[0,8]]);mojo.internal.Struct(LensPageHandler_FetchSupportedLanguages_ResponseParamsSpec.$,"LensPageHandler_FetchSupportedLanguages_ResponseParams",[mojo.internal.StructField("browserLocale",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("sourceLanguages",8,0,mojo.internal.Array(lens_mojom_LanguageSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("targetLanguages",16,0,mojo.internal.Array(lens_mojom_LanguageSpec.$,false),null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(LensPageHandler_FinishReshowOverlay_ParamsSpec.$,"LensPageHandler_FinishReshowOverlay_Params",[],[[0,8]]);mojo.internal.Struct(LensPageHandler_AcceptPrivacyNotice_ParamsSpec.$,"LensPageHandler_AcceptPrivacyNotice_Params",[],[[0,8]]);mojo.internal.Struct(LensPageHandler_DismissPrivacyNotice_ParamsSpec.$,"LensPageHandler_DismissPrivacyNotice_Params",[],[[0,8]]);mojo.internal.Struct(LensPage_ScreenshotDataReceived_ParamsSpec.$,"LensPage_ScreenshotDataReceived_Params",[mojo.internal.StructField("screenshotData",0,0,skia_mojom_BitmapMappedFromTrustedProcessSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("isSidePanelOpen",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(LensPage_NotifyHandshakeComplete_ParamsSpec.$,"LensPage_NotifyHandshakeComplete_Params",[],[[0,8]]);mojo.internal.Struct(LensPage_NotifyResultsPanelOpened_ParamsSpec.$,"LensPage_NotifyResultsPanelOpened_Params",[],[[0,8]]);mojo.internal.Struct(LensPage_NotifyOverlayClosing_ParamsSpec.$,"LensPage_NotifyOverlayClosing_Params",[],[[0,8]]);mojo.internal.Struct(LensPage_ObjectsReceived_ParamsSpec.$,"LensPage_ObjectsReceived_Params",[mojo.internal.StructField("objects",0,0,mojo.internal.Array(lens_mojom_OverlayObjectSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPage_TextReceived_ParamsSpec.$,"LensPage_TextReceived_Params",[mojo.internal.StructField("text",0,0,lens_mojom_TextSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPage_RegionTextReceived_ParamsSpec.$,"LensPage_RegionTextReceived_Params",[mojo.internal.StructField("text",0,0,lens_mojom_TextSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("isInjectedImage",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(LensPage_ThemeReceived_ParamsSpec.$,"LensPage_ThemeReceived_Params",[mojo.internal.StructField("theme",0,0,OverlayThemeSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPage_ShouldShowContextualSearchBox_ParamsSpec.$,"LensPage_ShouldShowContextualSearchBox_Params",[mojo.internal.StructField("shouldShow",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPage_PageContentTypeChanged_ParamsSpec.$,"LensPage_PageContentTypeChanged_Params",[mojo.internal.StructField("newPageContentType",0,0,lens_mojom_PageContentTypeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPage_SetPostRegionSelection_ParamsSpec.$,"LensPage_SetPostRegionSelection_Params",[mojo.internal.StructField("region",0,0,lens_mojom_CenterRotatedBoxSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPage_SetTextSelection_ParamsSpec.$,"LensPage_SetTextSelection_Params",[mojo.internal.StructField("selectionStartIndex",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("selectionEndIndex",4,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LensPage_SetTranslateMode_ParamsSpec.$,"LensPage_SetTranslateMode_Params",[mojo.internal.StructField("sourceLanguage",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("targetLanguage",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(LensPage_ClearRegionSelection_ParamsSpec.$,"LensPage_ClearRegionSelection_Params",[],[[0,8]]);mojo.internal.Struct(LensPage_ClearTextSelection_ParamsSpec.$,"LensPage_ClearTextSelection_Params",[],[[0,8]]);mojo.internal.Struct(LensPage_ClearAllSelections_ParamsSpec.$,"LensPage_ClearAllSelections_Params",[],[[0,8]]);mojo.internal.Struct(LensPage_OnCopyCommand_ParamsSpec.$,"LensPage_OnCopyCommand_Params",[],[[0,8]]);mojo.internal.Struct(LensPage_SuppressGhostLoader_ParamsSpec.$,"LensPage_SuppressGhostLoader_Params",[],[[0,8]]);mojo.internal.Struct(LensPage_OnOverlayReshown_ParamsSpec.$,"LensPage_OnOverlayReshown_Params",[mojo.internal.StructField("screenshotData",0,0,skia_mojom_BitmapMappedFromTrustedProcessSpec.$,null,false,0,undefined,undefined)],[[0,16]]);