// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{I18nMixin}from"//resources/cr_elements/i18n_mixin.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./cursor_tooltip.html.js";import{toPixels}from"./values_converter.js";export var CursorTooltipType;(function(CursorTooltipType){CursorTooltipType[CursorTooltipType["NONE"]=0]="NONE";CursorTooltipType[CursorTooltipType["REGION_SEARCH"]=1]="REGION_SEARCH";CursorTooltipType[CursorTooltipType["TEXT_HIGHLIGHT"]=2]="TEXT_HIGHLIGHT";CursorTooltipType[CursorTooltipType["CLICK_SEARCH"]=3]="CLICK_SEARCH";CursorTooltipType[CursorTooltipType["LIVE_PAGE"]=4]="LIVE_PAGE"})(CursorTooltipType||(CursorTooltipType={}));const CursorTooltipElementBase=I18nMixin(PolymerElement);export class CursorTooltipElement extends CursorTooltipElementBase{static get is(){return"cursor-tooltip"}static get template(){return getTemplate()}static get properties(){return{canShowTooltipFromPrefs:{type:Boolean,value:()=>loadTimeData.getBoolean("canShowTooltipFromPrefs")},currentTooltip:{type:Number,value:CursorTooltipType.NONE},forceTooltipHidden:{type:Boolean,value:false},isPointerInsideViewport:Boolean,tooltipMessage:String}}queuedTooltipType;queuedTooltipMessage;queuedOffsetLeftPx=0;queuedOffsetTopPx=0;shouldPauseTooltipChanges=false;markPointerEnteredContentArea(){this.isPointerInsideViewport=true}markPointerLeftContentArea(){this.isPointerInsideViewport=false}hideTooltip(){this.forceTooltipHidden=true}unhideTooltip(){this.forceTooltipHidden=false}setPauseTooltipChanges(shouldPauseTooltipChanges){this.shouldPauseTooltipChanges=shouldPauseTooltipChanges;if(!shouldPauseTooltipChanges&&this.queuedTooltipType){this.setTooltipImmediately(this.queuedTooltipType)}}setTooltip(type){if(this.shouldPauseTooltipChanges){this.queuedTooltipType=type}else{this.setTooltipImmediately(type)}}isTooltipVisible(){if(this.forceTooltipHidden){return false}if(this.currentTooltip===CursorTooltipType.LIVE_PAGE&&this.isPointerInsideViewport){return true}return this.isPointerInsideViewport&&this.canShowTooltipFromPrefs&&this.currentTooltip!==CursorTooltipType.NONE}setTooltipImmediately(tooltipType){this.currentTooltip=tooltipType;if(tooltipType===CursorTooltipType.NONE){return}this.queuedTooltipType=undefined;let offsetLeftPx=0;let offsetTopPx=0;let tooltipMessage="";if(tooltipType===CursorTooltipType.LIVE_PAGE){offsetTopPx=24;tooltipMessage=this.i18n("cursorTooltipLivePageMessage")}else{offsetLeftPx+=16;offsetTopPx+=40;if(tooltipType===CursorTooltipType.REGION_SEARCH){offsetTopPx+=6;offsetLeftPx+=3;tooltipMessage=this.i18n("cursorTooltipDragMessage")}else if(tooltipType===CursorTooltipType.TEXT_HIGHLIGHT){offsetTopPx+=8;offsetLeftPx+=3;tooltipMessage=this.i18n("cursorTooltipTextHighlightMessage")}else if(tooltipType===CursorTooltipType.CLICK_SEARCH){offsetTopPx+=17;offsetLeftPx+=11;tooltipMessage=this.i18n("cursorTooltipClickMessage")}}this.style.setProperty("--offset-top",toPixels(offsetTopPx));this.style.setProperty("--offset-left",toPixels(offsetLeftPx));this.tooltipMessage=tooltipMessage}getHiddenCursorClass(){return this.isTooltipVisible()?"":"hidden"}}customElements.define(CursorTooltipElement.is,CursorTooltipElement);