// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { LegionInternalsPageHandler } from './legion_internals.mojom-webui.js';
export class LegionInternalsBrowserProxyImpl {
    handler;
    constructor(handler) {
        this.handler = handler;
    }
    connect(url, apiKey) {
        return this.handler.connect(url, apiKey);
    }
    close() {
        return this.handler.close();
    }
    async sendRequest(featureName, request) {
        const { response } = await this.handler.sendRequest(featureName, request);
        return response;
    }
    static getInstance() {
        return instance ||
            (instance = new LegionInternalsBrowserProxyImpl(LegionInternalsPageHandler.getRemote()));
    }
    static setInstance(newInstance) {
        instance = newInstance;
    }
}
let instance = null;
