import type { LegionInternalsPageHandlerRemote, LegionResponseMojoType } from './legion_internals.mojom-webui.js';
/**
 * @fileoverview A browser proxy for the Legion Internals page.
 */
export interface LegionInternalsBrowserProxy {
    connect(url: string, apiKey: string): Promise<void>;
    close(): Promise<void>;
    sendRequest(featureName: string, request: string): Promise<LegionResponseMojoType>;
}
export declare class LegionInternalsBrowserProxyImpl implements LegionInternalsBrowserProxy {
    handler: LegionInternalsPageHandlerRemote;
    constructor(handler: LegionInternalsPageHandlerRemote);
    connect(url: string, apiKey: string): Promise<void>;
    close(): Promise<void>;
    sendRequest(featureName: string, request: string): Promise<LegionResponseMojoType>;
    static getInstance(): LegionInternalsBrowserProxy;
    static setInstance(newInstance: LegionInternalsBrowserProxy): void;
}
