// chrome/browser/ui/webui/legion_internals/legion_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export class LegionInternalsPageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'legion_internals.mojom.LegionInternalsPageHandler', scope);
    }
}
export class LegionInternalsPageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(LegionInternalsPageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    connect(url, apiKey) {
        return this.proxy.sendMessage(0, LegionInternalsPageHandler_Connect_ParamsSpec.$, LegionInternalsPageHandler_Connect_ResponseParamsSpec.$, [
            url,
            apiKey
        ], false);
    }
    close() {
        return this.proxy.sendMessage(1, LegionInternalsPageHandler_Close_ParamsSpec.$, LegionInternalsPageHandler_Close_ResponseParamsSpec.$, [], false);
    }
    sendRequest(featureName, request) {
        return this.proxy.sendMessage(2, LegionInternalsPageHandler_SendRequest_ParamsSpec.$, LegionInternalsPageHandler_SendRequest_ResponseParamsSpec.$, [
            featureName,
            request
        ], false);
    }
}
;
/**
 * An object which receives request messages for the LegionInternalsPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LegionInternalsPageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LegionInternalsPageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, LegionInternalsPageHandler_Connect_ParamsSpec.$, LegionInternalsPageHandler_Connect_ResponseParamsSpec.$, impl.connect.bind(impl), false);
        this.helper_internal_.registerHandler(1, LegionInternalsPageHandler_Close_ParamsSpec.$, LegionInternalsPageHandler_Close_ResponseParamsSpec.$, impl.close.bind(impl), false);
        this.helper_internal_.registerHandler(2, LegionInternalsPageHandler_SendRequest_ParamsSpec.$, LegionInternalsPageHandler_SendRequest_ResponseParamsSpec.$, impl.sendRequest.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class LegionInternalsPageHandler {
    static get $interfaceName() {
        return "legion_internals.mojom.LegionInternalsPageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new LegionInternalsPageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the LegionInternalsPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LegionInternalsPageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    connect;
    close;
    sendRequest;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LegionInternalsPageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.connect =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, LegionInternalsPageHandler_Connect_ParamsSpec.$, LegionInternalsPageHandler_Connect_ResponseParamsSpec.$, this.connect.createReceiverHandler(true /* expectsResponse */), false);
        this.close =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, LegionInternalsPageHandler_Close_ParamsSpec.$, LegionInternalsPageHandler_Close_ResponseParamsSpec.$, this.close.createReceiverHandler(true /* expectsResponse */), false);
        this.sendRequest =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, LegionInternalsPageHandler_SendRequest_ParamsSpec.$, LegionInternalsPageHandler_SendRequest_ResponseParamsSpec.$, this.sendRequest.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const LegionResponseSpec = { $: {} };
export const LegionInternalsPageHandler_Connect_ParamsSpec = { $: {} };
export const LegionInternalsPageHandler_Connect_ResponseParamsSpec = { $: {} };
export const LegionInternalsPageHandler_Close_ParamsSpec = { $: {} };
export const LegionInternalsPageHandler_Close_ResponseParamsSpec = { $: {} };
export const LegionInternalsPageHandler_SendRequest_ParamsSpec = { $: {} };
export const LegionInternalsPageHandler_SendRequest_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(LegionResponseSpec.$, 'LegionResponse', [
    mojo.internal.StructField('response', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('error', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(LegionInternalsPageHandler_Connect_ParamsSpec.$, 'LegionInternalsPageHandler_Connect_Params', [
    mojo.internal.StructField('url', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('apiKey', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(LegionInternalsPageHandler_Connect_ResponseParamsSpec.$, 'LegionInternalsPageHandler_Connect_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(LegionInternalsPageHandler_Close_ParamsSpec.$, 'LegionInternalsPageHandler_Close_Params', [], [[0, 8],]);
mojo.internal.Struct(LegionInternalsPageHandler_Close_ResponseParamsSpec.$, 'LegionInternalsPageHandler_Close_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(LegionInternalsPageHandler_SendRequest_ParamsSpec.$, 'LegionInternalsPageHandler_SendRequest_Params', [
    mojo.internal.StructField('featureName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('request', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(LegionInternalsPageHandler_SendRequest_ResponseParamsSpec.$, 'LegionInternalsPageHandler_SendRequest_ResponseParams', [
    mojo.internal.StructField('response', 0, 0, LegionResponseSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
