import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export type LegionInternalsPageHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<LegionInternalsPageHandlerPendingReceiver>;
export declare class LegionInternalsPageHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<LegionInternalsPageHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<LegionInternalsPageHandlerPendingReceiver>;
    constructor(handle: MojoHandle | LegionInternalsPageHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface LegionInternalsPageHandlerInterface {
    connect(url: string, apiKey: string): Promise<void>;
    close(): Promise<void>;
    sendRequest(featureName: string, request: string): Promise<{
        response: LegionResponse;
    }>;
}
export declare class LegionInternalsPageHandlerRemote implements LegionInternalsPageHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<LegionInternalsPageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | LegionInternalsPageHandlerPendingReceiverEndpoint);
    connect(url: string, apiKey: string): Promise<void>;
    close(): Promise<void>;
    sendRequest(featureName: string, request: string): Promise<{
        response: LegionResponse;
    }>;
}
/**
 * An object which receives request messages for the LegionInternalsPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class LegionInternalsPageHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<LegionInternalsPageHandlerRemote, LegionInternalsPageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: LegionInternalsPageHandlerInterface);
}
export declare class LegionInternalsPageHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): LegionInternalsPageHandlerRemote;
}
/**
 * An object which receives request messages for the LegionInternalsPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class LegionInternalsPageHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<LegionInternalsPageHandlerRemote, LegionInternalsPageHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    connect: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    close: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    sendRequest: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const LegionResponseSpec: {
    $: mojo.internal.MojomType;
};
export declare const LegionInternalsPageHandler_Connect_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const LegionInternalsPageHandler_Connect_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const LegionInternalsPageHandler_Close_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const LegionInternalsPageHandler_Close_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const LegionInternalsPageHandler_SendRequest_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const LegionInternalsPageHandler_SendRequest_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export interface LegionResponseMojoType {
    response: (string | null);
    error: (string | null);
}
export type LegionResponse = LegionResponseMojoType;
export interface LegionInternalsPageHandler_Connect_ParamsMojoType {
    url: string;
    apiKey: string;
}
export type LegionInternalsPageHandler_Connect_Params = LegionInternalsPageHandler_Connect_ParamsMojoType;
export interface LegionInternalsPageHandler_Connect_ResponseParamsMojoType {
}
export type LegionInternalsPageHandler_Connect_ResponseParams = LegionInternalsPageHandler_Connect_ResponseParamsMojoType;
export interface LegionInternalsPageHandler_Close_ParamsMojoType {
}
export type LegionInternalsPageHandler_Close_Params = LegionInternalsPageHandler_Close_ParamsMojoType;
export interface LegionInternalsPageHandler_Close_ResponseParamsMojoType {
}
export type LegionInternalsPageHandler_Close_ResponseParams = LegionInternalsPageHandler_Close_ResponseParamsMojoType;
export interface LegionInternalsPageHandler_SendRequest_ParamsMojoType {
    featureName: string;
    request: string;
}
export type LegionInternalsPageHandler_SendRequest_Params = LegionInternalsPageHandler_SendRequest_ParamsMojoType;
export interface LegionInternalsPageHandler_SendRequest_ResponseParamsMojoType {
    response: LegionResponse;
}
export type LegionInternalsPageHandler_SendRequest_ResponseParams = LegionInternalsPageHandler_SendRequest_ResponseParamsMojoType;
