// chrome/browser/ui/webui/legion_internals/legion_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';








export type LegionInternalsPageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<LegionInternalsPageHandlerPendingReceiver>;

export class LegionInternalsPageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<LegionInternalsPageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<LegionInternalsPageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|LegionInternalsPageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'legion_internals.mojom.LegionInternalsPageHandler',
        scope);
  }
}

export interface LegionInternalsPageHandlerInterface {
  connect(url: string, apiKey: string): Promise<void>;
  close(): Promise<void>;
  sendRequest(featureName: string, request: string): Promise<{
        response: LegionResponse, }>;
}

export class LegionInternalsPageHandlerRemote implements LegionInternalsPageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<LegionInternalsPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<LegionInternalsPageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|LegionInternalsPageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LegionInternalsPageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  connect(
      url: string,
      apiKey: string): Promise<void> {
    return this.proxy.sendMessage(
        0,
        LegionInternalsPageHandler_Connect_ParamsSpec.$,
        LegionInternalsPageHandler_Connect_ResponseParamsSpec.$,
        [
          url,
          apiKey
        ],
        false);
  }

  close(): Promise<void> {
    return this.proxy.sendMessage(
        1,
        LegionInternalsPageHandler_Close_ParamsSpec.$,
        LegionInternalsPageHandler_Close_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  sendRequest(
      featureName: string,
      request: string): Promise<{
        response: LegionResponse, }> {
    return this.proxy.sendMessage(
        2,
        LegionInternalsPageHandler_SendRequest_ParamsSpec.$,
        LegionInternalsPageHandler_SendRequest_ResponseParamsSpec.$,
        [
          featureName,
          request
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LegionInternalsPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LegionInternalsPageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    LegionInternalsPageHandlerRemote, LegionInternalsPageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    LegionInternalsPageHandlerRemote, LegionInternalsPageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: LegionInternalsPageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LegionInternalsPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LegionInternalsPageHandler_Connect_ParamsSpec.$,
        LegionInternalsPageHandler_Connect_ResponseParamsSpec.$,
        impl.connect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        LegionInternalsPageHandler_Close_ParamsSpec.$,
        LegionInternalsPageHandler_Close_ResponseParamsSpec.$,
        impl.close.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        LegionInternalsPageHandler_SendRequest_ParamsSpec.$,
        LegionInternalsPageHandler_SendRequest_ResponseParamsSpec.$,
        impl.sendRequest.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LegionInternalsPageHandler {
  static get $interfaceName(): string {
    return "legion_internals.mojom.LegionInternalsPageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): LegionInternalsPageHandlerRemote {
    let remote = new LegionInternalsPageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the LegionInternalsPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LegionInternalsPageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    LegionInternalsPageHandlerRemote, LegionInternalsPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    LegionInternalsPageHandlerRemote, LegionInternalsPageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  connect: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  close: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  sendRequest: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LegionInternalsPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LegionInternalsPageHandler_Connect_ParamsSpec.$,
        LegionInternalsPageHandler_Connect_ResponseParamsSpec.$,
        this.connect.createReceiverHandler(true /* expectsResponse */),
        false);
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        LegionInternalsPageHandler_Close_ParamsSpec.$,
        LegionInternalsPageHandler_Close_ResponseParamsSpec.$,
        this.close.createReceiverHandler(true /* expectsResponse */),
        false);
    this.sendRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        LegionInternalsPageHandler_SendRequest_ParamsSpec.$,
        LegionInternalsPageHandler_SendRequest_ResponseParamsSpec.$,
        this.sendRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const LegionResponseSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LegionInternalsPageHandler_Connect_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LegionInternalsPageHandler_Connect_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LegionInternalsPageHandler_Close_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LegionInternalsPageHandler_Close_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LegionInternalsPageHandler_SendRequest_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LegionInternalsPageHandler_SendRequest_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface LegionResponseMojoType {
  response: (string | null);
  error: (string | null);
}


export type LegionResponse = LegionResponseMojoType;
mojo.internal.Struct<LegionResponseMojoType>(
    LegionResponseSpec.$,
    'LegionResponse',
    [
      mojo.internal.StructField<LegionResponseMojoType, string>(
        'response', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LegionResponseMojoType, string>(
        'error', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface LegionInternalsPageHandler_Connect_ParamsMojoType {
  url: string;
  apiKey: string;
}


export type LegionInternalsPageHandler_Connect_Params = LegionInternalsPageHandler_Connect_ParamsMojoType;
mojo.internal.Struct<LegionInternalsPageHandler_Connect_ParamsMojoType>(
    LegionInternalsPageHandler_Connect_ParamsSpec.$,
    'LegionInternalsPageHandler_Connect_Params',
    [
      mojo.internal.StructField<LegionInternalsPageHandler_Connect_ParamsMojoType, string>(
        'url', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LegionInternalsPageHandler_Connect_ParamsMojoType, string>(
        'apiKey', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface LegionInternalsPageHandler_Connect_ResponseParamsMojoType {
}


export type LegionInternalsPageHandler_Connect_ResponseParams = LegionInternalsPageHandler_Connect_ResponseParamsMojoType;
mojo.internal.Struct<LegionInternalsPageHandler_Connect_ResponseParamsMojoType>(
    LegionInternalsPageHandler_Connect_ResponseParamsSpec.$,
    'LegionInternalsPageHandler_Connect_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface LegionInternalsPageHandler_Close_ParamsMojoType {
}


export type LegionInternalsPageHandler_Close_Params = LegionInternalsPageHandler_Close_ParamsMojoType;
mojo.internal.Struct<LegionInternalsPageHandler_Close_ParamsMojoType>(
    LegionInternalsPageHandler_Close_ParamsSpec.$,
    'LegionInternalsPageHandler_Close_Params',
    [
    ],
    [[0, 8],]);





export interface LegionInternalsPageHandler_Close_ResponseParamsMojoType {
}


export type LegionInternalsPageHandler_Close_ResponseParams = LegionInternalsPageHandler_Close_ResponseParamsMojoType;
mojo.internal.Struct<LegionInternalsPageHandler_Close_ResponseParamsMojoType>(
    LegionInternalsPageHandler_Close_ResponseParamsSpec.$,
    'LegionInternalsPageHandler_Close_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface LegionInternalsPageHandler_SendRequest_ParamsMojoType {
  featureName: string;
  request: string;
}


export type LegionInternalsPageHandler_SendRequest_Params = LegionInternalsPageHandler_SendRequest_ParamsMojoType;
mojo.internal.Struct<LegionInternalsPageHandler_SendRequest_ParamsMojoType>(
    LegionInternalsPageHandler_SendRequest_ParamsSpec.$,
    'LegionInternalsPageHandler_SendRequest_Params',
    [
      mojo.internal.StructField<LegionInternalsPageHandler_SendRequest_ParamsMojoType, string>(
        'featureName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LegionInternalsPageHandler_SendRequest_ParamsMojoType, string>(
        'request', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface LegionInternalsPageHandler_SendRequest_ResponseParamsMojoType {
  response: LegionResponse;
}


export type LegionInternalsPageHandler_SendRequest_ResponseParams = LegionInternalsPageHandler_SendRequest_ResponseParamsMojoType;
mojo.internal.Struct<LegionInternalsPageHandler_SendRequest_ResponseParamsMojoType>(
    LegionInternalsPageHandler_SendRequest_ResponseParamsSpec.$,
    'LegionInternalsPageHandler_SendRequest_ResponseParams',
    [
      mojo.internal.StructField<LegionInternalsPageHandler_SendRequest_ResponseParamsMojoType, LegionResponse>(
        'response', 0,
        0,
        LegionResponseSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



