import 'chrome://resources/cr_elements/cr_spinner_style.css.js';
import { Authenticator } from 'chrome://chrome-signin/gaia_auth_host/authenticator.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
interface WebViewElement extends HTMLElement {
    canGoBack(): boolean;
    back(): void;
}
export interface InlineLoginAppElement {
    $: {
        signinFrame: WebViewElement;
        spinner: HTMLElement;
    };
}
declare const InlineLoginAppElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class InlineLoginAppElement extends InlineLoginAppElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Indicates whether the page is loading.
         */
        loading_: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * Indicates whether the account is being verified.
         */
        verifyingAccount_: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * The auth extension host instance.
         */
        authenticator_: {
            type: ObjectConstructor;
            value: null;
        };
    };
    private loading_;
    private verifyingAccount_;
    private authenticator_;
    /** Whether the login UI is loaded for signing in primary account. */
    private isLoginPrimaryAccount_;
    private browserProxy_;
    ready(): void;
    connectedCallback(): void;
    private addAuthenticatorListeners_;
    private onDropLink_;
    private onNewWindow_;
    private onAuthReady_;
    private onResize_;
    private onAuthCompleted_;
    private onShowIncognito_;
    /**
     * Loads auth extension.
     * @param data Parameters for auth extension.
     */
    private loadAuthenticator_;
    /**
     * Sends a message 'lstFetchResults'. This is a specific message sent when
     * the inline signin is loaded with reason kFetchLstOnly. Handlers of
     * this message would expect a single argument a base::Dictionary value that
     * contains the values fetched from the gaia sign in endpoint.
     * @param arg The string representation of the json data returned by
     *    the sign in dialog after it has finished the sign in process.
     */
    private sendLstFetchResults_;
    /**
     * @param loading Indicates whether the page is loading.
     * @param verifyingAccount Indicates whether the user account is being
     *     verified.
     */
    private isSpinnerActive_;
    /**
     * Closes the login dialog.
     */
    private closeDialog_;
    setAuthenticatorForTest(authenticator: Authenticator): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'inline-login-app': InlineLoginAppElement;
    }
}
export {};
