// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Defines some types shared across files in host/.
import { ScrollToErrorReason } from '../../glic_api/glic_api.js';
import { ErrorWithReasonImpl } from '../../glic_api_impl/request_types.js';
// How to respond to each requests received in the background. One entry for
// each request type that does not specify `backgroundAllowed`.
export const BACKGROUND_RESPONSES = {
    glicBrowserCreateTab: { returns: {} },
    glicBrowserShowProfilePicker: { throws: true },
    glicBrowserGetContextFromFocusedTab: { throws: true },
    glicBrowserGetContextFromTab: { throws: true },
    glicBrowserCaptureScreenshot: { throws: true },
    glicBrowserScrollTo: {
        does: () => {
            throw new ErrorWithReasonImpl('scrollTo', ScrollToErrorReason.NOT_SUPPORTED);
        },
    },
    glicBrowserOpenOsPermissionSettingsMenu: { throws: true },
    glicBrowserPinTabs: { returns: { pinnedAll: false } },
    glicBrowserUnpinAllTabs: { returns: undefined },
    glicBrowserSubscribeToPinCandidates: { returns: undefined },
    glicBrowserGetZeroStateSuggestionsForFocusedTab: { returns: {} },
    glicBrowserGetZeroStateSuggestionsAndSubscribe: { returns: {} },
};
export var PanelOpenState;
(function (PanelOpenState) {
    PanelOpenState[PanelOpenState["OPEN"] = 0] = "OPEN";
    PanelOpenState[PanelOpenState["CLOSED"] = 1] = "CLOSED";
})(PanelOpenState || (PanelOpenState = {}));
