import type { HostRequestTypes, RequestResponseType } from '../../glic_api_impl/request_types.js';
type IsBackgroundRequest<T extends keyof HostRequestTypes> = 'backgroundAllowed' extends keyof HostRequestTypes[T] ? HostRequestTypes[T]['backgroundAllowed'] : false;
interface HostBackgroundResponseThrows {
    throws: true;
}
export interface HostBackgroundResponseDoes<R> {
    does: () => R;
}
export interface HostBackgroundResponseReturns<R> {
    returns: R;
}
export type HostBackgroundResponse<R> = HostBackgroundResponseThrows | HostBackgroundResponseReturns<R> | HostBackgroundResponseDoes<R>;
type HostBackgroundResponseMap = {
    [RequestName in keyof HostRequestTypes as IsBackgroundRequest<RequestName> extends true ? never : RequestName]: HostBackgroundResponse<RequestResponseType<RequestName>>;
};
export declare const BACKGROUND_RESPONSES: HostBackgroundResponseMap;
export declare enum PanelOpenState {
    OPEN = 0,
    CLOSED = 1
}
export {};
