import type { PageMetadata as PageMetadataMojo } from '../../ai_page_content_metadata.mojom-webui.js';
import type { ActorTaskState as ActorTaskStateMojo, AdditionalContext as AdditionalContextMojo, FocusedTabData as FocusedTabDataMojo, OpenPanelInfo as OpenPanelInfoMojo, PanelOpeningData as PanelOpeningDataMojo, PanelState as PanelStateMojo, TabData as TabDataMojo, ViewChangeRequest as ViewChangeRequestMojo, WebClientInterface, ZeroStateSuggestionsOptions as ZeroStateSuggestionsOptionsMojo, ZeroStateSuggestionsV2 as ZeroStateSuggestionsV2Mojo } from '../../glic.mojom-webui.js';
import type { NavigationConfirmationRequest as NavigationConfirmationRequestMojo, NavigationConfirmationResponse as NavigationConfirmationResponseMojo, SelectAutofillSuggestionsDialogRequest as SelectAutofillSuggestionsDialogRequestMojo, SelectAutofillSuggestionsDialogResponse as SelectAutofillSuggestionsDialogResponseMojo, SelectCredentialDialogRequest as SelectCredentialDialogRequestMojo, SelectCredentialDialogResponse as SelectCredentialDialogResponseMojo, UserConfirmationDialogRequest as UserConfirmationDialogRequestMojo, UserConfirmationDialogResponse as UserConfirmationDialogResponseMojo } from './../../actor_webui.mojom-webui.js';
import type { ApiHostEmbedder, GlicApiHost } from './glic_api_host.js';
export declare class WebClientImpl implements WebClientInterface {
    private host;
    private embedder;
    private sender;
    constructor(host: GlicApiHost, embedder: ApiHostEmbedder);
    notifyPanelWillOpen(panelOpeningData: PanelOpeningDataMojo): Promise<{
        openPanelInfo: OpenPanelInfoMojo;
    }>;
    notifyPanelWasClosed(): Promise<void>;
    notifyPanelStateChange(panelState: PanelStateMojo): void;
    notifyPanelCanAttachChange(canAttach: boolean): void;
    notifyMicrophonePermissionStateChanged(enabled: boolean): void;
    notifyLocationPermissionStateChanged(enabled: boolean): void;
    notifyTabContextPermissionStateChanged(enabled: boolean): void;
    notifyOsLocationPermissionStateChanged(enabled: boolean): void;
    notifyClosedCaptioningSettingChanged(enabled: boolean): void;
    notifyDefaultTabContextPermissionStateChanged(enabled: boolean): void;
    notifyActuationOnWebSettingChanged(enabled: boolean): void;
    notifyFocusedTabChanged(focusedTabData: (FocusedTabDataMojo)): void;
    notifyPanelActiveChange(panelActive: boolean): void;
    notifyManualResizeChanged(resizing: boolean): void;
    notifyBrowserIsOpenChanged(browserIsOpen: boolean): void;
    notifyInstanceActivationChanged(instanceIsActive: boolean): void;
    notifyOsHotkeyStateChanged(hotkey: string): void;
    notifyPinnedTabsChanged(tabData: TabDataMojo[]): void;
    notifyPinnedTabDataChanged(tabData: TabDataMojo): void;
    notifyZeroStateSuggestionsChanged(suggestions: ZeroStateSuggestionsV2Mojo, options: ZeroStateSuggestionsOptionsMojo): void;
    notifyActorTaskStateChanged(taskId: number, state: ActorTaskStateMojo): void;
    notifyTabDataChanged(tabData: TabDataMojo): void;
    requestViewChange(requestMojo: ViewChangeRequestMojo): void;
    notifyPageMetadataChanged(tabId: number, metadata: PageMetadataMojo | null): void;
    requestToShowCredentialSelectionDialog(request: SelectCredentialDialogRequestMojo): Promise<{
        response: SelectCredentialDialogResponseMojo;
    }>;
    requestToShowUserConfirmationDialog(request: UserConfirmationDialogRequestMojo): Promise<{
        response: UserConfirmationDialogResponseMojo;
    }>;
    requestToConfirmNavigation(request: NavigationConfirmationRequestMojo): Promise<{
        response: NavigationConfirmationResponseMojo;
    }>;
    notifyAdditionalContext(context: AdditionalContextMojo): void;
    notifyActOnWebCapabilityChanged(canActOnWeb: boolean): void;
    notifyOnboardingCompletedChanged(completed: boolean): void;
    requestToShowAutofillSuggestionsDialog(request: SelectAutofillSuggestionsDialogRequestMojo): Promise<{
        response: SelectAutofillSuggestionsDialogResponseMojo;
    }>;
}
