import type { CaptureRegionObserver, CaptureRegionResult as CaptureRegionResultMojo, PinCandidate as PinCandidateMojo, PinCandidatesObserver, WebClientHandlerInterface } from '../../glic.mojom-webui.js';
import { CaptureRegionErrorReason as CaptureRegionErrorReasonMojo, CaptureRegionObserverReceiver, PinCandidatesObserverReceiver } from '../../glic.mojom-webui.js';
import type { ActorTaskPauseReason, ActorTaskStopReason, ConversationInfo, DraggableArea, GetPinCandidatesOptions, Journal, OnResponseStoppedDetails, OpenSettingsOptions, Screenshot, ScrollToParams, TabContextOptions, TaskOptions, ViewChangedNotification, WebClientMode, ZeroStateSuggestions, ZeroStateSuggestionsOptions, ZeroStateSuggestionsV2 } from '../../glic_api/glic_api.js';
import { ResponseExtras } from '../post_message_transport.js';
import type { HostRequestTypes, RequestRequestType, RequestResponseType, ResumeActorTaskResultPrivate, RgbaImage, TabContextResultPrivate, TransferableException, WebClientInitialStatePrivate } from '../request_types.js';
import type { GatedSender } from './gated_sender.js';
import type { ApiHostEmbedder, GlicApiHost } from './glic_api_host.js';
type Promisify<T> = T extends void ? void : Promise<T>;
type HostMessageHandlerInterface = {
    [Property in keyof HostRequestTypes as string extends Property ? never : Property]: (payload: RequestRequestType<Property>, extras: ResponseExtras) => Promisify<RequestResponseType<Property>>;
};
/**
 * Handles all requests to the host.
 *
 * Each function is a message handler, automatically called when the host
 * receives a message with the corresponding request name.
 *
 * Any new state or function that's not a handler should be added to
 * `GlicApiHost`.
 */
export declare class HostMessageHandler implements HostMessageHandlerInterface {
    private handler;
    private sender;
    private embedder;
    private host;
    private receiver;
    constructor(handler: WebClientHandlerInterface, sender: GatedSender, embedder: ApiHostEmbedder, host: GlicApiHost);
    destroy(): void;
    glicBrowserWebClientCreated(_request: void, extras: ResponseExtras): Promise<{
        initialState: WebClientInitialStatePrivate;
    }>;
    glicBrowserWebClientInitialized(request: {
        success: boolean;
        exception?: TransferableException;
    }): void;
    glicBrowserCreateTab(request: {
        url: string;
        options: {
            openInBackground?: boolean;
            windowId?: string;
        };
    }): Promise<{
        tabData: {
            tabId: string;
            windowId: string;
            url: string;
            title: string | undefined;
        };
    } | {
        tabData?: undefined;
    }>;
    glicBrowserOpenGlicSettingsPage(request: {
        options?: OpenSettingsOptions;
    }): void;
    glicBrowserOpenPasswordManagerSettingsPage(): void;
    glicBrowserClosePanel(): void;
    glicBrowserClosePanelAndShutdown(): void;
    glicBrowserAttachPanel(): void;
    glicBrowserDetachPanel(): void;
    glicBrowserShowProfilePicker(): void;
    glicBrowserGetModelQualityClientId(): Promise<{
        modelQualityClientId: string;
    }>;
    glicBrowserSwitchConversation(request: {
        info?: ConversationInfo;
    }): Promise<{}>;
    glicBrowserRegisterConversation(request: {
        info: ConversationInfo;
    }): Promise<{}>;
    glicBrowserGetContextFromFocusedTab(request: {
        options: TabContextOptions;
    }, extras: ResponseExtras): Promise<{
        tabContextResult: TabContextResultPrivate;
    }>;
    glicBrowserGetContextFromTab(request: {
        tabId: string;
        options: TabContextOptions;
    }, extras: ResponseExtras): Promise<{
        tabContextResult: TabContextResultPrivate;
    }>;
    glicBrowserGetContextForActorFromTab(request: {
        tabId: string;
        options: TabContextOptions;
    }, extras: ResponseExtras): Promise<{
        tabContextResult: TabContextResultPrivate;
    }>;
    glicBrowserSetMaximumNumberOfPinnedTabs(request: {
        requestedMax: number;
    }): Promise<{
        effectiveMax: number;
    }>;
    glicBrowserCreateTask(request: {
        taskOptions?: TaskOptions;
    }): Promise<{
        taskId: number;
    }>;
    glicBrowserPerformActions(request: {
        actions: ArrayBuffer;
    }): Promise<{
        actionsResult: ArrayBuffer;
    }>;
    glicBrowserStopActorTask(request: {
        taskId: number;
        stopReason: ActorTaskStopReason;
    }): void;
    glicBrowserPauseActorTask(request: {
        taskId: number;
        pauseReason: ActorTaskPauseReason;
        tabId: string;
    }): void;
    glicBrowserResumeActorTask(request: {
        taskId: number;
        tabContextOptions: TabContextOptions;
    }, extras: ResponseExtras): Promise<{
        resumeActorTaskResult: ResumeActorTaskResultPrivate;
    }>;
    glicBrowserInterruptActorTask(request: {
        taskId: number;
    }): void;
    glicBrowserUninterruptActorTask(request: {
        taskId: number;
    }): void;
    glicBrowserCreateActorTab(request: {
        taskId: number;
        options: {
            initiatorTabId?: string;
            initiatorWindowId?: string;
            openInBackground?: boolean;
        };
    }): Promise<{
        tabData: {
            tabId: string;
            windowId: string;
            url: string;
            title: string | undefined;
        };
    } | {
        tabData?: undefined;
    }>;
    glicBrowserActivateTab(request: {
        tabId: string;
    }): void;
    glicBrowserResizeWindow(request: {
        size: {
            width: number;
            height: number;
        };
        options?: {
            durationMs?: number;
        };
    }): Promise<void>;
    glicBrowserEnableDragResize(request: {
        enabled: boolean;
    }): void;
    glicBrowserSubscribeToCaptureRegion(request: {
        observationId: number;
    }): void;
    glicBrowserUnsubscribeFromCaptureRegion(request: {
        observationId: number;
    }): void;
    glicBrowserCaptureScreenshot(_request: void, extras: ResponseExtras): Promise<{
        screenshot: Screenshot;
    }>;
    glicBrowserSetWindowDraggableAreas(request: {
        areas: DraggableArea[];
    }): Promise<void>;
    glicBrowserSetMinimumWidgetSize(request: {
        size: {
            width: number;
            height: number;
        };
    }): void;
    glicBrowserSetMicrophonePermissionState(request: {
        enabled: boolean;
    }): Promise<void>;
    glicBrowserSetLocationPermissionState(request: {
        enabled: boolean;
    }): Promise<void>;
    glicBrowserSetTabContextPermissionState(request: {
        enabled: boolean;
    }): Promise<void>;
    glicBrowserSetClosedCaptioningSetting(request: {
        enabled: boolean;
    }): Promise<void>;
    glicBrowserSetActuationOnWebSetting(request: {
        enabled: boolean;
    }): Promise<void>;
    glicBrowserGetUserProfileInfo(_request: void, extras: ResponseExtras): Promise<{
        profileInfo?: undefined;
    } | {
        profileInfo: Omit<import("../../glic.mojom-webui.js").UserProfileInfoMojoType, "avatarIcon"> & {
            avatarIcon: RgbaImage | undefined;
        };
    }>;
    glicBrowserRefreshSignInCookies(): Promise<{
        success: boolean;
    }>;
    glicBrowserSetContextAccessIndicator(request: {
        show: boolean;
    }): void;
    glicBrowserSetAudioDucking(request: {
        enabled: boolean;
    }): void;
    glicBrowserOnUserInputSubmitted(request: {
        mode: number;
    }): void;
    glicBrowserOnContextUploadStarted(): void;
    glicBrowserOnContextUploadCompleted(): void;
    glicBrowserOnReaction(request: {
        reactionType: number;
    }): void;
    glicBrowserOnResponseStarted(): void;
    glicBrowserOnResponseStopped(request: {
        details?: OnResponseStoppedDetails;
    }): void;
    glicBrowserOnSessionTerminated(): void;
    glicBrowserOnTurnCompleted(request: {
        model: number;
        duration: number;
    }): void;
    glicBrowserOnModelChanged(request: {
        model: number;
    }): void;
    glicBrowserOnRecordUseCounter(request: {
        counter: number;
    }): void;
    glicBrowserLogBeginAsyncEvent(request: {
        asyncEventId: number;
        taskId: number;
        event: string;
        details: string;
    }): void;
    glicBrowserLogEndAsyncEvent(request: {
        asyncEventId: number;
        details: string;
    }): void;
    glicBrowserLogInstantEvent(request: {
        taskId: number;
        event: string;
        details: string;
    }): void;
    glicBrowserJournalClear(): void;
    glicBrowserJournalSnapshot(request: {
        clear: boolean;
    }, extras: ResponseExtras): Promise<{
        journal: Journal;
    }>;
    glicBrowserJournalStart(request: {
        maxBytes: number;
        captureScreenshots: boolean;
    }): void;
    glicBrowserJournalStop(): void;
    glicBrowserJournalRecordFeedback(request: {
        positive: boolean;
        reason: string;
    }): void;
    glicBrowserOnResponseRated(request: {
        positive: boolean;
    }): void;
    glicBrowserOnClosedCaptionsShown(): void;
    glicBrowserScrollTo(request: {
        params: ScrollToParams;
    }): Promise<{}>;
    glicBrowserSetSyntheticExperimentState(request: {
        trialName: string;
        groupName: string;
    }): void;
    glicBrowserOpenOsPermissionSettingsMenu(request: {
        permission: string;
    }): void | Promise<void>;
    glicBrowserGetOsMicrophonePermissionStatus(): Promise<{
        enabled: boolean;
    }>;
    glicBrowserPinTabs(request: {
        tabIds: string[];
    }): Promise<{
        pinnedAll: boolean;
    }>;
    glicBrowserUnpinTabs(request: {
        tabIds: string[];
    }): Promise<{
        unpinnedAll: boolean;
    }>;
    glicBrowserUnpinAllTabs(): void;
    glicBrowserSubscribeToPinCandidates(request: {
        options: GetPinCandidatesOptions;
        observationId: number;
    }): void;
    glicBrowserUnsubscribeFromPinCandidates(request: {
        observationId: number;
    }): void;
    glicBrowserGetZeroStateSuggestionsForFocusedTab(request: {
        isFirstRun?: boolean;
    }): Promise<{
        suggestions?: ZeroStateSuggestions;
    }>;
    glicBrowserGetZeroStateSuggestionsAndSubscribe(request: {
        hasActiveSubscription: boolean;
        options: ZeroStateSuggestionsOptions;
    }): Promise<{
        suggestions?: ZeroStateSuggestionsV2;
    }>;
    glicBrowserDropScrollToHighlight(): void;
    glicBrowserMaybeRefreshUserStatus(): void;
    glicBrowserOnViewChanged(request: {
        notification: ViewChangedNotification;
    }): void;
    glicBrowserSubscribeToPageMetadata(request: {
        tabId: string;
        names: string[];
    }): Promise<{
        success: boolean;
    }>;
    glicBrowserOnModeChange(request: {
        newMode: WebClientMode;
    }): void;
    glicBrowserSetOnboardingCompleted(): void;
    glicBrowserLoadAndExtractContent(_request: {
        urls: string[];
        options: TabContextOptions[];
    }, _extras: ResponseExtras): Promise<{
        results: TabContextResultPrivate[];
    }>;
}
export declare class CaptureRegionObserverImpl implements CaptureRegionObserver {
    private sender;
    private handler;
    observationId: number;
    receiver?: CaptureRegionObserverReceiver;
    constructor(sender: GatedSender, handler: WebClientHandlerInterface, observationId: number);
    destroy(): void;
    private connectToSource;
    onUpdate(result: CaptureRegionResultMojo | null, reason: CaptureRegionErrorReasonMojo | null): void;
}
export declare class PinCandidatesObserverImpl implements PinCandidatesObserver {
    private sender;
    private handler;
    private options;
    observationId: number;
    receiver?: PinCandidatesObserverReceiver;
    constructor(sender: GatedSender, handler: WebClientHandlerInterface, options: GetPinCandidatesOptions, observationId: number);
    disconnectFromSource(): void;
    connectToSource(): void;
    onPinCandidatesChanged(candidates: PinCandidateMojo[]): void;
}
export {};
