import type { BrowserProxy } from '../../browser_proxy.js';
import type { WebClientInitialState } from '../../glic.mojom-webui.js';
import type { ObservableValueReadOnly } from '../../observable.js';
import type { PostMessageRequestHandler, ResponseExtras } from './../post_message_transport.js';
import { PostMessageRequestReceiver, PostMessageRequestSender } from './../post_message_transport.js';
import { GatedSender } from './gated_sender.js';
import type { CaptureRegionObserverImpl, PinCandidatesObserverImpl } from './host_from_client.js';
export declare enum WebClientState {
    UNINITIALIZED = 0,
    RESPONSIVE = 1,
    UNRESPONSIVE = 2,
    ERROR = 3
}
declare enum PanelOpenState {
    OPEN = 0,
    CLOSED = 1
}
export declare enum DetailedWebClientState {
    BOOTSTRAP_PENDING = 0,
    WEB_CLIENT_NOT_CREATED = 1,
    WEB_CLIENT_INITIALIZE_FAILED = 2,
    WEB_CLIENT_NOT_INITIALIZED = 3,
    TEMPORARY_UNRESPONSIVE = 4,
    PERMANENT_UNRESPONSIVE = 5,
    RESPONSIVE = 6,
    RESPONSIVE_INACTIVE = 7,
    UNRESPONSIVE_INACTIVE = 8,
    MOJO_PIPE_CLOSED_UNEXPECTEDLY = 9,
    MAX_VALUE = 9
}
export interface ApiHostEmbedder {
    onGuestResizeRequest(size: {
        width: number;
        height: number;
    }): void;
    enableDragResize(enabled: boolean): void;
    webClientReady(): void;
}
export declare class GlicApiCommunicator implements PostMessageRequestHandler {
    private embeddedOrigin;
    private windowProxy;
    private senderId;
    readonly postMessageReceiver: PostMessageRequestReceiver;
    readonly postMessageSender: PostMessageRequestSender;
    private bootstrapPingIntervalId;
    private loggingEnabled;
    private host?;
    private hostPromise;
    constructor(embeddedOrigin: string, windowProxy: WindowProxy);
    destroy(): void;
    setHost(host: GlicApiHost): void;
    contentLoaded(): void;
    handleRawRequest(type: string, payload: any, extras: ResponseExtras): Promise<{
        payload: any;
    } | undefined>;
    onRequestReceived(_type: string): void;
    onRequestHandlerException(_type: string): void;
    onRequestCompleted(_type: string): void;
    private stopBootstrapPing;
    private bootstrapPing;
}
/**
 * The host side of the Glic API.
 *
 * Its primary job is to route calls between the client (over postMessage) and
 * the browser (over Mojo).
 */
export declare class GlicApiHost implements PostMessageRequestHandler {
    private browserProxy;
    private messageHandler;
    sender: GatedSender;
    private enableApiActivationGating;
    panelIsActive: boolean;
    private handler;
    private webClientErrorTimer;
    private webClientState;
    private waitingOnPanelWillOpenValue;
    private clientActiveObs;
    private panelOpenState;
    private instanceIsActive;
    private hasShownDebuggerAttachedWarning;
    private loggingEnabled;
    detailedWebClientState: DetailedWebClientState;
    pinCandidatesObserver?: PinCandidatesObserverImpl;
    captureRegionObserver?: CaptureRegionObserverImpl;
    constructor(browserProxy: BrowserProxy, communicator: GlicApiCommunicator, embedder: ApiHostEmbedder);
    destroy(): void;
    setInitialState(initialState: WebClientInitialState): void;
    updateSenderActive(): void;
    shouldGateRequests(): boolean;
    waitingOnPanelWillOpen(): boolean;
    setWaitingOnPanelWillOpen(value: boolean): void;
    panelOpenStateChanged(state: PanelOpenState): void;
    setInstanceIsActive(instanceIsActive: boolean): void;
    private isClientActive;
    webClientInitialized(): void;
    webClientInitializeFailed(): void;
    setWebClientState(state: WebClientState): void;
    getWebClientState(): ObservableValueReadOnly<WebClientState>;
    getDetailedWebClientState(): DetailedWebClientState;
    responsiveCheckLoop(): Promise<void>;
    private shouldAllowUnresponsiveClient;
    startWebClientErrorTimer(): void;
    openLinkInPopup(url: string, initialWidth: number, initialHeight: number): void;
    openLinkInNewTab(url: string): Promise<void>;
    shouldAllowMediaPermissionRequest(): Promise<boolean>;
    shouldAllowGeolocationPermissionRequest(): Promise<boolean>;
    handleRawRequest(type: string, payload: any, extras: ResponseExtras): Promise<{
        payload: any;
    } | undefined>;
    onRequestReceived(type: string): void;
    onRequestHandlerException(type: string): void;
    onRequestCompleted(type: string): void;
    reportRequestCountEvent(requestType: string, event: GlicRequestEvent): void;
}
declare enum GlicRequestEvent {
    REQUEST_RECEIVED = 0,
    RESPONSE_SENT = 1,
    REQUEST_HANDLER_EXCEPTION = 2,
    REQUEST_RECEIVED_WHILE_HIDDEN = 3,
    MAX_VALUE = 3
}
export {};
