import type { PostMessageRequestSender } from 'glic_api_impl/post_message_transport.js';
import type { AllRequestTypesWithoutReturn, AllRequestTypesWithReturn, RequestRequestType, WebClientRequestTypes } from 'glic_api_impl/request_types.js';
type IsGatedRequest<T extends keyof WebClientRequestTypes> = 'backgroundAllowed' extends keyof WebClientRequestTypes[T] ? false : true;
export type UngatedWebClientRequestTypes = {
    [Property in keyof WebClientRequestTypes as IsGatedRequest<Property> extends true ? never : Property]: true;
};
export declare class GatedSender {
    private sender;
    private sequenceNumber;
    private messageQueue;
    private keyedMessages;
    private shouldGateRequests;
    constructor(sender: PostMessageRequestSender);
    isGating(): boolean;
    getRawSender(): PostMessageRequestSender;
    setGating(shouldGateRequests: boolean): void;
    sendWhenActive<T extends keyof AllRequestTypesWithoutReturn>(requestType: T, request: RequestRequestType<T>, transfer?: Transferable[]): void;
    sendIfActiveOrDrop<T extends keyof AllRequestTypesWithoutReturn>(requestType: T, request: RequestRequestType<T>, transfer?: Transferable[]): void;
    sendLatestWhenActive<T extends keyof AllRequestTypesWithoutReturn>(requestType: T, request: RequestRequestType<T>, transfer?: Transferable[], additionalKey?: string): void;
    requestNoResponse<T extends keyof Omit<UngatedWebClientRequestTypes, keyof AllRequestTypesWithReturn>>(requestType: T, request: RequestRequestType<T>, transfer?: Transferable[]): void;
    requestWithResponse<T extends keyof UngatedWebClientRequestTypes>(requestType: T, request: RequestRequestType<T>, transfer?: Transferable[]): Promise<import("glic_api_impl/request_types.js").RequestResponseType<T>>;
}
export {};
