import type { BigBuffer } from '//resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js';
import type { TimeDelta } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import type { BitmapN32 } from '//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js';
import type { Origin } from '//resources/mojo/url/mojom/origin.mojom-webui.js';
import type { Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
import type { PageMetadata as PageMetadataMojo } from '../../ai_page_content_metadata.mojom-webui.js';
import type { AnnotatedPageData as AnnotatedPageDataMojo, CaptureRegionResult as CaptureRegionResultMojo, ContextData as ContextDataMojo, ConversationInfo as ConversationInfoMojo, FocusedTabData as FocusedTabDataMojo, GetPinCandidatesOptions as GetPinCandidatesOptionsMojo, GetTabContextOptions as TabContextOptionsMojo, HostCapability as HostCapabilityMojo, PanelOpeningData as PanelOpeningDataMojo, PanelState as PanelStateMojo, PdfDocumentData as PdfDocumentDataMojo, Platform as PlatformMojo, Screenshot as ScreenshotMojo, TabContext as TabContextMojo, TabData as TabDataMojo, WebPageData as WebPageDataMojo } from '../../glic.mojom-webui.js';
import { WebClientMode as WebClientModeMojo } from '../../glic.mojom-webui.js';
import type { CaptureRegionResult, ConversationInfo, GetPinCandidatesOptions, HostCapability, PageMetadata, PanelOpeningData, PanelState, Platform, Screenshot, TabContextOptions, TaskOptions, WebPageData } from '../../glic_api/glic_api.js';
import { WebClientMode } from '../../glic_api/glic_api.js';
import type { NavigationConfirmationRequest as NavigationConfirmationRequestMojo, NavigationConfirmationResponse as NavigationConfirmationResponseMojo, SelectAutofillSuggestionsDialogRequest as SelectAutofillSuggestionsDialogRequestMojo, SelectAutofillSuggestionsDialogResponse as SelectAutofillSuggestionsDialogResponseMojo, SelectCredentialDialogRequest as SelectCredentialDialogRequestMojo, SelectCredentialDialogResponse as SelectCredentialDialogResponseMojo, TaskOptions as TaskOptionsMojo, UserConfirmationDialogRequest as UserConfirmationDialogRequestMojo, UserConfirmationDialogResponse as UserConfirmationDialogResponseMojo } from './../../actor_webui.mojom-webui.js';
import type { ResponseExtras } from './../post_message_transport.js';
import type { AnnotatedPageDataPrivate, FocusedTabDataPrivate, NavigationConfirmationRequestPrivate, NavigationConfirmationResponsePrivate, PdfDocumentDataPrivate, ResumeActorTaskResultPrivate, RgbaImage, SelectAutofillSuggestionsDialogRequestPrivate, SelectAutofillSuggestionsDialogResponsePrivate, SelectCredentialDialogRequestPrivate, SelectCredentialDialogResponsePrivate, TabContextResultPrivate, TabDataPrivate, UserConfirmationDialogRequestPrivate, UserConfirmationDialogResponsePrivate } from './../request_types.js';
export declare function idToClient(windowId: number): string;
export declare function idToClient(windowId: number | null): string | undefined;
export declare function idFromClient(windowId: string): number;
export declare function idFromClient(windowId: string | undefined): number | null;
export declare function screenshotToClient(screenshot: ScreenshotMojo | null, extras: ResponseExtras): Screenshot | undefined;
export declare function contextDataToClient(data: ContextDataMojo, extras: ResponseExtras): {
    mimeType: string;
    data: ArrayBuffer;
} | undefined;
export declare function webPageDataToClient(webPageData: WebPageDataMojo | null): WebPageData | undefined;
export declare function pdfDocumentDataToClient(pdfDocumentData: PdfDocumentDataMojo | null, extras: ResponseExtras): PdfDocumentDataPrivate | undefined;
export declare function annotatedPageDataToClient(annotatedPageData: AnnotatedPageDataMojo | null, extras: ResponseExtras): AnnotatedPageDataPrivate | undefined;
export declare function optionalToClient<T>(value: T | null): (T & {}) | undefined;
export declare function optionalFromClient<T>(value: T | undefined): (T & {}) | null;
export declare function urlToClient(url: Url): string;
export declare function urlToClient(url: Url | null): string | undefined;
export declare function urlFromClient(url: string): Url;
export declare function originToClient(origin: Origin): string;
export declare function originToClient(origin: Origin | null): string | undefined;
export declare function tabDataToClient(tabData: TabDataMojo, extras: ResponseExtras): TabDataPrivate;
export declare function tabDataToClient(tabData: TabDataMojo | null, extras: ResponseExtras): TabDataPrivate | undefined;
export declare function focusedTabDataToClient(focusedTabData: FocusedTabDataMojo, extras: ResponseExtras): FocusedTabDataPrivate;
export declare function getArrayBufferFromBigBuffer(bigBuffer: BigBuffer): ArrayBuffer | undefined;
export declare function bitmapN32ToRGBAImage(bitmap: BitmapN32): RgbaImage | undefined;
export declare function panelOpeningDataToClient(panelOpeningData: PanelOpeningDataMojo): PanelOpeningData;
export declare function conversationInfoToClient(conversationInfo: ConversationInfoMojo): ConversationInfo;
export declare function panelStateToClient(panelState: PanelStateMojo): PanelState;
export declare function pageMetadataToClient(metadata: PageMetadataMojo | null): PageMetadata | null;
/** Takes a time value in milliseconds and converts to a Mojo TimeDelta. */
export declare function timeDeltaFromClient(durationMs?: number): TimeDelta;
export declare function tabContextToClient(tabContext: TabContextMojo, extras: ResponseExtras): TabContextResultPrivate;
export declare function resumeActorTaskResultToClient(tabContext: TabContextMojo, actionResult: number, extras: ResponseExtras): ResumeActorTaskResultPrivate;
export declare function tabContextOptionsFromClient(options: TabContextOptions): TabContextOptionsMojo;
export declare function getPinCandidatesOptionsFromClient(options: GetPinCandidatesOptions): GetPinCandidatesOptionsMojo;
export declare function byteArrayFromClient(buffer: ArrayBuffer): number[];
export declare function hostCapabilitiesToClient(capabilities: HostCapabilityMojo[]): HostCapability[];
export declare function platformToClient(platform: PlatformMojo): Platform;
export declare function selectCredentialDialogResponseToMojo(response: SelectCredentialDialogResponsePrivate): SelectCredentialDialogResponseMojo;
export declare function selectCredentialDialogRequestToClient(request: SelectCredentialDialogRequestMojo): SelectCredentialDialogRequestPrivate;
export declare function userConfirmationDialogRequestToClient(request: UserConfirmationDialogRequestMojo): UserConfirmationDialogRequestPrivate;
export declare function userConfirmationDialogResponseToMojo(response: UserConfirmationDialogResponsePrivate): UserConfirmationDialogResponseMojo;
export declare function navigationConfirmationRequestToClient(request: NavigationConfirmationRequestMojo): NavigationConfirmationRequestPrivate;
export declare function navigationConfirmationResponseToMojo(response: NavigationConfirmationResponsePrivate): NavigationConfirmationResponseMojo;
export declare function selectAutofillSuggestionsDialogRequestToClient(request: SelectAutofillSuggestionsDialogRequestMojo): SelectAutofillSuggestionsDialogRequestPrivate;
export declare function selectAutofillSuggestionsDialogResponseToMojo(response: SelectAutofillSuggestionsDialogResponsePrivate): SelectAutofillSuggestionsDialogResponseMojo;
export declare function taskOptionsToMojo(taskOptions?: TaskOptions): TaskOptionsMojo | null;
export declare function webClientModeToMojo(mode: WebClientMode | undefined): WebClientModeMojo;
export declare function captureRegionResultToClient(result: CaptureRegionResultMojo | null): CaptureRegionResult | undefined;
