import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { NavigationConfirmationRequest as actor_webui_mojom_NavigationConfirmationRequest, NavigationConfirmationResponse as actor_webui_mojom_NavigationConfirmationResponse, SelectAutofillSuggestionsDialogRequest as actor_webui_mojom_SelectAutofillSuggestionsDialogRequest, SelectAutofillSuggestionsDialogResponse as actor_webui_mojom_SelectAutofillSuggestionsDialogResponse, SelectCredentialDialogRequest as actor_webui_mojom_SelectCredentialDialogRequest, SelectCredentialDialogResponse as actor_webui_mojom_SelectCredentialDialogResponse, TaskOptions as actor_webui_mojom_TaskOptions, UserConfirmationDialogRequest as actor_webui_mojom_UserConfirmationDialogRequest, UserConfirmationDialogResponse as actor_webui_mojom_UserConfirmationDialogResponse } from './actor_webui.mojom-webui.js';
import { PageMetadata as blink_mojom_PageMetadata } from './ai_page_content_metadata.mojom-webui.js';
import { ContentSettingsType as contentSettings_mojom_ContentSettingsType } from './content_settings_types.mojom-webui.js';
import { BigBuffer as mojoBase_mojom_BigBuffer } from '//resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js';
import { ProtoWrapper as mojoBase_mojom_ProtoWrapper } from '//resources/mojo/mojo/public/mojom/base/proto_wrapper.mojom-webui.js';
import { TimeDelta as mojoBase_mojom_TimeDelta } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { UnguessableToken as mojoBase_mojom_UnguessableToken } from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';
import { Version as mojoBase_mojom_Version } from '//resources/mojo/mojo/public/mojom/base/version.mojom-webui.js';
import { BitmapN32 as skia_mojom_BitmapN32 } from '//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js';
import { Rect as gfx_mojom_Rect, Size as gfx_mojom_Size } from '//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js';
import { Origin as url_mojom_Origin } from '//resources/mojo/url/mojom/origin.mojom-webui.js';
import { Url as url_mojom_Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export declare const ProfileReadyStateSpec: {
    $: mojo.internal.MojomType;
};
export declare enum ProfileReadyState {
    MIN_VALUE = 0,
    MAX_VALUE = 4,
    kUnknownError = 0,
    kSignInRequired = 1,
    kReady = 2,
    kIneligible = 3,
    kDisabledByAdmin = 4
}
export declare const WebUiStateSpec: {
    $: mojo.internal.MojomType;
};
export declare enum WebUiState {
    MIN_VALUE = 0,
    MAX_VALUE = 12,
    kUninitialized = 0,
    kBeginLoad = 1,
    kShowLoading = 2,
    kHoldLoading = 3,
    kFinishLoading = 4,
    kError = 5,
    kOffline = 6,
    kUnavailable = 7,
    kReady = 8,
    kUnresponsive = 9,
    kSignIn = 10,
    kGuestError = 11,
    kDisabledByAdmin = 12
}
export declare const MetricUserInputReactionTypeSpec: {
    $: mojo.internal.MojomType;
};
export declare enum MetricUserInputReactionType {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kUnknown = 0,
    kCanned = 1,
    kModel = 2
}
export declare const PrepareForClientResultSpec: {
    $: mojo.internal.MojomType;
};
export declare enum PrepareForClientResult {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kSuccess = 0,
    kErrorResyncingCookies = 1,
    kRequiresSignIn = 2
}
export declare const PerformActionsErrorReasonSpec: {
    $: mojo.internal.MojomType;
};
export declare enum PerformActionsErrorReason {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kUnknown = 0,
    kInvalidProto = 1,
    kMissingTaskId = 2
}
export declare const CreateTaskErrorReasonSpec: {
    $: mojo.internal.MojomType;
};
export declare enum CreateTaskErrorReason {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kUnknown = 0,
    kTaskSystemUnavailable = 1
}
export declare const ActorTaskStateSpec: {
    $: mojo.internal.MojomType;
};
export declare enum ActorTaskState {
    MIN_VALUE = 0,
    MAX_VALUE = 4,
    kUnknown = 0,
    kIdle = 1,
    kActing = 2,
    kPaused = 3,
    kStopped = 4
}
export declare const ActorTaskPauseReasonSpec: {
    $: mojo.internal.MojomType;
};
export declare enum ActorTaskPauseReason {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kPausedByModel = 0,
    kPausedByUser = 1
}
export declare const ActorTaskStopReasonSpec: {
    $: mojo.internal.MojomType;
};
export declare enum ActorTaskStopReason {
    MIN_VALUE = 0,
    MAX_VALUE = 4,
    kTaskComplete = 0,
    kStoppedByUser = 1,
    kModelError = 2,
    kUserStartedNewChat = 3,
    kUserLoadedPreviousChat = 4
}
export declare const CaptureScreenshotErrorReasonSpec: {
    $: mojo.internal.MojomType;
};
export declare enum CaptureScreenshotErrorReason {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kUnknown = 0,
    kScreenCaptureRequestThrottled = 1,
    kUserCancelledScreenPickerDialog = 2
}
export declare const PlatformSpec: {
    $: mojo.internal.MojomType;
};
export declare enum Platform {
    MIN_VALUE = 0,
    MAX_VALUE = 4,
    kUnknown = 0,
    kMacOS = 1,
    kWindows = 2,
    kLinux = 3,
    kChromeOS = 4
}
export declare const ScrollToErrorReasonSpec: {
    $: mojo.internal.MojomType;
};
export declare enum ScrollToErrorReason {
    MIN_VALUE = 0,
    MAX_VALUE = 8,
    kNotSupported = 0,
    kNewerScrollToCall = 1,
    kNoFocusedTab = 2,
    kNoMatchFound = 3,
    kFocusedTabChangedOrNavigated = 4,
    kNoMatchingDocument = 5,
    kSearchRangeInvalid = 6,
    kTabContextPermissionDisabled = 7,
    kDroppedByWebClient = 8
}
export declare const SwitchConversationErrorReasonSpec: {
    $: mojo.internal.MojomType;
};
export declare enum SwitchConversationErrorReason {
    MIN_VALUE = 0,
    MAX_VALUE = 0,
    kUnknown = 0
}
export declare const RegisterConversationErrorReasonSpec: {
    $: mojo.internal.MojomType;
};
export declare enum RegisterConversationErrorReason {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kUnknown = 0,
    kInstanceAlreadyHasConversationId = 1
}
export declare const PanelStateKindSpec: {
    $: mojo.internal.MojomType;
};
export declare enum PanelStateKind {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kHidden = 0,
    kDetached = 1,
    kAttached = 2
}
export declare const InvocationSourceSpec: {
    $: mojo.internal.MojomType;
};
export declare enum InvocationSource {
    MIN_VALUE = 0,
    MAX_VALUE = 14,
    kOsButton = 0,
    kOsButtonMenu = 1,
    kOsHotkey = 2,
    kTopChromeButton = 3,
    kFre = 4,
    kProfilePicker = 5,
    kNudge = 6,
    kThreeDotsMenu = 7,
    kUnsupported = 8,
    kWhatsNew = 9,
    kAfterSignIn = 10,
    kSharedTab = 11,
    kActorTaskIcon = 12,
    kSharedImage = 13,
    kHandoffButton = 14
}
export declare const WebClientModeSpec: {
    $: mojo.internal.MojomType;
};
export declare enum WebClientMode {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kUnknown = 2,
    kText = 0,
    kAudio = 1
}
export declare const WebClientModelSpec: {
    $: mojo.internal.MojomType;
};
export declare enum WebClientModel {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kDefault = 0,
    kActor = 1
}
export declare const WebUseCounterSpec: {
    $: mojo.internal.MojomType;
};
export declare enum WebUseCounter {
    MIN_VALUE = 0,
    MAX_VALUE = 3,
    kDefault = 0,
    kSubmitPromptWithAutoMode = 1,
    kTaskInterruptedForUserConfirmation = 2,
    kTaskInterruptedForUserClarification = 3
}
export declare const ResponseStopCauseSpec: {
    $: mojo.internal.MojomType;
};
export declare enum ResponseStopCause {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kUnknown = 0,
    kUser = 1,
    kOther = 2
}
export declare const CaptureRegionErrorReasonSpec: {
    $: mojo.internal.MojomType;
};
export declare enum CaptureRegionErrorReason {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kUnknown = 0,
    kNoFocusableTab = 1
}
export declare const SettingsPageFieldSpec: {
    $: mojo.internal.MojomType;
};
export declare enum SettingsPageField {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kNone = 0,
    kOsHotkey = 1,
    kOsEntrypointToggle = 2
}
export declare const HostCapabilitySpec: {
    $: mojo.internal.MojomType;
};
export declare enum HostCapability {
    MIN_VALUE = 0,
    MAX_VALUE = 5,
    kScrollToPdf = 0,
    kResetSizeAndLocationOnOpen = 1,
    kGetModelQualityClientId = 2,
    kMultiInstance = 3,
    kTrustFirstOnboardingArm1 = 4,
    kTrustFirstOnboardingArm2 = 5
}
export declare const CurrentViewSpec: {
    $: mojo.internal.MojomType;
};
export declare enum CurrentView {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kConversation = 0,
    kActuation = 1
}
export type PagePendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
export declare class PagePendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<Page> {
    handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
    constructor(handle: MojoHandle | PagePendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageInterface {
    intentToShow(): void;
    setProfileReadyState(readyState: ProfileReadyState): void;
    updatePageState(panelStateKind: PanelStateKind): void;
}
export declare class PageRemote implements PageInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PagePendingReceiverEndpoint);
    intentToShow(): void;
    setProfileReadyState(readyState: ProfileReadyState): void;
    updatePageState(panelStateKind: PanelStateKind): void;
}
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageRemote, PagePendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageInterface);
}
export declare class Page {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageRemote;
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageRemote, PagePendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    intentToShow: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setProfileReadyState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    updatePageState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type PageHandlerFactoryPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
export declare class PageHandlerFactoryPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {
    handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
    constructor(handle: MojoHandle | PageHandlerFactoryPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageHandlerFactoryInterface {
    createPageHandler(receiver: PageHandlerPendingReceiver, page: PageRemote): void;
}
export declare class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PageHandlerFactoryPendingReceiverEndpoint);
    createPageHandler(receiver: PageHandlerPendingReceiver, page: PageRemote): void;
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageHandlerFactoryReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageHandlerFactoryInterface);
}
export declare class PageHandlerFactory {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageHandlerFactoryRemote;
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageHandlerFactoryCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type PageHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
export declare class PageHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
    constructor(handle: MojoHandle | PageHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageHandlerInterface {
    createWebClient(webClientReceiver: WebClientHandlerPendingReceiver): void;
    prepareForClient(): Promise<{
        result: PrepareForClientResult;
    }>;
    webviewCommitted(url: url_mojom_Url): void;
    closePanel(): Promise<void>;
    openProfilePickerAndClosePanel(): void;
    openDisabledByAdminLinkAndClosePanel(): void;
    signInAndClosePanel(): void;
    resizeWidget(size: gfx_mojom_Size, duration: mojoBase_mojom_TimeDelta): Promise<void>;
    enableDragResize(enabled: boolean): void;
    webUiStateChanged(newState: WebUiState): void;
}
export declare class PageHandlerRemote implements PageHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PageHandlerPendingReceiverEndpoint);
    createWebClient(webClientReceiver: WebClientHandlerPendingReceiver): void;
    prepareForClient(): Promise<{
        result: PrepareForClientResult;
    }>;
    webviewCommitted(url: url_mojom_Url): void;
    closePanel(): Promise<void>;
    openProfilePickerAndClosePanel(): void;
    openDisabledByAdminLinkAndClosePanel(): void;
    signInAndClosePanel(): void;
    resizeWidget(size: gfx_mojom_Size, duration: mojoBase_mojom_TimeDelta): Promise<void>;
    enableDragResize(enabled: boolean): void;
    webUiStateChanged(newState: WebUiState): void;
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerRemote, PageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageHandlerInterface);
}
export declare class PageHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageHandlerRemote;
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerRemote, PageHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    createWebClient: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    prepareForClient: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    webviewCommitted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    closePanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    openProfilePickerAndClosePanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    openDisabledByAdminLinkAndClosePanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    signInAndClosePanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    resizeWidget: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    enableDragResize: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    webUiStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type PinCandidatesObserverPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PinCandidatesObserverPendingReceiver>;
export declare class PinCandidatesObserverPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<PinCandidatesObserver> {
    handle: mojo.internal.interfaceSupport.Endpoint<PinCandidatesObserverPendingReceiver>;
    constructor(handle: MojoHandle | PinCandidatesObserverPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PinCandidatesObserverInterface {
    onPinCandidatesChanged(candidates: PinCandidate[]): void;
}
export declare class PinCandidatesObserverRemote implements PinCandidatesObserverInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PinCandidatesObserverPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PinCandidatesObserverPendingReceiverEndpoint);
    onPinCandidatesChanged(candidates: PinCandidate[]): void;
}
/**
 * An object which receives request messages for the PinCandidatesObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PinCandidatesObserverReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PinCandidatesObserverRemote, PinCandidatesObserverPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PinCandidatesObserverInterface);
}
export declare class PinCandidatesObserver {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PinCandidatesObserverRemote;
}
/**
 * An object which receives request messages for the PinCandidatesObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PinCandidatesObserverCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PinCandidatesObserverRemote, PinCandidatesObserverPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    onPinCandidatesChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type WebClientHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<WebClientHandlerPendingReceiver>;
export declare class WebClientHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<WebClientHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<WebClientHandlerPendingReceiver>;
    constructor(handle: MojoHandle | WebClientHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface WebClientHandlerInterface {
    webClientCreated(webClient: WebClientRemote): Promise<{
        initialState: WebClientInitialState;
    }>;
    webClientInitialized(): void;
    webClientInitializeFailed(): void;
    createTab(url: url_mojom_Url, openInBackground: boolean, windowId: (number | null)): Promise<{
        tabData: (TabData | null);
    }>;
    openLinkInPopup(url: url_mojom_Url, popupWidth: number, popupHeight: number): void;
    openGlicSettingsPage(options: OpenSettingsOptions): void;
    openPasswordManagerSettingsPage(): void;
    closePanel(): void;
    closePanelAndShutdown(): void;
    attachPanel(): void;
    detachPanel(): void;
    onModeChange(newMode: WebClientMode): void;
    showProfilePicker(): void;
    getModelQualityClientId(): Promise<{
        modelQualityClientId: string;
    }>;
    getContextFromFocusedTab(options: GetTabContextOptions): Promise<{
        result: GetContextResult;
    }>;
    getContextFromTab(tabId: number, options: GetTabContextOptions): Promise<{
        result: GetContextResult;
    }>;
    getContextForActorFromTab(tabId: number, options: GetTabContextOptions): Promise<{
        result: GetContextResult;
    }>;
    setMaximumNumberOfPinnedTabs(requestedMax: number): Promise<{
        effectiveMax: number;
    }>;
    pinTabs(tabIds: number[]): Promise<{
        pinnedAll: boolean;
    }>;
    unpinTabs(tabIds: number[]): Promise<{
        unpinnedAll: boolean;
    }>;
    unpinAllTabs(): void;
    subscribeToPinCandidates(options: GetPinCandidatesOptions, observer: PinCandidatesObserverRemote): void;
    createTask(taskOptions: (actor_webui_mojom_TaskOptions | null)): Promise<number>;
    performActions(actionsProto: number[]): Promise<mojoBase_mojom_ProtoWrapper>;
    stopActorTask(taskId: number, stopReason: ActorTaskStopReason): void;
    pauseActorTask(taskId: number, pauseReason: ActorTaskPauseReason, tabId: (number | null)): void;
    resumeActorTask(taskId: number, contextOptions: GetTabContextOptions): Promise<{
        result: GetContextResultWithActionResultCode;
    }>;
    interruptActorTask(taskId: number): void;
    uninterruptActorTask(taskId: number): void;
    createActorTab(taskId: number, openInBackground: boolean, initiatorTabId: (number | null), initiatorWindowId: (number | null)): Promise<{
        tabData: (TabData | null);
    }>;
    activateTab(taskId: number): void;
    resizeWidget(size: gfx_mojom_Size, duration: mojoBase_mojom_TimeDelta): Promise<void>;
    captureScreenshot(): Promise<{
        result: CaptureScreenshotResult;
    }>;
    captureRegion(observer: CaptureRegionObserverRemote): void;
    setAudioDucking(enable: boolean): Promise<{
        result: boolean;
    }>;
    setPanelDraggableAreas(draggableAreas: gfx_mojom_Rect[]): Promise<void>;
    setMinimumPanelSize(size: gfx_mojom_Size): void;
    setMicrophonePermissionState(enabled: boolean): Promise<void>;
    setLocationPermissionState(enabled: boolean): Promise<void>;
    setTabContextPermissionState(enabled: boolean): Promise<void>;
    setClosedCaptioningSetting(enabled: boolean): Promise<void>;
    setActuationOnWebSetting(enabled: boolean): Promise<void>;
    shouldAllowMediaPermissionRequest(): Promise<{
        isAllowed: boolean;
    }>;
    shouldAllowGeolocationPermissionRequest(): Promise<{
        isAllowed: boolean;
    }>;
    setContextAccessIndicator(enabled: boolean): void;
    getUserProfileInfo(): Promise<{
        profileInfo: (UserProfileInfo | null);
    }>;
    syncCookies(): Promise<{
        success: boolean;
    }>;
    logBeginAsyncEvent(eventAsyncId: bigint, taskId: number, event: string, details: string): void;
    logEndAsyncEvent(eventAsyncId: bigint, details: string): void;
    logInstantEvent(taskId: number, event: string, details: string): void;
    journalClear(): void;
    journalSnapshot(clearJournal: boolean): Promise<{
        journal: Journal;
    }>;
    journalStart(maxBytes: bigint, captureScreenshots: boolean): void;
    journalStop(): void;
    journalRecordFeedback(positive: boolean, reason: string): void;
    onUserInputSubmitted(mode: WebClientMode): void;
    onContextUploadStarted(): void;
    onContextUploadCompleted(): void;
    onReaction(reactionType: MetricUserInputReactionType): void;
    onResponseStarted(): void;
    onResponseStopped(details: OnResponseStoppedDetails): void;
    onSessionTerminated(): void;
    onTurnCompleted(model: WebClientModel, duration: mojoBase_mojom_TimeDelta): void;
    onModelChanged(model: WebClientModel): void;
    onRecordUseCounter(counter: number): void;
    onResponseRated(positive: boolean): void;
    onClosedCaptionsShown(): void;
    scrollTo(params: ScrollToParams): Promise<{
        errorReason: (ScrollToErrorReason | null);
    }>;
    dropScrollToHighlight(): void;
    setSyntheticExperimentState(trialName: string, groupName: string): void;
    openOsPermissionSettingsMenu(type: contentSettings_mojom_ContentSettingsType): void;
    getOsMicrophonePermissionStatus(): Promise<{
        enabled: boolean;
    }>;
    getZeroStateSuggestionsAndSubscribe(isLive: boolean, options: ZeroStateSuggestionsOptions): Promise<{
        zeroStateSuggestions: (ZeroStateSuggestionsV2 | null);
    }>;
    getZeroStateSuggestionsForFocusedTab(isFirstRun: (boolean | null)): Promise<{
        suggestions: (ZeroStateSuggestions | null);
    }>;
    maybeRefreshUserStatus(): void;
    isDebuggerAttached(): Promise<{
        isAttachedToWebview: boolean;
    }>;
    onViewChanged(notification: ViewChangedNotification): void;
    subscribeToPageMetadata(tabId: number, names: string[]): Promise<{
        success: boolean;
    }>;
    switchConversation(info: (ConversationInfo | null)): Promise<{
        errorReason: (SwitchConversationErrorReason | null);
    }>;
    registerConversation(info: ConversationInfo): Promise<{
        errorReason: (RegisterConversationErrorReason | null);
    }>;
    setOnboardingCompleted(): void;
}
export declare class WebClientHandlerRemote implements WebClientHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<WebClientHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | WebClientHandlerPendingReceiverEndpoint);
    webClientCreated(webClient: WebClientRemote): Promise<{
        initialState: WebClientInitialState;
    }>;
    webClientInitialized(): void;
    webClientInitializeFailed(): void;
    createTab(url: url_mojom_Url, openInBackground: boolean, windowId: (number | null)): Promise<{
        tabData: (TabData | null);
    }>;
    openLinkInPopup(url: url_mojom_Url, popupWidth: number, popupHeight: number): void;
    openGlicSettingsPage(options: OpenSettingsOptions): void;
    openPasswordManagerSettingsPage(): void;
    closePanel(): void;
    closePanelAndShutdown(): void;
    attachPanel(): void;
    detachPanel(): void;
    onModeChange(newMode: WebClientMode): void;
    showProfilePicker(): void;
    getModelQualityClientId(): Promise<{
        modelQualityClientId: string;
    }>;
    getContextFromFocusedTab(options: GetTabContextOptions): Promise<{
        result: GetContextResult;
    }>;
    getContextFromTab(tabId: number, options: GetTabContextOptions): Promise<{
        result: GetContextResult;
    }>;
    getContextForActorFromTab(tabId: number, options: GetTabContextOptions): Promise<{
        result: GetContextResult;
    }>;
    setMaximumNumberOfPinnedTabs(requestedMax: number): Promise<{
        effectiveMax: number;
    }>;
    pinTabs(tabIds: number[]): Promise<{
        pinnedAll: boolean;
    }>;
    unpinTabs(tabIds: number[]): Promise<{
        unpinnedAll: boolean;
    }>;
    unpinAllTabs(): void;
    subscribeToPinCandidates(options: GetPinCandidatesOptions, observer: PinCandidatesObserverRemote): void;
    createTask(taskOptions: (actor_webui_mojom_TaskOptions | null)): Promise<number>;
    performActions(actionsProto: number[]): Promise<mojoBase_mojom_ProtoWrapper>;
    stopActorTask(taskId: number, stopReason: ActorTaskStopReason): void;
    pauseActorTask(taskId: number, pauseReason: ActorTaskPauseReason, tabId: (number | null)): void;
    resumeActorTask(taskId: number, contextOptions: GetTabContextOptions): Promise<{
        result: GetContextResultWithActionResultCode;
    }>;
    interruptActorTask(taskId: number): void;
    uninterruptActorTask(taskId: number): void;
    createActorTab(taskId: number, openInBackground: boolean, initiatorTabId: (number | null), initiatorWindowId: (number | null)): Promise<{
        tabData: (TabData | null);
    }>;
    activateTab(taskId: number): void;
    resizeWidget(size: gfx_mojom_Size, duration: mojoBase_mojom_TimeDelta): Promise<void>;
    captureScreenshot(): Promise<{
        result: CaptureScreenshotResult;
    }>;
    captureRegion(observer: CaptureRegionObserverRemote): void;
    setAudioDucking(enable: boolean): Promise<{
        result: boolean;
    }>;
    setPanelDraggableAreas(draggableAreas: gfx_mojom_Rect[]): Promise<void>;
    setMinimumPanelSize(size: gfx_mojom_Size): void;
    setMicrophonePermissionState(enabled: boolean): Promise<void>;
    setLocationPermissionState(enabled: boolean): Promise<void>;
    setTabContextPermissionState(enabled: boolean): Promise<void>;
    setClosedCaptioningSetting(enabled: boolean): Promise<void>;
    setActuationOnWebSetting(enabled: boolean): Promise<void>;
    shouldAllowMediaPermissionRequest(): Promise<{
        isAllowed: boolean;
    }>;
    shouldAllowGeolocationPermissionRequest(): Promise<{
        isAllowed: boolean;
    }>;
    setContextAccessIndicator(enabled: boolean): void;
    getUserProfileInfo(): Promise<{
        profileInfo: (UserProfileInfo | null);
    }>;
    syncCookies(): Promise<{
        success: boolean;
    }>;
    logBeginAsyncEvent(eventAsyncId: bigint, taskId: number, event: string, details: string): void;
    logEndAsyncEvent(eventAsyncId: bigint, details: string): void;
    logInstantEvent(taskId: number, event: string, details: string): void;
    journalClear(): void;
    journalSnapshot(clearJournal: boolean): Promise<{
        journal: Journal;
    }>;
    journalStart(maxBytes: bigint, captureScreenshots: boolean): void;
    journalStop(): void;
    journalRecordFeedback(positive: boolean, reason: string): void;
    onUserInputSubmitted(mode: WebClientMode): void;
    onContextUploadStarted(): void;
    onContextUploadCompleted(): void;
    onReaction(reactionType: MetricUserInputReactionType): void;
    onResponseStarted(): void;
    onResponseStopped(details: OnResponseStoppedDetails): void;
    onSessionTerminated(): void;
    onTurnCompleted(model: WebClientModel, duration: mojoBase_mojom_TimeDelta): void;
    onModelChanged(model: WebClientModel): void;
    onRecordUseCounter(counter: number): void;
    onResponseRated(positive: boolean): void;
    onClosedCaptionsShown(): void;
    scrollTo(params: ScrollToParams): Promise<{
        errorReason: (ScrollToErrorReason | null);
    }>;
    dropScrollToHighlight(): void;
    setSyntheticExperimentState(trialName: string, groupName: string): void;
    openOsPermissionSettingsMenu(type: contentSettings_mojom_ContentSettingsType): void;
    getOsMicrophonePermissionStatus(): Promise<{
        enabled: boolean;
    }>;
    getZeroStateSuggestionsAndSubscribe(isLive: boolean, options: ZeroStateSuggestionsOptions): Promise<{
        zeroStateSuggestions: (ZeroStateSuggestionsV2 | null);
    }>;
    getZeroStateSuggestionsForFocusedTab(isFirstRun: (boolean | null)): Promise<{
        suggestions: (ZeroStateSuggestions | null);
    }>;
    maybeRefreshUserStatus(): void;
    isDebuggerAttached(): Promise<{
        isAttachedToWebview: boolean;
    }>;
    onViewChanged(notification: ViewChangedNotification): void;
    subscribeToPageMetadata(tabId: number, names: string[]): Promise<{
        success: boolean;
    }>;
    switchConversation(info: (ConversationInfo | null)): Promise<{
        errorReason: (SwitchConversationErrorReason | null);
    }>;
    registerConversation(info: ConversationInfo): Promise<{
        errorReason: (RegisterConversationErrorReason | null);
    }>;
    setOnboardingCompleted(): void;
}
/**
 * An object which receives request messages for the WebClientHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class WebClientHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<WebClientHandlerRemote, WebClientHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: WebClientHandlerInterface);
}
export declare class WebClientHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): WebClientHandlerRemote;
}
/**
 * An object which receives request messages for the WebClientHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class WebClientHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<WebClientHandlerRemote, WebClientHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    webClientCreated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    webClientInitialized: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    webClientInitializeFailed: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    createTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    openLinkInPopup: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    openGlicSettingsPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    openPasswordManagerSettingsPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    closePanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    closePanelAndShutdown: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    attachPanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    detachPanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onModeChange: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    showProfilePicker: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getModelQualityClientId: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getContextFromFocusedTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getContextFromTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getContextForActorFromTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setMaximumNumberOfPinnedTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    pinTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    unpinTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    unpinAllTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    subscribeToPinCandidates: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    createTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    performActions: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    stopActorTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    pauseActorTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    resumeActorTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    interruptActorTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    uninterruptActorTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    createActorTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    activateTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    resizeWidget: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    captureScreenshot: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    captureRegion: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setAudioDucking: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setPanelDraggableAreas: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setMinimumPanelSize: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setMicrophonePermissionState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setLocationPermissionState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setTabContextPermissionState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setClosedCaptioningSetting: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setActuationOnWebSetting: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    shouldAllowMediaPermissionRequest: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    shouldAllowGeolocationPermissionRequest: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setContextAccessIndicator: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getUserProfileInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    syncCookies: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    logBeginAsyncEvent: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    logEndAsyncEvent: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    logInstantEvent: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    journalClear: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    journalSnapshot: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    journalStart: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    journalStop: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    journalRecordFeedback: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onUserInputSubmitted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onContextUploadStarted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onContextUploadCompleted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onReaction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onResponseStarted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onResponseStopped: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onSessionTerminated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onTurnCompleted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onModelChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onRecordUseCounter: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onResponseRated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onClosedCaptionsShown: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    scrollTo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    dropScrollToHighlight: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setSyntheticExperimentState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    openOsPermissionSettingsMenu: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getOsMicrophonePermissionStatus: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getZeroStateSuggestionsAndSubscribe: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getZeroStateSuggestionsForFocusedTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    maybeRefreshUserStatus: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    isDebuggerAttached: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onViewChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    subscribeToPageMetadata: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    switchConversation: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    registerConversation: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setOnboardingCompleted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type WebClientPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<WebClientPendingReceiver>;
export declare class WebClientPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<WebClient> {
    handle: mojo.internal.interfaceSupport.Endpoint<WebClientPendingReceiver>;
    constructor(handle: MojoHandle | WebClientPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface WebClientInterface {
    notifyPanelWillOpen(panelOpeningData: PanelOpeningData): Promise<{
        openPanelInfo: OpenPanelInfo;
    }>;
    notifyPanelWasClosed(): Promise<void>;
    notifyPanelStateChange(panelState: PanelState): void;
    notifyPanelActiveChange(panelActive: boolean): void;
    notifyPanelCanAttachChange(canAttach: boolean): void;
    notifyMicrophonePermissionStateChanged(enabled: boolean): void;
    notifyLocationPermissionStateChanged(enabled: boolean): void;
    notifyTabContextPermissionStateChanged(enabled: boolean): void;
    notifyOsLocationPermissionStateChanged(enabled: boolean): void;
    notifyFocusedTabChanged(focusedTabData: FocusedTabData): void;
    notifyManualResizeChanged(resizing: boolean): void;
    notifyOsHotkeyStateChanged(hotkey: string): void;
    notifyBrowserIsOpenChanged(browserIsOpen: boolean): void;
    notifyInstanceActivationChanged(instanceActive: boolean): void;
    notifyClosedCaptioningSettingChanged(enabled: boolean): void;
    notifyPinnedTabsChanged(tabData: TabData[]): void;
    notifyPinnedTabDataChanged(tabData: TabData): void;
    notifyZeroStateSuggestionsChanged(suggestions: (ZeroStateSuggestionsV2 | null), options: ZeroStateSuggestionsOptions): void;
    notifyActorTaskStateChanged(taskId: number, state: ActorTaskState): void;
    notifyTabDataChanged(tabData: TabData): void;
    requestViewChange(request: ViewChangeRequest): void;
    notifyPageMetadataChanged(tabId: number, metadata: (blink_mojom_PageMetadata | null)): void;
    notifyDefaultTabContextPermissionStateChanged(enabled: boolean): void;
    requestToShowCredentialSelectionDialog(request: actor_webui_mojom_SelectCredentialDialogRequest): Promise<{
        response: actor_webui_mojom_SelectCredentialDialogResponse;
    }>;
    requestToShowAutofillSuggestionsDialog(request: actor_webui_mojom_SelectAutofillSuggestionsDialogRequest): Promise<{
        response: actor_webui_mojom_SelectAutofillSuggestionsDialogResponse;
    }>;
    requestToShowUserConfirmationDialog(request: actor_webui_mojom_UserConfirmationDialogRequest): Promise<{
        response: actor_webui_mojom_UserConfirmationDialogResponse;
    }>;
    requestToConfirmNavigation(request: actor_webui_mojom_NavigationConfirmationRequest): Promise<{
        response: actor_webui_mojom_NavigationConfirmationResponse;
    }>;
    notifyAdditionalContext(context: AdditionalContext): void;
    notifyActuationOnWebSettingChanged(enabled: boolean): void;
    notifyActOnWebCapabilityChanged(canActOnWeb: boolean): void;
    notifyOnboardingCompletedChanged(completed: boolean): void;
}
export declare class WebClientRemote implements WebClientInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<WebClientPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | WebClientPendingReceiverEndpoint);
    notifyPanelWillOpen(panelOpeningData: PanelOpeningData): Promise<{
        openPanelInfo: OpenPanelInfo;
    }>;
    notifyPanelWasClosed(): Promise<void>;
    notifyPanelStateChange(panelState: PanelState): void;
    notifyPanelActiveChange(panelActive: boolean): void;
    notifyPanelCanAttachChange(canAttach: boolean): void;
    notifyMicrophonePermissionStateChanged(enabled: boolean): void;
    notifyLocationPermissionStateChanged(enabled: boolean): void;
    notifyTabContextPermissionStateChanged(enabled: boolean): void;
    notifyOsLocationPermissionStateChanged(enabled: boolean): void;
    notifyFocusedTabChanged(focusedTabData: FocusedTabData): void;
    notifyManualResizeChanged(resizing: boolean): void;
    notifyOsHotkeyStateChanged(hotkey: string): void;
    notifyBrowserIsOpenChanged(browserIsOpen: boolean): void;
    notifyInstanceActivationChanged(instanceActive: boolean): void;
    notifyClosedCaptioningSettingChanged(enabled: boolean): void;
    notifyPinnedTabsChanged(tabData: TabData[]): void;
    notifyPinnedTabDataChanged(tabData: TabData): void;
    notifyZeroStateSuggestionsChanged(suggestions: (ZeroStateSuggestionsV2 | null), options: ZeroStateSuggestionsOptions): void;
    notifyActorTaskStateChanged(taskId: number, state: ActorTaskState): void;
    notifyTabDataChanged(tabData: TabData): void;
    requestViewChange(request: ViewChangeRequest): void;
    notifyPageMetadataChanged(tabId: number, metadata: (blink_mojom_PageMetadata | null)): void;
    notifyDefaultTabContextPermissionStateChanged(enabled: boolean): void;
    requestToShowCredentialSelectionDialog(request: actor_webui_mojom_SelectCredentialDialogRequest): Promise<{
        response: actor_webui_mojom_SelectCredentialDialogResponse;
    }>;
    requestToShowAutofillSuggestionsDialog(request: actor_webui_mojom_SelectAutofillSuggestionsDialogRequest): Promise<{
        response: actor_webui_mojom_SelectAutofillSuggestionsDialogResponse;
    }>;
    requestToShowUserConfirmationDialog(request: actor_webui_mojom_UserConfirmationDialogRequest): Promise<{
        response: actor_webui_mojom_UserConfirmationDialogResponse;
    }>;
    requestToConfirmNavigation(request: actor_webui_mojom_NavigationConfirmationRequest): Promise<{
        response: actor_webui_mojom_NavigationConfirmationResponse;
    }>;
    notifyAdditionalContext(context: AdditionalContext): void;
    notifyActuationOnWebSettingChanged(enabled: boolean): void;
    notifyActOnWebCapabilityChanged(canActOnWeb: boolean): void;
    notifyOnboardingCompletedChanged(completed: boolean): void;
}
/**
 * An object which receives request messages for the WebClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class WebClientReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<WebClientRemote, WebClientPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: WebClientInterface);
}
export declare class WebClient {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): WebClientRemote;
}
/**
 * An object which receives request messages for the WebClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class WebClientCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<WebClientRemote, WebClientPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    notifyPanelWillOpen: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyPanelWasClosed: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyPanelStateChange: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyPanelActiveChange: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyPanelCanAttachChange: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyMicrophonePermissionStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyLocationPermissionStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyTabContextPermissionStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyOsLocationPermissionStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyFocusedTabChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyManualResizeChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyOsHotkeyStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyBrowserIsOpenChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyInstanceActivationChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyClosedCaptioningSettingChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyPinnedTabsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyPinnedTabDataChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyZeroStateSuggestionsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyActorTaskStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyTabDataChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    requestViewChange: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyPageMetadataChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyDefaultTabContextPermissionStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    requestToShowCredentialSelectionDialog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    requestToShowAutofillSuggestionsDialog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    requestToShowUserConfirmationDialog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    requestToConfirmNavigation: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyAdditionalContext: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyActuationOnWebSettingChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyActOnWebCapabilityChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyOnboardingCompletedChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type CaptureRegionObserverPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<CaptureRegionObserverPendingReceiver>;
export declare class CaptureRegionObserverPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<CaptureRegionObserver> {
    handle: mojo.internal.interfaceSupport.Endpoint<CaptureRegionObserverPendingReceiver>;
    constructor(handle: MojoHandle | CaptureRegionObserverPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface CaptureRegionObserverInterface {
    onUpdate(result: (CaptureRegionResult | null), reason: (CaptureRegionErrorReason | null)): void;
}
export declare class CaptureRegionObserverRemote implements CaptureRegionObserverInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CaptureRegionObserverPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | CaptureRegionObserverPendingReceiverEndpoint);
    onUpdate(result: (CaptureRegionResult | null), reason: (CaptureRegionErrorReason | null)): void;
}
/**
 * An object which receives request messages for the CaptureRegionObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class CaptureRegionObserverReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<CaptureRegionObserverRemote, CaptureRegionObserverPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: CaptureRegionObserverInterface);
}
export declare class CaptureRegionObserver {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): CaptureRegionObserverRemote;
}
/**
 * An object which receives request messages for the CaptureRegionObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class CaptureRegionObserverCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<CaptureRegionObserverRemote, CaptureRegionObserverPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    onUpdate: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const GetContextResultWithActionResultCodeSpec: {
    $: mojo.internal.MojomType;
};
export declare const UserProfileInfoSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientInitialStateSpec: {
    $: mojo.internal.MojomType;
};
export declare const GetTabContextOptionsSpec: {
    $: mojo.internal.MojomType;
};
export declare const GetPinCandidatesOptionsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ScrollToParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ScrollToTextSelectorSpec: {
    $: mojo.internal.MojomType;
};
export declare const ScrollToTextFragmentSelectorSpec: {
    $: mojo.internal.MojomType;
};
export declare const ScrollToNodeSelectorSpec: {
    $: mojo.internal.MojomType;
};
export declare const SuggestionContentSpec: {
    $: mojo.internal.MojomType;
};
export declare const ZeroStateSuggestionsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ZeroStateSuggestionsV2Spec: {
    $: mojo.internal.MojomType;
};
export declare const ZeroStateSuggestionsOptionsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PinCandidateSpec: {
    $: mojo.internal.MojomType;
};
export declare const ConversationInfoSpec: {
    $: mojo.internal.MojomType;
};
export declare const PanelOpeningDataSpec: {
    $: mojo.internal.MojomType;
};
export declare const PanelStateSpec: {
    $: mojo.internal.MojomType;
};
export declare const OnResponseStoppedDetailsSpec: {
    $: mojo.internal.MojomType;
};
export declare const OpenPanelInfoSpec: {
    $: mojo.internal.MojomType;
};
export declare const ContextDataSpec: {
    $: mojo.internal.MojomType;
};
export declare const AdditionalContextSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabContextSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebPageDataSpec: {
    $: mojo.internal.MojomType;
};
export declare const DocumentDataSpec: {
    $: mojo.internal.MojomType;
};
export declare const PdfDocumentDataSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabDataSpec: {
    $: mojo.internal.MojomType;
};
export declare const NoFocusedTabDataSpec: {
    $: mojo.internal.MojomType;
};
export declare const AnnotatedPageDataSpec: {
    $: mojo.internal.MojomType;
};
export declare const ImageOriginAnnotationsSpec: {
    $: mojo.internal.MojomType;
};
export declare const JournalSpec: {
    $: mojo.internal.MojomType;
};
export declare const CaptureRegionResultSpec: {
    $: mojo.internal.MojomType;
};
export declare const ScreenshotSpec: {
    $: mojo.internal.MojomType;
};
export declare const OpenSettingsOptionsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ViewChangeRequestActuationSpec: {
    $: mojo.internal.MojomType;
};
export declare const ViewChangeRequestConversationSpec: {
    $: mojo.internal.MojomType;
};
export declare const ViewChangeRequestSpec: {
    $: mojo.internal.MojomType;
};
export declare const ViewChangedNotificationSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_IntentToShow_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_SetProfileReadyState_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_UpdatePageState_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandlerFactory_CreatePageHandler_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_CreateWebClient_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_PrepareForClient_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_PrepareForClient_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_WebviewCommitted_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ClosePanel_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ClosePanel_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_OpenProfilePickerAndClosePanel_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_SignInAndClosePanel_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ResizeWidget_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ResizeWidget_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_EnableDragResize_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_WebUiStateChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PinCandidatesObserver_OnPinCandidatesChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_WebClientCreated_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_WebClientCreated_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_WebClientInitialized_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_WebClientInitializeFailed_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_CreateTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_CreateTab_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OpenLinkInPopup_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OpenGlicSettingsPage_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OpenPasswordManagerSettingsPage_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_ClosePanel_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_ClosePanelAndShutdown_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_AttachPanel_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_DetachPanel_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OnModeChange_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_ShowProfilePicker_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetModelQualityClientId_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetModelQualityClientId_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetContextFromFocusedTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetContextFromFocusedTab_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetContextFromTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetContextFromTab_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetContextForActorFromTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetContextForActorFromTab_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_PinTabs_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_PinTabs_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_UnpinTabs_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_UnpinTabs_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_UnpinAllTabs_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SubscribeToPinCandidates_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_CreateTask_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_CreateTask_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_PerformActions_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_PerformActions_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_StopActorTask_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_PauseActorTask_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_ResumeActorTask_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_ResumeActorTask_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_InterruptActorTask_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_UninterruptActorTask_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_CreateActorTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_CreateActorTab_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_ActivateTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_ResizeWidget_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_ResizeWidget_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_CaptureScreenshot_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_CaptureScreenshot_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_CaptureRegion_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetAudioDucking_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetAudioDucking_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetPanelDraggableAreas_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetPanelDraggableAreas_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetMinimumPanelSize_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetMicrophonePermissionState_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetMicrophonePermissionState_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetLocationPermissionState_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetLocationPermissionState_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetTabContextPermissionState_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetTabContextPermissionState_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetClosedCaptioningSetting_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetClosedCaptioningSetting_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetActuationOnWebSetting_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetActuationOnWebSetting_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetContextAccessIndicator_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetUserProfileInfo_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetUserProfileInfo_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SyncCookies_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SyncCookies_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_LogBeginAsyncEvent_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_LogEndAsyncEvent_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_LogInstantEvent_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_JournalClear_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_JournalSnapshot_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_JournalSnapshot_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_JournalStart_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_JournalStop_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_JournalRecordFeedback_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OnUserInputSubmitted_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OnContextUploadStarted_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OnContextUploadCompleted_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OnReaction_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OnResponseStarted_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OnResponseStopped_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OnSessionTerminated_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OnTurnCompleted_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OnModelChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OnRecordUseCounter_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OnResponseRated_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OnClosedCaptionsShown_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_ScrollTo_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_ScrollTo_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_DropScrollToHighlight_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetSyntheticExperimentState_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OpenOsPermissionSettingsMenu_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetOsMicrophonePermissionStatus_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_MaybeRefreshUserStatus_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_IsDebuggerAttached_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_IsDebuggerAttached_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_OnViewChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SubscribeToPageMetadata_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SubscribeToPageMetadata_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SwitchConversation_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SwitchConversation_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_RegisterConversation_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_RegisterConversation_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_SetOnboardingCompleted_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyPanelWillOpen_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyPanelWillOpen_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyPanelWasClosed_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyPanelWasClosed_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyPanelStateChange_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyPanelActiveChange_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyPanelCanAttachChange_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyMicrophonePermissionStateChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyLocationPermissionStateChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyTabContextPermissionStateChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyOsLocationPermissionStateChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyFocusedTabChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyManualResizeChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyOsHotkeyStateChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyBrowserIsOpenChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyInstanceActivationChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyClosedCaptioningSettingChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyPinnedTabsChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyPinnedTabDataChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyZeroStateSuggestionsChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyActorTaskStateChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyTabDataChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_RequestViewChange_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyPageMetadataChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_RequestToShowCredentialSelectionDialog_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_RequestToShowAutofillSuggestionsDialog_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_RequestToShowUserConfirmationDialog_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_RequestToShowUserConfirmationDialog_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_RequestToConfirmNavigation_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_RequestToConfirmNavigation_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyAdditionalContext_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyActuationOnWebSettingChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyActOnWebCapabilityChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClient_NotifyOnboardingCompletedChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const CaptureRegionObserver_OnUpdate_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const GetContextResultSpec: {
    $: mojo.internal.MojomType;
};
export declare const CaptureScreenshotResultSpec: {
    $: mojo.internal.MojomType;
};
export declare const ScrollToSelectorSpec: {
    $: mojo.internal.MojomType;
};
export declare const AdditionalContextPartSpec: {
    $: mojo.internal.MojomType;
};
export declare const FocusedTabDataSpec: {
    $: mojo.internal.MojomType;
};
export declare const CapturedRegionSpec: {
    $: mojo.internal.MojomType;
};
export declare const ViewChangeRequestDetailsSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_CreateTask_ResponseParam_ResultSpec: {
    $: mojo.internal.MojomType;
};
export declare const WebClientHandler_PerformActions_ResponseParam_ResultSpec: {
    $: mojo.internal.MojomType;
};
export interface GetContextResultWithActionResultCodeMojoType {
    getContextResult: GetContextResult;
    actionResult: (number | null);
}
export type GetContextResultWithActionResultCode = GetContextResultWithActionResultCodeMojoType;
export interface UserProfileInfoMojoType {
    avatarIcon: (skia_mojom_BitmapN32 | null);
    displayName: string;
    localProfileName: string;
    email: string;
    givenName: string;
    isManaged: boolean;
}
export type UserProfileInfo = UserProfileInfoMojoType;
export interface WebClientInitialStateMojoType {
    panelState: PanelState;
    focusedTabData: FocusedTabData;
    microphonePermissionEnabled: boolean;
    locationPermissionEnabled: boolean;
    tabContextPermissionEnabled: boolean;
    osLocationPermissionEnabled: boolean;
    canAttach: boolean;
    panelIsActive: boolean;
    browserIsOpen: boolean;
    instanceIsActive: boolean;
    alwaysDetachedMode: boolean;
    enableZeroStateSuggestions: boolean;
    enableActInFocusedTab: boolean;
    enableScrollTo: boolean;
    enableDefaultTabContextSettingFeature: boolean;
    defaultTabContextSettingEnabled: boolean;
    enableClosedCaptioningFeature: boolean;
    closedCaptioningSettingEnabled: boolean;
    enableMaybeRefreshUserStatus: boolean;
    enableMultiTab: boolean;
    enableGetContextActor: boolean;
    enableGetPageMetadata: boolean;
    enableApiActivationGating: boolean;
    enableCaptureRegion: boolean;
    enableWebActuationSettingFeature: boolean;
    actuationOnWebSettingEnabled: boolean;
    canActOnWeb: boolean;
    enableActivateTab: boolean;
    enableGetTabById: boolean;
    enableOpenPasswordManagerSettingsPage: boolean;
    enableLoadAndExtractContent: boolean;
    enableTrustFirstOnboarding: boolean;
    onboardingCompleted: boolean;
    platform: Platform;
    hotkey: string;
    chromeVersion: mojoBase_mojom_Version;
    hostCapabilities: HostCapability[];
}
export type WebClientInitialState = WebClientInitialStateMojoType;
export interface GetTabContextOptionsMojoType {
    includeInnerText: boolean;
    includeViewportScreenshot: boolean;
    includeAnnotatedPageContent: boolean;
    includePdf: boolean;
    innerTextBytesLimit: number;
    maxMetaTags: number;
    pdfSizeLimit: number;
    annotatedPageContentMode: number;
}
export type GetTabContextOptions = GetTabContextOptionsMojoType;
export interface GetPinCandidatesOptionsMojoType {
    maxCandidates: number;
    query: (string | null);
}
export type GetPinCandidatesOptions = GetPinCandidatesOptionsMojoType;
export interface ScrollToParamsMojoType {
    selector: ScrollToSelector;
    highlight: boolean;
    documentId: (mojoBase_mojom_UnguessableToken | null);
    url: (url_mojom_Url | null);
}
export type ScrollToParams = ScrollToParamsMojoType;
export interface ScrollToTextSelectorMojoType {
    text: string;
    searchRangeStartNodeId: (number | null);
}
export type ScrollToTextSelector = ScrollToTextSelectorMojoType;
export interface ScrollToTextFragmentSelectorMojoType {
    textStart: string;
    textEnd: string;
    searchRangeStartNodeId: (number | null);
}
export type ScrollToTextFragmentSelector = ScrollToTextFragmentSelectorMojoType;
export interface ScrollToNodeSelectorMojoType {
    nodeId: number;
}
export type ScrollToNodeSelector = ScrollToNodeSelectorMojoType;
export interface SuggestionContentMojoType {
    suggestion: string;
}
export type SuggestionContent = SuggestionContentMojoType;
export interface ZeroStateSuggestionsMojoType {
    suggestions: SuggestionContent[];
    tabId: number;
    tabUrl: url_mojom_Url;
}
export type ZeroStateSuggestions = ZeroStateSuggestionsMojoType;
export interface ZeroStateSuggestionsV2MojoType {
    suggestions: SuggestionContent[];
    isPending: boolean;
}
export type ZeroStateSuggestionsV2 = ZeroStateSuggestionsV2MojoType;
export interface ZeroStateSuggestionsOptionsMojoType {
    isFirstRun: boolean;
    supportedTools: string[];
}
export type ZeroStateSuggestionsOptions = ZeroStateSuggestionsOptionsMojoType;
export interface PinCandidateMojoType {
    tabData: TabData;
}
export type PinCandidate = PinCandidateMojoType;
export interface ConversationInfoMojoType {
    conversationId: string;
    conversationTitle: string;
}
export type ConversationInfo = ConversationInfoMojoType;
export interface PanelOpeningDataMojoType {
    panelState: PanelState;
    invocationSource: InvocationSource;
    conversationId: (string | null);
    promptSuggestion: (string | null);
    recentlyActiveConversations: (ConversationInfo[] | null);
}
export type PanelOpeningData = PanelOpeningDataMojoType;
export interface PanelStateMojoType {
    kind: PanelStateKind;
    windowId: (number | null);
}
export type PanelState = PanelStateMojoType;
export interface OnResponseStoppedDetailsMojoType {
    cause: ResponseStopCause;
}
export type OnResponseStoppedDetails = OnResponseStoppedDetailsMojoType;
export interface OpenPanelInfoMojoType {
    webClientMode: WebClientMode;
    canUserResize: boolean;
    panelSize: (gfx_mojom_Size | null);
    resizeDuration: mojoBase_mojom_TimeDelta;
}
export type OpenPanelInfo = OpenPanelInfoMojoType;
export interface ContextDataMojoType {
    mimeType: string;
    data: mojoBase_mojom_BigBuffer;
}
export type ContextData = ContextDataMojoType;
export interface AdditionalContextMojoType {
    name: (string | null);
    tabId: (number | null);
    origin: (url_mojom_Origin | null);
    frameUrl: (url_mojom_Url | null);
    parts: AdditionalContextPart[];
}
export type AdditionalContext = AdditionalContextMojoType;
export interface TabContextMojoType {
    tabData: TabData;
    webPageData: (WebPageData | null);
    viewportScreenshot: (Screenshot | null);
    pdfDocumentData: (PdfDocumentData | null);
    annotatedPageData: (AnnotatedPageData | null);
}
export type TabContext = TabContextMojoType;
export interface WebPageDataMojoType {
    mainDocument: DocumentData;
}
export type WebPageData = WebPageDataMojoType;
export interface DocumentDataMojoType {
    origin: url_mojom_Origin;
    innerText: string;
    innerTextTruncated: boolean;
}
export type DocumentData = DocumentDataMojoType;
export interface PdfDocumentDataMojoType {
    origin: url_mojom_Origin;
    pdfData: (number[] | null);
    sizeLimitExceeded: boolean;
}
export type PdfDocumentData = PdfDocumentDataMojoType;
export interface TabDataMojoType {
    tabId: number;
    windowId: number;
    url: url_mojom_Url;
    title: (string | null);
    favicon: (skia_mojom_BitmapN32 | null);
    faviconUrl: (url_mojom_Url | null);
    documentMimeType: string;
    isObservable: (boolean | null);
    isMediaActive: (boolean | null);
    isTabContentCaptured: (boolean | null);
    isActiveInWindow: (boolean | null);
    isWindowActive: (boolean | null);
}
export type TabData = TabDataMojoType;
export interface NoFocusedTabDataMojoType {
    activeTabData: (TabData | null);
    noFocusReason: string;
}
export type NoFocusedTabData = NoFocusedTabDataMojoType;
export interface AnnotatedPageDataMojoType {
    annotatedPageContent: (mojoBase_mojom_ProtoWrapper | null);
    metadata: (blink_mojom_PageMetadata | null);
}
export type AnnotatedPageData = AnnotatedPageDataMojoType;
export interface ImageOriginAnnotationsMojoType {
}
export type ImageOriginAnnotations = ImageOriginAnnotationsMojoType;
export interface JournalMojoType {
    data: number[];
}
export type Journal = JournalMojoType;
export interface CaptureRegionResultMojoType {
    tabId: number;
    region: CapturedRegion;
}
export type CaptureRegionResult = CaptureRegionResultMojoType;
export interface ScreenshotMojoType {
    widthPixels: number;
    heightPixels: number;
    data: number[];
    mimeType: string;
    originAnnotations: ImageOriginAnnotations;
}
export type Screenshot = ScreenshotMojoType;
export interface OpenSettingsOptionsMojoType {
    highlightField: SettingsPageField;
}
export type OpenSettingsOptions = OpenSettingsOptionsMojoType;
export interface ViewChangeRequestActuationMojoType {
}
export type ViewChangeRequestActuation = ViewChangeRequestActuationMojoType;
export interface ViewChangeRequestConversationMojoType {
}
export type ViewChangeRequestConversation = ViewChangeRequestConversationMojoType;
export interface ViewChangeRequestMojoType {
    details: ViewChangeRequestDetails;
}
export type ViewChangeRequest = ViewChangeRequestMojoType;
export interface ViewChangedNotificationMojoType {
    currentView: CurrentView;
}
export type ViewChangedNotification = ViewChangedNotificationMojoType;
export interface Page_IntentToShow_ParamsMojoType {
}
export type Page_IntentToShow_Params = Page_IntentToShow_ParamsMojoType;
export interface Page_SetProfileReadyState_ParamsMojoType {
    readyState: ProfileReadyState;
}
export type Page_SetProfileReadyState_Params = Page_SetProfileReadyState_ParamsMojoType;
export interface Page_UpdatePageState_ParamsMojoType {
    panelStateKind: PanelStateKind;
}
export type Page_UpdatePageState_Params = Page_UpdatePageState_ParamsMojoType;
export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
    receiver: PageHandlerPendingReceiver;
    page: PageRemote;
}
export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
export interface PageHandler_CreateWebClient_ParamsMojoType {
    webClientReceiver: WebClientHandlerPendingReceiver;
}
export type PageHandler_CreateWebClient_Params = PageHandler_CreateWebClient_ParamsMojoType;
export interface PageHandler_PrepareForClient_ParamsMojoType {
}
export type PageHandler_PrepareForClient_Params = PageHandler_PrepareForClient_ParamsMojoType;
export interface PageHandler_PrepareForClient_ResponseParamsMojoType {
    result: PrepareForClientResult;
}
export type PageHandler_PrepareForClient_ResponseParams = PageHandler_PrepareForClient_ResponseParamsMojoType;
export interface PageHandler_WebviewCommitted_ParamsMojoType {
    url: url_mojom_Url;
}
export type PageHandler_WebviewCommitted_Params = PageHandler_WebviewCommitted_ParamsMojoType;
export interface PageHandler_ClosePanel_ParamsMojoType {
}
export type PageHandler_ClosePanel_Params = PageHandler_ClosePanel_ParamsMojoType;
export interface PageHandler_ClosePanel_ResponseParamsMojoType {
}
export type PageHandler_ClosePanel_ResponseParams = PageHandler_ClosePanel_ResponseParamsMojoType;
export interface PageHandler_OpenProfilePickerAndClosePanel_ParamsMojoType {
}
export type PageHandler_OpenProfilePickerAndClosePanel_Params = PageHandler_OpenProfilePickerAndClosePanel_ParamsMojoType;
export interface PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsMojoType {
}
export type PageHandler_OpenDisabledByAdminLinkAndClosePanel_Params = PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsMojoType;
export interface PageHandler_SignInAndClosePanel_ParamsMojoType {
}
export type PageHandler_SignInAndClosePanel_Params = PageHandler_SignInAndClosePanel_ParamsMojoType;
export interface PageHandler_ResizeWidget_ParamsMojoType {
    size: gfx_mojom_Size;
    duration: mojoBase_mojom_TimeDelta;
}
export type PageHandler_ResizeWidget_Params = PageHandler_ResizeWidget_ParamsMojoType;
export interface PageHandler_ResizeWidget_ResponseParamsMojoType {
}
export type PageHandler_ResizeWidget_ResponseParams = PageHandler_ResizeWidget_ResponseParamsMojoType;
export interface PageHandler_EnableDragResize_ParamsMojoType {
    enabled: boolean;
}
export type PageHandler_EnableDragResize_Params = PageHandler_EnableDragResize_ParamsMojoType;
export interface PageHandler_WebUiStateChanged_ParamsMojoType {
    newState: WebUiState;
}
export type PageHandler_WebUiStateChanged_Params = PageHandler_WebUiStateChanged_ParamsMojoType;
export interface PinCandidatesObserver_OnPinCandidatesChanged_ParamsMojoType {
    candidates: PinCandidate[];
}
export type PinCandidatesObserver_OnPinCandidatesChanged_Params = PinCandidatesObserver_OnPinCandidatesChanged_ParamsMojoType;
export interface WebClientHandler_WebClientCreated_ParamsMojoType {
    webClient: WebClientRemote;
}
export type WebClientHandler_WebClientCreated_Params = WebClientHandler_WebClientCreated_ParamsMojoType;
export interface WebClientHandler_WebClientCreated_ResponseParamsMojoType {
    initialState: WebClientInitialState;
}
export type WebClientHandler_WebClientCreated_ResponseParams = WebClientHandler_WebClientCreated_ResponseParamsMojoType;
export interface WebClientHandler_WebClientInitialized_ParamsMojoType {
}
export type WebClientHandler_WebClientInitialized_Params = WebClientHandler_WebClientInitialized_ParamsMojoType;
export interface WebClientHandler_WebClientInitializeFailed_ParamsMojoType {
}
export type WebClientHandler_WebClientInitializeFailed_Params = WebClientHandler_WebClientInitializeFailed_ParamsMojoType;
export interface WebClientHandler_CreateTab_ParamsMojoType {
    url: url_mojom_Url;
    openInBackground: boolean;
    windowId: (number | null);
}
export type WebClientHandler_CreateTab_Params = WebClientHandler_CreateTab_ParamsMojoType;
export interface WebClientHandler_CreateTab_ResponseParamsMojoType {
    tabData: (TabData | null);
}
export type WebClientHandler_CreateTab_ResponseParams = WebClientHandler_CreateTab_ResponseParamsMojoType;
export interface WebClientHandler_OpenLinkInPopup_ParamsMojoType {
    url: url_mojom_Url;
    popupWidth: number;
    popupHeight: number;
}
export type WebClientHandler_OpenLinkInPopup_Params = WebClientHandler_OpenLinkInPopup_ParamsMojoType;
export interface WebClientHandler_OpenGlicSettingsPage_ParamsMojoType {
    options: OpenSettingsOptions;
}
export type WebClientHandler_OpenGlicSettingsPage_Params = WebClientHandler_OpenGlicSettingsPage_ParamsMojoType;
export interface WebClientHandler_OpenPasswordManagerSettingsPage_ParamsMojoType {
}
export type WebClientHandler_OpenPasswordManagerSettingsPage_Params = WebClientHandler_OpenPasswordManagerSettingsPage_ParamsMojoType;
export interface WebClientHandler_ClosePanel_ParamsMojoType {
}
export type WebClientHandler_ClosePanel_Params = WebClientHandler_ClosePanel_ParamsMojoType;
export interface WebClientHandler_ClosePanelAndShutdown_ParamsMojoType {
}
export type WebClientHandler_ClosePanelAndShutdown_Params = WebClientHandler_ClosePanelAndShutdown_ParamsMojoType;
export interface WebClientHandler_AttachPanel_ParamsMojoType {
}
export type WebClientHandler_AttachPanel_Params = WebClientHandler_AttachPanel_ParamsMojoType;
export interface WebClientHandler_DetachPanel_ParamsMojoType {
}
export type WebClientHandler_DetachPanel_Params = WebClientHandler_DetachPanel_ParamsMojoType;
export interface WebClientHandler_OnModeChange_ParamsMojoType {
    newMode: WebClientMode;
}
export type WebClientHandler_OnModeChange_Params = WebClientHandler_OnModeChange_ParamsMojoType;
export interface WebClientHandler_ShowProfilePicker_ParamsMojoType {
}
export type WebClientHandler_ShowProfilePicker_Params = WebClientHandler_ShowProfilePicker_ParamsMojoType;
export interface WebClientHandler_GetModelQualityClientId_ParamsMojoType {
}
export type WebClientHandler_GetModelQualityClientId_Params = WebClientHandler_GetModelQualityClientId_ParamsMojoType;
export interface WebClientHandler_GetModelQualityClientId_ResponseParamsMojoType {
    modelQualityClientId: string;
}
export type WebClientHandler_GetModelQualityClientId_ResponseParams = WebClientHandler_GetModelQualityClientId_ResponseParamsMojoType;
export interface WebClientHandler_GetContextFromFocusedTab_ParamsMojoType {
    options: GetTabContextOptions;
}
export type WebClientHandler_GetContextFromFocusedTab_Params = WebClientHandler_GetContextFromFocusedTab_ParamsMojoType;
export interface WebClientHandler_GetContextFromFocusedTab_ResponseParamsMojoType {
    result: GetContextResult;
}
export type WebClientHandler_GetContextFromFocusedTab_ResponseParams = WebClientHandler_GetContextFromFocusedTab_ResponseParamsMojoType;
export interface WebClientHandler_GetContextFromTab_ParamsMojoType {
    tabId: number;
    options: GetTabContextOptions;
}
export type WebClientHandler_GetContextFromTab_Params = WebClientHandler_GetContextFromTab_ParamsMojoType;
export interface WebClientHandler_GetContextFromTab_ResponseParamsMojoType {
    result: GetContextResult;
}
export type WebClientHandler_GetContextFromTab_ResponseParams = WebClientHandler_GetContextFromTab_ResponseParamsMojoType;
export interface WebClientHandler_GetContextForActorFromTab_ParamsMojoType {
    tabId: number;
    options: GetTabContextOptions;
}
export type WebClientHandler_GetContextForActorFromTab_Params = WebClientHandler_GetContextForActorFromTab_ParamsMojoType;
export interface WebClientHandler_GetContextForActorFromTab_ResponseParamsMojoType {
    result: GetContextResult;
}
export type WebClientHandler_GetContextForActorFromTab_ResponseParams = WebClientHandler_GetContextForActorFromTab_ResponseParamsMojoType;
export interface WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsMojoType {
    requestedMax: number;
}
export type WebClientHandler_SetMaximumNumberOfPinnedTabs_Params = WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsMojoType;
export interface WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsMojoType {
    effectiveMax: number;
}
export type WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParams = WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsMojoType;
export interface WebClientHandler_PinTabs_ParamsMojoType {
    tabIds: number[];
}
export type WebClientHandler_PinTabs_Params = WebClientHandler_PinTabs_ParamsMojoType;
export interface WebClientHandler_PinTabs_ResponseParamsMojoType {
    pinnedAll: boolean;
}
export type WebClientHandler_PinTabs_ResponseParams = WebClientHandler_PinTabs_ResponseParamsMojoType;
export interface WebClientHandler_UnpinTabs_ParamsMojoType {
    tabIds: number[];
}
export type WebClientHandler_UnpinTabs_Params = WebClientHandler_UnpinTabs_ParamsMojoType;
export interface WebClientHandler_UnpinTabs_ResponseParamsMojoType {
    unpinnedAll: boolean;
}
export type WebClientHandler_UnpinTabs_ResponseParams = WebClientHandler_UnpinTabs_ResponseParamsMojoType;
export interface WebClientHandler_UnpinAllTabs_ParamsMojoType {
}
export type WebClientHandler_UnpinAllTabs_Params = WebClientHandler_UnpinAllTabs_ParamsMojoType;
export interface WebClientHandler_SubscribeToPinCandidates_ParamsMojoType {
    options: GetPinCandidatesOptions;
    observer: PinCandidatesObserverRemote;
}
export type WebClientHandler_SubscribeToPinCandidates_Params = WebClientHandler_SubscribeToPinCandidates_ParamsMojoType;
export interface WebClientHandler_CreateTask_ParamsMojoType {
    taskOptions: (actor_webui_mojom_TaskOptions | null);
}
export type WebClientHandler_CreateTask_Params = WebClientHandler_CreateTask_ParamsMojoType;
export interface WebClientHandler_CreateTask_ResponseParamsMojoType {
    result: WebClientHandler_CreateTask_ResponseParam_Result;
}
export type WebClientHandler_CreateTask_ResponseParams = WebClientHandler_CreateTask_ResponseParamsMojoType;
export interface WebClientHandler_PerformActions_ParamsMojoType {
    actionsProto: number[];
}
export type WebClientHandler_PerformActions_Params = WebClientHandler_PerformActions_ParamsMojoType;
export interface WebClientHandler_PerformActions_ResponseParamsMojoType {
    result: WebClientHandler_PerformActions_ResponseParam_Result;
}
export type WebClientHandler_PerformActions_ResponseParams = WebClientHandler_PerformActions_ResponseParamsMojoType;
export interface WebClientHandler_StopActorTask_ParamsMojoType {
    taskId: number;
    stopReason: ActorTaskStopReason;
}
export type WebClientHandler_StopActorTask_Params = WebClientHandler_StopActorTask_ParamsMojoType;
export interface WebClientHandler_PauseActorTask_ParamsMojoType {
    taskId: number;
    pauseReason: ActorTaskPauseReason;
    tabId: (number | null);
}
export type WebClientHandler_PauseActorTask_Params = WebClientHandler_PauseActorTask_ParamsMojoType;
export interface WebClientHandler_ResumeActorTask_ParamsMojoType {
    taskId: number;
    contextOptions: GetTabContextOptions;
}
export type WebClientHandler_ResumeActorTask_Params = WebClientHandler_ResumeActorTask_ParamsMojoType;
export interface WebClientHandler_ResumeActorTask_ResponseParamsMojoType {
    result: GetContextResultWithActionResultCode;
}
export type WebClientHandler_ResumeActorTask_ResponseParams = WebClientHandler_ResumeActorTask_ResponseParamsMojoType;
export interface WebClientHandler_InterruptActorTask_ParamsMojoType {
    taskId: number;
}
export type WebClientHandler_InterruptActorTask_Params = WebClientHandler_InterruptActorTask_ParamsMojoType;
export interface WebClientHandler_UninterruptActorTask_ParamsMojoType {
    taskId: number;
}
export type WebClientHandler_UninterruptActorTask_Params = WebClientHandler_UninterruptActorTask_ParamsMojoType;
export interface WebClientHandler_CreateActorTab_ParamsMojoType {
    taskId: number;
    openInBackground: boolean;
    initiatorTabId: (number | null);
    initiatorWindowId: (number | null);
}
export type WebClientHandler_CreateActorTab_Params = WebClientHandler_CreateActorTab_ParamsMojoType;
export interface WebClientHandler_CreateActorTab_ResponseParamsMojoType {
    tabData: (TabData | null);
}
export type WebClientHandler_CreateActorTab_ResponseParams = WebClientHandler_CreateActorTab_ResponseParamsMojoType;
export interface WebClientHandler_ActivateTab_ParamsMojoType {
    taskId: number;
}
export type WebClientHandler_ActivateTab_Params = WebClientHandler_ActivateTab_ParamsMojoType;
export interface WebClientHandler_ResizeWidget_ParamsMojoType {
    size: gfx_mojom_Size;
    duration: mojoBase_mojom_TimeDelta;
}
export type WebClientHandler_ResizeWidget_Params = WebClientHandler_ResizeWidget_ParamsMojoType;
export interface WebClientHandler_ResizeWidget_ResponseParamsMojoType {
}
export type WebClientHandler_ResizeWidget_ResponseParams = WebClientHandler_ResizeWidget_ResponseParamsMojoType;
export interface WebClientHandler_CaptureScreenshot_ParamsMojoType {
}
export type WebClientHandler_CaptureScreenshot_Params = WebClientHandler_CaptureScreenshot_ParamsMojoType;
export interface WebClientHandler_CaptureScreenshot_ResponseParamsMojoType {
    result: CaptureScreenshotResult;
}
export type WebClientHandler_CaptureScreenshot_ResponseParams = WebClientHandler_CaptureScreenshot_ResponseParamsMojoType;
export interface WebClientHandler_CaptureRegion_ParamsMojoType {
    observer: CaptureRegionObserverRemote;
}
export type WebClientHandler_CaptureRegion_Params = WebClientHandler_CaptureRegion_ParamsMojoType;
export interface WebClientHandler_SetAudioDucking_ParamsMojoType {
    enable: boolean;
}
export type WebClientHandler_SetAudioDucking_Params = WebClientHandler_SetAudioDucking_ParamsMojoType;
export interface WebClientHandler_SetAudioDucking_ResponseParamsMojoType {
    result: boolean;
}
export type WebClientHandler_SetAudioDucking_ResponseParams = WebClientHandler_SetAudioDucking_ResponseParamsMojoType;
export interface WebClientHandler_SetPanelDraggableAreas_ParamsMojoType {
    draggableAreas: gfx_mojom_Rect[];
}
export type WebClientHandler_SetPanelDraggableAreas_Params = WebClientHandler_SetPanelDraggableAreas_ParamsMojoType;
export interface WebClientHandler_SetPanelDraggableAreas_ResponseParamsMojoType {
}
export type WebClientHandler_SetPanelDraggableAreas_ResponseParams = WebClientHandler_SetPanelDraggableAreas_ResponseParamsMojoType;
export interface WebClientHandler_SetMinimumPanelSize_ParamsMojoType {
    size: gfx_mojom_Size;
}
export type WebClientHandler_SetMinimumPanelSize_Params = WebClientHandler_SetMinimumPanelSize_ParamsMojoType;
export interface WebClientHandler_SetMicrophonePermissionState_ParamsMojoType {
    enabled: boolean;
}
export type WebClientHandler_SetMicrophonePermissionState_Params = WebClientHandler_SetMicrophonePermissionState_ParamsMojoType;
export interface WebClientHandler_SetMicrophonePermissionState_ResponseParamsMojoType {
}
export type WebClientHandler_SetMicrophonePermissionState_ResponseParams = WebClientHandler_SetMicrophonePermissionState_ResponseParamsMojoType;
export interface WebClientHandler_SetLocationPermissionState_ParamsMojoType {
    enabled: boolean;
}
export type WebClientHandler_SetLocationPermissionState_Params = WebClientHandler_SetLocationPermissionState_ParamsMojoType;
export interface WebClientHandler_SetLocationPermissionState_ResponseParamsMojoType {
}
export type WebClientHandler_SetLocationPermissionState_ResponseParams = WebClientHandler_SetLocationPermissionState_ResponseParamsMojoType;
export interface WebClientHandler_SetTabContextPermissionState_ParamsMojoType {
    enabled: boolean;
}
export type WebClientHandler_SetTabContextPermissionState_Params = WebClientHandler_SetTabContextPermissionState_ParamsMojoType;
export interface WebClientHandler_SetTabContextPermissionState_ResponseParamsMojoType {
}
export type WebClientHandler_SetTabContextPermissionState_ResponseParams = WebClientHandler_SetTabContextPermissionState_ResponseParamsMojoType;
export interface WebClientHandler_SetClosedCaptioningSetting_ParamsMojoType {
    enabled: boolean;
}
export type WebClientHandler_SetClosedCaptioningSetting_Params = WebClientHandler_SetClosedCaptioningSetting_ParamsMojoType;
export interface WebClientHandler_SetClosedCaptioningSetting_ResponseParamsMojoType {
}
export type WebClientHandler_SetClosedCaptioningSetting_ResponseParams = WebClientHandler_SetClosedCaptioningSetting_ResponseParamsMojoType;
export interface WebClientHandler_SetActuationOnWebSetting_ParamsMojoType {
    enabled: boolean;
}
export type WebClientHandler_SetActuationOnWebSetting_Params = WebClientHandler_SetActuationOnWebSetting_ParamsMojoType;
export interface WebClientHandler_SetActuationOnWebSetting_ResponseParamsMojoType {
}
export type WebClientHandler_SetActuationOnWebSetting_ResponseParams = WebClientHandler_SetActuationOnWebSetting_ResponseParamsMojoType;
export interface WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsMojoType {
}
export type WebClientHandler_ShouldAllowMediaPermissionRequest_Params = WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsMojoType;
export interface WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsMojoType {
    isAllowed: boolean;
}
export type WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParams = WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsMojoType;
export interface WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsMojoType {
}
export type WebClientHandler_ShouldAllowGeolocationPermissionRequest_Params = WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsMojoType;
export interface WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsMojoType {
    isAllowed: boolean;
}
export type WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParams = WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsMojoType;
export interface WebClientHandler_SetContextAccessIndicator_ParamsMojoType {
    enabled: boolean;
}
export type WebClientHandler_SetContextAccessIndicator_Params = WebClientHandler_SetContextAccessIndicator_ParamsMojoType;
export interface WebClientHandler_GetUserProfileInfo_ParamsMojoType {
}
export type WebClientHandler_GetUserProfileInfo_Params = WebClientHandler_GetUserProfileInfo_ParamsMojoType;
export interface WebClientHandler_GetUserProfileInfo_ResponseParamsMojoType {
    profileInfo: (UserProfileInfo | null);
}
export type WebClientHandler_GetUserProfileInfo_ResponseParams = WebClientHandler_GetUserProfileInfo_ResponseParamsMojoType;
export interface WebClientHandler_SyncCookies_ParamsMojoType {
}
export type WebClientHandler_SyncCookies_Params = WebClientHandler_SyncCookies_ParamsMojoType;
export interface WebClientHandler_SyncCookies_ResponseParamsMojoType {
    success: boolean;
}
export type WebClientHandler_SyncCookies_ResponseParams = WebClientHandler_SyncCookies_ResponseParamsMojoType;
export interface WebClientHandler_LogBeginAsyncEvent_ParamsMojoType {
    eventAsyncId: bigint;
    taskId: number;
    event: string;
    details: string;
}
export type WebClientHandler_LogBeginAsyncEvent_Params = WebClientHandler_LogBeginAsyncEvent_ParamsMojoType;
export interface WebClientHandler_LogEndAsyncEvent_ParamsMojoType {
    eventAsyncId: bigint;
    details: string;
}
export type WebClientHandler_LogEndAsyncEvent_Params = WebClientHandler_LogEndAsyncEvent_ParamsMojoType;
export interface WebClientHandler_LogInstantEvent_ParamsMojoType {
    taskId: number;
    event: string;
    details: string;
}
export type WebClientHandler_LogInstantEvent_Params = WebClientHandler_LogInstantEvent_ParamsMojoType;
export interface WebClientHandler_JournalClear_ParamsMojoType {
}
export type WebClientHandler_JournalClear_Params = WebClientHandler_JournalClear_ParamsMojoType;
export interface WebClientHandler_JournalSnapshot_ParamsMojoType {
    clearJournal: boolean;
}
export type WebClientHandler_JournalSnapshot_Params = WebClientHandler_JournalSnapshot_ParamsMojoType;
export interface WebClientHandler_JournalSnapshot_ResponseParamsMojoType {
    journal: Journal;
}
export type WebClientHandler_JournalSnapshot_ResponseParams = WebClientHandler_JournalSnapshot_ResponseParamsMojoType;
export interface WebClientHandler_JournalStart_ParamsMojoType {
    maxBytes: bigint;
    captureScreenshots: boolean;
}
export type WebClientHandler_JournalStart_Params = WebClientHandler_JournalStart_ParamsMojoType;
export interface WebClientHandler_JournalStop_ParamsMojoType {
}
export type WebClientHandler_JournalStop_Params = WebClientHandler_JournalStop_ParamsMojoType;
export interface WebClientHandler_JournalRecordFeedback_ParamsMojoType {
    positive: boolean;
    reason: string;
}
export type WebClientHandler_JournalRecordFeedback_Params = WebClientHandler_JournalRecordFeedback_ParamsMojoType;
export interface WebClientHandler_OnUserInputSubmitted_ParamsMojoType {
    mode: WebClientMode;
}
export type WebClientHandler_OnUserInputSubmitted_Params = WebClientHandler_OnUserInputSubmitted_ParamsMojoType;
export interface WebClientHandler_OnContextUploadStarted_ParamsMojoType {
}
export type WebClientHandler_OnContextUploadStarted_Params = WebClientHandler_OnContextUploadStarted_ParamsMojoType;
export interface WebClientHandler_OnContextUploadCompleted_ParamsMojoType {
}
export type WebClientHandler_OnContextUploadCompleted_Params = WebClientHandler_OnContextUploadCompleted_ParamsMojoType;
export interface WebClientHandler_OnReaction_ParamsMojoType {
    reactionType: MetricUserInputReactionType;
}
export type WebClientHandler_OnReaction_Params = WebClientHandler_OnReaction_ParamsMojoType;
export interface WebClientHandler_OnResponseStarted_ParamsMojoType {
}
export type WebClientHandler_OnResponseStarted_Params = WebClientHandler_OnResponseStarted_ParamsMojoType;
export interface WebClientHandler_OnResponseStopped_ParamsMojoType {
    details: OnResponseStoppedDetails;
}
export type WebClientHandler_OnResponseStopped_Params = WebClientHandler_OnResponseStopped_ParamsMojoType;
export interface WebClientHandler_OnSessionTerminated_ParamsMojoType {
}
export type WebClientHandler_OnSessionTerminated_Params = WebClientHandler_OnSessionTerminated_ParamsMojoType;
export interface WebClientHandler_OnTurnCompleted_ParamsMojoType {
    model: WebClientModel;
    duration: mojoBase_mojom_TimeDelta;
}
export type WebClientHandler_OnTurnCompleted_Params = WebClientHandler_OnTurnCompleted_ParamsMojoType;
export interface WebClientHandler_OnModelChanged_ParamsMojoType {
    model: WebClientModel;
}
export type WebClientHandler_OnModelChanged_Params = WebClientHandler_OnModelChanged_ParamsMojoType;
export interface WebClientHandler_OnRecordUseCounter_ParamsMojoType {
    counter: number;
}
export type WebClientHandler_OnRecordUseCounter_Params = WebClientHandler_OnRecordUseCounter_ParamsMojoType;
export interface WebClientHandler_OnResponseRated_ParamsMojoType {
    positive: boolean;
}
export type WebClientHandler_OnResponseRated_Params = WebClientHandler_OnResponseRated_ParamsMojoType;
export interface WebClientHandler_OnClosedCaptionsShown_ParamsMojoType {
}
export type WebClientHandler_OnClosedCaptionsShown_Params = WebClientHandler_OnClosedCaptionsShown_ParamsMojoType;
export interface WebClientHandler_ScrollTo_ParamsMojoType {
    params: ScrollToParams;
}
export type WebClientHandler_ScrollTo_Params = WebClientHandler_ScrollTo_ParamsMojoType;
export interface WebClientHandler_ScrollTo_ResponseParamsMojoType {
    errorReason: (ScrollToErrorReason | null);
}
export type WebClientHandler_ScrollTo_ResponseParams = WebClientHandler_ScrollTo_ResponseParamsMojoType;
export interface WebClientHandler_DropScrollToHighlight_ParamsMojoType {
}
export type WebClientHandler_DropScrollToHighlight_Params = WebClientHandler_DropScrollToHighlight_ParamsMojoType;
export interface WebClientHandler_SetSyntheticExperimentState_ParamsMojoType {
    trialName: string;
    groupName: string;
}
export type WebClientHandler_SetSyntheticExperimentState_Params = WebClientHandler_SetSyntheticExperimentState_ParamsMojoType;
export interface WebClientHandler_OpenOsPermissionSettingsMenu_ParamsMojoType {
    type: contentSettings_mojom_ContentSettingsType;
}
export type WebClientHandler_OpenOsPermissionSettingsMenu_Params = WebClientHandler_OpenOsPermissionSettingsMenu_ParamsMojoType;
export interface WebClientHandler_GetOsMicrophonePermissionStatus_ParamsMojoType {
}
export type WebClientHandler_GetOsMicrophonePermissionStatus_Params = WebClientHandler_GetOsMicrophonePermissionStatus_ParamsMojoType;
export interface WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsMojoType {
    enabled: boolean;
}
export type WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParams = WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsMojoType;
export interface WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsMojoType {
    isLive: boolean;
    options: ZeroStateSuggestionsOptions;
}
export type WebClientHandler_GetZeroStateSuggestionsAndSubscribe_Params = WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsMojoType;
export interface WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsMojoType {
    zeroStateSuggestions: (ZeroStateSuggestionsV2 | null);
}
export type WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParams = WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsMojoType;
export interface WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsMojoType {
    isFirstRun: (boolean | null);
}
export type WebClientHandler_GetZeroStateSuggestionsForFocusedTab_Params = WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsMojoType;
export interface WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsMojoType {
    suggestions: (ZeroStateSuggestions | null);
}
export type WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParams = WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsMojoType;
export interface WebClientHandler_MaybeRefreshUserStatus_ParamsMojoType {
}
export type WebClientHandler_MaybeRefreshUserStatus_Params = WebClientHandler_MaybeRefreshUserStatus_ParamsMojoType;
export interface WebClientHandler_IsDebuggerAttached_ParamsMojoType {
}
export type WebClientHandler_IsDebuggerAttached_Params = WebClientHandler_IsDebuggerAttached_ParamsMojoType;
export interface WebClientHandler_IsDebuggerAttached_ResponseParamsMojoType {
    isAttachedToWebview: boolean;
}
export type WebClientHandler_IsDebuggerAttached_ResponseParams = WebClientHandler_IsDebuggerAttached_ResponseParamsMojoType;
export interface WebClientHandler_OnViewChanged_ParamsMojoType {
    notification: ViewChangedNotification;
}
export type WebClientHandler_OnViewChanged_Params = WebClientHandler_OnViewChanged_ParamsMojoType;
export interface WebClientHandler_SubscribeToPageMetadata_ParamsMojoType {
    tabId: number;
    names: string[];
}
export type WebClientHandler_SubscribeToPageMetadata_Params = WebClientHandler_SubscribeToPageMetadata_ParamsMojoType;
export interface WebClientHandler_SubscribeToPageMetadata_ResponseParamsMojoType {
    success: boolean;
}
export type WebClientHandler_SubscribeToPageMetadata_ResponseParams = WebClientHandler_SubscribeToPageMetadata_ResponseParamsMojoType;
export interface WebClientHandler_SwitchConversation_ParamsMojoType {
    info: (ConversationInfo | null);
}
export type WebClientHandler_SwitchConversation_Params = WebClientHandler_SwitchConversation_ParamsMojoType;
export interface WebClientHandler_SwitchConversation_ResponseParamsMojoType {
    errorReason: (SwitchConversationErrorReason | null);
}
export type WebClientHandler_SwitchConversation_ResponseParams = WebClientHandler_SwitchConversation_ResponseParamsMojoType;
export interface WebClientHandler_RegisterConversation_ParamsMojoType {
    info: ConversationInfo;
}
export type WebClientHandler_RegisterConversation_Params = WebClientHandler_RegisterConversation_ParamsMojoType;
export interface WebClientHandler_RegisterConversation_ResponseParamsMojoType {
    errorReason: (RegisterConversationErrorReason | null);
}
export type WebClientHandler_RegisterConversation_ResponseParams = WebClientHandler_RegisterConversation_ResponseParamsMojoType;
export interface WebClientHandler_SetOnboardingCompleted_ParamsMojoType {
}
export type WebClientHandler_SetOnboardingCompleted_Params = WebClientHandler_SetOnboardingCompleted_ParamsMojoType;
export interface WebClient_NotifyPanelWillOpen_ParamsMojoType {
    panelOpeningData: PanelOpeningData;
}
export type WebClient_NotifyPanelWillOpen_Params = WebClient_NotifyPanelWillOpen_ParamsMojoType;
export interface WebClient_NotifyPanelWillOpen_ResponseParamsMojoType {
    openPanelInfo: OpenPanelInfo;
}
export type WebClient_NotifyPanelWillOpen_ResponseParams = WebClient_NotifyPanelWillOpen_ResponseParamsMojoType;
export interface WebClient_NotifyPanelWasClosed_ParamsMojoType {
}
export type WebClient_NotifyPanelWasClosed_Params = WebClient_NotifyPanelWasClosed_ParamsMojoType;
export interface WebClient_NotifyPanelWasClosed_ResponseParamsMojoType {
}
export type WebClient_NotifyPanelWasClosed_ResponseParams = WebClient_NotifyPanelWasClosed_ResponseParamsMojoType;
export interface WebClient_NotifyPanelStateChange_ParamsMojoType {
    panelState: PanelState;
}
export type WebClient_NotifyPanelStateChange_Params = WebClient_NotifyPanelStateChange_ParamsMojoType;
export interface WebClient_NotifyPanelActiveChange_ParamsMojoType {
    panelActive: boolean;
}
export type WebClient_NotifyPanelActiveChange_Params = WebClient_NotifyPanelActiveChange_ParamsMojoType;
export interface WebClient_NotifyPanelCanAttachChange_ParamsMojoType {
    canAttach: boolean;
}
export type WebClient_NotifyPanelCanAttachChange_Params = WebClient_NotifyPanelCanAttachChange_ParamsMojoType;
export interface WebClient_NotifyMicrophonePermissionStateChanged_ParamsMojoType {
    enabled: boolean;
}
export type WebClient_NotifyMicrophonePermissionStateChanged_Params = WebClient_NotifyMicrophonePermissionStateChanged_ParamsMojoType;
export interface WebClient_NotifyLocationPermissionStateChanged_ParamsMojoType {
    enabled: boolean;
}
export type WebClient_NotifyLocationPermissionStateChanged_Params = WebClient_NotifyLocationPermissionStateChanged_ParamsMojoType;
export interface WebClient_NotifyTabContextPermissionStateChanged_ParamsMojoType {
    enabled: boolean;
}
export type WebClient_NotifyTabContextPermissionStateChanged_Params = WebClient_NotifyTabContextPermissionStateChanged_ParamsMojoType;
export interface WebClient_NotifyOsLocationPermissionStateChanged_ParamsMojoType {
    enabled: boolean;
}
export type WebClient_NotifyOsLocationPermissionStateChanged_Params = WebClient_NotifyOsLocationPermissionStateChanged_ParamsMojoType;
export interface WebClient_NotifyFocusedTabChanged_ParamsMojoType {
    focusedTabData: FocusedTabData;
}
export type WebClient_NotifyFocusedTabChanged_Params = WebClient_NotifyFocusedTabChanged_ParamsMojoType;
export interface WebClient_NotifyManualResizeChanged_ParamsMojoType {
    resizing: boolean;
}
export type WebClient_NotifyManualResizeChanged_Params = WebClient_NotifyManualResizeChanged_ParamsMojoType;
export interface WebClient_NotifyOsHotkeyStateChanged_ParamsMojoType {
    hotkey: string;
}
export type WebClient_NotifyOsHotkeyStateChanged_Params = WebClient_NotifyOsHotkeyStateChanged_ParamsMojoType;
export interface WebClient_NotifyBrowserIsOpenChanged_ParamsMojoType {
    browserIsOpen: boolean;
}
export type WebClient_NotifyBrowserIsOpenChanged_Params = WebClient_NotifyBrowserIsOpenChanged_ParamsMojoType;
export interface WebClient_NotifyInstanceActivationChanged_ParamsMojoType {
    instanceActive: boolean;
}
export type WebClient_NotifyInstanceActivationChanged_Params = WebClient_NotifyInstanceActivationChanged_ParamsMojoType;
export interface WebClient_NotifyClosedCaptioningSettingChanged_ParamsMojoType {
    enabled: boolean;
}
export type WebClient_NotifyClosedCaptioningSettingChanged_Params = WebClient_NotifyClosedCaptioningSettingChanged_ParamsMojoType;
export interface WebClient_NotifyPinnedTabsChanged_ParamsMojoType {
    tabData: TabData[];
}
export type WebClient_NotifyPinnedTabsChanged_Params = WebClient_NotifyPinnedTabsChanged_ParamsMojoType;
export interface WebClient_NotifyPinnedTabDataChanged_ParamsMojoType {
    tabData: TabData;
}
export type WebClient_NotifyPinnedTabDataChanged_Params = WebClient_NotifyPinnedTabDataChanged_ParamsMojoType;
export interface WebClient_NotifyZeroStateSuggestionsChanged_ParamsMojoType {
    suggestions: (ZeroStateSuggestionsV2 | null);
    options: ZeroStateSuggestionsOptions;
}
export type WebClient_NotifyZeroStateSuggestionsChanged_Params = WebClient_NotifyZeroStateSuggestionsChanged_ParamsMojoType;
export interface WebClient_NotifyActorTaskStateChanged_ParamsMojoType {
    taskId: number;
    state: ActorTaskState;
}
export type WebClient_NotifyActorTaskStateChanged_Params = WebClient_NotifyActorTaskStateChanged_ParamsMojoType;
export interface WebClient_NotifyTabDataChanged_ParamsMojoType {
    tabData: TabData;
}
export type WebClient_NotifyTabDataChanged_Params = WebClient_NotifyTabDataChanged_ParamsMojoType;
export interface WebClient_RequestViewChange_ParamsMojoType {
    request: ViewChangeRequest;
}
export type WebClient_RequestViewChange_Params = WebClient_RequestViewChange_ParamsMojoType;
export interface WebClient_NotifyPageMetadataChanged_ParamsMojoType {
    tabId: number;
    metadata: (blink_mojom_PageMetadata | null);
}
export type WebClient_NotifyPageMetadataChanged_Params = WebClient_NotifyPageMetadataChanged_ParamsMojoType;
export interface WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsMojoType {
    enabled: boolean;
}
export type WebClient_NotifyDefaultTabContextPermissionStateChanged_Params = WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsMojoType;
export interface WebClient_RequestToShowCredentialSelectionDialog_ParamsMojoType {
    request: actor_webui_mojom_SelectCredentialDialogRequest;
}
export type WebClient_RequestToShowCredentialSelectionDialog_Params = WebClient_RequestToShowCredentialSelectionDialog_ParamsMojoType;
export interface WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsMojoType {
    response: actor_webui_mojom_SelectCredentialDialogResponse;
}
export type WebClient_RequestToShowCredentialSelectionDialog_ResponseParams = WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsMojoType;
export interface WebClient_RequestToShowAutofillSuggestionsDialog_ParamsMojoType {
    request: actor_webui_mojom_SelectAutofillSuggestionsDialogRequest;
}
export type WebClient_RequestToShowAutofillSuggestionsDialog_Params = WebClient_RequestToShowAutofillSuggestionsDialog_ParamsMojoType;
export interface WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParamsMojoType {
    response: actor_webui_mojom_SelectAutofillSuggestionsDialogResponse;
}
export type WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParams = WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParamsMojoType;
export interface WebClient_RequestToShowUserConfirmationDialog_ParamsMojoType {
    request: actor_webui_mojom_UserConfirmationDialogRequest;
}
export type WebClient_RequestToShowUserConfirmationDialog_Params = WebClient_RequestToShowUserConfirmationDialog_ParamsMojoType;
export interface WebClient_RequestToShowUserConfirmationDialog_ResponseParamsMojoType {
    response: actor_webui_mojom_UserConfirmationDialogResponse;
}
export type WebClient_RequestToShowUserConfirmationDialog_ResponseParams = WebClient_RequestToShowUserConfirmationDialog_ResponseParamsMojoType;
export interface WebClient_RequestToConfirmNavigation_ParamsMojoType {
    request: actor_webui_mojom_NavigationConfirmationRequest;
}
export type WebClient_RequestToConfirmNavigation_Params = WebClient_RequestToConfirmNavigation_ParamsMojoType;
export interface WebClient_RequestToConfirmNavigation_ResponseParamsMojoType {
    response: actor_webui_mojom_NavigationConfirmationResponse;
}
export type WebClient_RequestToConfirmNavigation_ResponseParams = WebClient_RequestToConfirmNavigation_ResponseParamsMojoType;
export interface WebClient_NotifyAdditionalContext_ParamsMojoType {
    context: AdditionalContext;
}
export type WebClient_NotifyAdditionalContext_Params = WebClient_NotifyAdditionalContext_ParamsMojoType;
export interface WebClient_NotifyActuationOnWebSettingChanged_ParamsMojoType {
    enabled: boolean;
}
export type WebClient_NotifyActuationOnWebSettingChanged_Params = WebClient_NotifyActuationOnWebSettingChanged_ParamsMojoType;
export interface WebClient_NotifyActOnWebCapabilityChanged_ParamsMojoType {
    canActOnWeb: boolean;
}
export type WebClient_NotifyActOnWebCapabilityChanged_Params = WebClient_NotifyActOnWebCapabilityChanged_ParamsMojoType;
export interface WebClient_NotifyOnboardingCompletedChanged_ParamsMojoType {
    completed: boolean;
}
export type WebClient_NotifyOnboardingCompletedChanged_Params = WebClient_NotifyOnboardingCompletedChanged_ParamsMojoType;
export interface CaptureRegionObserver_OnUpdate_ParamsMojoType {
    result: (CaptureRegionResult | null);
    reason: (CaptureRegionErrorReason | null);
}
export type CaptureRegionObserver_OnUpdate_Params = CaptureRegionObserver_OnUpdate_ParamsMojoType;
export interface GetContextResult {
    errorReason?: string;
    tabContext?: TabContext;
}
export declare enum GetContextResultFieldTags {
    ERROR_REASON = 0,
    TAB_CONTEXT = 1
}
export declare function whichGetContextResult(u: GetContextResult): GetContextResultFieldTags;
export interface CaptureScreenshotResult {
    errorReason?: CaptureScreenshotErrorReason;
    screenshot?: Screenshot;
}
export declare enum CaptureScreenshotResultFieldTags {
    ERROR_REASON = 0,
    SCREENSHOT = 1
}
export declare function whichCaptureScreenshotResult(u: CaptureScreenshotResult): CaptureScreenshotResultFieldTags;
export interface ScrollToSelector {
    exactTextSelector?: ScrollToTextSelector;
    textFragmentSelector?: ScrollToTextFragmentSelector;
    nodeSelector?: ScrollToNodeSelector;
}
export declare enum ScrollToSelectorFieldTags {
    EXACT_TEXT_SELECTOR = 0,
    TEXT_FRAGMENT_SELECTOR = 1,
    NODE_SELECTOR = 2
}
export declare function whichScrollToSelector(u: ScrollToSelector): ScrollToSelectorFieldTags;
export interface AdditionalContextPart {
    data?: ContextData;
    screenshot?: Screenshot;
    webPageData?: WebPageData;
    annotatedPageData?: AnnotatedPageData;
    pdfDocumentData?: PdfDocumentData;
    tabContext?: TabContext;
}
export declare enum AdditionalContextPartFieldTags {
    DATA = 0,
    SCREENSHOT = 1,
    WEB_PAGE_DATA = 2,
    ANNOTATED_PAGE_DATA = 3,
    PDF_DOCUMENT_DATA = 4,
    TAB_CONTEXT = 5
}
export declare function whichAdditionalContextPart(u: AdditionalContextPart): AdditionalContextPartFieldTags;
export interface FocusedTabData {
    focusedTab?: TabData;
    noFocusedTabData?: NoFocusedTabData;
}
export declare enum FocusedTabDataFieldTags {
    FOCUSED_TAB = 0,
    NO_FOCUSED_TAB_DATA = 1
}
export declare function whichFocusedTabData(u: FocusedTabData): FocusedTabDataFieldTags;
export interface CapturedRegion {
    rect?: gfx_mojom_Rect;
}
export declare enum CapturedRegionFieldTags {
    RECT = 0
}
export declare function whichCapturedRegion(u: CapturedRegion): CapturedRegionFieldTags;
export interface ViewChangeRequestDetails {
    actuation?: ViewChangeRequestActuation;
    conversation?: ViewChangeRequestConversation;
}
export declare enum ViewChangeRequestDetailsFieldTags {
    ACTUATION = 0,
    CONVERSATION = 1
}
export declare function whichViewChangeRequestDetails(u: ViewChangeRequestDetails): ViewChangeRequestDetailsFieldTags;
export interface WebClientHandler_CreateTask_ResponseParam_Result {
    success?: number;
    failure?: CreateTaskErrorReason;
}
export declare enum WebClientHandler_CreateTask_ResponseParam_ResultFieldTags {
    SUCCESS = 0,
    FAILURE = 1
}
export declare function whichWebClientHandler_CreateTask_ResponseParam_Result(u: WebClientHandler_CreateTask_ResponseParam_Result): WebClientHandler_CreateTask_ResponseParam_ResultFieldTags;
export interface WebClientHandler_PerformActions_ResponseParam_Result {
    success?: mojoBase_mojom_ProtoWrapper;
    failure?: PerformActionsErrorReason;
}
export declare enum WebClientHandler_PerformActions_ResponseParam_ResultFieldTags {
    SUCCESS = 0,
    FAILURE = 1
}
export declare function whichWebClientHandler_PerformActions_ResponseParam_Result(u: WebClientHandler_PerformActions_ResponseParam_Result): WebClientHandler_PerformActions_ResponseParam_ResultFieldTags;
