// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{exceptionFromTransferable,newTransferableException}from"./request_types.js";export function newSenderId(){const array=new Uint8Array(8);crypto.getRandomValues(array);return Array.from(array).map((n=>n.toString(16))).join("")}export class ResponseExtras{transfers=[];addTransfer(...transfers){this.transfers.push(...transfers)}}class MessageLogger{prefix;loggingEnabled=false;loggingPrefix;constructor(senderId,prefix){this.prefix=prefix;this.loggingPrefix=`${prefix}(${senderId.substring(0,6)})`}setLoggingEnabled(v){this.loggingEnabled=v}shouldLogMessage(requestType){return this.loggingEnabled&&requestType!=="glicWebClientCheckResponsive"}maybeLogMessage(requestType,message,payload){if(!this.shouldLogMessage(requestType)){return}console.info(`${this.loggingPrefix} [${requestType}] ${message}: ${toDebugJson(payload)}`,payload)}}export class PostMessageRequestSender extends MessageLogger{messageSender;remoteOrigin;senderId;requestId=1;responseHandlers=new Map;onDestroy;constructor(messageSender,remoteOrigin,senderId,logPrefix){super(senderId,logPrefix);this.messageSender=messageSender;this.remoteOrigin=remoteOrigin;this.senderId=senderId;const handler=this.onMessage.bind(this);window.addEventListener("message",handler);this.onDestroy=()=>{window.removeEventListener("message",handler)}}destroy(){this.onDestroy()}onMessage(event){if(event.origin!==this.remoteOrigin||event.data.senderId!==this.senderId||event.data.type===undefined||event.data.responseId===undefined){return}const response=event.data;const handler=this.responseHandlers.get(response.responseId);if(!handler){return}this.responseHandlers.delete(response.responseId);handler(response)}requestWithResponse(requestType,request,transfer=[]){const{promise:promise,resolve:resolve,reject:reject}=Promise.withResolvers();const requestId=this.requestId++;this.responseHandlers.set(requestId,(response=>{if(response.exception!==undefined){this.maybeLogMessage(requestType,"received with exception",response.exception);reject(exceptionFromTransferable(response.exception))}else{this.maybeLogMessage(requestType,"received",response.responsePayload);resolve(response.responsePayload)}}));this.maybeLogMessage(requestType,"sending",request);const message={senderId:this.senderId,glicRequest:true,requestId:requestId,type:requestType,requestPayload:request};this.messageSender.postMessage(message,this.remoteOrigin,transfer);return promise}requestNoResponse(requestType,request,transfer=[]){const message={senderId:this.senderId,glicRequest:true,requestId:undefined,type:requestType,requestPayload:request};this.maybeLogMessage(requestType,"sending",request);this.messageSender.postMessage(message,this.remoteOrigin,transfer)}}export class PostMessageRequestReceiver extends MessageLogger{embeddedOrigin;postMessageSender;handler;onDestroy;constructor(embeddedOrigin,senderId,postMessageSender,handler,logPrefix){super(senderId,logPrefix);this.embeddedOrigin=embeddedOrigin;this.postMessageSender=postMessageSender;this.handler=handler;const handlerFunction=this.onMessage.bind(this);window.addEventListener("message",handlerFunction);this.onDestroy=()=>{window.removeEventListener("message",handlerFunction)}}destroy(){this.onDestroy()}async onMessage(event){if(event.origin!==this.embeddedOrigin||!event.source||!event.data.glicRequest){return}const requestMessage=event.data;const{requestId:requestId,type:type,requestPayload:requestPayload,senderId:senderId}=requestMessage;let response;let exception;const extras=new ResponseExtras;this.handler.onRequestReceived(type);this.maybeLogMessage(type,"processing request",requestPayload);try{response=await this.handler.handleRawRequest(type,requestPayload,extras)}catch(error){this.handler.onRequestHandlerException(type);console.warn("Unexpected error",error);if(error instanceof Error){exception=newTransferableException(error)}else{exception=newTransferableException(new Error(`Unexpected error: ${error}`))}}if(!exception){this.handler.onRequestCompleted(type)}if(!requestId){return}this.maybeLogMessage(type,"sending response",response?.payload);const responseMessage={type:type,responseId:requestId,responsePayload:response?.payload,senderId:senderId};if(exception){responseMessage.exception=exception}this.postMessageSender.postMessage(responseMessage,this.embeddedOrigin,extras.transfers)}}function toDebugJson(v){return JSON.stringify(v,((_key,value)=>{if(typeof value==="bigint"){return value.toString()}return value}))}