// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{WebClientHandlerRemote}from"../../glic.mojom-webui.js";import{ObservableValue}from"../../observable.js";import{OneShotTimer}from"../../timer.js";import{newSenderId,PostMessageRequestReceiver,PostMessageRequestSender}from"./../post_message_transport.js";import{HOST_REQUEST_TYPES,requestTypeToHistogramSuffix}from"./../request_types.js";import{urlFromClient}from"./conversions.js";import{GatedSender}from"./gated_sender.js";import{HostMessageHandler}from"./host_from_client.js";import{BACKGROUND_RESPONSES}from"./types.js";export var WebClientState;(function(WebClientState){WebClientState[WebClientState["UNINITIALIZED"]=0]="UNINITIALIZED";WebClientState[WebClientState["RESPONSIVE"]=1]="RESPONSIVE";WebClientState[WebClientState["UNRESPONSIVE"]=2]="UNRESPONSIVE";WebClientState[WebClientState["ERROR"]=3]="ERROR"})(WebClientState||(WebClientState={}));var PanelOpenState;(function(PanelOpenState){PanelOpenState[PanelOpenState["OPEN"]=0]="OPEN";PanelOpenState[PanelOpenState["CLOSED"]=1]="CLOSED"})(PanelOpenState||(PanelOpenState={}));export var DetailedWebClientState;(function(DetailedWebClientState){DetailedWebClientState[DetailedWebClientState["BOOTSTRAP_PENDING"]=0]="BOOTSTRAP_PENDING";DetailedWebClientState[DetailedWebClientState["WEB_CLIENT_NOT_CREATED"]=1]="WEB_CLIENT_NOT_CREATED";DetailedWebClientState[DetailedWebClientState["WEB_CLIENT_INITIALIZE_FAILED"]=2]="WEB_CLIENT_INITIALIZE_FAILED";DetailedWebClientState[DetailedWebClientState["WEB_CLIENT_NOT_INITIALIZED"]=3]="WEB_CLIENT_NOT_INITIALIZED";DetailedWebClientState[DetailedWebClientState["TEMPORARY_UNRESPONSIVE"]=4]="TEMPORARY_UNRESPONSIVE";DetailedWebClientState[DetailedWebClientState["PERMANENT_UNRESPONSIVE"]=5]="PERMANENT_UNRESPONSIVE";DetailedWebClientState[DetailedWebClientState["RESPONSIVE"]=6]="RESPONSIVE";DetailedWebClientState[DetailedWebClientState["RESPONSIVE_INACTIVE"]=7]="RESPONSIVE_INACTIVE";DetailedWebClientState[DetailedWebClientState["UNRESPONSIVE_INACTIVE"]=8]="UNRESPONSIVE_INACTIVE";DetailedWebClientState[DetailedWebClientState["MOJO_PIPE_CLOSED_UNEXPECTEDLY"]=9]="MOJO_PIPE_CLOSED_UNEXPECTEDLY";DetailedWebClientState[DetailedWebClientState["MAX_VALUE"]=9]="MAX_VALUE"})(DetailedWebClientState||(DetailedWebClientState={}));export class GlicApiCommunicator{embeddedOrigin;windowProxy;senderId=newSenderId();postMessageReceiver;postMessageSender;bootstrapPingIntervalId;loggingEnabled=loadTimeData.getBoolean("loggingEnabled");host;hostPromise=Promise.withResolvers();constructor(embeddedOrigin,windowProxy){this.embeddedOrigin=embeddedOrigin;this.windowProxy=windowProxy;this.postMessageReceiver=new PostMessageRequestReceiver(embeddedOrigin,this.senderId,windowProxy,this,"glic_api_host");this.postMessageReceiver.setLoggingEnabled(this.loggingEnabled);this.postMessageSender=new PostMessageRequestSender(windowProxy,embeddedOrigin,this.senderId,"glic_api_host");this.postMessageSender.setLoggingEnabled(this.loggingEnabled);this.bootstrapPingIntervalId=window.setInterval(this.bootstrapPing.bind(this),50);this.bootstrapPing()}destroy(){window.clearInterval(this.bootstrapPingIntervalId);this.postMessageReceiver.destroy();this.postMessageSender.destroy()}setHost(host){assert(!this.host);this.host=host;this.hostPromise.resolve(host)}contentLoaded(){this.bootstrapPing();this.stopBootstrapPing()}handleRawRequest(type,payload,extras){this.stopBootstrapPing();if(type==="glicBrowserWebClientCreated"){return this.hostPromise.promise.then((h=>{this.postMessageReceiver.handler=h;return h.handleRawRequest(type,payload,extras)}))}else{return Promise.resolve(undefined)}}onRequestReceived(_type){}onRequestHandlerException(_type){}onRequestCompleted(_type){}stopBootstrapPing(){if(this.bootstrapPingIntervalId!==undefined){window.clearInterval(this.bootstrapPingIntervalId);this.bootstrapPingIntervalId=undefined}}bootstrapPing(){if(this.bootstrapPingIntervalId===undefined){return}this.windowProxy.postMessage({type:"glic-bootstrap",glicApiSource:loadTimeData.getString("glicGuestAPISource")},this.embeddedOrigin)}}export class GlicApiHost{browserProxy;messageHandler;sender;enableApiActivationGating=true;panelIsActive=false;handler;webClientErrorTimer;webClientState=ObservableValue.withValue(WebClientState.UNINITIALIZED);waitingOnPanelWillOpenValue=false;clientActiveObs=ObservableValue.withValue(false);panelOpenState=PanelOpenState.CLOSED;instanceIsActive=true;hasShownDebuggerAttachedWarning=false;loggingEnabled=loadTimeData.getBoolean("loggingEnabled");detailedWebClientState=DetailedWebClientState.BOOTSTRAP_PENDING;pinCandidatesObserver;captureRegionObserver;constructor(browserProxy,communicator,embedder){this.browserProxy=browserProxy;this.sender=new GatedSender(communicator.postMessageSender);this.handler=new WebClientHandlerRemote;this.handler.onConnectionError.addListener((()=>{if(this.webClientState.getCurrentValue()!==WebClientState.ERROR){console.warn(`Mojo connection error in glic host`);this.detailedWebClientState=DetailedWebClientState.MOJO_PIPE_CLOSED_UNEXPECTEDLY;this.webClientState.assignAndSignal(WebClientState.ERROR)}}));this.handler.$.close();this.browserProxy.handler.createWebClient(this.handler.$.bindNewPipeAndPassReceiver());this.messageHandler=new HostMessageHandler(this.handler,this.sender,embedder,this);this.webClientErrorTimer=new OneShotTimer(loadTimeData.getInteger("clientUnresponsiveUiMaxTimeMs"));communicator.setHost(this)}destroy(){this.webClientState=ObservableValue.withValue(WebClientState.ERROR);this.webClientErrorTimer.reset();this.messageHandler.destroy();this.pinCandidatesObserver?.disconnectFromSource();this.captureRegionObserver?.destroy()}setInitialState(initialState){this.enableApiActivationGating=initialState.enableApiActivationGating;this.panelIsActive=initialState.panelIsActive;this.updateSenderActive()}updateSenderActive(){const shouldGate=this.shouldGateRequests();if(this.sender.isGating()===shouldGate){return}if(shouldGate){this.captureRegionObserver?.destroy();this.captureRegionObserver=undefined}this.sender.setGating(shouldGate)}shouldGateRequests(){return!this.panelIsActive&&this.enableApiActivationGating}waitingOnPanelWillOpen(){return this.waitingOnPanelWillOpenValue}setWaitingOnPanelWillOpen(value){this.waitingOnPanelWillOpenValue=value}panelOpenStateChanged(state){this.panelOpenState=state;this.clientActiveObs.assignAndSignal(this.isClientActive());if(state===PanelOpenState.CLOSED){this.pinCandidatesObserver?.disconnectFromSource();this.captureRegionObserver?.destroy();this.captureRegionObserver=undefined}else{this.pinCandidatesObserver?.connectToSource()}}setInstanceIsActive(instanceIsActive){this.instanceIsActive=instanceIsActive;this.clientActiveObs.assignAndSignal(this.isClientActive())}isClientActive(){return this.panelOpenState===PanelOpenState.OPEN&&this.webClientState.getCurrentValue()!==WebClientState.ERROR&&this.instanceIsActive}webClientInitialized(){this.detailedWebClientState=DetailedWebClientState.RESPONSIVE;this.setWebClientState(WebClientState.RESPONSIVE);this.responsiveCheckLoop()}webClientInitializeFailed(){console.warn("GlicApiHost: web client initialize failed");this.detailedWebClientState=DetailedWebClientState.WEB_CLIENT_INITIALIZE_FAILED;this.setWebClientState(WebClientState.ERROR)}setWebClientState(state){this.webClientState.assignAndSignal(state)}getWebClientState(){return this.webClientState}getDetailedWebClientState(){return this.detailedWebClientState}async responsiveCheckLoop(){if(!loadTimeData.getBoolean("isClientResponsivenessCheckEnabled")){return}const timeoutMs=loadTimeData.getInteger("clientResponsivenessCheckTimeoutMs")*(loadTimeData.getBoolean("devMode")?1e3:1);const checkIntervalMs=loadTimeData.getInteger("clientResponsivenessCheckIntervalMs");while(this.webClientState.getCurrentValue()!==WebClientState.ERROR){if(!this.isClientActive()){if(this.webClientState.getCurrentValue()===WebClientState.UNRESPONSIVE){this.detailedWebClientState=DetailedWebClientState.UNRESPONSIVE_INACTIVE;this.setWebClientState(WebClientState.RESPONSIVE);this.webClientErrorTimer.reset()}else{this.detailedWebClientState=DetailedWebClientState.RESPONSIVE_INACTIVE}await this.clientActiveObs.waitUntil((active=>active))}let gotResponse=false;const responsePromise=this.sender.requestWithResponse("glicWebClientCheckResponsive",undefined).then((()=>{gotResponse=true}));const responseTimeout=sleep(timeoutMs);await Promise.race([responsePromise,responseTimeout]);if(this.webClientState.getCurrentValue()===WebClientState.ERROR){return}if(gotResponse){this.webClientErrorTimer.reset();this.setWebClientState(WebClientState.RESPONSIVE);this.detailedWebClientState=DetailedWebClientState.RESPONSIVE;await sleep(checkIntervalMs);continue}if(this.webClientState.getCurrentValue()===WebClientState.RESPONSIVE){const ignoreUnresponsiveClient=await this.shouldAllowUnresponsiveClient();if(!ignoreUnresponsiveClient){console.warn("GlicApiHost: web client is unresponsive");this.detailedWebClientState=DetailedWebClientState.TEMPORARY_UNRESPONSIVE;this.setWebClientState(WebClientState.UNRESPONSIVE);this.startWebClientErrorTimer()}}await responsePromise}}async shouldAllowUnresponsiveClient(){if(loadTimeData.getBoolean("clientResponsivenessCheckIgnoreWhenDebuggerAttached")){const isDebuggerAttached=await this.handler.isDebuggerAttached().then((result=>result.isAttachedToWebview)).catch((()=>false));if(isDebuggerAttached){if(!this.hasShownDebuggerAttachedWarning){console.warn("GlicApiHost: ignoring unresponsive client because "+"a debugger (likely DevTools) is attached");this.hasShownDebuggerAttachedWarning=true}return true}}return false}startWebClientErrorTimer(){this.webClientErrorTimer.start((()=>{console.warn("GlicApiHost: web client is permanently unresponsive");this.detailedWebClientState=DetailedWebClientState.PERMANENT_UNRESPONSIVE;this.setWebClientState(WebClientState.ERROR)}))}openLinkInPopup(url,initialWidth,initialHeight){this.handler.openLinkInPopup(urlFromClient(url),initialWidth,initialHeight)}async openLinkInNewTab(url){await this.handler.createTab(urlFromClient(url),false,null)}async shouldAllowMediaPermissionRequest(){return(await this.handler.shouldAllowMediaPermissionRequest()).isAllowed}async shouldAllowGeolocationPermissionRequest(){return(await this.handler.shouldAllowGeolocationPermissionRequest()).isAllowed}async handleRawRequest(type,payload,extras){const handlerFunction=this.messageHandler[type];if(typeof handlerFunction!=="function"){console.warn(`GlicApiHost: Unknown message type ${type}`);return}if(this.detailedWebClientState===DetailedWebClientState.BOOTSTRAP_PENDING){this.detailedWebClientState=DetailedWebClientState.WEB_CLIENT_NOT_CREATED}let response;if(this.shouldGateRequests()&&Object.hasOwn(BACKGROUND_RESPONSES,type)){const backgroundResponse=BACKGROUND_RESPONSES[type];if(Object.hasOwn(backgroundResponse,"throws")){const friendlyName=type.replaceAll(/^glicBrowser|^glicWebClient/g,"");throw new Error(`${friendlyName} not allowed while backgrounded`)}if(this.loggingEnabled){console.warn(`Using background request behavior for ${type}`)}if(Object.hasOwn(backgroundResponse,"does")){response=await backgroundResponse.does()}else{response=backgroundResponse.returns}}else{response=await handlerFunction.call(this.messageHandler,payload,extras)}if(!response){return}return{payload:response}}onRequestReceived(type){this.reportRequestCountEvent(type,GlicRequestEvent.REQUEST_RECEIVED);if(document.visibilityState==="hidden"){this.reportRequestCountEvent(type,GlicRequestEvent.REQUEST_RECEIVED_WHILE_HIDDEN)}}onRequestHandlerException(type){this.reportRequestCountEvent(type,GlicRequestEvent.REQUEST_HANDLER_EXCEPTION)}onRequestCompleted(type){this.reportRequestCountEvent(type,GlicRequestEvent.RESPONSE_SENT)}reportRequestCountEvent(requestType,event){const histogramSuffix=requestTypeToHistogramSuffix(requestType);if(histogramSuffix===undefined){return}const requestTypeNumber=HOST_REQUEST_TYPES[histogramSuffix];if(!requestTypeNumber){console.warn(`reportRequestCountEvent: invalid requestType ${histogramSuffix}`);return}chrome.metricsPrivate.recordEnumerationValue(`Glic.Api.RequestCounts.${histogramSuffix}`,event,GlicRequestEvent.MAX_VALUE+1);switch(event){case GlicRequestEvent.REQUEST_HANDLER_EXCEPTION:chrome.metricsPrivate.recordEnumerationValue(`Glic.Api.RequestCounts.Error`,requestTypeNumber,HOST_REQUEST_TYPES.MAX_VALUE+1);break;case GlicRequestEvent.REQUEST_RECEIVED_WHILE_HIDDEN:chrome.metricsPrivate.recordEnumerationValue(`Glic.Api.RequestCounts.Hidden`,requestTypeNumber,HOST_REQUEST_TYPES.MAX_VALUE+1);break;case GlicRequestEvent.REQUEST_RECEIVED:chrome.metricsPrivate.recordEnumerationValue(`Glic.Api.RequestCounts.Received`,requestTypeNumber,HOST_REQUEST_TYPES.MAX_VALUE+1);break;default:break}}}var GlicRequestEvent;(function(GlicRequestEvent){GlicRequestEvent[GlicRequestEvent["REQUEST_RECEIVED"]=0]="REQUEST_RECEIVED";GlicRequestEvent[GlicRequestEvent["RESPONSE_SENT"]=1]="RESPONSE_SENT";GlicRequestEvent[GlicRequestEvent["REQUEST_HANDLER_EXCEPTION"]=2]="REQUEST_HANDLER_EXCEPTION";GlicRequestEvent[GlicRequestEvent["REQUEST_RECEIVED_WHILE_HIDDEN"]=3]="REQUEST_RECEIVED_WHILE_HIDDEN";GlicRequestEvent[GlicRequestEvent["MAX_VALUE"]=3]="MAX_VALUE"})(GlicRequestEvent||(GlicRequestEvent={}));function sleep(ms){return new Promise((resolve=>setTimeout(resolve,ms)))}