// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{ActorTaskPauseReason,ActorTaskState,ActorTaskStopReason,HostCapability}from"../../glic_api/glic_api.js";import{ObservableValue as ObservableValueImpl,Subject}from"../../observable.js";import{replaceProperties}from"./../conversions.js";import{newSenderId,PostMessageRequestReceiver,PostMessageRequestSender}from"./../post_message_transport.js";import{ConfirmationRequestErrorReason,ErrorWithReasonImpl,ImageAlphaType,ImageColorType,newTransferableException,SelectAutofillSuggestionsDialogErrorReason,SelectCredentialDialogErrorReason}from"./../request_types.js";export class GlicHostRegistryImpl{windowProxy;host;constructor(windowProxy){this.windowProxy=windowProxy}async registerWebClient(webClient){this.host=new GlicBrowserHostImpl(webClient,this.windowProxy);await this.host.webClientCreated();let success=false;let exception;try{await webClient.initialize(this.host);success=true}catch(e){console.warn(e);if(e instanceof Error){exception=newTransferableException(e)}}if(this.host){this.host.webClientInitialized(success,exception)}}}class WebClientMessageHandler{webClient;host;cachedPinnedTabs=undefined;constructor(webClient,host){this.webClient=webClient;this.host=host}async glicWebClientNotifyPanelWillOpen(payload){let openPanelInfo;try{const mergedArgument=Object.assign({},payload.panelOpeningData,payload.panelOpeningData.panelState);const result=await(this.webClient.notifyPanelWillOpen?.(mergedArgument));if(result){openPanelInfo=result}}catch(e){console.warn(e)}return{openPanelInfo:openPanelInfo}}async glicWebClientNotifyPanelWasClosed(){try{await(this.webClient.notifyPanelWasClosed?.())}catch(e){console.warn(e)}}glicWebClientPanelStateChanged(payload){this.host.getPanelState?.().assignAndSignal(payload.panelState)}glicWebClientRequestViewChange(payload){this.host.viewChangeRequestsSubject.next(payload.request)}glicWebClientZeroStateSuggestionsChanged(payload){this.host.currentZeroStateObserver?.assignAndSignal(payload.suggestions)}glicWebClientCanAttachStateChanged(payload){this.host.canAttachPanelValue.assignAndSignal(payload.canAttach)}glicWebClientNotifyMicrophonePermissionStateChanged(payload){this.host.getMicrophonePermissionState().assignAndSignal(payload.enabled)}glicWebClientNotifyLocationPermissionStateChanged(payload){this.host.getLocationPermissionState().assignAndSignal(payload.enabled)}glicWebClientNotifyTabContextPermissionStateChanged(payload){this.host.getTabContextPermissionState().assignAndSignal(payload.enabled)}glicWebClientNotifyDefaultTabContextPermissionStateChanged(payload){this.host.defaultTabContextPermission.assignAndSignal(payload.enabled)}glicWebClientNotifyOsLocationPermissionStateChanged(payload){this.host.getOsLocationPermissionState().assignAndSignal(payload.enabled)}glicWebClientNotifyClosedCaptioningSettingChanged(payload){this.host.closedCaptioningState.assignAndSignal(payload.enabled)}glicWebClientNotifyActuationOnWebSettingChanged(payload){this.host.actuationOnWebState.assignAndSignal(payload.enabled)}glicWebClientNotifyFocusedTabChanged(payload){const focusedTabData=convertFocusedTabDataFromPrivate(payload.focusedTabDataPrivate);this.host.getFocusedTabStateV2().assignAndSignal(focusedTabData)}glicWebClientNotifyPanelActiveChanged(payload){this.host.panelActiveValue.assignAndSignal(payload.panelActive)}async glicWebClientCheckResponsive(){return this.webClient.checkResponsive?.()}glicWebClientNotifyManualResizeChanged(payload){this.host.isManuallyResizing().assignAndSignal(payload.resizing)}glicWebClientBrowserIsOpenChanged(payload){this.host.isBrowserOpenValue.assignAndSignal(payload.browserIsOpen)}glicWebClientNotifyOsHotkeyStateChanged(payload){this.host.getOsHotkeyState().assignAndSignal(payload)}glicWebClientPinCandidatesChanged(payload){this.host.pinCandidates?.processUpdate(payload.candidates,payload.observationId)}glicWebClientNotifyPinnedTabsChanged(payload){this.cachedPinnedTabs=payload.tabData.map((x=>convertTabDataFromPrivate(x)));this.host.pinnedTabs?.assignAndSignal(this.cachedPinnedTabs)}glicWebClientNotifyPinnedTabDataChanged(payload){if(!this.cachedPinnedTabs){return}const tabData=convertTabDataFromPrivate(payload.tabData);this.cachedPinnedTabs=this.cachedPinnedTabs.map((cachedTab=>{if(cachedTab.tabId===tabData.tabId){return tabData}return cachedTab}));this.host.pinnedTabs.assignAndSignal(this.cachedPinnedTabs)}glicWebClientNotifyActorTaskStateChanged(payload){this.host.setActorTaskState(payload.taskId,payload.state)}glicWebClientNotifyTabDataChanged(payload){this.host.setTabData(payload.tabData)}glicWebClientPageMetadataChanged(payload){const observable=this.host.pageMetadataObservers.get(payload.tabId);if(!observable){return}if(payload.pageMetadata){observable.assignAndSignal(payload.pageMetadata)}else{if(!observable.isStopped()){observable.complete()}this.host.pageMetadataObservers.delete(payload.tabId)}}async glicWebClientRequestToShowDialog(payload){const request=payload.request;return new Promise((resolve=>{if(!this.host.selectCredentialDialogRequestSubject.hasActiveSubscription()){window.console.warn("GlicWebClient: no subscriber for"+" selectCredentialDialogRequest()!");resolve({response:{taskId:request.taskId,errorReason:SelectCredentialDialogErrorReason.DIALOG_PROMISE_NO_SUBSCRIBER}});return}const iconsGetter=new Map;for(const[id,image]of payload.request.icons.entries()){let promise;iconsGetter.set(id,(()=>{if(!promise){promise=rgbaImageToBlob(image)}return promise}))}const credentials=request.credentials.map((credential=>{const getIcon=iconsGetter.get(credential.sourceSiteOrApp);if(getIcon){return{...credential,getIcon:getIcon}}return credential}));const requestWithCallback={...request,credentials:credentials,onDialogClosed:resolve};this.host.selectCredentialDialogRequestSubject.next(requestWithCallback)}))}glicWebClientRequestToShowConfirmationDialog(payload){return new Promise((resolve=>{if(!this.host.userConfirmationDialogRequestSubject.hasActiveSubscription()){window.console.warn("GlicWebClient: no subscriber for "+"userConfirmationDialogRequest()!");resolve({response:{permissionGranted:false,errorReason:ConfirmationRequestErrorReason.REQUEST_PROMISE_NO_SUBSCRIBER}});return}const requestWithCallback={...payload.request,onDialogClosed:resolve};this.host.userConfirmationDialogRequestSubject.next(requestWithCallback)}))}glicWebClientRequestToConfirmNavigation(payload){return new Promise((resolve=>{if(!this.host.navigationConfirmationRequestSubject.hasActiveSubscription()){window.console.warn("GlicWebClient: no subscriber for "+"navigationConfirmationRequest()!");resolve({response:{errorReason:ConfirmationRequestErrorReason.REQUEST_PROMISE_NO_SUBSCRIBER}});return}const requestWithCallback={...payload.request,onConfirmationDecision:resolve};this.host.navigationConfirmationRequestSubject.next(requestWithCallback)}))}glicWebClientNotifyAdditionalContext(payload){const context=payload.context;const parts=context.parts.map((p=>{const annotatedPageData=p.annotatedPageData&&convertAnnotatedPageDataFromPrivate(p.annotatedPageData);const pdf=p.pdf&&convertPdfDocumentDataFromPrivate(p.pdf);const data=p.data&&new Blob([p.data.data],{type:p.data.mimeType});const tabContext=p.tabContext&&convertTabContextResultFromPrivate(p.tabContext);return{...p,data:data,annotatedPageData:annotatedPageData,pdf:pdf,tabContext:tabContext}}));this.host.additionalContextSubject.next({name:context.name,tabId:context.tabId,origin:context.origin,frameUrl:context.frameUrl,parts:parts})}glicWebClientCaptureRegionUpdate(payload){const observable=this.host.captureRegionObservable;if(observable?.observationId!==payload.observationId){return}if(payload.result){observable.processUpdate(payload.result)}else if(payload.reason!==undefined){observable.processError(payload.reason)}}glicWebClientNotifyActOnWebCapabilityChanged(payload){this.host.actOnWebCapabilityValue.assignAndSignal(payload.canActOnWeb)}glicWebClientOnboardingCompletedChanged(payload){this.host.onboardingCompleted.assignAndSignal(payload.completed)}async glicWebClientRequestToShowAutofillSuggestionsDialog(payload){const request=payload.request;return new Promise((resolve=>{if(!this.host.selectAutofillSuggestionsDialogRequestSubject.hasActiveSubscription()){resolve({response:{taskId:request.taskId,errorReason:SelectAutofillSuggestionsDialogErrorReason.DIALOG_PROMISE_NO_SUBSCRIBER,selectedSuggestions:[]}});return}const requestWithCallback={...request,formFillingRequests:request.formFillingRequests.map((formFillingRequest=>({...formFillingRequest,suggestions:formFillingRequest.suggestions.map((suggestion=>{const icon=suggestion.icon;const getIcon=icon?()=>rgbaImageToBlob(icon):undefined;return{...suggestion,getIcon:getIcon}}))}))),onDialogClosed:result=>{const response={...result.response,taskId:request.taskId};resolve({response:response})}};this.host.selectAutofillSuggestionsDialogRequestSubject.next(requestWithCallback)}))}}class GlicBrowserHostImpl{webClient;hostId=newSenderId();sender;receiver;handlerFunctionNames=new Set;webClientMessageHandler;chromeVersion;platform;panelState=ObservableValueImpl.withNoValue();canAttachPanelValue=ObservableValueImpl.withNoValue();focusedTabStateV2=ObservableValueImpl.withNoValue();permissionStateMicrophone=ObservableValueImpl.withNoValue();permissionStateLocation=ObservableValueImpl.withNoValue();permissionStateTabContext=ObservableValueImpl.withNoValue();defaultTabContextPermission=ObservableValueImpl.withNoValue();enableDefaultTabContextSettingFeature=false;permissionStateOsLocation=ObservableValueImpl.withNoValue();closedCaptioningState=ObservableValueImpl.withNoValue();actuationOnWebState=ObservableValueImpl.withNoValue();osHotkeyState=ObservableValueImpl.withNoValue();onboardingCompleted=ObservableValueImpl.withNoValue();panelActiveValue=ObservableValueImpl.withNoValue();isBrowserOpenValue=ObservableValueImpl.withNoValue();journalHost;metrics;manuallyResizing=ObservableValueImpl.withValue(false);pinnedTabs=ObservableValueImpl.withNoValue();pinCandidates;captureRegionObservable;idGenerator=new IdGenerator;currentZeroStateSuggestionOptions={isFirstRun:false,supportedTools:[]};currentZeroStateObserver=ObservableValueImpl.withNoValue();hostCapabilities=new Set;actorTaskState=new Map;observedTabData=new Map;viewChangeRequestsSubject=new Subject;additionalContextSubject=new Subject;pageMetadataObservers=new Map;selectCredentialDialogRequestSubject=new Subject;userConfirmationDialogRequestSubject=new Subject;navigationConfirmationRequestSubject=new Subject;actOnWebCapabilityValue=ObservableValueImpl.withNoValue();selectAutofillSuggestionsDialogRequestSubject=new Subject;constructor(webClient,windowProxy){this.webClient=webClient;this.sender=new PostMessageRequestSender(windowProxy,"chrome://glic",this.hostId,"glic_api_client");this.receiver=new PostMessageRequestReceiver("chrome://glic",this.hostId,windowProxy,this,"glic_api_client");this.webClientMessageHandler=new WebClientMessageHandler(this.webClient,this);this.journalHost=new GlicBrowserHostJournalImpl(this.sender);this.metrics=new GlicBrowserHostMetricsImpl(this.sender);for(const name of Object.getOwnPropertyNames(WebClientMessageHandler.prototype)){if(name!=="constructor"){this.handlerFunctionNames.add(name)}}}destroy(){this.receiver.destroy()}async webClientCreated(){const response=await this.sender.requestWithResponse("glicBrowserWebClientCreated",undefined);const state=response.initialState;this.receiver.setLoggingEnabled(state.loggingEnabled);this.sender.setLoggingEnabled(state.loggingEnabled);this.panelState.assignAndSignal(state.panelState);const focusedTabData=convertFocusedTabDataFromPrivate(state.focusedTabData);this.focusedTabStateV2.assignAndSignal(focusedTabData);this.permissionStateMicrophone.assignAndSignal(state.microphonePermissionEnabled);this.permissionStateLocation.assignAndSignal(state.locationPermissionEnabled);if(state.enableDefaultTabContextSettingFeature){this.permissionStateTabContext.assignAndSignal(state.defaultTabContextSettingEnabled)}else{this.permissionStateTabContext.assignAndSignal(state.tabContextPermissionEnabled)}this.defaultTabContextPermission.assignAndSignal(state.defaultTabContextSettingEnabled);this.enableDefaultTabContextSettingFeature=state.enableDefaultTabContextSettingFeature;this.permissionStateOsLocation.assignAndSignal(state.osLocationPermissionEnabled);this.canAttachPanelValue.assignAndSignal(state.canAttach);this.chromeVersion=state.chromeVersion;this.platform=state.platform;this.panelActiveValue.assignAndSignal(state.panelIsActive);this.isBrowserOpenValue.assignAndSignal(state.browserIsOpen);this.osHotkeyState.assignAndSignal({hotkey:state.hotkey});this.closedCaptioningState.assignAndSignal(state.closedCaptioningSettingEnabled);this.actuationOnWebState.assignAndSignal(state.actuationOnWebSettingEnabled);for(const capability of state.hostCapabilities){this.hostCapabilities.add(capability)}this.actOnWebCapabilityValue.assignAndSignal(state.canActOnWeb);this.onboardingCompleted.assignAndSignal(state.onboardingCompleted);if(!this.hostCapabilities.has(HostCapability.GET_MODEL_QUALITY_CLIENT_ID)){this.getModelQualityClientId=undefined}if(!state.enableScrollTo){this.scrollTo=undefined;this.dropScrollToHighlight=undefined}if(!state.enableActInFocusedTab){this.createTask=undefined;this.performActions=undefined;this.stopActorTask=undefined;this.pauseActorTask=undefined;this.resumeActorTask=undefined;this.interruptActorTask=undefined;this.uninterruptActorTask=undefined;this.getActOnWebCapability=undefined;this.createActorTab=undefined}if(state.alwaysDetachedMode){this.attachPanel=undefined;this.detachPanel=undefined;this.canAttachPanel=undefined;this.getPanelState=undefined}if(!state.enableZeroStateSuggestions){this.getZeroStateSuggestionsForFocusedTab=undefined;this.getZeroStateSuggestions=undefined}if(!state.enableDefaultTabContextSettingFeature){this.getDefaultTabContextPermissionState=undefined}if(!state.enableClosedCaptioningFeature){this.getClosedCaptioningSetting=undefined;this.setClosedCaptioningSetting=undefined;this.metrics.onClosedCaptionsShown=undefined}if(!state.enableMaybeRefreshUserStatus){this.maybeRefreshUserStatus=undefined}if(!state.enableMultiTab){this.getContextFromTab=undefined;this.getPinnedTabs=undefined;this.getPinCandidates=undefined;this.pinTabs=undefined;this.setMaximumNumberOfPinnedTabs=undefined;this.unpinTabs=undefined;this.unpinAllTabs=undefined}if(!state.enableGetContextActor){this.getContextForActorFromTab=undefined}if(!state.enableGetPageMetadata){this.getPageMetadata=undefined}if(!state.enableWebActuationSettingFeature){this.getActuationOnWebSetting=undefined;this.setActuationOnWebSetting=undefined}if(!state.enableCaptureRegion){this.captureRegion=undefined}if(!state.enableActivateTab){this.activateTab=undefined}if(!state.enableGetTabById){this.getTabById=undefined}if(!state.enableOpenPasswordManagerSettingsPage){this.openPasswordManagerSettingsPage=undefined}if(!state.enableLoadAndExtractContent){this.loadAndExtractContent=undefined}if(!state.enableTrustFirstOnboarding){this.setOnboardingCompleted=undefined;this.isOnboardingCompleted=undefined}}webClientInitialized(success,exception){this.sender.requestNoResponse("glicBrowserWebClientInitialized",{success:success,exception:exception})}async handleRawRequest(type,payload,extras){if(!this.handlerFunctionNames.has(type)){return}const handlerFunction=this.webClientMessageHandler[type];const response=await handlerFunction.call(this.webClientMessageHandler,payload,extras);if(!response){return}return{payload:response}}setActorTaskState(taskId,state){this.getActorTaskState(taskId).assignAndSignal(state);if(state===ActorTaskState.STOPPED){this.actorTaskState.delete(taskId)}}setTabData(tabData){const data=convertTabDataFromPrivate(tabData);this.getTabById?.(data.tabId).assignAndSignal(data)}onRequestReceived(_type){}onRequestHandlerException(_type){}onRequestCompleted(_type){}getChromeVersion(){return Promise.resolve(this.chromeVersion)}getPlatform(){return this.platform}async createTab(url,options){const result=await this.sender.requestWithResponse("glicBrowserCreateTab",{url:url,options:options});if(!result.tabData){throw new Error("createTab: failed")}return convertTabDataFromPrivate(result.tabData)}openGlicSettingsPage(options){this.sender.requestNoResponse("glicBrowserOpenGlicSettingsPage",{options:options})}openPasswordManagerSettingsPage(){this.sender.requestNoResponse("glicBrowserOpenPasswordManagerSettingsPage",undefined)}closePanel(){return this.sender.requestWithResponse("glicBrowserClosePanel",undefined)}closePanelAndShutdown(){this.sender.requestNoResponse("glicBrowserClosePanelAndShutdown",undefined)}attachPanel(){this.sender.requestNoResponse("glicBrowserAttachPanel",undefined)}detachPanel(){this.sender.requestNoResponse("glicBrowserDetachPanel",undefined)}showProfilePicker(){this.sender.requestNoResponse("glicBrowserShowProfilePicker",undefined)}async getModelQualityClientId(){const result=await this.sender.requestWithResponse("glicBrowserGetModelQualityClientId",undefined);return result.modelQualityClientId}async switchConversation(info){if(info&&!info.conversationId){throw new Error("conversationId cannot be empty.")}await this.sender.requestWithResponse("glicBrowserSwitchConversation",{info:info})}async registerConversation(info){await this.sender.requestWithResponse("glicBrowserRegisterConversation",{info:info})}async getContextFromFocusedTab(options){const context=await this.sender.requestWithResponse("glicBrowserGetContextFromFocusedTab",{options:options});return convertTabContextResultFromPrivate(context.tabContextResult)}async setMaximumNumberOfPinnedTabs(requestedMax){const result=await this.sender.requestWithResponse("glicBrowserSetMaximumNumberOfPinnedTabs",{requestedMax:requestedMax});return result.effectiveMax}async getContextFromTab(tabId,options){const result=await this.sender.requestWithResponse("glicBrowserGetContextFromTab",{tabId:tabId,options:options});return convertTabContextResultFromPrivate(result.tabContextResult)}async getContextForActorFromTab(tabId,options){const result=await this.sender.requestWithResponse("glicBrowserGetContextForActorFromTab",{tabId:tabId,options:options});return convertTabContextResultFromPrivate(result.tabContextResult)}async createTask(taskOptions){const result=await this.sender.requestWithResponse("glicBrowserCreateTask",{taskOptions:taskOptions});return result.taskId}async performActions(actions){const result=await this.sender.requestWithResponse("glicBrowserPerformActions",{actions:actions});return result.actionsResult}stopActorTask(taskId,stopReason){this.sender.requestNoResponse("glicBrowserStopActorTask",{taskId:taskId??0,stopReason:stopReason??ActorTaskStopReason.TASK_COMPLETE})}pauseActorTask(taskId,pauseReason,tabId){this.sender.requestNoResponse("glicBrowserPauseActorTask",{taskId:taskId,pauseReason:pauseReason??ActorTaskPauseReason.PAUSED_BY_MODEL,tabId:tabId??""})}async resumeActorTask(taskId,tabContextOptions){const response=await this.sender.requestWithResponse("glicBrowserResumeActorTask",{taskId:taskId,tabContextOptions:tabContextOptions});return convertTabContextResultFromPrivate(response.resumeActorTaskResult)}interruptActorTask(taskId){this.sender.requestNoResponse("glicBrowserInterruptActorTask",{taskId:taskId})}uninterruptActorTask(taskId){this.sender.requestNoResponse("glicBrowserUninterruptActorTask",{taskId:taskId})}getActorTaskState(taskId){const stateObs=this.actorTaskState.get(taskId);if(stateObs){return stateObs}const newObs=ObservableValueImpl.withNoValue();this.actorTaskState.set(taskId,newObs);return newObs}async createActorTab(taskId,options){const result=await this.sender.requestWithResponse("glicBrowserCreateActorTab",{taskId:taskId,options:options});if(!result.tabData){throw new Error("createActorTab: failed")}return convertTabDataFromPrivate(result.tabData)}getTabById(tabId){const tabObs=this.observedTabData.get(tabId);if(tabObs){return tabObs}const newObs=ObservableValueImpl.withNoValue();this.observedTabData.set(tabId,newObs);return newObs}activateTab(tabId){this.sender.requestNoResponse("glicBrowserActivateTab",{tabId:tabId})}onModeChange(newMode){this.sender.requestNoResponse("glicBrowserOnModeChange",{newMode:newMode})}async resizeWindow(width,height,options){return this.sender.requestWithResponse("glicBrowserResizeWindow",{size:{width:width,height:height},options:options})}enableDragResize(enabled){return this.sender.requestWithResponse("glicBrowserEnableDragResize",{enabled:enabled})}async captureScreenshot(){const screenshotResult=await this.sender.requestWithResponse("glicBrowserCaptureScreenshot",undefined);return screenshotResult.screenshot}captureRegion(){if(this.captureRegionObservable){this.captureRegionObservable.complete()}this.captureRegionObservable=new CaptureRegionObservable(this.idGenerator.next(),this.sender);return this.captureRegionObservable}setWindowDraggableAreas(areas){return this.sender.requestWithResponse("glicBrowserSetWindowDraggableAreas",{areas:areas})}setMinimumWidgetSize(width,height){return this.sender.requestWithResponse("glicBrowserSetMinimumWidgetSize",{size:{width:width,height:height}})}getPanelState(){return this.panelState}panelActive(){return this.panelActiveValue}canAttachPanel(){return this.canAttachPanelValue}isBrowserOpen(){return this.isBrowserOpenValue}getFocusedTabStateV2(){return this.focusedTabStateV2}getMicrophonePermissionState(){return this.permissionStateMicrophone}getLocationPermissionState(){return this.permissionStateLocation}getTabContextPermissionState(){return this.permissionStateTabContext}getDefaultTabContextPermissionState(){return this.defaultTabContextPermission}getOsLocationPermissionState(){return this.permissionStateOsLocation}getClosedCaptioningSetting(){return this.closedCaptioningState}getActuationOnWebSetting(){return this.actuationOnWebState}setMicrophonePermissionState(enabled){return this.sender.requestWithResponse("glicBrowserSetMicrophonePermissionState",{enabled:enabled})}setLocationPermissionState(enabled){return this.sender.requestWithResponse("glicBrowserSetLocationPermissionState",{enabled:enabled})}setTabContextPermissionState(enabled){if(this.enableDefaultTabContextSettingFeature){this.permissionStateTabContext.assignAndSignal(enabled);return Promise.resolve()}return this.sender.requestWithResponse("glicBrowserSetTabContextPermissionState",{enabled:enabled})}setClosedCaptioningSetting(enabled){return this.sender.requestWithResponse("glicBrowserSetClosedCaptioningSetting",{enabled:enabled})}setContextAccessIndicator(show){this.sender.requestWithResponse("glicBrowserSetContextAccessIndicator",{show:show})}setActuationOnWebSetting(enabled){return this.sender.requestWithResponse("glicBrowserSetActuationOnWebSetting",{enabled:enabled})}async getUserProfileInfo(){const{profileInfo:profileInfo}=await this.sender.requestWithResponse("glicBrowserGetUserProfileInfo",undefined);if(!profileInfo){throw new Error("getUserProfileInfo failed")}const{avatarIcon:avatarIcon}=profileInfo;return replaceProperties(profileInfo,{avatarIcon:async()=>avatarIcon&&rgbaImageToBlob(avatarIcon)})}async refreshSignInCookies(){const result=await this.sender.requestWithResponse("glicBrowserRefreshSignInCookies",undefined);if(!result.success){throw Error("refreshSignInCookies failed")}}setAudioDucking(enabled){this.sender.requestNoResponse("glicBrowserSetAudioDucking",{enabled:enabled})}getJournalHost(){return this.journalHost}getMetrics(){return this.metrics}scrollTo(params){return this.sender.requestWithResponse("glicBrowserScrollTo",{params:params})}setSyntheticExperimentState(trialName,groupName){this.sender.requestNoResponse("glicBrowserSetSyntheticExperimentState",{trialName:trialName,groupName:groupName})}openOsPermissionSettingsMenu(permission){this.sender.requestNoResponse("glicBrowserOpenOsPermissionSettingsMenu",{permission:permission})}async getOsMicrophonePermissionStatus(){return(await this.sender.requestWithResponse("glicBrowserGetOsMicrophonePermissionStatus",undefined)).enabled}isManuallyResizing(){return this.manuallyResizing}getOsHotkeyState(){return this.osHotkeyState}getPinnedTabs(){return this.pinnedTabs}async pinTabs(tabIds){return(await this.sender.requestWithResponse("glicBrowserPinTabs",{tabIds:tabIds})).pinnedAll}async unpinTabs(tabIds){return(await this.sender.requestWithResponse("glicBrowserUnpinTabs",{tabIds:tabIds})).unpinnedAll}unpinAllTabs(){this.sender.requestNoResponse("glicBrowserUnpinAllTabs",undefined)}getPinCandidates(options){this.pinCandidates?.setObsolete();return this.pinCandidates=new PinCandidatesObservable(this.idGenerator.next(),this.sender,options)}async getZeroStateSuggestionsForFocusedTab(isFirstRun){const zeroStateResult=await this.sender.requestWithResponse("glicBrowserGetZeroStateSuggestionsForFocusedTab",{isFirstRun:isFirstRun});if(!zeroStateResult.suggestions){return{suggestions:[],tabId:"",url:""}}return zeroStateResult.suggestions}async zeroStateActiveSubscriptionStateChanged(options,hasActiveSubscription){if(options!==this.currentZeroStateSuggestionOptions){return}const zeroStateResult=await this.sender.requestWithResponse("glicBrowserGetZeroStateSuggestionsAndSubscribe",{hasActiveSubscription:hasActiveSubscription,options:options});if(zeroStateResult.suggestions){this.currentZeroStateObserver?.assignAndSignal(zeroStateResult.suggestions)}}getZeroStateSuggestions(options){options=options??{isFirstRun:false,supportedTools:[]};this.currentZeroStateSuggestionOptions=options;this.currentZeroStateObserver=ObservableValueImpl.withNoValue(this.zeroStateActiveSubscriptionStateChanged.bind(this,options));return this.currentZeroStateObserver}dropScrollToHighlight(){this.sender.requestNoResponse("glicBrowserDropScrollToHighlight",undefined)}maybeRefreshUserStatus(){this.sender.requestNoResponse("glicBrowserMaybeRefreshUserStatus",undefined)}getAdditionalContext(){return this.additionalContextSubject}getHostCapabilities(){return this.hostCapabilities}getViewChangeRequests(){return this.viewChangeRequestsSubject}onViewChanged(notification){this.sender.requestNoResponse("glicBrowserOnViewChanged",{notification:notification})}getPageMetadata(tabId,names){if(this.pageMetadataObservers.has(tabId)){return this.pageMetadataObservers.get(tabId)}if(names.length===0){throw Error("names must not be empty")}const observableValue=ObservableValueImpl.withNoValue((async isActive=>{const{success:success}=await this.sender.requestWithResponse("glicBrowserSubscribeToPageMetadata",{tabId:tabId,names:isActive?names:[]});if(!success){if(!observableValue.isStopped()){observableValue.complete()}this.pageMetadataObservers.delete(tabId)}}));this.pageMetadataObservers.set(tabId,observableValue);return observableValue}selectCredentialDialogRequestHandler(){return this.selectCredentialDialogRequestSubject}selectUserConfirmationDialogRequestHandler(){return this.userConfirmationDialogRequestSubject}selectNavigationConfirmationRequestHandler(){return this.navigationConfirmationRequestSubject}getActOnWebCapability(){return this.actOnWebCapabilityValue}selectAutofillSuggestionsDialogRequestHandler(){return this.selectAutofillSuggestionsDialogRequestSubject}async loadAndExtractContent(urls,options){const response=await this.sender.requestWithResponse("glicBrowserLoadAndExtractContent",{urls:urls,options:options});return response.results.map(convertTabContextResultFromPrivate)}setOnboardingCompleted(){return this.sender.requestNoResponse("glicBrowserSetOnboardingCompleted",undefined)}isOnboardingCompleted(){return this.onboardingCompleted}}class GlicBrowserHostJournalImpl{sender;constructor(sender){this.sender=sender}beginAsyncEvent(asyncEventId,taskId,event,details){this.sender.requestNoResponse("glicBrowserLogBeginAsyncEvent",{asyncEventId:asyncEventId,taskId:taskId,event:event,details:details})}clear(){this.sender.requestNoResponse("glicBrowserJournalClear",undefined)}endAsyncEvent(asyncEventId,details){this.sender.requestNoResponse("glicBrowserLogEndAsyncEvent",{asyncEventId:asyncEventId,details:details})}instantEvent(taskId,event,details){this.sender.requestNoResponse("glicBrowserLogInstantEvent",{taskId:taskId,event:event,details:details})}async snapshot(clear){const snapshotResult=await this.sender.requestWithResponse("glicBrowserJournalSnapshot",{clear:clear});return snapshotResult.journal}start(maxBytes,captureScreenshots){this.sender.requestNoResponse("glicBrowserJournalStart",{maxBytes:maxBytes,captureScreenshots:captureScreenshots})}stop(){this.sender.requestNoResponse("glicBrowserJournalStop",undefined)}recordFeedback(positive,reason){this.sender.requestNoResponse("glicBrowserJournalRecordFeedback",{positive:positive,reason:reason})}}class GlicBrowserHostMetricsImpl{sender;constructor(sender){this.sender=sender}onUserInputSubmitted(mode){this.sender.requestNoResponse("glicBrowserOnUserInputSubmitted",{mode:mode})}onReaction(reactionType){this.sender.requestNoResponse("glicBrowserOnReaction",{reactionType:reactionType})}onContextUploadStarted(){this.sender.requestNoResponse("glicBrowserOnContextUploadStarted",undefined)}onContextUploadCompleted(){this.sender.requestNoResponse("glicBrowserOnContextUploadCompleted",undefined)}onResponseStarted(){this.sender.requestNoResponse("glicBrowserOnResponseStarted",undefined)}onResponseStopped(details){this.sender.requestNoResponse("glicBrowserOnResponseStopped",{details:details})}onSessionTerminated(){this.sender.requestNoResponse("glicBrowserOnSessionTerminated",undefined)}onResponseRated(positive){this.sender.requestNoResponse("glicBrowserOnResponseRated",{positive:positive})}onClosedCaptionsShown(){this.sender.requestNoResponse("glicBrowserOnClosedCaptionsShown",undefined)}onTurnCompleted(model,duration){this.sender.requestNoResponse("glicBrowserOnTurnCompleted",{model:model,duration:duration})}onModelChanged(model){this.sender.requestNoResponse("glicBrowserOnModelChanged",{model:model})}onRecordUseCounter(counter){this.sender.requestNoResponse("glicBrowserOnRecordUseCounter",{counter:counter})}}class IdGenerator{nextId=1;next(){return this.nextId++}}class CaptureRegionObservable extends ObservableValueImpl{sender;observationId;constructor(observationId,sender){super(false);this.sender=sender;this.observationId=observationId}activeSubscriptionChanged(hasActiveSubscription){super.activeSubscriptionChanged(hasActiveSubscription);if(this.isStopped()){return}if(hasActiveSubscription){this.sender.requestNoResponse("glicBrowserSubscribeToCaptureRegion",{observationId:this.observationId})}else{this.sender.requestNoResponse("glicBrowserUnsubscribeFromCaptureRegion",{observationId:this.observationId});this.complete()}}error(e){if(this.isStopped()){return}super.error(e)}complete(){if(this.isStopped()){return}super.complete()}processUpdate(result){this.assignAndSignal(result)}processError(reason){this.error(new ErrorWithReasonImpl("captureRegion",reason))}}class PinCandidatesObservable extends ObservableValueImpl{observationId;sender;options;isObsolete=false;constructor(observationId,sender,options){super(false);this.observationId=observationId;this.sender=sender;this.options=options}activeSubscriptionChanged(hasActiveSubscription){super.activeSubscriptionChanged(hasActiveSubscription);if(this.isObsolete){console.warn(`getPinCandidates() observable is in use while obsolete.`);return}if(hasActiveSubscription){this.sender.requestNoResponse("glicBrowserSubscribeToPinCandidates",{options:this.options,observationId:this.observationId})}else{this.sender.requestNoResponse("glicBrowserUnsubscribeFromPinCandidates",{observationId:this.observationId})}}processUpdate(candidates,observationId){if(this.observationId!==observationId){return}this.assignAndSignal(candidates.map((c=>({tabData:convertTabDataFromPrivate(c.tabData)}))))}setObsolete(){if(this.hasActiveSubscription()){console.warn(`getPinCandidates() observable was made obsolete with subscribers.`)}this.isObsolete=true}}async function rgbaImageToBlob(image){const canvas=document.createElement("canvas");canvas.width=image.width;canvas.height=image.height;const ctx=canvas.getContext("2d");if(!ctx){throw Error("getContext error")}if(image.colorType!==ImageColorType.BGRA){throw Error("unsupported colorType")}const pixelData=new Uint8ClampedArray(image.dataRGBA);if(image.alphaType===ImageAlphaType.PREMUL){for(let i=0;i+3<pixelData.length;i+=4){const alphaInt=pixelData[i+3];if(alphaInt===0){continue}const alpha=alphaInt/255;const[B,G,R]=[pixelData[i],pixelData[i+1],pixelData[i+2]];pixelData[i]=R/alpha;pixelData[i+1]=G/alpha;pixelData[i+2]=B/alpha}}else{for(let i=0;i+3<pixelData.length;i+=4){const[B,R]=[pixelData[i],pixelData[i+2]];pixelData[i]=R;pixelData[i+2]=B}}ctx.putImageData(new ImageData(pixelData,image.width,image.height),0,0);return new Promise((resolve=>{canvas.toBlob((result=>{if(!result){throw Error("toBlob failed")}resolve(result)}))}))}function convertTabDataFromPrivate(data){if(!data){return undefined}let faviconResult;const dataFavicon=data.favicon;async function getFavicon(){if(dataFavicon&&!faviconResult){faviconResult=rgbaImageToBlob(dataFavicon);return faviconResult}return faviconResult}const favicon=dataFavicon&&getFavicon;return replaceProperties(data,{favicon:favicon})}function convertFocusedTabDataFromPrivate(data){const result={};if(data.hasFocus){result.hasFocus=replaceProperties(data.hasFocus,{tabData:convertTabDataFromPrivate(data.hasFocus.tabData)})}if(data.hasNoFocus){result.hasNoFocus=replaceProperties(data.hasNoFocus,{tabFocusCandidateData:convertTabDataFromPrivate(data.hasNoFocus.tabFocusCandidateData)})}return result}function streamFromBuffer(buffer){return new ReadableStream({start(controller){controller.enqueue(buffer);controller.close()}})}function convertPdfDocumentDataFromPrivate(data){const pdfData=data.pdfData&&streamFromBuffer(new Uint8Array(data.pdfData));return replaceProperties(data,{pdfData:pdfData})}function convertAnnotatedPageDataFromPrivate(data){const annotatedPageContent=data.annotatedPageContent&&streamFromBuffer(new Uint8Array(data.annotatedPageContent));return replaceProperties(data,{annotatedPageContent:annotatedPageContent})}function convertTabContextResultFromPrivate(data){const tabData=convertTabDataFromPrivate(data.tabData);const pdfDocumentData=data.pdfDocumentData&&convertPdfDocumentDataFromPrivate(data.pdfDocumentData);const annotatedPageData=data.annotatedPageData&&convertAnnotatedPageDataFromPrivate(data.annotatedPageData);return replaceProperties(data,{tabData:tabData,pdfDocumentData:pdfDocumentData,annotatedPageData:annotatedPageData})}