import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { Url as url_mojom_Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export declare const FreWebUiStateSpec: {
    $: mojo.internal.MojomType;
};
export declare enum FreWebUiState {
    MIN_VALUE = 0,
    MAX_VALUE = 8,
    kUninitialized = 0,
    kBeginLoading = 1,
    kShowLoading = 2,
    kHoldLoading = 3,
    kFinishLoading = 4,
    kError = 5,
    kOffline = 6,
    kReady = 7,
    kDisabledByAdmin = 8
}
export type FrePageHandlerFactoryPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<FrePageHandlerFactoryPendingReceiver>;
export declare class FrePageHandlerFactoryPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<FrePageHandlerFactory> {
    handle: mojo.internal.interfaceSupport.Endpoint<FrePageHandlerFactoryPendingReceiver>;
    constructor(handle: MojoHandle | FrePageHandlerFactoryPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface FrePageHandlerFactoryInterface {
    createPageHandler(receiver: FrePageHandlerPendingReceiver): void;
}
export declare class FrePageHandlerFactoryRemote implements FrePageHandlerFactoryInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<FrePageHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | FrePageHandlerFactoryPendingReceiverEndpoint);
    createPageHandler(receiver: FrePageHandlerPendingReceiver): void;
}
/**
 * An object which receives request messages for the FrePageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class FrePageHandlerFactoryReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<FrePageHandlerFactoryRemote, FrePageHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: FrePageHandlerFactoryInterface);
}
export declare class FrePageHandlerFactory {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): FrePageHandlerFactoryRemote;
}
/**
 * An object which receives request messages for the FrePageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class FrePageHandlerFactoryCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<FrePageHandlerFactoryRemote, FrePageHandlerFactoryPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type FrePageHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<FrePageHandlerPendingReceiver>;
export declare class FrePageHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<FrePageHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<FrePageHandlerPendingReceiver>;
    constructor(handle: MojoHandle | FrePageHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface FrePageHandlerInterface {
    acceptFre(): void;
    rejectFre(): void;
    dismissFre(panel: FreWebUiState): void;
    freReloaded(): void;
    prepareForClient(): Promise<{
        success: boolean;
    }>;
    validateAndOpenLinkInNewTab(url: url_mojom_Url): void;
    webUiStateChanged(newState: FreWebUiState): void;
    exceededTimeoutError(): void;
    logWebUiLoadComplete(): void;
}
export declare class FrePageHandlerRemote implements FrePageHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<FrePageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | FrePageHandlerPendingReceiverEndpoint);
    acceptFre(): void;
    rejectFre(): void;
    dismissFre(panel: FreWebUiState): void;
    freReloaded(): void;
    prepareForClient(): Promise<{
        success: boolean;
    }>;
    validateAndOpenLinkInNewTab(url: url_mojom_Url): void;
    webUiStateChanged(newState: FreWebUiState): void;
    exceededTimeoutError(): void;
    logWebUiLoadComplete(): void;
}
/**
 * An object which receives request messages for the FrePageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class FrePageHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<FrePageHandlerRemote, FrePageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: FrePageHandlerInterface);
}
export declare class FrePageHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): FrePageHandlerRemote;
}
/**
 * An object which receives request messages for the FrePageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class FrePageHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<FrePageHandlerRemote, FrePageHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    acceptFre: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    rejectFre: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    dismissFre: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    freReloaded: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    prepareForClient: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    validateAndOpenLinkInNewTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    webUiStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    exceededTimeoutError: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    logWebUiLoadComplete: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const FrePageHandlerFactory_CreatePageHandler_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const FrePageHandler_AcceptFre_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const FrePageHandler_RejectFre_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const FrePageHandler_DismissFre_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const FrePageHandler_FreReloaded_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const FrePageHandler_PrepareForClient_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const FrePageHandler_PrepareForClient_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const FrePageHandler_WebUiStateChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const FrePageHandler_ExceededTimeoutError_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const FrePageHandler_LogWebUiLoadComplete_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export interface FrePageHandlerFactory_CreatePageHandler_ParamsMojoType {
    receiver: FrePageHandlerPendingReceiver;
}
export type FrePageHandlerFactory_CreatePageHandler_Params = FrePageHandlerFactory_CreatePageHandler_ParamsMojoType;
export interface FrePageHandler_AcceptFre_ParamsMojoType {
}
export type FrePageHandler_AcceptFre_Params = FrePageHandler_AcceptFre_ParamsMojoType;
export interface FrePageHandler_RejectFre_ParamsMojoType {
}
export type FrePageHandler_RejectFre_Params = FrePageHandler_RejectFre_ParamsMojoType;
export interface FrePageHandler_DismissFre_ParamsMojoType {
    panel: FreWebUiState;
}
export type FrePageHandler_DismissFre_Params = FrePageHandler_DismissFre_ParamsMojoType;
export interface FrePageHandler_FreReloaded_ParamsMojoType {
}
export type FrePageHandler_FreReloaded_Params = FrePageHandler_FreReloaded_ParamsMojoType;
export interface FrePageHandler_PrepareForClient_ParamsMojoType {
}
export type FrePageHandler_PrepareForClient_Params = FrePageHandler_PrepareForClient_ParamsMojoType;
export interface FrePageHandler_PrepareForClient_ResponseParamsMojoType {
    success: boolean;
}
export type FrePageHandler_PrepareForClient_ResponseParams = FrePageHandler_PrepareForClient_ResponseParamsMojoType;
export interface FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsMojoType {
    url: url_mojom_Url;
}
export type FrePageHandler_ValidateAndOpenLinkInNewTab_Params = FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsMojoType;
export interface FrePageHandler_WebUiStateChanged_ParamsMojoType {
    newState: FreWebUiState;
}
export type FrePageHandler_WebUiStateChanged_Params = FrePageHandler_WebUiStateChanged_ParamsMojoType;
export interface FrePageHandler_ExceededTimeoutError_ParamsMojoType {
}
export type FrePageHandler_ExceededTimeoutError_Params = FrePageHandler_ExceededTimeoutError_ParamsMojoType;
export interface FrePageHandler_LogWebUiLoadComplete_ParamsMojoType {
}
export type FrePageHandler_LogWebUiLoadComplete_Params = FrePageHandler_LogWebUiLoadComplete_ParamsMojoType;
