declare global {
    type GetUserMediaError = Error & {
        constraintName: string;
    };
    interface Navigator {
        webkitGetUserMedia(params: any, callback: (stream?: MediaStream) => void, errorCallback: (error: GetUserMediaError) => void): void;
    }
}
export interface FeedbackBrowserProxy {
    getSystemInformation(): Promise<chrome.feedbackPrivate.LogsMapEntry[]>;
    getUserEmail(): Promise<string>;
    getDialogArguments(): string;
    getUserMedia(params: any): Promise<MediaStream | undefined>;
    sendFeedback(feedback: chrome.feedbackPrivate.FeedbackInfo, loadSystemInfo?: boolean, formOpenTime?: number): Promise<chrome.feedbackPrivate.SendFeedbackResult>;
    showDialog(): void;
    closeDialog(): void;
    showSystemInfo(): void;
    showMetrics(): void;
    showAutofillMetadataInfo(autofillMetadata: string): void;
}
export declare class FeedbackBrowserProxyImpl implements FeedbackBrowserProxy {
    getSystemInformation(): Promise<chrome.feedbackPrivate.LogsMapEntry[]>;
    getUserEmail(): Promise<string>;
    getDialogArguments(): string;
    getUserMedia(params: any): Promise<MediaStream | undefined>;
    sendFeedback(feedback: chrome.feedbackPrivate.FeedbackInfo, loadSystemInfo?: boolean, formOpenTime?: number): Promise<chrome.feedbackPrivate.SendFeedbackResult>;
    showDialog(): void;
    closeDialog(): void;
    showSystemInfo(): void;
    showMetrics(): void;
    showAutofillMetadataInfo(autofillMetadata: string): void;
    static getInstance(): FeedbackBrowserProxy;
    static setInstance(obj: FeedbackBrowserProxy): void;
}
