import {css, CSSResultGroup} from 'chrome://resources/lit/v3_0/lit.rollup.js';
import {getCss as getActionLinkLit} from 'chrome://resources/cr_elements/action_link_lit.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';

let instance: CSSResultGroup|null = null;
export function getCss() {
  return instance || (instance = [...[getActionLinkLit()], css`table{border-collapse:collapse}table td,table th{border:1px solid #777;padding-inline-end:4px;padding-inline-start:4px}@media (prefers-color-scheme:dark){table td,table th{border-color:var(--cr-separator-color)}}table th{background:rgb(224,236,255);padding-bottom:4px;padding-inline-end:16px;padding-top:4px;white-space:nowrap}@media (prefers-color-scheme:dark){table th{background:var(--google-grey-800)}}table th[data-sort-key]{cursor:pointer}table th div.header-cell-container{align-items:center;display:flex;justify-content:flex-start}@media (prefers-color-scheme:dark){table td{background-color:var(--google-grey-900);color:var(--cr-secondary-text-color)}}table td.title-cell{max-width:200px;overflow:hidden;white-space:nowrap}table td div.title-cell-container{align-items:center;display:flex;justify-content:flex-start}table td div.favicon-div{height:16px;margin:3px;min-width:16px}table td div.title-div{overflow:hidden;white-space:nowrap}table td.tab-url-cell{max-width:200px;overflow:hidden;white-space:nowrap}table td.visibility-cell{width:6em}table td.loading-state-cell{width:6em}table td.state-cell{width:10em}table td.boolean-cell,table td.discard-count-cell,table td.reactivation-score-cell,table td.site-engagement-score-cell,table td.utility-rank-cell{text-align:center}table td div[is=action-link],table td.actions-cell{font-size:0.6rem}table tr:hover{background:rgb(255,255,187)}@media (prefers-color-scheme:dark){table tr:hover td{background:var(--google-grey-800)}}th div.header-cell-container::after{content:'▲';opacity:0}th.sort-column div.header-cell-container::after{content:'▲';opacity:1}th.sort-column-reverse div.header-cell-container::after{content:'▼';opacity:1}.tooltip-container{position:relative}.tooltip{background:black;color:white;display:none;font-size:0.75rem;left:50%;margin-inline-start:-100px;margin-top:4px;padding:4px;position:absolute;top:100%;width:200px;z-index:1}.tooltip-container:hover>.tooltip{display:block}`]);
}