// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/js/action_link.js";import"/strings.m.js";import{assertNotReached}from"chrome://resources/js/assert.js";import{getFaviconForPageURL}from"chrome://resources/js/icon.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{boolToString,durationToString,getOrCreateDetailsProvider}from"./discards.js";import{CanFreeze,LifecycleUnitVisibility}from"./discards.mojom-webui.js";import{getCss}from"./discards_tab.css.js";import{getHtml}from"./discards_tab.html.js";import{LifecycleUnitDiscardReason,LifecycleUnitLoadingState,LifecycleUnitState}from"./lifecycle_unit_state.mojom-webui.js";import{SortedTableMixinLit}from"./sorted_table_mixin_lit.js";function compareByTitle(a,b){const val1=a.title.toLowerCase();const val2=b.title.toLowerCase();if(val1===val2){return 0}return val1>val2?1:-1}function compareByTabUrl(a,b){const val1=a.tabUrl.toLowerCase();const val2=b.tabUrl.toLowerCase();if(val1===val2){return 0}return val1>val2?1:-1}function compareByIsAutoDiscardable(a,b){const val1=a.isAutoDiscardable;const val2=b.isAutoDiscardable;if(val1===val2){return 0}return val1>val2?1:-1}function compareByCanDiscard(a,b){const val1=a.canDiscard;const val2=b.canDiscard;if(val1===val2){return 0}return val1>val2?1:-1}function compareByState(a,b){const val1=a.state;const val2=b.state;if(val1===val2&&val1===LifecycleUnitState.DISCARDED){return a.discardReason-b.discardReason}return val1-val2}function compareByVisibility(a,b){return a.visibility-b.visibility}function compareByLoadingState(a,b){return a.loadingState-b.loadingState}function compareByDiscardCount(a,b){return a.discardCount-b.discardCount}function compareByUtilityRank(a,b){return a.utilityRank-b.utilityRank}function compareByLastActiveSeconds(a,b){return a.lastActiveSeconds-b.lastActiveSeconds}function compareBySiteEngagementScore(a,b){return a.siteEngagementScore-b.siteEngagementScore}function compareByCanFreeze(a,b){return a.canFreeze-b.canFreeze}export function getSortFunctionForKey(sortKey){switch(sortKey){case"title":return compareByTitle;case"tabUrl":return compareByTabUrl;case"isAutoDiscardable":return compareByIsAutoDiscardable;case"canDiscard":return compareByCanDiscard;case"state":return compareByState;case"visibility":return compareByVisibility;case"loadingState":return compareByLoadingState;case"discardCount":return compareByDiscardCount;case"utilityRank":return compareByUtilityRank;case"lastActiveSeconds":return compareByLastActiveSeconds;case"siteEngagementScore":return compareBySiteEngagementScore;case"canFreeze":return compareByCanFreeze;default:assertNotReached("Unknown sortKey: "+sortKey)}}const DiscardsTabElementBase=SortedTableMixinLit(CrLitElement);export class DiscardsTabElement extends DiscardsTabElementBase{static get is(){return"discards-tab"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{tabInfos_:{type:Array},isPerformanceInterventionDemoModeEnabled_:{type:Boolean}}}#tabInfos__accessor_storage=[];get tabInfos_(){return this.#tabInfos__accessor_storage}set tabInfos_(value){this.#tabInfos__accessor_storage=value}#isPerformanceInterventionDemoModeEnabled__accessor_storage=loadTimeData.getBoolean("isPerformanceInterventionDemoModeEnabled");get isPerformanceInterventionDemoModeEnabled_(){return this.#isPerformanceInterventionDemoModeEnabled__accessor_storage}set isPerformanceInterventionDemoModeEnabled_(value){this.#isPerformanceInterventionDemoModeEnabled__accessor_storage=value}updateTimer_=0;discardsDetailsProvider_=null;sortKey="utilityRank";connectedCallback(){super.connectedCallback();this.discardsDetailsProvider_=getOrCreateDetailsProvider();this.updateTable_()}computeSortFunction_(sortKey,sortReverse){const sortFunction=getSortFunctionForKey(sortKey);return function(a,b){const comp=sortFunction(a,b);return sortReverse?-comp:comp}}getSortedTabInfos_(){if(!this.tabInfos_){return[]}const sortFunction=this.computeSortFunction_(this.sortKey,this.sortReverse);return this.tabInfos_.sort(sortFunction)}visibilityToString_(visibility){switch(visibility){case LifecycleUnitVisibility.HIDDEN:return"hidden";case LifecycleUnitVisibility.OCCLUDED:return"occluded";case LifecycleUnitVisibility.VISIBLE:return"visible";default:assertNotReached()}}loadingStateToString_(loadingState){switch(loadingState){case LifecycleUnitLoadingState.UNLOADED:return"unloaded";case LifecycleUnitLoadingState.LOADING:return"loading";case LifecycleUnitLoadingState.LOADED:return"loaded";default:assertNotReached()}}discardReasonToString_(reason){switch(reason){case LifecycleUnitDiscardReason.EXTERNAL:return"external";case LifecycleUnitDiscardReason.URGENT:return"urgent";case LifecycleUnitDiscardReason.PROACTIVE:return"proactive";case LifecycleUnitDiscardReason.SUGGESTED:return"suggested";case LifecycleUnitDiscardReason.FROZEN_WITH_GROWING_MEMORY:return"frozen with growing memory";default:assertNotReached()}}lifecycleStateToString_(state,reason,visibility,hasFocus,stateChangeTime){function pageLifecycleStateFromVisibilityAndFocus(){switch(visibility){case LifecycleUnitVisibility.HIDDEN:case LifecycleUnitVisibility.OCCLUDED:return"hidden";case LifecycleUnitVisibility.VISIBLE:return hasFocus?"active":"passive";default:assertNotReached()}}switch(state){case LifecycleUnitState.ACTIVE:return pageLifecycleStateFromVisibilityAndFocus();case LifecycleUnitState.FROZEN:return"frozen";case LifecycleUnitState.DISCARDED:return"discarded ("+this.discardReasonToString_(reason)+")"+(reason===LifecycleUnitDiscardReason.URGENT?" at "+new Date(Number(stateChangeTime.microseconds)/1e3).toLocaleString():"");default:assertNotReached()}}updateTableImpl_(){this.discardsDetailsProvider_.getTabDiscardsInfo().then((response=>{this.tabInfos_=response.infos}))}updateTable_(){if(this.updateTimer_){clearInterval(this.updateTimer_)}this.updateTableImpl_();this.updateTimer_=setInterval(this.updateTableImpl_.bind(this),1e3)}getSiteEngagementScore_(item){return item.siteEngagementScore.toFixed(1)}getFavIconStyle_(item){return"background-image:"+getFaviconForPageURL(item.tabUrl,false)}getLifeCycleState_(item){if(item.loadingState!==LifecycleUnitLoadingState.UNLOADED||item.discardCount>0){return this.lifecycleStateToString_(item.state,item.discardReason,item.visibility,item.hasFocus,item.stateChangeTime)}else{return""}}boolToString_(value){return boolToString(value)}canFreezeToString_(canFreeze){switch(canFreeze){case CanFreeze.YES:return"✔";case CanFreeze.NO:return"✘️";case CanFreeze.VARIES:return"~";default:assertNotReached()}}durationToString_(secondsAgo){return durationToString(secondsAgo)}canLoadViaUi_(tab){return tab.loadingState===LifecycleUnitLoadingState.UNLOADED}canDiscardViaUi_(tab){return tab.visibility!==LifecycleUnitVisibility.VISIBLE&&tab.state!==LifecycleUnitState.DISCARDED}canFreezeViaUi_(tab){return tab.visibility!==LifecycleUnitVisibility.VISIBLE&&tab.state!==LifecycleUnitState.DISCARDED&&tab.state!==LifecycleUnitState.FROZEN}shouldShowCannotDiscardReason_(tab){return!tab.canDiscard&&tab.state!==LifecycleUnitState.DISCARDED}shouldShowCannotFreezeReason_(tab){return tab.canFreeze!==CanFreeze.YES&&tab.state!==LifecycleUnitState.FROZEN&&tab.state!==LifecycleUnitState.DISCARDED}toggleAutoDiscardable_(e){const item=e.currentTarget;const id=Number(item.dataset["id"]);const isAutoDiscardable=item.dataset["isAutoDiscardable"]==="true";this.discardsDetailsProvider_.setAutoDiscardable(id,!isAutoDiscardable).then(this.updateTable_.bind(this))}loadTab_(e){const id=Number(e.currentTarget.dataset["id"]);this.discardsDetailsProvider_.loadById(id)}urgentDiscardTab_(e){const id=Number(e.currentTarget.dataset["id"]);this.discardsDetailsProvider_.discardById(id,LifecycleUnitDiscardReason.URGENT).then(this.updateTable_.bind(this))}proactiveDiscardTab_(e){const id=Number(e.currentTarget.dataset["id"]);this.discardsDetailsProvider_.discardById(id,LifecycleUnitDiscardReason.PROACTIVE).then(this.updateTable_.bind(this))}freezeTab_(e){const id=Number(e.currentTarget.dataset["id"]);this.discardsDetailsProvider_.freezeById(id)}discardImpl_(){this.discardsDetailsProvider_.discard().then((()=>{this.updateTable_()}))}discardUrgentNow_(_e){this.discardImpl_()}toggleBatterySaverMode_(_e){this.discardsDetailsProvider_.toggleBatterySaverMode()}refreshPerformanceTabCpuMeasurements_(_e){this.discardsDetailsProvider_.refreshPerformanceTabCpuMeasurements()}}customElements.define(DiscardsTabElement.is,DiscardsTabElement);