// chrome/browser/ui/webui/data_sharing/data_sharing.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  GroupDataSpec as dataSharing_mojom_GroupDataSpec,
  GroupData as dataSharing_mojom_GroupData
} from './group_data.mojom-webui.js';
import {
  AbslStatusCodeSpec as mojoBase_mojom_AbslStatusCodeSpec,
  AbslStatusCode as mojoBase_mojom_AbslStatusCode
} from '//resources/mojo/mojo/public/mojom/base/absl_status.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const GroupActionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum GroupAction {

  MIN_VALUE = 0,
  MAX_VALUE = 5,
  kUnknown = 0,
  kJoinGroup = 1,
  kDeleteGroup = 2,
  kLeaveGroup = 3,
  kKeepGroup = 4,
  kStopSharing = 5,
}

export const GroupActionProgressSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum GroupActionProgress {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kUnknown = 0,
  kStarted = 1,
  kFailed = 2,
  kSuccess = 3,
}



export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'data_sharing.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "data_sharing.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'data_sharing.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  showUI(): void;
  closeUI(statusCode: number): void;
  apiInitComplete(): void;
  makeTabGroupShared(tabGroupId: string, groupId: string, accessToken: string): Promise<{
        url: (url_mojom_Url | null), }>;
  getShareLink(groupId: string, accessToken: string): Promise<{
        url: url_mojom_Url, }>;
  getTabGroupPreview(groupId: string, accessToken: string): Promise<{
        groupPreview: GroupPreview, }>;
  openTabGroup(groupId: string): void;
  aboutToUnShareTabGroup(tabGroupId: string): void;
  onTabGroupUnShareComplete(tabGroupId: string): void;
  onGroupAction(action: GroupAction, progress: GroupActionProgress): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  showUI(): void {
    this.proxy.sendMessage(
        0,
        PageHandler_ShowUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  closeUI(
      statusCode: number): void {
    this.proxy.sendMessage(
        1,
        PageHandler_CloseUI_ParamsSpec.$,
        null,
        [
          statusCode
        ],
        false);
  }

  apiInitComplete(): void {
    this.proxy.sendMessage(
        2,
        PageHandler_ApiInitComplete_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  makeTabGroupShared(
      tabGroupId: string,
      groupId: string,
      accessToken: string): Promise<{
        url: (url_mojom_Url | null), }> {
    return this.proxy.sendMessage(
        3,
        PageHandler_MakeTabGroupShared_ParamsSpec.$,
        PageHandler_MakeTabGroupShared_ResponseParamsSpec.$,
        [
          tabGroupId,
          groupId,
          accessToken
        ],
        false);
  }

  getShareLink(
      groupId: string,
      accessToken: string): Promise<{
        url: url_mojom_Url, }> {
    return this.proxy.sendMessage(
        4,
        PageHandler_GetShareLink_ParamsSpec.$,
        PageHandler_GetShareLink_ResponseParamsSpec.$,
        [
          groupId,
          accessToken
        ],
        false);
  }

  getTabGroupPreview(
      groupId: string,
      accessToken: string): Promise<{
        groupPreview: GroupPreview, }> {
    return this.proxy.sendMessage(
        5,
        PageHandler_GetTabGroupPreview_ParamsSpec.$,
        PageHandler_GetTabGroupPreview_ResponseParamsSpec.$,
        [
          groupId,
          accessToken
        ],
        false);
  }

  openTabGroup(
      groupId: string): void {
    this.proxy.sendMessage(
        6,
        PageHandler_OpenTabGroup_ParamsSpec.$,
        null,
        [
          groupId
        ],
        false);
  }

  aboutToUnShareTabGroup(
      tabGroupId: string): void {
    this.proxy.sendMessage(
        7,
        PageHandler_AboutToUnShareTabGroup_ParamsSpec.$,
        null,
        [
          tabGroupId
        ],
        false);
  }

  onTabGroupUnShareComplete(
      tabGroupId: string): void {
    this.proxy.sendMessage(
        8,
        PageHandler_OnTabGroupUnShareComplete_ParamsSpec.$,
        null,
        [
          tabGroupId
        ],
        false);
  }

  onGroupAction(
      action: GroupAction,
      progress: GroupActionProgress): void {
    this.proxy.sendMessage(
        9,
        PageHandler_OnGroupAction_ParamsSpec.$,
        null,
        [
          action,
          progress
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_ShowUI_ParamsSpec.$,
        null,
        impl.showUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_CloseUI_ParamsSpec.$,
        null,
        impl.closeUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_ApiInitComplete_ParamsSpec.$,
        null,
        impl.apiInitComplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_MakeTabGroupShared_ParamsSpec.$,
        PageHandler_MakeTabGroupShared_ResponseParamsSpec.$,
        impl.makeTabGroupShared.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_GetShareLink_ParamsSpec.$,
        PageHandler_GetShareLink_ResponseParamsSpec.$,
        impl.getShareLink.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_GetTabGroupPreview_ParamsSpec.$,
        PageHandler_GetTabGroupPreview_ResponseParamsSpec.$,
        impl.getTabGroupPreview.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_OpenTabGroup_ParamsSpec.$,
        null,
        impl.openTabGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_AboutToUnShareTabGroup_ParamsSpec.$,
        null,
        impl.aboutToUnShareTabGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_OnTabGroupUnShareComplete_ParamsSpec.$,
        null,
        impl.onTabGroupUnShareComplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_OnGroupAction_ParamsSpec.$,
        null,
        impl.onGroupAction.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "data_sharing.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  showUI: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  closeUI: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  apiInitComplete: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  makeTabGroupShared: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getShareLink: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getTabGroupPreview: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openTabGroup: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  aboutToUnShareTabGroup: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onTabGroupUnShareComplete: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onGroupAction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.showUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_ShowUI_ParamsSpec.$,
        null,
        this.showUI.createReceiverHandler(false /* expectsResponse */),
        false);
    this.closeUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_CloseUI_ParamsSpec.$,
        null,
        this.closeUI.createReceiverHandler(false /* expectsResponse */),
        false);
    this.apiInitComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_ApiInitComplete_ParamsSpec.$,
        null,
        this.apiInitComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    this.makeTabGroupShared =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_MakeTabGroupShared_ParamsSpec.$,
        PageHandler_MakeTabGroupShared_ResponseParamsSpec.$,
        this.makeTabGroupShared.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getShareLink =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_GetShareLink_ParamsSpec.$,
        PageHandler_GetShareLink_ResponseParamsSpec.$,
        this.getShareLink.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getTabGroupPreview =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_GetTabGroupPreview_ParamsSpec.$,
        PageHandler_GetTabGroupPreview_ResponseParamsSpec.$,
        this.getTabGroupPreview.createReceiverHandler(true /* expectsResponse */),
        false);
    this.openTabGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_OpenTabGroup_ParamsSpec.$,
        null,
        this.openTabGroup.createReceiverHandler(false /* expectsResponse */),
        false);
    this.aboutToUnShareTabGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_AboutToUnShareTabGroup_ParamsSpec.$,
        null,
        this.aboutToUnShareTabGroup.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onTabGroupUnShareComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_OnTabGroupUnShareComplete_ParamsSpec.$,
        null,
        this.onTabGroupUnShareComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onGroupAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_OnGroupAction_ParamsSpec.$,
        null,
        this.onGroupAction.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'data_sharing.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  onAccessTokenFetched(accessToken: string): void;
  readGroups(readGroupsParams: ReadGroupsParams): Promise<{
        result: ReadGroupsResult, }>;
  readGroupWithToken(param: ReadGroupWithTokenParam): Promise<{
        result: ReadGroupWithTokenResult, }>;
  deleteGroup(groupId: string): Promise<{
        statusCode: number, }>;
  leaveGroup(groupId: string): Promise<{
        statusCode: number, }>;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onAccessTokenFetched(
      accessToken: string): void {
    this.proxy.sendMessage(
        0,
        Page_OnAccessTokenFetched_ParamsSpec.$,
        null,
        [
          accessToken
        ],
        false);
  }

  readGroups(
      readGroupsParams: ReadGroupsParams): Promise<{
        result: ReadGroupsResult, }> {
    return this.proxy.sendMessage(
        1,
        Page_ReadGroups_ParamsSpec.$,
        Page_ReadGroups_ResponseParamsSpec.$,
        [
          readGroupsParams
        ],
        false);
  }

  readGroupWithToken(
      param: ReadGroupWithTokenParam): Promise<{
        result: ReadGroupWithTokenResult, }> {
    return this.proxy.sendMessage(
        2,
        Page_ReadGroupWithToken_ParamsSpec.$,
        Page_ReadGroupWithToken_ResponseParamsSpec.$,
        [
          param
        ],
        false);
  }

  deleteGroup(
      groupId: string): Promise<{
        statusCode: number, }> {
    return this.proxy.sendMessage(
        3,
        Page_DeleteGroup_ParamsSpec.$,
        Page_DeleteGroup_ResponseParamsSpec.$,
        [
          groupId
        ],
        false);
  }

  leaveGroup(
      groupId: string): Promise<{
        statusCode: number, }> {
    return this.proxy.sendMessage(
        4,
        Page_LeaveGroup_ParamsSpec.$,
        Page_LeaveGroup_ResponseParamsSpec.$,
        [
          groupId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_OnAccessTokenFetched_ParamsSpec.$,
        null,
        impl.onAccessTokenFetched.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_ReadGroups_ParamsSpec.$,
        Page_ReadGroups_ResponseParamsSpec.$,
        impl.readGroups.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_ReadGroupWithToken_ParamsSpec.$,
        Page_ReadGroupWithToken_ResponseParamsSpec.$,
        impl.readGroupWithToken.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Page_DeleteGroup_ParamsSpec.$,
        Page_DeleteGroup_ResponseParamsSpec.$,
        impl.deleteGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Page_LeaveGroup_ParamsSpec.$,
        Page_LeaveGroup_ResponseParamsSpec.$,
        impl.leaveGroup.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "data_sharing.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onAccessTokenFetched: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  readGroups: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  readGroupWithToken: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deleteGroup: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  leaveGroup: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onAccessTokenFetched =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_OnAccessTokenFetched_ParamsSpec.$,
        null,
        this.onAccessTokenFetched.createReceiverHandler(false /* expectsResponse */),
        false);
    this.readGroups =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_ReadGroups_ParamsSpec.$,
        Page_ReadGroups_ResponseParamsSpec.$,
        this.readGroups.createReceiverHandler(true /* expectsResponse */),
        false);
    this.readGroupWithToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_ReadGroupWithToken_ParamsSpec.$,
        Page_ReadGroupWithToken_ResponseParamsSpec.$,
        this.readGroupWithToken.createReceiverHandler(true /* expectsResponse */),
        false);
    this.deleteGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Page_DeleteGroup_ParamsSpec.$,
        Page_DeleteGroup_ResponseParamsSpec.$,
        this.deleteGroup.createReceiverHandler(true /* expectsResponse */),
        false);
    this.leaveGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Page_LeaveGroup_ParamsSpec.$,
        Page_LeaveGroup_ResponseParamsSpec.$,
        this.leaveGroup.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ReadGroupsParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ReadGroupParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ReadGroupsResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ReadGroupWithTokenParamSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ReadGroupWithTokenResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SharedTabSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GroupPreviewSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShowUI_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CloseUI_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ApiInitComplete_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_MakeTabGroupShared_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_MakeTabGroupShared_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetShareLink_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetShareLink_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabGroupPreview_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabGroupPreview_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenTabGroup_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_AboutToUnShareTabGroup_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnTabGroupUnShareComplete_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnGroupAction_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnAccessTokenFetched_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ReadGroups_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ReadGroups_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ReadGroupWithToken_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ReadGroupWithToken_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_DeleteGroup_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_DeleteGroup_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_LeaveGroup_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_LeaveGroup_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ReadGroupsParamsMojoType {
  params: ReadGroupParams[];
}


export type ReadGroupsParams = ReadGroupsParamsMojoType;
mojo.internal.Struct<ReadGroupsParamsMojoType>(
    ReadGroupsParamsSpec.$,
    'ReadGroupsParams',
    [
      mojo.internal.StructField<ReadGroupsParamsMojoType, ReadGroupParams[]>(
        'params', 0,
        0,
        mojo.internal.Array(ReadGroupParamsSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ReadGroupParamsMojoType {
  groupId: string;
  consistencyToken: string;
}


export type ReadGroupParams = ReadGroupParamsMojoType;
mojo.internal.Struct<ReadGroupParamsMojoType>(
    ReadGroupParamsSpec.$,
    'ReadGroupParams',
    [
      mojo.internal.StructField<ReadGroupParamsMojoType, string>(
        'groupId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ReadGroupParamsMojoType, string>(
        'consistencyToken', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ReadGroupsResultMojoType {
  groups: dataSharing_mojom_GroupData[];
  statusCode: number;
}


export type ReadGroupsResult = ReadGroupsResultMojoType;
mojo.internal.Struct<ReadGroupsResultMojoType>(
    ReadGroupsResultSpec.$,
    'ReadGroupsResult',
    [
      mojo.internal.StructField<ReadGroupsResultMojoType, dataSharing_mojom_GroupData[]>(
        'groups', 0,
        0,
        mojo.internal.Array(dataSharing_mojom_GroupDataSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ReadGroupsResultMojoType, number>(
        'statusCode', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ReadGroupWithTokenParamMojoType {
  groupId: string;
  accessToken: string;
}


export type ReadGroupWithTokenParam = ReadGroupWithTokenParamMojoType;
mojo.internal.Struct<ReadGroupWithTokenParamMojoType>(
    ReadGroupWithTokenParamSpec.$,
    'ReadGroupWithTokenParam',
    [
      mojo.internal.StructField<ReadGroupWithTokenParamMojoType, string>(
        'groupId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ReadGroupWithTokenParamMojoType, string>(
        'accessToken', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ReadGroupWithTokenResultMojoType {
  group: (dataSharing_mojom_GroupData | null);
  statusCode: number;
}


export type ReadGroupWithTokenResult = ReadGroupWithTokenResultMojoType;
mojo.internal.Struct<ReadGroupWithTokenResultMojoType>(
    ReadGroupWithTokenResultSpec.$,
    'ReadGroupWithTokenResult',
    [
      mojo.internal.StructField<ReadGroupWithTokenResultMojoType, dataSharing_mojom_GroupData>(
        'group', 0,
        0,
        dataSharing_mojom_GroupDataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ReadGroupWithTokenResultMojoType, number>(
        'statusCode', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface SharedTabMojoType {
  displayUrl: string;
  faviconUrl: url_mojom_Url;
}


export type SharedTab = SharedTabMojoType;
mojo.internal.Struct<SharedTabMojoType>(
    SharedTabSpec.$,
    'SharedTab',
    [
      mojo.internal.StructField<SharedTabMojoType, string>(
        'displayUrl', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SharedTabMojoType, url_mojom_Url>(
        'faviconUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface GroupPreviewMojoType {
  title: string;
  sharedTabs: SharedTab[];
  statusCode: mojoBase_mojom_AbslStatusCode;
}


export type GroupPreview = GroupPreviewMojoType;
mojo.internal.Struct<GroupPreviewMojoType>(
    GroupPreviewSpec.$,
    'GroupPreview',
    [
      mojo.internal.StructField<GroupPreviewMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GroupPreviewMojoType, SharedTab[]>(
        'sharedTabs', 8,
        0,
        mojo.internal.Array(SharedTabSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GroupPreviewMojoType, mojoBase_mojom_AbslStatusCode>(
        'statusCode', 16,
        0,
        mojoBase_mojom_AbslStatusCodeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_ShowUI_ParamsMojoType {
}


export type PageHandler_ShowUI_Params = PageHandler_ShowUI_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShowUI_ParamsMojoType>(
    PageHandler_ShowUI_ParamsSpec.$,
    'PageHandler_ShowUI_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_CloseUI_ParamsMojoType {
  statusCode: number;
}


export type PageHandler_CloseUI_Params = PageHandler_CloseUI_ParamsMojoType;
mojo.internal.Struct<PageHandler_CloseUI_ParamsMojoType>(
    PageHandler_CloseUI_ParamsSpec.$,
    'PageHandler_CloseUI_Params',
    [
      mojo.internal.StructField<PageHandler_CloseUI_ParamsMojoType, number>(
        'statusCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ApiInitComplete_ParamsMojoType {
}


export type PageHandler_ApiInitComplete_Params = PageHandler_ApiInitComplete_ParamsMojoType;
mojo.internal.Struct<PageHandler_ApiInitComplete_ParamsMojoType>(
    PageHandler_ApiInitComplete_ParamsSpec.$,
    'PageHandler_ApiInitComplete_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_MakeTabGroupShared_ParamsMojoType {
  tabGroupId: string;
  groupId: string;
  accessToken: string;
}


export type PageHandler_MakeTabGroupShared_Params = PageHandler_MakeTabGroupShared_ParamsMojoType;
mojo.internal.Struct<PageHandler_MakeTabGroupShared_ParamsMojoType>(
    PageHandler_MakeTabGroupShared_ParamsSpec.$,
    'PageHandler_MakeTabGroupShared_Params',
    [
      mojo.internal.StructField<PageHandler_MakeTabGroupShared_ParamsMojoType, string>(
        'tabGroupId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_MakeTabGroupShared_ParamsMojoType, string>(
        'groupId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_MakeTabGroupShared_ParamsMojoType, string>(
        'accessToken', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_MakeTabGroupShared_ResponseParamsMojoType {
  url: (url_mojom_Url | null);
}


export type PageHandler_MakeTabGroupShared_ResponseParams = PageHandler_MakeTabGroupShared_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_MakeTabGroupShared_ResponseParamsMojoType>(
    PageHandler_MakeTabGroupShared_ResponseParamsSpec.$,
    'PageHandler_MakeTabGroupShared_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_MakeTabGroupShared_ResponseParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetShareLink_ParamsMojoType {
  groupId: string;
  accessToken: string;
}


export type PageHandler_GetShareLink_Params = PageHandler_GetShareLink_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetShareLink_ParamsMojoType>(
    PageHandler_GetShareLink_ParamsSpec.$,
    'PageHandler_GetShareLink_Params',
    [
      mojo.internal.StructField<PageHandler_GetShareLink_ParamsMojoType, string>(
        'groupId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_GetShareLink_ParamsMojoType, string>(
        'accessToken', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetShareLink_ResponseParamsMojoType {
  url: url_mojom_Url;
}


export type PageHandler_GetShareLink_ResponseParams = PageHandler_GetShareLink_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetShareLink_ResponseParamsMojoType>(
    PageHandler_GetShareLink_ResponseParamsSpec.$,
    'PageHandler_GetShareLink_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetShareLink_ResponseParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetTabGroupPreview_ParamsMojoType {
  groupId: string;
  accessToken: string;
}


export type PageHandler_GetTabGroupPreview_Params = PageHandler_GetTabGroupPreview_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabGroupPreview_ParamsMojoType>(
    PageHandler_GetTabGroupPreview_ParamsSpec.$,
    'PageHandler_GetTabGroupPreview_Params',
    [
      mojo.internal.StructField<PageHandler_GetTabGroupPreview_ParamsMojoType, string>(
        'groupId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_GetTabGroupPreview_ParamsMojoType, string>(
        'accessToken', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetTabGroupPreview_ResponseParamsMojoType {
  groupPreview: GroupPreview;
}


export type PageHandler_GetTabGroupPreview_ResponseParams = PageHandler_GetTabGroupPreview_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabGroupPreview_ResponseParamsMojoType>(
    PageHandler_GetTabGroupPreview_ResponseParamsSpec.$,
    'PageHandler_GetTabGroupPreview_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetTabGroupPreview_ResponseParamsMojoType, GroupPreview>(
        'groupPreview', 0,
        0,
        GroupPreviewSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OpenTabGroup_ParamsMojoType {
  groupId: string;
}


export type PageHandler_OpenTabGroup_Params = PageHandler_OpenTabGroup_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenTabGroup_ParamsMojoType>(
    PageHandler_OpenTabGroup_ParamsSpec.$,
    'PageHandler_OpenTabGroup_Params',
    [
      mojo.internal.StructField<PageHandler_OpenTabGroup_ParamsMojoType, string>(
        'groupId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_AboutToUnShareTabGroup_ParamsMojoType {
  tabGroupId: string;
}


export type PageHandler_AboutToUnShareTabGroup_Params = PageHandler_AboutToUnShareTabGroup_ParamsMojoType;
mojo.internal.Struct<PageHandler_AboutToUnShareTabGroup_ParamsMojoType>(
    PageHandler_AboutToUnShareTabGroup_ParamsSpec.$,
    'PageHandler_AboutToUnShareTabGroup_Params',
    [
      mojo.internal.StructField<PageHandler_AboutToUnShareTabGroup_ParamsMojoType, string>(
        'tabGroupId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OnTabGroupUnShareComplete_ParamsMojoType {
  tabGroupId: string;
}


export type PageHandler_OnTabGroupUnShareComplete_Params = PageHandler_OnTabGroupUnShareComplete_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnTabGroupUnShareComplete_ParamsMojoType>(
    PageHandler_OnTabGroupUnShareComplete_ParamsSpec.$,
    'PageHandler_OnTabGroupUnShareComplete_Params',
    [
      mojo.internal.StructField<PageHandler_OnTabGroupUnShareComplete_ParamsMojoType, string>(
        'tabGroupId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OnGroupAction_ParamsMojoType {
  action: GroupAction;
  progress: GroupActionProgress;
}


export type PageHandler_OnGroupAction_Params = PageHandler_OnGroupAction_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnGroupAction_ParamsMojoType>(
    PageHandler_OnGroupAction_ParamsSpec.$,
    'PageHandler_OnGroupAction_Params',
    [
      mojo.internal.StructField<PageHandler_OnGroupAction_ParamsMojoType, GroupAction>(
        'action', 0,
        0,
        GroupActionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OnGroupAction_ParamsMojoType, GroupActionProgress>(
        'progress', 4,
        0,
        GroupActionProgressSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnAccessTokenFetched_ParamsMojoType {
  accessToken: string;
}


export type Page_OnAccessTokenFetched_Params = Page_OnAccessTokenFetched_ParamsMojoType;
mojo.internal.Struct<Page_OnAccessTokenFetched_ParamsMojoType>(
    Page_OnAccessTokenFetched_ParamsSpec.$,
    'Page_OnAccessTokenFetched_Params',
    [
      mojo.internal.StructField<Page_OnAccessTokenFetched_ParamsMojoType, string>(
        'accessToken', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_ReadGroups_ParamsMojoType {
  readGroupsParams: ReadGroupsParams;
}


export type Page_ReadGroups_Params = Page_ReadGroups_ParamsMojoType;
mojo.internal.Struct<Page_ReadGroups_ParamsMojoType>(
    Page_ReadGroups_ParamsSpec.$,
    'Page_ReadGroups_Params',
    [
      mojo.internal.StructField<Page_ReadGroups_ParamsMojoType, ReadGroupsParams>(
        'readGroupsParams', 0,
        0,
        ReadGroupsParamsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_ReadGroups_ResponseParamsMojoType {
  result: ReadGroupsResult;
}


export type Page_ReadGroups_ResponseParams = Page_ReadGroups_ResponseParamsMojoType;
mojo.internal.Struct<Page_ReadGroups_ResponseParamsMojoType>(
    Page_ReadGroups_ResponseParamsSpec.$,
    'Page_ReadGroups_ResponseParams',
    [
      mojo.internal.StructField<Page_ReadGroups_ResponseParamsMojoType, ReadGroupsResult>(
        'result', 0,
        0,
        ReadGroupsResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_ReadGroupWithToken_ParamsMojoType {
  param: ReadGroupWithTokenParam;
}


export type Page_ReadGroupWithToken_Params = Page_ReadGroupWithToken_ParamsMojoType;
mojo.internal.Struct<Page_ReadGroupWithToken_ParamsMojoType>(
    Page_ReadGroupWithToken_ParamsSpec.$,
    'Page_ReadGroupWithToken_Params',
    [
      mojo.internal.StructField<Page_ReadGroupWithToken_ParamsMojoType, ReadGroupWithTokenParam>(
        'param', 0,
        0,
        ReadGroupWithTokenParamSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_ReadGroupWithToken_ResponseParamsMojoType {
  result: ReadGroupWithTokenResult;
}


export type Page_ReadGroupWithToken_ResponseParams = Page_ReadGroupWithToken_ResponseParamsMojoType;
mojo.internal.Struct<Page_ReadGroupWithToken_ResponseParamsMojoType>(
    Page_ReadGroupWithToken_ResponseParamsSpec.$,
    'Page_ReadGroupWithToken_ResponseParams',
    [
      mojo.internal.StructField<Page_ReadGroupWithToken_ResponseParamsMojoType, ReadGroupWithTokenResult>(
        'result', 0,
        0,
        ReadGroupWithTokenResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_DeleteGroup_ParamsMojoType {
  groupId: string;
}


export type Page_DeleteGroup_Params = Page_DeleteGroup_ParamsMojoType;
mojo.internal.Struct<Page_DeleteGroup_ParamsMojoType>(
    Page_DeleteGroup_ParamsSpec.$,
    'Page_DeleteGroup_Params',
    [
      mojo.internal.StructField<Page_DeleteGroup_ParamsMojoType, string>(
        'groupId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_DeleteGroup_ResponseParamsMojoType {
  statusCode: number;
}


export type Page_DeleteGroup_ResponseParams = Page_DeleteGroup_ResponseParamsMojoType;
mojo.internal.Struct<Page_DeleteGroup_ResponseParamsMojoType>(
    Page_DeleteGroup_ResponseParamsSpec.$,
    'Page_DeleteGroup_ResponseParams',
    [
      mojo.internal.StructField<Page_DeleteGroup_ResponseParamsMojoType, number>(
        'statusCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_LeaveGroup_ParamsMojoType {
  groupId: string;
}


export type Page_LeaveGroup_Params = Page_LeaveGroup_ParamsMojoType;
mojo.internal.Struct<Page_LeaveGroup_ParamsMojoType>(
    Page_LeaveGroup_ParamsSpec.$,
    'Page_LeaveGroup_Params',
    [
      mojo.internal.StructField<Page_LeaveGroup_ParamsMojoType, string>(
        'groupId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_LeaveGroup_ResponseParamsMojoType {
  statusCode: number;
}


export type Page_LeaveGroup_ResponseParams = Page_LeaveGroup_ResponseParamsMojoType;
mojo.internal.Struct<Page_LeaveGroup_ResponseParamsMojoType>(
    Page_LeaveGroup_ResponseParamsSpec.$,
    'Page_LeaveGroup_ResponseParams',
    [
      mojo.internal.StructField<Page_LeaveGroup_ResponseParamsMojoType, number>(
        'statusCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



