// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import './icons.html.js';
import '//resources/cr_elements/cr_icon/cr_icon.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import '//resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import '//resources/cr_elements/icons.html.js';
import './favicon_group.js';
import './sources_menu.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { BrowserProxyImpl } from './contextual_tasks_browser_proxy.js';
import { getCss } from './top_toolbar.css.js';
import { getHtml } from './top_toolbar.html.js';
export class TopToolbarElement extends CrLitElement {
    static get is() {
        return 'top-toolbar';
    }
    static get styles() {
        return getCss();
    }
    static get properties() {
        return {
            attachedTabs: { type: Array },
            darkMode: {
                type: Boolean,
                reflect: true,
                attribute: 'dark-mode',
            },
            isAiPage: {
                type: Boolean,
                reflect: true,
                attribute: 'is-ai-page',
            },
            logoImageUrl_: { type: String },
            title: { type: String },
        };
    }
    #title_accessor_storage = '';
    get title() { return this.#title_accessor_storage; }
    set title(value) { this.#title_accessor_storage = value; }
    #attachedTabs_accessor_storage = [];
    get attachedTabs() { return this.#attachedTabs_accessor_storage; }
    set attachedTabs(value) { this.#attachedTabs_accessor_storage = value; }
    #darkMode_accessor_storage = false;
    get darkMode() { return this.#darkMode_accessor_storage; }
    set darkMode(value) { this.#darkMode_accessor_storage = value; }
    #isAiPage_accessor_storage = false;
    get isAiPage() { return this.#isAiPage_accessor_storage; }
    set isAiPage(value) { this.#isAiPage_accessor_storage = value; }
    browserProxy_ = BrowserProxyImpl.getInstance();
    render() {
        return getHtml.bind(this)();
    }
    onCloseButtonClick_() {
        chrome.metricsPrivate.recordUserAction('ContextualTasks.WebUI.UserAction.CloseSidePanel');
        chrome.metricsPrivate.recordBoolean('ContextualTasks.WebUI.UserAction.CloseSidePanel', true);
        this.browserProxy_.handler.closeSidePanel();
    }
    onNewThreadClick_() {
        this.fire('new-thread-click');
    }
    onThreadHistoryClick_() {
        chrome.metricsPrivate.recordUserAction('ContextualTasks.WebUI.UserAction.OpenThreadHistory');
        chrome.metricsPrivate.recordBoolean('ContextualTasks.WebUI.UserAction.OpenThreadHistory', true);
        this.browserProxy_.handler.showThreadHistory();
    }
    onMoreClick_(e) {
        this.$.menu.get().showAt(e.target);
    }
    onSourcesClick_(e) {
        this.$.sourcesMenu.get().showAt(e.target);
    }
    onOpenInNewTabClick_() {
        this.$.menu.get().close();
        chrome.metricsPrivate.recordUserAction('ContextualTasks.WebUI.UserAction.OpenInNewTab');
        chrome.metricsPrivate.recordBoolean('ContextualTasks.WebUI.UserAction.OpenInNewTab', true);
        this.browserProxy_.handler.moveTaskUiToNewTab();
    }
    onMyActivityClick_() {
        this.$.menu.get().close();
        chrome.metricsPrivate.recordUserAction('ContextualTasks.WebUI.UserAction.OpenMyActivity');
        chrome.metricsPrivate.recordBoolean('ContextualTasks.WebUI.UserAction.OpenMyActivity', true);
        this.browserProxy_.handler.openMyActivityUi();
    }
    onHelpClick_() {
        this.$.menu.get().close();
        chrome.metricsPrivate.recordUserAction('ContextualTasks.WebUI.UserAction.OpenHelp');
        chrome.metricsPrivate.recordBoolean('ContextualTasks.WebUI.UserAction.OpenHelp', true);
        this.browserProxy_.handler.openHelpUi();
    }
}
customElements.define(TopToolbarElement.is, TopToolbarElement);
