import './icons.html.js';
import '//resources/cr_elements/cr_icon/cr_icon.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import '//resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import '//resources/cr_elements/icons.html.js';
import './favicon_group.js';
import './sources_menu.js';
import type { CrActionMenuElement } from 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrLazyRenderLitElement } from 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { Tab } from './contextual_tasks.mojom-webui.js';
import type { SourcesMenuElement } from './sources_menu.js';
export interface TopToolbarElement {
    $: {
        menu: CrLazyRenderLitElement<CrActionMenuElement>;
        sourcesMenu: CrLazyRenderLitElement<SourcesMenuElement>;
        topToolbarLogo: HTMLImageElement;
    };
}
export declare class TopToolbarElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    static get properties(): {
        attachedTabs: {
            type: ArrayConstructor;
        };
        darkMode: {
            type: BooleanConstructor;
            reflect: boolean;
            attribute: string;
        };
        isAiPage: {
            type: BooleanConstructor;
            reflect: boolean;
            attribute: string;
        };
        logoImageUrl_: {
            type: StringConstructor;
        };
        title: {
            type: StringConstructor;
        };
    };
    accessor title: string;
    accessor attachedTabs: Tab[];
    accessor darkMode: boolean;
    accessor isAiPage: boolean;
    private browserProxy_;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    protected onCloseButtonClick_(): void;
    protected onNewThreadClick_(): void;
    protected onThreadHistoryClick_(): void;
    protected onMoreClick_(e: Event): void;
    protected onSourcesClick_(e: Event): void;
    protected onOpenInNewTabClick_(): void;
    protected onMyActivityClick_(): void;
    protected onHelpClick_(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'top-toolbar': TopToolbarElement;
    }
}
